import os
from subprocess import call
import urllib


from .helper import (get_dotfiles_url, modify_file)


githook_url = get_dotfiles_url() + 'git/templates/hooks/'
def git_init_and_hook(directory):
    call(['git', 'init'], cwd=directory)

    git_hooks = os.path.join(directory, '.git', 'hooks')
    for hook in ('post-commit', 'pre-commit', 'pre-push'):
        urllib.urlretrieve(
            githook_url + hook,
            os.path.join(git_hooks, hook)
        )


def git_finalize(directory, repo):
    call(['git', 'add', '.'], cwd=directory)

    call(
        ['git', 'commit', '-m', 'Auto-generated AlmostEmpty project', '-n'],
        cwd=directory
    )

    call(['git', 'remote', 'add', 'origin', repo], cwd=directory)
    call(['git', 'push', '-u', '--force', 'origin', 'master'], cwd=directory)


def init_readme(directory):
    modify_file(
        'README.md',
        directory,
        [
            (
                'Empty project auto-generated by [AlmostEmpty]'
                '(https://github.com/TheKevJames/almost-empty)'
            ),
            ''
        ]
    )


def meta(project, directory):
    """Set up standard metadata, e.g. README, TODO..."""
    for filename in ('AUTHORS', 'CHANGES', 'CONTRIBUTING'):
        modify_file(filename, directory, [filename, '='*len(filename), ''])

    modify_file('LICENSE', directory)
    modify_file('README.md', directory, [project, '='*len(project), ''])
    modify_file('TODO.md', directory, ['TODO', '====', ''])
