"""Run workflow for TeX-based projects"""
from .all import (git_init_and_hook, git_finalize, init_readme, meta)
from .helper import (get_readable_name, modify_file, store_gitignore)


def git(directory, repo):
    """Set up git repo, if provided

    Provide useful git hooks"""
    if repo:
        git_init_and_hook(directory)

        git_finalize(directory, repo)


####################
# Workflow Runners #
####################
def pure(name, directory, repo):
    """Run workflow for a TeX project"""
    readable_name = get_readable_name(name)

    modify_file(
        name + '.tex',
        directory,
        [
            '\\documentclass[a4paper,11pt]{article}',
            '\\usepackage[T1]{fontenc}',
            '\\usepackage[utf8]{inputenc}',
            '\\usepackage{lmodern}',
            '',
            '\\title{' + readable_name + '}',
            '\\author{@TheKevJames (auto-generated)}',
            '',
            '\\begin{document}',
            '',
            '\\maketitle',
            '\\tableofcontents',
            '',
            '\\begin{abstract}',
            '\\end{abstract}',
            '',
            '\\section{}',
            '',
            '\\end{document}'
        ]
    )
    modify_file(
        'Makefile',
        directory,
        [
            'all:',
            '\tlatexmk *.tex && latexmk -c',
            '',
            'clean:',
            '\tlatexmk -CA'
        ]
    )

    meta(readable_name, directory)
    init_readme(directory)

    store_gitignore('TeX', directory)

    git(directory, repo)
