import os
import tempfile
import unittest

from almost_empty.all import (
    init_readme,
    meta
)


class TestAll(unittest.TestCase):
    def test_init_readme(self):
        temp_dir = tempfile.gettempdir()
        init_readme(temp_dir)

        self.assertTrue(os.path.isfile(os.path.join(temp_dir, 'README.md')))

    def test_meta(self):
        temp_dir = tempfile.gettempdir()
        project_name = 'test'
        meta(project_name, temp_dir)

        for filename in (
                'AUTHORS',
                'CHANGES',
                'CONTRIBUTING',
                'LICENSE',
                'README.md',
                'TODO.md'
        ):
            self.assertTrue(os.path.isfile(os.path.join(temp_dir, filename)))


if __name__ == '__main':
    unittest.main()
