import hashlib
import time
import os
from re import sub
import urllib

import random
try:
    random = random.SystemRandom()
    sysrandom = True
except NotImplementedError:
    sysrandom = False


def get_dotfiles_url():
    return 'https://raw.githubusercontent.com/TheKevJames/dotfiles/master/'


chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'
def get_random_string(length=12, allowed_chars=chars):
    """This is the same function used to generate Django's SECRET_KEYs"""
    if not sysrandom:
        random.seed(hashlib.sha256(("%s%s%s" % (
            random.getstate(),
            time.time(),
            ''
        )).encode('utf-8')).digest())
    return ''.join([random.choice(allowed_chars) for _ in range(length)])


def get_readable_name(project_name):
    readable = sub(r"[-_](\w)", r"\1", project_name.title())
    return sub(r"[^\w]", "", readable)


def modify_file(name, directory, contents=None):
    if not contents:
        contents = []

    filename = os.path.join(directory, name)
    with open(filename, 'a') as txt:
        for line in contents:
            txt.write(line)
            txt.write('\n')


gitignore_url = 'https://raw.githubusercontent.com/github/gitignore/master/'
def store_gitignore(lang, directory):
    urllib.urlretrieve(
        gitignore_url + lang + '.gitignore',
        os.path.join(directory, '.gitignore')
    )
