try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

import alpha

setup(
    name='alpha',
    version=alpha.__version__,
    description='System administration utils',
    author='Andrey Gubarev',
    author_email='andrey@base.so',
    scripts=['scripts/alpha'],
    packages=[
        'alpha',
        'alpha.platform'
    ],
    package_dir={
        'alpha': 'alpha',
        'alpha.platform': 'alpha/platform'
    },
    data_files=[
        ('/opt/alpha/', [
            'recipes/git.py'
        ]),
        ('/opt/alpha/profile', [
            'recipes/profile/__init__.py',
        ]),
        ('/opt/alpha/profile/template', [
            'recipes/profile/template/bash_profile',
        ]),
        ('/opt/alpha/redis', [
            'recipes/redis/__init__.py',
        ]),
        ('/opt/alpha/redis/template', [
            'recipes/redis/template/redis_cli_script',
            'recipes/redis/template/redis_conf',
            'recipes/redis/template/redis_init_script'
        ])
    ]
)
