import os
import imp
from collections import namedtuple

class Recipes(object):
    PATH = [
        '/opt/alpharecipes',
    ]

    Recipe = namedtuple('Recipe', ['name', 'path', 'type'])

    def __init__(self):
        self.__recipes = self.__scan(self.PATH)

    def __scan(self, paths):
        resipes = {}
        for directory in paths:
            dirbased_modules = []
            for path, dirs, files in os.walk(directory):
                if '__init__.py' in files:
                    if any([dirbased_module in path for dirbased_module in dirbased_modules]):
                        continue
                    dirbased_modules.append(path)
                    name = os.path.basename(path)
                    resipes[name] = self.Recipe(name=name, path=os.path.abspath(os.path.join(path, '..')), type='module')
                    continue
                for fname in files:
                    if fname.endswith('.py'):
                        name = fname[:-3]
                        resipes[name] = self.Recipe(name=name, path=os.path.join(path, fname), type='file')
        return resipes

    def get(self, name, default=None):
        try:
            return self.__getitem__(name)
        except KeyError:
            return default

    def all(self):
        return [(recipe, self[recipe].__doc__) for recipe in self.__recipes]

    def __getitem__(self, name):
        recipe = self.__recipes[name]
        if recipe.type == 'file':
            return imp.load_source(recipe.name, recipe.path)

        elif recipe.type == 'module':
            module = imp.find_module(recipe.name, [recipe.path])
            return imp.load_module(recipe.name, *module)

    def __repr__(self):
        return '<Recipes: {}... object at {}>'.format(','.join(self.__recipes)[:10], hex(id(self))[:-1])
