'''
    aml.path.parser
    ~~~~~~~~~~~~~~~

    :copyright: 2009 by Bjoern Schulz <bjoern.schulz.92@gmail.com>
    :license: MIT, see LICENSE for more details
'''

from aml.path.path import Path, Root, Any, Parent, Self

class Parser(object):
    
    def __init__(self, scanner):
        self.scanner = scanner
        self.advance()
    
    def advance(self):
        self.t, self.v = self.scanner.next()
    
    def expect(self, t):
        if self.t != t:
            raise SyntaxError, '%s expected' % t
        v = self.v
        self.advance()
        return v
    
    def parse_attributes(self):
        attributes = {}
        if self.t == '[':
            self.advance()
            while self.t != ']':
                key = self.expect('name')
                self.expect('=')
                attributes[key] = self.expect('value')
                if self.t != ']':
                    self.expect(';')
            self.expect(']')
        return attributes
    
    def parse_path(self, name):
        path = Path(name, self.parse_attributes())
        if self.t == '/':
            self.advance()
            if self.t:
                path.child = self.parse_path(self.expect('name'))
        return path
    
    def parse(self):
        if self.t == '/' or (self.t == 'name' and self.v in '..'):
            t = self.t
            v = self.v
            self.advance()
            if t == '/':
                if self.t == '/':
                    self.advance()
                    path = Any(self.expect('name'), self.parse_attributes())
                else:
                    path = Root(self.expect('name'), self.parse_attributes())
            elif v == '.':
                path = Self()
            elif v == '..':
                path = Parent()
            if self.t == '/':
                self.advance()
                if self.t:
                    path.child = self.parse_path(self.expect('name'))
            return path
        else:
            return self.parse_path(self.expect('name'))