'''
    aml
    ~~~
    
    AML Markup Library provides a simple to use parser for working 
    with the AML Markup Language.

    :copyright: 2009 by Bjoern Schulz <bjoern.schulz.92@gmail.com>
    :license: MIT, see LICENSE for more details
'''

from __future__ import with_statement
from aml.node import Node
from aml.scanner import Scanner
from aml.parser import Parser

def parse_string(src):
    return Parser(Scanner(src)).parse()

def parse_file(name):
    src = ''
    with open(name) as f:
        for line in f:
            src += line
    return parse_string(src)