'''
    aml.pretty
    ~~~~~~~~~~

    :copyright: 2009 by Bjoern Schulz <bjoern.schulz.92@gmail.com>
    :license: MIT, see LICENSE for more details
'''

def pretty(node, indent=4, i=0):
    return '%s(%s%s%s%s%s)' % (
        ' ' * indent * i,
        node.name,
        '\n' if node.attributes else '',
        '\n'.join('%s(%s %r)' % (' ' * indent * (i + 1), a[0], a[1])
                  for a in node.iter_attrs()),
        '\n' if node.children else '',
        '\n'.join(pretty(n, indent, i+1) for n in node)
    )

def pprint(node, indent=4):
    print pretty(node, indent)