'''
    aml.scanner
    ~~~~~~~~~~~

    :copyright: 2009 by Bjoern Schulz <bjoern.schulz.92@gmail.com>
    :license: MIT, see LICENSE for more details
'''

import re

def Scanner(src):
    for m in re.finditer((r'([-+]?(\d+(\.\d*)?|\.\d+)([eE][-+]?\d+)?)'
                          r'|(\w+)|"([^"]*)"'
                          r"|'([^']*)'|([()])|;.*?\n|\s+"),
                         src, re.UNICODE):
        if m.lastindex:
            t = m.group(m.lastindex)
            if m.lastindex == 1:
                if any(c in t for c in '.eE'):
                    yield 'value', float(t)
                else:
                    yield 'value', int(t)
            elif m.lastindex == 5:
                yield 'name', t
            elif m.lastindex in (6, 7):
                yield 'value', t
            elif m.lastindex == 8:
                yield t, t
    yield None, None