'''
    aml.path.path
    ~~~~~~~~~~~~~

    :copyright: 2009 by Bjoern Schulz <bjoern.schulz.92@gmail.com>
    :license: MIT, see LICENSE for more details
'''

class Path(object):
    
    def __init__(self, name, attributes=None, index=None, child=None):
        self.name = name
        self.attributes = attributes or {}
        self.index = index
        self.child = child
    
    def __repr__(self):
        return '%s(%r, %r, %r)' % (
            self.__class__.__name__,
            self.name,
            self.attributes,
            self.child
        )
    
    def match(self, node):
        return (
            (node.name == self.name or self.name == '*') and
            all(node[k] == self.attributes[k] for k in self.attributes) and
            (node.parent.children.index(node) == self.index
             if self.index is not None else True)
        )
    
    def findall(self, node):
        if self.match(node):
            if self.child is None:
                yield node
            elif isinstance(self.child, Attribute):
                for attr in self.child.findall(node):
                    yield attr
            else:
                for child in node:
                    for n in self.child.findall(child):
                        yield n

class Root(Path):
    
    def root(self, node):
        while node.parent is not None:
            node = node.parent
        return node
    
    def findall(self, node):
        node = self.root(node)
        if self.match(node):
            if self.child is None:
                yield node
            elif isinstance(self.child, Attribute):
                for attr in self.child.findall(node):
                    yield attr
            else:
                for child in node:
                    for n in self.child.findall(child):
                        yield n

class Any(Path):
    
    def flatten(self, node):
        yield node
        for n in node:
            for r in self.flatten(n):
                yield r
    
    def findall(self, node):
        for n in self.flatten(node):
            if self.match(n):
                if self.child is None:
                    yield n
                elif isinstance(self.child, Attribute):
                    for attr in self.child.findall(n):
                        yield attr
                else:
                    for r in self.child.findall(n):
                        yield r

class Self(object):
    
    def __init__(self, child=None):
        self.child = child
    
    def __repr__(self):
        return 'Self(%r)' % (
            self.child
        )
    
    def findall(self, node):
        if self.child is None:
            yield node
        elif isinstance(self.child, Attribute):
            for attr in self.child.findall(node):
                yield attr
        else:
            for child in node:
                for n in self.child.findall(child):
                    yield n

class Parent(object):
    
    def __init__(self, child=None):
        self.child = child
    
    def __repr__(self):
        return 'Parent(%r)' % (
            self.child
        )
    
    def findall(self, node):
        if self.child is None:
            if node.parent is None:
                yield node
            else:
                yield node.parent
        elif isinstance(self.child, Attribute):
            if node.parent is not None:
                node = node.parent
            for attr in self.child.findall(node.parent):
                yield attr
        else:
            if node.parent is not None:
                node = node.parent
            for child in node:
                for n in self.child.findall(child):
                    yield n

class Attribute(object):
    
    def __init__(self, name):
        self.name = name
    
    def __repr__(self):
        return 'Attribute(%r)' % (self.name)
    
    def findall(self, node):
        yield node[self.name]