'''
    aml.scanner
    ~~~~~~~~~~~

    :copyright: 2009 by Bjoern Schulz <bjoern.schulz.92@gmail.com>
    :license: MIT, see LICENSE for more details
'''

import re

def Scanner(src):
    for m in re.finditer((r'([-+]?(?:\d+(?:\.\d*)?|\.\d+)(?:[eE][-+]?\d+)?)'
                          r'|(\w+)|#(t|f|n)'
                          r'|"""(.*?)"""|"([^"\\]*(?:\\.[^"\\]*)*)"'
                          r"|'''(.*?)'''|'([^'\\]*(?:\\.[^'\\]*)*)'"
                          r'|([()])|;.*?(\n|$)|(\n|$)|\s'),
                         src, re.UNICODE | re.DOTALL | re.MULTILINE):
        if m.lastindex:
            t = m.group(m.lastindex)
            if m.lastindex == 1:
                if any(c in t for c in '.eE'):
                    yield 'value', float(t)
                else:
                    yield 'value', int(t)
            elif m.lastindex == 2:
                yield 'name', t
            elif m.lastindex == 3:
                if t == 't':
                    yield 'value', True
                elif t == 'f':
                    yield 'value', False
                else:
                    yield 'value', None
            elif m.lastindex in (5, 7):
                yield 'value', t.decode('string-escape').decode('utf-8')
            elif m.lastindex in (4, 6):
                yield 'value', t.decode('utf-8')
            else:
                if t:
                    yield t, t
    yield None, None