'''
    aml.parser
    ~~~~~~~~~~

    :copyright: 2009 by Bjoern Schulz <bjoern.schulz.92@gmail.com>
    :license: MIT, see LICENSE for more details
'''

from aml.node import Node

class Parser(object):
    
    def __init__(self, scanner, node_type=None):
        self.scanner = scanner
        self.node_type = node_type or Node
        self.lineno = 1
        self.advance()
    
    def advance(self):
        self.t, self.v = self.scanner.next()
        if self.t == '\n':
            self.lineno += 1
            self.advance()
    
    def expect(self, t):
        if self.t != t:
            raise SyntaxError, '%s expected, got %s (line %d)' % (
                t, self.t, self.lineno
            )
        v = self.v
        self.advance()
        return v
    
    def node(self, name):
        node = self.node_type(name)
        while self.t == '(':
            self.advance()
            name = self.expect('name')
            if self.t == 'value':
                node[name] = self.expect('value')
                self.expect(')')
            elif self.t == '(':
                node.append(self.node(name))
            elif self.t == ')':
                node.append(self.node_type(name))
                self.advance()
        self.expect(')')
        return node
    
    def parse(self):
        self.expect('(')
        return self.node(self.expect('name'))