'''
    aml.path.parser
    ~~~~~~~~~~~~~~~

    :copyright: 2009 by Bjoern Schulz <bjoern.schulz.92@gmail.com>
    :license: MIT, see LICENSE for more details
'''

from aml.path.path import Path, Root, Any, Parent, Self, Attribute

class Parser(object):
    
    def __init__(self, scanner):
        self.scanner = scanner
        self.advance()
    
    def advance(self):
        self.t, self.v = self.scanner.next()
    
    def expect(self, t):
        if self.t != t:
            raise SyntaxError, '%s expected' % t
        v = self.v
        self.advance()
        return v

    def parse_parentheses(self):
        attributes = {}
        index = None
        if self.t == '[':
            self.advance()
            if self.t == 'value':
                index = self.expect('value')
                self.expect(']')
            else:
                while self.t != ']':
                    name = self.expect('name')
                    self.expect('=')
                    attributes[name] = self.expect('value')
                    if self.t != ']':
                        self.expect(';')
                self.expect(']')
                if self.t == '[':
                    self.advance()
                    index = self.expect('value')
                    self.expect(']')
        return attributes, index
    
    def parse_path(self, name):
        path = Path(name, *self.parse_parentheses())
        if self.t == '/':
            self.advance()
            if self.t == '@':
                self.advance()
                path.child = Attribute(self.expect('name'))
            elif self.t is not None:
                path.child = self.parse_path(self.expect('name'))
        elif self.t == '@':
            self.advance()
            path.child = Attribute(self.expect('name'))
        return path
    
    def parse(self):
        if self.t == '/' or self.t in '..':
            t = self.t
            v = self.v
            self.advance()
            if t == '/':
                if self.t == '/':
                    self.advance()
                    path = Any(self.expect('name'))
                else:
                    path = Root(self.expect('name'))
                attributes, index = self.parse_parentheses()
                path.attributes = attributes
            elif t == '.':
                path = Self()
            elif t == '..':
                path = Parent()
            if self.t == '/':
                self.advance()
                if self.t == '@':
                    self.advance()
                    path.child = Attribute(self.expect('name'))
                elif self.t is not None:
                    path.child = self.parse_path(self.expect('name'))
            elif self.t == '@':
                self.advance()
                path.child = Attribute(self.expect('name'))
            return path
        elif self.t == '@':
            self.advance()
            return Attribute(self.expect('name'))
        else:
            return self.parse_path(self.expect('name'))