'''
    aml.pretty
    ~~~~~~~~~~

    :copyright: 2009 by Bjoern Schulz <bjoern.schulz.92@gmail.com>
    :license: MIT, see LICENSE for more details
'''

import string
from types import NoneType

def pretty(node, indent=4, depth=0):
    def escape(s):
        for c in string.whitespace:
            s = s.replace(c, c.encode('string-escape'))
        return s.replace('"', '\\"')
    types = {
        NoneType: lambda v: '#n',
        bool: lambda v: '#t' if v else '#f',
        str: lambda v: '"%s"' % escape(v),
        unicode: lambda v: '"%s"' % escape(v).encode('utf-8'),
        int: lambda v: v,
        float: lambda v: v,
    }
    return '%s(%s%s%s%s%s)' % (
        ' ' * indent * depth,
        node.name,
        '\n' if node.attributes else '',
        '\n'.join(
            '%s(%s %s)' % (
                ' ' * indent * (depth + 1), name, types[type(value)](value)
            ) for name, value in node.iter_attrs()
        ),
        '\n' if node.children else '',
        '\n'.join(pretty(n, indent, depth + 1) for n in node)
    )

def pprint(node, indent=4):
    print pretty(node, indent)