#-------------------------------------------------------------------------------------------------#
#                                                                                                 #
#-------------------------------------------------------------------------------------------------#

import os, sys
from setuptools import setup, find_packages
from codecs     import open as fopen
from os.path    import abspath, dirname, join

py_hexver = getattr(sys, "hexversion", 0)
is_pypy   = hasattr(sys, "pypy_version_info")
is_jython = sys.platform.startswith("java")
here_path = abspath(dirname(__file__))

if py_hexver < 0x02060000:
    raise AssertionError("Python 2.6 or newer is required")

exec(open(join(here_path,"annotate","version.py")).read(), None)

setup(
    name             = __project__,
    version          = __version__,
    description      = "Decorator to set a function's __annotations__ like Py3.",
    url              = __url__,
    download_url     = __url__,
    platforms        = ["any"],

    author           = __author__,
    author_email     = __contact__,
    maintainer       = __author__,
    maintainer_email = __contact__,
    license          = __license__,
    long_description = (fopen(join(here_path,"README.txt"),  "r", "utf-8").read() + "\n" +
                        fopen(join(here_path,"CHANGES.txt"), "r", "utf-8").read()),

    packages         = find_packages(exclude=["bin", "doc", "docs", "examples", "test", "tests"]),
    scripts          = [],
    provides         = ["annotate"],
    entry_points     = {},
    requires         = [],
    install_requires = [],
    include_package_data = True,
    zip_safe         = True,

    keywords         = ["annotate", "decorator"],
    classifiers      = ["Development Status :: 4 - Beta",
                        "Intended Audience :: Developers",
                        "Natural Language :: Polish",
                        "Operating System :: OS Independent",
                        "License :: OSI Approved",
                        "License :: OSI Approved :: zlib/libpng License",
                        "Programming Language :: Python",
                        "Programming Language :: Python :: 2",
                        "Programming Language :: Python :: 2.6",
                        "Programming Language :: Python :: 2.7",
                        "Programming Language :: Python :: 2 :: Only",
                        "Programming Language :: Python :: Implementation :: CPython",
                        "Programming Language :: Python :: Implementation :: PyPy",
                        "Programming Language :: Python :: Implementation :: Stackless",
                        "Programming Language :: Python :: Implementation :: IronPython",
                        "Programming Language :: Python :: Implementation :: Jython",
                        "Topic :: Software Development",
                        "Topic :: Software Development :: Libraries",
                        "Topic :: Software Development :: Libraries :: Python Modules"],
)

#---------------------------------------------  EOF  ---------------------------------------------#
