#-------------------------------------------------------------------------------------------------#
#                                                                                                 #
#-------------------------------------------------------------------------------------------------#

import os, sys
from setuptools import setup, find_packages
from codecs     import open as fopen
from os.path    import join as path, abspath, dirname

py_hexver = getattr(sys, "hexversion", 0)
is_pypy   = hasattr(sys, "pypy_version_info")
is_jython = sys.platform.startswith("java")
setup_dir = dirname(abspath(__file__))

if py_hexver < 0x02060000:
    raise AssertionError("Python 2.6 or newer is required")

class about: exec(open(path(setup_dir,"annotate","__about__.py")).read(), None)

setup(
    name             = about.__title__,
    version          = about.__version__,
    description      = about.__summary__,
    url              = about.__uri__,
    download_url     = about.__uri__,

    author           = about.__author__,
    author_email     = about.__email__,
    maintainer       = about.__author__,
    maintainer_email = about.__email__,
    license          = about.__license__,
    long_description = (fopen(path(setup_dir,"README.rst"),   "r","utf-8").read() + "\n" +
                        fopen(path(setup_dir,"CHANGELOG.rst"),"r","utf-8").read()),

    platforms        = ["any"],
    packages         = find_packages(exclude=["bin","doc","docs","examples","test","tests"]),
    scripts          = [],
    provides         = ["annotate"],
    entry_points     = {},
    requires         = [],
    install_requires = [],
    include_package_data = True,
    zip_safe         = True,

    keywords         = ["annotate","decorator"],
    classifiers      = ["Development Status :: 4 - Beta",
                        "Intended Audience :: Developers",
                        "License :: OSI Approved :: zlib/libpng License",
                        "Operating System :: OS Independent",
                        "Natural Language :: Polish",
                        "Programming Language :: Python",
                        "Programming Language :: Python :: 2",
                        "Programming Language :: Python :: 2.6",
                        "Programming Language :: Python :: 2.7",
                        "Programming Language :: Python :: 2 :: Only",
                        "Programming Language :: Python :: Implementation :: CPython",
                        "Programming Language :: Python :: Implementation :: PyPy",
                        "Programming Language :: Python :: Implementation :: Stackless",
                        "Programming Language :: Python :: Implementation :: IronPython",
                        "Programming Language :: Python :: Implementation :: Jython",
                        "Topic :: Software Development :: Libraries :: Python Modules"],
)

#---------------------------------------------  EOF  ---------------------------------------------#
