#!/usr/bin/env python
# coding=UTF-8
# Copyright (c) 2008 Geoffrey Sneddon
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

import ez_setup
ez_setup.use_setuptools()

from setuptools import setup, find_packages

setup(
    # Basic project info
    name = "anolis",
    version = "1.0",
    packages = find_packages(),
    scripts = ["anolis"],
    install_requires = ["html5lib>=0.10", "lxml>=2"],
    
    # Useless metadata cruft
    author = "Geoffrey Sneddon",
    author_email = "geoffers@gmail.com",
    url = "http://anolis.gsnedders.com",
    license = "MIT",
    description = "HTML document post-processor",
    long_description = """Anolis is an HTML document post-processor that takes
                          an input HTML file, adds section numbers, a table
                          of contents, and cross-references, and writes the
                          output to another file.""",
    download_url = "http://anolis.gsnedders.com",
    classifiers = [
        "Development Status :: 5 - Production/Stable",
        "Environment :: Console",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 2",
        "Topic :: Text Processing :: Markup :: HTML"
    ]
)
