#!/usr/bin/env python3
# Re-implementation of the output of 256colors2.pl by Todd Larason.
# This is not a port of the Perl script, but a mimic of the output.

from ansicol import colored

print('System colors:')
for i in range(2):
    for j in range(8):
        print(colored('  ', 'on_ansi{}'.format(i * 8 + j)), end='')
    print()
print()

print('Color cube, 6x6x6:')
for g in range(6):
    for r in range(6):
        for b in range(6):
            print(colored('  ', 'on_rgb{}{}{}'.format(r, g, b)), end='')
        print(' ', end='')
    print()

print('Grayscale ramp:')
for i in range(24):
    print(colored('  ', 'on_grey{}'.format(i)), end='')
print()
