import os
from setuptools import setup

# Utility function to read the README file.
# Used for the long_description.  It's nice, because now 1) we have a top level
# README file and 2) it's easier to type in the README file than to put a raw
# string in below ...
def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()

desc = "A project generator tools for easily create project skeleton."

try:
	long_description = read('ansprogen/README.md')
except:
	long_description = desc

setup(
    name = "ansprogen",
    version = "0.0.1",
    author = "Robin Syihab",
    author_email = "anvie_2194@yahoo.com",
    description = (desc),
    license = "MIT",
    keywords = "ansprogen project generator",
    url = "https://github.com/anvie/Ansprogen",
    packages=['ansprogen'],
	package_data = {
		'': ['README.md', '*.py']
	},
    long_description=long_description,
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Topic :: Utilities",
        "License :: OSI Approved :: MIT License",
    ],
)
