import sys, os

from Acquisition import aq_base, aq_inner

from zope.interface import implements
from Products.Five.browser import BrowserView

from interfaces import ICustomFolderExport

def shasattr(f, n):
    _o = aq_base(aq_inner(f))
    return hasattr(_o, n)

class CustomFolderExport(BrowserView):
    """ @see: ICustomFolderExport """

    implements(ICustomFolderExport)

    def export(self, path, customfolder=None):
        """ @see: ICustomFolderExport#export """

        message = ''

        # meta_type : [postfix, contents reading method]
        objectsmapping = {
            'Script (Python)': ['.py', 'read'],
            'Page Template':['.pt', 'read'],
            'DTML Method':['.dtml','read'],
            'DTML Document':['.dtml','read'],
            'Controller Page Template':['.cpt', 'read'],
            'Controller Python Script':['.cpy','read'],
            'Image':['', 'data'],
            'Folder':['.props', 'read'],
            'File':['', 'data']
        }

        if not os.path.exists(path):
            message = 'Could not find directory %s! Please create it before exporting' % path
            return self.request.RESPONSE.redirect(self.context.absolute_url()+'/@@customexport?status_message=%s' % message)

        if customfolder is None:
            cs = self.context
        else: cs = customfolder

        lst = cs.objectValues()
        for o in lst:
            ct = ''
            
            if not objectsmapping.has_key(o.meta_type):
                message += 'Objects of type "%s" are currently not exportable!<br/>' % o.meta_type
                continue
            
            exportname = '%s%s' % (o.getId(), objectsmapping.get(o.meta_type)[0])
            __traceback_info__ = (exportname, objectsmapping.get(o.meta_type)[1])

            readmethod = getattr(o , objectsmapping[o.meta_type][1], None)
            if readmethod:
                if callable(readmethod):
                    if shasattr(readmethod, 'aq_base'):
                        if callable(readmethod.aq_base):
                            ct = readmethod()
                        else:
                            if shasattr(readmethod, 'seek'):
                                ct = readmethod.read()
                            else: ct = readmethod
                    else:
                        if shasattr(readmethod, 'data'):
                            ct = readmethod.data
                        else:
                            ct = readmethod()
                else: ct = readmethod
            
            # special handling for base_properties
            if exportname == 'base_properties.props':
                props = o.propdict()
                for p in props.values():
                    p['value'] = getattr(o.aq_base, p['id'])
                    ct += '%(id)s:%(type)s=%(value)s\n' % p

            # we also need some special handling for
            # controller objects - they need .metadata file
            if objectsmapping.get(o.meta_type)[0] in ['.cpt', '.cpy']:
                formactions = o.listFormActions(False)
                formvalidations = o.listFormValidators(False)

                fdm = open('%s/%s' % (path, exportname+'.metadata'), 'wb')
                fdm.seek(0)

                dg = """[default]\ntitle = %s\n""" % o.getId().replace('_', '')
                fdm.write(dg)
                
                fdm.write('\n[validators]\n')
                formvalidations.reverse()
                for va in formvalidations:
                    stk = 'validators.%s.%s = %s\n' % \
                            (str(va.getContextType()).replace('None', ''), \
                            str(va.getButton()).replace('None',''), \
                            ','.join(va.getValidators()))

                    # remove some blather
                    stk = stk.replace('.. =', ' =')
                    fdm.write(stk)

                fdm.write('\n[actions]\n')
                formactions.reverse()
                for ac in formactions:
                    fdm.write(str(ac).replace('None','')\
                            .replace('=', ' = ')\
                            .replace(o.getId(), 'action')\
                            .replace('.. =', ' =') + '\n')

                fdm.close()

            if not ct and not readmethod:
                if o.meta_type == 'Folder':
                    basedir = os.path.join(path, o.getId())
                    os.mkdir(basedir)
                    message += self.export(basedir, customfolder=o)
                else:
                    raise Exception, 'Could not find data for %s' % o.getId()

            fd = open('%s/%s' % (path, exportname), 'wb')
            fd.seek(0)

            try:
                fd.write(ct)
            except UnicodeEncodeError:
                fd.close()
                
                # use encoded write - we seem to have unicode
                import codecs
                ufd = codecs.open('%s/%s' % (path, exportname), encoding='utf8', mode='w')
                ufd.write(ct)
                ufd.close()

        message += ' Objects exported. After having checked correctness of export you can delete contents of this folder.'
        return self.request.RESPONSE.redirect(cs.absolute_url()+'/@@customexport?status_message=%s' % message)
