%if 0%{?rhel} && 0%{?rhel} < 5
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
%{!?python_version: %global python_version %(%{__python} -c "import sys ; print sys.version[:3]")}
%endif

%{!?python3_version: %global python3_version %(%{__python3} -c "import sys; sys.stdout.write(sys.version[:3])")}

%if 0%{?fedora}
%global with_python3 1
%endif

# disable debuginfo
%define debug_package %{nil}
%define pkgname anyconfig

Name:           python-%{pkgname}
Version:        0.0.3.10
Release:        1%{?dist}
Summary:        Generic access to configuration files in some formats
Group:          Development/Libraries
License:        MIT
URL:            https://github.com/ssato/%{name}
#Source0:        https://github.com/ssato/%{name}/tarball/master/%{name}-%{version}.tar.gz
Source0:        %{pkgname}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch
BuildRequires:  python-devel
BuildRequires:  python-setuptools
Requires:       PyYAML
Requires:       python-setuptools
%if %{?rhel}%{!?rhel:0} == 5
Requires:       python-simplejson
%endif
%if 0%{?with_python3}
BuildRequires:  python3-devel
BuildRequires:  python3-setuptools
%endif


%description
Python library to provide generic access to configuration files in some
formats such like INI, JSON and YAML.

%if 0%{?with_python3}
%package -n python3-%{pkgname}
Summary:        Generic access to configuration files in some formats
Group:          Development/Libraries
Requires:       python3-PyYAML
Requires:       python3-setuptools

%description -n python3-%{pkgname}
Python library to provide generic access to configuration files in some
formats such like INI, JSON and YAML.
%endif


%prep
%setup -q -n %{pkgname}-%{version}

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif


%build
%{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif


%install
rm -rf $RPM_BUILD_ROOT

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install -O1 --skip-build --root $RPM_BUILD_ROOT
mv $RPM_BUILD_ROOT%{_bindir}/anyconfig_cli $RPM_BUILD_ROOT%{_bindir}/py3anyconfig_cli
# TODO: It does not look working well:
#chmod +x $RPM_BUILD_ROOT%{_bindir}/py3anyconfig_cli
popd
%endif

%{__python} setup.py install -O1 --skip-build --root $RPM_BUILD_ROOT


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc README.rst
%{python_sitelib}/*
%{_bindir}/anyconfig_cli

%if 0%{?with_python3}
%files -n python3-%{pkgname}
%defattr(644,root,root,755)
%doc README.rst
%{python3_sitelib}/*
%attr(755,root,root) %{_bindir}/py3anyconfig_cli
%endif


%changelog
* Thu May  2 2013 Satoru SATOH <ssato@redhat.com> - 0.0.3.10-1
- [anyconfig_cli] Fix a typo in its filename; s/anyconfg/anyconfig/g,
  it's alsot pointed by jonathaneunice-san. Thanks a lot!
- Swtich to use setuptools instead of standard distutils to allow writing
  various pluggable backends
- Implement pluggable backend system w/ using setuptools
- Fix some build and runtime dependencies to PyYAML and setuptools
- Spin off java properties file backend into a separate project:
  https://github.com/ssato/python-anyconfig-pyjavaproperties-backend
- Fix some type mismatches in methods of backend modules
- Make cli frontend generated w/ setuptools' help and remove tools/*

* Sun Mar 31 2013 Satoru SATOH <ssato@redhat.com> - 0.0.3.9-1
- Some fixes and enhancements around logging code
- [anyconfig_cli] add -s/--silent and -v/--verbose option to control log level
  and removed -d/--debug option
- Allow swtich from/to build time snapshot-versioning-mode dynamically
- Build also RPMs for python-3.x
- Allow backend specific options passed to load*/dump* methods of some backends
- Ensure dir to dump output created if that dir not exist

* Wed Mar 13 2013 Satoru SATOH <ssato@redhat.com> - 0.0.3.8-1
- Do not expose internal repr. of loaded data when dump them
- Fix for ini (configparser) backend

* Tue Mar 12 2013 Satoru SATOH <ssato@redhat.com> - 0.0.3.7-1
- change API from anyconfig.find_parser to anyconfig.find_loader
- [anyconfig_cli] rename cli frontend from anyconfig_cui to anyconfig_cli
- [anyconfig_cli] add new option '-M/--merge' to select strategy to merge
  multiple configs
- add 'noreplace' merging strategy
- fix the bug that 'replace' merge strategy (value: 0) was evaluated as False
  and cause an 'invalid strategy' error, and change default merging strategy
- other misc fixes for PEP8 errors and warns, etc.

* Fri Feb  1 2013 Satoru SATOH <ssato@redhat.com> - 0.0.3.6-1
- Added -A and --atype option to anyconfig_cui to override configs w/ -A option
- Fixed an error in anyconfig.api.loads when config type is None
- Updated usage example of anyconfig_cui in README

* Fri Jan 18 2013 Satoru SATOH <ssato@redhat.com> - 0.0.3.5-1
- Changed the default merge strategy of anyconfig.mergeabledict.MergeableDict
  from merge_dicts_and_lists to merge_dicts
- Updated README and added some usage examples

* Thu Jan 17 2013 Satoru SATOH <ssato@redhat.com> - 0.0.3.4-1
- Fine tunes in some APIs to load multi config files
- Updated and enhanced CUI frontend, anyconfig_cui
- Fixed a bug in anyconfig.Bunch.update_w_merge that cause error when merging
  lists with passing merge_lists=True argument
- Updated module's doctext and added some usage examples
- Removed strong dependency to anyconfig.Bunch.Bunch, and switched to
  anyconfig.mergeabledict.MergeableDict which is stripped-down version of
  anyconfig.Bunch.Bunch object

* Fri Jan  4 2013 Satoru SATOH <ssato@redhat.com> - 0.0.3.3-1
- Changed APIs (new: load, {single,mulit}_load) and some cleanups
- Complemented some meta package info to register this module to PyPI
- Changed the name of python module; stripped 'python-' from its name

* Fri Jan  4 2013 Satoru SATOH <ssato@redhat.com> - 0.0.3.2-1
- Fixed a few that yaml.* and etree.* not defined when yaml and etree module is
  not found, causing build time error

* Fri Jan  4 2013 Satoru SATOH <ssato@redhat.com> - 0.0.3.1-1
- Added metaconfig module to control config-loading behavior
- Added some new APIs including anyconfig.{mload,loads}, etc.
- Started CI tests w/ Travis

* Tue Aug  4 2012 Satoru SATOH <ssato@redhat.com> - 0.0.3-1
- Fixed a grave syntax error in anyconfig.backend.properties_
- Some docstring cleanups
- Some refactoring
- Implemented dicts merge/replacements came from config files

* Mon Jul  2 2012 Satoru SATOH <ssato@redhat.com> - 0.0.2-1
- Fixed packaging bug that some modules were missing from the list

* Fri Jun 29 2012 Satoru SATOH <ssato@redhat.com> - 0.0.1-1
- Initial packaging
