#!/usr/bin/python
from __future__ import with_statement
import os, sys
from commands import getoutput
try:
    from setuptools import setup
except:
    from distutils.core import setup
import time

def read_readme():
    with open('docs/readme.rst') as f:
        return f.read()

#XXX: anyvc should do that itself
def getversion():
    if not os.path.exists('.hg'):
        try:
            from anyvc.__version__ import version
            return version
        except ImportError:
            return None # not in a repository
    try:
        l = getoutput('hg id -it').split()
    except OSError, e:
        print "warning: could not establish Mercurial version: %s" % e
        return

    while len(l) > 1 and l[-1][0].isalpha(): # remove non-numbered tags
        l.pop()
    if l:
        version = l[-1] # latest tag or revision number
        if version.endswith('+'):
            version += time.strftime('%Y%m%d')
        return version

version = getversion()
if version:
    f = file("anyvc/__version__.py", "w")
    f.write('# this file is autogenerated by setup.py\n')
    f.write('version = "%s"\n' % version)
    f.close()
else:
    version = "unknown"


setup(
    version = version,
    name = 'anyvc',
    packages = [
        'anyvc',
        'anyvc.common',
        'anyvc.remote',

        # backends
        'anyvc.mercurial',
        'anyvc.git',
        'anyvc.subversion',
        'anyvc.bazaar',
    ],

    extras_require={
        'mercurial': ['mercurial'],
        'bazaar': ['bzr'],
        'git': ['dulwich'],
        'subversion': ['subvertpy'],
        'remoting': ['execnet'],
    },

    entry_points={
        'console.script':[
            'vc = anyvc.client:main',
        ],
    },
    description='Library to access any version control system.',
    license='GNU GPL2 (or later) as published by the FSF',
    url='http://www.bitbucket.org/RonnyPfannschmidt/anyvc/',
    author='Ronny Pfannschmidt',
    author_email='Ronny.Pfannschmidt@gmx.de',
    long_description=read_readme(),
    classifiers = [
        'Intended Audience :: Developers',
    ],
)
