#!/usr/bin/env python3
#
#

import os
import sys

if sys.version_info.major < 3: print("you need to run meds with python3") ; os._exit(1)

try: use_setuptools()
except: pass

try:
    from setuptools import setup
except Exception as ex: print(str(ex)) ; os._exit(1)

from distutils import sysconfig
site_packages_path = sysconfig.get_python_lib()

setup(
    name='apoclaim',
    version='1',
    url='https://pikacode.com/bthate/apoclaim',
    author='Bart Thate',
    author_email='bthate@dds.nl',
    description="""  Een nano bloedmeter is wat we nodig hebben, een bloedglucose meter meet nu in de milli. """,
    license='MIT',
    include_package_data=True,
    zip_safe=False,
    install_requires=["cored", ],
    scripts=["bin/apo", "bin/apo-local", ],
    packages=['apo',
              'apo.plugs',
             ],
    long_description = """ 

Het is de bedoeling om een bloedmeter te koppelen aan dit programma
zodat men een overdosis of een tekort aan bepaalde stoffen in je bloed kan
waarnemen VOORDAT ze een probleem worden. Een bloedmeter kan dan ook inzicht
geven in welke lichaamseigen stoffen een invloed hebben op gedrag.

Een nano bloedmeter is wat we nodig hebben, een bloedglucose meter meet nu  
in de milli.

http://pypi.python.org/pypi/apoclaim


""", 
    classifiers=[
        'Development Status :: 4 - Beta',
        'License :: OSI Approved :: MIT License',
        'Operating System :: Unix',
        'Programming Language :: Python',
        'Topic :: Software Development :: Libraries :: Python Modules'],
)
