# apo/plugs/campagne.py
#
#

""" the thing to resolve. """

## IMPORTS

from core.utils import a_time, nr_days
from core.object import Object
from core.looper import Looper
from core import kernel

## basic imports

import time
import logging
import random
import datetime

## SuicideWarnLoop

pogingenjaar = 94000
pogingendag = pogingenjaar / 365.0
pogingenuur = pogingendag / 24.0
pogingenmin = pogingenuur / 60.0
geslaagdjaar = 1854
geslaagddag = geslaagdjaar / 365.0
geslaagduur = geslaagddag /  24.0
geslaagdmin = geslaagduur / 60.0
counter = 0
startdate = "2012-09-13 00:00:00"
starttime = a_time(startdate)

bron = "https://www.113online.nl/informatie/113online%2B/cijfers-over-zelfmoord"
url = "http://pypi.python.org/pypi/apoclaim"
tags = ["#cda", "#pvda", "#d66", "#vvd", "#groenlinks", "#pvv", "#pvdd", "#ggznederland", "#igz", "#vws"]

prevpogingen = 0
prevgeslaagd = 0
lastpoging = ""
lastsuicide = ""

def campagne(*args, **kwargs):
    global counter, prevpogingen, prevgeslaagd, lastpoging, lastsuicide
    counter += 1
    timediff = time.time() - starttime
    aantalmin = timediff / 60.0
    pogingen = int(aantalmin  * pogingenmin)
    geslaagd = int(aantalmin  * geslaagdmin)
    time_diff = float(time.time() - starttime)
    days = nr_days(time_diff)
    tag = random.choice(tags)
    txt = "POGING nummer %s #apotheker #meds #ggz %s - %s (%s days)" % (pogingen, tag, url, days)
    if pogingen != lastpoging:
        kernel.announce(txt)
        lastpoging = pogingen
    tag = random.choice(tags)
    txt = "SUICIDE nummer %s #apotheker #meds #ggz %s - %s (%s days)" % (geslaagd, tag, url, days) 
    if geslaagd != lastsuicide:
        kernel.announce(txt)
        lastsuicide = geslaagd

kernel.cmnds.register("campagne", campagne)

## campagne init

def init(*args, **kwargs):
    global kernel
    camp = Looper(campagne, 300)
    kernel.run.campagne = camp
    kernel.workers.put(camp.start)
