#!/usr/bin/env python
import os
try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

version = '0.2.1'

setup(
    name='arcus',
    version=version,
    description='Python client for the Arcus Cloud',
    url='http://github.com/arcus-io/arcus-py',
    download_url=('http://cloud.github.com/downloads/arcus-io/'
                  'arcus-py/arcus-%s.tar.gz' % version),
    author='Arcus',
    author_email='ehazlett@arcus.io',
    keywords=['arcus'],
    license='MIT',
    packages=['arcus'],
    install_requires = [ 'requests' ],
    test_suite='tests.all_tests',
    entry_points={
        'console_scripts': [
            'arcus = arcus.runner:main',
        ],
    },
    classifiers=[
        'Environment :: Console',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        ]
)
