#!/usr/bin/env python
# Copyright (c) 2012 Arcus
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
# associated documentation files (the "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all copies or substantial portions
# of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
# NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
# WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
# OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
from optparse import OptionParser
import logging
import os
import sys
from .client import Client

def main():
    log = logging.getLogger('arcus.client')
    log.setLevel(logging.DEBUG)
    log.addHandler(logging.StreamHandler())

    parser = OptionParser()
    parser.add_option('--arcus-url', action='store', dest='arcus_url', \
        default='https://nucleo.arcus.io/api/v1', help='Arcus API URL')
    parser.add_option('--api-key', action='store', dest='api_key', \
        default=None, help='Arcus Cloud API Key')
    parser.add_option('--register', action='store_true', default=False, \
        help='Register current machine with Arcus')

    opts, args = parser.parse_args()
    client = Client(url=opts.arcus_url, api_key=opts.api_key)

    if opts.register:
        if int(os.getuid()) != 0:
            log.error('You must run this as root')
            sys.exit(1)
        log.info('Registering with Arcus...')
        if client.register_node():
            log.info('Machine successfully registered with Arcus Cloud')
        sys.exit(0)

    parser.print_help()

if __name__=='__main__':
    main()

