from boto.s3.connection import S3Connection
from boto.s3.key import Key
from urlparse import urlparse

class ark_s3(object):
  def __init__(self, access_key, secret_key):
    self.access_key = access_key
    self.secret_key = secret_key
    self.s3 = S3Connection(access_key, secret_key)

  def get_content(self, bucket, key):
    k = Key(self.s3.get_bucket(bucket))
    k.key = key
    return k.get_contents_as_string()

  def download_file(self, remote_bucket, remote_key, local_file):
    bucket = self.s3.get_bucket(remote_bucket)
    key = bucket.get_key(remote_key)
    if key is not None:
      key.get_contents_to_filename(local_file)
    else:
      raise Exception("key not found")

  def upload_file(self, remote_bucket, remote_key, local_file):
    bucket = self.s3.get_bucket(remote_bucket)
    key = Key(bucket)
    key.key = remote_key
    key.set_contents_from_filename(local_file)

  def parse_bucket_key(self, path_without_scheme):
    return path_without_scheme.split('/', 1)

  def is_s3_url(self, url):
    """
    Test if the url is an s3 url
    """
    parts = urlparse(url)
    return parts.scheme.lower() == 's3'

  def trim_s3_scheme(self, url):
    """
    Trim the s3:// part of the url
    """
    if url.lower().startswith('s3://'):
      return url[5:]
    else:
      return url

