try:
  import unittest2 as unittest
except ImportError:
  import unittest

from mock import patch
from mock import MagicMock as Mock

import sys
from StringIO import StringIO

import arklib.cli.ark_restore_dir as ark_restore_dir

class ark_restore_dir_test(unittest.TestCase):
  
  def test_main_without_args(self):
    saved_stdout = sys.stdout
    try:
      out = StringIO()
      sys.stdout = out

      # Invoke
      with self.assertRaises(SystemExit) as cm:
        ark_restore_dir.run_main([])
      self.assertEquals(cm.exception.code, 1)

      output = out.getvalue().strip()
    finally:
      sys.stdout = saved_stdout

    self.assertEquals(output, "Syntax: ark-restore-dir [s3://backup-file] [local-dir]")

  @patch('arklib.cli.ark_restore_dir.ark_cred')
  def test_main_with_exception(self, m_cred):
    bad_mock = Mock(side_effect = Exception)
    bad_mock.__str__ = "str"
    m_cred.return_value = bad_mock

    with self.assertRaises(SystemExit) as cm:
      ark_restore_dir.run_main(['name', 'abcd', 's3://bucket/path/puppet.tar.gz'])

    self.assertEquals(cm.exception.code, 1)

  @patch('arklib.cli.ark_restore_dir.ark_cred')
  @patch('arklib.cli.ark_restore_dir.ark_utils')
  @patch('arklib.cli.ark_restore_dir.restore_script')
  def test_main(self, m_script, m_utils, m_cred):
    _cred = Mock()
    _cred.aws_access_key = 'access'
    _cred.aws_secret_key = 'secret'
    m_cred.return_value = _cred

    m_utils.random_word.return_value = "rnd"

    ark_restore_dir.run_main(['script_name', 's3://bucket/path/puppet.tar.gz', 'local'])

    m_cred.assert_called_with()
    m_utils.random_word.assert_called_with(10)
    m_utils.write_script.assert_called_with("/tmp/ark-restore-dir-rnd.sh", m_script)
    m_utils.exec_script.assert_called_with(["/tmp/ark-restore-dir-rnd.sh", "/tmp/backup-rnd.tar.gz", 'local'])
    print m_utils.delete_script.call_args_list
    self.assertTrue(m_utils.delete_script.call_count == 2)
    m_utils.delete_script.assert_any_call('/tmp/ark-restore-dir-rnd.sh')
    m_utils.delete_script.assert_any_call('/tmp/backup-rnd.tar.gz')

