## @package arklib.ark_cred
#
#  This package provides utilities to manage your credentials on the cloud

import yaml

## EC2 credential management.
#
#
#  This class loads your various credentials stored
#  in /etc/cred and provides interfaces to access them.
class ark_cred(object):
  ## Constructor
  #  @param src path to the yaml file storing your credentials.
  #  The default path is <em>/etc/cred.yaml</em>
  def __init__(self, src = '/etc/cred.yaml'):
    cred_src = open(src)
    self._cred = yaml.safe_load(cred_src)
    cred_src.close()

  ## Returns the AWS access key
  #  @return AWS access key
  @property
  def aws_access_key(self):
    return self._cred['aws']['access_key']

  ## Returns the AWS secret key
  #  @return AWS secret key
  @property
  def aws_secret_key(self):
    return self._cred['aws']['secret_key']

