import boto.route53
import xml.etree.ElementTree as ET

class ark_route53(object):
  def __init__(self, access_key, secret_key):
    self.route53 = boto.connect_route53(access_key, secret_key)

  ## Find the hosted zone_id for a given domain
  #
  #
  #  TODO: Consider truncated list
  #
  #
  #  @param domain look up domain
  #  @return zone_id of the domain if found, None otherwise
  def find_hosted_zone_id(self, domain):
    response = self.route53.get_all_hosted_zones()
    zones = response['ListHostedZonesResponse']['HostedZones']
    for z in zones:
      if z['Name'] == domain + '.':
        return z['Id'][12:]
    return None

  def domain_exists(self, domain, rtype, zone_id):
    for r in self.route53.get_all_rrsets(zone_id):
      tree = ET.fromstring(r.to_xml())
      rname = tree.find("Name").text
      ttype = tree.find("Type").text
      if ttype == rtype and rname == domain + ".":
        return True
    return False

  def create_cname_record(self, name, value, zone_id):
    changes = boto.route53.record.ResourceRecordSets(self.route53, zone_id)
    change = changes.add_change("CREATE", name, "CNAME")
    change.add_value(value)
    changes.commit()

  def delete_cname_record(self, name, value, zone_id):
    changes = boto.route53.record.ResourceRecordSets(self.route53, zone_id)
    change = changes.add_change("DELETE", name, "CNAME")
    change.add_value(value)
    changes.commit()

