#!/usr/bin/env python
import sys

import boto.ec2
import boto.utils

from arklib.ark_cred import ark_cred
from arklib.ark_ec2 import ark_ec2

def main():
  try:
    _cred = ark_cred()
    ec2 = ark_ec2(
        _cred.aws_access_key,
        _cred.aws_secret_key,
        'us-west-2')
    instance_id = boto.utils.get_instance_metadata()['instance-id']
    tags = ec2.retrieve_tags(instance_id)
    for tag, val in tags.items():
      print "ec2_tag_{0}={1}".format(tag, val)
  except Exception, e:
    print e
    sys.exit(1)

# # # # # # # # # #
if __name__ == "__main__":
  main()

