#!/usr/bin/env python
import sys, time

from arklib.ark_cred import ark_cred
from arklib.ark_s3 import ark_s3
import arklib.ark_utils as ark_utils

backup_script = """#!/bin/bash

## Directory backup script
#  Usage: dir_backup [directory] [destination]

SRC=$1
DESTINATION=$2

function do_backup() {
  rm -f ${DESTINATION}
  tar pczf ${DESTINATION} ${SRC}
}  

function main() {
  do_backup
}

# Entry point
main

"""

def generate_backup_filename(src):
  return "{}-{}.tar.gz".format(src, time.strftime("%Y-%m-%d"))

def upload_backup_to_s3(local_dest, s3_dest, _cred):
  print "Uploading {} to {}...".format(local_dest, s3_dest)
  s3 = ark_s3(_cred.aws_access_key, _cred.aws_secret_key)
  bucket, key = s3.parse_bucket_key(s3.trim_s3_scheme(s3_dest))
  s3.upload_file(bucket, key, local_dest)

def run_main(argv):
  if len(argv) != 3:
    print "Syntax: ark-backup-dir [local-dir] [s3://backup-dir]"
    sys.exit(1)

  try:
    _cred = ark_cred()
    src = argv[1]
    s3_dir = argv[2]
    filename = generate_backup_filename(src)
    script_path = "/tmp/ark-dir-backup-{}.sh".format(ark_utils.random_word(10))
    s3_dest = "{}/{}".format(s3_dir, filename)
    local_dest = "/tmp/{}-{}".format(ark_utils.random_word(10), filename)

    print "Compressing {} to {} ...".format(src, local_dest)
    ark_utils.write_script(script_path, backup_script)
    ark_utils.exec_script([script_path, src, local_dest])
    ark_utils.delete_script(script_path)
    upload_backup_to_s3(local_dest, s3_dest, _cred)
    ark_utils.delete_script(local_dest)
    print "OK"
  except Exception, e:
    print e
    sys.exit(1)

def main():
  run_main(sys.argv)

# # # # # # # # # #

if __name__ == "__main__":
  main()

