try:
  import unittest2 as unittest
except ImportError:
  import unittest

import tempfile
from arklib.ark_cred import *

class arkCredTest(unittest.TestCase):
  @classmethod
  def setUpClass(self):
    content = """
    aws:
        access_key: a_key
        secret_key: s_key
        region: region
    """

    self._tmpCred = tempfile.NamedTemporaryFile()
    self._tmpCred.write(content)
    self._tmpCred.flush()

  @classmethod
  def tearDownClass(self):
    self._tmpCred.close()

  def testCred(self):
    _cred = ark_cred(src = self._tmpCred.name)
    self.failUnless(_cred._cred is not None)
    self.failUnless(_cred.aws_access_key == 'a_key')
    self.failUnless(_cred.aws_secret_key == 's_key')
    self.failUnless(_cred.aws_region == 'region')

