#!/usr/bin/env python

import boto.ec2

class ark_ec2(object):
  def __init__(self, access_key, secret_key, region):
    self.ec2 = boto.ec2.connect_to_region(
        region,
        aws_access_key_id = access_key,
        aws_secret_access_key = secret_key)

  def retrieve_tags(self, instance_id):
    """
    Retrieve the instance tags
    """
    rsv = self.ec2.get_all_instances(instance_ids=[instance_id])

    if len(rsv) > 1:
      raise Exception("There are more than one instance with id {0}".format(instance_id))

    if len(rsv) == 0:
      raise Exception("There are no instance with id {0}".format(instance_id))

    return rsv[0].instances[0].__dict__['tags']

