#!/usr/bin/env python
import sys

import boto.ec2
import boto.utils

from arklib.ark_cred import ark_cred
from arklib.ark_ec2 import ark_ec2
import arklib.ark_utils as ark_utils

def main():
  try:
    _cred = ark_cred()
    metadata = boto.utils.get_instance_metadata()
    instance_id = metadata['instance-id']
    az = metadata['availability-zone']
    region = ark_utils.guess_region_from_az(az)
    ec2 = ark_ec2(
        _cred.aws_access_key,
        _cred.aws_secret_key,
        region)
    tags = ec2.retrieve_tags(instance_id)
    for tag, val in tags.items():
      print "ec2_tag_{0}={1}".format(tag, val)
  except Exception, e:
    print e
    sys.exit(1)

# # # # # # # # # #
if __name__ == "__main__":
  main()

