#!/usr/bin/env python
import sys
from arklib.ark_cred import ark_cred
import arklib.ark_utils as ark_utils

restore_script = """#!/bin/bash

## Data restore script
#  Usage: data_restore [local_gz] [local_dir]

LOCAL_GZ=$1
LOCAL_DIR=$2

function do_restore() {
  tar pxzf ${LOCAL_GZ} --directory=${LOCAL_DIR}
}

function main() {
  do_restore
}

# Entry point
main

"""

def run_main(argv):
  if len(argv) != 3:
    print "Syntax: ark-restore-dir [s3://backup-file] [local-dir]"
    sys.exit(1)

  try:
    _cred = ark_cred()
    s3_backup = argv[1]
    local_dir = argv[2]
    unique_id = ark_utils.random_word(10)
    tmp_file = "/tmp/backup-{}.tar.gz".format(unique_id)
    script_path = '/tmp/ark-restore-dir-{}.sh'.format(unique_id)

    ark_utils.download_from_s3(s3_backup, tmp_file, _cred)

    ark_utils.write_script(script_path, restore_script)
    ark_utils.exec_script([script_path, tmp_file, local_dir])
    ark_utils.delete_script(script_path)
    ark_utils.delete_script(tmp_file)

    print "OK"
  except Exception, e:
    print e
    sys.exit(1)

def main():
  run_main(sys.argv)

# # # # # # # # # #

if __name__ == "__main__":
  main()

