try:
  import unittest2 as unittest
except ImportError:
  import unittest

from mock import patch
from mock import MagicMock as Mock

import sys
from StringIO import StringIO

import arklib.cli.ark_ec2_tags as ark_ec2_tags

class ark_ec2_tags_test(unittest.TestCase):

  @patch('boto.utils.get_instance_metadata')
  @patch('arklib.cli.ark_ec2_tags.ark_ec2')
  @patch('arklib.cli.ark_ec2_tags.ark_cred')
  def test_main(self, m_cred, m_ec2, m_metadata):
    _cred = Mock()
    _cred.aws_access_key = "key"
    _cred.aws_secret_key = "secret"
    m_cred.return_value = _cred
    ec2 = Mock()
    ec2.retrieve_tags.return_value = {'k1': 'v1', 'k2': 'v2'}
    m_ec2.return_value = ec2
    m_metadata.return_value = {'instance-id': 'id', 'availability-zone': 'us-east-1b'}
    saved_stdout = sys.stdout
    try:
      out = StringIO()
      sys.stdout = out
      # Invoke
      ark_ec2_tags.main()
      output = out.getvalue().strip()
    finally:
      sys.stdout = saved_stdout

    # Asserts
    m_cred.assert_called_with()
    m_ec2.assert_called_with("key", "secret", "us-east-1")
    m_metadata.assert_called_with()
    self.assertTrue(output == 'ec2_tag_k1=v1\nec2_tag_k2=v2' or
        output == 'ec2_tag_k2=v2\nec2_tag_k1=v1')

  @patch('boto.utils.get_instance_metadata')
  @patch('arklib.cli.ark_ec2_tags.ark_cred')
  def test_main_with_exception_swallowed(self, m_cred, m_metadata):
    _cred = Mock(side_effect = Exception)
    _cred.__str__ = "mock"
    m_cred.return_value = _cred
    m_metadata.return_value = {'instance-id': 'id', 'availability-zone': 'us-east-1a'}
    with self.assertRaises(SystemExit) as cm:
      ark_ec2_tags.main()

    self.assertEquals(cm.exception.code, 1)

