try:
  import unittest2 as unittest
except ImportError:
  import unittest

from mock import patch
from mock import MagicMock as Mock

from arklib.ark_ec2 import ark_ec2

class ark_ec2_test(unittest.TestCase):
  
  @patch('boto.ec2.connect_to_region')
  def test_retrieve_tags_no_results(self, m_boto):
    m_ec2 = Mock()
    m_ec2.get_all_instances.return_value = []
    m_boto.return_value = m_ec2

    ec2 = ark_ec2("access", "secret", "region")
    self.assertRaises(Exception, ec2.retrieve_tags, "instance_id")

  @patch('boto.ec2.connect_to_region')
  def test_retrieve_tags_two_results(self, m_boto):
    m_ec2 = Mock()
    result = ["1", "2"]
    m_ec2.get_all_instances.return_value = result
    m_boto.return_value = m_ec2

    ec2 = ark_ec2("access", "secret", "region")
    self.assertRaises(Exception, ec2.retrieve_tags, "instance_id")

  @patch('boto.ec2.connect_to_region')
  def test_retrieve_tags_one_result(self, m_boto):
    m_ec2 = Mock()
    result = Mock()
    instances = Mock()
    instances.__dict__ = {'tags': ['t1', 't2']}
    result.instances = [instances]
    m_ec2.get_all_instances.return_value = [result]
    m_boto.return_value = m_ec2

    ec2 = ark_ec2("access", "secret", "region")
    tags = ec2.retrieve_tags("instance_id")

    self.assertEquals(tags, ['t1', 't2'])

