import os, stat, subprocess
import random, string

from ark_s3 import ark_s3

def download_from_s3(s3_file, local_file, _cred):
  s3 = ark_s3(_cred.aws_access_key, _cred.aws_secret_key)
  bucket, key = s3.parse_bucket_key(s3.trim_s3_scheme(s3_file))
  s3.download_file(bucket, key, local_file)

def write_script(script_path, content):
  f = open(script_path, 'w')
  f.write(content)
  f.close()
  st = os.stat(script_path)
  os.chmod(script_path, st.st_mode | stat.S_IEXEC)

def exec_script(script_and_params, shell = False):
  subprocess.call(script_and_params, shell = shell)

def delete_script(script_path):
  os.remove(script_path)

def random_word(length):
  return ''.join(random.choice(string.lowercase) for i in range(length))

# Guess region from availability zone
def guess_region_from_az(az):
  return az[:-1]

