#!/usr/bin/env python
import sys, os, time, yaml
from arklib.ark_s3 import ark_s3
from arklib.ark_ec2 import ark_ec2
from arklib.ark_cred import ark_cred
from urlparse import urlparse

from boto.ec2.blockdevicemapping import BlockDeviceType
from boto.ec2.blockdevicemapping import BlockDeviceMapping

# Create an ec2 instance
def create_instance(image_id, key_name, security_groups, instance_type, placement):
  # Load cred.yaml
  _cred = ark_cred()

  # Read user-data.template
  script_path = os.path.dirname(os.path.abspath(__file__))
  fd = open(script_path + "/user-data.template", "r")
  template = fd.read()
  fd.close()
  user_data = template % _cred._cred['aws']

  ec2 = ark_ec2(_cred.aws_access_key, _cred.aws_secret_key, _cred.aws_region).ec2

  mapping = create_block_dev_mapping(instance_type)

  reservation = ec2.run_instances(image_id=image_id, key_name=key_name,
    security_groups=security_groups, user_data=user_data,
    instance_type=instance_type, placement=placement, block_device_map=mapping)

  return reservation

def create_block_dev_mapping(instance_type):
  if instance_type == 'c1.xlarge':
    return blk_dev_map_c1_xlarge()
  else:
    return None

def blk_dev_map_c1_xlarge():
  mapping = BlockDeviceMapping()
  eph0 = BlockDeviceType()
  eph1 = BlockDeviceType()
  eph0.ephemeral_name = 'ephemeral0'
  eph1.ephemeral_name = 'ephemeral1'
  eph2.ephemeral_name = 'ephemeral2'
  eph3.ephemeral_name = 'ephemeral3'
  mapping['/dev/sdb'] = eph0
  mapping['/dev/sdc'] = eph1
  mapping['/dev/sdd'] = eph2
  mapping['/dev/sde'] = eph3

  return mapping

def wait_for_start(instance):
  status = instance.update()
  while status == 'pending':
    time.sleep(10)
    status = instance.update()

def load_metadata(path):
  # Load cred.yaml
  _cred = ark_cred()

  parsed = urlparse(path)
  bucket = parsed.netloc
  key = parsed.path
  s3 = ark_s3(_cred.aws_access_key, _cred.aws_secret_key)
  return s3.get_content(bucket, key)

def main(inst_metadata):
  metadata_str = load_metadata(sys.argv[1])
  print metadata_str
  metadata = yaml.safe_load(metadata_str)

  reservation = create_instance(
      metadata['ec2']['ami'],
      metadata['ec2']['key'],
      metadata['ec2']['security_groups'],
      metadata['ec2']['instance_type'],
      metadata['ec2']['az'])

  print "Waiting for instance to start..."
  inst = reservation.instances[0]

  wait_for_start(inst)
  print inst.public_dns_name

  tags = metadata['tags']
  for k, v in tags.items():
    inst.add_tag(k, v)

# # # # # # # # # #
if __name__ == "__main__":
  if len(sys.argv) != 2:
    print "Syntax: launch-instance [s3://path/to/instance/metadata.yaml]"
    sys.exit(1)

  main(sys.argv[1])

