#!/usr/bin/env python

import sys
import boto.utils
import boto.ec2

from arklib.ark_cred import ark_cred
from arklib.ark_route53 import ark_route53
from arklib.ark_ec2 import ark_ec2
import arklib.ark_utils as ark_utils

def set_dns_record(dns, public_dns_name, _cred):
  route53 = ark_route53(_cred.aws_access_key, _cred.aws_secret_key)
  domain = dns.split('.', 1)[1]
  zone_id = route53.find_hosted_zone_id(domain)

  if zone_id is None:
    print "Could not find a zone for {0} in route53".format(domain)
    return

  if not route53.domain_exists(dns, "CNAME", zone_id):
    route53.create_cname_record(dns, public_dns_name, zone_id)
    print "Added a CNAME record: {0} => {1}".format(dns, public_dns_name)
  else:
    print "Domain {0} exists".format(dns)

def main():
  try:
    _cred = ark_cred()
    metadata = boto.utils.get_instance_metadata()
    pub_hostname = metadata['public-hostname']
    ins_id = metadata['instance-id']
    az = metadata['placement']['availability-zone']
    region = ark_utils.guess_region_from_az(az)
    ec2 = ark_ec2(
        _cred.aws_access_key,
        _cred.aws_secret_key,
        region)
    dns = ec2.retrieve_tags(ins_id)['dns']
    set_dns_record(dns, pub_hostname, _cred)
  except Exception, e:
    print e
    sys.exit(1)

# # # # # # # # # #
if __name__ == "__main__":
  main()

