
US_state_abbrev = dict([
    ('AL', 'ALABAMA'),
    ('AK', 'ALASKA'),
    ('AS', 'AMERICAN SAMOA'),
    ('AZ', 'ARIZONA'),
    ('AR', 'ARKANSAS'),
    ('CA', 'CALIFORNIA'),
    ('CO', 'COLORADO'),
    ('CT', 'CONNECTICUT'),
    ('DE', 'DELAWARE'),
    ('DC', 'DISTRICT OF COLUMBIA'),
    ('FM', 'FEDERATED STATES OF MICRONESIA'),
    ('FL', 'FLORIDA'),
    ('GA', 'GEORGIA'),
    ('GU', 'GUAM'),
    ('HI', 'HAWAII'),
    ('ID', 'IDAHO'),
    ('IL', 'ILLINOIS'),
    ('IN', 'INDIANA'),
    ('IA', 'IOWA'),
    ('KS', 'KANSAS'),
    ('KY', 'KENTUCKY'),
    ('LA', 'LOUISIANA'),
    ('ME', 'MAINE'),
    ('MH', 'MARSHALL ISLANDS'),
    ('MD', 'MARYLAND'),
    ('MA', 'MASSACHUSETTS'),
    ('MI', 'MICHIGAN'),
    ('MN', 'MINNESOTA'),
    ('MS', 'MISSISSIPPI'),
    ('MO', 'MISSOURI'),
    ('MT', 'MONTANA'),
    ('NE', 'NEBRASKA'),
    ('NV', 'NEVADA'),
    ('NH', 'NEW HAMPSHIRE'),
    ('NJ', 'NEW JERSEY'),
    ('NM', 'NEW MEXICO'),
    ('NY', 'NEW YORK'),
    ('NC', 'NORTH CAROLINA'),
    ('ND', 'NORTH DAKOTA'),
    ('MP', 'NORTHERN MARIANA ISLANDS'),
    ('OH', 'OHIO'),
    ('OK', 'OKLAHOMA'),
    ('OR', 'OREGON'),
    ('PW', 'PALAU'),
    ('PA', 'PENNSYLVANIA'),
    ('PR', 'PUERTO RICO'),
    ('RI', 'RHODE ISLAND'),
    ('SC', 'SOUTH CAROLINA'),
    ('SD', 'SOUTH DAKOTA'),
    ('TN', 'TENNESSEE'),
    ('TX', 'TEXAS'),
    ('UT', 'UTAH'),
    ('VT', 'VERMONT'),
    ('VI', 'VIRGIN ISLANDS'),
    ('VA', 'VIRGINIA'),
    ('WA', 'WASHINGTON'),
    ('WV', 'WEST VIRGINIA'),
    ('WI', 'WISCONSIN'),
    ('WY', 'WYOMING')
])




## State or Territory
## USPS approved postal abbreviations
## GPO
## Traditional abbreviations
## Other abbreviations and codes

more_abbreviations = [
    ('Alabama', 'AL', 'Ala.', 'Ala.', None),
    ('Alaska', 'AK', 'Alaska', 'Alaska', 'Alas.'),
    ('Arizona', 'AZ', 'Ariz.', 'Ariz.', None),
    ('Arkansas', 'AR', 'Ark.', 'Ark.', 'A.R.'),
    ('California', 'CA', 'Calif.', 'Calif.', 'Cal., CF<sup>UCCG</sup>'),
    ('Colorado', 'CO', 'Colo.', 'Colo.', 'Col., CL<sup>UCCG</sup>'),
    ('Connecticut', 'CT', 'Conn.', 'Conn.', None),
    ('Delaware', 'DE', 'Del.', 'Del.', 'DL<sup>UCCG</sup>'),
    ('District of Columbia', 'DC', 'D.C.', 'D.C.', '(Federal district)'),
    ('Florida', 'FL', 'Fla.', 'Fla.', 'Flor.'),
    ('Georgia Georgia', 'GA', 'Ga.', 'Ga.', None),
    ('Hawaii', 'HI', 'Hawaii', 'Hawaii', 'H.I., HA<sup>UCCG</sup>'),
    ('Idaho', 'ID', 'Idaho', 'Idaho', 'Id. or Ida.'),
    ('Illinois', 'IL', 'Ill.', 'Ill.', 'Ills.'),
    ('Indiana', 'IN', 'Ind.', 'Ind.', None),
    ('Iowa', 'IA', 'Iowa', 'Iowa', 'Ia.'),
    ('Kansas', 'KS', 'Kans.', 'Kan.', 'KA<sup>UCCG</sup>'),
    ('Kentucky', 'KY', 'Ky.', 'Ky.', 'Ken. or Kent.'),
    ('Louisiana', 'LA', 'La.', 'La.', None),
    ('Maine', 'ME', 'Maine', 'Maine', 'Me.'),
    ('Maryland', 'MD', 'Md.', 'Md.', None),
    ('Massachusetts', 'MA', 'Mass.', 'Mass.', 'MS<sup>UCCG</sup>'),
    ('Michigan', 'MI', 'Mich.', 'Mich.', 'MC<sup>UCCG</sup>'),
    ('Minnesota', 'MN', 'Minn.', 'Minn.', None),
    ('Mississippi', 'MS', 'Miss.', 'Miss.', 'MI<sup>UCCG</sup>'),
    ('Missouri', 'MO', 'Mo.', 'Mo.', None),
    ('Montana', 'MT', 'Mont.', 'Mont.', None),
    ('Nebraska', 'NE', 'Nebr.', 'Neb.', 'NB<sup>UCCG</sup>'),
    ('Nevada', 'NV', 'Nev.', 'Nev.', None),
    ('New Hampshire', 'NH', 'N.H.', 'N.H.', None),
    ('New Jersey', 'NJ', 'N.J.', 'N.J.', None),
    ('New Mexico', 'NM', 'N. Mex.', 'N.M.', 'New M.'),
    ('New York', 'NY', 'N.Y.', 'N.Y.', 'N. York'),
    ('North Carolina', 'NC', 'N.C.', 'N.C.', 'N. Car.'),
    ('North Dakota', 'ND', 'N. Dak.', 'N.D.', None),
    ('Ohio', 'OH', 'Ohio', 'Ohio', 'O.'),
    ('Oklahoma', 'OK', 'Okla.', 'Okla.', None),
    ('Oregon', 'OR', 'Oreg.', 'Ore.', None),
    ('Pennsylvania', 'PA', 'Pa.', 'Pa.', 'Penn. or Penna.'),
    ('Rhode Island', 'RI', 'R.I.', 'R.I.', None),
    ('South Carolina', 'SC', 'S.C.', 'S.C.', 'S. Car.'),
    ('South Dakota', 'SD', 'S. Dak.', 'S.D.', None),
    ('Tennessee', 'TN', 'Tenn.', 'Tenn.', None),
    ('Texas', 'TX', 'Tex.', 'Texas', None),
    ('Utah', 'UT', 'Utah', 'Utah', 'Ut.'),
    ('Vermont', 'VT', 'Vt.', 'Vt.', None),
    ('Virginia', 'VA', 'Va.', 'Va.', None),
    ('Washington', 'WA', 'Wash.', 'Wash.', 'Wn., WN<sup>UCCG</sup>'),
    ('West Virginia', 'WV', 'W. Va.', 'W.Va.', 'W.V.'),
    ('Wisconsin', 'WI', 'Wis.', 'Wis.', 'Wisc., WS<sup>UCCG</sup>'),
    ('Wyoming', 'WY', 'Wyo.', 'Wyo.', None),
]
