#
# $Source: /home/blais/repos/cvsroot/arubomu/lib/python/arubomu/catcache.py,v $
# $Id: catcache.py,v 1.5 2004/02/14 18:22:31 blais Exp $
#

"""Cache for downloaded catalog HTML files."""

__version__ = "$Revision: 1.5 $"
__author__ = "Martin Blais <blais@furius.ca>"


import os
from os.path import join, exists
import urllib


try:
    cachedir = os.environ['JUKEBOX_CATALOG_CACHE']
except:
    cachedir = join(os.environ['HOME'], 'catcache')


class CatCache:

    #---------------------------------------------------------------------------
    #
    def __init__(self, name):
        self.name = name
        self.dir = join(cachedir, name)
        if not exists(self.dir):
            os.makedirs(self.dir)

    #---------------------------------------------------------------------------
    #
    def fetch(self, catno, url):
        fn = join(self.dir, catno)
        if not exists(fn):
            urllib.urlretrieve(url, fn)
        text = open(fn, 'r').read()
        return text
        


def test():
    pass

    
# Run main if loaded as a script
if __name__ == "__main__":
    test()

