#
# $Source: /home/blais/repos/cvsroot/arubomu/lib/python/arubomu/parsers/xml.py,v $
# $Id: xml.py,v 1.3 2004/02/15 21:59:21 blais Exp $
#

"""Parse our own format.  This is a round-trip algorithm implementation.

"""

__version__ = "$Revision: 1.3 $"
__author__ = "Martin Blais <blais@furius.ca>"


import sys, os
import string, re
import StringIO

import htmllib, formatter
import strxtra

from arubomu.parsers.base import Fetcher
from arubomu import album, rip


__all__ = ['ArubomuFetcher']


def create_fetcher():
    return ArubomuFetcher()


class ArubomuFetcher(Fetcher):

    def geturl(self, catalog_number):
        return 'file:%s' % catalog_number

    def parse(self, text):
        iss = StringIO.StringIO(text)
        a = rip.load(iss)
        if not a:
            iss = StringIO.StringIO(text)
            a = album.load(iss)
        return (a, None)
