#
# Install script for arubomu.
#

__version__ = "$Revision: 1.4 $"
__author__ = "Martin Blais <blais@furius.ca>"

from distutils.core import setup
import os
from os.path import join

def read_version():
    try:
        return open('VERSION', 'r').readline().strip()
    except IOError, e:
        raise SystemExit(
            "Error: you must run setup from the root directory (%s)" % str(e))

# Include all files without having to create MANIFEST.in
def add_all_files(fun):
    import os, os.path
    from os.path import abspath, dirname, join
    def f(self):
        for root, dirs, files in os.walk('.'):
            if '.hg' in dirs: dirs.remove('.hg')
            self.filelist.extend(join(root[2:], fn) for fn in files
                                 if not fn.endswith('.pyc'))
        return fun(self)
    return f
from distutils.command.sdist import sdist
sdist.add_defaults = add_all_files(sdist.add_defaults)


def get_scripts(p):
    files = os.listdir(p)
    files = filter(lambda x: x.startswith('arubomu-'), files)
    return map(lambda x: join(p, x), files)


setup(name="arubomu",
      version=read_version(),
      description="Library of data structures and I/O for music album information",
      long_description="""
This package contains a RELAX-NG schema and associated Python code for parsing
a simple XML file format for representing information that is related to a music
album, which is split in two: information that is common to all copies of that
album, and information that is specific to the owner (encoding errors, description,
favourite songs).

Accompanying tools allow to fetch and automatically convert data from a few
online database (amazon.com, descarga.com).  There are also numerous tools that
allow manipulating and converting album information to the XML format.
""",
      license="GNU GPL",
      author="Martin Blais",
      author_email="blais@furius.ca",
      url="http://furius.ca/arubomu",
      package_dir = {'': 'lib/python'},
      packages = ['arubomu', 'arubomu.parsers'],
      scripts = get_scripts('bin')
      )
