# run from main directory; not from test/
import asciitable

try:
    from math import isnan
except ImportError:
    try:
        from numpy import isnan
    except ImportError:
        print('Tests requiring isnan will fail')
    
readme = "t/vizier/ReadMe"

def test_header_from_readme():
    r = asciitable.Cds(readme)
    table = r.read("t/vizier/table1.dat")
    assert len(r.data.data_lines) == 15
    assert len(table) == 15
    assert len(table.keys()) == 18
    Bmag = [14.79,
            15.00, 
            14.80, 
            12.38, 
            12.36, 
            12.24, 
            13.75, 
            13.65, 
            13.41, 
            11.59, 
            11.68, 
            11.53, 
            13.92, 
            14.03, 
            14.18]
    for i, val in enumerate(table.field('Bmag')):
        assert val == Bmag[i]

    table = r.read("t/vizier/table5.dat")
    assert len(r.data.data_lines) == 5265
    assert len(table) == 5265
    assert len(table.keys()) == 10
    Q = [ 0.289, 
          0.325, 
          0.510, 
          0.577, 
          0.539, 
          0.390, 
          0.957, 
          0.736, 
          1.435, 
          1.117, 
          1.473, 
          0.808, 
          1.416, 
          2.209, 
          0.617, 
          1.046, 
          1.604, 
          1.419, 
          1.431, 
          1.183, 
          1.210, 
          1.005, 
          0.706, 
          0.665, 
          0.340, 
          0.323, 
          0.391, 
          0.280, 
          0.343, 
          0.369, 
          0.495, 
          0.828, 
          1.113, 
          0.499, 
          1.038, 
          0.260, 
          0.863, 
          1.638, 
          0.479, 
          0.232, 
          0.627, 
          0.671, 
          0.371, 
          0.851, 
          0.607, 
         -9.999, 
          1.958, 
          1.416, 
          0.949, 
          0.334, 
          0.319, 
          0.933, 
          1.111, 
          0.929, 
          0.358, 
          0.445, 
          2.024, 
          0.795, 
          0.905, 
          0.507, 
          0.402, 
          0.906, 
          0.949, 
          0.353, 
         -9.999, 
          0.548, 
          0.668, 
          0.881, 
          0.856, 
          0.691, 
          0.682, 
          0.465, 
          0.606, 
          1.623, 
          0.396, 
          0.458, 
          1.091, 
          0.472, 
          0.353, 
          0.433, 
          1.766, 
          0.789, 
          1.840, 
          0.441, 
          0.461, 
          0.693, 
          0.779, 
          0.347, 
          0.505, 
          1.018, 
          0.998, 
          0.615, 
          0.609, 
          0.532, 
          0.178, 
          1.038, 
          0.782, 
          1.302, 
          0.416, 
          0.295, 
         -9.999, 
         -9.999, 
          0.458, 
          1.201, 
          0.178, 
          0.727, 
          0.724, 
          0.614, 
          0.837, 
          0.871, 
          1.181, 
          0.718, 
          0.821, 
          0.638, 
          0.500, 
          0.651, 
          0.601, 
          0.680, 
          1.217, 
          0.945, 
          0.710, 
          0.735, 
          0.372, 
         -9.999, 
          0.467, 
          0.436, 
          1.398, 
          0.911, 
          0.348, 
          1.240, 
          0.779, 
          1.471, 
          1.342, 
          0.375, 
          0.485, 
          0.196, 
          1.036, 
          0.888, 
          0.702, 
          0.883, 
          1.166, 
          1.427, 
          1.590, 
          1.580, 
          1.171, 
          0.852, 
          0.445, 
          0.624, 
          1.130, 
          0.465, 
          0.379, 
          0.548, 
          0.653, 
          0.696, 
          0.258, 
          0.736, 
          0.369, 
          0.339, 
         -9.999, 
          0.309, 
          0.456, 
          0.559, 
          0.255, 
          0.321, 
          0.257, 
          0.260, 
          0.932, 
          0.938, 
          0.712, 
          0.797, 
          0.305, 
          0.434, 
          0.343, 
          0.809, 
          0.317, 
          0.657, 
          0.662, 
          0.296, 
          0.597, 
          0.697, 
          0.445, 
          0.715, 
          0.722, 
          0.475, 
         -9.999, 
          0.765, 
          0.776, 
          0.810, 
          0.664, 
          0.645, 
          0.599, 
          0.365, 
          0.376, 
          0.712, 
          0.257, 
          0.233, 
          0.820, 
          0.500, 
          0.286, 
          1.110, 
          0.581, 
          1.031, 
          0.197, 
          0.996, 
          0.287, 
          0.703, 
          0.221, 
          0.370, 
          0.451, 
          0.746, 
          0.760, 
          0.576, 
          0.419, 
          0.357, 
         -9.999, 
          0.608, 
          1.283, 
         -9.999, 
          0.736, 
          0.503, 
          0.520, 
         -9.999, 
          0.272, 
          0.504, 
          0.377, 
          0.505, 
          0.265, 
          0.411, 
          0.324, 
          1.315, 
          0.994, 
          0.182, 
          0.360, 
          0.521, 
          0.966, 
          0.301, 
          1.406, 
          0.482, 
          1.426, 
          1.120, 
          0.717, 
          1.352, 
          1.035, 
          0.340, 
          1.357, 
          0.696, 
          0.796, 
          0.506, 
          0.685, 
          0.509, 
          0.549, 
          0.212, 
          0.519, 
          0.694, 
          0.547, 
          0.626, 
          0.730, 
          0.715, 
          0.844, 
          0.632, 
          0.541, 
          0.312, 
          0.311, 
          0.895, 
          0.435, 
          0.510, 
          0.164, 
          0.817, 
          0.387, 
          1.169, 
          0.612, 
          0.510, 
          0.349, 
          0.915, 
          0.815, 
          0.537, 
          0.418, 
          0.705, 
          0.649, 
          0.787, 
          0.486, 
          0.744, 
          0.995, 
          0.524, 
          0.501, 
          1.052, 
          0.417, 
          0.485, 
          0.712, 
          0.478, 
          0.642, 
          0.478, 
          0.273, 
          0.190, 
          0.456, 
          0.511, 
          0.199, 
          0.433, 
          0.272, 
          0.355, 
          0.672, 
          0.456, 
          0.257, 
          0.321, 
          0.435, 
          0.625, 
          0.578, 
          0.480, 
          1.293, 
          0.439, 
         -9.999, 
          0.328, 
          1.706, 
          1.711, 
          0.554, 
          0.584, 
          0.840, 
          0.928, 
          0.761, 
          0.497, 
          0.609, 
          1.312, 
          0.783, 
          0.845, 
          0.692, 
          1.364, 
          0.565, 
          0.180, 
          0.321, 
          0.646, 
          0.762, 
          0.660, 
          1.857, 
          0.334, 
          0.502, 
          0.632, 
          0.384, 
          0.232, 
          1.165, 
          0.394, 
          0.615, 
          1.005, 
          1.031, 
          0.579, 
          1.049, 
          0.927, 
          0.721, 
          0.572, 
          0.946, 
          0.227, 
          0.163, 
         -9.999, 
          0.322, 
          0.530, 
          0.217, 
          0.596, 
          0.349, 
          0.650, 
          0.362, 
          0.932, 
          1.168, 
          1.665, 
          1.569, 
          1.206, 
          1.563, 
         -9.999, 
          0.891, 
          1.269, 
          1.921, 
          1.085, 
          0.851, 
          1.144, 
          0.909, 
          0.832, 
          0.482, 
          0.406, 
          0.218, 
          0.268, 
          0.303, 
          0.250, 
          0.366, 
          0.355, 
          1.951, 
          0.685, 
          0.596, 
          0.348, 
         -9.999, 
          1.389, 
          0.493, 
          0.313, 
          0.406, 
         -9.999, 
          0.553, 
          0.829, 
         -9.999, 
          1.031, 
         -9.999, 
          0.784, 
          1.790, 
          0.486, 
         -9.999, 
          0.700, 
          0.724, 
          1.590, 
          0.792, 
          1.585, 
          0.864, 
          1.823, 
          0.251, 
          0.533, 
          1.326, 
          0.374, 
          0.827, 
          0.899, 
          0.579, 
          0.754, 
          0.389, 
          1.453, 
          0.621, 
          1.186, 
          0.700, 
          0.493, 
          0.328, 
          0.669, 
          1.194, 
          0.309, 
          0.673, 
          1.369, 
          0.830, 
          0.810, 
          0.856, 
          2.100, 
          0.878, 
          2.165, 
         -9.999, 
          0.504, 
          1.053, 
          0.563, 
          0.990, 
          1.014, 
          0.990, 
          0.584, 
          0.584, 
          0.663, 
          0.544, 
          0.584, 
          0.637, 
          1.049, 
          1.488, 
         -9.999, 
         -9.999, 
         -9.999, 
          0.518, 
          0.753, 
          0.969, 
          0.777, 
          0.744, 
          0.865, 
          0.681, 
          0.589, 
          0.739, 
          0.804, 
          0.703, 
         -9.999, 
          0.968, 
          0.976, 
          0.797, 
         -9.999, 
          1.245, 
          1.021, 
          0.943, 
          0.481, 
          1.019, 
         -9.999, 
          0.381, 
          0.757, 
          1.156, 
          1.647, 
          0.984, 
          0.638, 
          1.266, 
          1.117, 
          1.157, 
          1.539, 
          0.300, 
          0.795, 
          0.788, 
          0.804, 
          1.224, 
          0.649, 
          0.718, 
          0.416, 
          0.636, 
          1.025, 
          0.904, 
          0.866, 
          0.717, 
         -9.999, 
          0.598, 
          0.783, 
          0.628, 
          0.542, 
          0.467, 
          0.718, 
          0.822, 
          0.479, 
          0.641, 
          0.650, 
          0.495, 
          0.543, 
          0.198, 
          0.809, 
         -9.999, 
          0.407, 
          0.380, 
          0.700, 
          0.340, 
          0.470, 
          0.407, 
          0.327, 
          0.489, 
          0.631, 
          0.256, 
         -9.999, 
          0.946, 
          0.413, 
          0.376, 
          0.478, 
          0.583, 
          0.360, 
          0.939, 
          0.374, 
          0.411, 
          1.183, 
          0.435, 
          0.382, 
          0.265, 
          0.502, 
          0.347, 
         -9.999, 
          0.943, 
         -9.999, 
          0.562, 
          0.497, 
          0.514, 
          0.546, 
          0.200, 
          0.696, 
          0.362, 
          0.212, 
          0.295, 
          0.388, 
          0.767, 
          0.375, 
          0.801, 
          0.543, 
          0.444, 
          0.389, 
          0.149, 
          0.582, 
          0.299, 
          0.326, 
          0.764, 
          0.330, 
         -9.999, 
          0.292, 
          0.520, 
          0.575, 
          0.520, 
         -9.999, 
         -9.999, 
          0.422, 
          0.585, 
          0.434, 
          0.545, 
          0.701, 
          0.328, 
          0.728, 
          0.647, 
          0.149, 
          1.180, 
          1.162, 
          0.405, 
          0.320, 
          0.234, 
          0.743, 
          0.659, 
          1.757, 
          0.293, 
          1.350, 
          0.602, 
          0.513, 
          1.642, 
          0.940, 
          0.930, 
          1.721, 
          0.760, 
          0.895, 
          0.708, 
          0.663, 
          0.757, 
          0.446, 
          0.597, 
          0.534, 
          0.721, 
         -9.999, 
          0.645, 
          0.657, 
          0.844, 
          0.839, 
          0.959, 
          0.396, 
          0.406, 
          0.659, 
          0.497, 
          0.453, 
          0.687, 
          0.310, 
          0.922, 
          0.164, 
          1.239, 
          0.596, 
          0.569, 
          0.378, 
         -9.999, 
          0.423, 
          0.746, 
          0.632, 
          0.751, 
          0.524, 
          0.511, 
          0.644, 
          0.633, 
          0.832, 
          1.013, 
          0.523, 
          0.827, 
          0.445, 
          0.360, 
          0.580, 
          0.329, 
          0.723, 
          0.157, 
          0.369, 
          0.229, 
          0.247, 
          0.540, 
          0.576, 
          0.223, 
          0.225, 
          0.514, 
          0.613, 
          0.464, 
          0.379, 
          0.529, 
          0.435, 
          0.409, 
          0.608, 
          0.512, 
          0.762, 
          0.645, 
          0.473, 
          0.242, 
          1.660, 
          3.424, 
          2.007, 
          0.834, 
          0.715, 
          0.592, 
          0.571, 
          0.417, 
          0.821, 
          0.564, 
          0.237, 
          0.642, 
          0.967, 
          1.238, 
          0.560, 
          0.540, 
         -9.999, 
          0.407, 
          0.350, 
          0.335, 
         -9.999, 
          0.704, 
          0.315, 
          0.815, 
          0.585, 
          0.213, 
          0.713, 
          1.736, 
          0.627, 
          1.226, 
         -9.999, 
          0.717, 
          0.649, 
          0.803, 
          0.334, 
          0.444, 
          1.592, 
          0.370, 
         -9.999, 
          0.730, 
          0.374, 
          0.538, 
          0.790, 
          0.508, 
          0.435, 
          0.513, 
          1.467, 
          1.144, 
          1.335, 
          1.610, 
          1.210, 
          1.047, 
          0.828, 
          0.443, 
          0.875, 
          0.520, 
          1.444, 
          1.254, 
          1.313, 
          1.637, 
          0.649, 
          1.097, 
          0.761, 
          0.383, 
          0.414, 
          0.262, 
          0.380, 
          0.457, 
          1.023, 
          0.348, 
          0.577, 
          0.680, 
         -9.999, 
          0.423, 
          0.325, 
          0.539, 
          0.820, 
          0.470, 
          0.299, 
          0.412, 
          0.222, 
         -9.999, 
          0.597, 
          0.917, 
          1.469, 
          1.068, 
          0.724, 
          0.823, 
          1.696, 
          0.510, 
          0.830, 
          0.235, 
         -9.999, 
          0.915, 
          0.856, 
          1.062, 
          1.035, 
          0.718, 
          0.771, 
         -9.999, 
          1.121, 
          0.568, 
          0.748, 
          0.669, 
          0.318, 
          1.126, 
          0.578, 
          1.014, 
          1.013, 
          0.545, 
          0.560, 
          1.126, 
          1.172, 
          0.582, 
          0.939, 
          0.339, 
          0.384, 
          0.200, 
          1.316, 
          0.980, 
          0.566, 
          0.841, 
          0.219, 
          0.588, 
          0.241, 
          0.257, 
          1.192, 
          0.566, 
          0.577, 
          0.437, 
         -9.999, 
          0.583, 
          0.526, 
          0.633, 
          0.747, 
          0.237, 
          0.482, 
          0.506, 
          0.364, 
          0.794, 
          0.511, 
         -9.999, 
          0.957, 
          0.529, 
          0.823, 
          0.941, 
          0.664, 
          0.721, 
          1.115, 
          0.979, 
          1.268, 
          0.401, 
          1.265, 
          1.433, 
         -9.999, 
         -9.999, 
          0.372, 
          2.069, 
          0.367, 
          0.657, 
          0.946, 
          0.305, 
          0.551, 
          0.455, 
          0.594, 
          1.594, 
          1.378, 
          0.559, 
          1.429, 
          1.025, 
          1.520, 
          1.302, 
          0.200, 
          0.422, 
          0.512, 
          1.065, 
          0.823, 
          0.390, 
          1.288, 
          0.792, 
          0.544, 
          1.048, 
          1.317, 
          1.361, 
          0.275, 
          0.371, 
          0.486, 
          0.759, 
          0.366, 
          0.370, 
          0.601, 
          0.567, 
          0.313, 
          0.464, 
          0.459, 
          0.572, 
          0.418, 
          0.735, 
          0.622, 
          0.643, 
          0.317, 
          0.242, 
          0.220, 
          0.243, 
          0.254, 
          0.329, 
          0.326, 
          0.501, 
          0.697, 
          0.332, 
          0.603, 
          0.266, 
          0.869, 
          1.038, 
          0.587, 
          0.565, 
          0.355, 
          0.314, 
          0.261, 
          0.336, 
          0.421, 
          0.715, 
          0.413, 
          0.605, 
         -9.999, 
          0.577, 
          0.317, 
          0.523, 
          1.194, 
          0.849, 
          0.467, 
          1.032, 
          0.614, 
          0.308, 
          0.519, 
          0.862, 
          0.420, 
          0.288, 
          0.447, 
          0.369, 
          0.939, 
          0.318, 
          0.756, 
          0.523, 
         -9.999, 
         -9.999, 
         -9.999, 
          0.454, 
          0.568, 
          0.413, 
          0.747, 
         -9.999, 
          0.108, 
          0.746, 
         -9.999, 
          0.940, 
          0.725, 
         -9.999, 
          0.914, 
          0.649, 
          0.647, 
          0.225, 
          1.001, 
          0.607, 
          0.193, 
          0.595, 
          0.729, 
          0.454, 
         -9.999, 
          0.426, 
          0.778, 
         -9.999, 
          0.223, 
          1.112, 
          0.870, 
          0.645, 
          0.407, 
          0.781, 
          0.314, 
          0.341, 
         -9.999, 
          0.532, 
          0.740, 
          1.071, 
          0.784, 
          1.228, 
          0.467, 
          0.618, 
          0.894, 
          0.800, 
          0.387, 
          0.554, 
          0.416, 
          0.473, 
          0.273, 
          0.498, 
          0.877, 
          0.485, 
          0.883, 
          0.287, 
          0.304, 
          0.580, 
         -9.999, 
          0.442, 
          0.595, 
          0.357, 
          0.821, 
          0.210, 
          0.945, 
          0.678, 
          0.688, 
          0.258, 
          0.490, 
          0.798, 
          0.715, 
          0.822, 
          0.463, 
          0.666, 
          0.366, 
          1.903, 
          1.433, 
          0.715, 
          0.638, 
          0.908, 
          1.138, 
          0.619, 
          0.670, 
          0.420, 
          0.396, 
          0.689, 
          0.303, 
          0.567, 
          0.408, 
          0.235, 
          0.266, 
         -9.999, 
          0.329, 
         -9.999, 
          0.364, 
          0.573, 
          0.338, 
          0.252, 
          0.415, 
          0.707, 
         -9.999, 
          0.484, 
          0.310, 
          0.760, 
          0.252, 
          0.627, 
          0.517, 
          1.312, 
         -9.999, 
          0.447, 
          0.347, 
          0.755, 
          0.654, 
          1.561, 
          0.410, 
          0.422, 
          0.593, 
          0.620, 
          0.862, 
          0.665, 
          1.097, 
          0.377, 
          0.254, 
         -9.999, 
          0.675, 
          0.400, 
          0.416, 
         -9.999, 
          0.565, 
          0.380, 
          1.312, 
          0.494, 
          0.569, 
          1.101, 
          0.701, 
          0.623, 
          0.734, 
          1.067, 
          0.866, 
          0.840, 
          0.694, 
          0.589, 
          0.358, 
          0.548, 
          0.695, 
          0.284, 
          0.570, 
          0.494, 
          0.324, 
          0.569, 
          1.267, 
          1.277, 
          1.028, 
          1.765, 
          0.598, 
          1.135, 
          0.825, 
          0.635, 
          0.536, 
          2.801, 
          0.415, 
          0.464, 
          0.653, 
          0.780, 
          0.258, 
          0.283, 
          0.491, 
          0.289, 
          0.700, 
          0.911, 
          0.260, 
          0.422, 
          0.239, 
          0.288, 
          0.262, 
          0.285, 
          0.357, 
         -9.999, 
          0.385, 
          0.690, 
          0.764, 
          0.659, 
         -9.999, 
          0.672, 
          0.172, 
          0.460, 
          0.382, 
          0.494, 
          1.364, 
          0.609, 
          0.239, 
          0.341, 
          0.426, 
          0.679, 
          0.309, 
          0.686, 
         -9.999, 
          0.335, 
          0.509, 
         -9.999, 
          0.865, 
          0.284, 
          1.500, 
          1.718, 
          0.233, 
          0.473, 
          0.450, 
          1.352, 
          0.568, 
          1.076, 
          0.246, 
          0.298, 
          0.211, 
          0.223, 
          0.727, 
          0.379, 
          0.441, 
         -9.999, 
          0.705, 
          0.302, 
          0.588, 
          0.447, 
          0.219, 
          0.176, 
          0.224, 
          0.922, 
          0.651, 
          0.507, 
          0.693, 
          1.059, 
          0.587, 
         -9.999, 
          0.344, 
          0.359, 
          0.885, 
          0.357, 
          0.253, 
          0.583, 
          0.252, 
          0.602, 
          0.425, 
          0.967, 
          0.270, 
          0.342, 
          0.229, 
         -9.999, 
          0.410, 
          0.856, 
          0.594, 
          0.429, 
          0.341, 
          0.578, 
          0.707, 
          0.440, 
          1.149, 
          0.983, 
          0.687, 
          0.596, 
          0.125, 
          0.679, 
          0.560, 
          0.198, 
          0.293, 
          0.564, 
          0.785, 
          0.537, 
          0.613, 
          0.302, 
          0.623, 
          0.237, 
          0.226, 
          0.564, 
          1.669, 
          0.344, 
          0.329, 
          0.762, 
          0.239, 
          0.603, 
          0.664, 
          0.982, 
          0.153, 
          0.457, 
          0.618, 
          0.832, 
          0.284, 
          1.196, 
          0.799, 
          0.255, 
          0.731, 
          0.831, 
          0.650, 
          0.111, 
         -9.999, 
          0.894, 
          1.421, 
          0.230, 
          0.940, 
          0.550, 
          0.821, 
          0.411, 
          0.312, 
          0.443, 
          0.656, 
          0.128, 
          0.630, 
          0.753, 
          0.500, 
         -9.999, 
          0.253, 
          0.204, 
          0.308, 
         -9.999, 
          0.393, 
          1.656, 
          0.605, 
          0.650, 
          0.599, 
          0.779, 
          0.464, 
          1.134, 
          0.425, 
          1.224, 
          0.212, 
          0.567, 
          0.956, 
          0.319, 
          0.482, 
          0.404, 
          0.241, 
          0.385, 
          0.520, 
          0.253, 
          0.310, 
          0.508, 
          0.310, 
          0.345, 
          0.893, 
          0.587, 
          0.219, 
          0.648, 
          0.601, 
          0.653, 
          0.498, 
          0.541, 
          0.203, 
          0.939, 
          0.458, 
          1.264, 
          0.389, 
          0.786, 
          0.288, 
          0.682, 
          0.652, 
          0.114, 
          1.103, 
          0.314, 
          0.207, 
          0.994, 
          0.223, 
          0.629, 
          0.945, 
          0.554, 
          0.835, 
          0.716, 
          0.451, 
          0.278, 
          0.608, 
          0.525, 
          0.443, 
          0.562, 
          0.342, 
          0.257, 
          0.267, 
          0.749, 
          0.306, 
          0.410, 
          0.271, 
          0.121, 
          0.218, 
          0.951, 
          0.863, 
          0.676, 
         -9.999, 
          0.681, 
          0.536, 
          0.637, 
          0.275, 
          0.788, 
          1.846, 
          0.440, 
          0.493, 
          0.643, 
          0.562, 
          0.512, 
          0.877, 
          1.000, 
          1.375, 
          0.608, 
          0.656, 
          0.571, 
          1.083, 
          0.274, 
          0.383, 
          0.267, 
          0.260, 
          0.670, 
          0.346, 
          0.212, 
          0.256, 
          0.852, 
          0.356, 
          0.702, 
          0.737, 
          0.470, 
          0.455, 
          0.563, 
          0.463, 
          0.394, 
          0.591, 
          0.521, 
          0.261, 
          0.530, 
          0.951, 
          0.480, 
          1.299, 
          0.615, 
          0.307, 
          0.691, 
          0.315, 
          0.755, 
          0.829, 
          0.939, 
          0.344, 
          0.633, 
          0.681, 
          0.833, 
          1.102, 
          0.351, 
          0.603, 
          0.726, 
          0.520, 
          0.740, 
          0.207, 
          0.588, 
          0.759, 
          0.452, 
          0.213, 
          0.257, 
          0.649, 
          0.271, 
          0.602, 
          0.253, 
          1.445, 
          1.101, 
          0.426, 
          0.194, 
          0.318, 
         -9.999, 
          0.227, 
          0.844, 
          0.340, 
          0.469, 
          0.600, 
          0.897, 
          1.861, 
          0.164, 
          0.496, 
          0.513, 
          0.455, 
          0.218, 
          0.392, 
          0.503, 
          0.282, 
          0.534, 
          0.319, 
          0.577, 
          0.348, 
          1.176, 
          0.700, 
          1.267, 
          0.339, 
          0.720, 
          1.191, 
          0.455, 
          0.292, 
          0.255, 
          0.655, 
          0.700, 
          0.983, 
          0.463, 
          0.835, 
          0.237, 
          0.376, 
          0.442, 
          0.474, 
          0.399, 
          0.601, 
          0.524, 
          0.276, 
          0.552, 
          0.579, 
          0.965, 
          0.689, 
          0.461, 
          1.712, 
          0.599, 
          1.281, 
          0.797, 
          1.108, 
          0.505, 
          3.213, 
          0.162, 
          0.299, 
          0.872, 
          0.670, 
          0.552, 
          0.826, 
          0.851, 
          0.359, 
          0.563, 
          0.636, 
          0.294, 
          0.655, 
          0.292, 
          0.131, 
          0.187, 
          0.371, 
          0.363, 
         -9.999, 
          0.570, 
          0.298, 
          0.871, 
          0.465, 
          0.497, 
          0.348, 
          0.345, 
          0.259, 
          0.452, 
          0.591, 
          1.286, 
          0.725, 
          0.975, 
          0.338, 
          0.316, 
          0.533, 
          0.207, 
          0.262, 
         -9.999, 
          0.313, 
          0.547, 
         -9.999, 
          0.844, 
         -9.999, 
          1.934, 
          1.566, 
          0.508, 
          0.430, 
          0.224, 
          1.559, 
          0.246, 
          0.766, 
          0.275, 
          0.375, 
          0.600, 
          0.546, 
          0.778, 
          0.440, 
          0.356, 
          0.499, 
          0.472, 
          0.819, 
          0.375, 
         -9.999, 
          0.225, 
          0.166, 
          0.361, 
          0.679, 
          0.713, 
          0.422, 
          0.642, 
          0.789, 
          0.380, 
         -9.999, 
          0.343, 
          0.589, 
          0.907, 
          0.243, 
          0.401, 
          0.183, 
          0.258, 
          0.603, 
          0.591, 
          1.173, 
          0.251, 
          0.355, 
          0.343, 
          0.560, 
          0.372, 
          0.488, 
          0.551, 
          0.255, 
          0.177, 
          0.340, 
          0.575, 
          0.200, 
          0.956, 
          0.405, 
          0.607, 
          0.524, 
          0.316, 
          0.655, 
          0.689, 
          0.553, 
          0.301, 
          0.261, 
          1.243, 
          0.561, 
          0.557, 
          0.346, 
          0.789, 
          0.178, 
          0.286, 
          0.278, 
          1.620, 
          0.451, 
          0.207, 
          0.555, 
          0.419, 
          0.374, 
          0.890, 
          0.834, 
          0.295, 
          0.428, 
          0.629, 
          0.856, 
          0.732, 
          0.913, 
          0.472, 
          0.518, 
          0.409, 
          0.819, 
          0.773, 
          0.259, 
          0.370, 
          0.825, 
          1.364, 
          0.185, 
          0.844, 
          0.557, 
          0.788, 
          0.306, 
          0.518, 
          0.558, 
          0.473, 
          0.591, 
          0.450, 
          0.684, 
          0.433, 
          0.320, 
          0.420, 
          0.155, 
          0.226, 
         -9.999, 
          0.767, 
          0.401, 
          0.441, 
          0.138, 
          0.329, 
          0.513, 
          0.234, 
          0.283, 
          0.278, 
          0.342, 
          0.314, 
          0.712, 
          0.839, 
          0.413, 
          0.790, 
          0.630, 
          0.904, 
          0.290, 
          0.209, 
          0.380, 
          0.243, 
          0.446, 
         -9.999, 
          0.322, 
         -9.999, 
          0.498, 
          0.261, 
          0.449, 
          0.480, 
          0.511, 
          0.495, 
          0.147, 
          0.175, 
          0.835, 
          0.166, 
          1.263, 
          0.348, 
          0.653, 
          0.153, 
          0.664, 
         -9.999, 
          0.273, 
          0.619, 
          0.864, 
          0.604, 
          0.942, 
          0.469, 
         -9.999, 
          0.973, 
         -9.999, 
          0.869, 
          0.383, 
          0.465, 
          0.247, 
          0.337, 
          0.720, 
          0.397, 
         -9.999, 
          0.221, 
          0.239, 
          0.395, 
          0.463, 
          0.250, 
          0.730, 
          0.209, 
          0.425, 
          0.380, 
          0.752, 
          1.090, 
          0.827, 
          0.240, 
          0.660, 
          1.103, 
          0.609, 
          0.417, 
          0.726, 
          1.553, 
          0.120, 
          0.449, 
          0.517, 
          0.606, 
          0.511, 
          0.531, 
          0.759, 
          0.996, 
          0.814, 
          0.235, 
          0.236, 
          0.969, 
          0.394, 
          0.597, 
          0.234, 
          0.369, 
          0.546, 
          0.367, 
          0.791, 
          0.391, 
          0.883, 
          0.678, 
          0.462, 
          0.815, 
          0.360, 
          0.186, 
          0.575, 
          0.588, 
          0.285, 
          0.361, 
          0.217, 
          0.412, 
          1.013, 
          0.928, 
          0.503, 
          0.628, 
          0.320, 
          0.529, 
          1.114, 
          0.369, 
          0.386, 
          1.223, 
          0.420, 
          0.325, 
          0.489, 
          1.005, 
          0.277, 
          0.451, 
         -9.999, 
          0.444, 
          0.828, 
          0.358, 
          0.695, 
          0.327, 
          0.561, 
          0.339, 
          0.629, 
          0.334, 
          0.366, 
          0.411, 
          0.249, 
          0.899, 
          0.739, 
          1.789, 
          0.368, 
          0.372, 
          0.414, 
          0.409, 
          0.672, 
          1.197, 
          1.352, 
          0.198, 
          0.507, 
          0.641, 
         -9.999, 
         -9.999, 
          0.509, 
          0.842, 
          0.555, 
          0.429, 
          0.262, 
          0.361, 
          0.826, 
          0.608, 
          0.693, 
          0.291, 
          0.628, 
          0.115, 
         -9.999, 
          0.857, 
         -9.999, 
          0.411, 
          0.777, 
          0.382, 
          0.117, 
          0.283, 
          0.239, 
          0.674, 
          0.773, 
          1.294, 
          0.309, 
          0.622, 
          0.429, 
          0.440, 
          0.203, 
          0.615, 
          0.145, 
          0.360, 
          0.439, 
          0.443, 
          0.732, 
          0.291, 
          1.379, 
          0.766, 
          0.684, 
          0.621, 
          0.909, 
          0.788, 
          1.066, 
          1.279, 
          1.067, 
          2.435, 
          1.231, 
          1.063, 
          1.020, 
          0.638, 
          0.957, 
          0.834, 
          0.717, 
          0.618, 
          0.503, 
          0.838, 
          0.342, 
          0.403, 
          0.389, 
          0.206, 
          0.536, 
          0.328, 
          0.278, 
          1.061, 
          1.775, 
         -9.999, 
          0.937, 
          0.604, 
          0.280, 
          0.531, 
          0.387, 
          0.181, 
          0.864, 
          0.440, 
          1.145, 
          1.150, 
          0.595, 
          0.397, 
          1.075, 
          0.348, 
          0.736, 
          1.107, 
          0.380, 
          0.181, 
          0.532, 
         -9.999, 
          0.901, 
          0.832, 
          1.837, 
          0.878, 
          0.178, 
          0.579, 
         -9.999, 
          1.286, 
          0.641, 
          0.780, 
          1.038, 
          0.552, 
          0.683, 
          0.588, 
          1.037, 
          0.702, 
          0.830, 
          0.299, 
          0.611, 
          1.113, 
          0.423, 
         -9.999, 
          0.337, 
          0.765, 
          0.246, 
          0.759, 
          0.812, 
          0.433, 
          1.793, 
          1.441, 
          0.344, 
          0.387, 
          0.232, 
          0.404, 
          0.411, 
          0.433, 
          0.674, 
          0.590, 
          0.804, 
          0.577, 
          0.411, 
          0.674, 
          0.562, 
          0.400, 
          0.404, 
         -9.999, 
          0.299, 
          0.520, 
          0.560, 
          0.795, 
          0.256, 
          0.772, 
          0.940, 
          0.243, 
          0.735, 
          0.791, 
          0.471, 
          0.729, 
          0.291, 
          0.824, 
          0.647, 
          0.356, 
          0.213, 
          0.633, 
          1.185, 
          0.512, 
          0.447, 
          0.414, 
          0.677, 
         -9.999, 
          0.530, 
          0.346, 
          1.431, 
          0.729, 
          0.414, 
          0.683, 
          0.369, 
          0.398, 
          0.947, 
          0.874, 
          0.340, 
          0.322, 
          0.493, 
          0.646, 
          0.306, 
          0.916, 
          0.644, 
          0.337, 
          0.643, 
          1.298, 
          0.766, 
          0.295, 
          0.326, 
          0.932, 
          0.454, 
          0.361, 
          1.107, 
          0.542, 
          0.537, 
          0.410, 
          0.579, 
          0.371, 
          0.566, 
          0.366, 
          0.350, 
          0.862, 
          0.393, 
          0.140, 
          0.263, 
          0.120, 
          0.314, 
          0.212, 
          0.380, 
          1.411, 
          0.326, 
          0.208, 
          0.463, 
          0.389, 
          0.479, 
          0.546, 
          0.302, 
          0.558, 
          0.250, 
          0.707, 
          0.766, 
          0.784, 
          1.065, 
          0.405, 
          0.849, 
         -9.999, 
          0.422, 
          0.194, 
          0.360, 
          0.307, 
          0.893, 
          0.914, 
          0.455, 
          0.414, 
          0.702, 
          0.304, 
         -9.999, 
          0.690, 
          0.383, 
          0.329, 
          0.331, 
          0.147, 
          0.806, 
          1.104, 
          0.430, 
          0.772, 
          0.231, 
          0.362, 
          0.263, 
          0.277, 
          0.342, 
          0.499, 
          0.348, 
          0.755, 
          0.474, 
          0.320, 
          0.511, 
          0.866, 
          0.743, 
         -9.999, 
          0.856, 
          0.269, 
          0.852, 
          0.535, 
          0.271, 
          0.470, 
          0.643, 
          0.922, 
          0.295, 
          0.645, 
          0.248, 
          0.418, 
          0.373, 
          0.720, 
          0.489, 
          0.442, 
          0.933, 
          0.641, 
          0.852, 
          0.410, 
          1.637, 
          0.600, 
          0.390, 
          0.318, 
          1.673, 
          0.329, 
          0.553, 
          0.740, 
          0.859, 
          0.754, 
          1.192, 
          0.562, 
          0.783, 
          0.422, 
          0.510, 
          0.596, 
          0.750, 
          0.695, 
          0.882, 
          0.467, 
          0.625, 
          0.373, 
          0.404, 
          0.270, 
          0.647, 
          0.807, 
          0.669, 
          1.453, 
          0.788, 
          0.692, 
          0.374, 
          0.401, 
          0.550, 
          0.319, 
          0.663, 
          0.719, 
          0.639, 
          0.604, 
          0.378, 
          0.684, 
          0.551, 
          0.536, 
          0.522, 
          0.860, 
          0.569, 
          0.926, 
          1.004, 
          1.285, 
          0.743, 
          0.573, 
          0.295, 
          0.336, 
          0.719, 
          0.821, 
          0.556, 
          0.591, 
          0.376, 
          0.732, 
          0.411, 
         -9.999, 
          0.339, 
          0.297, 
          0.587, 
          0.263, 
          0.173, 
          0.322, 
          0.298, 
          0.362, 
          1.605, 
          0.403, 
          0.442, 
          0.474, 
          0.522, 
          0.356, 
          1.038, 
          1.611, 
          0.751, 
          0.638, 
          0.761, 
          0.596, 
          1.337, 
          0.262, 
          1.032, 
          0.540, 
          0.430, 
          0.534, 
          0.532, 
          0.819, 
          0.853, 
          0.867, 
          0.362, 
          0.746, 
          0.411, 
          0.596, 
          0.756, 
          0.756, 
          0.777, 
          0.741, 
         -9.999, 
          0.203, 
          0.610, 
          0.457, 
          1.298, 
          0.563, 
          1.201, 
          0.303, 
          0.183, 
          0.633, 
          0.315, 
          0.286, 
          1.130, 
          0.374, 
          0.295, 
          0.632, 
          0.538, 
          0.776, 
          0.716, 
          0.700, 
          0.602, 
          0.896, 
          1.012, 
          0.470, 
          1.752, 
          1.684, 
          0.681, 
          0.982, 
          2.398, 
          0.896, 
          1.740, 
          1.340, 
          1.533, 
          1.889, 
          1.563, 
          0.649, 
          0.742, 
          0.996, 
          0.571, 
          0.454, 
          0.323, 
          0.666, 
          0.280, 
          0.364, 
          0.417, 
         -9.999, 
          1.479, 
          1.834, 
          1.400, 
          0.456, 
          0.721, 
          0.550, 
          1.144, 
          0.459, 
          0.399, 
          0.539, 
          1.385, 
          1.573, 
          0.907, 
          0.889, 
          0.860, 
          0.982, 
          0.875, 
          0.725, 
          1.322, 
          1.032, 
          0.886, 
          1.567, 
          0.636, 
          1.851, 
         -9.999, 
          2.906, 
         -9.999, 
          0.766, 
          0.440, 
         -9.999, 
          1.549, 
          1.291, 
          0.790, 
         -9.999, 
          0.489, 
          0.921, 
          0.597, 
          0.543, 
          2.196, 
          0.893, 
          0.449, 
          1.234, 
          0.581, 
          0.694, 
          0.768, 
          0.767, 
          0.939, 
          0.687, 
          0.627, 
          2.119, 
          0.375, 
          1.134, 
         -9.999, 
          0.523, 
          0.561, 
          0.315, 
          0.439, 
          0.755, 
          1.061, 
          0.769, 
          0.614, 
          0.792, 
          0.497, 
          0.442, 
          0.851, 
          0.333, 
          1.242, 
          0.448, 
          0.396, 
         -9.999, 
          0.749, 
          0.495, 
          1.227, 
         -9.999, 
          0.962, 
          0.961, 
          0.521, 
          0.950, 
          1.530, 
          1.337, 
          0.762, 
          0.539, 
          1.583, 
          0.668, 
          0.476, 
          0.456, 
          0.889, 
          2.293, 
          0.726, 
          0.541, 
          0.760, 
          0.345, 
          0.621, 
          0.567, 
          0.974, 
          1.676, 
          1.491, 
          0.537, 
          1.121, 
          0.754, 
          1.860, 
          2.006, 
          0.500, 
          0.544, 
          0.797, 
          1.069, 
          1.313, 
          0.256, 
          1.763, 
          1.018, 
          1.378, 
          1.564, 
          2.294, 
          1.186, 
          0.605, 
          0.252, 
          0.589, 
          1.079, 
          0.228, 
          0.392, 
          0.693, 
          1.088, 
          0.605, 
          0.458, 
          0.506, 
          0.775, 
          0.351, 
          0.244, 
          0.627, 
          0.592, 
         -9.999, 
          0.597, 
          0.468, 
          0.674, 
          0.336, 
          0.418, 
          1.192, 
          0.745, 
          0.806, 
          0.842, 
          0.244, 
          0.766, 
          0.848, 
          0.714, 
          0.613, 
         -9.999, 
          0.408, 
          0.402, 
          0.525, 
          0.355, 
          0.592, 
          1.125, 
          0.282, 
          0.722, 
          0.629, 
          0.427, 
          0.629, 
          0.206, 
          0.849, 
          0.816, 
          0.909, 
          1.195, 
          0.780, 
          0.390, 
          0.310, 
          0.840, 
          0.453, 
          0.505, 
          0.482, 
          0.607, 
          0.945, 
         -9.999, 
          0.791, 
          0.482, 
          0.574, 
          0.350, 
          0.542, 
          0.853, 
          0.588, 
          0.367, 
          1.116, 
          0.170, 
          0.381, 
          0.424, 
          0.353, 
          0.606, 
          0.434, 
          0.826, 
          0.741, 
          1.005, 
          0.545, 
          0.486, 
         -9.999, 
          0.558, 
          0.658, 
          0.682, 
          0.350, 
          0.258, 
         -9.999, 
          1.030, 
         -9.999, 
          0.145, 
          0.193, 
          0.557, 
          0.420, 
          0.211, 
          0.449, 
          2.353, 
          0.576, 
          0.854, 
          1.523, 
         -9.999, 
          0.996, 
          1.875, 
         -9.999, 
          0.672, 
          0.540, 
          1.343, 
          1.050, 
          0.746, 
          0.270, 
          0.358, 
          0.524, 
          1.089, 
          0.625, 
          0.762, 
          0.256, 
          0.672, 
          0.542, 
          0.582, 
          0.382, 
          0.459, 
          1.135, 
          0.540, 
          0.891, 
         -9.999, 
          0.958, 
          0.187, 
          1.522, 
          0.498, 
          0.457, 
          0.598, 
          0.320, 
          0.313, 
          0.724, 
          0.522, 
          0.852, 
          1.366, 
          0.863, 
          1.141, 
          0.754, 
          1.316, 
          0.685, 
          0.717, 
          0.393, 
          0.434, 
          0.439, 
          0.571, 
          0.403, 
          0.625, 
          0.598, 
         -9.999, 
          0.276, 
          0.425, 
          0.253, 
          0.417, 
          0.433, 
          0.403, 
          0.278, 
          0.416, 
          0.308, 
          0.235, 
          0.383, 
          0.437, 
          0.598, 
          0.788, 
          0.426, 
          0.741, 
          0.704, 
          1.026, 
          0.798, 
          2.232, 
          2.225, 
          0.518, 
          0.588, 
         -9.999, 
          1.485, 
          1.487, 
          0.412, 
          0.447, 
          0.757, 
          0.774, 
          0.413, 
          0.823, 
          1.709, 
          0.861, 
          0.511, 
          0.459, 
          0.492, 
          1.124, 
          0.632, 
          0.670, 
          0.502, 
          0.284, 
          0.777, 
         -9.999, 
          0.460, 
          1.258, 
          0.581, 
          0.614, 
          0.681, 
          0.937, 
          0.535, 
          0.599, 
          0.844, 
          0.505, 
          0.683, 
          1.152, 
          0.607, 
          0.395, 
          0.723, 
          0.314, 
          0.456, 
          0.361, 
          0.448, 
          0.272, 
          0.775, 
          1.475, 
          1.241, 
          1.987, 
          1.585, 
          1.470, 
          1.298, 
          2.232, 
          0.581, 
          1.731, 
          1.731, 
          1.477, 
          1.525, 
          1.694, 
          0.708, 
          0.884, 
          0.663, 
         -9.999, 
          0.310, 
          0.382, 
          0.434, 
          0.220, 
          0.389, 
          0.226, 
          0.374, 
          0.647, 
          1.361, 
          0.476, 
          0.163, 
          0.825, 
         -9.999, 
          0.674, 
         -9.999, 
          0.706, 
          0.669, 
          1.047, 
         -9.999, 
          1.280, 
          0.983, 
          0.679, 
          0.404, 
          0.898, 
          1.315, 
          1.366, 
         -9.999, 
          0.508, 
          0.690, 
          0.807, 
          1.262, 
          0.280, 
          3.351, 
          0.634, 
          0.633, 
          1.254, 
          0.266, 
          1.073, 
          0.772, 
          0.649, 
          0.332, 
          0.374, 
          1.741, 
          0.575, 
          0.580, 
          0.744, 
          0.369, 
          0.462, 
          0.288, 
          1.646, 
          0.928, 
          0.619, 
          1.251, 
          1.411, 
          1.180, 
          1.508, 
          1.511, 
          0.394, 
          1.879, 
          0.485, 
          0.600, 
         -9.999, 
          0.451, 
          0.466, 
          0.669, 
          0.627, 
          0.670, 
          0.418, 
          0.548, 
          0.286, 
          0.358, 
         -9.999, 
          0.609, 
          0.944, 
          0.825, 
          0.192, 
          0.405, 
          0.924, 
          0.498, 
          1.341, 
          0.536, 
          1.695, 
          1.151, 
          0.370, 
          0.982, 
          0.659, 
          1.090, 
          0.696, 
          0.431, 
          1.367, 
          0.413, 
          0.436, 
          0.467, 
          0.815, 
          2.318, 
          0.835, 
          0.513, 
          1.112, 
          0.315, 
          0.510, 
          0.407, 
          0.749, 
          1.674, 
          1.707, 
          0.327, 
          1.088, 
          0.636, 
          1.274, 
          1.654, 
          0.194, 
          0.434, 
          1.015, 
          1.310, 
          1.226, 
          0.433, 
          1.171, 
          2.068, 
          1.362, 
          1.971, 
          1.612, 
          1.599, 
          0.714, 
          0.381, 
          1.140, 
          0.797, 
          0.510, 
          0.434, 
          0.388, 
          0.578, 
          0.368, 
          0.718, 
          0.701, 
          0.829, 
          0.270, 
          0.184, 
          0.504, 
          0.841, 
          0.439, 
          0.314, 
          0.834, 
          0.513, 
         -9.999, 
          0.619, 
          1.332, 
          0.784, 
          0.567, 
          0.787, 
          0.497, 
          0.642, 
          0.952, 
          0.703, 
          0.280, 
         -9.999, 
          0.565, 
          0.277, 
          0.662, 
          0.435, 
         -9.999, 
          1.537, 
          0.227, 
          0.346, 
          0.496, 
          0.255, 
          0.320, 
          0.319, 
          0.857, 
          0.658, 
          0.359, 
          0.715, 
          0.889, 
          0.494, 
          0.296, 
          1.087, 
          0.568, 
          0.306, 
          0.498, 
          0.897, 
          0.793, 
          0.582, 
          1.142, 
          0.388, 
          0.709, 
          0.235, 
          0.565, 
          1.165, 
          0.554, 
          0.675, 
          1.209, 
          0.805, 
          0.688, 
          0.798, 
          1.086, 
          1.458, 
          1.002, 
          0.440, 
          0.997, 
          0.764, 
          0.497, 
          0.372, 
          0.462, 
          0.351, 
          0.296, 
          0.926, 
          0.427, 
         -9.999, 
          0.631, 
          1.038, 
          0.649, 
          0.270, 
          0.222, 
          1.071, 
          0.767, 
          0.363, 
          0.521, 
          2.164, 
          0.604, 
          0.982, 
          1.246, 
          1.156, 
         -9.999, 
          1.298, 
          0.496, 
          0.803, 
          0.319, 
          1.277, 
          0.616, 
          0.775, 
          0.381, 
          0.358, 
          0.507, 
          0.791, 
          0.395, 
          1.165, 
          0.353, 
          0.861, 
          0.930, 
          0.524, 
          0.532, 
          0.278, 
          0.752, 
          0.308, 
          0.735, 
          0.710, 
          1.176, 
          0.707, 
          1.381, 
          0.670, 
          0.449, 
          0.499, 
          0.424, 
          0.699, 
          0.558, 
          1.177, 
          1.242, 
          0.629, 
          0.684, 
          0.852, 
          0.700, 
          0.544, 
          1.029, 
          1.020, 
          0.589, 
          0.810, 
          0.496, 
          0.527, 
          0.706, 
          0.633, 
          0.801, 
          0.377, 
          0.384, 
          0.538, 
          0.676, 
          0.322, 
          0.242, 
          0.546, 
          0.177, 
          0.408, 
          0.440, 
          0.439, 
          0.346, 
          0.424, 
          0.298, 
          0.594, 
          0.497, 
          0.769, 
          0.666, 
          0.648, 
          1.326, 
          1.426, 
          2.384, 
          1.083, 
          0.671, 
          0.677, 
          0.796, 
          0.999, 
          0.352, 
          0.739, 
          0.900, 
         -9.999, 
          0.291, 
          1.286, 
          1.304, 
          0.664, 
          0.504, 
          0.243, 
          0.646, 
          0.419, 
          0.493, 
          0.566, 
          0.236, 
          0.682, 
          0.597, 
          0.838, 
          0.558, 
          0.690, 
          0.318, 
          0.838, 
          1.010, 
          0.962, 
          0.400, 
          0.585, 
          0.512, 
          0.695, 
         -9.999, 
          1.157, 
          0.259, 
          0.740, 
          0.233, 
          0.439, 
          0.549, 
          0.448, 
          0.520, 
          0.528, 
          0.762, 
         -9.999, 
          0.842, 
          1.761, 
          1.323, 
          1.421, 
          0.832, 
          2.324, 
          0.601, 
          1.588, 
          1.520, 
          1.298, 
          1.648, 
          1.130, 
          1.558, 
          0.813, 
          0.555, 
          0.336, 
          0.414, 
          0.481, 
          0.350, 
         -9.999, 
          0.445, 
          0.310, 
          0.569, 
          0.875, 
          1.675, 
          0.783, 
          0.894, 
          0.816, 
          0.271, 
          1.095, 
          0.651, 
          0.489, 
          0.659, 
          1.362, 
          0.787, 
          0.663, 
          0.534, 
          1.105, 
          0.910, 
          0.922, 
          0.669, 
          1.269, 
          0.958, 
          0.478, 
          0.382, 
          0.726, 
          1.556, 
         -9.999, 
          2.778, 
          0.865, 
          1.038, 
          0.757, 
          0.176, 
          1.391, 
          0.829, 
          0.609, 
         -9.999, 
          0.460, 
          0.681, 
          0.460, 
          0.930, 
          0.407, 
          0.616, 
          0.547, 
          0.887, 
          1.338, 
          0.553, 
          0.419, 
          0.648, 
          0.841, 
          0.863, 
          1.372, 
          1.070, 
          1.263, 
          2.328, 
          0.698, 
          1.141, 
         -9.999, 
          0.471, 
          0.756, 
          0.507, 
          0.637, 
          0.981, 
         -9.999, 
          0.529, 
          0.485, 
          0.464, 
          0.862, 
          0.262, 
          0.586, 
          0.449, 
          0.686, 
          0.454, 
          0.469, 
          0.785, 
          0.905, 
          0.603, 
          1.849, 
          0.891, 
          0.312, 
          0.520, 
          0.825, 
          1.467, 
          0.558, 
          0.514, 
          1.349, 
          0.436, 
         -9.999, 
          0.585, 
          0.526, 
          1.552, 
          1.025, 
          0.410, 
          0.875, 
          0.748, 
          0.538, 
          0.579, 
          0.612, 
          1.500, 
          1.054, 
         -9.999, 
          1.331, 
          0.779, 
          1.699, 
          1.377, 
          0.756, 
          0.260, 
          0.744, 
          1.600, 
          1.145, 
          0.601, 
          0.980, 
          1.738, 
          1.362, 
          1.168, 
          1.999, 
          1.226, 
          1.083, 
          0.472, 
          0.614, 
          0.889, 
          0.569, 
          0.731, 
          0.587, 
          0.722, 
          0.288, 
          0.449, 
          0.613, 
          0.466, 
          0.454, 
          0.509, 
         -9.999, 
          0.534, 
          0.226, 
          0.567, 
          0.169, 
          0.321, 
          0.377, 
          0.323, 
          1.080, 
          0.516, 
          0.606, 
          0.880, 
          0.480, 
          0.693, 
          0.666, 
          0.542, 
         -9.999, 
         -9.999, 
          1.304, 
          0.648, 
          0.950, 
          0.570, 
          0.956, 
          0.676, 
          0.204, 
          0.610, 
          0.643, 
          0.321, 
          0.558, 
          0.338, 
          0.624, 
          0.964, 
          1.221, 
          0.773, 
          0.346, 
          0.497, 
          0.493, 
          0.571, 
          0.572, 
          0.535, 
          0.599, 
          0.734, 
          1.123, 
          0.334, 
          0.912, 
          0.545, 
          0.622, 
          0.317, 
          0.647, 
          1.039, 
          0.401, 
          0.383, 
          0.453, 
          0.268, 
         -9.999, 
          0.817, 
          0.541, 
          0.542, 
          0.834, 
          0.548, 
          0.714, 
          0.441, 
          0.597, 
          0.544, 
          0.377, 
          0.492, 
          0.775, 
          0.625, 
          0.476, 
          0.325, 
          0.857, 
          0.559, 
          0.770, 
         -9.999, 
          0.324, 
          1.116, 
          0.479, 
          0.408, 
          0.519, 
          1.661, 
          0.566, 
          0.211, 
          1.222, 
         -9.999, 
         -9.999, 
          1.113, 
          0.912, 
          0.486, 
          0.737, 
          0.631, 
          0.439, 
          0.678, 
          0.290, 
          0.319, 
          0.702, 
          0.510, 
          0.187, 
          0.890, 
          0.875, 
          0.323, 
          0.269, 
          0.251, 
          0.294, 
          0.446, 
          0.347, 
          0.480, 
          0.962, 
          0.623, 
          0.836, 
          0.365, 
          1.800, 
         -9.999, 
          0.706, 
          0.469, 
          0.614, 
          0.482, 
          0.729, 
          0.307, 
          0.618, 
          0.638, 
          0.692, 
          1.002, 
          0.791, 
          1.561, 
          0.498, 
          1.060, 
          0.458, 
          0.991, 
          0.528, 
          0.508, 
          0.991, 
          1.044, 
         -9.999, 
          0.374, 
          0.702, 
          0.212, 
          0.420, 
          0.745, 
          0.482, 
         -9.999, 
         -9.999, 
          0.544, 
          0.518, 
          0.403, 
          0.331, 
         -9.999, 
         -9.999, 
          0.880, 
          0.663, 
          0.532, 
         -9.999, 
          0.647, 
          0.565, 
          1.007, 
          2.451, 
          0.461, 
          0.350, 
         -9.999, 
         -9.999, 
          0.768, 
          0.374, 
          0.446, 
          0.909, 
         -9.999, 
          0.509, 
          0.768, 
          1.585, 
          0.816, 
          0.525, 
          0.154, 
          0.662, 
          0.246, 
          0.366, 
          0.815, 
          0.517, 
          0.394, 
          1.684, 
          0.894, 
          0.416, 
          0.809, 
          0.665, 
          0.567, 
          1.118, 
          0.598, 
          0.502, 
          0.821, 
          0.560, 
          0.391, 
          0.649, 
          0.830, 
          0.553, 
          0.269, 
          0.610, 
          0.286, 
         -9.999, 
          0.249, 
          0.764, 
          0.353, 
          0.930, 
          0.752, 
          1.030, 
          1.618, 
          1.891, 
          1.940, 
          1.293, 
          1.443, 
          0.388, 
          1.082, 
          1.564, 
          1.337, 
          1.851, 
          1.820, 
          0.719, 
          1.049, 
          0.362, 
          1.090, 
          0.339, 
          0.257, 
          0.529, 
          0.371, 
          0.416, 
          0.511, 
          0.386, 
          1.032, 
          1.605, 
          0.305, 
          0.357, 
          0.366, 
          0.200, 
          1.402, 
          0.709, 
          0.571, 
          0.935, 
          1.419, 
          0.931, 
          0.211, 
          0.905, 
          0.297, 
          0.456, 
          0.639, 
          1.562, 
          0.378, 
          0.924, 
          0.935, 
          0.599, 
          1.588, 
          0.841, 
          0.158, 
          2.531, 
          1.336, 
          0.594, 
          0.476, 
          0.242, 
          1.422, 
          1.225, 
          0.926, 
          0.688, 
          0.251, 
         -9.999, 
          0.328, 
          0.347, 
          0.341, 
          0.500, 
          0.089, 
          0.499, 
          1.208, 
          0.951, 
          0.832, 
          0.721, 
          0.534, 
          1.193, 
          1.417, 
          1.580, 
          1.252, 
          1.561, 
          0.462, 
          0.325, 
          0.432, 
          0.514, 
          0.528, 
          0.683, 
          1.387, 
          1.180, 
          0.737, 
          0.699, 
          0.465, 
          0.401, 
          0.900, 
          0.610, 
          0.832, 
          0.363, 
          0.539, 
          0.522, 
          0.593, 
          0.259, 
          1.255, 
          0.394, 
          1.030, 
          1.276, 
          0.560, 
          0.818, 
          1.209, 
          1.676, 
          1.046, 
          0.335, 
          1.337, 
          1.246, 
          0.540, 
          0.449, 
          1.016, 
          2.092, 
          1.192, 
          0.782, 
          0.860, 
          0.246, 
          0.426, 
          0.333, 
          0.726, 
          2.060, 
          1.819, 
          0.371, 
          1.251, 
          0.798, 
          2.102, 
          1.770, 
          0.333, 
          0.142, 
          0.558, 
          0.951, 
          1.390, 
          0.315, 
          1.299, 
          1.608, 
          1.220, 
          1.500, 
          1.835, 
          1.274, 
          0.423, 
          0.413, 
          1.310, 
          0.971, 
          0.094, 
          0.564, 
          0.730, 
          0.760, 
          0.436, 
          0.489, 
          0.857, 
          1.017, 
          0.229, 
          0.292, 
          1.152, 
          1.048, 
          0.529, 
          0.181, 
          0.196, 
          0.555, 
          0.366, 
          0.677, 
         -9.999, 
          0.759, 
          0.187, 
          0.704, 
          0.376, 
          0.185, 
          0.851, 
          0.561, 
          0.516, 
          0.527, 
          0.471, 
          0.339, 
          1.341, 
         -9.999, 
          0.699, 
          1.416, 
          0.412, 
          0.334, 
         -9.999, 
          0.653, 
          0.375, 
         -9.999, 
          1.038, 
         -9.999, 
          0.421, 
          0.567, 
          0.737, 
          0.287, 
          0.474, 
          1.168, 
          0.541, 
          0.379, 
          0.612, 
          1.078, 
          1.637, 
          0.271, 
          1.051, 
         -9.999, 
          1.091, 
          0.264, 
          0.481, 
          1.208, 
          0.459, 
          0.589, 
          0.601, 
          0.548, 
          0.334, 
          0.236, 
          0.516, 
          0.994, 
          0.428, 
          1.251, 
         -9.999, 
          0.737, 
          0.311, 
          0.303, 
          0.460, 
          0.233, 
          0.462, 
          0.448, 
          0.268, 
          0.114, 
          0.292, 
          0.528, 
          0.406, 
          0.283, 
          0.699, 
         -9.999, 
          0.515, 
          0.574, 
          0.302, 
          2.383, 
          0.639, 
          0.927, 
          2.131, 
          1.178, 
          0.167, 
          2.057, 
          0.769, 
          0.599, 
          0.561, 
          0.524, 
          0.697, 
          0.615, 
          0.612, 
          0.490, 
          0.806, 
          0.608, 
          0.614, 
          0.990, 
          0.316, 
          0.743, 
          0.957, 
          0.395, 
          0.457, 
          0.315, 
          0.642, 
          0.431, 
          0.689, 
          0.359, 
          1.142, 
          0.428, 
          1.501, 
          1.030, 
          0.954, 
          0.684, 
          0.970, 
          0.349, 
          1.094, 
          0.785, 
          1.073, 
          0.804, 
          1.130, 
          0.618, 
          0.490, 
          0.657, 
          0.613, 
          1.089, 
          1.634, 
          0.359, 
          0.360, 
          0.395, 
          0.705, 
          0.802, 
          0.623, 
          0.205, 
          0.260, 
         -9.999, 
          0.402, 
          0.447, 
          0.393, 
         -9.999, 
         -9.999, 
         -9.999, 
          0.381, 
          0.518, 
          0.273, 
          0.455, 
          0.435, 
          0.546, 
          0.423, 
          0.554, 
         -9.999, 
          0.557, 
          1.015, 
          1.731, 
          2.609, 
          0.244, 
          0.553, 
          0.987, 
          0.663, 
          1.018, 
          0.268, 
          1.272, 
          0.575, 
          0.261, 
          0.723, 
          1.252, 
          1.292, 
          0.725, 
          0.408, 
          0.547, 
          0.873, 
          1.107, 
          1.091, 
         -9.999, 
          0.920, 
          0.341, 
          0.988, 
          0.382, 
          0.537, 
          1.471, 
          0.765, 
          0.463, 
          1.284, 
         -9.999, 
          0.660, 
          1.472, 
          1.073, 
          0.788, 
          0.218, 
          0.495, 
          0.309, 
          0.204, 
          0.712, 
          0.237, 
          0.301, 
          0.137, 
          0.540, 
          0.514, 
          0.945, 
          0.483, 
          1.169, 
          1.549, 
          1.623, 
          1.525, 
          1.403, 
          1.425, 
          0.408, 
          1.670, 
          1.505, 
          1.341, 
          1.816, 
          2.001, 
          1.292, 
          0.859, 
          0.451, 
          0.600, 
          0.177, 
          0.744, 
          0.376, 
          0.363, 
         -9.999, 
          0.430, 
          0.183, 
          1.290, 
          1.327, 
          0.265, 
          0.545, 
          0.240, 
          0.216, 
          1.056, 
          0.798, 
          0.408, 
          0.483, 
          1.310, 
          0.760, 
          0.411, 
          0.508, 
          0.377, 
          1.296, 
          0.784, 
          1.164, 
          1.327, 
          0.793, 
          0.970, 
          0.535, 
          0.988, 
          1.084, 
          0.351, 
          2.049, 
          1.082, 
          0.528, 
          0.478, 
          0.224, 
          1.370, 
          0.909, 
          0.964, 
          0.359, 
          0.623, 
          0.664, 
          0.469, 
          0.258, 
          0.318, 
          0.617, 
          0.353, 
          0.445, 
          1.273, 
          0.327, 
          0.547, 
          0.372, 
          0.628, 
          0.851, 
          1.442, 
          1.503, 
          1.165, 
          1.567, 
          0.665, 
          0.148, 
          0.237, 
          0.596, 
          0.335, 
          0.354, 
          1.148, 
          0.475, 
          0.603, 
          0.740, 
          0.376, 
          0.379, 
          1.122, 
          0.660, 
          0.586, 
          0.732, 
          0.216, 
          0.458, 
          0.704, 
          0.308, 
          1.175, 
          0.264, 
          1.377, 
          1.306, 
          0.424, 
          0.895, 
          1.322, 
          1.417, 
          0.869, 
          0.527, 
          1.372, 
          1.116, 
          0.295, 
          0.178, 
          1.338, 
          2.148, 
          0.972, 
          0.403, 
          0.695, 
          0.258, 
          0.410, 
          0.613, 
          1.124, 
          2.065, 
          1.510, 
          0.310, 
          1.291, 
          0.603, 
          1.744, 
          1.683, 
          0.628, 
          0.450, 
          0.713, 
          1.319, 
          1.163, 
          0.419, 
          1.482, 
          1.561, 
          1.032, 
          1.233, 
          1.660, 
          1.225, 
          0.587, 
          0.273, 
          0.985, 
          1.139, 
          0.345, 
          0.556, 
          0.718, 
          0.789, 
          0.941, 
          0.364, 
          0.653, 
          0.782, 
          0.500, 
          0.360, 
          0.495, 
          0.909, 
          0.182, 
          0.222, 
          0.549, 
          0.499, 
          0.315, 
          0.521, 
          1.205, 
          0.999, 
          0.555, 
          0.404, 
          0.266, 
          0.478, 
          0.592, 
          0.268, 
          0.466, 
          0.390, 
          0.470, 
          0.361, 
          0.463, 
          0.458, 
          0.642, 
          1.186, 
          0.482, 
          0.507, 
         -9.999, 
          0.216, 
          0.796, 
          0.656, 
          0.864, 
          0.613, 
          0.651, 
          0.790, 
          0.752, 
          0.181, 
          0.403, 
          1.002, 
          0.686, 
          0.176, 
         -9.999, 
          0.724, 
          1.137, 
          0.354, 
          1.004, 
          0.289, 
          0.877, 
          0.359, 
          0.162, 
          0.907, 
          0.571, 
          0.452, 
          0.458, 
          0.407, 
          0.325, 
          0.264, 
          0.389, 
          1.129, 
          0.458, 
          0.697, 
         -9.999, 
          0.304, 
          0.349, 
          0.286, 
          0.121, 
          0.208, 
          0.708, 
          0.405, 
          0.244, 
          0.186, 
          0.618, 
          0.383, 
          0.338, 
          0.479, 
          0.425, 
          0.265, 
          0.717, 
          0.831, 
          0.240, 
          2.744, 
          0.541, 
          0.691, 
          1.693, 
          1.542, 
          0.539, 
          1.233, 
          0.503, 
          0.556, 
          0.419, 
          0.651, 
          0.738, 
          0.740, 
          0.174, 
          0.237, 
          1.003, 
          0.231, 
          0.493, 
          1.471, 
          0.622, 
          0.686, 
          0.849, 
          0.602, 
          0.483, 
          0.526, 
          0.619, 
          0.623, 
          0.736, 
          0.456, 
          1.211, 
          0.210, 
          1.577, 
          0.705, 
          0.550, 
          0.858, 
          0.353, 
          0.690, 
          0.756, 
          0.611, 
          1.016, 
          0.814, 
          1.313, 
          1.202, 
          0.280, 
          0.857, 
          0.366, 
          0.713, 
          1.806, 
          0.750, 
          0.392, 
          0.529, 
          0.280, 
          0.755, 
          0.487, 
          0.299, 
          0.434, 
          0.511, 
          0.293, 
          0.422, 
          0.553, 
          0.242, 
          0.187, 
          0.886, 
          0.334, 
          0.255, 
          0.199, 
          0.350, 
          0.328, 
          0.534, 
          0.690, 
          0.405, 
         -9.999, 
          0.365, 
          0.229, 
          2.019, 
          2.074, 
          0.261, 
          0.655, 
          0.620, 
          0.860, 
          1.173, 
          0.460, 
          1.004, 
          0.943, 
          0.274, 
          0.692, 
          1.181, 
          1.269, 
          0.756, 
          0.356, 
          0.354, 
          1.033, 
          0.821, 
          0.442, 
         -9.999, 
          0.644, 
          0.287, 
          0.775, 
          0.414, 
          0.434, 
          1.540, 
          0.652, 
          0.781, 
          0.876, 
         -9.999, 
          0.605, 
          0.970, 
          0.930, 
          0.338, 
          0.222, 
          0.594, 
          0.529, 
          0.415, 
          0.468, 
          0.590, 
         -9.999, 
         -9.999, 
          0.758, 
          0.470, 
          0.275, 
          0.070, 
          1.750, 
          2.028, 
          2.293, 
          2.565, 
          2.573, 
          2.066, 
          0.646, 
          2.320, 
          2.039, 
          2.460, 
          2.229, 
          2.240, 
          1.288, 
          1.057, 
          0.498, 
          1.201, 
          0.683, 
          0.843, 
          0.586, 
          0.347, 
          0.193, 
          0.259, 
          0.411, 
          1.372, 
          2.046, 
          0.477, 
          0.561, 
          0.419, 
          0.167, 
          1.924, 
          0.817, 
          0.626, 
          1.113, 
         -9.999, 
          0.822, 
          0.700, 
          1.181, 
          1.109, 
          0.727, 
          1.100, 
          1.125, 
          1.088, 
          0.965, 
          1.247, 
          1.106, 
          0.912, 
          1.199, 
          0.247, 
          3.003, 
         -9.999, 
          0.722, 
          1.276, 
          0.206, 
          0.678, 
          1.547, 
          1.055, 
          0.372, 
          0.344, 
          0.477, 
          0.492, 
          0.342, 
          0.829, 
          0.630, 
          0.219, 
          0.978, 
          1.446, 
          0.581, 
          0.815, 
          0.953, 
          0.980, 
          1.204, 
          1.052, 
          1.974, 
          1.635, 
          2.135, 
          0.518, 
          0.199, 
          0.173, 
          0.260, 
          0.856, 
          0.969, 
          1.848, 
          1.047, 
          0.867, 
          1.199, 
          0.623, 
          0.590, 
          1.006, 
          0.382, 
          1.299, 
          0.372, 
          0.555, 
          0.319, 
          0.586, 
          0.383, 
          1.447, 
          0.418, 
          1.496, 
          1.410, 
          0.761, 
          1.208, 
          1.681, 
          2.247, 
          1.237, 
          0.652, 
          1.629, 
          1.641, 
          0.353, 
          0.261, 
          1.192, 
          2.598, 
          1.385, 
          1.061, 
          0.980, 
          0.611, 
          0.399, 
          1.487, 
          1.157, 
          2.557, 
          2.261, 
          0.268, 
          1.839, 
          1.339, 
          2.266, 
          2.548, 
          0.535, 
          0.712, 
          0.800, 
          1.305, 
          1.446, 
          0.243, 
          2.026, 
          1.874, 
          1.749, 
          2.234, 
          2.177, 
          1.291, 
          0.921, 
          0.553, 
          1.291, 
          1.259, 
          0.279, 
          0.800, 
          0.905, 
          1.048, 
          1.743, 
          0.445, 
          1.054, 
          1.348, 
          0.495, 
          0.633, 
          0.884, 
          1.295, 
          0.416, 
          0.208, 
          0.523, 
          0.752, 
          0.315, 
          0.898, 
          0.403, 
          1.053, 
          0.368, 
          0.618, 
          0.335, 
          0.934, 
          1.228, 
          0.637, 
          0.760, 
          0.696, 
          0.598, 
          0.399, 
          1.120, 
          0.923, 
          0.458, 
          1.184, 
          0.248, 
          0.858, 
          0.906, 
          0.772, 
          0.923, 
          0.410, 
          1.044, 
          0.785, 
          0.370, 
          1.046, 
          0.909, 
          0.262, 
          0.581, 
          1.268, 
          1.014, 
          0.489, 
          0.885, 
          1.190, 
          1.936, 
          0.443, 
          1.331, 
          0.743, 
          1.071, 
          0.365, 
          0.330, 
          1.185, 
          0.520, 
          0.534, 
          1.001, 
          0.662, 
         -9.999, 
          0.443, 
          0.463, 
          1.628, 
          0.900, 
         -9.999, 
          0.259, 
          0.961, 
          0.263, 
          0.164, 
          0.263, 
          0.247, 
          0.790, 
          0.594, 
          0.819, 
         -9.999, 
          0.163, 
          0.713, 
          0.460, 
          0.403, 
          0.394, 
          0.856, 
          0.324, 
          0.689, 
          0.223, 
          2.652, 
          1.224, 
          1.810, 
          1.264, 
          1.429, 
          0.334, 
          1.720, 
          0.862, 
          0.672, 
          0.626, 
          0.831, 
          1.319, 
          0.702, 
          0.515, 
          0.363, 
          1.407, 
          0.523, 
          0.808, 
          2.273, 
          0.914, 
          1.090, 
          1.282, 
          0.393, 
          0.354, 
          0.524, 
          0.833, 
          0.654, 
         -9.999, 
          0.285, 
          1.506, 
          0.497, 
          2.357, 
          0.994, 
          1.095, 
          1.017, 
          0.905, 
          0.723, 
          1.013, 
          0.953, 
          1.128, 
          0.941, 
          1.253, 
          0.291, 
          0.463, 
          0.830, 
          0.966, 
          0.676, 
          1.587, 
          0.746, 
          0.427, 
          1.181, 
          0.659, 
          0.971, 
         -9.999, 
          0.295, 
          0.435, 
          0.401, 
          0.501, 
          0.249, 
          0.428, 
          0.311, 
          0.379, 
          2.918, 
          0.273, 
          0.152, 
          0.345, 
          0.266, 
          0.476, 
          0.881, 
          0.880, 
          0.751, 
          0.221, 
         -9.999, 
          0.412, 
          2.291, 
          3.264, 
          0.427, 
          0.796, 
          1.113, 
          1.011, 
          1.582, 
          0.545, 
          1.724, 
          1.366, 
          0.264, 
          0.784, 
          1.934, 
          2.174, 
          1.318, 
          0.569, 
          0.633, 
          1.491, 
          1.854, 
          1.030, 
          1.732, 
          0.999, 
          0.472, 
          0.981, 
          0.425, 
         -9.999, 
          1.549, 
          1.198, 
          0.721, 
          1.909, 
          1.857, 
          1.377, 
          2.140, 
          2.348, 
          1.201, 
          0.186, 
          0.535, 
          0.356, 
          0.494, 
         -9.999, 
          0.552, 
          0.297, 
         -9.999, 
          0.811, 
          0.510, 
          1.127, 
          0.296, 
          1.108, 
          0.868, 
          0.849, 
          0.984, 
          0.481, 
          2.278, 
          0.561, 
          1.362, 
          1.312, 
          1.102, 
          0.734, 
          1.232, 
          1.512, 
          0.480, 
          1.002, 
          0.515, 
          0.319, 
          0.561, 
          0.676, 
          0.461, 
          0.476, 
          0.486, 
          0.211, 
          0.774, 
          0.964, 
          0.558, 
          1.045, 
          0.580, 
         -9.999, 
          0.707, 
          0.445, 
          0.483, 
          0.826, 
         -9.999, 
         -9.999, 
          1.082, 
          0.496, 
          0.440, 
          1.178, 
          1.241, 
          1.340, 
          1.933, 
          0.810, 
          0.435, 
          0.296, 
          1.554, 
          0.434, 
          0.623, 
          1.493, 
         -9.999, 
          0.821, 
          0.572, 
          0.726, 
          1.083, 
          0.610, 
          0.729, 
          0.887, 
          0.654, 
          0.306, 
          0.709, 
          0.607, 
          1.020, 
          0.652, 
          0.292, 
          0.901, 
          0.794, 
          0.550, 
         -9.999, 
          0.563, 
          0.675, 
          0.862, 
          0.258, 
          0.978, 
          0.809, 
          0.990, 
          1.004, 
          0.623, 
          0.336, 
          0.559, 
          0.777, 
          0.486, 
          0.500, 
          0.252, 
          0.265, 
          0.882, 
          0.493, 
         -9.999, 
          0.992, 
          0.414, 
          0.587, 
          0.916, 
         -9.999, 
          0.553, 
          0.733, 
          0.505, 
          0.613, 
          0.395, 
          1.085, 
          0.870, 
          0.202, 
          0.549, 
          1.084, 
          0.812, 
          0.525, 
          0.416, 
          0.899, 
          1.400, 
          0.559, 
          0.326, 
          0.759, 
          1.216, 
          0.560, 
          0.577, 
          1.223, 
          0.556, 
          0.289, 
          0.558, 
          0.872, 
          1.514, 
          1.224, 
          0.325, 
          0.900, 
          0.570, 
          0.152, 
          0.936, 
          0.494, 
          0.425, 
          0.383, 
          0.282, 
          1.124, 
          0.779, 
          0.688, 
          0.576, 
          0.656, 
          0.528, 
          1.645, 
          0.773, 
          0.520, 
          0.652, 
          0.810, 
          1.085, 
          0.351, 
          0.428, 
          0.231, 
          0.515, 
          0.677, 
          0.254, 
          0.303, 
          0.508, 
          0.289, 
          0.518, 
         -9.999, 
          0.939, 
          0.331, 
          0.255, 
          0.307, 
          0.335, 
          0.491, 
          0.272, 
          0.339, 
          0.350, 
          0.171, 
          0.207, 
          0.331, 
          0.547, 
          1.049, 
          0.188, 
          0.296, 
          0.748, 
          0.463, 
          0.328, 
          0.311, 
          0.468, 
          0.730, 
          1.089, 
          0.262, 
          0.235, 
          0.878, 
          0.692, 
          0.526, 
          0.406, 
          0.381, 
          0.974, 
          0.214, 
          0.611, 
          0.152, 
          0.472, 
          0.423, 
          0.511, 
          0.627, 
          0.295, 
          0.371, 
          0.478, 
          0.693, 
          0.568, 
          0.608, 
          0.215, 
          0.551, 
         -9.999, 
          0.291, 
          0.613, 
          0.443, 
          0.331, 
          0.878, 
          0.310, 
         -9.999, 
         -9.999, 
          0.544, 
          1.325, 
          0.544, 
         -9.999, 
          0.459, 
          0.484, 
          0.467, 
          0.419, 
          0.709, 
          0.696, 
          0.618, 
          0.299, 
          0.522, 
          0.594, 
          0.227, 
          0.394, 
          0.667, 
         -9.999, 
          0.469, 
          0.943, 
          1.146, 
          0.881, 
          0.697, 
          1.084, 
          0.445, 
          0.666, 
          1.097, 
          1.029, 
         -9.999, 
          1.272, 
          0.584, 
          0.594, 
          0.307, 
          0.651, 
          1.230, 
          0.527, 
          0.485, 
          0.657, 
          0.640, 
          0.677, 
          0.499, 
          1.019, 
          0.554, 
          0.531, 
          1.494, 
          0.344, 
          0.220, 
          0.376, 
          0.651, 
          0.245, 
          0.801, 
          0.576, 
          0.991, 
          0.187, 
          1.450, 
          0.595, 
          0.407, 
          0.764, 
          0.561, 
          0.722, 
          0.240, 
         -9.999, 
          0.479, 
          0.422, 
          0.512, 
         -9.999, 
          0.314, 
          0.333, 
          0.704, 
          0.990, 
          0.955, 
          0.526, 
          0.369, 
          0.430, 
          0.686, 
          0.555, 
          0.737, 
          0.369, 
          0.704, 
         -9.999, 
          0.518, 
          0.552, 
          0.540, 
          0.308, 
          0.471, 
          0.357, 
          0.478, 
          0.448, 
          0.273, 
         -9.999, 
          0.496, 
          0.928, 
          0.315, 
         -9.999, 
          0.412, 
          0.605, 
          0.815, 
          0.512, 
          1.828, 
         -9.999, 
          0.456, 
          0.610, 
          0.462, 
          1.317, 
          0.558, 
          0.585, 
          0.726, 
         -9.999, 
          0.361, 
          0.757, 
          0.828, 
          0.429, 
          0.245, 
          0.248, 
          0.584, 
          0.256, 
          0.599, 
          0.530, 
          0.549, 
          0.151, 
          0.540, 
         -9.999, 
          0.522, 
          1.185, 
          0.871, 
         -9.999, 
          0.631, 
          0.697, 
          0.257, 
          0.559, 
          0.876, 
          0.381, 
          0.216, 
         -9.999, 
          0.376, 
         -9.999, 
          0.399, 
          0.315, 
         -9.999, 
          0.410, 
          0.900, 
          0.465, 
          0.598, 
          1.157, 
          0.698, 
          1.543, 
          1.014, 
          1.071, 
          0.957, 
          1.628, 
          0.143, 
          1.413, 
          0.782, 
          1.628, 
          1.203, 
          1.790, 
          1.157, 
          0.826, 
          0.562, 
         -9.999, 
          0.616, 
         -9.999, 
          0.257, 
          0.318, 
          0.472, 
          0.306, 
          0.412, 
          0.970, 
          1.459, 
          0.597, 
          0.496, 
          0.419, 
          0.441, 
          0.743, 
          0.265, 
          0.249, 
          0.279, 
          0.884, 
          0.904, 
         -9.999, 
          0.567, 
          1.044, 
          1.052, 
          1.124, 
          1.053, 
          1.437, 
         -9.999, 
          0.410, 
          0.836, 
          2.209, 
          1.560, 
          0.614, 
          1.924, 
         -9.999, 
          1.211, 
          0.566, 
          0.502, 
          1.553, 
          0.342, 
          0.350, 
          0.269, 
          0.225, 
          0.825, 
          0.553, 
          0.445, 
          0.361, 
          1.425, 
          0.562, 
          0.899, 
          1.274, 
          0.753, 
          0.806, 
          1.241, 
          0.815, 
          0.831, 
          1.202, 
          1.176, 
          0.348, 
          1.228, 
          0.832, 
          0.699, 
          0.242, 
          0.683, 
          0.866, 
          0.438, 
          0.994, 
          0.525, 
          0.358, 
         -9.999, 
          1.019, 
          0.425, 
          0.693, 
          0.445, 
          1.049, 
          0.572, 
          0.638, 
          0.511, 
         -9.999, 
          0.438, 
          1.229, 
          0.782, 
          1.235, 
          0.681, 
          0.428, 
          0.688, 
          0.962, 
          0.931, 
          0.481, 
          0.268, 
          1.152, 
          0.721, 
          0.699, 
         -9.999, 
          0.657, 
          1.450, 
          0.925, 
          1.001, 
          0.438, 
          0.513, 
          0.191, 
          0.462, 
          0.858, 
          1.379, 
          0.763, 
          0.656, 
          0.459, 
          0.537, 
          0.964, 
          1.548, 
          0.824, 
          0.614, 
          0.599, 
          1.389, 
          1.101, 
          0.340, 
          0.666, 
          1.049, 
          0.937, 
          1.079, 
          0.976, 
          1.025, 
          0.502, 
          0.421, 
          0.702, 
          0.627, 
          0.823, 
          0.610, 
          0.359, 
          0.648, 
          0.555, 
          0.282, 
          0.832, 
          0.805, 
          0.397, 
          0.362, 
          0.738, 
          0.402, 
          0.243, 
          0.430, 
          0.590, 
          0.367, 
          0.246, 
          0.405, 
          1.569, 
          0.535, 
          0.251, 
          0.734, 
          0.226, 
          0.593, 
          0.448, 
          0.653, 
          0.282, 
          0.343, 
          0.756, 
          0.251, 
          0.465, 
          0.442, 
          0.434, 
          1.142, 
          0.442, 
          0.462, 
          0.235, 
          0.437, 
          0.463, 
          0.540, 
          0.474, 
          0.439, 
          0.390, 
          0.413, 
          0.413, 
          0.228, 
          0.645, 
          0.482, 
          0.711, 
          0.335, 
          0.418, 
          0.495, 
          1.179, 
          0.583, 
          0.987, 
          0.281, 
          0.428, 
          0.175, 
          0.275, 
          0.903, 
          0.527, 
          0.649, 
          0.472, 
          0.375, 
          0.367, 
          0.774, 
          0.290, 
          1.302, 
          0.406, 
          0.369, 
          0.314, 
          0.441, 
          0.934, 
          0.320, 
          0.452, 
          0.264, 
          0.598, 
          0.599, 
          0.922, 
          0.429, 
          0.309, 
          1.381, 
          0.502, 
          0.485, 
          0.364, 
          0.462, 
          1.079, 
          0.309, 
          0.234, 
          1.933, 
          0.431, 
          0.438, 
          2.940, 
         -9.999, 
          0.328, 
          1.560, 
          1.066, 
          0.422, 
          0.684, 
          1.266, 
          0.901, 
          0.713, 
          0.635, 
          0.483, 
          0.664, 
          0.742, 
          0.821, 
          1.009, 
          0.813, 
          0.790, 
          0.490, 
          0.640, 
          0.364, 
          0.253, 
          0.861, 
          0.381, 
          0.745, 
          0.359, 
          0.610, 
          0.294, 
          1.301, 
          0.403, 
          0.355, 
          0.619, 
          0.517, 
          0.439, 
          0.619, 
          0.451, 
          1.071, 
          0.579, 
          0.761, 
          1.604, 
          0.774, 
          0.513, 
          0.850, 
          0.385, 
          1.249, 
          0.637, 
          0.541, 
          0.537, 
          0.736, 
          0.427, 
          0.929, 
          1.042, 
          0.298, 
          0.247, 
          0.393, 
          0.704, 
          0.444, 
          0.256, 
          0.264, 
          0.524, 
          0.389, 
          0.430, 
          0.376, 
         -9.999, 
         -9.999, 
          0.692, 
          0.540, 
          0.253, 
          0.367, 
          0.353, 
          0.408, 
          1.351, 
          2.796, 
          1.555, 
          0.517, 
          0.389, 
          0.508, 
         -9.999, 
          0.554, 
          1.031, 
          1.029, 
          0.327, 
          0.327, 
          1.056, 
          1.086, 
          0.865, 
          0.249, 
          0.225, 
          0.362, 
          0.493, 
          0.519, 
          1.509, 
          0.817, 
          0.259, 
          1.391, 
          0.489, 
          0.240, 
          0.458, 
          0.336, 
          0.557, 
          0.793, 
          1.131, 
          0.527, 
          0.846, 
          1.206, 
          0.261, 
          0.267, 
         -9.999, 
          0.515, 
         -9.999, 
         -9.999, 
          0.371, 
          0.370, 
          0.570, 
          0.628, 
          0.420, 
          1.113, 
          0.847, 
          1.210, 
          1.510, 
          1.117, 
          1.556, 
          1.609, 
          1.643, 
          0.718, 
          0.829, 
          1.388, 
          1.197, 
          0.742, 
          1.153, 
          0.937, 
          0.456, 
          0.967, 
          0.343, 
          0.343, 
          0.612, 
          0.578, 
          0.496, 
          0.557, 
          0.431, 
          0.397, 
          1.219, 
          1.021, 
          0.367, 
          0.939, 
          0.465, 
          0.739, 
          0.386, 
          0.446, 
          0.386, 
          1.106, 
          1.180, 
          1.366, 
          2.846, 
          1.216, 
          0.661, 
          2.290, 
          1.397, 
          1.149, 
          0.929, 
          0.933, 
          0.421, 
          1.788, 
          1.390, 
          1.582, 
          0.498, 
          1.362, 
          0.574, 
          0.542, 
          0.476, 
         -9.999, 
          0.820, 
          1.005, 
          1.173, 
          0.945, 
          0.353, 
          0.842, 
          0.860, 
          0.419, 
          0.571, 
          1.455, 
          0.797, 
          1.074, 
          0.983, 
          0.680, 
          1.013, 
          0.758, 
          0.785, 
          0.749, 
          1.059, 
          0.698, 
          1.427, 
          1.327, 
          0.556, 
          0.196, 
          0.385, 
          0.707, 
          0.787, 
          0.634, 
          0.737, 
          1.047, 
         -9.999, 
          0.429, 
          0.271, 
         -9.999, 
          0.758, 
          0.601, 
          0.817, 
          0.389, 
          0.799, 
          1.171, 
          0.782, 
          0.934, 
          0.860, 
          0.766, 
          0.576, 
          1.753, 
          0.613, 
          0.670, 
          1.025, 
          0.471, 
          0.561, 
          0.239, 
          0.805, 
          0.989, 
          0.476, 
          1.492, 
          1.085, 
          1.431, 
          0.387, 
          0.701, 
          0.511, 
          0.458, 
         -9.999, 
          0.256, 
          0.846, 
          1.218, 
          0.387, 
          0.683, 
          0.882, 
          1.480, 
          0.945, 
          0.765, 
          0.538, 
          0.594, 
          0.595, 
          0.940, 
          1.019, 
          0.334, 
          0.457, 
          1.217, 
          0.863, 
          1.451, 
          1.511, 
          0.969, 
          0.507, 
         -9.999, 
          1.267, 
          0.860, 
          0.848, 
          0.563, 
          0.671, 
          0.903, 
          0.813, 
          0.672, 
          1.148, 
          0.803, 
          0.362, 
          0.306, 
         -9.999, 
          0.516, 
          0.361, 
          0.639, 
          0.377, 
          0.744, 
         -9.999, 
          0.459, 
          0.280, 
          0.260, 
         -9.999, 
          0.504, 
          0.288, 
         -9.999, 
          0.482, 
          0.367, 
          0.640, 
          0.245, 
          0.324, 
          0.510, 
          0.438, 
          0.302, 
          0.449, 
          0.563, 
          0.490, 
          0.568, 
          0.322, 
          0.594, 
          0.844, 
          0.492, 
          0.619, 
          0.520, 
          0.656, 
          0.764, 
          0.195, 
          0.250, 
          0.499, 
          0.670, 
          0.711, 
          0.421, 
          0.802, 
          1.197, 
          0.871, 
          0.449, 
          0.378, 
          0.328, 
          0.538, 
          0.365, 
          0.350, 
          0.470, 
          0.363, 
          0.512, 
          0.754, 
          0.449, 
         -9.999, 
          0.423, 
         -9.999, 
          0.636, 
         -9.999, 
          0.957, 
         -9.999, 
          0.944, 
          0.498, 
          0.212, 
          0.566, 
          0.346, 
          0.362, 
          0.633, 
          0.615, 
          0.305, 
          0.846, 
          0.646, 
          0.593, 
          0.385, 
          0.339, 
          0.881, 
          0.938, 
          0.744, 
          0.577, 
          0.983, 
          0.432, 
          1.456, 
          1.912, 
          1.252, 
          1.027, 
          1.337, 
          1.586, 
          0.935, 
          0.424, 
          1.204, 
          0.579, 
          0.873, 
          0.498, 
          0.691, 
          0.657, 
          1.612, 
          0.474, 
          0.781, 
          0.427, 
          1.011, 
          0.685, 
          0.388, 
          0.454, 
          0.679, 
          0.349, 
          0.887, 
          0.403, 
          0.227, 
          0.532, 
          0.677, 
          1.030, 
          0.360, 
          0.551, 
          0.597, 
          0.646, 
          0.336, 
          0.797, 
          0.268, 
          0.310, 
          0.574, 
          1.044, 
          1.713, 
          0.682, 
          1.040, 
          1.283, 
          0.524, 
          0.601, 
          0.791, 
          0.684, 
          1.309, 
          0.585, 
          0.889, 
          0.355, 
          0.658, 
          0.217, 
          0.511, 
          0.349, 
          0.436, 
          0.685, 
         -9.999, 
          0.312, 
          0.884, 
          0.462, 
          0.333, 
          0.319, 
          0.522, 
          1.103, 
          0.553, 
          1.041, 
          0.542, 
          0.705, 
          1.192, 
          0.518, 
          1.390, 
          1.174, 
          0.791, 
          1.357, 
          0.826, 
          0.835, 
         -9.999, 
          0.586, 
          1.453, 
          0.758, 
         -9.999, 
          0.508, 
          0.712, 
          1.264, 
          0.395, 
          0.598, 
          0.591, 
          0.201, 
          0.562, 
          0.626, 
          0.766, 
          0.766, 
          0.512, 
          1.091, 
          1.399, 
          0.435, 
          1.167, 
          0.765, 
          0.735, 
          1.162, 
          0.918, 
          0.451, 
          0.674, 
          0.858, 
          0.249, 
         -9.999, 
          0.785, 
          0.670, 
          0.313] 
    for i, val in enumerate(table.field('Q')):
        if isnan(val):
            assert Q[i] == -9.999 #the text value for a missing value in that table
        else:
            assert val == Q[i]

if __name__ == "__main__": # run from main directory; not from test/
    test_header_from_readme()
