""" An extensible ASCII table reader and writer.

:Copyright: Smithsonian Astrophysical Observatory (2010)
:Author: Tom Aldcroft (aldcroft@head.cfa.harvard.edu)
"""
## 
## Redistribution and use in source and binary forms, with or without
## modification, are permitted provided that the following conditions are met:
##     * Redistributions of source code must retain the above copyright
##       notice, this list of conditions and the following disclaimer.
##     * Redistributions in binary form must reproduce the above copyright
##       notice, this list of conditions and the following disclaimer in the
##       documentation and/or other materials provided with the distribution.
##     * Neither the name of the Smithsonian Astrophysical Observatory nor the
##       names of its contributors may be used to endorse or promote products
##       derived from this software without specific prior written permission.
## 
## THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
## ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
## WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
## DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
## DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
## (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
## LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
## ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
## (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS  
## SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

from asciitable.core import (__version__, has_numpy,
                             InconsistentTableError,
                             NoType, StrType, NumType, FloatType, IntType, AllType,
                             Column, Keyword,
                             BaseInputter, ContinuationLinesInputter,
                             BaseHeader,
                             BaseData,
                             BaseOutputter, NumpyOutputter, DictLikeNumpy,
                             BaseReader, 
                             BaseSplitter, DefaultSplitter, FixedWidthSplitter, WhitespaceSplitter,
                             convert_list, convert_numpy,
                             )
from asciitable.basic import (Basic, BasicReader,
                              Rdb, RdbReader,
                              Tab, TabReader,
                              NoHeader, NoHeaderReader,
                              CommentedHeader, CommentedHeaderReader)
from asciitable.cds import Cds, CdsReader
from asciitable.latex import Latex, LatexReader, AASTex, AASTexReader, latexdicts
from asciitable.ipac import Ipac, IpacReader
from asciitable.daophot import Daophot, DaophotReader
from asciitable.memory import Memory, MemoryReader
from asciitable.ui import (set_guess, get_reader, read, get_writer, write)

