# -*- coding: utf-8 -*-
import re
import os
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.autosummary',
    'sphinx.ext.doctest',
    'sphinx.ext.todo',
    'sphinx.ext.coverage',
    'sphinx.ext.ifconfig',
    'sphinx.ext.viewcode',
]
if os.getenv('SPELLCHECK'):
    extensions += 'sphinxcontrib.spelling',
    spelling_show_suggestions = True
    spelling_lang = 'en_US'

source_suffix = '.rst'
master_doc = 'index'
copyright = u'2014, Ionel Cristian Mărieș'
version = release = re.findall(
    'version="(.*)"',
    open(os.path.join(os.path.dirname(__file__), '../setup.py')).read()
)[0]
project = u'python-aspectlib'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

html_theme = 'pydoctheme'
html_theme_path = ['sphinxext']
pygments_style = 'trac'
templates_path = ['sphinxext']
html_static_path = ['sphinxext/static']
html_use_smartypants = True
html_last_updated_fmt = '%b %d, %Y'
exclude_trees = ['sphinxext']
html_split_index = True
html_sidebars = {
   '**': ['searchbox.html', 'globaltoc.html', 'sourcelink.html'],
}


#html_theme = "default"
#html_theme_option = dict(
#    stickysidebar=True,
#    collapsiblesidebar=True,
#    bodyfont="'Palatino', 'Palatino Linotype', 'URW Palladio L', 'Century Schoolbook L', 'Georgia', serif",
#    headfont="'Myriad Pro', 'Trebuchet Ms', 'Segoe UI', sans-serif",
#)

#html_theme = 'traditional'
#html_theme = 'nature'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#html_theme_options = {}

# Add any paths that contain custom themes here, relative to this directory.
#html_theme_path = []

htmlhelp_basename = 'python-aspectlib-docs'
