"""
    Copyright 2000, 2001 Astrolabe by William McClain

    Forked in 2013 to Astronomia

    Copyright 2013 Astronomia by Tim Cera

    This file is part of Astronomia.

    Astronomia is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Astronomia is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astronomia; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    """

_planets = {
('Mercury', 'L'): [[
[4.40250710144, 0.00000000000, 0.00000000000],
[0.40989414976, 1.48302034194, 26087.90314157420],
[0.05046294199, 4.47785489540, 52175.80628314840],
[0.00855346843, 1.16520322351, 78263.70942472259],
[0.00165590362, 4.11969163181, 104351.61256629678],
[0.00034561897, 0.77930765817, 130439.51570787099],
[0.00007583476, 3.71348400510, 156527.41884944518],
[0.00003559740, 1.51202669419, 1109.37855209340],
[0.00001726012, 0.35832239908, 182615.32199101939],
[0.00001803463, 4.10333178410, 5661.33204915220],
[0.00001364682, 4.59918318745, 27197.28169366760],
[0.00001589923, 2.99510417815, 25028.52121138500],
[0.00001017332, 0.88031439040, 31749.23519072640],
[0.00000714182, 1.54144865265, 24978.52458948080],
[0.00000643759, 5.30266110787, 21535.94964451540],
[0.00000404200, 3.28228847025, 208703.22513259358],
[0.00000352441, 5.24156297101, 20426.57109242200],
[0.00000343313, 5.76531885335, 955.59974160860],
[0.00000339214, 5.86327765000, 25558.21217647960],
[0.00000451137, 6.04989275289, 51116.42435295920],
[0.00000325335, 1.33674334780, 53285.18483524180],
[0.00000259587, 0.98732428184, 4551.95349705880],
[0.00000345212, 2.79211901539, 15874.61759536320],
[0.00000272947, 2.49451163975, 529.69096509460],
[0.00000234830, 0.26672118900, 11322.66409830440],
[0.00000238793, 0.11343953378, 1059.38193018920],
[0.00000264336, 3.91705094013, 57837.13833230060],
[0.00000216645, 0.65987207348, 13521.75144159140],
[0.00000183359, 2.62878670784, 27043.50288318280],
[0.00000175965, 4.53636829858, 51066.42773105500],
[0.00000181629, 2.43413502466, 25661.30495069820],
[0.00000208995, 2.09178234008, 47623.85278608960],
[0.00000172643, 2.45200164173, 24498.83024629040],
[0.00000142316, 3.36003948842, 37410.56723987860],
[0.00000137942, 0.29098447849, 10213.28554621100],
[0.00000118233, 2.78149786369, 77204.32749453338],
[0.00000096860, 6.20398202740, 234791.12827416777],
[0.00000125219, 3.72079804425, 39609.65458316560],
[0.00000086819, 2.64219349385, 51646.11531805379],
[0.00000086723, 1.95953042650, 46514.47423399620],
[0.00000088329, 5.41338795963, 26617.59410666880],
[0.00000106422, 4.20572116254, 19804.82729158280],
[0.00000089987, 5.85243631094, 41962.52073693740],
[0.00000084971, 4.33100364958, 79373.08797681599],
[0.00000069247, 4.19446437496, 19.66976089979],
[0.00000063463, 3.14700877722, 7238.67559160000],
[0.00000068493, 0.63424819267, 83925.04147387479],
[0.00000069729, 3.57201709671, 25132.30339996560],
[0.00000059481, 2.74692752000, 16983.99614745660],
[0.00000064830, 0.04762925810, 33326.57873317420],
[0.00000055376, 4.05312663019, 30639.85663863300],
[0.00000054442, 3.14331542453, 27147.28507176339],
[0.00000047560, 5.49722099211, 3.88133535800],
[0.00000049567, 3.98985863874, 6770.71060124560],
[0.00000056531, 5.11920557675, 73711.75592766379],
[0.00000041764, 5.64185159566, 53131.40602475700],
[0.00000051458, 5.47786463494, 50586.73338786459],
[0.00000044744, 1.22366857463, 77154.33087262919],
[0.00000041882, 5.19309298528, 6283.07584999140],
[0.00000038045, 2.43117327523, 12566.15169998280],
[0.00000035627, 0.81390126585, 32858.61374281979],
[0.00000048007, 5.49260554912, 51749.20809227239],
[0.00000035392, 3.36964859355, 36301.18868778519],
[0.00000033951, 2.78618091049, 14765.23904326980],
[0.00000030560, 5.84045074182, 43071.89928903080],
[0.00000035964, 1.42380838630, 2218.75710418680],
[0.00000034044, 0.47470299167, 65697.55772473979],
[0.00000030800, 5.77017310191, 103292.23063610759],
[0.00000028496, 0.65048992658, 426.59819087600],
[0.00000026215, 5.24158618719, 22645.32819660879],
[0.00000026253, 0.64807043102, 1589.07289528380],
[0.00000029538, 0.69771244088, 213.29909543800],
[0.00000027504, 0.98010127839, 45892.73043315699],
[0.00000022347, 5.65335125838, 77734.01845962799],
[0.00000022047, 4.93398225193, 72602.37737557039],
[0.00000022275, 2.17909842576, 52705.49724824299],
[0.00000024252, 4.39994170609, 7.11354700080],
[0.00000026751, 1.06145361792, 3442.57494496540],
[0.00000023656, 2.84168536986, 260879.03141574195],
[0.00000022908, 2.58462026514, 68050.42387851159],
[0.00000027086, 0.08501738669, 63498.47038145279],
[0.00000022247, 3.22418265191, 25448.00585526019],
[0.00000017803, 3.61202297483, 110012.94461544899],
[0.00000022407, 1.02520094825, 105460.99111839019],
[0.00000017576, 4.71742326981, 25874.60404613620],
[0.00000018586, 4.52709871258, 28306.66024576099],
[0.00000014176, 6.12394176563, 53235.18821333759],
[0.00000014186, 5.14246797066, 26068.23338067440],
[0.00000017244, 0.28394746813, 51220.20654153979],
[0.00000017176, 3.26084092971, 153.77881048480],
[0.00000014938, 1.83542009339, 99799.65906923798],
[0.00000013387, 0.76564655407, 56727.75978020720],
[0.00000013978, 2.30193139916, 76674.63652943878],
[0.00000014428, 0.96646356501, 26107.57290247399],
[0.00000011990, 6.20492907598, 18849.22754997420],
[0.00000014381, 1.90956715654, 23969.13928119580],
[0.00000011233, 2.04817126136, 32370.97899156560],
[0.00000013392, 4.51750784605, 26080.78959457339],
[0.00000011632, 2.38496860260, 79219.30916633119],
[0.00000012412, 2.22280944169, 77837.11123384659],
[0.00000009950, 2.04594448880, 48733.23133818299],
[0.00000009803, 2.26706433546, 26091.78447693220],
[0.00000009362, 5.44291958209, 38654.05484155699],
[0.00000009747, 3.83976857418, 26084.02180621620],
[0.00000009264, 4.02987000812, 467.96499035440],
[0.00000008961, 0.11062526114, 62389.09182935939],
[0.00000011543, 4.17789167759, 103242.23401420339],
[0.00000011146, 3.78292300417, 26301.20223701220],
[0.00000009677, 2.98527809776, 59414.48187474840],
[0.00000008977, 3.47888073089, 91785.46086631398],
[0.00000009664, 5.77941968495, 25938.33994443960],
[0.00000008855, 2.84672636028, 25035.63475838580],
[0.00000008181, 5.77857196635, 40853.14218484400],
[0.00000008033, 2.45692824195, 129380.13377768178],
[0.00000008343, 5.34499871294, 19317.19254032860],
[0.00000007425, 4.71160330390, 6.62855890001],
[0.00000009001, 6.23396256413, 25021.40766438420],
[0.00000008126, 1.12294634635, 26095.01668857500],
[0.00000006568, 3.66248946629, 26514.50133245020],
[0.00000007038, 3.99035923761, 71980.63357473118],
[0.00000006956, 1.62821260299, 23869.14603738740],
[0.00000007595, 0.18334396433, 12432.04265039780],
[0.00000006061, 3.67044794062, 27676.97603685800],
[0.00000005896, 5.57171141866, 94138.32702008578],
[0.00000005716, 5.18204203484, 78793.40038981718],
[0.00000005855, 2.14311779301, 20760.42703319140],
[0.00000005681, 1.60727624525, 98690.28051714458],
[0.00000005788, 2.35467492390, 103821.92160120218],
[0.00000005121, 3.77832929907, 58946.51688439399],
[0.00000005873, 5.76210244486, 286966.93455731616],
[0.00000005858, 6.12538452806, 26011.63707029860],
[0.00000005215, 3.29186833997, 38519.94579197200],
[0.00000006000, 0.00057044073, 51535.90899683439],
[0.00000004647, 0.29020584575, 136100.84775702319],
[0.00000005787, 4.44783057272, 19406.67828817460],
[0.00000005908, 4.12195491631, 29530.47808653960],
[0.00000005918, 3.98930701135, 131548.89425996438],
[0.00000005728, 3.02314979708, 89586.37352302698],
[0.00000003928, 4.81437933690, 125887.56221081219],
[0.00000003929, 2.48449041501, 69159.80243060499],
[0.00000003681, 2.80180999964, 79323.09135491178],
[0.00000004498, 1.50325539137, 51962.50718771040],
[0.00000003687, 5.33717753698, 102762.53967101299],
[0.00000003497, 1.85400531491, 52156.13652224860],
[0.00000003867, 1.25354714671, 54394.56338733519],
[0.00000004459, 4.88911997687, 50057.04242277000],
[0.00000003396, 3.73870967348, 82815.66292178139],
[0.00000003525, 6.07665337319, 25934.12433108940],
[0.00000003492, 1.28206984744, 52168.69273614759],
[0.00000003411, 6.13976263434, 639.89728631400],
[0.00000004395, 3.25475914760, 77308.10968311399],
[0.00000002990, 5.27323635392, 46848.33017476560],
[0.00000003218, 5.20938751579, 103925.01437542078],
[0.00000002899, 5.08451495112, 58458.88213313979],
[0.00000003708, 0.02713701028, 26241.68195205900],
[0.00000002991, 2.92278339368, 44937.13069154840],
[0.00000003177, 0.05753403864, 22747.29071487440],
[0.00000003163, 5.38713552769, 105307.21230790539],
[0.00000003556, 3.96231142071, 52195.47604404819],
[0.00000002787, 0.54704419913, 52389.10537858640],
[0.00000002458, 1.14904830408, 2333.19639287200],
[0.00000002492, 5.24922078791, 25668.41849769900],
[0.00000002409, 2.14208355028, 64741.95798313119],
[0.00000002509, 0.61934630416, 85034.42002596818],
[0.00000002416, 5.26204437192, 52179.68761850640],
[0.00000002296, 3.09900451546, 88476.99497093359],
[0.00000002357, 0.17742385045, 117873.36400788819],
[0.00000003012, 0.83689268367, 129330.13715577759],
[0.00000002421, 3.95913346049, 49.99662190420],
[0.00000002197, 2.56129546358, 3340.61242669980],
[0.00000002402, 0.55121112633, 52171.92494779040],
[0.00000002106, 5.41271503337, 155468.03691925599],
[0.00000002566, 3.00606194044, 51109.31080595839],
[0.00000002392, 0.17898534184, 103.09277421860],
[0.00000002737, 1.08192567668, 632.78373931320],
[0.00000002523, 5.90356438675, 51123.53789995999],
[0.00000002098, 2.47132069140, 66941.04532641819],
[0.00000002003, 3.75422326828, 16066.06586147480],
[0.00000002188, 1.18654376903, 2118.76386037840],
[0.00000002593, 2.55122032446, 25654.19140369739],
[0.00000002559, 1.18101453315, 45494.58142974879],
[0.00000001918, 0.79899605678, 26555.86813192860],
[0.00000001819, 0.69178943674, 98068.53671630539],
[0.00000002471, 2.55057179214, 52026.24308601380],
[0.00000001704, 0.36723577740, 52602.40447402440],
[0.00000002129, 2.66251948472, 18093.37469954999],
[0.00000001715, 4.62177464710, 49957.04917896160],
[0.00000001916, 5.83726462050, 85502.38501632259],
[0.00000001976, 3.57365896777, 24395.73747207180],
[0.00000001581, 0.36987184257, 53764.87917843220],
[0.00000001589, 1.33531241950, 114.43928868521],
[0.00000002042, 2.05385564074, 45405.09568190280],
[0.00000001539, 2.25468618977, 120226.23016165999],
[0.00000001525, 1.48231179113, 26094.53170047421],
[0.00000002055, 4.16315644175, 52182.91983014920],
[0.00000001829, 0.38846130335, 522.57741809380],
[0.00000002105, 4.04128506778, 25234.70675982219],
[0.00000001480, 1.87644604156, 104881.30353139139],
[0.00000001460, 1.01790185557, 25455.11940226100],
[0.00000001453, 0.34125222190, 1052.26838318840],
[0.00000001449, 3.39742463494, 24505.94379329119],
[0.00000001480, 4.55094492082, 124778.18365871879],
[0.00000001481, 3.62242942443, 149.56319713460],
[0.00000001516, 5.32327802440, 129909.82474277639],
[0.00000001594, 3.00887674765, 77623.81213840858],
[0.00000001927, 3.90378108197, 74.78159856730],
[0.00000001373, 4.32419381493, 80482.46652890938],
[0.00000001419, 3.90109225299, 7880.08915333899],
[0.00000001525, 4.62451312025, 26081.27458267419],
[0.00000001567, 0.65981123945, 157636.79740153858],
[0.00000001725, 4.40112128069, 316.39186965660],
[0.00000001263, 4.96320745251, 74821.13447975718],
[0.00000001472, 5.56006656586, 95247.70557217918],
[0.00000001315, 1.83254115004, 76144.94556434419],
[0.00000001439, 0.83286166370, 55618.38122811380],
[0.00000001355, 3.15837061982, 1066.49547719000],
[0.00000001224, 3.24032680768, 162188.75089859738],
[0.00000001390, 5.13745290383, 419.48464387520],
[0.00000001310, 5.28250636680, 25619.93815121980],
[0.00000001477, 2.40227455027, 313054.83769889036],
[0.00000001252, 5.65227031449, 26013.12154300690],
[0.00000001143, 0.38707356937, 42153.96900304900],
[0.00000001082, 2.56550728704, 26190.99591579279],
[0.00000001493, 2.89973504649, 52099.54021187280],
[0.00000001468, 5.71507791250, 24491.71669928959],
[0.00000001034, 1.49544294440, 151975.46535238638],
[0.00000001314, 5.91505351846, 115674.27666460119],
[0.00000001065, 3.61081835123, 206.18554843720],
[0.00000001053, 5.17996026320, 23754.70674870219],
[0.00000000964, 2.05264296353, 128850.44281258718],
[0.00000001032, 3.39114761061, 25551.09862947879],
[0.00000001065, 3.38225524038, 25863.55834587229],
[0.00000001153, 5.76498787983, 44181.27784112419],
[0.00000000960, 5.74774250678, 105410.99449648599],
[0.00000001137, 6.20919445956, 103396.01282468818],
[0.00000000914, 4.28855434634, 78256.59587772179],
[0.00000000917, 3.27543718918, 76.26607127560],
[0.00000000892, 4.82397571946, 78244.03966382280],
[0.00000000976, 4.86442946387, 25131.61398560359],
[0.00000001086, 0.73424633411, 33967.99229491319],
[0.00000001162, 4.52128441898, 78050.41032928458],
[0.00000000868, 2.78848256837, 52022.02747266360],
[0.00000000943, 4.09736853870, 26720.68688088739],
[0.00000000973, 4.54018615747, 24925.42843716640],
[0.00000000845, 5.05414707498, 25977.69682035479],
[0.00000000841, 1.89412486884, 130012.91751699499],
[0.00000000920, 3.02504494542, 52329.58509363319],
[0.00000000814, 3.15330668609, 48835.19385644859],
[0.00000000876, 0.41318857467, 108903.56606335558],
[0.00000000818, 1.61477924287, 40565.25432477420],
[0.00000001074, 1.37296024678, 23439.44831610119],
[0.00000000812, 2.82156935191, 25984.81036735560],
[0.00000000775, 2.86911510061, 26727.80042788820],
[0.00000000755, 5.44067645183, 24609.03656750980],
[0.00000000921, 4.72557901430, 14477.35118320000],
[0.00000000914, 4.70826349904, 6681.22485339960],
[0.00000000749, 1.80279541026, 84546.78527471398],
[0.00000000907, 0.64974692551, 78283.37918562238],
[0.00000000854, 5.05058435764, 307.55762096960],
[0.00000000766, 5.89942349817, 71025.03383312259],
[0.00000000713, 3.55192633098, 78477.00852016058],
[0.00000000718, 1.85061030321, 100909.03762133139],
[0.00000000858, 5.43959629234, 536.80451209540],
[0.00000000794, 3.77076518156, 155418.04029735178],
[0.00000000848, 2.08790526575, 131395.11544947959],
[0.00000000622, 3.14583461131, 143961.26714946238],
[0.00000000623, 4.58424507963, 9103.90699411760],
[0.00000000623, 5.10535773746, 90829.86112470538],
[0.00000000706, 4.19554833142, 71582.48457132299],
[0.00000000738, 0.15942404038, 24712.12934172840],
[0.00000000621, 1.32834420218, 3328.13565628019],
[0.00000000714, 1.88052234658, 2199.08734328700],
[0.00000000678, 6.01392909264, 77197.21394753258],
[0.00000000650, 5.51227348491, 29428.51556827400],
[0.00000000658, 2.03299256393, 51756.32163927320],
[0.00000000593, 6.06807779961, 114564.89811250778],
[0.00000000666, 0.70706334861, 26162.68474014150],
[0.00000000597, 5.15771478155, 333.85594076940],
[0.00000000616, 1.94902289932, 78267.59076008058],
[0.00000000774, 2.84206828086, 13655.86049117640],
[0.00000000698, 5.60747842278, 51742.09454527159],
[0.00000000557, 2.07529602574, 181555.94006083018],
[0.00000000547, 3.17747066781, 90695.75207512038],
[0.00000000541, 4.20816350943, 28421.09953444620],
[0.00000000639, 5.55908134374, 78114.14622758799],
[0.00000000529, 3.60209913515, 1911.19948321720],
[0.00000000620, 4.87816246784, 25771.51127191760],
[0.00000000569, 3.56250435364, 111122.32316754239],
[0.00000000510, 4.20331823730, 28206.66700195260],
[0.00000000539, 5.42639519551, 93028.94846799239],
[0.00000000659, 3.45407389663, 26610.48055966799],
[0.00000000613, 3.52133069078, 78259.82808936459],
[0.00000000594, 1.16299449628, 26404.29501123080],
[0.00000000576, 0.81617266730, 51322.60990139639],
[0.00000000497, 5.37540191935, 26037.90651966999],
[0.00000000663, 2.63246066036, 77211.44104153418],
[0.00000000487, 1.96691664683, 26507.38778544939],
[0.00000000474, 3.65243004234, 124156.43985787958],
[0.00000000550, 5.81040334783, 1731.12235293260],
[0.00000000472, 3.79351701945, 52643.77127350280],
[0.00000000467, 4.50175920356, 110.20632121940],
[0.00000000593, 3.04818872924, 12725.45343477500],
[0.00000000552, 0.68733268561, 26137.89976347840],
[0.00000000525, 0.87988157932, 78270.82297172339],
[0.00000000600, 0.33902061394, 50483.64061364600],
[0.00000000443, 3.33385484899, 78690.30761559859],
[0.00000000441, 1.31034191525, 76044.95232053580],
[0.00000000588, 2.37074288411, 121335.60871375339],
[0.00000000427, 0.14810668871, 50593.84693486539],
[0.00000000413, 3.33346664325, 79852.78232000639],
[0.00000000403, 5.20705536949, 146314.13330323418],
[0.00000000524, 5.02853960393, 71492.99882347698],
[0.00000000418, 5.99113644745, 103711.71527998279],
[0.00000000388, 4.44142037364, 29416.03879785439],
[0.00000000390, 4.02400157761, 51543.02254383520],
[0.00000000442, 2.37158178341, 111590.28815789679],
[0.00000000375, 4.47565026408, 52182.43484204840],
[0.00000000387, 4.83640155029, 130969.20667296558],
[0.00000000390, 1.20415517897, 150866.08680029298],
[0.00000000416, 3.60399872842, 183724.70054311278],
[0.00000000407, 0.52938530500, 433.71173787680],
[0.00000000439, 2.45401498182, 50579.61984086379],
[0.00000000412, 0.50186886239, 27999.10262479140],
[0.00000000391, 0.68517124695, 134.10904958500],
[0.00000000398, 1.99594942261, 155997.72788435058],
[0.00000000346, 3.40308148193, 27140.17152476259],
[0.00000000422, 5.83293462268, 38813.35657634920],
[0.00000000342, 0.83679406818, 25764.39772491679],
[0.00000000368, 3.80659045949, 81706.28436968799],
[0.00000000355, 1.99286044781, 1089.70879119360],
[0.00000000462, 3.33451630664, 25440.89230825939],
[0.00000000330, 0.37013669364, 26237.46633870879],
[0.00000000330, 6.19331560111, 188276.65404017158],
[0.00000000407, 2.17141736652, 641.41356173899],
[0.00000000321, 5.02532002650, 102232.84870591838],
[0.00000000330, 5.53086966080, 10021.83728009940],
[0.00000000336, 2.49163362426, 25344.91308104160],
[0.00000000381, 5.90928705861, 78187.44335344699],
[0.00000000316, 2.42532836233, 52101.02468458109],
[0.00000000331, 4.38897286971, 26202.34243025941],
[0.00000000401, 1.99380933624, 49842.60989027639],
[0.00000000422, 0.46556669940, 1.48447270830],
[0.00000000310, 6.18819197073, 27154.39861876420],
[0.00000000302, 4.68575942793, 25565.32572348040],
[0.00000000296, 1.70818196194, 25973.46385288896],
[0.00000000375, 5.31085497894, 339142.74084046457],
[0.00000000329, 5.32609571265, 853.19638175200],
[0.00000000299, 5.81101886868, 1692.16566950240],
[0.00000000378, 1.33745475273, 52169.17772424839],
[0.00000000293, 4.43993559835, 579.68758699880],
[0.00000000276, 4.45147472194, 178063.36849396059],
[0.00000000283, 6.19860164015, 25881.71759313700],
[0.00000000315, 1.95956643364, 51707.84129279399],
[0.00000000337, 4.21457120705, 34282.17847478280],
[0.00000000334, 3.00354887525, 23866.04650697719],
[0.00000000268, 1.34437493520, 35191.81013569180],
[0.00000000306, 5.94445231410, 64607.84893354619],
[0.00000000283, 0.96234220412, 1639.06951718800],
[0.00000000287, 1.28099267608, 51013.33157874059],
[0.00000000269, 0.55818949975, 3462.24470586520],
[0.00000000274, 5.61047457506, 52278.89905736699],
[0.00000000352, 0.49071599781, 26294.08869001139],
[0.00000000358, 1.23360990528, 1223.81784077861],
[0.00000000343, 4.29256939583, 49527.35145767539],
[0.00000000255, 5.03019684368, 154938.34595416138],
[0.00000000297, 2.87172991159, 129483.91596626239],
[0.00000000252, 0.09044630682, 13541.42120249119],
[0.00000000301, 1.22789205624, 104138.31347085879],
[0.00000000274, 3.67792692372, 68241.87214462319],
[0.00000000321, 2.49914111769, 141762.17980617538],
[0.00000000290, 1.02241335068, 8194.27533320860],
[0.00000000240, 0.99284920524, 104344.49901929598],
[0.00000000278, 0.53151576617, 949.17560896980],
[0.00000000249, 2.39787134441, 131498.89763806018],
[0.00000000274, 2.09560778105, 26624.70765366959],
[0.00000000240, 3.14668052954, 23976.25282819660],
[0.00000000239, 0.85198559240, 52808.59002246159],
[0.00000000266, 0.18324709351, 2168.76048228260],
[0.00000000226, 4.85701184113, 156100.82065856918],
[0.00000000228, 2.19799888298, 50696.93970908399],
[0.00000000231, 1.49522976308, 104331.94280539699],
[0.00000000245, 4.68642861263, 5327.47610838280],
[0.00000000281, 1.63579312063, 51219.51712717779],
[0.00000000219, 5.75893553103, 78109.93061423779],
[0.00000000233, 5.99853185125, 78417.48823520739],
[0.00000000227, 6.02396548637, 1581.95934828300],
[0.00000000218, 5.42819370607, 18207.81398823521],
[0.00000000220, 3.72017611382, 7994.52844202420],
[0.00000000271, 0.20833686608, 51639.00177105299],
[0.00000000244, 2.33639123341, 25138.72753260440],
[0.00000000254, 5.46143104532, 621.74380083920],
[0.00000000209, 0.01908528531, 26164.16921284980],
[0.00000000208, 6.18336687237, 74923.09699802278],
[0.00000000274, 0.15423898790, 51951.46148744649],
[0.00000000212, 1.95557421945, 735.87651353180],
[0.00000000236, 4.28368070837, 24079.34560241519],
[0.00000000206, 5.86972946528, 52072.71350892979],
[0.00000000201, 1.61226877070, 25241.82030682300],
[0.00000000235, 3.60446251088, 104371.28232719658],
[0.00000000229, 3.66187363672, 1596.18644228460],
[0.00000000198, 5.85298126352, 52815.70356946240],
[0.00000000220, 1.39541547612, 32769.12799497380],
[0.00000000229, 3.36265291664, 134991.46920492979],
[0.00000000192, 1.03510456065, 25867.49049913539],
[0.00000000199, 4.78126289270, 110634.68841628819],
[0.00000000191, 4.24110997660, 14.22709400160],
[0.00000000210, 5.44710702022, 147423.51185532758],
[0.00000000229, 0.76266531820, 220.41264243880],
[0.00000000185, 0.24752751791, 104564.91166173479],
[0.00000000211, 1.81826670820, 52065.59996192899],
[0.00000000182, 2.31946183497, 9384.84100807520],
[0.00000000207, 0.77329376239, 917.93028598180],
[0.00000000190, 0.91354241432, 97670.38771289718],
[0.00000000184, 3.32299343484, 30.32686100440],
[0.00000000209, 0.41150840785, 181505.94343892598],
[0.00000000225, 5.06158596891, 157483.01859105378],
[0.00000000184, 2.71529935065, 103285.11708910679],
[0.00000000191, 1.96528922573, 314.18617986960],
[0.00000000182, 4.30249539122, 1884.90116341740],
[0.00000000192, 4.82097876700, 126996.94076290558],
[0.00000000188, 0.98150502881, 26049.77010593640],
[0.00000000184, 0.67028697590, 106570.36967048359],
[0.00000000167, 5.71084692524, 96357.08412427259],
[0.00000000184, 2.33710037381, 77829.99768684579],
[0.00000000201, 2.57648669602, 97112.93697469679],
[0.00000000176, 3.20466399658, 39629.32434406539],
[0.00000000169, 2.30516098722, 101.96251826560],
[0.00000000163, 6.11134623776, 170049.17029103659],
[0.00000000195, 5.18276528052, 99024.13645791399],
[0.00000000165, 6.00583599609, 224.34479570190],
[0.00000000167, 3.75645242744, 52250.58788171570],
[0.00000000172, 4.28474997892, 25780.34552060460],
[0.00000000216, 3.20425967752, 50800.03248330259],
[0.00000000157, 1.61810971101, 24815.22211594700],
[0.00000000163, 1.77694235279, 116917.76426627958],
[0.00000000156, 1.94644057334, 26421.75908234360],
[0.00000000164, 3.81487619480, 77410.51304297059],
[0.00000000158, 4.95279229085, 35472.74414964940],
[0.00000000150, 5.03580916221, 207643.84320240439],
[0.00000000208, 2.59008696784, 27819.02549450680],
[0.00000000180, 5.62518388437, 103299.34418310839],
[0.00000000165, 2.25945126594, 104202.04936916218],
[0.00000000148, 3.94625893131, 24601.92302050899],
[0.00000000149, 4.49766341520, 956.28915597060],
[0.00000000157, 1.62995234425, 51859.41441349179],
[0.00000000166, 0.21228205353, 52698.38370124219],
[0.00000000151, 2.75061488385, 140652.80125408198],
[0.00000000161, 1.72952408524, 2648.45482547300],
[0.00000000169, 2.61298183547, 26086.41866886590],
[0.00000000170, 0.78905798191, 72936.23331633979],
[0.00000000177, 5.06009562295, 77844.22478084739],
[0.00000000142, 2.61984020842, 24292.64469785319],
[0.00000000150, 4.93124201089, 28286.99048486120],
[0.00000000175, 5.79468120941, 39743.76363275060],
[0.00000000163, 3.37032055762, 76571.54375522019],
[0.00000000150, 1.79967850988, 3.93215326310],
[0.00000000159, 4.90360163470, 104355.49390165479],
[0.00000000149, 4.20242344258, 52492.19815280499],
[0.00000000146, 1.31203861446, 26198.10946279360],
[0.00000000162, 2.25640253895, 55516.41870984820],
[0.00000000178, 1.81205070225, 26395.46076254379],
[0.00000000132, 0.90685777764, 54294.57014352679],
[0.00000000142, 1.70641940798, 92741.06060792258],
[0.00000000138, 0.64298043300, 86143.79857806159],
[0.00000000125, 0.32592941945, 150244.34299945379],
[0.00000000131, 0.91963253985, 54509.00267602040],
[0.00000000144, 4.17124383409, 24822.33566294780],
[0.00000000135, 3.86821614788, 104358.72611329758],
[0.00000000159, 4.72016316702, 4083.98850670440],
[0.00000000122, 2.08133407370, 52125.80966124419],
[0.00000000141, 2.08765477131, 119116.85160956658],
[0.00000000122, 5.01211051965, 52595.29092702359],
[0.00000000149, 0.38744219837, 487.63475125420],
[0.00000000121, 3.30215904574, 1263.15736257819],
[0.00000000138, 1.04671626049, 1083.08023229360],
[0.00000000157, 5.17018916622, 23962.02573419499],
[0.00000000163, 3.26593103179, 26089.38761428249],
[0.00000000130, 0.56779128434, 25936.85547173129],
[0.00000000160, 0.19385295261, 104347.73123093879],
[0.00000000116, 2.69818513122, 129799.61842155698],
[0.00000000113, 4.26323214388, 102132.85546210999],
[0.00000000115, 1.35196569742, 75615.25459924959],
[0.00000000135, 1.70032124143, 97580.90196505119],
[0.00000000121, 0.20372434486, 38.13303563780],
[0.00000000118, 0.49434134122, 78731.67441507700],
[0.00000000119, 5.54562725890, 76667.52298243798],
[0.00000000133, 4.67446352847, 2014.98167179780],
[0.00000000126, 6.24694138116, 636.99627202420],
[0.00000000120, 3.20442216756, 76681.75007643958],
[0.00000000125, 3.65255045892, 29550.14784743939],
[0.00000000118, 5.26052652437, 26729.31670331319],
[0.00000000113, 6.26688921593, 104778.21075717278],
[0.00000000134, 1.56524046563, 25939.82441714789],
[0.00000000114, 3.52566774494, 24356.78078864160],
[0.00000000120, 1.72596426067, 22759.76748529401],
[0.00000000145, 3.61638421570, 52225.80290505260],
[0.00000000107, 5.72285490406, 24176.70365835700],
[0.00000000112, 0.28882268029, 209812.60368468695],
[0.00000000121, 0.11234419157, 51528.79544983359],
[0.00000000120, 4.17769370414, 25754.04720080480],
[0.00000000105, 1.88137155058, 172402.03644480839],
[0.00000000106, 6.27133163237, 105940.68546158058],
[0.00000000104, 3.85061395100, 1478.86657406440],
[0.00000000108, 2.96292200098, 1375.77379984580],
[0.00000000132, 4.60210460022, 11610.55195837420],
[0.00000000114, 5.20612177122, 137678.19129947099],
[0.00000000107, 0.00557717441, 13362.44970679920],
[0.00000000101, 0.73934409276, 77630.92568540938],
[0.00000000097, 1.19155686364, 78270.33798362259],
[0.00000000100, 0.25974575144, 160.40736938481],
[0.00000000105, 0.03739853961, 180.07713028460],
[0.00000000114, 5.13609864972, 1135.67687189320],
[0.00000000101, 4.14323258440, 176953.98994186718],
[0.00000000095, 0.49488385937, 107794.18751126219],
[0.00000000095, 1.54869651436, 25973.50403466079],
[0.00000000100, 1.51228088427, 157057.10981453978],
[0.00000000106, 4.57237246234, 26073.67604757259],
[0.00000000094, 3.53697338405, 26521.61487945100],
[0.00000000091, 3.13017596287, 64901.25971792339],
[0.00000000088, 5.20234335205, 1485.29070670320],
[0.00000000116, 5.96693811684, 24182.43837663380],
[0.00000000099, 2.12002549240, 66653.15746634839],
[0.00000000105, 4.04764282865, 27726.97265876220],
[0.00000000094, 2.62198655221, 104275.34649502118],
[0.00000000106, 2.06629215696, 125112.03959948818],
[0.00000000088, 3.88240703310, 51852.30086649099],
[0.00000000085, 2.83285123847, 214364.55718174578],
[0.00000000083, 5.44599307753, 78188.92782615528],
[0.00000000083, 3.35497157412, 52325.36948028299],
[0.00000000104, 4.95116515346, 182085.63102592478],
[0.00000000110, 6.04814955763, 49953.94964855139],
[0.00000000093, 1.00014028766, 9745.32055585660],
[0.00000000081, 4.03821735964, 132658.27281205778],
[0.00000000084, 0.11234538521, 53228.07466633679],
[0.00000000094, 5.55962830464, 51432.81622261579],
[0.00000000080, 6.13595673095, 137210.22630911658],
[0.00000000080, 2.72256616799, 25042.74830538660],
[0.00000000080, 4.29137248560, 77101.23472031478],
[0.00000000085, 0.97100574775, 25788.77674730500],
[0.00000000082, 1.89501710792, 128320.75184749259],
[0.00000000077, 1.16185579398, 204151.27163553478],
[0.00000000092, 4.44154858356, 26091.83529483729],
[0.00000000078, 3.73813140716, 26222.01219115920],
[0.00000000076, 4.28770981047, 86457.98475793119],
[0.00000000076, 2.88868549481, 53242.30176033840],
[0.00000000104, 4.32540467122, 23888.81579828719],
[0.00000000094, 4.32453647728, 78257.08086582259],
[0.00000000074, 4.96325610801, 26823.77965510599],
[0.00000000077, 1.07428657729, 50167.24874398939],
[0.00000000075, 2.56662960973, 19202.75325164339],
[0.00000000099, 6.00141798836, 19958.60610206760],
[0.00000000087, 3.55579419373, 52381.99183158559],
[0.00000000078, 1.00822618263, 25352.02662804239],
[0.00000000088, 3.52269656514, 60055.89543648739],
[0.00000000078, 5.82066892741, 155571.81910783658],
[0.00000000076, 2.96046756402, 25024.58905812189],
[0.00000000076, 4.24421235710, 130226.21661243298],
[0.00000000076, 2.22645638378, 36109.74042167360],
[0.00000000072, 2.23348468194, 173511.41499690177],
[0.00000000079, 1.13204602827, 52290.24557183361],
[0.00000000074, 1.55328520138, 51653.22886505459],
[0.00000000071, 2.26106298981, 159.30173479220],
[0.00000000073, 2.05345178568, 26941.09952332620],
[0.00000000095, 1.93550514722, 365230.64398203876],
[0.00000000070, 4.74315846161, 52061.36699446317],
[0.00000000085, 1.31607641314, 26667.59072857300],
[0.00000000076, 5.58726680703, 13675.53025207620],
[0.00000000092, 3.24599684677, 28256.66362385679],
[0.00000000067, 1.15071488774, 55503.94193942859],
[0.00000000068, 2.92993581219, 23919.14265929160],
[0.00000000067, 1.77035470445, 181026.24909573558],
[0.00000000066, 2.59648990707, 27780.06881107659],
[0.00000000082, 5.36282814327, 167850.08294774959],
[0.00000000064, 3.99165913279, 130432.40216087017],
[0.00000000069, 5.13777502156, 52712.61079524379],
[0.00000000063, 0.54837259436, 34082.43158359840],
[0.00000000065, 3.89976847376, 27005.83342755599],
[0.00000000073, 6.19252091852, 50064.15596977079],
[0.00000000066, 1.91671959572, 102018.41617342478],
[0.00000000082, 0.87824651640, 25446.48957983520],
[0.00000000063, 3.87624799927, 78896.49316403578],
[0.00000000062, 1.55377407031, 182188.72380014337],
[0.00000000062, 4.71223563105, 103.78218858060],
[0.00000000087, 3.57434964589, 27037.07875054399],
[0.00000000077, 3.43626093365, 54087.00576636560],
[0.00000000078, 4.92073893807, 77795.74443436819],
[0.00000000071, 2.76139796167, 11.04570026390],
[0.00000000064, 5.37974575072, 51226.63067417859],
[0.00000000082, 3.78003355754, 26308.31578401300],
[0.00000000062, 2.70733081732, 104505.39137678158],
[0.00000000071, 5.05097183202, 27177.61193276780],
[0.00000000070, 4.29342266024, 27311.72098235281],
[0.00000000068, 2.34136362165, 78366.80219894118],
[0.00000000060, 4.90888421377, 25508.21555457540],
[0.00000000068, 6.04917764171, 647.01083331480],
[0.00000000058, 2.46745404038, 104197.83375581198],
[0.00000000067, 2.96573339768, 51969.62073471119],
[0.00000000066, 5.33871332672, 157586.80077963437],
[0.00000000058, 2.17528608366, 323.50541665740],
[0.00000000062, 4.44991435917, 130419.84594697120],
[0.00000000063, 0.27396211581, 130459.18546877075],
[0.00000000063, 5.22327184571, 76784.84285065818],
[0.00000000064, 4.64108529425, 61279.71327726600],
[0.00000000062, 1.84001159422, 183570.92173262799],
[0.00000000055, 1.66692917947, 31415.37924995700],
[0.00000000058, 4.06522187846, 32132.13172294960],
[0.00000000057, 2.07569387080, 17893.62780836560],
[0.00000000055, 2.49038254003, 22625.65843570900],
[0.00000000077, 6.17301946895, 25032.45336464809],
[0.00000000068, 4.68765980625, 77307.42026875199],
[0.00000000054, 4.63708190151, 51329.72344839720],
[0.00000000055, 0.21233757772, 2221.85663459700],
[0.00000000068, 2.36358626958, 25953.79409198919],
[0.00000000053, 2.88564903323, 101011.00013959699],
[0.00000000062, 1.19998944516, 26083.97098831109],
[0.00000000054, 3.90599349467, 123758.29085447139],
[0.00000000052, 2.60595997150, 78160.61665050399],
[0.00000000072, 0.83460657204, 22909.75735100660],
[0.00000000066, 3.17005690509, 78039.36462902068],
[0.00000000052, 2.13323028898, 44295.71712980940],
[0.00000000061, 1.63440457571, 61.72597474020],
[0.00000000053, 2.00748586733, 24448.83362438620],
[0.00000000051, 2.50978165702, 78903.60671103658],
[0.00000000051, 3.22110952745, 130652.81480330898],
[0.00000000060, 6.23105854697, 76887.93562487679],
[0.00000000066, 3.23596712512, 77726.90491262719],
[0.00000000059, 1.53485505891, 6044.22858137540],
[0.00000000059, 1.10559326249, 26102.13023557580],
[0.00000000060, 1.08408977503, 27972.80430499159],
[0.00000000049, 2.24548271996, 425.90877651400],
[0.00000000055, 3.33645161611, 207593.84658050018],
[0.00000000067, 0.59579109206, 94329.77528619739],
[0.00000000056, 4.05652507832, 26010.15259759030],
[0.00000000056, 1.49670493057, 136722.59155786238],
[0.00000000049, 4.72236375377, 5193.36705879780],
[0.00000000049, 2.99400480872, 52252.07235442399],
[0.00000000049, 4.15104806247, 51955.39364070959],
[0.00000000050, 5.31916782876, 103917.90082841998],
[0.00000000051, 4.32173710361, 58857.03113654799],
[0.00000000050, 0.42233074233, 27684.08958385880],
[0.00000000066, 5.06498799279, 73.29712585900],
[0.00000000048, 0.80745705976, 2703.61615467560],
[0.00000000048, 0.16882113823, 24918.31489016559],
[0.00000000049, 5.71984539931, 50380.54783942739],
[0.00000000061, 0.05575706789, 161079.37234650398],
[0.00000000047, 5.70016549134, 129373.02023068098],
[0.00000000048, 4.71754734372, 50903.12525752120],
[0.00000000050, 0.77120384679, 50689.82616208319],
[0.00000000050, 4.75557775921, 143005.66740785378],
[0.00000000046, 1.03065291695, 51868.24866217880],
[0.00000000046, 4.07474771884, 52137.67324751059],
[0.00000000045, 2.75496032307, 196137.07343261078],
[0.00000000056, 1.48667124221, 30171.89164827860],
[0.00000000047, 3.49884159195, 26575.53789282839],
[0.00000000048, 2.04489119557, 27573.19384827740],
[0.00000000046, 1.96812600979, 27223.58001346740],
[0.00000000044, 0.58466186909, 1243.48760167840],
[0.00000000043, 0.48582749664, 78338.49102328988],
[0.00000000046, 0.10663541022, 102659.44689679438],
[0.00000000049, 1.92223535597, 50049.92887576919],
[0.00000000047, 5.34811633125, 846.08283475120],
[0.00000000046, 2.32911930278, 129387.24732468258],
[0.00000000056, 1.46049477175, 28102.88481337200],
[0.00000000050, 5.62967300375, 53906.92863608099],
[0.00000000046, 5.09770472011, 151199.94274106238],
[0.00000000043, 2.30154744958, 26709.64694241340],
[0.00000000051, 2.88082546361, 27669.86248985719],
[0.00000000055, 5.55849793732, 123200.84011627098],
[0.00000000044, 0.48527820908, 80174.90890793978],
[0.00000000048, 2.59296696271, 6720.71397934140],
[0.00000000044, 0.24824938054, 742.99006053260],
[0.00000000045, 2.48949498300, 65831.66677432480],
[0.00000000045, 4.86503115391, 52483.36390411799],
[0.00000000041, 5.23419163545, 130289.95251073639],
[0.00000000041, 0.91885509326, 50910.23880452200],
[0.00000000044, 3.12424163301, 26126.03617721200],
[0.00000000042, 5.66855218492, 166740.70439565618],
[0.00000000039, 5.01739570944, 26402.08932144380],
[0.00000000038, 0.02313645928, 2111.65031337760],
[0.00000000049, 4.11697361923, 25227.59321282139],
[0.00000000038, 0.09191461136, 26118.23000257860],
[0.00000000038, 5.03146092380, 24203.00197815680],
[0.00000000051, 4.86305906640, 78153.50310350319],
[0.00000000038, 0.13003640396, 27351.06050415239],
[0.00000000038, 1.34984785206, 70269.18098269838],
[0.00000000038, 0.52032944033, 103498.41618454478],
[0.00000000040, 5.66117959398, 52174.32181044009],
[0.00000000038, 0.92511339052, 112231.70171963578],
[0.00000000051, 4.15223165568, 27170.98337386779],
[0.00000000037, 1.67308781547, 54374.89362643540],
[0.00000000038, 6.26592309401, 202.25339517410],
[0.00000000036, 3.23911910889, 176332.24614102798],
[0.00000000037, 1.90730795656, 3308.46589538040],
[0.00000000037, 3.03203144287, 76041.85279012559],
[0.00000000038, 3.17519743409, 78786.28684281638],
[0.00000000035, 3.90697621183, 80382.47328510099],
[0.00000000038, 2.00924199028, 1162.47470440780],
[0.00000000036, 1.80080871248, 19336.86230122839],
[0.00000000035, 4.66254825701, 77947.31755506598],
[0.00000000043, 1.57972686428, 130443.39704322898],
[0.00000000035, 0.74694549648, 25985.94062330859],
[0.00000000040, 2.11415671365, 3492.57156686960],
[0.00000000038, 4.65738726744, 22003.91463486980],
[0.00000000037, 0.77571838110, 16703.06213349900],
[0.00000000035, 5.00128829727, 52509.66222391780],
[0.00000000047, 0.02275392308, 25014.29411738339],
[0.00000000043, 3.15273137814, 130435.63437251298],
[0.00000000034, 3.05681901713, 2820.83114412620],
[0.00000000037, 4.68248751145, 123668.80510662538],
[0.00000000034, 5.73615227262, 45290.65639321759],
[0.00000000040, 2.76893017076, 50270.34151820800],
[0.00000000038, 6.01229835605, 26057.57628056979],
[0.00000000034, 6.25090722416, 21716.02677480000],
[0.00000000034, 0.95587257158, 78580.10129437919],
[0.00000000033, 3.35217476663, 235900.50682626116],
[0.00000000032, 2.35469869139, 2383.19301477620],
[0.00000000037, 3.80938441515, 8989.46770543239],
[0.00000000043, 2.27476214717, 25169.97285559240],
[0.00000000032, 4.14291864821, 2686.72209454120],
[0.00000000037, 0.04571185840, 52177.29075585669],
[0.00000000032, 1.53610678036, 233731.74634397858],
[0.00000000038, 3.98892541543, 1300.82681820500],
[0.00000000042, 5.10993958059, 145204.75475114079],
[0.00000000033, 2.91530565997, 130866.11389874699],
[0.00000000043, 1.77793563831, 103932.12792242158],
[0.00000000035, 5.35726747093, 26189.86565983980],
[0.00000000035, 0.65119403092, 1535.97674296940],
[0.00000000044, 3.08976502022, 8014.19820292400],
[0.00000000031, 0.90638189649, 128220.75860368418],
[0.00000000042, 3.37905134636, 23549.65463732060],
[0.00000000038, 0.38543000653, 515.46387109300],
[0.00000000039, 1.08681725797, 25773.71696170459],
[0.00000000036, 4.30448026071, 52286.01260436779],
[0.00000000031, 5.08183330827, 78213.71280281838],
[0.00000000038, 3.16432629306, 91805.13062721379],
[0.00000000039, 1.47494002110, 4022.26253196420],
[0.00000000042, 0.60192138814, 24388.62392507099],
[0.00000000037, 3.23606285260, 28791.51929624980],
[0.00000000040, 0.26646931277, 78313.70604662679],
[0.00000000036, 4.38588497247, 81591.84508100279],
[0.00000000035, 0.17056359345, 6129.29703950660],
[0.00000000030, 2.50459470137, 102755.42612401219],
[0.00000000040, 4.58870970073, 26076.85744131030],
[0.00000000040, 4.09419634913, 35833.22369743080],
[0.00000000030, 4.79837659477, 28736.35796704720],
[0.00000000032, 3.42931668217, 24402.85101907260],
[0.00000000029, 2.52212486456, 1353.74874501680],
[0.00000000030, 4.69352116507, 24072.92146977640],
[0.00000000029, 5.31070299201, 199599.31813847595],
[0.00000000030, 3.20350587499, 23762.95373275860],
[0.00000000036, 2.44362166097, 23336.35554188260],
[0.00000000028, 2.77231585227, 26312.24793727610],
[0.00000000028, 0.26775880889, 50444.68393021580],
[0.00000000029, 3.50869792127, 15406.65260500879],
[0.00000000030, 2.95993198433, 132028.58860315479],
[0.00000000028, 3.41609673663, 133882.09065283638],
[0.00000000033, 2.39929042753, 61560.64729122359],
[0.00000000032, 1.34796958829, 37698.45509994840],
[0.00000000028, 1.75026246832, 78683.19406859778],
[0.00000000033, 4.51080770987, 3776.43088573480],
[0.00000000032, 5.00665307820, 29396.36903695460],
[0.00000000037, 5.23066729388, 81604.32185142238],
[0.00000000028, 0.99927277404, 1322.67764753140],
[0.00000000029, 2.00159770770, 25004.82290928060],
[0.00000000035, 4.69198477732, 22065.64060961000],
[0.00000000029, 3.80697601044, 24513.05734029200],
[0.00000000032, 4.69401466159, 27250.37784598199],
[0.00000000031, 5.86715902954, 5815.11085963699],
[0.00000000027, 1.26702311366, 27044.19229754480],
[0.00000000030, 3.44351888035, 104819.57755665119],
[0.00000000028, 5.36078058708, 412.37109687440],
[0.00000000028, 5.73893599832, 240452.46032331996],
[0.00000000034, 5.19151430726, 2008.55753915900],
[0.00000000030, 1.73241634839, 163766.09444104518],
[0.00000000027, 5.30425762252, 24864.08530079559],
[0.00000000032, 1.12362303179, 625.67019231240],
[0.00000000030, 2.04171272941, 193937.98608932378],
[0.00000000032, 4.78663079749, 75930.51303185058],
[0.00000000030, 4.46891226150, 25450.90686955000],
[0.00000000032, 4.73906176949, 48847.67062686820],
[0.00000000027, 4.12514822062, 104358.24112519680],
[0.00000000026, 0.67609297065, 35077.37084700659],
[0.00000000033, 2.69651735555, 25647.07785669659],
[0.00000000026, 4.94767789631, 209658.82487420218],
[0.00000000035, 3.86705432105, 25466.15934073500],
[0.00000000026, 4.79912409089, 198489.93958638258],
[0.00000000026, 1.59971503257, 31281.27020037200],
[0.00000000026, 1.20008223797, 153084.84390447979],
[0.00000000026, 3.02443658098, 26724.89941359840],
[0.00000000025, 2.03567222767, 52817.21984488739],
[0.00000000027, 1.23585314301, 53.09615231440],
[0.00000000026, 5.53069670975, 25657.37279743509],
[0.00000000028, 0.93845909288, 158746.17595363196],
[0.00000000025, 1.46977800361, 1272.68102562720],
[0.00000000026, 2.45961936761, 181659.72224941078],
[0.00000000034, 2.39774146758, 39763.43339365039],
[0.00000000029, 6.23821353511, 102769.65321801379],
[0.00000000029, 4.90111965589, 116783.65521669458],
[0.00000000025, 3.02186465541, 39450.35284837340],
[0.00000000027, 3.77575599741, 103718.82882698359],
[0.00000000027, 3.92125046850, 80596.90581759460],
[0.00000000023, 0.26970481255, 52609.51802102519],
[0.00000000023, 5.98846059571, 27463.67694142000],
[0.00000000025, 1.22968381596, 49976.71893986139],
[0.00000000023, 5.57437029749, 155887.52156313117],
[0.00000000023, 5.99507985020, 50007.04580086580],
[0.00000000023, 1.44496012077, 5687.63036895200],
[0.00000000024, 0.46516912647, 130446.62925487179],
[0.00000000023, 0.94331115897, 28774.62523611540],
[0.00000000027, 0.80529908381, 2698.45144737720],
[0.00000000027, 0.27124610516, 1265.56747862640],
[0.00000000023, 0.89381228793, 156314.11975400719],
[0.00000000023, 2.96257779899, 12546.48193908300],
[0.00000000022, 5.42940490576, 1485.98012106520],
[0.00000000022, 1.03839316349, 103189.13786188899],
[0.00000000023, 1.35379542887, 52161.57918914679],
[0.00000000026, 6.01331218379, 122444.98726584678],
[0.00000000030, 2.66518277698, 25600.26839032000],
[0.00000000023, 4.07521268525, 230239.17477710896],
[0.00000000024, 0.64355332403, 203041.89308344138],
[0.00000000022, 1.39463873909, 952.07662325960],
[0.00000000023, 1.98852683178, 7392.45440208480],
[0.00000000028, 1.37381287166, 309.27832265580],
[0.00000000022, 2.15165551798, 104276.83096772949],
[0.00000000025, 4.93854060665, 101703.15774082378],
[0.00000000023, 3.12039946936, 77616.69859140778],
[0.00000000028, 0.40745832322, 55638.05098901359],
[0.00000000024, 0.44199264440, 24285.53115085240],
[0.00000000023, 1.33496997363, 163298.12945069079],
[0.00000000021, 4.01469381260, 120417.67842777158],
[0.00000000024, 0.63196904603, 77940.20400806518],
[0.00000000022, 5.70851933792, 2840.50090502600],
[0.00000000024, 4.45840068641, 183145.01295611398],
[0.00000000023, 3.62152465067, 5635.03372935240],
[0.00000000021, 3.04515069387, 9123.57675501740],
[0.00000000021, 1.96886020684, 177287.84588263658],
[0.00000000023, 0.59040250365, 25672.35065096209],
[0.00000000021, 3.40810269373, 129586.31932611899],
[0.00000000021, 3.09046433472, 26267.98027185880],
[0.00000000024, 1.94276984966, 183674.70392120858],
[0.00000000021, 3.98455358233, 6191.02301424680],
[0.00000000028, 0.93414213433, 51841.95034237900],
[0.00000000020, 4.59348701559, 52061.40717623499],
[0.00000000027, 4.61439897742, 52027.72755872209],
[0.00000000020, 0.48128544481, 52309.91533273340],
[0.00000000020, 3.31281154655, 26248.31051095900],
[0.00000000023, 1.67970146036, 23113.29318696320],
[0.00000000020, 2.44057473344, 50264.60679993120],
[0.00000000025, 5.43422956232, 2.96894541660],
[0.00000000026, 3.61410457829, 52024.75861330549],
[0.00000000020, 0.60321200025, 138319.60486120995],
[0.00000000020, 2.62628682595, 164.43591058941],
[0.00000000020, 0.65324774200, 156520.30530244438],
[0.00000000027, 4.74395008878, 391318.54712361297],
[0.00000000021, 4.45035214874, 25862.07387316400],
[0.00000000021, 1.54947465846, 148.07872442630],
[0.00000000027, 5.13202499307, 12382.04602849360],
[0.00000000020, 0.68567124507, 42.88307490340],
[0.00000000019, 1.92072938625, 78800.51393681798],
[0.00000000027, 2.48188330716, 25665.23710396129],
[0.00000000027, 1.27457874648, 7860.41939243920],
[0.00000000022, 2.29809961839, 25865.04281858059],
[0.00000000019, 4.09473921906, 76255.15188556358],
[0.00000000020, 4.67174071386, 207114.15223730978],
[0.00000000022, 2.63315058351, 7768.36655669460],
[0.00000000020, 1.24271716091, 52179.73843641149],
[0.00000000020, 6.11431848045, 24824.74577899600],
[0.00000000023, 4.18071159026, 2125.87740737920],
[0.00000000021, 0.74169140667, 1795.25844372100],
[0.00000000019, 2.66558529381, 191.44826611160],
[0.00000000020, 3.22150044915, 156547.08861034496],
[0.00000000021, 6.18753985884, 104127.26777059489],
[0.00000000020, 5.52295053123, 130363.24963659538],
[0.00000000021, 3.90684382108, 51534.39272140940],
[0.00000000020, 3.10019509540, 838.96928775040],
[0.00000000025, 5.79466888187, 26098.94884183810],
[0.00000000021, 6.23594952039, 103814.80805420138],
[0.00000000019, 5.79715725254, 26279.35140768579],
[0.00000000022, 0.71256272418, 959.12285995760],
[0.00000000021, 1.39589766697, 103395.32341032618],
[0.00000000018, 1.52837590084, 107.30530692960],
[0.00000000019, 0.60262102760, 27566.76971563859],
[0.00000000025, 0.78252166479, 53814.87580033639],
[0.00000000025, 2.29282750485, 77520.71936418998],
[0.00000000018, 2.11606037402, 26.29831979980],
[0.00000000024, 1.60264230919, 208173.53416749898],
[0.00000000021, 6.27983567062, 54344.56676543099],
[0.00000000018, 2.13288203799, 77314.53381575279],
[0.00000000019, 5.02228884604, 26114.20146137400],
[0.00000000020, 5.52520867267, 9591.54174537180],
[0.00000000017, 4.12183264175, 24602.61243487099],
[0.00000000022, 0.51026067819, 95.97922721780],
[0.00000000017, 4.48889832500, 208276.62694171758],
[0.00000000017, 3.94937058994, 25459.05155552409],
[0.00000000017, 5.29323037427, 76137.83201734339],
[0.00000000019, 3.67294881327, 6885.14988993081],
[0.00000000018, 1.02433476262, 53399.62412392700],
[0.00000000020, 2.79332004367, 25927.49577218939],
[0.00000000018, 5.83348216244, 293.41078437720],
[0.00000000024, 3.00078431660, 23446.56186310200],
[0.00000000020, 1.11172116756, 156507.74908854539],
[0.00000000017, 0.56645607004, 104984.39630560997],
[0.00000000020, 4.48412602835, 52755.49387014719],
[0.00000000019, 5.18601674976, 2544.67263689240],
[0.00000000023, 4.19936868759, 24952.22626968100],
[0.00000000017, 2.06473217893, 130005.80396999417],
[0.00000000019, 0.55214472899, 52396.21892558720],
[0.00000000019, 1.79653943961, 89.48574784600],
[0.00000000022, 3.72989530019, 48997.66049258080],
[0.00000000020, 5.93006048006, 11852.35506339900],
[0.00000000018, 6.24870732707, 233681.74972207438],
[0.00000000021, 3.01566725550, 25907.82601128960],
[0.00000000016, 1.73390726659, 52911.68279668019],
[0.00000000017, 3.23716624064, 117893.03376878797],
[0.00000000022, 0.46092942812, 19367.18916223280],
[0.00000000016, 5.06429474773, 43981.53094993980],
[0.00000000021, 1.13950009268, 25650.25925043430],
[0.00000000019, 3.19311280972, 47803.92991637420],
[0.00000000021, 4.64218889935, 112545.88789950538],
[0.00000000017, 2.96216633831, 102975.83876645098],
[0.00000000016, 0.60226326404, 149846.19399604558],
[0.00000000016, 5.86803075725, 127098.90328117118],
[0.00000000018, 1.20391834667, 87367.61641884019],
[0.00000000016, 4.53670173929, 2667.05233364140],
[0.00000000017, 5.77652308057, 51130.65144696079],
[0.00000000018, 5.87706432040, 78057.52387628538],
[0.00000000019, 5.24206436649, 60370.08161635699],
[0.00000000016, 1.31713012946, 78843.39701172139],
[0.00000000019, 5.33584429695, 104454.70534051539],
[0.00000000015, 4.52789928708, 25984.12095299360],
[0.00000000016, 4.12162585450, 189386.03259226495],
[0.00000000017, 3.51115348265, 45455.09230380700],
[0.00000000015, 1.65943772958, 51596.11869614960],
[0.00000000015, 4.28577331083, 117.31986822020],
[0.00000000016, 0.28814169191, 78469.89497315978],
[0.00000000015, 0.64079475058, 53093.73656913019],
[0.00000000020, 5.58915267196, 1423.56473196300],
[0.00000000015, 6.19871258212, 156740.71794488319],
[0.00000000015, 2.05066243688, 16342.58258571760],
[0.00000000018, 0.93517825293, 104344.98400739678],
[0.00000000015, 4.64013294295, 2974.60995461100],
[0.00000000015, 2.61010767947, 7830.09253143480],
[0.00000000015, 2.60585262136, 151.04766984290],
[0.00000000018, 0.92309429794, 1577.34354244780],
[0.00000000017, 1.36952124854, 78115.63070029629],
[0.00000000018, 1.95659679786, 102872.74599223239],
[0.00000000017, 5.37350443158, 25384.26995695679],
[0.00000000015, 2.12952532360, 128106.31931499895],
[0.00000000018, 4.06290374391, 51439.92976961659],
[0.00000000015, 4.32808623679, 77741.13200662879],
[0.00000000014, 3.46389680879, 104426.39416486409],
[0.00000000020, 5.15870331048, 154408.65498906678],
[0.00000000014, 4.53089771582, 57503.28239153120],
[0.00000000016, 3.64720066701, 24072.23205541439],
[0.00000000015, 2.96793644807, 24719.24288872919],
[0.00000000014, 0.79165737765, 25928.60140678200],
[0.00000000014, 4.36570321274, 78249.48233072099],
[0.00000000014, 5.35774038541, 896.07945665540],
[0.00000000014, 5.57146329055, 104248.51979207818],
[0.00000000014, 6.22061869408, 104874.18998439058],
[0.00000000015, 0.66056760946, 77622.29586298359],
[0.00000000017, 4.39404084250, 162810.49469943657],
[0.00000000017, 4.01700926317, 51876.67988887919],
[0.00000000014, 5.96074966457, 4371.87636677420],
[0.00000000014, 5.51412243126, 48713.56157728320],
[0.00000000014, 5.04161806976, 53029.00266490040],
[0.00000000014, 3.09979574700, 128747.35003836859],
[0.00000000019, 4.61702547610, 16028.39640584800],
[0.00000000017, 2.09526572835, 52277.76880141400],
[0.00000000014, 1.51516908270, 52164.76058288449],
[0.00000000014, 2.76589411039, 26734.91397488900],
[0.00000000017, 5.31477308011, 103608.62250576419],
[0.00000000013, 6.04881581356, 52812.80255517260],
[0.00000000015, 0.92065367569, 256327.07791868312],
[0.00000000016, 2.76936523753, 46046.50924364180],
[0.00000000019, 4.91561037107, 277.03499374140],
[0.00000000015, 1.87874008695, 26161.20026743319],
[0.00000000013, 1.48593089360, 54824.26110862140],
[0.00000000015, 1.37228117638, 18043.37807764579],
[0.00000000018, 2.95472168569, 76152.05911134499],
[0.00000000017, 1.57020520015, 104241.40624507738],
[0.00000000018, 2.97721991956, 187167.27548807819],
[0.00000000013, 3.49902133309, 78397.81847430758],
[0.00000000018, 2.18386661425, 149288.74325784518],
[0.00000000017, 5.38851170070, 52041.69723356339],
[0.00000000013, 6.26956660770, 90989.16285949759],
[0.00000000013, 1.13674691740, 237009.88537835456],
[0.00000000014, 2.18322393546, 225687.22128005016],
[0.00000000013, 6.15204536524, 35211.47989659159],
[0.00000000017, 1.32178768936, 106262.81204951399],
[0.00000000014, 1.73651187343, 2912.88397987080],
[0.00000000013, 0.84907711504, 102343.05502713779],
[0.00000000013, 2.39970220380, 155460.92337225519],
[0.00000000017, 4.15374414668, 26014.60601571519],
[0.00000000013, 0.72484082297, 153878.96402397218],
[0.00000000013, 3.04907288197, 80432.46990700519],
[0.00000000013, 1.37316946035, 104035.22069664019],
[0.00000000015, 3.12808384217, 173.44857138459],
[0.00000000013, 2.93774353095, 533.62311835770],
[0.00000000013, 2.24535401962, 246113.79237247216],
[0.00000000016, 0.39665846969, 78112.66175487968],
[0.00000000015, 4.75053341616, 130020.03106399579],
[0.00000000016, 0.76587038276, 557.45073820040],
[0.00000000015, 6.01045796437, 51112.49219969609],
[0.00000000015, 0.93774708323, 461.33643145440],
[0.00000000012, 4.03988032603, 77956.15180375299],
[0.00000000015, 1.43833460468, 169093.57054942798],
[0.00000000014, 2.14749108820, 78129.60037513758],
[0.00000000012, 4.57098987537, 6751.04084034580],
[0.00000000017, 0.64086933600, 5131.64108405760],
[0.00000000013, 5.02936180992, 144916.86689107098],
[0.00000000016, 3.65387335184, 104028.10714963939],
[0.00000000013, 3.37789792164, 79212.88503369238],
[0.00000000013, 1.38408689559, 4885.80943782820],
[0.00000000012, 4.95862705668, 50536.73676596039],
[0.00000000014, 2.05563043425, 107692.22499299659],
[0.00000000012, 3.93772391530, 104668.00443595338],
[0.00000000014, 3.26407683636, 104401.60918820098],
[0.00000000014, 2.94492731309, 51120.35650622229],
[0.00000000013, 5.30554859990, 155475.15046625677],
[0.00000000014, 5.14050840336, 726.48201987020],
[0.00000000012, 2.41433841278, 24551.92639860479],
[0.00000000013, 3.02673254226, 182828.62108645738],
[0.00000000012, 2.94598982599, 5039.58824831300],
[0.00000000013, 3.57478000552, 78484.12206716138],
[0.00000000013, 2.94343799803, 79315.97780791098],
[0.00000000012, 5.17024351037, 103402.43695732698],
[0.00000000012, 3.19152649116, 28309.75977617119],
[0.00000000012, 6.16852058989, 78413.27262185719],
[0.00000000013, 4.35939831008, 133767.65136415116],
[0.00000000013, 5.96217383792, 2538.24850425360],
[0.00000000012, 2.97455363125, 26290.15653674829],
[0.00000000012, 1.94777069809, 156377.85565231058],
[0.00000000012, 1.81926611664, 70069.43409151399],
[0.00000000013, 1.24212367708, 4437.51420837359],
[0.00000000012, 0.53775842570, 106470.37642667518],
[0.00000000012, 4.06029507610, 79487.52726550119],
[0.00000000012, 1.39982040688, 77417.62658997139],
[0.00000000012, 5.70094378358, 79330.20490191258],
[0.00000000012, 2.36617272843, 79994.83177765518],
[0.00000000012, 4.77094162628, 78999.58593825439],
[0.00000000012, 5.23189289937, 26411.40855823160],
[0.00000000014, 2.99800402366, 1073.60902419080],
[0.00000000012, 6.15146193785, 103704.60173298199],
[0.00000000012, 1.58617824624, 78571.26704569219],
[0.00000000013, 0.37894193721, 53124.98189211819],
[0.00000000012, 3.86549077079, 189853.99758261938],
[0.00000000013, 4.70785515154, 234261.43730907318],
[0.00000000012, 4.54097648940, 56259.79478985279],
[0.00000000012, 1.32257018476, 149756.70824819959],
[0.00000000011, 5.69779744921, 222224.97657418498],
[0.00000000012, 0.60900120711, 2751.54759969160],
[0.00000000011, 0.79876219873, 78225.57638908479],
[0.00000000013, 2.57664086838, 1116.49209909420],
[0.00000000012, 0.86411055123, 78043.29678228378],
[0.00000000011, 4.02869363295, 263097.78851992876],
[0.00000000011, 3.97587600566, 76998.14194609619],
[0.00000000011, 5.29433199334, 52797.55008398759],
[0.00000000013, 5.69550284497, 51688.17153189420],
[0.00000000015, 3.91946731118, 27665.24668402200],
[0.00000000013, 4.89334198524, 45424.76544280259],
[0.00000000012, 2.33066141026, 130336.42293365239],
[0.00000000012, 2.97893637259, 25885.64974640009],
[0.00000000012, 0.33532325982, 41494.55574658299],
[0.00000000011, 1.81390783997, 104301.61594439259],
[0.00000000011, 3.67540306066, 79181.63971070439],
[0.00000000013, 1.92207364074, 2962.88060177500],
[0.00000000012, 4.51335455691, 54190.78795494619],
[0.00000000012, 5.89140397220, 156954.01704032118],
[0.00000000012, 5.80412470555, 72134.41238521598],
[0.00000000011, 2.54446138738, 26183.88236879199],
[0.00000000011, 0.57810940674, 142871.55835826878],
[0.00000000014, 1.49797486148, 103883.64757594238],
[0.00000000011, 0.25563634033, 52663.44103440259],
[0.00000000011, 4.34226157432, 63786.35824152260],
[0.00000000011, 5.79546155779, 76358.24465978218],
[0.00000000011, 5.43581617959, 4398.17468657401],
[0.00000000010, 3.45435285202, 26830.89320210680],
[0.00000000010, 1.05961891051, 216897.50046580215],
[0.00000000010, 5.54078372768, 53867.97195265079],
[0.00000000013, 4.09291929409, 78378.14871340781],
[0.00000000012, 6.09214378282, 156523.53751408719],
[0.00000000012, 2.30793560033, 192828.60753723037],
[0.00000000011, 5.49984194986, 130593.29451835579],
[0.00000000010, 5.02934387609, 63.73589830340],
[0.00000000010, 2.56161075764, 3178.14579056760],
[0.00000000010, 4.51229030686, 80912.16425019559],
[0.00000000010, 3.26964460988, 143980.93691036216],
[0.00000000014, 0.09133406732, 138.51749687070],
[0.00000000014, 4.26704901561, 52171.87412988529],
[0.00000000010, 2.12874423735, 181563.05360783098],
[0.00000000010, 2.68594312022, 53551.58008299420],
[0.00000000010, 5.01052160566, 53311.48315504160],
[0.00000000013, 2.21304135803, 287.88786006980],
[0.00000000010, 5.99285759925, 129063.74190802519],
[0.00000000010, 0.23580667035, 159969.99379441059],
[0.00000000014, 4.15846442712, 52190.03337714999],
[0.00000000014, 2.17544501087, 2506.64496425660],
[0.00000000010, 2.39055885342, 78262.22495201428],
[0.00000000010, 5.33589950489, 128843.32926558638],
[0.00000000010, 3.69795961564, 175934.09713761978],
[0.00000000010, 5.50982370855, 181548.82651382938],
[0.00000000012, 0.91293309387, 53258.88651544199],
[0.00000000010, 0.21546965297, 155674.22246769318],
[0.00000000010, 5.05408550952, 182465.75879388479],
[0.00000000011, 1.47055363263, 76991.02839909539],
[0.00000000014, 1.74381856487, 36.64856292950],
[0.00000000014, 1.73080789777, 171292.65789271498],
[0.00000000010, 1.79047706298, 235746.72801577636],
[0.00000000012, 2.86918517100, 2045.30853280220],
[0.00000000013, 5.94639118711, 168959.46149984296],
[0.00000000010, 5.24213703651, 130285.73689738619],
[0.00000000014, 6.10459624713, 454.90936652730],
[0.00000000010, 5.39397583397, 77.75054398390],
[0.00000000011, 1.99827759086, 1088.60315660100],
[0.00000000010, 1.76064600598, 52489.99246301800],
[0.00000000010, 5.11611480967, 113455.51956041438],
[0.00000000014, 4.11983704037, 54060.70744656579],
[0.00000000012, 2.84049561669, 183041.92018189539],
[0.00000000012, 3.18297085790, 228508.05242417638],
[0.00000000010, 1.62042818189, 231348.55332920236],
[0.00000000010, 2.38308200520, 181975.42470470538],
[0.00000000010, 5.17901157458, 203375.74902421077],
[0.00000000010, 1.70609651468, 78597.56536549199],
[0.00000000010, 3.01880618190, 104501.17576343138],
[0.00000000011, 1.42631059185, 58220.03486452380],
[0.00000000010, 3.45269160846, 99979.73619952259],
[0.00000000011, 4.42716378223, 235320.81923926238],
[0.00000000010, 4.45423293249, 5469.88378304060],
[0.00000000009, 4.68983089958, 80462.79676800959],
[0.00000000009, 1.77635894319, 50290.90511973100],
[0.00000000010, 1.41464391522, 48091.81777644400],
[0.00000000011, 5.93477819724, 158116.49174472898],
[0.00000000010, 2.55614008171, 105418.10804348679],
[0.00000000009, 3.11835021508, 52206.13314415280],
[0.00000000009, 2.24380470375, 299.12639426920],
[0.00000000009, 3.22171579815, 51006.21803173979],
[0.00000000009, 3.24808968579, 78697.42116259939],
[0.00000000011, 0.73383746517, 17605.73994829580],
[0.00000000010, 2.45523846147, 233835.52853255918],
[0.00000000009, 4.35363918141, 190809.59732422797],
[0.00000000009, 2.77090630961, 76094.94894243999],
[0.00000000012, 0.23038883503, 130907.48069822539],
[0.00000000009, 5.05551915235, 70383.62027138360],
[0.00000000009, 5.11051597902, 156093.70711156838],
[0.00000000011, 5.44617170556, 56777.75640211140],
[0.00000000009, 4.67339642631, 104771.09721017198],
[0.00000000009, 4.56456351898, 259819.64948555276],
[0.00000000009, 0.73352390338, 75085.56363415498],
[0.00000000010, 2.64743106367, 153186.80642274539],
[0.00000000010, 5.18315351919, 1382.19793248460],
[0.00000000012, 4.75714453262, 250665.74586953096],
[0.00000000011, 5.79093643324, 292628.26660646834],
[0.00000000009, 6.24971585432, 202420.14928260217],
[0.00000000012, 5.83966176266, 11790.62908865880],
[0.00000000011, 2.84614041718, 184204.39488630318],
[0.00000000010, 3.41187941424, 1905.46476494040],
[0.00000000010, 3.00240265080, 118828.96374949679],
[0.00000000009, 3.90754065548, 154308.66174525839],
[0.00000000010, 0.88848120961, 51315.49635439559],
[0.00000000011, 4.49431301230, 156531.30018480319],
[0.00000000009, 0.37279337773, 182622.43553802017],
[0.00000000009, 5.94479236467, 38634.38508065720],
[0.00000000009, 0.28434529807, 5019.91848741320],
[0.00000000011, 5.30507160437, 51257.87599716660],
[0.00000000009, 5.05598171209, 62197.64356324779],
[0.00000000009, 2.00743011270, 154194.22245657316],
[0.00000000010, 2.29548861266, 1211.34107035900],
[0.00000000009, 1.40840962373, 78149.27013603736],
[0.00000000011, 2.69818187519, 195047.36464141717],
[0.00000000009, 3.77338110020, 52073.84376488279],
[0.00000000010, 4.16632261841, 1130.15394758580],
[0.00000000009, 4.71851534374, 257436.45647077652],
[0.00000000009, 1.56697202296, 156107.93420556998],
[0.00000000010, 3.84491070936, 42790.96527507320],
[0.00000000010, 0.84911221571, 61921.12683900499],
[0.00000000011, 3.43504498990, 81725.95413058778],
[0.00000000008, 3.46841587447, 156534.53239644598],
[0.00000000009, 3.07023951195, 78265.19389743089],
[0.00000000011, 5.33240591310, 49424.25868345679],
[0.00000000009, 3.80703237983, 184834.07909520617],
[0.00000000010, 5.24984657637, 860.30992875280],
[0.00000000008, 2.32846981012, 156451.15277816958],
[0.00000000009, 5.86810139691, 221135.26778299136],
[0.00000000009, 0.07267483428, 54879.42243782400],
[0.00000000009, 3.53847001127, 1169.58825140860],
[0.00000000008, 0.40730399000, 5852.78031526380],
[0.00000000010, 5.08938165465, 53661.09698985160],
[0.00000000009, 0.09227292796, 285857.55600522275],
[0.00000000009, 1.53921610006, 171004.77003264519],
[0.00000000010, 6.02369999880, 105403.88094948517],
[0.00000000009, 1.41005383919, 215473.93573383916],
[0.00000000008, 2.95064025568, 182611.44065566138],
[0.00000000011, 0.82592745776, 52098.05573916449],
[0.00000000011, 1.89268014069, 53265.51507434200],
[0.00000000009, 0.91534494504, 130446.14426677099],
[0.00000000011, 5.68651428373, 97466.46267636596],
[0.00000000008, 6.09336539202, 65538.25598994759],
[0.00000000010, 4.71864870979, 1865.23140251760],
[0.00000000011, 0.33942008091, 2352.86615377180],
[0.00000000010, 0.58149039679, 51554.06248230919],
[0.00000000009, 4.63908561414, 130329.30938665158],
[0.00000000008, 3.29340479484, 76532.58707178998],
[0.00000000008, 0.39996086139, 31722.93687092660],
[0.00000000009, 2.07892055945, 84307.93800609799],
[0.00000000008, 0.10251061291, 130489.51232977519],
[0.00000000009, 4.86488540298, 197380.56103428919],
[0.00000000008, 2.84319355109, 247223.17092456557],
[0.00000000009, 5.40644601602, 205260.65018762815],
[0.00000000008, 2.99554948925, 28199.55345495179],
[0.00000000008, 2.31903661034, 50951.98844236979],
[0.00000000009, 3.67243760379, 132558.27956824939],
[0.00000000010, 3.84482406254, 199.07200143640],
[0.00000000008, 5.13311255182, 133780.12813457078],
[0.00000000008, 4.50659262629, 31775.53351052620],
[0.00000000010, 3.05711078565, 12098.18670962840],
[0.00000000009, 5.43609233651, 65851.33653522459],
[0.00000000008, 3.16471275120, 53438.96364572659],
[0.00000000008, 5.49628419906, 208063.32784627957],
[0.00000000009, 0.80806156177, 84944.93427812219],
[0.00000000008, 1.45936166924, 50160.82461135059],
[0.00000000009, 3.83369994945, 79902.77894191058],
[0.00000000008, 5.05169260225, 220025.88923089796],
[0.00000000010, 0.99908522442, 78373.91574594198],
[0.00000000008, 1.78435325528, 4743.40176317040],
[0.00000000009, 2.44642878457, 76468.45098100159],
[0.00000000010, 0.64041079500, 106684.80895916879],
[0.00000000008, 0.22706755866, 130514.29730643828],
[0.00000000008, 4.45568539518, 175844.61138977378],
[0.00000000008, 5.30875425569, 104991.50985261079],
[0.00000000008, 4.26578657244, 78267.64157798568],
[0.00000000010, 3.66900856638, 22595.33157470459],
[0.00000000008, 5.39530906170, 1168.89883704660],
[0.00000000007, 2.97217552646, 130962.09312596478],
[0.00000000008, 5.41659156640, 106082.73491922939],
[0.00000000007, 6.14449914187, 154835.25317994278],
[0.00000000009, 3.77109166248, 76777.72930365738],
[0.00000000010, 2.68699198523, 31903.01400121119],
[0.00000000010, 4.11325286170, 51861.62010327879],
[0.00000000010, 6.22285311837, 52213.93931878620],
[0.00000000008, 4.05691998652, 130432.88714897096],
[0.00000000008, 5.44182392744, 24844.41553989579],
[0.00000000008, 5.31551782104, 26247.20487636640],
[0.00000000007, 3.34982243781, 53771.99272543299],
[0.00000000007, 0.76435484795, 103829.03514820298],
[0.00000000009, 0.48166296597, 4571.62325795859],
[0.00000000010, 2.53857628850, 23735.03698780239],
[0.00000000009, 3.06932982640, 51102.19725895759],
[0.00000000009, 0.81667861584, 180396.56488683258],
[0.00000000008, 1.37381137878, 182619.20332637738],
[0.00000000010, 4.53462580754, 195181.47369100217],
[0.00000000007, 5.92229713446, 102129.75593169978],
[0.00000000009, 1.70197819412, 114.39910691340],
[0.00000000009, 2.75554865259, 52145.47942214399],
[0.00000000007, 5.03002929900, 78905.12298646157],
[0.00000000008, 4.70162992466, 77684.02183772379],
[0.00000000007, 2.16016333042, 252884.50297371777],
[0.00000000007, 4.70104811610, 197092.67317421938],
[0.00000000008, 3.34882273958, 92.05283574460],
[0.00000000007, 4.64287583099, 104659.17018726638],
[0.00000000007, 1.74834665027, 79116.90580647459],
[0.00000000007, 1.40803395997, 78149.31031780918],
[0.00000000007, 5.96603423152, 1685.05212250160],
[0.00000000008, 5.74025115791, 27441.65188659100],
[0.00000000007, 3.32172728837, 186057.89693598478],
[0.00000000007, 5.77399157694, 52822.81711646319],
[0.00000000009, 5.40969007280, 25970.58327335399],
[0.00000000007, 5.03097379670, 51092.72605085480],
[0.00000000008, 4.85500497006, 79353.41821591619],
[0.00000000009, 2.91790460578, 128857.55635958798],
[0.00000000010, 2.62831495455, 104145.42701785959],
[0.00000000008, 3.65717048924, 50476.52706664519],
[0.00000000010, 4.97375703081, 128960.64913380658],
[0.00000000007, 0.63731291763, 132350.71519108818],
[0.00000000007, 3.70718359263, 61165.27398858079],
[0.00000000007, 1.52409890800, 224577.84272795678],
[0.00000000007, 5.83295581556, 78339.97549599818],
[0.00000000007, 1.28982657880, 127791.06088239799],
[0.00000000007, 4.38077281912, 87648.55043279778],
[0.00000000007, 0.78772735446, 104044.05494532720],
[0.00000000007, 5.55018242223, 148532.89040742096],
[0.00000000008, 3.94353800260, 77929.85348395319],
[0.00000000007, 4.68484570125, 129971.55071751658],
[0.00000000007, 5.46082675395, 76352.50994150538],
[0.00000000007, 0.89727780818, 28213.78054895339],
[0.00000000006, 2.25546242417, 79955.87509422498],
[0.00000000007, 1.85784871452, 28096.46068073319],
[0.00000000006, 6.22318977780, 261988.40996783535],
[0.00000000006, 3.92166942434, 182402.02289558138],
[0.00000000006, 4.54553590954, 26235.98186600050],
[0.00000000006, 0.04385251847, 182634.99175191917],
[0.00000000006, 3.27000773736, 104557.79811473397],
[0.00000000006, 1.48316940910, 26191.68533015479],
[0.00000000006, 1.42098831764, 26026.17716683400],
[0.00000000006, 4.63624566094, 57369.17334194619],
[0.00000000006, 2.24614788518, 131079.41299418498],
[0.00000000008, 1.46359871781, 74935.57376844239],
[0.00000000007, 0.19039890992, 117077.06600107178],
[0.00000000006, 2.30839350284, 27353.47062020059],
[0.00000000008, 4.05701479596, 60170.33472517260],
[0.00000000006, 2.25676540184, 118007.47305747319],
[0.00000000007, 5.19369769843, 91919.56991589899],
[0.00000000006, 2.17221286567, 27573.88326263939],
[0.00000000006, 3.04358438526, 83591.18553310538],
[0.00000000006, 5.50261387027, 26238.95081141709],
[0.00000000006, 5.55141392261, 207747.62539098498],
[0.00000000007, 3.67760971466, 229129.79622501558],
[0.00000000006, 5.14998820697, 130364.73410930368],
[0.00000000006, 2.59291082745, 52186.85198341230],
[0.00000000006, 3.70620257597, 182608.20844401857],
[0.00000000007, 5.89987227798, 53757.76563143139],
[0.00000000007, 1.17954845926, 209232.91609768818],
[0.00000000007, 1.99199973963, 88285.54670482199],
[0.00000000006, 5.29985761538, 175376.64639941938],
[0.00000000007, 1.76338847974, 55484.27217852879],
[0.00000000008, 0.55724966367, 129806.73196855778],
[0.00000000005, 4.19687137282, 111032.83741969639],
[0.00000000006, 1.86021237763, 96471.52341295779],
[0.00000000006, 1.44535366888, 20043.67456019880],
[0.00000000006, 1.48244229587, 260349.34045064733],
[0.00000000006, 1.00031747475, 51538.81001112419],
[0.00000000005, 0.08842088266, 79859.89586700719],
[0.00000000006, 2.17116807817, 156373.64003896038],
[0.00000000007, 2.57540094308, 77218.55458853499],
[0.00000000006, 4.66124811472, 65717.22748563958],
[0.00000000005, 5.69376389474, 52400.15107885030],
[0.00000000006, 2.47972848111, 266540.36346489414],
[0.00000000005, 4.47086994598, 27360.58416720139],
[0.00000000005, 3.20880924837, 259769.65286364855],
[0.00000000005, 3.98361684334, 54862.52837768960],
[0.00000000007, 2.86077141334, 179172.74704605396],
[0.00000000005, 2.46087822928, 156681.19765992998],
[0.00000000007, 5.00361119157, 209762.60706278277],
[0.00000000005, 5.35670104895, 26513.81191808820],
[0.00000000006, 3.62607025643, 27883.16158529519],
[0.00000000005, 0.80991017339, 25661.99436506020],
[0.00000000006, 0.20069428083, 50490.75416064679],
[0.00000000005, 3.77056538505, 164407.50800278416],
[0.00000000005, 2.71005052987, 104427.87863757239],
[0.00000000006, 0.84754795471, 104466.05185498200],
[0.00000000005, 2.69389382491, 180496.55813064099],
[0.00000000005, 4.04820376371, 129277.04100346318],
[0.00000000006, 0.57829057010, 50600.96048186620],
[0.00000000006, 4.21216601811, 182595.65223011958],
[0.00000000005, 3.59670550074, 131072.29944718418],
[0.00000000005, 0.08842684725, 27993.36790651460],
[0.00000000006, 0.00392034365, 73891.83305794839],
[0.00000000006, 4.68979746906, 26149.62911631439],
[0.00000000005, 4.61789756581, 20894.53608277640],
[0.00000000005, 3.57093232780, 53654.67285721279],
[0.00000000005, 0.36682731238, 146505.58156934578],
[0.00000000005, 1.40545824640, 233202.05537888398],
[0.00000000006, 2.35439456378, 139543.42270198859],
[0.00000000004, 1.28935961583, 234364.53008329177],
[0.00000000004, 1.10749672173, 51086.09749195479],
[0.00000000005, 3.64294402198, 27331.39074325260],
[0.00000000004, 0.00216060134, 213255.17862965238],
[0.00000000004, 4.40507427126, 129483.22655190038],
[0.00000000004, 2.18529936793, 23384.28698689860],
[0.00000000005, 0.93391333656, 52102.50915728939],
[0.00000000004, 2.33941435272, 23389.45169419700],
[0.00000000004, 3.59370682931, 46564.47085590040],
[0.00000000004, 2.90835831307, 61299.38303816579],
[0.00000000004, 6.27884818175, 170068.84005193636],
[0.00000000004, 4.90170477242, 104888.41707839219],
[0.00000000004, 4.56426377076, 46131.57770177300],
[0.00000000005, 2.12658067178, 130542.60848208958],
[0.00000000005, 2.50519016528, 79845.66877300559],
[0.00000000004, 6.24881318031, 18073.70493865020],
[0.00000000004, 1.10868110225, 52072.02409456780],
[0.00000000004, 6.14515791357, 34102.10134449819],
[0.00000000004, 2.94097893970, 129902.71119577558],
[0.00000000004, 2.91542426579, 130215.17091216908],
[0.00000000005, 2.20146513310, 82865.65954368559],
[0.00000000005, 4.46570663623, 104237.17327761157],
[0.00000000004, 5.13334797430, 26387.02953584340],
[0.00000000004, 5.34965278511, 24787.07632336920],
[0.00000000004, 4.17772291197, 53132.09543911899],
[0.00000000004, 2.66996288682, 25572.43927048119],
[0.00000000005, 1.14175711692, 188898.39784101078],
], [
[26088.14706222746, 0.00000000000, 0.00000000000],
[0.01126007832, 6.21703970996, 26087.90314157420],
[0.00303471395, 3.05565472363, 52175.80628314840],
[0.00080538452, 6.10454743366, 78263.70942472259],
[0.00021245035, 2.83531934452, 104351.61256629678],
[0.00005592094, 5.82675673328, 130439.51570787099],
[0.00001472233, 2.51845458395, 156527.41884944518],
[0.00000352244, 3.05238094403, 1109.37855209340],
[0.00000388318, 5.48039225891, 182615.32199101939],
[0.00000093540, 6.11791163931, 27197.28169366760],
[0.00000090579, 0.00045481669, 24978.52458948080],
[0.00000102743, 2.14879173777, 208703.22513259358],
[0.00000051941, 5.62107554052, 5661.33204915220],
[0.00000044370, 4.57348500464, 25028.52121138500],
[0.00000028070, 3.04195430989, 51066.42773105500],
[0.00000022003, 0.86475371243, 955.59974160860],
[0.00000027295, 5.09210138837, 234791.12827416777],
[0.00000020425, 3.71509622702, 20426.57109242200],
[0.00000020221, 0.51934047295, 21535.94964451540],
[0.00000017496, 5.72663608620, 4551.95349705880],
[0.00000016680, 1.35134428173, 529.69096509460],
[0.00000015306, 1.79184360652, 11322.66409830440],
[0.00000015398, 5.74263453989, 19.66976089979],
[0.00000013964, 3.59426938083, 24498.83024629040],
[0.00000012822, 2.69591798562, 53285.18483524180],
[0.00000012621, 3.89530641889, 3.88133535800],
[0.00000012566, 4.70537436663, 1059.38193018920],
[0.00000007974, 4.17682324505, 26617.59410666880],
[0.00000007929, 0.50426804318, 46514.47423399620],
[0.00000008024, 3.92723313702, 27043.50288318280],
[0.00000007665, 2.48158305355, 57837.13833230060],
[0.00000008639, 6.06360282793, 77154.33087262919],
[0.00000006838, 2.77387065312, 7.11354700080],
[0.00000006554, 5.53478998989, 6770.71060124560],
[0.00000005846, 4.28139659800, 16983.99614745660],
[0.00000007285, 1.74581868954, 260879.03141574195],
[0.00000007179, 2.97766079692, 2218.75710418680],
[0.00000006364, 2.13805619380, 25132.30339996560],
[0.00000005883, 2.19545230409, 13521.75144159140],
[0.00000004969, 2.47752134180, 30639.85663863300],
[0.00000004578, 1.55845855383, 27147.28507176339],
[0.00000004857, 4.84757952324, 37410.56723987860],
[0.00000005022, 3.94124675992, 25661.30495069820],
[0.00000004381, 4.94471456712, 213.29909543800],
[0.00000004211, 5.53886788148, 83925.04147387479],
[0.00000004299, 5.09070560802, 10213.28554621100],
[0.00000004593, 0.81920676333, 25558.21217647960],
[0.00000003571, 2.34341884629, 32858.61374281979],
[0.00000004454, 5.79159156180, 3442.57494496540],
[0.00000003547, 3.59413896239, 26068.23338067440],
[0.00000003664, 1.39952931281, 77204.32749453338],
[0.00000003417, 0.49855041138, 22645.32819660879],
[0.00000003195, 1.25743024246, 14765.23904326980],
[0.00000003031, 4.45207030477, 7238.67559160000],
[0.00000003284, 5.22996707635, 25448.00585526019],
[0.00000002974, 0.14234349726, 50586.73338786459],
[0.00000002855, 0.67083991526, 26091.78447693220],
[0.00000002773, 3.54351198199, 72602.37737557039],
[0.00000003132, 6.21365344759, 26080.78959457339],
[0.00000002732, 5.64171761904, 1589.07289528380],
[0.00000002652, 0.88219699366, 52705.49724824299],
[0.00000003125, 6.07160751766, 28306.66024576099],
[0.00000002799, 2.51152391376, 26107.57290247399],
[0.00000002403, 1.15515130360, 25035.63475838580],
[0.00000002274, 1.85167073193, 36301.18868778519],
[0.00000002501, 4.34723465048, 41962.52073693740],
[0.00000002321, 5.44262378304, 26084.02180621620],
[0.00000002535, 5.80101392346, 26095.01668857500],
[0.00000002872, 1.63503968499, 25021.40766438420],
[0.00000002066, 1.07231845630, 43071.89928903080],
[0.00000002616, 2.78322243283, 103242.23401420339],
[0.00000001987, 2.95923214706, 23969.13928119580],
[0.00000001979, 4.44092591248, 103292.23063610759],
[0.00000001974, 0.83681704901, 12566.15169998280],
[0.00000001700, 2.28603732736, 110012.94461544899],
[0.00000001677, 4.63366122462, 53235.18821333759],
[0.00000001954, 4.67733727976, 286966.93455731616],
[0.00000001653, 1.25518276011, 33326.57873317420],
[0.00000001785, 1.80830270808, 26301.20223701220],
[0.00000001784, 5.17926273269, 426.59819087600],
[0.00000002143, 5.16312278245, 51220.20654153979],
[0.00000001597, 5.53494401703, 56727.75978020720],
[0.00000001590, 0.07660134798, 23869.14603738740],
[0.00000001574, 3.75870586370, 73711.75592766379],
[0.00000001362, 1.13830507985, 68050.42387851159],
[0.00000001358, 1.45317020242, 51646.11531805379],
[0.00000001586, 4.65681044624, 79373.08797681599],
[0.00000001347, 3.80254397382, 19317.19254032860],
[0.00000001242, 3.79389911401, 25874.60404613620],
[0.00000001124, 1.28920904043, 31749.23519072640],
[0.00000001065, 4.31416942177, 40853.14218484400],
[0.00000001014, 3.58126441973, 48733.23133818299],
[0.00000001259, 1.73130656223, 12432.04265039780],
[0.00000000989, 0.33276224293, 52156.13652224860],
[0.00000001057, 4.35251408825, 77734.01845962799],
[0.00000001033, 3.72503880786, 6283.07584999140],
[0.00000000894, 0.29768279333, 105460.99111839019],
[0.00000000910, 0.49823258962, 99799.65906923798],
[0.00000000999, 5.29812267938, 65697.55772473979],
[0.00000001138, 2.56391312022, 29530.47808653960],
[0.00000000876, 4.91112286703, 62389.09182935939],
[0.00000000912, 0.27449857787, 98690.28051714458],
[0.00000000879, 4.78847722011, 18849.22754997420],
[0.00000000869, 3.87957425954, 78793.40038981718],
[0.00000000831, 2.35459129726, 27676.97603685800],
[0.00000000791, 1.17444825871, 129380.13377768178],
[0.00000000782, 3.92653768734, 38654.05484155699],
[0.00000000782, 3.69412482234, 52179.68761850640],
[0.00000000745, 2.09648894863, 51535.90899683439],
[0.00000000736, 6.05470921559, 114.43928868521],
[0.00000000733, 3.23019978320, 47623.85278608960],
[0.00000000698, 2.99026308247, 52168.69273614759],
[0.00000000780, 5.77004504059, 129330.13715577759],
[0.00000000752, 4.22525357653, 51123.53789995999],
[0.00000000752, 4.70099207936, 51109.31080595839],
[0.00000000651, 5.87383050095, 2333.19639287200],
[0.00000000699, 4.82823185979, 38519.94579197200],
[0.00000000656, 3.65375726729, 25668.41849769900],
[0.00000000660, 1.98037689941, 26514.50133245020],
[0.00000000808, 6.27898737551, 53131.40602475700],
[0.00000000753, 5.64446551994, 45892.73043315699],
[0.00000000610, 1.21194007471, 153.77881048480],
[0.00000000604, 5.29267380518, 136100.84775702319],
[0.00000000811, 4.22885181263, 25654.19140369739],
[0.00000000697, 1.89331617498, 77308.10968311399],
[0.00000000581, 2.61707271637, 76674.63652943878],
[0.00000000549, 4.18661776549, 94138.32702008578],
[0.00000000567, 6.08785859254, 25234.70675982219],
[0.00000000549, 2.08003708209, 91785.46086631398],
[0.00000000563, 1.38660458000, 79323.09135491178],
[0.00000000527, 5.83448542494, 50057.04242277000],
[0.00000000524, 2.45745967369, 467.96499035440],
[0.00000000570, 3.10425513710, 15874.61759536320],
[0.00000000699, 2.57322536922, 52182.91983014920],
[0.00000000501, 0.39578180187, 32370.97899156560],
[0.00000000542, 2.77109053528, 54394.56338733519],
[0.00000000525, 1.31791713133, 313054.83769889036],
[0.00000000513, 2.28640740711, 82815.66292178139],
[0.00000000579, 5.45103833735, 52195.47604404819],
[0.00000000617, 4.18395572588, 639.89728631400],
[0.00000000449, 3.10044122691, 49957.04917896160],
[0.00000000495, 2.11807671869, 52171.92494779040],
[0.00000000431, 3.06714836720, 131548.89425996438],
[0.00000000427, 5.35367311100, 49.99662190420],
[0.00000000470, 1.46585019834, 1066.49547719000],
[0.00000000470, 1.07485595760, 103821.92160120218],
[0.00000000415, 2.50109134151, 71980.63357473118],
[0.00000000395, 5.24320159822, 58946.51688439399],
[0.00000000408, 0.92030240581, 77837.11123384659],
[0.00000000523, 4.92390082310, 52389.10537858640],
[0.00000000377, 3.50882025297, 125887.56221081219],
[0.00000000508, 1.03838633466, 24491.71669928959],
[0.00000000418, 0.36439379673, 51962.50718771040],
[0.00000000400, 3.51557589073, 20760.42703319140],
[0.00000000359, 0.03091967859, 2118.76386037840],
[0.00000000356, 2.03727281128, 1052.26838318840],
[0.00000000423, 4.21437546240, 18093.37469954999],
[0.00000000340, 1.64349471632, 79219.30916633119],
[0.00000000336, 1.55276786593, 24505.94379329119],
[0.00000000348, 1.06528227311, 66941.04532641819],
[0.00000000327, 5.45093694594, 7880.08915333899],
[0.00000000303, 1.67537340603, 88476.99497093359],
[0.00000000323, 5.59204872298, 55618.38122811380],
[0.00000000281, 0.83478570176, 63498.47038145279],
[0.00000000393, 0.55222046684, 45405.09568190280],
[0.00000000280, 0.69995179262, 64741.95798313119],
[0.00000000381, 2.16540447546, 522.57741809380],
[0.00000000279, 4.17319236859, 155468.03691925599],
[0.00000000314, 1.52755129973, 44937.13069154840],
[0.00000000280, 3.33549459014, 78244.03966382280],
[0.00000000272, 5.34763989826, 53764.87917843220],
[0.00000000287, 4.98400171694, 25551.09862947879],
[0.00000000288, 3.26773464056, 124778.18365871879],
[0.00000000275, 0.59220058467, 104881.30353139139],
[0.00000000229, 5.07700202235, 52602.40447402440],
[0.00000000265, 1.04033681288, 25938.33994443960],
[0.00000000224, 5.10726819180, 117873.36400788819],
[0.00000000242, 0.44760602599, 23754.70674870219],
[0.00000000214, 3.50460190598, 58458.88213313979],
[0.00000000230, 2.45937674101, 155418.04029735178],
[0.00000000211, 3.92377004339, 103925.01437542078],
[0.00000000282, 3.81265243625, 536.80451209540],
[0.00000000218, 4.88963285925, 103396.01282468818],
[0.00000000200, 5.41573374322, 16066.06586147480],
[0.00000000218, 0.41409439248, 78267.59076008058],
[0.00000000201, 2.38235635877, 23439.44831610119],
[0.00000000203, 2.69458032262, 59414.48187474840],
[0.00000000196, 0.92807787406, 120226.23016165999],
[0.00000000201, 2.00560473829, 162188.75089859738],
[0.00000000183, 3.83128433173, 69159.80243060499],
[0.00000000180, 2.20428238305, 89586.37352302698],
[0.00000000215, 5.35652096610, 206.18554843720],
[0.00000000178, 1.24568538055, 103.09277421860],
[0.00000000196, 0.44564203205, 51756.32163927320],
[0.00000000183, 2.88003872828, 3328.13565628019],
[0.00000000216, 4.48180965712, 26241.68195205900],
[0.00000000215, 2.26752450953, 33967.99229491319],
[0.00000000193, 4.34407767816, 105307.21230790539],
[0.00000000200, 1.01165813281, 51742.09454527159],
[0.00000000170, 5.57003076622, 98068.53671630539],
[0.00000000224, 0.97932137082, 77211.44104153418],
[0.00000000168, 5.96360976147, 157636.79740153858],
[0.00000000178, 1.42319344949, 77197.21394753258],
[0.00000000196, 5.59654497318, 78270.82297172339],
[0.00000000161, 5.51918174079, 26555.86813192860],
[0.00000000197, 4.79975858562, 25455.11940226100],
[0.00000000181, 4.39987679970, 105410.99449648599],
[0.00000000159, 2.63928704121, 28421.09953444620],
[0.00000000158, 0.75224521142, 51116.42435295920],
[0.00000000196, 4.92493608061, 102762.53967101299],
[0.00000000162, 2.82561928047, 26202.34243025941],
[0.00000000194, 1.02167898855, 44181.27784112419],
[0.00000000179, 5.11561177302, 25440.89230825939],
[0.00000000152, 5.21934955501, 77623.81213840858],
[0.00000000150, 5.98491689335, 78256.59587772179],
[0.00000000184, 0.26375114604, 419.48464387520],
[0.00000000144, 2.90657294970, 51322.60990139639],
[0.00000000163, 1.01728531879, 26727.80042788820],
[0.00000000160, 1.39225289207, 26011.63707029860],
[0.00000000145, 5.76503611587, 80482.46652890938],
[0.00000000140, 0.27227514908, 46848.33017476560],
[0.00000000136, 0.22641179921, 151975.46535238638],
[0.00000000142, 4.24343923379, 339142.74084046457],
[0.00000000178, 4.08547287819, 129909.82474277639],
[0.00000000142, 3.31130337074, 78050.41032928458],
[0.00000000131, 0.70125733168, 3340.61242669980],
[0.00000000154, 1.72826405606, 78477.00852016058],
[0.00000000159, 5.29643521725, 108903.56606335558],
[0.00000000129, 3.26743532785, 25973.46385288896],
[0.00000000128, 6.10775258657, 76044.95232053580],
[0.00000000144, 4.06091644657, 50579.61984086379],
[0.00000000164, 6.17696810226, 19406.67828817460],
[0.00000000139, 5.11979950242, 433.71173787680],
[0.00000000153, 1.30046862259, 13655.86049117640],
[0.00000000132, 5.23445066335, 26610.48055966799],
[0.00000000115, 4.61845793770, 50593.84693486539],
[0.00000000121, 2.52027376421, 76144.94556434419],
[0.00000000114, 4.51555533683, 27154.39861876420],
[0.00000000106, 5.18068866237, 85502.38501632259],
[0.00000000110, 3.45757703411, 25565.32572348040],
[0.00000000100, 0.11496600894, 74821.13447975718],
[0.00000000100, 3.95989644984, 26037.90651966999],
[0.00000000100, 3.01535382150, 28206.66700195260],
[0.00000000099, 5.99257260255, 29416.03879785439],
[0.00000000117, 3.56597928882, 71492.99882347698],
[0.00000000131, 5.96070215452, 1223.81784077861],
[0.00000000095, 1.84065750300, 85034.42002596818],
[0.00000000102, 4.69459571654, 114564.89811250778],
[0.00000000097, 0.87353840441, 181555.94006083018],
[0.00000000118, 2.02298794976, 78283.37918562238],
[0.00000000111, 4.07316227960, 93028.94846799239],
[0.00000000090, 5.01726237192, 115674.27666460119],
[0.00000000094, 2.31806507832, 81706.28436968799],
[0.00000000089, 5.94413487088, 25131.61398560359],
[0.00000000095, 3.72299894590, 90829.86112470538],
[0.00000000120, 5.44384753792, 51749.20809227239],
[0.00000000105, 5.01803826552, 78259.82808936459],
[0.00000000086, 1.83551544255, 143961.26714946238],
[0.00000000108, 4.53825443085, 71025.03383312259],
[0.00000000083, 0.64015893446, 130012.91751699499],
[0.00000000099, 0.52218556269, 26624.70765366959],
[0.00000000094, 2.65386396812, 9103.90699411760],
[0.00000000098, 3.31480172250, 853.19638175200],
[0.00000000080, 2.13424472361, 42153.96900304900],
[0.00000000086, 2.05760695844, 79852.78232000639],
[0.00000000084, 0.97023030623, 131395.11544947959],
[0.00000000081, 0.28916970825, 84546.78527471398],
[0.00000000081, 5.18614814481, 220.41264243880],
[0.00000000081, 1.98383157756, 149.56319713460],
[0.00000000082, 0.05817684667, 104331.94280539699],
[0.00000000074, 1.62836007935, 25984.81036735560],
[0.00000000075, 1.84245188133, 78690.30761559859],
[0.00000000087, 3.58634855360, 130969.20667296558],
[0.00000000074, 5.06505616563, 27140.17152476259],
[0.00000000075, 5.47760610876, 134.10904958500],
[0.00000000089, 6.25587801019, 150866.08680029298],
[0.00000000098, 4.71698591369, 12725.45343477500],
[0.00000000069, 5.05822197567, 1911.19948321720],
[0.00000000081, 2.05307563846, 1596.18644228460],
[0.00000000075, 2.05688075943, 26137.89976347840],
[0.00000000069, 3.67576176321, 24609.03656750980],
[0.00000000081, 1.38060133126, 52329.58509363319],
[0.00000000069, 1.60181551296, 129483.91596626239],
[0.00000000067, 5.43668176629, 181505.94343892598],
[0.00000000066, 1.56953438995, 19804.82729158280],
[0.00000000066, 3.92553131581, 146314.13330323418],
[0.00000000062, 3.46967694133, 24925.42843716640],
[0.00000000079, 3.56674606057, 49842.60989027639],
[0.00000000067, 4.76959706409, 25881.71759313700],
[0.00000000061, 2.61995550094, 183724.70054311278],
[0.00000000061, 1.63344766876, 13541.42120249119],
[0.00000000061, 2.31153135385, 124156.43985787958],
[0.00000000058, 3.88678278617, 18207.81398823521],
[0.00000000082, 1.36242531494, 128850.44281258718],
[0.00000000058, 2.98990179150, 110.20632121940],
[0.00000000064, 4.98131448153, 188276.65404017158],
[0.00000000067, 2.32849722473, 26294.08869001139],
[0.00000000057, 3.72454115593, 29428.51556827400],
[0.00000000066, 1.69869503126, 51543.02254383520],
[0.00000000055, 2.30093263701, 52643.77127350280],
[0.00000000069, 1.78774826271, 51639.00177105299],
[0.00000000067, 4.00863968986, 103299.34418310839],
[0.00000000074, 6.14089486388, 14477.35118320000],
[0.00000000054, 5.27646510692, 49527.35145767539],
[0.00000000056, 2.33495620660, 104358.72611329758],
[0.00000000062, 3.41967311766, 104355.49390165479],
[0.00000000050, 1.20854390978, 23976.25282819660],
[0.00000000064, 0.58512976749, 307.55762096960],
[0.00000000062, 3.69245785160, 641.41356173899],
[0.00000000062, 4.47317710621, 636.99627202420],
[0.00000000049, 4.09291926847, 52815.70356946240],
[0.00000000061, 0.78849475911, 155997.72788435058],
[0.00000000047, 2.14659254610, 7994.52844202420],
[0.00000000047, 0.00507866085, 104138.31347085879],
[0.00000000045, 2.28588893693, 25764.39772491679],
[0.00000000051, 2.98348805265, 40565.25432477420],
[0.00000000047, 4.03957254582, 77829.99768684579],
[0.00000000047, 3.21862563103, 178063.36849396059],
[0.00000000045, 4.41401819607, 103285.11708910679],
[0.00000000054, 3.47879330948, 77844.22478084739],
[0.00000000054, 2.83659707386, 6681.22485339960],
[0.00000000056, 1.11360360738, 131498.89763806018],
[0.00000000046, 3.38384624666, 26507.38778544939],
[0.00000000055, 2.68637168389, 25934.12433108940],
[0.00000000046, 4.78696197215, 104564.91166173479],
[0.00000000059, 1.29879100690, 38813.35657634920],
[0.00000000043, 3.86025201636, 10021.83728009940],
[0.00000000044, 1.90320971624, 51528.79544983359],
[0.00000000055, 0.48335079540, 23962.02573419499],
[0.00000000042, 4.11693586607, 26190.99591579279],
[0.00000000044, 1.64247485835, 76.26607127560],
[0.00000000042, 6.21848377968, 26094.53170047421],
[0.00000000041, 2.73996884659, 25867.49049913539],
[0.00000000043, 0.38981425968, 1089.70879119360],
[0.00000000043, 4.89046790101, 24395.73747207180],
[0.00000000041, 0.44351702671, 25619.93815121980],
[0.00000000041, 1.47439583353, 76681.75007643958],
[0.00000000039, 1.71519867865, 111590.28815789679],
[0.00000000041, 5.67594181048, 54509.00267602040],
[0.00000000049, 1.65739950579, 1581.95934828300],
[0.00000000040, 1.85008425708, 27999.10262479140],
[0.00000000038, 3.99668572981, 9384.84100807520],
[0.00000000037, 2.83147987268, 102132.85546210999],
[0.00000000039, 0.84546566819, 365230.64398203876],
[0.00000000037, 4.65200082367, 90695.75207512038],
[0.00000000037, 0.94736176192, 76667.52298243798],
[0.00000000040, 0.16806354899, 22759.76748529401],
[0.00000000049, 2.02480943113, 134991.46920492979],
[0.00000000041, 5.85592543833, 52290.24557183361],
[0.00000000040, 1.21491127400, 64607.84893354619],
[0.00000000041, 3.07842612799, 26081.27458267419],
[0.00000000035, 3.89800430981, 157483.01859105378],
[0.00000000037, 0.29068345666, 97580.90196505119],
[0.00000000035, 4.74965057267, 39629.32434406539],
[0.00000000035, 1.88777425098, 26521.61487945100],
[0.00000000033, 3.60227423859, 156100.82065856918],
[0.00000000035, 1.96114191570, 74.78159856730],
[0.00000000045, 3.72467663437, 39609.65458316560],
[0.00000000038, 4.29218444251, 39743.76363275060],
[0.00000000032, 5.95900501016, 77410.51304297059],
[0.00000000032, 0.64794221724, 2648.45482547300],
[0.00000000039, 5.08510962281, 25863.55834587229],
[0.00000000031, 1.62486752727, 141762.17980617538],
[0.00000000031, 1.25910229689, 53242.30176033840],
[0.00000000031, 2.65918037491, 104344.49901929598],
[0.00000000032, 0.00169740803, 52061.36699446317],
[0.00000000031, 6.12210016938, 25977.69682035479],
[0.00000000030, 5.72239820341, 579.68758699880],
[0.00000000030, 0.70553319870, 52125.80966124419],
[0.00000000039, 1.60801806885, 333.85594076940],
[0.00000000030, 5.28578152795, 102232.84870591838],
[0.00000000029, 0.53270948692, 50696.93970908399],
[0.00000000029, 0.40281274949, 35472.74414964940],
[0.00000000028, 2.96171859812, 100909.03762133139],
[0.00000000034, 1.41428136641, 140652.80125408198],
[0.00000000029, 6.00401578551, 54294.57014352679],
[0.00000000032, 0.45221016093, 116917.76426627958],
[0.00000000028, 5.07088961710, 26237.46633870879],
[0.00000000028, 5.33382835025, 107794.18751126219],
[0.00000000030, 3.86080757411, 207643.84320240439],
[0.00000000028, 4.81897403543, 170049.17029103659],
[0.00000000031, 1.90989851759, 26308.31578401300],
[0.00000000035, 1.26114015069, 97112.93697469679],
[0.00000000028, 2.01146788563, 52698.38370124219],
[0.00000000033, 4.31496976407, 154938.34595416138],
[0.00000000028, 4.46781875730, 78417.48823520739],
[0.00000000033, 0.25034815279, 51653.22886505459],
[0.00000000026, 0.07835049738, 51013.33157874059],
[0.00000000029, 3.32582529322, 110634.68841628819],
[0.00000000027, 6.01993388409, 25227.59321282139],
[0.00000000036, 0.79025288269, 119116.85160956658],
[0.00000000026, 4.68624143375, 632.78373931320],
[0.00000000027, 1.14521834701, 121335.60871375339],
[0.00000000025, 3.42095174931, 956.28915597060],
[0.00000000028, 2.73386270717, 27311.72098235281],
[0.00000000024, 0.82215620694, 314.18617986960],
[0.00000000025, 5.21681600178, 25241.82030682300],
[0.00000000025, 3.57372833543, 52712.61079524379],
[0.00000000027, 5.05183520711, 105940.68546158058],
[0.00000000031, 2.25462520789, 26720.68688088739],
[0.00000000025, 4.86890931082, 104778.21075717278],
[0.00000000023, 3.01659387998, 52182.43484204840],
[0.00000000026, 2.13973174244, 103711.71527998279],
[0.00000000023, 4.60383496965, 52072.71350892979],
[0.00000000023, 4.55605691468, 155571.81910783658],
[0.00000000022, 3.69622699918, 735.87651353180],
[0.00000000023, 2.40544682432, 8194.27533320860],
[0.00000000022, 2.44094101414, 2703.61615467560],
[0.00000000027, 5.29221944987, 26162.68474014150],
[0.00000000022, 4.11517024183, 19202.75325164339],
[0.00000000029, 4.25385019536, 647.01083331480],
[0.00000000021, 2.11851790816, 207593.84658050018],
[0.00000000029, 2.91003553544, 176953.98994186718],
[0.00000000026, 5.68398596586, 95247.70557217918],
[0.00000000021, 5.29289519906, 150244.34299945379],
[0.00000000024, 3.05210539174, 130419.84594697120],
[0.00000000020, 2.54144132983, 51219.51712717779],
[0.00000000020, 6.16401959180, 35191.81013569180],
[0.00000000022, 3.22920342008, 1083.08023229360],
[0.00000000028, 0.30709453091, 157057.10981453978],
[0.00000000023, 1.65280537431, 214364.55718174578],
[0.00000000027, 3.72484040647, 621.74380083920],
[0.00000000023, 2.59065413623, 71582.48457132299],
[0.00000000022, 0.94588004362, 52022.02747266360],
[0.00000000020, 3.84776796820, 5327.47610838280],
[0.00000000024, 4.82779429778, 104371.28232719658],
[0.00000000019, 1.94368317235, 22747.29071487440],
[0.00000000023, 3.19739923216, 6044.22858137540],
[0.00000000020, 0.58967836529, 172402.03644480839],
[0.00000000019, 2.73169091081, 55503.94193942859],
[0.00000000018, 1.63099638721, 48835.19385644859],
[0.00000000022, 1.62646807429, 104347.73123093879],
[0.00000000018, 4.90435895585, 77630.92568540938],
[0.00000000018, 0.59687432455, 183570.92173262799],
[0.00000000024, 5.58828197916, 34282.17847478280],
[0.00000000018, 5.54856348293, 209812.60368468695],
[0.00000000019, 0.53136209334, 55516.41870984820],
[0.00000000020, 0.73777252741, 129387.24732468258],
[0.00000000021, 4.62446809035, 13362.44970679920],
[0.00000000021, 1.94768946886, 487.63475125420],
[0.00000000019, 4.18946427203, 78114.14622758799],
[0.00000000023, 2.43977160852, 24822.33566294780],
[0.00000000017, 2.24086275048, 26222.01219115920],
[0.00000000018, 5.08348808758, 27684.08958385880],
[0.00000000017, 4.31062701282, 50064.15596977079],
[0.00000000017, 0.62713581550, 44295.71712980940],
[0.00000000022, 0.09847423078, 26941.09952332620],
[0.00000000019, 2.09224104001, 86143.79857806159],
[0.00000000016, 0.43713509764, 101.96251826560],
[0.00000000016, 4.27219175799, 24176.70365835700],
[0.00000000018, 5.24040005379, 68241.87214462319],
[0.00000000020, 5.09682447452, 60055.89543648739],
[0.00000000016, 4.08590900542, 147423.51185532758],
[0.00000000018, 2.12913862198, 106570.36967048359],
[0.00000000016, 1.00668387150, 25138.72753260440],
[0.00000000016, 5.76419504418, 14.22709400160],
[0.00000000021, 6.16511987091, 52169.17772424839],
[0.00000000016, 0.82798074394, 96357.08412427259],
[0.00000000016, 3.75399093257, 159.30173479220],
[0.00000000017, 4.95698248546, 52225.80290505260],
[0.00000000017, 6.11461465994, 26198.10946279360],
[0.00000000017, 6.19302565011, 204151.27163553478],
[0.00000000017, 5.34573358099, 78731.67441507700],
[0.00000000016, 1.90468795194, 128320.75184749259],
[0.00000000017, 3.73180335896, 182085.63102592478],
[0.00000000017, 5.86222137701, 32132.13172294960],
[0.00000000019, 1.56034038551, 51969.62073471119],
[0.00000000018, 2.54086242120, 25780.34552060460],
[0.00000000015, 4.29267057949, 1692.16566950240],
[0.00000000016, 1.75865740707, 53228.07466633679],
[0.00000000020, 2.35700883433, 75615.25459924959],
[0.00000000015, 5.29296109539, 130446.62925487179],
[0.00000000014, 0.85174293693, 78903.60671103658],
[0.00000000015, 5.50776870695, 52808.59002246159],
[0.00000000017, 5.96622721781, 32769.12799497380],
[0.00000000014, 5.40589812318, 52381.99183158559],
[0.00000000014, 2.92783624754, 130226.21661243298],
[0.00000000014, 4.73334676783, 26164.16921284980],
[0.00000000018, 4.09540263999, 157586.80077963437],
[0.00000000015, 5.00568645183, 28791.51929624980],
[0.00000000013, 0.88297787282, 24292.64469785319],
[0.00000000018, 0.07544318179, 2199.08734328700],
[0.00000000014, 0.39198838648, 1162.47470440780],
[0.00000000012, 4.87283902225, 64901.25971792339],
[0.00000000013, 4.28417448099, 23866.04650697719],
[0.00000000013, 3.77892895408, 391318.54712361297],
[0.00000000012, 0.90287358387, 104202.04936916218],
[0.00000000012, 1.68139724364, 72936.23331633979],
[0.00000000015, 3.76108194990, 111122.32316754239],
[0.00000000012, 1.82629728829, 22909.75735100660],
[0.00000000013, 1.25451832397, 26724.89941359840],
[0.00000000012, 5.74844907374, 97670.38771289718],
[0.00000000012, 1.52451201886, 130652.81480330898],
[0.00000000011, 5.30694474936, 24601.92302050899],
[0.00000000014, 2.82065667408, 1639.06951718800],
[0.00000000015, 4.79144654769, 77726.90491262719],
[0.00000000013, 5.37369194634, 8989.46770543239],
[0.00000000013, 3.84042504901, 25953.79409198919],
[0.00000000015, 0.08558342266, 130443.39704322898],
[0.00000000011, 5.16135808879, 233681.74972207438],
[0.00000000012, 0.99700192092, 65831.66677432480],
[0.00000000012, 4.51508367315, 78187.44335344699],
[0.00000000012, 0.62022460619, 36109.74042167360],
[0.00000000011, 1.08182792000, 129373.02023068098],
[0.00000000014, 5.59428027773, 25446.48957983520],
[0.00000000011, 4.68045355937, 74923.09699802278],
[0.00000000014, 4.68060965317, 27669.86248985719],
[0.00000000012, 4.91061349082, 54087.00576636560],
[0.00000000010, 0.73914692842, 103917.90082841998],
[0.00000000013, 4.96538793287, 161079.37234650398],
[0.00000000011, 0.31330958005, 182188.72380014337],
[0.00000000013, 3.74649756573, 145204.75475114079],
[0.00000000010, 1.79124533717, 949.17560896980],
[0.00000000010, 4.24347093551, 78109.93061423779],
[0.00000000010, 1.22394899357, 104505.39137678158],
[0.00000000012, 3.21001019103, 102018.41617342478],
[0.00000000011, 4.48294709049, 102769.65321801379],
[0.00000000010, 4.33936275875, 95.97922721780],
[0.00000000010, 3.73409843943, 199599.31813847595],
[0.00000000012, 6.08780023115, 25450.90686955000],
[0.00000000012, 0.52219299955, 125112.03959948818],
[0.00000000012, 3.12928292612, 11610.55195837420],
[0.00000000013, 2.59745313501, 78378.14871340781],
[0.00000000010, 0.95664142687, 45290.65639321759],
[0.00000000011, 3.04942272888, 309.27832265580],
[0.00000000012, 3.42470973506, 143005.66740785378],
[0.00000000009, 5.24571653547, 34082.43158359840],
[0.00000000012, 1.94632930172, 1135.67687189320],
[0.00000000010, 2.75654212398, 103.78218858060],
[0.00000000010, 6.06089846081, 78270.33798362259],
[0.00000000009, 1.42295924162, 12546.48193908300],
[0.00000000009, 5.23889079020, 160.40736938481],
[0.00000000010, 1.77339719648, 25754.04720080480],
[0.00000000011, 3.45444324976, 27177.61193276780],
[0.00000000010, 2.40808781707, 3462.24470586520],
[0.00000000012, 0.21115577900, 103932.12792242158],
[0.00000000010, 0.44397528833, 26729.31670331319],
[0.00000000009, 4.39355955971, 224.34479570190],
[0.00000000009, 5.76319803259, 86457.98475793119],
[0.00000000009, 3.21350384534, 123668.80510662538],
[0.00000000009, 5.50134612867, 25352.02662804239],
[0.00000000009, 3.61240341796, 76784.84285065818],
[0.00000000009, 3.71346537596, 78213.71280281838],
[0.00000000011, 0.04658635952, 136722.59155786238],
[0.00000000009, 3.16339317765, 24079.34560241519],
[0.00000000010, 1.52307057829, 196137.07343261078],
[0.00000000009, 5.78277172101, 137210.22630911658],
[0.00000000009, 5.34709321166, 16703.06213349900],
[0.00000000010, 1.10603431719, 76152.05911134499],
[0.00000000010, 2.92130709301, 78257.08086582259],
[0.00000000009, 4.92591389280, 52609.51802102519],
[0.00000000008, 4.47915729665, 167850.08294774959],
[0.00000000010, 3.52532046928, 50049.92887576919],
[0.00000000009, 5.74701495675, 128220.75860368418],
[0.00000000009, 3.39636103723, 25771.51127191760],
[0.00000000009, 0.40885845708, 173511.41499690177],
[0.00000000009, 0.05214771460, 209232.91609768818],
[0.00000000011, 4.39473500560, 166740.70439565618],
[0.00000000008, 0.83788793173, 52101.02468458109],
[0.00000000009, 0.39740145698, 208173.53416749898],
[0.00000000009, 2.14648409917, 52250.58788171570],
[0.00000000011, 0.77019715443, 181026.24909573558],
[0.00000000008, 0.46458507594, 11.04570026390],
[0.00000000009, 3.75726239516, 26395.46076254379],
[0.00000000011, 3.88183253605, 99024.13645791399],
[0.00000000009, 5.91589628233, 26404.29501123080],
[0.00000000008, 3.62038830716, 28736.35796704720],
[0.00000000009, 5.53218561478, 50910.23880452200],
[0.00000000008, 3.98222002302, 51226.63067417859],
[0.00000000008, 2.20332298794, 35077.37084700659],
[0.00000000010, 1.71606704784, 132028.58860315479],
[0.00000000009, 4.19828805921, 123200.84011627098],
[0.00000000008, 4.94949508683, 1263.15736257819],
[0.00000000008, 0.38255024740, 78800.51393681798],
[0.00000000008, 3.55931433878, 25508.21555457540],
[0.00000000008, 2.06623542364, 133882.09065283638],
[0.00000000008, 2.76004606287, 103498.41618454478],
[0.00000000009, 6.07146960892, 52595.29092702359],
[0.00000000010, 4.64768763301, 240452.46032331996],
[0.00000000010, 4.75089417351, 158116.49174472898],
[0.00000000009, 3.16830318341, 156531.30018480319],
[0.00000000009, 0.51442466727, 233731.74634397858],
[0.00000000008, 1.84170519176, 52325.36948028299],
[0.00000000009, 1.58020929410, 130866.11389874699],
[0.00000000008, 1.31021834242, 78160.61665050399],
[0.00000000007, 3.52394232228, 209658.82487420218],
[0.00000000007, 5.30361639156, 51852.30086649099],
[0.00000000007, 1.68129390597, 103704.60173298199],
[0.00000000007, 4.93711462539, 77616.69859140778],
[0.00000000007, 4.26547182656, 130363.24963659538],
[0.00000000008, 5.88262362064, 51955.39364070959],
[0.00000000009, 2.85041915486, 52286.01260436779],
[0.00000000009, 4.54751921819, 222224.97657418498],
[0.00000000007, 2.95164397426, 58857.03113654799],
[0.00000000007, 5.09932324366, 26421.75908234360],
[0.00000000008, 5.95900851407, 625.67019231240],
[0.00000000008, 2.87611784406, 182595.65223011958],
[0.00000000007, 2.95245442922, 70269.18098269838],
[0.00000000009, 1.85768285044, 2168.76048228260],
[0.00000000009, 5.87894263333, 203041.89308344138],
[0.00000000007, 5.76376514627, 53399.62412392700],
[0.00000000007, 3.19368974135, 77947.31755506598],
[0.00000000007, 0.58513513972, 17893.62780836560],
[0.00000000007, 1.25969543054, 104275.34649502118],
[0.00000000007, 1.78997113742, 187167.27548807819],
[0.00000000007, 3.04234073392, 77101.23472031478],
[0.00000000007, 5.13452237557, 77307.42026875199],
[0.00000000008, 2.39389370291, 51534.39272140940],
[0.00000000007, 0.36315569295, 179172.74704605396],
[0.00000000009, 4.65044386389, 156954.01704032118],
[0.00000000007, 5.75015377153, 78580.10129437919],
[0.00000000008, 4.90310056069, 101703.15774082378],
[0.00000000007, 2.81152781596, 92741.06060792258],
[0.00000000007, 4.53777069646, 78339.97549599818],
[0.00000000008, 3.72793390212, 77795.74443436819],
[0.00000000007, 4.99225219771, 102659.44689679438],
[0.00000000008, 1.24101149187, 128857.55635958798],
[0.00000000006, 1.24806705522, 181659.72224941078],
[0.00000000007, 1.41908776548, 39450.35284837340],
[0.00000000008, 5.07207947299, 202420.14928260217],
[0.00000000006, 3.88021248158, 104991.50985261079],
[0.00000000007, 0.44811727260, 104301.61594439259],
[0.00000000007, 6.19019459405, 37698.45509994840],
[0.00000000008, 3.27628873745, 183145.01295611398],
[0.00000000006, 1.04156861985, 104197.83375581198],
[0.00000000007, 6.04804574225, 103189.13786188899],
[0.00000000007, 6.15588549143, 75930.51303185058],
[0.00000000007, 2.01982955946, 176332.24614102798],
[0.00000000007, 4.68299502093, 838.96928775040],
[0.00000000007, 4.32694078051, 104248.51979207818],
[0.00000000006, 0.30098706976, 54824.26110862140],
[0.00000000007, 2.39268679107, 80596.90581759460],
[0.00000000006, 0.45279066685, 225687.22128005016],
[0.00000000006, 4.93617566760, 215473.93573383916],
[0.00000000006, 4.22528261713, 79330.20490191258],
[0.00000000007, 5.53062936347, 917.93028598180],
[0.00000000006, 0.27837413876, 76137.83201734339],
[0.00000000007, 1.50054882304, 78313.70604662679],
[0.00000000006, 4.84865195534, 213255.17862965238],
[0.00000000007, 0.37969316028, 102872.74599223239],
[0.00000000006, 4.82915128356, 79859.89586700719],
[0.00000000007, 2.36435599398, 58220.03486452380],
[0.00000000007, 0.76243719900, 183674.70392120858],
[0.00000000006, 3.48561717935, 61560.64729122359],
[0.00000000007, 3.15542325331, 53029.00266490040],
[0.00000000006, 2.04066112896, 156534.53239644598],
[0.00000000006, 4.08906102427, 91919.56991589899],
[0.00000000006, 3.64988511750, 151199.94274106238],
[0.00000000006, 4.09613031145, 53867.97195265079],
[0.00000000006, 3.49486002612, 66653.15746634839],
[0.00000000007, 2.89745929648, 230239.17477710896],
[0.00000000006, 3.99809593088, 50380.54783942739],
[0.00000000006, 3.65663654813, 70383.62027138360],
[0.00000000006, 6.23319937932, 182619.20332637738],
[0.00000000006, 0.15202166498, 51859.41441349179],
[0.00000000006, 0.36162525319, 26823.77965510599],
[0.00000000006, 5.03417122369, 78786.28684281638],
[0.00000000006, 2.61401898803, 80382.47328510099],
[0.00000000006, 5.06939782090, 51841.95034237900],
[0.00000000008, 4.96432797037, 52396.21892558720],
[0.00000000006, 3.74091556543, 155475.15046625677],
[0.00000000006, 4.29792825666, 52812.80255517260],
[0.00000000007, 6.02219529486, 156507.74908854539],
[0.00000000005, 6.28085632767, 31415.37924995700],
[0.00000000006, 2.70517720720, 52492.19815280499],
[0.00000000007, 6.25185953525, 74935.57376844239],
[0.00000000005, 6.03800330793, 84944.93427812219],
[0.00000000007, 2.08385155566, 104819.57755665119],
[0.00000000005, 2.79143401592, 51315.49635439559],
[0.00000000007, 0.15300257128, 2014.98167179780],
[0.00000000006, 5.45690475475, 1243.48760167840],
[0.00000000005, 1.72310829290, 103718.82882698359],
[0.00000000005, 0.05343175320, 27044.19229754480],
[0.00000000005, 1.35980682609, 94329.77528619739],
[0.00000000007, 5.94496795198, 256327.07791868312],
[0.00000000006, 1.88665916947, 80174.90890793978],
[0.00000000005, 2.15640465605, 235900.50682626116],
[0.00000000005, 5.97271372078, 156314.11975400719],
[0.00000000006, 2.66620904510, 229129.79622501558],
[0.00000000005, 2.52891655111, 123758.29085447139],
[0.00000000006, 1.20953605164, 130459.18546877075],
[0.00000000005, 4.06443360712, 130285.73689738619],
[0.00000000007, 1.34355308244, 1731.12235293260],
[0.00000000005, 2.36158299954, 78896.49316403578],
[0.00000000005, 0.96987247797, 149288.74325784518],
[0.00000000005, 0.76610110351, 24864.08530079559],
[0.00000000005, 1.95647355963, 76571.54375522019],
[0.00000000005, 1.13701088228, 26312.24793727610],
[0.00000000005, 1.05826639118, 27780.06881107659],
[0.00000000005, 4.54130791881, 156740.71794488319],
[0.00000000006, 3.58276567647, 198489.93958638258],
[0.00000000005, 0.51603916276, 171292.65789271498],
[0.00000000006, 3.03452226064, 77741.13200662879],
[0.00000000005, 1.46111595893, 101011.00013959699],
[0.00000000005, 0.02805624095, 149756.70824819959],
[0.00000000005, 5.10195955921, 112231.70171963578],
[0.00000000005, 4.87459278742, 78413.27262185719],
[0.00000000007, 3.69898590349, 81604.32185142238],
[0.00000000005, 0.76195152302, 417406.45026518717],
[0.00000000005, 0.55904094194, 2383.19301477620],
[0.00000000005, 3.95096384085, 78188.92782615528],
[0.00000000005, 1.76549372525, 53771.99272543299],
[0.00000000005, 3.35356708410, 205260.65018762815],
[0.00000000006, 5.57902902188, 87253.17713015496],
[0.00000000005, 0.26610630357, 235746.72801577636],
[0.00000000005, 2.90596877294, 154194.22245657316],
[0.00000000004, 1.16974176650, 193937.98608932378],
[0.00000000004, 3.93130462476, 130289.95251073639],
[0.00000000004, 4.33627478046, 89.48574784600],
[0.00000000005, 2.80022335340, 4437.51420837359],
[0.00000000006, 4.70286246928, 91805.13062721379],
[0.00000000005, 1.82284966431, 1884.90116341740],
[0.00000000005, 2.02580304988, 259769.65286364855],
[0.00000000004, 4.65165864815, 195047.36464141717],
[0.00000000004, 0.58858147700, 323.50541665740],
[0.00000000004, 4.00623668740, 175376.64639941938],
[0.00000000004, 0.64833718455, 156377.85565231058],
[0.00000000004, 2.71436739189, 182402.02289558138],
[0.00000000005, 4.68929437146, 79315.97780791098],
[0.00000000004, 5.71176695959, 81591.84508100279],
[0.00000000004, 1.42876132655, 52252.07235442399],
[0.00000000005, 2.55069425936, 154308.66174525839],
[0.00000000005, 1.42813778372, 266540.36346489414],
[0.00000000004, 2.00085806148, 189386.03259226495],
[0.00000000005, 4.29231489707, 220025.88923089796],
[0.00000000004, 6.20316213523, 79116.90580647459],
[0.00000000004, 0.85257120719, 118007.47305747319],
[0.00000000004, 5.77579934605, 129799.61842155698],
[0.00000000004, 4.47492094862, 137678.19129947099],
[0.00000000004, 1.64566631180, 78697.42116259939],
[0.00000000005, 2.17514536840, 51329.72344839720],
[0.00000000006, 4.78710650697, 102755.42612401219],
[0.00000000004, 1.46002058771, 935.92998070881],
[0.00000000005, 5.13889133658, 130907.48069822539],
[0.00000000004, 1.89321187110, 2111.65031337760],
[0.00000000004, 0.10839681347, 38.13303563780],
[0.00000000005, 4.42201446083, 78057.52387628538],
[0.00000000005, 5.65870377214, 1300.82681820500],
[0.00000000005, 5.90579064813, 1478.86657406440],
[0.00000000004, 5.24580055005, 52309.91533273340],
[0.00000000004, 2.74756161638, 144916.86689107098],
[0.00000000005, 3.31232177694, 48847.67062686820],
[0.00000000004, 4.43048849829, 118828.96374949679],
[0.00000000004, 0.51369916437, 181563.05360783098],
[0.00000000004, 5.22571179686, 261988.40996783535],
[0.00000000004, 0.80000960641, 1485.29070670320],
[0.00000000004, 3.25642623421, 195181.47369100217],
[0.00000000005, 5.23264312237, 126996.94076290558],
[0.00000000004, 3.86524951456, 209762.60706278277],
[0.00000000004, 3.43760746038, 234261.43730907318],
[0.00000000004, 0.67741502331, 131079.41299418498],
[0.00000000004, 5.40862384292, 104984.39630560997],
[0.00000000004, 0.30384598125, 285907.55262712695],
[0.00000000004, 5.65734972357, 51868.24866217880],
[0.00000000004, 5.55015227967, 149846.19399604558],
[0.00000000004, 1.51752118872, 103814.80805420138],
[0.00000000004, 2.53135799952, 79487.52726550119],
[0.00000000004, 1.88512485652, 54879.42243782400],
[0.00000000004, 5.12386500502, 182622.43553802017],
[0.00000000004, 4.36228014188, 207747.62539098498],
[0.00000000004, 3.24471199066, 130020.03106399579],
[0.00000000004, 0.51045647492, 107692.22499299659],
[0.00000000004, 4.26267840541, 132658.27281205778],
[0.00000000004, 3.08522628552, 175844.61138977378],
[0.00000000004, 3.38866894732, 104888.41707839219],
[0.00000000004, 1.21404057369, 139543.42270198859],
[0.00000000005, 3.75130732000, 62197.64356324779],
[0.00000000004, 0.30056239753, 233202.05537888398],
[0.00000000004, 4.20598588282, 218916.51067880458],
[0.00000000004, 1.34568004641, 182828.62108645738],
[0.00000000004, 0.68519128486, 104276.83096772949],
[0.00000000004, 0.20412928769, 169093.57054942798],
[0.00000000003, 0.98973904852, 105418.10804348679],
[0.00000000004, 3.42019897755, 61279.71327726600],
[0.00000000003, 5.22780381742, 78338.49102328988],
[0.00000000003, 2.67114319601, 24998.19435038059],
[0.00000000004, 1.65814724695, 50800.03248330259],
[0.00000000004, 3.24764679291, 28286.99048486120],
[0.00000000004, 6.01723954923, 104237.17327761157],
[0.00000000003, 3.99050522839, 71378.55953479178],
[0.00000000003, 3.46632047879, 45494.58142974879],
[0.00000000003, 4.27304181959, 130593.29451835579],
[0.00000000003, 4.05932083484, 52822.81711646319],
[0.00000000003, 5.89324219451, 50483.64061364600],
[0.00000000003, 2.88091404327, 78149.27013603736],
[0.00000000003, 4.09573256493, 155460.92337225519],
[0.00000000003, 0.40695406256, 52278.89905736699],
[0.00000000003, 0.53381434741, 26709.64694241340],
[0.00000000003, 1.00008179165, 50264.60679993120],
[0.00000000004, 5.67939124426, 106470.37642667518],
[0.00000000003, 0.77610404005, 142871.55835826878],
[0.00000000003, 3.80375047171, 26402.08932144380],
[0.00000000003, 2.44134109777, 156520.30530244438],
[0.00000000003, 0.98764974659, 128843.32926558638],
[0.00000000003, 3.62903815930, 130435.63437251298],
[0.00000000003, 2.12651302584, 78469.89497315978],
[0.00000000003, 4.29158350083, 154408.65498906678],
[0.00000000003, 1.06499703474, 26734.91397488900],
[0.00000000003, 1.86490629185, 51707.84129279399],
[0.00000000003, 5.95559848753, 104344.98400739678],
[0.00000000004, 3.60184879954, 207114.15223730978],
[0.00000000003, 3.28684847821, 208276.62694171758],
[0.00000000003, 2.80509981839, 104358.24112519680],
[0.00000000003, 5.02808401414, 130432.40216087017],
[0.00000000003, 6.16601650050, 20043.67456019880],
[0.00000000003, 5.29581547615, 57503.28239153120],
[0.00000000003, 1.35036448550, 23919.14265929160],
[0.00000000002, 3.75076268715, 130005.80396999417],
[0.00000000003, 3.05479754348, 162810.49469943657],
[0.00000000003, 2.06087055668, 52065.59996192899],
[0.00000000003, 1.11245383788, 192828.60753723037],
[0.00000000002, 1.90218644384, 24356.78078864160],
[0.00000000002, 4.74203919229, 76887.93562487679],
[0.00000000002, 0.63548334553, 23384.28698689860],
[0.00000000002, 2.51564214512, 26667.59072857300],
[0.00000000002, 6.08909078783, 116783.65521669458],
[0.00000000002, 3.56733241522, 26073.67604757259],
[0.00000000003, 5.60392923976, 104466.05185498200],
[0.00000000002, 3.56126103854, 26189.86565983980],
[0.00000000002, 5.97797555746, 50167.24874398939],
[0.00000000002, 4.41481991835, 65538.25598994759],
[0.00000000002, 5.91297170155, 87367.61641884019],
[0.00000000002, 5.17508169630, 163298.12945069079],
[0.00000000003, 1.10832319418, 25600.26839032000],
[0.00000000002, 2.11477268878, 25773.71696170459],
[0.00000000002, 2.15515419441, 51951.46148744649],
[0.00000000003, 5.43138498093, 106684.80895916879],
[0.00000000002, 0.11511311275, 27170.98337386779],
[0.00000000002, 5.22579437397, 6885.14988993081],
[0.00000000002, 2.93412437896, 63786.35824152260],
[0.00000000003, 6.19860078008, 25004.82290928060],
[0.00000000002, 0.23150025826, 24448.83362438620],
[0.00000000002, 0.54898566845, 153084.84390447979],
[0.00000000002, 0.63373893542, 1265.56747862640],
[0.00000000002, 4.49873870855, 50007.04580086580],
[0.00000000002, 5.57750243319, 25928.60140678200],
[0.00000000002, 5.66467419812, 25466.15934073500],
[0.00000000002, 5.10682926241, 159969.99379441059],
[0.00000000002, 3.49751807681, 259819.64948555276],
], [
[0.00053049845, 0.00000000000, 0.00000000000],
[0.00016903658, 4.69072300649, 26087.90314157420],
[0.00007396711, 1.34735624669, 52175.80628314840],
[0.00003018297, 4.45643539705, 78263.70942472259],
[0.00001107419, 1.26226537554, 104351.61256629678],
[0.00000378173, 4.31998055900, 130439.51570787099],
[0.00000122998, 1.06868541052, 156527.41884944518],
[0.00000038663, 4.08011610182, 182615.32199101939],
[0.00000014898, 4.63343085810, 1109.37855209340],
[0.00000011861, 0.79187646439, 208703.22513259358],
[0.00000005243, 4.71799772791, 24978.52458948080],
[0.00000003575, 3.77317513032, 234791.12827416777],
[0.00000002566, 1.44059109766, 27197.28169366760],
[0.00000002045, 1.49570544876, 51066.42773105500],
[0.00000001064, 0.46023695675, 260879.03141574195],
[0.00000000972, 1.80344701358, 955.59974160860],
[0.00000000628, 6.18483168149, 529.69096509460],
[0.00000000628, 4.84930105320, 24498.83024629040],
[0.00000000763, 4.54299337366, 77154.33087262919],
[0.00000000654, 0.98170349539, 5661.33204915220],
[0.00000000572, 5.92841937309, 25028.52121138500],
[0.00000000552, 2.13228646570, 20426.57109242200],
[0.00000000507, 4.11466890786, 4551.95349705880],
[0.00000000608, 4.54152310086, 2218.75710418680],
[0.00000000439, 3.40705996719, 11322.66409830440],
[0.00000000381, 2.83442391504, 26617.59410666880],
[0.00000000370, 0.82360646560, 6770.71060124560],
[0.00000000312, 5.18785829630, 46514.47423399620],
[0.00000000314, 3.42002895816, 286966.93455731616],
[0.00000000307, 3.20507351217, 1059.38193018920],
[0.00000000332, 0.97416155325, 25132.30339996560],
[0.00000000327, 2.22989850002, 21535.94964451540],
[0.00000000303, 4.68482058244, 27043.50288318280],
[0.00000000247, 5.87612469398, 16983.99614745660],
[0.00000000311, 4.22422008005, 3442.57494496540],
[0.00000000237, 4.37101224231, 114.43928868521],
[0.00000000234, 0.93917232374, 30639.85663863300],
[0.00000000273, 1.29086264556, 103242.23401420339],
[0.00000000209, 3.30158370895, 213.29909543800],
[0.00000000197, 2.07792605062, 22645.32819660879],
[0.00000000182, 0.62534354989, 25448.00585526019],
[0.00000000219, 1.34188738340, 28306.66024576099],
[0.00000000168, 6.20806483822, 27147.28507176339],
[0.00000000156, 3.91999448441, 32858.61374281979],
[0.00000000160, 5.79377449410, 52705.49724824299],
[0.00000000153, 4.33936015634, 1589.07289528380],
[0.00000000161, 4.80105233203, 23869.14603738740],
[0.00000000148, 1.97575825359, 72602.37737557039],
[0.00000000145, 5.96024756685, 14765.23904326980],
[0.00000000129, 4.16213277137, 23969.13928119580],
[0.00000000135, 3.86775437070, 51220.20654153979],
[0.00000000140, 3.66642468738, 25558.21217647960],
[0.00000000108, 1.39723983534, 50586.73338786459],
[0.00000000115, 0.15124159675, 26301.20223701220],
[0.00000000113, 4.98137485250, 79373.08797681599],
[0.00000000115, 3.05230359467, 53285.18483524180],
[0.00000000099, 3.99635236807, 56727.75978020720],
[0.00000000099, 3.84242768306, 83925.04147387479],
[0.00000000093, 2.04998627084, 26068.23338067440],
[0.00000000092, 0.08628005998, 313054.83769889036],
[0.00000000094, 4.30968259383, 129330.13715577759],
[0.00000000085, 3.01984486981, 53235.18821333759],
[0.00000000105, 5.32363189985, 7238.67559160000],
[0.00000000095, 2.24093904831, 19317.19254032860],
[0.00000000099, 1.00218248773, 29530.47808653960],
[0.00000000075, 5.40269356209, 26091.78447693220],
[0.00000000074, 4.31017375756, 2333.19639287200],
[0.00000000086, 0.78555390902, 57837.13833230060],
[0.00000000081, 0.95889229790, 26107.57290247399],
[0.00000000085, 3.28561166885, 12432.04265039780],
[0.00000000070, 3.55533072657, 13521.75144159140],
[0.00000000078, 0.27707431029, 37410.56723987860],
[0.00000000063, 0.65828525440, 110012.94461544899],
[0.00000000064, 2.68437002997, 43071.89928903080],
[0.00000000067, 3.89216578780, 26084.02180621620],
[0.00000000064, 2.75958867988, 40853.14218484400],
[0.00000000061, 5.77836694481, 12566.15169998280],
[0.00000000069, 3.44813862795, 10213.28554621100],
[0.00000000060, 0.79452201416, 53131.40602475700],
[0.00000000063, 5.02106928248, 98690.28051714458],
[0.00000000063, 2.49160532665, 78793.40038981718],
[0.00000000059, 0.15541098170, 36301.18868778519],
[0.00000000056, 1.01839356017, 27676.97603685800],
[0.00000000053, 1.55958841442, 49957.04917896160],
[0.00000000052, 5.14041028675, 52156.13652224860],
[0.00000000052, 1.15062443564, 26202.34243025941],
[0.00000000052, 0.53687576880, 77308.10968311399],
[0.00000000048, 1.60851837486, 25234.70675982219],
[0.00000000048, 5.19507775798, 48733.23133818299],
[0.00000000053, 5.49113976101, 25661.30495069820],
[0.00000000046, 5.18676728087, 77204.32749453338],
[0.00000000044, 4.97145613800, 25973.46385288896],
[0.00000000054, 0.32708522231, 25874.60404613620],
[0.00000000042, 2.21900478384, 52179.68761850640],
[0.00000000045, 2.52716095523, 103292.23063610759],
[0.00000000048, 0.48944876530, 51646.11531805379],
[0.00000000039, 6.25275173960, 47623.85278608960],
[0.00000000041, 2.81015791586, 41962.52073693740],
[0.00000000037, 5.01445357044, 26080.78959457339],
[0.00000000038, 6.08585317961, 79323.09135491178],
[0.00000000043, 3.24574920597, 52389.10537858640],
[0.00000000041, 2.43000457106, 639.89728631400],
[0.00000000039, 0.76157461206, 82815.66292178139],
[0.00000000034, 3.28090243752, 62389.09182935939],
[0.00000000037, 0.05738918168, 38519.94579197200],
[0.00000000035, 5.78457148656, 68050.42387851159],
[0.00000000040, 3.14856042352, 426.59819087600],
[0.00000000042, 4.09553132731, 52195.47604404819],
[0.00000000032, 2.45518077222, 38654.05484155699],
[0.00000000039, 1.80165134294, 33326.57873317420],
[0.00000000041, 4.32141055637, 26095.01668857500],
[0.00000000032, 3.72358129034, 136100.84775702319],
[0.00000000040, 5.69015360764, 31749.23519072640],
[0.00000000032, 1.65828846012, 105460.99111839019],
[0.00000000032, 1.02549984810, 155418.04029735178],
[0.00000000030, 1.57915654792, 52168.69273614759],
[0.00000000031, 0.69335015231, 50057.04242277000],
[0.00000000033, 4.04678616141, 55618.38122811380],
[0.00000000029, 3.72464718175, 51535.90899683439],
[0.00000000029, 5.73654447860, 129380.13377768178],
[0.00000000038, 3.74472554242, 18849.22754997420],
[0.00000000028, 3.05059885517, 339142.74084046457],
[0.00000000035, 0.74194291507, 52171.92494779040],
[0.00000000028, 0.73918545262, 7880.08915333899],
[0.00000000036, 1.26742819742, 51116.42435295920],
[0.00000000035, 5.29298143160, 45405.09568190280],
[0.00000000032, 5.79438282818, 18093.37469954999],
[0.00000000026, 5.79318346346, 66941.04532641819],
[0.00000000028, 4.27104078603, 54394.56338733519],
[0.00000000024, 5.06304791610, 2118.76386037840],
[0.00000000030, 1.05420470769, 52182.91983014920],
[0.00000000025, 1.75996910240, 124778.18365871879],
[0.00000000022, 4.43631488516, 3328.13565628019],
[0.00000000022, 5.09106835544, 99799.65906923798],
[0.00000000022, 1.88199362566, 78244.03966382280],
[0.00000000021, 2.56123211200, 94138.32702008578],
[0.00000000025, 5.46150069597, 104881.30353139139],
[0.00000000025, 0.05236467599, 26514.50133245020],
[0.00000000025, 3.02983070039, 77734.01845962799],
[0.00000000020, 3.48966334599, 103396.01282468818],
[0.00000000021, 3.97495995227, 53764.87917843220],
[0.00000000018, 1.07895331282, 28421.09953444620],
[0.00000000019, 1.98308917333, 23754.70674870219],
[0.00000000018, 4.58631365960, 76044.95232053580],
[0.00000000019, 2.90042907299, 6283.07584999140],
[0.00000000019, 3.18954246101, 51109.31080595839],
[0.00000000018, 2.11231697626, 73711.75592766379],
[0.00000000017, 0.06118735536, 88476.99497093359],
[0.00000000018, 6.26984143774, 15874.61759536320],
[0.00000000018, 2.58820345674, 51123.53789995999],
[0.00000000017, 5.82864656129, 32370.97899156560],
[0.00000000018, 5.22519288335, 78267.59076008058],
[0.00000000015, 5.43053381026, 64741.95798313119],
[0.00000000015, 2.53107093357, 155468.03691925599],
[0.00000000020, 4.40959528115, 1223.81784077861],
[0.00000000015, 4.05461375332, 51962.50718771040],
[0.00000000015, 3.52769852262, 79219.30916633119],
[0.00000000015, 0.45988103836, 162188.75089859738],
[0.00000000015, 0.87152359342, 78283.37918562238],
[0.00000000014, 1.87990160627, 125887.56221081219],
[0.00000000016, 2.82759858554, 105410.99449648599],
[0.00000000013, 4.67219046898, 78256.59587772179],
[0.00000000016, 0.04901690153, 78477.00852016058],
[0.00000000014, 4.21146699511, 52290.24557183361],
[0.00000000014, 4.08726245298, 78270.82297172339],
[0.00000000015, 3.80902990348, 33967.99229491319],
[0.00000000016, 0.28761005157, 44937.13069154840],
[0.00000000014, 5.84330605810, 103821.92160120218],
[0.00000000015, 6.03738264520, 13655.86049117640],
[0.00000000012, 0.81685952408, 81706.28436968799],
[0.00000000015, 3.79894620695, 108903.56606335558],
[0.00000000011, 3.26651828162, 52602.40447402440],
[0.00000000011, 1.28755195884, 29416.03879785439],
[0.00000000011, 4.03185618461, 181505.94343892598],
[0.00000000011, 5.58448046140, 120226.23016165999],
[0.00000000012, 0.32316787548, 91785.46086631398],
[0.00000000013, 2.02636565149, 71492.99882347698],
[0.00000000015, 3.56357453844, 76674.63652943878],
[0.00000000013, 3.80590035776, 78259.82808936459],
[0.00000000010, 0.04109363791, 77197.21394753258],
[0.00000000010, 6.00753285175, 365230.64398203876],
[0.00000000010, 1.74642821988, 52061.36699446317],
[0.00000000013, 2.79229719351, 636.99627202420],
[0.00000000011, 5.52780687723, 26727.80042788820],
[0.00000000011, 4.04728142335, 45892.73043315699],
[0.00000000008, 4.96985130540, 151975.46535238638],
[0.00000000008, 3.44547998787, 23439.44831610119],
[0.00000000011, 2.54429302352, 44181.27784112419],
[0.00000000010, 3.50274229100, 65697.55772473979],
[0.00000000009, 2.45809063705, 93028.94846799239],
[0.00000000009, 4.92568932060, 104331.94280539699],
[0.00000000008, 0.80535713418, 71980.63357473118],
[0.00000000010, 2.20026830808, 130969.20667296558],
[0.00000000007, 2.30885367448, 18207.81398823521],
[0.00000000010, 5.72020107388, 77211.44104153418],
[0.00000000007, 0.15536656581, 129483.91596626239],
[0.00000000008, 2.31255848253, 58458.88213313979],
[0.00000000007, 2.07713892797, 90829.86112470538],
[0.00000000007, 3.50101836609, 117873.36400788819],
[0.00000000007, 3.20275960823, 64607.84893354619],
[0.00000000007, 4.73829767381, 51322.60990139639],
[0.00000000007, 5.65553946700, 181555.94006083018],
[0.00000000009, 2.56870006051, 129909.82474277639],
[0.00000000008, 0.67171808844, 79852.78232000639],
[0.00000000007, 4.06204756163, 39609.65458316560],
[0.00000000007, 1.46575838897, 853.19638175200],
[0.00000000007, 2.57400610109, 69159.80243060499],
[0.00000000006, 3.86283147263, 59414.48187474840],
[0.00000000006, 1.33545681950, 102132.85546210999],
[0.00000000007, 2.80506785787, 39743.76363275060],
[0.00000000006, 1.66711581835, 28206.66700195260],
[0.00000000008, 4.73806237855, 150866.08680029298],
[0.00000000006, 0.81325444169, 207593.84658050018],
[0.00000000006, 0.06925555540, 58946.51688439399],
[0.00000000006, 3.09908354288, 114564.89811250778],
[0.00000000006, 0.88473087003, 104358.72611329758],
[0.00000000006, 3.51715962887, 188276.65404017158],
[0.00000000006, 4.13083556162, 54509.00267602040],
[0.00000000006, 3.14680331401, 104564.91166173479],
[0.00000000007, 5.89465282471, 131498.89763806018],
[0.00000000005, 0.27174681491, 143961.26714946238],
[0.00000000005, 5.25316838887, 3340.61242669980],
[0.00000000007, 1.99860349328, 104355.49390165479],
[0.00000000005, 1.47362369989, 9103.90699411760],
[0.00000000007, 0.60725013988, 60055.89543648739],
[0.00000000005, 3.20081630256, 13541.42120249119],
[0.00000000006, 0.50137409605, 63498.47038145279],
[0.00000000005, 5.07739475360, 97580.90196505119],
[0.00000000005, 1.35632842517, 104344.49901929598],
[0.00000000005, 2.16611734526, 103925.01437542078],
[0.00000000005, 4.04581717475, 98068.53671630539],
[0.00000000005, 4.90166806916, 22759.76748529401],
[0.00000000005, 3.87246722733, 89586.37352302698],
[0.00000000005, 3.01510200596, 103285.11708910679],
[0.00000000006, 1.44791474080, 78050.41032928458],
[0.00000000005, 2.47831218420, 26241.68195205900],
[0.00000000005, 3.85799454501, 107794.18751126219],
[0.00000000005, 0.57300969993, 134991.46920492979],
[0.00000000005, 2.38724530268, 146314.13330323418],
[0.00000000004, 6.11121027497, 90695.75207512038],
[0.00000000004, 1.83181231470, 74821.13447975718],
[0.00000000004, 5.23938469806, 130012.91751699499],
[0.00000000005, 1.18020888905, 27311.72098235281],
[0.00000000005, 3.00001411726, 85034.42002596818],
[0.00000000005, 5.56662713374, 155997.72788435058],
[0.00000000005, 2.35342507828, 145204.75475114079],
[0.00000000004, 4.57119707855, 157636.79740153858],
[0.00000000004, 5.78384635962, 51742.09454527159],
[0.00000000004, 2.41778026187, 157483.01859105378],
[0.00000000005, 2.53226316949, 103299.34418310839],
[0.00000000004, 3.71458526250, 26555.86813192860],
[0.00000000004, 3.83639975710, 150244.34299945379],
[0.00000000004, 3.30201863644, 76144.94556434419],
[0.00000000004, 0.68904721853, 124156.43985787958],
[0.00000000004, 1.73206522989, 178063.36849396059],
[0.00000000005, 3.20991489892, 71025.03383312259],
[0.00000000005, 3.69408876581, 105940.68546158058],
[0.00000000004, 2.75867944254, 391318.54712361297],
[0.00000000005, 0.53586068200, 80482.46652890938],
[0.00000000004, 5.07565982849, 51756.32163927320],
[0.00000000004, 0.12462379137, 78690.30761559859],
[0.00000000004, 5.25512859919, 157057.10981453978],
[0.00000000004, 5.66367904256, 9384.84100807520],
[0.00000000004, 4.70366039546, 54294.57014352679],
[0.00000000004, 4.74767635950, 204151.27163553478],
[0.00000000003, 3.24177385660, 155571.81910783658],
[0.00000000003, 0.85377908455, 16066.06586147480],
[0.00000000003, 1.58566666033, 130226.21661243298],
[0.00000000004, 5.58218314089, 119116.85160956658],
[0.00000000004, 0.94898112028, 78378.14871340781],
[0.00000000004, 6.15781348253, 97112.93697469679],
[0.00000000004, 2.31787867435, 52815.70356946240],
[0.00000000004, 2.73401660736, 78417.48823520739],
[0.00000000004, 5.67762508473, 183674.70392120858],
[0.00000000004, 0.21138526735, 214364.55718174578],
[0.00000000004, 5.24311464709, 116917.76426627958],
[0.00000000003, 3.86634858823, 104371.28232719658],
[0.00000000004, 5.42881221134, 233731.74634397858],
[0.00000000003, 1.97251042531, 183145.01295611398],
[0.00000000003, 0.60740481915, 133882.09065283638],
[0.00000000003, 6.23399386415, 181659.72224941078],
[0.00000000004, 6.22336284288, 140652.80125408198],
[0.00000000003, 5.94876130841, 25035.63475838580],
[0.00000000003, 3.83428144879, 233681.74972207438],
[0.00000000003, 2.32902857669, 182085.63102592478],
[0.00000000003, 2.84354681160, 123200.84011627098],
[0.00000000003, 1.53933182823, 176953.98994186718],
[0.00000000004, 2.45893471155, 207643.84320240439],
[0.00000000003, 5.72001402121, 102762.53967101299],
[0.00000000004, 1.40880562474, 80382.47328510099],
[0.00000000003, 4.90489886883, 51749.20809227239],
[0.00000000003, 4.76799924569, 104138.31347085879],
[0.00000000004, 6.26291139255, 25021.40766438420],
[0.00000000003, 0.40352872921, 132028.58860315479],
[0.00000000003, 2.66696150741, 157586.80077963437],
[0.00000000003, 5.23202292846, 84546.78527471398],
[0.00000000003, 4.59428408981, 131548.89425996438],
[0.00000000003, 2.53649995681, 50579.61984086379],
[0.00000000003, 2.55542640702, 77829.99768684579],
[0.00000000004, 1.67304824627, 130419.84594697120],
[0.00000000003, 6.21862713072, 95247.70557217918],
[0.00000000003, 5.37878648081, 44295.71712980940],
[0.00000000003, 4.68342323732, 156507.74908854539],
[0.00000000003, 3.36164307862, 104778.21075717278],
[0.00000000003, 2.91632245418, 166740.70439565618],
[0.00000000002, 0.72039482289, 7994.52844202420],
[0.00000000002, 5.43309839263, 78903.60671103658],
[0.00000000002, 1.12849064703, 183724.70054311278],
[0.00000000003, 1.94668130835, 143005.66740785378],
[0.00000000003, 0.56289392960, 104347.73123093879],
[0.00000000002, 1.78482957305, 156531.30018480319],
[0.00000000003, 5.03542424850, 130443.39704322898],
[0.00000000003, 4.72735160431, 78149.27013603736],
[0.00000000002, 5.31651763274, 208173.53416749898],
[0.00000000003, 5.36470448658, 131395.11544947959],
[0.00000000002, 0.06581745526, 196137.07343261078],
[0.00000000002, 2.93678015526, 167850.08294774959],
[0.00000000002, 5.84781134233, 65831.66677432480],
[0.00000000002, 5.56634055777, 70269.18098269838],
[0.00000000002, 5.42145220392, 183570.92173262799],
[0.00000000002, 6.06636386319, 53242.30176033840],
[0.00000000002, 4.37154457896, 128220.75860368418],
[0.00000000002, 0.35903300236, 187167.27548807819],
[0.00000000002, 2.78347515438, 79330.20490191258],
[0.00000000002, 4.51952536661, 203041.89308344138],
[0.00000000002, 3.36865001265, 170049.17029103659],
[0.00000000002, 3.08184453618, 50593.84693486539],
[0.00000000002, 4.32534428501, 55503.94193942859],
[0.00000000002, 1.81636961816, 110634.68841628819],
[0.00000000002, 5.58793955981, 103917.90082841998],
[0.00000000002, 5.79409172557, 417406.45026518717],
[0.00000000002, 0.85923934181, 235900.50682626116],
[0.00000000002, 4.60084058009, 26941.09952332620],
[0.00000000002, 5.14995676460, 182188.72380014337],
[0.00000000002, 3.91756419842, 130446.62925487179],
[0.00000000002, 2.88997273266, 27154.39861876420],
[0.00000000003, 5.85721944439, 52329.58509363319],
[0.00000000002, 6.10145799164, 77623.81213840858],
[0.00000000002, 1.98246165585, 77844.22478084739],
[0.00000000002, 0.11071759480, 130866.11389874699],
[0.00000000002, 0.64849171165, 52643.77127350280],
[0.00000000002, 3.98410950717, 104466.05185498200],
[0.00000000002, 1.83715639115, 123668.80510662538],
[0.00000000002, 5.61305711026, 76667.52298243798],
[0.00000000002, 5.83992902277, 19804.82729158280],
[0.00000000002, 0.54331921743, 130459.18546877075],
[0.00000000002, 0.00997429525, 141762.17980617538],
[0.00000000002, 5.59377744943, 35191.81013569180],
[0.00000000002, 0.39746661127, 26521.61487945100],
[0.00000000002, 6.16192704020, 130652.81480330898],
[0.00000000002, 0.85416063806, 25934.12433108940],
[0.00000000002, 2.18339110714, 156100.82065856918],
[0.00000000002, 4.39281517355, 130432.40216087017],
[0.00000000002, 5.50117730009, 172402.03644480839],
[0.00000000001, 3.49234867738, 130435.63437251298],
[0.00000000001, 4.80995492080, 77837.11123384659],
[0.00000000002, 6.26921260007, 87367.61641884019],
[0.00000000002, 2.79561490409, 115674.27666460119],
[0.00000000002, 4.92122664455, 24864.08530079559],
[0.00000000001, 2.41576832330, 26037.90651966999],
[0.00000000001, 6.04596837149, 129373.02023068098],
[0.00000000002, 0.94020572434, 80596.90581759460],
[0.00000000002, 0.30073776192, 51639.00177105299],
[0.00000000001, 0.18846827752, 34082.43158359840],
[0.00000000001, 3.62844435085, 161079.37234650398],
[0.00000000002, 5.13133615893, 49842.60989027639],
[0.00000000001, 0.30832555285, 53228.07466633679],
[0.00000000001, 5.56519625382, 129387.24732468258],
[0.00000000001, 5.63110777945, 46848.33017476560],
[0.00000000001, 1.38420566741, 26011.63707029860],
[0.00000000001, 5.86450783334, 26724.89941359840],
[0.00000000001, 6.14517818644, 76681.75007643958],
[0.00000000001, 3.19299019423, 25654.19140369739],
[0.00000000001, 0.34495954566, 128850.44281258718],
[0.00000000001, 3.60230008239, 20760.42703319140],
[0.00000000001, 5.80015495751, 19406.67828817460],
[0.00000000001, 4.42116052212, 100909.03762133139],
[0.00000000001, 0.48535289275, 52698.38370124219],
[0.00000000001, 6.22940855233, 111590.28815789679],
[0.00000000001, 0.16055219324, 105307.21230790539],
[0.00000000001, 2.19795772042, 29428.51556827400],
[0.00000000001, 5.09783503526, 102232.84870591838],
[0.00000000001, 0.61014627166, 25668.41849769900],
[0.00000000001, 5.62459774786, 25565.32572348040],
[0.00000000001, 0.90991571866, 103711.71527998279],
[0.00000000001, 0.28037611495, 25450.90686955000],
[0.00000000001, 0.54824728173, 26137.89976347840],
[0.00000000001, 4.25324476801, 209812.60368468695],
[0.00000000001, 0.08089899001, 51543.02254383520],
[0.00000000001, 0.33953378597, 51528.79544983359],
[0.00000000001, 4.15667461533, 25551.09862947879],
[0.00000000001, 1.59597814656, 72936.23331633979],
[0.00000000001, 5.59362222240, 25619.93815121980],
[0.00000000001, 3.26520760555, 240452.46032331996],
[0.00000000001, 5.52286605071, 52125.80966124419],
], [
[0.00000188077, 0.03466830117, 52175.80628314840],
[0.00000142152, 3.12505452600, 26087.90314157420],
[0.00000096877, 3.00378171915, 78263.70942472259],
[0.00000043669, 6.01867965826, 104351.61256629678],
[0.00000035395, 0.00000000000, 0.00000000000],
[0.00000018045, 2.77538373991, 130439.51570787099],
[0.00000006971, 5.81808665742, 156527.41884944518],
[0.00000002556, 2.57014364454, 182615.32199101939],
[0.00000000900, 5.59308888939, 208703.22513259358],
[0.00000000307, 2.32189002493, 234791.12827416777],
[0.00000000117, 3.16567324160, 24978.52458948080],
[0.00000000102, 5.32134064237, 260879.03141574195],
[0.00000000077, 6.24155593431, 51066.42773105500],
[0.00000000057, 6.11222330831, 27197.28169366760],
[0.00000000034, 2.03244612467, 286966.93455731616],
[0.00000000038, 2.99912912226, 77154.33087262919],
[0.00000000031, 3.11483471984, 53285.18483524180],
[0.00000000017, 6.02950226714, 103242.23401420339],
[0.00000000011, 5.00109293882, 313054.83769889036],
[0.00000000009, 0.59396483404, 20426.57109242200],
[0.00000000009, 3.65190477342, 46514.47423399620],
[0.00000000009, 6.28305510644, 79373.08797681599],
[0.00000000008, 2.74138109305, 129330.13715577759],
[0.00000000007, 5.79018632644, 25132.30339996560],
[0.00000000005, 0.33554769835, 72602.37737557039],
[0.00000000005, 1.31115810350, 26617.59410666880],
[0.00000000004, 2.46414914425, 51220.20654153979],
[0.00000000004, 1.74528964721, 339142.74084046457],
[0.00000000004, 4.31141963105, 52705.49724824299],
[0.00000000004, 3.07093349506, 27043.50288318280],
[0.00000000004, 5.68013701250, 30639.85663863300],
[0.00000000003, 5.80662640937, 155418.04029735178],
[0.00000000003, 4.64519088060, 27147.28507176339],
[0.00000000004, 3.02893592955, 23869.14603738740],
[0.00000000003, 4.35199345075, 79323.09135491178],
[0.00000000003, 1.29040630287, 53235.18821333759],
[0.00000000003, 4.34017676059, 14765.23904326980],
[0.00000000003, 2.86652251194, 105460.99111839019],
[0.00000000003, 6.23875368963, 28306.66024576099],
[0.00000000003, 3.37815322354, 98690.28051714458],
[0.00000000002, 5.37466119262, 110012.94461544899],
[0.00000000002, 0.16040583556, 50586.73338786459],
[0.00000000002, 0.35038889636, 19317.19254032860],
[0.00000000002, 6.23271649650, 49957.04917896160],
[0.00000000002, 2.52219274566, 181505.94343892598],
[0.00000000002, 5.05358903232, 162188.75089859738],
[0.00000000002, 0.15071040297, 124778.18365871879],
[0.00000000002, 2.29024350361, 56727.75978020720],
[0.00000000002, 0.42411179784, 71492.99882347698],
[0.00000000002, 6.11262694468, 57837.13833230060],
[0.00000000002, 2.17198531948, 108903.56606335558],
[0.00000000002, 2.92723030315, 54394.56338733519],
[0.00000000002, 2.40411188609, 83925.04147387479],
[0.00000000002, 3.43613336205, 78267.59076008058],
[0.00000000002, 4.77873510695, 365230.64398203876],
[0.00000000002, 3.54043808451, 64741.95798313119],
[0.00000000002, 1.60502923885, 77734.01845962799],
[0.00000000002, 3.11800510932, 150866.08680029298],
[0.00000000002, 1.02098746090, 78793.40038981718],
[0.00000000002, 4.39439085682, 88476.99497093359],
[0.00000000002, 1.49912329404, 43071.89928903080],
[0.00000000002, 1.96277160647, 25558.21217647960],
[0.00000000002, 4.76774165204, 77204.32749453338],
[0.00000000002, 0.61066658116, 155468.03691925599],
[0.00000000002, 5.26875308161, 77308.10968311399],
[0.00000000002, 0.52736095020, 94138.32702008578],
[0.00000000002, 2.05793854229, 103396.01282468818],
[0.00000000002, 4.12698349577, 66941.04532641819],
[0.00000000002, 5.43336870762, 78283.37918562238],
[0.00000000002, 1.97520131105, 136100.84775702319],
[0.00000000002, 5.54343111585, 81706.28436968799],
[0.00000000002, 1.25444219651, 40853.14218484400],
[0.00000000002, 1.07684180123, 103292.23063610759],
[0.00000000001, 3.23979322492, 52156.13652224860],
[0.00000000002, 5.33834891475, 52182.91983014920],
[0.00000000002, 3.36867866204, 99799.65906923798],
[0.00000000002, 5.40697906670, 82815.66292178139],
[0.00000000001, 5.80853057947, 4551.95349705880],
[0.00000000001, 4.95909385120, 129483.91596626239],
[0.00000000001, 3.17481245588, 76674.63652943878],
[0.00000000001, 1.53803169600, 52389.10537858640],
[0.00000000001, 2.48052961456, 53764.87917843220],
[0.00000000001, 1.20843095195, 105410.99449648599],
[0.00000000002, 3.64576833526, 45405.09568190280],
[0.00000000002, 4.00710217385, 104881.30353139139],
[0.00000000001, 3.09532094520, 76044.95232053580],
[0.00000000001, 5.52119023864, 58946.51688439399],
[0.00000000002, 5.53036712466, 131548.89425996438],
[0.00000000001, 0.38352295948, 52179.68761850640],
[0.00000000001, 0.08902944955, 51116.42435295920],
[0.00000000001, 1.47514166670, 62389.09182935939],
[0.00000000001, 4.20864838814, 131498.89763806018],
[0.00000000001, 2.88161012078, 79219.30916633119],
[0.00000000001, 5.03155341199, 51646.11531805379],
[0.00000000001, 0.05873279909, 53131.40602475700],
[0.00000000001, 0.60647620600, 38654.05484155699],
[0.00000000001, 1.58007357234, 391318.54712361297],
[0.00000000001, 0.68687557696, 130969.20667296558],
[0.00000000001, 3.90367213586, 129380.13377768178],
[0.00000000001, 2.11138180302, 32858.61374281979],
[0.00000000001, 0.18542211423, 78244.03966382280],
[0.00000000001, 1.24063083423, 9103.90699411760],
[0.00000000001, 1.78547815249, 188276.65404017158],
[0.00000000001, 0.94125502564, 93028.94846799239],
[0.00000000001, 2.41309932759, 55618.38122811380],
[0.00000000001, 2.29683748973, 52195.47604404819],
[0.00000000001, 3.39284109553, 25028.52121138500],
[0.00000000001, 4.29717383023, 26301.20223701220],
[0.00000000001, 6.10639166059, 102132.85546210999],
[0.00000000001, 4.58189329524, 37410.56723987860],
[0.00000000001, 6.16145880062, 125887.56221081219],
[0.00000000001, 5.22010441376, 52171.92494779040],
[0.00000000001, 5.95645110567, 80482.46652890938],
[0.00000000001, 4.81981872221, 26107.57290247399],
[0.00000000001, 4.27546069271, 36301.18868778519],
[0.00000000001, 2.43374991272, 51535.90899683439],
[0.00000000001, 4.03088051207, 1109.37855209340],
[0.00000000001, 5.60495524983, 207593.84658050018],
[0.00000000001, 4.89918476796, 35191.81013569180],
[0.00000000001, 6.07747011982, 27676.97603685800],
[0.00000000001, 5.48361013686, 29530.47808653960],
[0.00000000001, 0.15288602386, 25448.00585526019],
[0.00000000001, 2.18342825402, 63498.47038145279],
[0.00000000001, 3.67054321453, 21535.94964451540],
[0.00000000001, 1.49815422727, 26084.02180621620],
[0.00000000001, 1.75551273491, 26095.01668857500],
[0.00000000001, 2.60061927559, 12566.15169998280],
[0.00000000001, 2.69537843932, 52290.24557183361],
[0.00000000001, 4.87760109673, 25874.60404613620],
[0.00000000001, 2.82170820105, 26091.78447693220],
[0.00000000001, 0.20736391933, 52061.36699446317],
[0.00000000001, 3.82330817663, 68050.42387851159],
[0.00000000001, 4.42501613287, 22645.32819660879],
[0.00000000001, 6.01128227925, 52168.69273614759],
[0.00000000001, 0.28595674172, 11322.66409830440],
[0.00000000001, 5.86280830053, 26202.34243025941],
[0.00000000001, 3.42109354799, 25973.46385288896],
[0.00000000001, 0.30050065300, 41962.52073693740],
[0.00000000001, 2.73414310032, 25035.63475838580],
[0.00000000001, 1.72346523407, 51962.50718771040],
[0.00000000001, 4.77297529316, 78477.00852016058],
[0.00000000001, 5.84491832575, 50057.04242277000],
[0.00000000001, 3.22072290870, 25021.40766438420],
[0.00000000001, 4.74388045372, 26514.50133245020],
[0.00000000001, 4.31760630574, 69159.80243060499],
[0.00000000001, 0.65529515413, 426.59819087600],
[0.00000000000, 1.96307435492, 1059.38193018920],
[0.00000000001, 5.58694327783, 79852.78232000639],
[0.00000000000, 3.84680432548, 26080.78959457339],
[0.00000000001, 6.07111696987, 102762.53967101299],
[0.00000000000, 0.59142287644, 73711.75592766379],
[0.00000000001, 5.84438975852, 105307.21230790539],
[0.00000000001, 2.82906439989, 24498.83024629040],
], [
[0.00000114078, 3.14159265359, 0.00000000000],
[0.00000003247, 2.02848007619, 26087.90314157420],
[0.00000001914, 1.41731803758, 78263.70942472259],
[0.00000001727, 4.50137643801, 52175.80628314840],
[0.00000001237, 4.49970181057, 104351.61256629678],
[0.00000000645, 1.26591776986, 130439.51570787099],
[0.00000000298, 4.30600984981, 156527.41884944518],
[0.00000000128, 1.05702505039, 182615.32199101939],
[0.00000000051, 4.08566191934, 208703.22513259358],
[0.00000000020, 0.82130394681, 234791.12827416777],
[0.00000000008, 3.82199615635, 260879.03141574195],
[0.00000000003, 0.54824060574, 286966.93455731616],
[0.00000000002, 3.52134138964, 313054.83769889036],
[0.00000000001, 1.67435118540, 24978.52458948080],
[0.00000000002, 4.60718203612, 51066.42773105500],
[0.00000000001, 1.11396201203, 129330.13715577759],
[0.00000000001, 4.35040700322, 103242.23401420339],
[0.00000000001, 4.17434865844, 79373.08797681599],
[0.00000000001, 1.20388630609, 77154.33087262919],
[0.00000000001, 4.84677084740, 27197.28169366760],
[0.00000000001, 0.29913093643, 339142.74084046457],
[0.00000000000, 4.11587125815, 155418.04029735178],
[0.00000000000, 0.73293870976, 46514.47423399620],
[0.00000000000, 3.68822427283, 21535.94964451540],
[0.00000000000, 3.83816920045, 20426.57109242200],
[0.00000000000, 4.73086078962, 1059.38193018920],
[0.00000000000, 0.40939402954, 24498.83024629040],
[0.00000000000, 3.30678220146, 365230.64398203876],
], [
[0.00000000877, 3.14159265359, 0.00000000000],
[0.00000000059, 3.37513289692, 52175.80628314840],
[0.00000000042, 0.02433099382, 78263.70942472259],
[0.00000000043, 4.65071406046, 26087.90314157420],
[0.00000000031, 2.98112204944, 104351.61256629678],
[0.00000000019, 6.00992467582, 130439.51570787099],
[0.00000000010, 2.75699791920, 156527.41884944518],
[0.00000000005, 5.79082359724, 182615.32199101939],
[0.00000000002, 2.51435448230, 208703.22513259358],
[0.00000000001, 5.49411470932, 234791.12827416777],
[0.00000000001, 2.23688504668, 260879.03141574195],
[0.00000000001, 5.18718589133, 286966.93455731616],
[0.00000000000, 2.11315496491, 313054.83769889036],
]],
('Mercury', 'B'):[[
[0.11737528962, 1.98357498767, 26087.90314157420],
[0.02388076996, 5.03738959685, 52175.80628314840],
[0.01222839532, 3.14159265359, 0.00000000000],
[0.00543251810, 1.79644363963, 78263.70942472259],
[0.00129778770, 4.83232503961, 104351.61256629678],
[0.00031866927, 1.58088495667, 130439.51570787099],
[0.00007963301, 4.60972126348, 156527.41884944518],
[0.00002014189, 1.35324164694, 182615.32199101939],
[0.00000513953, 4.37835409309, 208703.22513259358],
[0.00000207674, 4.91772564073, 27197.28169366760],
[0.00000208584, 2.02020294153, 24978.52458948080],
[0.00000132013, 1.11908492283, 234791.12827416777],
[0.00000100454, 5.65684734206, 20426.57109242200],
[0.00000121395, 1.81271752059, 53285.18483524180],
[0.00000091566, 2.28163128692, 25028.52121138500],
[0.00000099214, 0.09391887097, 51116.42435295920],
[0.00000094574, 1.24184909234, 31749.23519072640],
[0.00000078785, 4.40725880000, 57837.13833230060],
[0.00000077747, 0.52557061749, 1059.38193018920],
[0.00000084264, 5.08510388314, 51066.42773105500],
[0.00000049948, 3.49752993688, 5661.33204915220],
[0.00000046454, 3.23739270829, 77204.32749453338],
[0.00000044767, 4.87849816734, 79373.08797681599],
[0.00000040766, 2.46558332165, 46514.47423399620],
[0.00000037378, 4.45768797944, 4551.95349705880],
[0.00000034082, 4.14209210575, 260879.03141574195],
[0.00000035911, 1.09057317869, 1109.37855209340],
[0.00000031953, 1.18516389747, 83925.04147387479],
[0.00000030954, 3.50328027210, 21535.94964451540],
[0.00000031808, 2.41474588439, 47623.85278608960],
[0.00000028691, 1.84828614269, 77154.33087262919],
[0.00000025765, 2.77593370583, 27043.50288318280],
[0.00000025199, 3.59062266460, 27147.28507176339],
[0.00000020244, 3.06833797229, 51646.11531805379],
[0.00000018591, 5.58427274440, 73711.75592766379],
[0.00000016971, 0.02791276551, 103292.23063610759],
[0.00000020099, 4.06593040301, 25132.30339996560],
[0.00000017002, 6.13739392193, 41962.52073693740],
[0.00000014984, 1.64717994813, 105460.99111839019],
[0.00000014186, 0.33074185469, 10213.28554621100],
[0.00000015577, 6.07693643204, 53131.40602475700],
[0.00000015795, 3.79629547258, 529.69096509460],
[0.00000014011, 5.52786452723, 72602.37737557039],
[0.00000012309, 3.16626298867, 14765.23904326980],
[0.00000011261, 0.11326534696, 13521.75144159140],
[0.00000012448, 4.05109331029, 39609.65458316560],
[0.00000013044, 3.48016433624, 37410.56723987860],
[0.00000011042, 4.23192662377, 110012.94461544899],
[0.00000011152, 0.55658461820, 63498.47038145279],
[0.00000010717, 1.53686240986, 25661.30495069820],
[0.00000010213, 2.87881017166, 12566.15169998280],
[0.00000009924, 0.94824584866, 65697.55772473979],
[0.00000011047, 5.79741510309, 51749.20809227239],
[0.00000010460, 5.82962163777, 50586.73338786459],
[0.00000009774, 1.66271762650, 24498.83024629040],
[0.00000009412, 1.82364886045, 15874.61759536320],
[0.00000012866, 4.81650804018, 30639.85663863300],
[0.00000009123, 4.88604394110, 103242.23401420339],
[0.00000009011, 1.04262074744, 426.59819087600],
[0.00000008735, 3.04132552652, 68050.42387851159],
[0.00000008491, 1.05130498445, 1589.07289528380],
[0.00000008835, 0.88128343813, 286966.93455731616],
[0.00000008823, 5.81343662067, 11322.66409830440],
[0.00000008196, 0.84015129448, 51220.20654153979],
[0.00000007640, 3.43584035231, 36301.18868778519],
[0.00000009175, 6.16059719071, 77734.01845962799],
[0.00000008897, 0.39691733779, 53235.18821333759],
[0.00000007253, 2.37179970828, 99799.65906923798],
[0.00000007104, 5.73557153523, 26617.59410666880],
[0.00000008322, 5.27157128800, 25558.21217647960],
[0.00000006578, 2.66741925057, 52705.49724824299],
[0.00000005825, 6.25072627414, 33326.57873317420],
[0.00000005625, 3.08030000230, 129380.13377768178],
[0.00000005295, 1.35863387771, 45892.73043315699],
[0.00000005116, 2.67576280851, 76674.63652943878],
[0.00000005035, 2.66614676257, 77837.11123384659],
[0.00000004762, 4.68983196238, 131548.89425996438],
[0.00000005714, 2.87339047644, 79219.30916633119],
[0.00000005601, 5.37190885150, 955.59974160860],
[0.00000004965, 3.47619946892, 59414.48187474840],
[0.00000005468, 1.43781223143, 56727.75978020720],
[0.00000004080, 4.01667499000, 91785.46086631398],
[0.00000003971, 5.44452771841, 6283.07584999140],
[0.00000004063, 5.64291749144, 26068.23338067440],
[0.00000003877, 3.60887633874, 89586.37352302698],
[0.00000004047, 5.95235957644, 38654.05484155699],
[0.00000004064, 1.46283079734, 26107.57290247399],
[0.00000003681, 0.47365215122, 62389.09182935939],
[0.00000004247, 6.23163402945, 40853.14218484400],
[0.00000003694, 2.75543227024, 7238.67559160000],
[0.00000003348, 5.91868911857, 43071.89928903080],
[0.00000004475, 2.28937952702, 98690.28051714458],
[0.00000003115, 0.74943919509, 32858.61374281979],
[0.00000003100, 3.35203735852, 19804.82729158280],
[0.00000003215, 6.11374633777, 94138.32702008578],
[0.00000003558, 0.98820289555, 136100.84775702319],
[0.00000002908, 4.06284172838, 26514.50133245020],
[0.00000002799, 1.63602212056, 129330.13715577759],
[0.00000002800, 3.88358619611, 77308.10968311399],
[0.00000002680, 4.48235268618, 71980.63357473118],
[0.00000002767, 4.12700796923, 27676.97603685800],
[0.00000003285, 0.39398081520, 18849.22754997420],
[0.00000003290, 2.93487892542, 103821.92160120218],
[0.00000003048, 0.67698362024, 9103.90699411760],
[0.00000002484, 5.42332204960, 125887.56221081219],
[0.00000002663, 1.70280488847, 16983.99614745660],
[0.00000002791, 2.76839978418, 26091.78447693220],
[0.00000002747, 5.75135788288, 19317.19254032860],
[0.00000002676, 5.73635682216, 78793.40038981718],
[0.00000002710, 4.31274902720, 58946.51688439399],
[0.00000002877, 3.45410696457, 79323.09135491178],
[0.00000002787, 4.34025817469, 26084.02180621620],
[0.00000002097, 2.09090732812, 23869.14603738740],
[0.00000002297, 3.90321251530, 313054.83769889036],
[0.00000002535, 3.05170623483, 69159.80243060499],
[0.00000002211, 4.65120210900, 28306.66024576099],
[0.00000001912, 5.78403850812, 102762.53967101299],
[0.00000002265, 3.34478937379, 22645.32819660879],
[0.00000001817, 5.74251490625, 103925.01437542078],
[0.00000001961, 5.94577427093, 105307.21230790539],
[0.00000001922, 4.43763124338, 82815.66292178139],
[0.00000001667, 4.51887419928, 52195.47604404819],
[0.00000001771, 6.12278757535, 155468.03691925599],
[0.00000001515, 1.72458115830, 54394.56338733519],
[0.00000001585, 0.23900687506, 85502.38501632259],
[0.00000001477, 4.73359545019, 29530.47808653960],
[0.00000001469, 1.44574704924, 157636.79740153858],
[0.00000001653, 2.41345886386, 52156.13652224860],
[0.00000001377, 0.59981573116, 26080.78959457339],
[0.00000001430, 0.78416943990, 117873.36400788819],
[0.00000001680, 3.42684715134, 6770.71060124560],
[0.00000001604, 4.52048871587, 3442.57494496540],
[0.00000001345, 0.31857167988, 51535.90899683439],
[0.00000001357, 3.17349203273, 25874.60404613620],
[0.00000001250, 2.33380858079, 25448.00585526019],
[0.00000001196, 2.09277609512, 48733.23133818299],
[0.00000001194, 0.36376300747, 115674.27666460119],
[0.00000001443, 2.73186009497, 64741.95798313119],
[0.00000001375, 5.32672767568, 124778.18365871879],
[0.00000001325, 3.57805811914, 88476.99497093359],
[0.00000001115, 0.26092087309, 639.89728631400],
[0.00000001094, 2.22755234371, 32370.97899156560],
[0.00000001433, 3.03965981318, 66941.04532641819],
[0.00000001370, 3.45924813827, 44937.13069154840],
[0.00000001003, 0.28769164324, 25934.12433108940],
[0.00000001136, 1.11057140999, 52171.92494779040],
[0.00000001000, 0.52457514920, 26241.68195205900],
[0.00000001033, 2.55563840213, 45405.09568190280],
[0.00000001096, 5.01257889902, 7.11354700080],
[0.00000001146, 5.40631829059, 213.29909543800],
[0.00000001080, 5.97835772937, 129909.82474277639],
[0.00000000988, 1.25815251981, 98068.53671630539],
[0.00000001062, 2.88132742088, 120226.23016165999],
[0.00000000892, 0.63710475446, 103396.01282468818],
[0.00000001041, 0.89365572198, 52602.40447402440],
[0.00000000978, 0.93067667928, 53764.87917843220],
[0.00000001136, 5.82023159264, 52179.68761850640],
[0.00000000838, 4.66556603681, 155418.04029735178],
[0.00000000910, 5.53568417425, 58458.88213313979],
[0.00000000834, 5.16159172473, 49957.04917896160],
[0.00000001100, 4.02157761190, 162188.75089859738],
[0.00000000805, 1.03425281191, 23969.13928119580],
[0.00000000835, 5.28205659749, 50057.04242277000],
[0.00000000891, 0.21542628779, 105410.99449648599],
[0.00000000743, 0.86945390288, 52389.10537858640],
[0.00000000783, 3.32304812554, 26301.20223701220],
[0.00000000711, 1.57780048955, 2118.76386037840],
[0.00000000801, 2.18220012579, 151975.46535238638],
[0.00000000915, 1.71247948367, 51962.50718771040],
[0.00000000832, 5.53506450006, 74821.13447975718],
[0.00000000750, 2.16183196338, 52168.69273614759],
[0.00000000923, 2.50170936928, 104881.30353139139],
[0.00000000727, 6.05394635764, 95247.70557217918],
[0.00000000640, 2.71738158564, 131395.11544947959],
[0.00000000628, 1.43868691098, 55618.38122811380],
[0.00000000622, 3.46102298068, 77623.81213840858],
[0.00000000825, 1.00561540075, 85034.42002596818],
[0.00000000611, 0.99677911598, 2218.75710418680],
[0.00000000605, 4.68164610499, 52182.91983014920],
[0.00000000646, 2.57803910757, 128850.44281258718],
[0.00000000621, 1.16576338077, 108903.56606335558],
[0.00000000651, 1.60040223342, 26095.01668857500],
[0.00000000599, 2.51123620954, 130012.91751699499],
[0.00000000570, 1.27714994259, 78283.37918562238],
[0.00000000616, 2.88990323867, 52026.24308601380],
[0.00000000553, 5.17654422678, 25938.33994443960],
[0.00000000560, 3.32834155275, 51109.31080595839],
[0.00000000538, 4.74592892110, 80482.46652890938],
[0.00000000514, 5.52495783925, 25021.40766438420],
[0.00000000512, 2.12021253064, 25035.63475838580],
[0.00000000545, 1.31029342517, 26555.86813192860],
[0.00000000475, 4.05390077061, 149.56319713460],
[0.00000000464, 3.26222495894, 111590.28815789679],
[0.00000000460, 5.34048307893, 46848.33017476560],
[0.00000000550, 5.84636069235, 25619.93815121980],
[0.00000000447, 3.57688571640, 1066.49547719000],
[0.00000000550, 6.22077946049, 51123.53789995999],
[0.00000000596, 0.64492352990, 339142.74084046457],
[0.00000000484, 3.16177806139, 38519.94579197200],
[0.00000000441, 0.67395966884, 1052.26838318840],
[0.00000000477, 0.22606306742, 71025.03383312259],
[0.00000000423, 2.08215220948, 76144.94556434419],
[0.00000000472, 3.35508518254, 35191.81013569180],
[0.00000000418, 3.57908956341, 52329.58509363319],
[0.00000000441, 4.91196768491, 78050.41032928458],
[0.00000000440, 4.47866581814, 183724.70054311278],
[0.00000000435, 1.98197259533, 26094.53170047421],
[0.00000000564, 5.45416215614, 78244.03966382280],
[0.00000000540, 2.87570725847, 181555.94006083018],
[0.00000000450, 6.09063658976, 93028.94846799239],
[0.00000000461, 3.82361162048, 143961.26714946238],
[0.00000000408, 3.34314470563, 52022.02747266360],
[0.00000000412, 2.07516355558, 150866.08680029298],
[0.00000000435, 5.12507754577, 26081.27458267419],
[0.00000000409, 0.56822912556, 64607.84893354619],
[0.00000000388, 4.16039183226, 78259.82808936459],
[0.00000000393, 3.23715146834, 13655.86049117640],
[0.00000000375, 5.33297275541, 26011.63707029860],
[0.00000000467, 5.77388878977, 90829.86112470538],
[0.00000000350, 5.62301652558, 71492.99882347698],
[0.00000000352, 3.27694758804, 26727.80042788820],
[0.00000000350, 3.39302729957, 141762.17980617538],
[0.00000000390, 2.58800166779, 78267.59076008058],
[0.00000000365, 3.19925143022, 52099.54021187280],
[0.00000000433, 1.55185163390, 20760.42703319140],
[0.00000000327, 5.69228054184, 12432.04265039780],
[0.00000000339, 1.58088572820, 45494.58142974879],
[0.00000000338, 2.73161573173, 155997.72788435058],
[0.00000000315, 4.00061444247, 78477.00852016058],
[0.00000000435, 0.36408526333, 114564.89811250778],
[0.00000000344, 5.02616143626, 78256.59587772179],
[0.00000000346, 4.14121333484, 111122.32316754239],
[0.00000000286, 5.40513646014, 6681.22485339960],
[0.00000000283, 3.65516534367, 76.26607127560],
[0.00000000325, 4.30412080460, 124156.43985787958],
[0.00000000364, 2.32771554672, 84546.78527471398],
[0.00000000331, 0.76882559900, 188276.65404017158],
[0.00000000267, 3.81778097058, 19406.67828817460],
[0.00000000270, 6.02010732963, 78114.14622758799],
[0.00000000273, 3.66726180240, 129483.91596626239],
[0.00000000263, 0.18743596408, 77197.21394753258],
[0.00000000268, 3.25051884036, 131498.89763806018],
[0.00000000284, 1.93848296863, 76044.95232053580],
[0.00000000295, 5.53951004419, 130969.20667296558],
[0.00000000335, 5.92048177497, 146314.13330323418],
[0.00000000246, 1.45343047775, 78270.82297172339],
[0.00000000259, 3.08241704780, 77211.44104153418],
[0.00000000253, 2.86398164134, 121335.60871375339],
[0.00000000338, 3.95823396010, 78690.30761559859],
[0.00000000317, 3.98138369220, 79852.78232000639],
[0.00000000232, 4.66776441683, 28206.66700195260],
[0.00000000247, 1.40414696612, 181505.94343892598],
[0.00000000228, 0.25677390582, 103711.71527998279],
[0.00000000219, 4.69799359762, 71582.48457132299],
[0.00000000221, 4.46394113791, 81706.28436968799],
[0.00000000254, 1.43735157085, 5327.47610838280],
[0.00000000199, 5.76674433704, 157483.01859105378],
[0.00000000253, 2.47481215159, 72936.23331633979],
[0.00000000191, 4.17749403686, 134991.46920492979],
[0.00000000246, 5.21552773120, 178063.36849396059],
[0.00000000182, 4.31488794636, 104371.28232719658],
[0.00000000206, 1.62004139707, 106570.36967048359],
[0.00000000234, 2.18979921440, 100909.03762133139],
[0.00000000176, 3.58325574282, 48835.19385644859],
[0.00000000188, 2.58568452037, 51707.84129279399],
[0.00000000177, 1.89461095130, 52169.17772424839],
[0.00000000168, 3.01264496377, 23754.70674870219],
[0.00000000222, 4.35573235377, 52643.77127350280],
[0.00000000169, 5.25194313253, 102232.84870591838],
[0.00000000188, 5.55333225508, 156100.82065856918],
[0.00000000163, 1.72109994467, 104138.31347085879],
[0.00000000205, 5.64507146979, 154938.34595416138],
[0.00000000161, 0.06514575292, 78187.44335344699],
[0.00000000155, 3.29540644622, 97112.93697469679],
[0.00000000152, 1.66425291176, 25654.19140369739],
[0.00000000179, 2.20248310353, 104331.94280539699],
[0.00000000157, 5.91615237188, 51742.09454527159],
[0.00000000176, 5.03409571975, 52182.43484204840],
[0.00000000145, 0.34814763869, 78417.48823520739],
[0.00000000151, 0.84016182050, 26237.46633870879],
[0.00000000143, 0.36102957131, 27154.39861876420],
[0.00000000142, 5.87490895177, 26037.90651966999],
[0.00000000167, 4.43520444137, 25668.41849769900],
[0.00000000137, 2.85089329350, 119116.85160956658],
[0.00000000161, 5.91020381915, 207643.84320240439],
[0.00000000130, 6.26801612444, 137678.19129947099],
[0.00000000130, 0.93376066695, 433.71173787680],
[0.00000000140, 1.22522976768, 26137.89976347840],
[0.00000000144, 4.56326656247, 419.48464387520],
[0.00000000145, 2.53141564902, 116917.76426627958],
[0.00000000145, 3.74606280935, 27140.17152476259],
[0.00000000155, 3.65976494728, 365230.64398203876],
[0.00000000124, 0.92716868075, 104347.73123093879],
[0.00000000140, 0.11287334170, 78109.93061423779],
[0.00000000126, 1.13823138141, 51322.60990139639],
[0.00000000146, 3.25675289634, 3340.61242669980],
[0.00000000122, 5.10611624534, 176953.98994186718],
[0.00000000125, 5.63666753628, 104355.49390165479],
[0.00000000155, 2.30861381490, 51756.32163927320],
[0.00000000136, 3.41914767255, 140652.80125408198],
[0.00000000115, 6.25299482333, 39743.76363275060],
[0.00000000113, 0.79353194356, 7994.52844202420],
[0.00000000126, 0.12477487369, 52815.70356946240],
[0.00000000121, 0.68099507149, 50483.64061364600],
[0.00000000118, 0.87294905519, 137210.22630911658],
[0.00000000112, 2.41390426449, 97580.90196505119],
[0.00000000130, 1.22267912068, 209812.60368468695],
[0.00000000110, 3.15687226733, 25234.70675982219],
[0.00000000109, 2.85465805569, 24395.73747207180],
[0.00000000108, 5.73587160710, 853.19638175200],
[0.00000000141, 4.76875897743, 28421.09953444620],
[0.00000000143, 0.57659923971, 170049.17029103659],
[0.00000000127, 5.39590556187, 110634.68841628819],
[0.00000000110, 0.79294568581, 104564.91166173479],
[0.00000000103, 5.77115680934, 182085.63102592478],
[0.00000000108, 0.78147749534, 42153.96900304900],
[0.00000000101, 6.24176236571, 1692.16566950240],
[0.00000000125, 1.72822604057, 104344.49901929598],
[0.00000000112, 1.53691309669, 18093.37469954999],
[0.00000000100, 6.03656277681, 147423.51185532758],
[0.00000000102, 2.16777222106, 32769.12799497380],
[0.00000000127, 5.69552946334, 44181.27784112419],
[0.00000000096, 2.81662615895, 104202.04936916218],
[0.00000000094, 6.16378269144, 103299.34418310839],
[0.00000000095, 3.08582674985, 70269.18098269838],
[0.00000000096, 3.26682732105, 103285.11708910679],
[0.00000000101, 1.49832461293, 40565.25432477420],
[0.00000000099, 0.11817727117, 167850.08294774959],
[0.00000000099, 3.80154992347, 214364.55718174578],
[0.00000000093, 3.27120904242, 90695.75207512038],
[0.00000000104, 5.35405285854, 126996.94076290558],
[0.00000000105, 0.73008875321, 104778.21075717278],
[0.00000000089, 2.82753100547, 50579.61984086379],
[0.00000000098, 0.55393078868, 33967.99229491319],
[0.00000000087, 1.47928882834, 97670.38771289718],
[0.00000000117, 0.17401840597, 61279.71327726600],
[0.00000000089, 0.41552735762, 26164.16921284980],
[0.00000000091, 2.28447351962, 157057.10981453978],
[0.00000000103, 2.67784306575, 172402.03644480839],
[0.00000000084, 4.31852113132, 60055.89543648739],
[0.00000000085, 4.50666554965, 104358.72611329758],
[0.00000000098, 0.74967522191, 105940.68546158058],
[0.00000000082, 2.80078395016, 52101.02468458109],
[0.00000000086, 0.38069361609, 74923.09699802278],
[0.00000000077, 4.91602955543, 24491.71669928959],
[0.00000000104, 6.08692240129, 10021.83728009940],
[0.00000000094, 2.21754829180, 25973.46385288896],
[0.00000000079, 4.63574888508, 2333.19639287200],
[0.00000000076, 0.06676607630, 157586.80077963437],
[0.00000000076, 4.09119863738, 1596.18644228460],
[0.00000000089, 0.51926466594, 50593.84693486539],
[0.00000000078, 5.85412082904, 18207.81398823521],
[0.00000000083, 1.48347794862, 54294.57014352679],
[0.00000000102, 1.11648927836, 150244.34299945379],
[0.00000000081, 0.43168464249, 155571.81910783658],
[0.00000000071, 2.77560894834, 77829.99768684579],
[0.00000000098, 3.04617186486, 16066.06586147480],
[0.00000000089, 3.91487126164, 68241.87214462319],
[0.00000000076, 3.32839538947, 129799.61842155698],
[0.00000000091, 4.99146967087, 102132.85546210999],
[0.00000000088, 4.54401955709, 51543.02254383520],
[0.00000000092, 4.88825714860, 26202.34243025941],
[0.00000000066, 1.97272013972, 632.78373931320],
[0.00000000066, 1.34921841483, 52808.59002246159],
[0.00000000071, 1.21551241620, 107794.18751126219],
[0.00000000088, 3.90671333341, 74.78159856730],
[0.00000000076, 1.11684262920, 78731.67441507700],
[0.00000000060, 4.94665488683, 78257.08086582259],
[0.00000000067, 4.24719146625, 14477.35118320000],
[0.00000000069, 5.46721744006, 77844.22478084739],
[0.00000000059, 2.80000354604, 25863.55834587229],
[0.00000000060, 4.23924716288, 52225.80290505260],
[0.00000000059, 5.90340687048, 103.09277421860],
[0.00000000059, 3.81127888964, 76571.54375522019],
[0.00000000060, 5.62072757879, 77795.74443436819],
[0.00000000069, 4.36673018646, 207593.84658050018],
[0.00000000066, 0.49890308433, 51951.46148744649],
[0.00000000058, 1.63810168022, 51013.33157874059],
[0.00000000058, 4.28286858594, 77410.51304297059],
[0.00000000066, 0.61313044187, 51639.00177105299],
[0.00000000057, 3.15657420172, 104275.34649502118],
[0.00000000058, 4.41262101447, 26720.68688088739],
[0.00000000075, 0.13973480485, 1581.95934828300],
[0.00000000057, 0.41985749035, 23439.44831610119],
[0.00000000069, 6.04001555481, 29428.51556827400],
[0.00000000055, 0.87548003173, 161079.37234650398],
[0.00000000054, 2.10504641371, 2648.45482547300],
[0.00000000070, 1.90064683191, 204151.27163553478],
[0.00000000054, 3.73359360369, 24925.42843716640],
[0.00000000055, 4.74493087072, 49527.35145767539],
[0.00000000071, 2.67007207774, 24505.94379329119],
[0.00000000057, 1.10422154948, 130459.18546877075],
[0.00000000068, 5.29164108644, 26013.12154300690],
[0.00000000054, 0.06047544079, 52072.71350892979],
[0.00000000053, 0.06419360550, 536.80451209540],
[0.00000000053, 5.00852687358, 25977.69682035479],
[0.00000000052, 4.17403886040, 25131.61398560359],
[0.00000000052, 3.31036935415, 7880.08915333899],
[0.00000000070, 6.10702300469, 52278.89905736699],
[0.00000000059, 1.97971323674, 51219.51712717779],
[0.00000000052, 0.17883872581, 224.34479570190],
[0.00000000057, 2.64616122722, 52125.80966124419],
[0.00000000051, 2.51127480556, 183570.92173262799],
[0.00000000050, 4.67814206741, 130226.21661243298],
[0.00000000050, 4.77326024770, 25780.34552060460],
[0.00000000053, 2.81579181250, 55516.41870984820],
[0.00000000057, 2.13355985608, 128320.75184749259],
[0.00000000049, 2.32162107938, 26395.46076254379],
[0.00000000049, 4.96049794937, 956.28915597060],
[0.00000000047, 4.20636709156, 52250.58788171570],
[0.00000000058, 2.23088591593, 52065.59996192899],
[0.00000000048, 5.31209962934, 1162.47470440780],
[0.00000000062, 6.11793881000, 22747.29071487440],
[0.00000000051, 5.16823572193, 130419.84594697120],
[0.00000000058, 1.50494628165, 54509.00267602040],
[0.00000000060, 0.43836944868, 116783.65521669458],
[0.00000000059, 1.50474668065, 26507.38778544939],
[0.00000000047, 3.28426374672, 25565.32572348040],
[0.00000000056, 2.45288584577, 181026.24909573558],
[0.00000000051, 3.46813929041, 53242.30176033840],
[0.00000000045, 0.64303440167, 52698.38370124219],
[0.00000000049, 0.43622928396, 27999.10262479140],
[0.00000000046, 0.93537805397, 26162.68474014150],
[0.00000000043, 5.95311422864, 76667.52298243798],
[0.00000000060, 1.79764830651, 78270.33798362259],
[0.00000000056, 2.27809233545, 182188.72380014337],
[0.00000000043, 3.95909386803, 26521.61487945100],
[0.00000000043, 2.06740816154, 51859.41441349179],
[0.00000000051, 5.31772214752, 66653.15746634839],
[0.00000000044, 1.68470111077, 23888.81579828719],
[0.00000000054, 3.94217571152, 52325.36948028299],
[0.00000000043, 5.13864955940, 11610.55195837420],
[0.00000000042, 4.61363107691, 52492.19815280499],
[0.00000000046, 3.39633739377, 104505.39137678158],
[0.00000000046, 4.83387098498, 110.20632121940],
[0.00000000045, 3.54092987543, 50800.03248330259],
[0.00000000041, 5.69167231584, 24712.12934172840],
[0.00000000040, 0.05181171325, 123200.84011627098],
[0.00000000053, 0.61042891791, 53228.07466633679],
[0.00000000039, 3.11194295827, 25984.81036735560],
[0.00000000046, 2.53528410360, 50696.93970908399],
[0.00000000038, 4.44293961717, 29416.03879785439],
[0.00000000041, 2.66264705448, 233731.74634397858],
[0.00000000037, 3.37388547918, 1375.77379984580],
[0.00000000038, 5.61891042604, 143005.66740785378],
[0.00000000037, 5.42828179354, 28286.99048486120],
[0.00000000049, 5.33653478407, 99024.13645791399],
[0.00000000040, 5.63484527365, 522.57741809380],
[0.00000000039, 3.40419666656, 25551.09862947879],
[0.00000000036, 5.94925007197, 145204.75475114079],
[0.00000000038, 2.07740095188, 153084.84390447979],
[0.00000000039, 3.20021878147, 163766.09444104518],
[0.00000000037, 5.22659089943, 52595.29092702359],
[0.00000000042, 4.90625897857, 25771.51127191760],
[0.00000000041, 2.99128318097, 26190.99591579279],
[0.00000000044, 1.11685231827, 26404.29501123080],
[0.00000000045, 4.61987657347, 132658.27281205778],
[0.00000000037, 0.21788276252, 166740.70439565618],
[0.00000000034, 1.94222980062, 203041.89308344138],
[0.00000000045, 3.16157322891, 104197.83375581198],
[0.00000000046, 4.46372826281, 316.39186965660],
[0.00000000039, 2.02681719442, 136722.59155786238],
[0.00000000034, 1.34191646454, 467.96499035440],
[0.00000000043, 3.34582658464, 78903.60671103658],
[0.00000000039, 3.65232351757, 196137.07343261078],
[0.00000000037, 0.37289111380, 391318.54712361297],
[0.00000000037, 2.88378512797, 36109.74042167360],
[0.00000000037, 1.66197775716, 52290.24557183361],
[0.00000000036, 3.91856090884, 54087.00576636560],
[0.00000000034, 0.07777074766, 26294.08869001139],
[0.00000000033, 2.57658065167, 26941.09952332620],
[0.00000000034, 1.66706631543, 49842.60989027639],
[0.00000000042, 3.65143192554, 76681.75007643958],
[0.00000000032, 4.02685079656, 24356.78078864160],
[0.00000000041, 3.48117117726, 26610.48055966799],
[0.00000000040, 1.30798263894, 77630.92568540938],
[0.00000000033, 3.31591322468, 65831.66677432480],
[0.00000000042, 4.68305225464, 24609.03656750980],
[0.00000000034, 2.43308912753, 26421.75908234360],
[0.00000000031, 0.55207634036, 13362.44970679920],
[0.00000000031, 3.97168176907, 130435.63437251298],
[0.00000000035, 5.90195011358, 78188.92782615528],
[0.00000000032, 5.58275762493, 25881.71759313700],
[0.00000000032, 3.03394602316, 27780.06881107659],
[0.00000000038, 4.61602478200, 130432.40216087017],
[0.00000000031, 5.37268049479, 75930.51303185058],
[0.00000000034, 4.68006477569, 25754.04720080480],
[0.00000000030, 2.76917399150, 173511.41499690177],
[0.00000000037, 4.37537497770, 1478.86657406440],
[0.00000000030, 2.69970929614, 208173.53416749898],
[0.00000000029, 2.28199342452, 130443.39704322898],
[0.00000000039, 4.04390928499, 34282.17847478280],
[0.00000000033, 1.47153495142, 55503.94193942859],
[0.00000000029, 3.09374594552, 27819.02549450680],
[0.00000000030, 2.30968283835, 26624.70765366959],
[0.00000000035, 2.18534594257, 22759.76748529401],
[0.00000000027, 0.63624513172, 240452.46032331996],
[0.00000000035, 5.40588312340, 58857.03113654799],
[0.00000000028, 5.46904052697, 123668.80510662538],
[0.00000000028, 3.82629644574, 130866.11389874699],
[0.00000000027, 3.91273567728, 163298.12945069079],
[0.00000000032, 3.55783772742, 52252.07235442399],
[0.00000000036, 5.26852179816, 52061.36699446317],
[0.00000000027, 0.81868301401, 25455.11940226100],
[0.00000000030, 6.23608007707, 24176.70365835700],
[0.00000000025, 1.48874402537, 60370.08161635699],
[0.00000000027, 4.41957053501, 78896.49316403578],
[0.00000000025, 3.33404428554, 206.18554843720],
[0.00000000025, 2.22580879047, 12725.45343477500],
[0.00000000025, 5.37774707105, 183145.01295611398],
[0.00000000026, 3.83674753452, 132028.58860315479],
[0.00000000025, 2.93605355840, 129387.24732468258],
[0.00000000025, 5.86161454740, 130289.95251073639],
[0.00000000024, 4.03572089813, 26089.38761428249],
[0.00000000024, 3.09138745629, 26086.41866886590],
[0.00000000024, 1.40452977850, 25446.48957983520],
[0.00000000033, 3.35253473958, 193937.98608932378],
[0.00000000024, 4.81342275570, 27311.72098235281],
[0.00000000024, 2.36840229716, 25440.89230825939],
[0.00000000024, 2.60590286552, 125112.03959948818],
[0.00000000027, 2.64006708171, 44295.71712980940],
[0.00000000029, 3.85906422319, 130652.81480330898],
[0.00000000033, 4.26007262410, 235900.50682626116],
[0.00000000026, 3.37356285012, 87367.61641884019],
[0.00000000024, 3.83432680564, 52381.99183158559],
[0.00000000027, 4.14811634858, 176332.24614102798],
[0.00000000023, 0.19227535404, 647.01083331480],
[0.00000000025, 0.03897225418, 129373.02023068098],
[0.00000000023, 5.73072631591, 26729.31670331319],
[0.00000000026, 2.78110886808, 64901.25971792339],
[0.00000000028, 6.14191568069, 38813.35657634920],
[0.00000000025, 5.64677901976, 198489.93958638258],
[0.00000000022, 2.47489263310, 24864.08530079559],
[0.00000000023, 4.26682241390, 26222.01219115920],
[0.00000000024, 4.52962335246, 123758.29085447139],
[0.00000000023, 2.88962909157, 25953.79409198919],
[0.00000000028, 4.67408679361, 80382.47328510099],
[0.00000000021, 2.19925857864, 23866.04650697719],
[0.00000000025, 0.81737451667, 94329.77528619739],
[0.00000000021, 5.56863005528, 52712.61079524379],
[0.00000000021, 0.94657470314, 27684.08958385880],
[0.00000000023, 1.24923754668, 130446.62925487179],
[0.00000000022, 1.55521175306, 24998.19435038059],
[0.00000000024, 3.25930776298, 27669.86248985719],
[0.00000000021, 3.16657819785, 183674.70392120858],
[0.00000000020, 1.45970914613, 75615.25459924959],
[0.00000000028, 2.65124448902, 78366.80219894118],
[0.00000000021, 2.85719729554, 78160.61665050399],
[0.00000000022, 0.14164137879, 51528.79544983359],
[0.00000000022, 1.54435105177, 158746.17595363196],
[0.00000000019, 1.95606380894, 25344.91308104160],
[0.00000000019, 3.62491058376, 78039.36462902068],
[0.00000000019, 2.59809360557, 17893.62780836560],
[0.00000000019, 5.86487152937, 103917.90082841998],
[0.00000000019, 5.07516493363, 230239.17477710896],
[0.00000000023, 1.73809221823, 128220.75860368418],
[0.00000000018, 3.70453311537, 77726.90491262719],
[0.00000000020, 5.58951443277, 27177.61193276780],
[0.00000000019, 2.26298959398, 103932.12792242158],
[0.00000000018, 5.26103373994, 28736.35796704720],
[0.00000000018, 4.77075669731, 77101.23472031478],
[0.00000000019, 4.18613339997, 104819.57755665119],
[0.00000000019, 3.72825596269, 31415.37924995700],
[0.00000000018, 5.11985094325, 77307.42026875199],
[0.00000000019, 1.61447515906, 51653.22886505459],
[0.00000000022, 3.45569006244, 101011.00013959699],
[0.00000000017, 3.34823797519, 23919.14265929160],
[0.00000000017, 0.84289136609, 86143.79857806159],
[0.00000000018, 0.81997628030, 26073.67604757259],
[0.00000000020, 0.96632907921, 52609.51802102519],
[0.00000000016, 1.27839838984, 51868.24866217880],
[0.00000000020, 0.07187923898, 155887.52156313117],
[0.00000000018, 5.44524309894, 25508.21555457540],
[0.00000000016, 0.62722455150, 102659.44689679438],
[0.00000000016, 0.52102795891, 2221.85663459700],
[0.00000000017, 3.93009669878, 51852.30086649099],
[0.00000000016, 5.74180318220, 96357.08412427259],
[0.00000000019, 5.09029341511, 118828.96374949679],
[0.00000000017, 2.59947793429, 24448.83362438620],
[0.00000000016, 5.52244950928, 2199.08734328700],
[0.00000000015, 3.36667960581, 1911.19948321720],
[0.00000000021, 3.53223071778, 181659.72224941078],
[0.00000000019, 1.29524947399, 233681.74972207438],
[0.00000000016, 1.11236515889, 103498.41618454478],
[0.00000000020, 3.19274792861, 51969.62073471119],
[0.00000000017, 3.27645001526, 26312.24793727610],
[0.00000000016, 5.54159968247, 207114.15223730978],
[0.00000000015, 2.75565944373, 26709.64694241340],
[0.00000000015, 1.72732606714, 104344.98400739678],
[0.00000000016, 5.31828785394, 78153.50310350319],
[0.00000000016, 1.13565154505, 742.99006053260],
[0.00000000015, 6.19247438386, 130363.24963659538],
[0.00000000015, 1.16646378812, 92741.06060792258],
[0.00000000015, 4.39941321864, 25466.15934073500],
[0.00000000014, 1.03341872997, 78313.70604662679],
[0.00000000016, 1.77081422797, 27044.19229754480],
[0.00000000016, 1.77854347809, 26667.59072857300],
[0.00000000014, 2.39782698608, 103883.64757594238],
[0.00000000019, 6.27226219255, 25764.39772491679],
[0.00000000014, 1.89621592736, 37698.45509994840],
[0.00000000014, 5.86393829627, 81604.32185142238],
[0.00000000015, 2.41952075336, 27250.37784598199],
[0.00000000017, 5.62378615870, 51432.81622261579],
[0.00000000014, 0.57479381854, 8194.27533320860],
[0.00000000014, 2.01915873640, 156507.74908854539],
[0.00000000014, 4.00033644851, 187167.27548807819],
[0.00000000016, 3.05516572588, 22625.65843570900],
[0.00000000014, 0.41333257896, 76887.93562487679],
[0.00000000014, 3.81333935444, 28256.66362385679],
[0.00000000016, 5.63829774136, 209658.82487420218],
[0.00000000017, 2.79674558169, 323.50541665740],
[0.00000000015, 4.52292533775, 27726.97265876220],
[0.00000000017, 1.61686538851, 26198.10946279360],
[0.00000000017, 4.28628662370, 133882.09065283638],
[0.00000000013, 1.02936352404, 25867.49049913539],
[0.00000000014, 5.57651447296, 2008.55753915900],
[0.00000000014, 1.55161726953, 156314.11975400719],
[0.00000000017, 6.07989986315, 49953.94964855139],
[0.00000000015, 4.87081069542, 104358.24112519680],
[0.00000000013, 3.77228393975, 19.66976089979],
[0.00000000015, 5.41429733370, 208276.62694171758],
[0.00000000013, 1.15273910706, 949.17560896980],
[0.00000000017, 4.64614224273, 112231.70171963578],
[0.00000000015, 5.32485053265, 154408.65498906678],
[0.00000000013, 4.02426203972, 417406.45026518717],
[0.00000000013, 2.83441937048, 25169.97285559240],
[0.00000000016, 3.55004561005, 86457.98475793119],
[0.00000000014, 3.36717179008, 12546.48193908300],
[0.00000000013, 0.99900287294, 78338.49102328988],
[0.00000000012, 3.72935261349, 78786.28684281638],
[0.00000000013, 4.55769261775, 80596.90581759460],
[0.00000000013, 3.68794178346, 79315.97780791098],
[0.00000000014, 4.16918945992, 156547.08861034496],
[0.00000000012, 3.12295185577, 149288.74325784518],
[0.00000000012, 2.69822851627, 153.77881048480],
[0.00000000012, 4.38117483432, 27005.83342755599],
[0.00000000012, 0.19322533903, 27463.67694142000],
[0.00000000014, 4.15127082280, 29550.14784743939],
[0.00000000012, 2.80411772823, 102755.42612401219],
[0.00000000011, 5.82734448081, 259819.64948555276],
[0.00000000011, 2.40607503106, 169093.57054942798],
[0.00000000012, 0.49737747696, 102769.65321801379],
[0.00000000014, 5.69923121834, 76784.84285065818],
[0.00000000012, 5.56466695759, 26402.08932144380],
[0.00000000012, 1.48301102812, 78580.10129437919],
[0.00000000011, 5.15388067065, 77947.31755506598],
[0.00000000011, 1.64586759073, 25773.71696170459],
[0.00000000011, 2.45779334771, 34082.43158359840],
[0.00000000014, 2.00354520885, 846.08283475120],
[0.00000000013, 0.71980668578, 78413.27262185719],
[0.00000000011, 5.17906120193, 162810.49469943657],
[0.00000000011, 2.73596940194, 171292.65789271498],
[0.00000000011, 5.59141622457, 24203.00197815680],
[0.00000000011, 0.45608202666, 2111.65031337760],
[0.00000000010, 3.29404880642, 192828.60753723037],
[0.00000000010, 0.45857052500, 222224.97657418498],
[0.00000000013, 5.70684493376, 78213.71280281838],
[0.00000000011, 4.37474459591, 103718.82882698359],
[0.00000000011, 0.63918585951, 26118.23000257860],
[0.00000000013, 5.83092856998, 26411.40855823160],
[0.00000000010, 5.45367935399, 52483.36390411799],
[0.00000000010, 4.70344741563, 2125.87740737920],
[0.00000000011, 0.28816338163, 26057.57628056979],
[0.00000000010, 5.57764903480, 151199.94274106238],
[0.00000000011, 0.03362968403, 104991.50985261079],
[0.00000000010, 3.71565881071, 148532.89040742096],
[0.00000000013, 0.25119201649, 79330.20490191258],
[0.00000000010, 6.23763004539, 128106.31931499895],
[0.00000000011, 6.23138757669, 130285.73689738619],
[0.00000000013, 3.60703035316, 39629.32434406539],
[0.00000000011, 2.08623018213, 78683.19406859778],
[0.00000000011, 2.89478268807, 122444.98726584678],
[0.00000000011, 1.47224457688, 156520.30530244438],
[0.00000000012, 0.18308102701, 130593.29451835579],
[0.00000000009, 5.24611723729, 138319.60486120995],
[0.00000000009, 5.64920582852, 1265.56747862640],
[0.00000000009, 6.25551575071, 53906.92863608099],
[0.00000000011, 3.36985744471, 142871.55835826878],
[0.00000000009, 5.47085206361, 156531.30018480319],
[0.00000000009, 4.79150958411, 101703.15774082378],
[0.00000000009, 2.73233240797, 38.13303563780],
[0.00000000009, 5.91954900221, 62197.64356324779],
[0.00000000009, 4.73154570336, 78378.14871340781],
[0.00000000011, 0.80389582741, 3328.13565628019],
[0.00000000009, 6.25489842872, 91919.56991589899],
[0.00000000009, 5.87197255624, 199599.31813847595],
[0.00000000009, 0.76033087382, 156523.53751408719],
[0.00000000008, 0.63159267832, 80174.90890793978],
[0.00000000009, 5.02352759781, 229129.79622501558],
[0.00000000008, 2.63272452796, 25138.72753260440],
[0.00000000008, 0.59154768044, 156954.01704032118],
[0.00000000008, 3.95681232703, 120417.67842777158],
[0.00000000008, 3.46882638388, 77616.69859140778],
[0.00000000008, 0.20349823136, 113455.51956041438],
[0.00000000008, 0.21724719953, 13541.42120249119],
[0.00000000008, 1.77719128692, 26076.85744131030],
[0.00000000009, 6.21878690440, 189853.99758261938],
[0.00000000007, 5.88768146200, 51226.63067417859],
[0.00000000007, 0.61161547244, 158116.49174472898],
[0.00000000008, 2.05860519043, 78149.27013603736],
[0.00000000007, 0.09500184933, 90989.16285949759],
[0.00000000007, 0.56541937862, 25985.94062330859],
[0.00000000007, 0.73212945216, 78469.89497315978],
[0.00000000007, 0.44088896603, 104127.26777059489],
[0.00000000008, 5.86653927002, 104454.70534051539],
[0.00000000007, 0.70585294359, 52177.29075585669],
[0.00000000009, 1.96929942879, 1272.68102562720],
[0.00000000010, 2.72173324175, 104276.83096772949],
[0.00000000007, 5.16315798030, 26189.86565983980],
[0.00000000007, 5.17079740730, 179172.74704605396],
[0.00000000008, 5.26981396126, 48847.67062686820],
[0.00000000008, 0.19880797043, 1.48447270830],
[0.00000000007, 6.26371276121, 52174.32181044009],
[0.00000000008, 0.98956493578, 16703.06213349900],
[0.00000000007, 0.08448723866, 26098.94884183810],
[0.00000000008, 5.67030179581, 53029.00266490040],
[0.00000000007, 1.15333561308, 261988.40996783535],
[0.00000000007, 0.70724943755, 65717.22748563958],
[0.00000000007, 0.52800551865, 103814.80805420138],
[0.00000000008, 2.25202792521, 149756.70824819959],
[0.00000000007, 1.45586274187, 51841.95034237900],
[0.00000000007, 2.28027029168, 54374.89362643540],
[0.00000000007, 1.96795602434, 103395.32341032618],
[0.00000000007, 0.91100826202, 27972.80430499159],
[0.00000000007, 6.04142381509, 155475.15046625677],
[0.00000000008, 0.66187102958, 156740.71794488319],
[0.00000000007, 0.94700216301, 202420.14928260217],
[0.00000000008, 0.34397341638, 78339.97549599818],
[0.00000000008, 1.99164711035, 84944.93427812219],
[0.00000000006, 3.16647388859, 76041.85279012559],
[0.00000000007, 1.18920934641, 104984.39630560997],
[0.00000000007, 6.12812258419, 53867.97195265079],
[0.00000000007, 2.68832841048, 156377.85565231058],
[0.00000000007, 4.82261895829, 52286.01260436779],
[0.00000000006, 2.12110075547, 148.07872442630],
[0.00000000006, 3.05937939252, 151.04766984290],
[0.00000000007, 0.09315209734, 220025.88923089796],
[0.00000000008, 5.56250511075, 52509.66222391780],
[0.00000000006, 2.57622376266, 224577.84272795678],
[0.00000000007, 2.65171386195, 220.41264243880],
[0.00000000006, 2.00091220299, 102018.41617342478],
[0.00000000007, 0.86158158633, 50444.68393021580],
[0.00000000007, 1.61990482140, 103189.13786188899],
[0.00000000006, 2.68512587119, 77520.71936418998],
[0.00000000006, 4.82671721903, 154308.66174525839],
[0.00000000006, 2.40727316051, 78800.51393681798],
[0.00000000006, 5.66286619587, 234261.43730907318],
[0.00000000007, 1.38238075345, 106470.37642667518],
[0.00000000007, 4.62193558950, 81591.84508100279],
[0.00000000007, 0.26927581545, 127098.90328117118],
[0.00000000006, 0.92172283144, 57503.28239153120],
[0.00000000006, 5.39808870469, 130020.03106399579],
[0.00000000006, 2.52761413373, 52817.21984488739],
[0.00000000006, 0.06817978613, 53757.76563143139],
[0.00000000007, 3.13547312140, 155460.92337225519],
[0.00000000005, 2.17501494391, 209232.91609768818],
[0.00000000005, 2.16759656006, 104241.40624507738],
[0.00000000006, 2.68409858369, 130005.80396999417],
[0.00000000005, 1.58914721681, 50167.24874398939],
[0.00000000005, 1.01687539089, 55638.05098901359],
[0.00000000007, 1.31888655444, 149846.19399604558],
[0.00000000005, 2.48117306579, 9384.84100807520],
[0.00000000005, 3.70948655428, 266540.36346489414],
[0.00000000007, 5.71513815276, 70383.62027138360],
[0.00000000006, 4.55015130253, 51955.39364070959],
[0.00000000005, 3.51602263966, 102975.83876645098],
[0.00000000005, 3.69945557546, 39450.35284837340],
[0.00000000005, 3.98232048303, 53771.99272543299],
[0.00000000006, 1.01394190869, 77940.20400806518],
[0.00000000005, 2.50588363651, 102872.74599223239],
[0.00000000007, 3.01244944080, 50264.60679993120],
[0.00000000006, 0.45316437598, 50064.15596977079],
[0.00000000007, 6.03933985106, 1485.98012106520],
[0.00000000005, 1.35734487293, 53814.87580033639],
[0.00000000005, 4.43939776623, 51534.39272140940],
[0.00000000005, 2.29075654159, 61560.64729122359],
[0.00000000005, 0.07896316759, 78057.52387628538],
[0.00000000005, 0.95484155225, 130907.48069822539],
[0.00000000005, 1.56485117164, 53399.62412392700],
[0.00000000005, 4.55586232099, 52137.67324751059],
[0.00000000006, 4.34778590755, 156534.53239644598],
[0.00000000005, 3.72691818970, 128747.35003836859],
[0.00000000004, 0.56386565513, 189386.03259226495],
[0.00000000004, 2.67910077904, 107692.22499299659],
[0.00000000006, 6.10947724529, 104248.51979207818],
[0.00000000004, 3.99859010561, 104401.60918820098],
[0.00000000004, 0.51280078907, 54344.56676543099],
[0.00000000005, 4.19917665740, 129586.31932611899],
[0.00000000004, 5.91763059229, 52041.69723356339],
[0.00000000005, 3.18633834950, 181975.42470470538],
[0.00000000005, 0.99354989216, 1795.25844372100],
[0.00000000004, 6.20030341798, 209762.60706278277],
[0.00000000004, 4.57601261459, 184834.07909520617],
[0.00000000006, 4.81632935419, 77741.13200662879],
[0.00000000004, 2.32553366031, 53265.51507434200],
[0.00000000004, 4.83867556795, 52755.49387014719],
[0.00000000004, 0.47379105299, 105403.88094948517],
[0.00000000004, 2.62000942355, 50049.92887576919],
[0.00000000005, 1.01847704961, 52309.91533273340],
[0.00000000004, 5.12416312887, 52027.72755872209],
[0.00000000004, 0.26524339921, 50007.04580086580],
[0.00000000005, 0.30725353996, 207747.62539098498],
[0.00000000004, 4.93794243881, 63786.35824152260],
[0.00000000004, 4.51168915835, 77956.15180375299],
[0.00000000005, 1.16733741695, 27566.76971563859],
[0.00000000004, 3.77703754152, 104501.17576343138],
[0.00000000004, 5.44859511930, 129971.55071751658],
[0.00000000005, 5.22593130125, 51329.72344839720],
[0.00000000004, 1.64237114391, 130446.14426677099],
[0.00000000004, 1.28513103275, 112545.88789950538],
[0.00000000004, 3.50115780256, 76152.05911134499],
[0.00000000004, 4.79032272131, 130432.88714897096],
[0.00000000004, 5.62786746084, 43981.53094993980],
[0.00000000004, 4.12687975050, 52024.75861330549],
[0.00000000004, 5.13202982684, 735.87651353180],
[0.00000000004, 4.64327471216, 76255.15188556358],
[0.00000000004, 1.34781477964, 106684.80895916879],
[0.00000000004, 2.34997151211, 177287.84588263658],
], [
[0.00429151362, 3.50169780393, 26087.90314157420],
[0.00146233668, 3.14159265359, 0.00000000000],
[0.00022675295, 0.01515366880, 52175.80628314840],
[0.00010894981, 0.48540174006, 78263.70942472259],
[0.00006353462, 3.42943919982, 104351.61256629678],
[0.00002495743, 0.16051210665, 130439.51570787099],
[0.00000859585, 3.18452433647, 156527.41884944518],
[0.00000277503, 6.21020774184, 182615.32199101939],
[0.00000086233, 2.95244391822, 208703.22513259358],
[0.00000026133, 5.97708962692, 234791.12827416777],
[0.00000027696, 0.29068938889, 27197.28169366760],
[0.00000012831, 3.37744320558, 53285.18483524180],
[0.00000012720, 0.53792661684, 24978.52458948080],
[0.00000007781, 2.71768609268, 260879.03141574195],
[0.00000007527, 3.58305121268, 51066.42773105500],
[0.00000006183, 2.92383205004, 31749.23519072640],
[0.00000005453, 1.97318763801, 51116.42435295920],
[0.00000003394, 0.34761695275, 77154.33087262919],
[0.00000003481, 0.10739761667, 79373.08797681599],
[0.00000002932, 5.95430013169, 57837.13833230060],
[0.00000002742, 0.98758439378, 25028.52121138500],
[0.00000002126, 4.16352818018, 47623.85278608960],
[0.00000002286, 5.74036496396, 286966.93455731616],
[0.00000002380, 4.00213666550, 21535.94964451540],
[0.00000001651, 4.43606584681, 27043.50288318280],
[0.00000001523, 1.97926797181, 5661.33204915220],
[0.00000001518, 5.01636479848, 77204.32749453338],
[0.00000001398, 0.66375029294, 20426.57109242200],
[0.00000001345, 3.39193943388, 103242.23401420339],
[0.00000001297, 5.34251327744, 37410.56723987860],
[0.00000001076, 0.95624460335, 50586.73338786459],
[0.00000001050, 3.00944151152, 26107.57290247399],
[0.00000000918, 1.89988871166, 1059.38193018920],
[0.00000001063, 1.28486292967, 53131.40602475700],
[0.00000000905, 3.34776562702, 25558.21217647960],
[0.00000000929, 4.81159652409, 51646.11531805379],
[0.00000000782, 6.08817839271, 529.69096509460],
[0.00000000783, 1.50962699410, 41962.52073693740],
[0.00000000794, 2.16868396183, 63498.47038145279],
[0.00000000731, 0.92148918837, 73711.75592766379],
[0.00000000755, 4.10910637390, 26068.23338067440],
[0.00000000703, 2.22466530621, 10213.28554621100],
[0.00000000922, 2.30268247092, 1109.37855209340],
[0.00000000739, 3.05842748947, 105460.99111839019],
[0.00000000681, 1.40695567526, 51749.20809227239],
[0.00000000841, 5.93206787810, 26084.02180621620],
[0.00000000616, 5.95368982430, 39609.65458316560],
[0.00000000610, 2.96796433797, 25132.30339996560],
[0.00000000721, 1.16472614778, 46514.47423399620],
[0.00000000638, 1.16941585214, 26091.78447693220],
[0.00000000633, 3.07427024064, 30639.85663863300],
[0.00000000665, 2.47994200156, 313054.83769889036],
[0.00000000669, 4.10310179631, 72602.37737557039],
[0.00000000495, 0.14776350456, 129330.13715577759],
[0.00000000474, 2.61466823958, 32858.61374281979],
[0.00000000470, 5.04436148211, 13521.75144159140],
[0.00000000494, 0.07430556450, 28306.66024576099],
[0.00000000459, 5.81611579004, 51220.20654153979],
[0.00000000467, 5.56622114735, 4551.95349705880],
[0.00000000433, 2.10197184422, 24498.83024629040],
[0.00000000430, 3.91046377635, 76674.63652943878],
[0.00000000436, 1.46213785727, 43071.89928903080],
[0.00000000383, 6.05537830853, 52195.47604404819],
[0.00000000335, 0.55996605330, 23869.14603738740],
[0.00000000369, 4.43217995206, 22645.32819660879],
[0.00000000329, 2.59508442112, 65697.55772473979],
[0.00000000346, 2.03170085305, 27147.28507176339],
[0.00000000424, 0.29775934661, 1589.07289528380],
[0.00000000378, 5.09810178577, 53235.18821333759],
[0.00000000308, 3.30225015955, 54394.56338733519],
[0.00000000314, 2.40932519602, 83925.04147387479],
[0.00000000364, 5.87784809361, 58946.51688439399],
[0.00000000352, 0.87939481900, 52156.13652224860],
[0.00000000352, 5.92675293084, 25661.30495069820],
[0.00000000310, 2.69873876637, 52171.92494779040],
[0.00000000345, 0.84406679212, 98690.28051714458],
[0.00000000358, 6.14890038263, 56727.75978020720],
[0.00000000248, 2.34396840060, 51535.90899683439],
[0.00000000286, 2.39648280163, 19804.82729158280],
[0.00000000338, 1.55189200325, 52705.49724824299],
[0.00000000239, 3.35169081927, 52168.69273614759],
[0.00000000234, 2.51108507067, 77308.10968311399],
[0.00000000229, 5.16737598091, 36301.18868778519],
[0.00000000245, 4.26996032400, 19317.19254032860],
[0.00000000210, 3.16281965425, 29530.47808653960],
[0.00000000212, 5.33861521612, 15874.61759536320],
[0.00000000291, 4.22929240183, 52179.68761850640],
[0.00000000263, 4.64138649646, 69159.80243060499],
[0.00000000235, 5.08060846802, 59414.48187474840],
[0.00000000251, 1.90047504790, 14765.23904326980],
[0.00000000253, 4.21581970504, 79219.30916633119],
[0.00000000194, 5.05904557922, 51109.31080595839],
[0.00000000188, 3.90664116889, 48733.23133818299],
[0.00000000207, 2.89949362192, 7.11354700080],
[0.00000000179, 4.43018837604, 77837.11123384659],
[0.00000000223, 2.96569885227, 110012.94461544899],
[0.00000000176, 5.15204624857, 89586.37352302698],
[0.00000000215, 4.50903357312, 78793.40038981718],
[0.00000000173, 3.18496771460, 155418.04029735178],
[0.00000000205, 1.89888752382, 79323.09135491178],
[0.00000000175, 2.91183047213, 82815.66292178139],
[0.00000000165, 0.49123694380, 25035.63475838580],
[0.00000000183, 1.42148796836, 77734.01845962799],
[0.00000000158, 3.63030783882, 49957.04917896160],
[0.00000000201, 4.78711687782, 40853.14218484400],
[0.00000000157, 3.02451795123, 52182.91983014920],
[0.00000000192, 5.50218209050, 339142.74084046457],
[0.00000000145, 3.39803928124, 45892.73043315699],
[0.00000000140, 2.64826898848, 16983.99614745660],
[0.00000000190, 3.05043439775, 27676.97603685800],
[0.00000000169, 3.40273824751, 25874.60404613620],
[0.00000000148, 3.87588943419, 124778.18365871879],
[0.00000000134, 0.94930028730, 25021.40766438420],
[0.00000000174, 5.88326736492, 136100.84775702319],
[0.00000000138, 2.34393108627, 1052.26838318840],
[0.00000000163, 6.05484015332, 26080.78959457339],
[0.00000000142, 3.07209103150, 3442.57494496540],
[0.00000000137, 2.10984857727, 426.59819087600],
[0.00000000126, 1.89432609260, 1066.49547719000],
[0.00000000122, 1.04298624291, 45405.09568190280],
[0.00000000135, 4.66414339767, 25448.00585526019],
[0.00000000115, 2.81365851520, 78283.37918562238],
[0.00000000114, 4.47315411813, 68050.42387851159],
[0.00000000134, 5.35393682799, 213.29909543800],
[0.00000000125, 1.61827845372, 129380.13377768178],
[0.00000000158, 5.53788931475, 9103.90699411760],
[0.00000000116, 0.50075235780, 102762.53967101299],
[0.00000000136, 0.24559658100, 50057.04242277000],
[0.00000000124, 2.20590858584, 33326.57873317420],
[0.00000000106, 6.15493608726, 11322.66409830440],
[0.00000000123, 4.43265735200, 639.89728631400],
[0.00000000137, 3.93191153638, 78244.03966382280],
[0.00000000138, 4.46503235172, 51123.53789995999],
[0.00000000119, 3.64440622006, 26617.59410666880],
[0.00000000099, 6.18313188027, 55618.38122811380],
[0.00000000101, 5.52733987069, 103396.01282468818],
[0.00000000107, 4.79994153405, 6770.71060124560],
[0.00000000096, 0.01853371395, 80482.46652890938],
[0.00000000115, 1.57423656512, 66941.04532641819],
[0.00000000111, 1.00588061631, 78267.59076008058],
[0.00000000121, 5.90839328752, 26095.01668857500],
[0.00000000095, 5.74549458142, 78259.82808936459],
[0.00000000100, 1.90676485528, 103292.23063610759],
[0.00000000107, 5.73194510449, 131548.89425996438],
[0.00000000098, 5.49064814924, 77623.81213840858],
[0.00000000112, 0.87682090108, 74821.13447975718],
[0.00000000090, 5.82373560803, 955.59974160860],
[0.00000000093, 0.15279056716, 78256.59587772179],
[0.00000000100, 1.21759895953, 104881.30353139139],
[0.00000000087, 4.20722631983, 12566.15169998280],
[0.00000000088, 5.00176994115, 38519.94579197200],
[0.00000000086, 1.23375034376, 26301.20223701220],
[0.00000000085, 1.88852891739, 77197.21394753258],
[0.00000000082, 3.75652571856, 99799.65906923798],
[0.00000000089, 4.95684147986, 105410.99449648599],
[0.00000000096, 5.10490831351, 52389.10537858640],
[0.00000000075, 2.50722139185, 2218.75710418680],
[0.00000000093, 6.00229475799, 53764.87917843220],
[0.00000000073, 6.11603054445, 78270.82297172339],
[0.00000000091, 4.67762120545, 155468.03691925599],
[0.00000000080, 1.98564256640, 7238.67559160000],
[0.00000000089, 1.62820970873, 6283.07584999140],
[0.00000000073, 5.93728826025, 108903.56606335558],
[0.00000000087, 2.61787684648, 162188.75089859738],
[0.00000000092, 2.55298032665, 85034.42002596818],
[0.00000000076, 4.44230028342, 38654.05484155699],
[0.00000000070, 2.07147354168, 25934.12433108940],
[0.00000000078, 1.79664677749, 23969.13928119580],
[0.00000000068, 2.15267768357, 64607.84893354619],
[0.00000000069, 1.37976390686, 77211.44104153418],
[0.00000000080, 0.75440631101, 2118.76386037840],
[0.00000000060, 5.95179539253, 18849.22754997420],
[0.00000000058, 0.98126270514, 51962.50718771040],
[0.00000000057, 0.63495768344, 150866.08680029298],
[0.00000000063, 0.40577774917, 76044.95232053580],
[0.00000000061, 3.20728040856, 76144.94556434419],
[0.00000000053, 1.34424134476, 51742.09454527159],
[0.00000000052, 4.11944860444, 71492.99882347698],
[0.00000000054, 2.23964604878, 44937.13069154840],
[0.00000000064, 1.19785741966, 64741.95798313119],
[0.00000000058, 6.22316473811, 181505.94343892598],
[0.00000000060, 2.12727479557, 88476.99497093359],
[0.00000000049, 1.76854754615, 13655.86049117640],
[0.00000000049, 1.27506119902, 26727.80042788820],
[0.00000000048, 2.04581990152, 78477.00852016058],
[0.00000000050, 4.62948267835, 93028.94846799239],
[0.00000000055, 5.47526225139, 62389.09182935939],
[0.00000000047, 4.99113735496, 27154.39861876420],
[0.00000000055, 4.79762177368, 94138.32702008578],
[0.00000000051, 5.56459812422, 52602.40447402440],
[0.00000000055, 1.20462687751, 95247.70557217918],
[0.00000000050, 2.21530140501, 365230.64398203876],
[0.00000000049, 0.68636780387, 104331.94280539699],
[0.00000000047, 4.30403626352, 23754.70674870219],
[0.00000000042, 3.32657201754, 25654.19140369739],
[0.00000000051, 1.08082309375, 25619.93815121980],
[0.00000000047, 2.79966035046, 26514.50133245020],
[0.00000000040, 2.91932668980, 81706.28436968799],
[0.00000000040, 4.65660434525, 129909.82474277639],
[0.00000000041, 4.21875403274, 130969.20667296558],
[0.00000000050, 1.46644208786, 120226.23016165999],
[0.00000000047, 3.77053215629, 25973.46385288896],
[0.00000000047, 2.82867670887, 25668.41849769900],
[0.00000000046, 4.14427477722, 125887.56221081219],
[0.00000000039, 4.06156914485, 104355.49390165479],
[0.00000000037, 3.22245380356, 51322.60990139639],
[0.00000000039, 2.26439106521, 129483.91596626239],
[0.00000000040, 0.54598734169, 105307.21230790539],
[0.00000000035, 5.53895897820, 433.71173787680],
[0.00000000038, 6.05329467990, 419.48464387520],
[0.00000000039, 2.72082598885, 79852.78232000639],
[0.00000000035, 1.72937228501, 131498.89763806018],
[0.00000000034, 0.83611265968, 12432.04265039780],
[0.00000000032, 4.45254278754, 50579.61984086379],
[0.00000000042, 1.41457022130, 181555.94006083018],
[0.00000000032, 4.73349986920, 52026.24308601380],
[0.00000000036, 5.60766535694, 188276.65404017158],
[0.00000000033, 3.98525990131, 78050.41032928458],
[0.00000000032, 5.86059322955, 104371.28232719658],
[0.00000000040, 5.45287901295, 27140.17152476259],
[0.00000000031, 5.17982917253, 71025.03383312259],
[0.00000000039, 3.34206786809, 26202.34243025941],
[0.00000000029, 1.94010215318, 103821.92160120218],
[0.00000000036, 0.65969730203, 51756.32163927320],
[0.00000000030, 0.82864967511, 46848.33017476560],
[0.00000000038, 0.80809536333, 151975.46535238638],
[0.00000000029, 2.89227792530, 104358.72611329758],
[0.00000000029, 4.49728060011, 103299.34418310839],
[0.00000000035, 1.48121158024, 85502.38501632259],
[0.00000000028, 5.48224379273, 91785.46086631398],
[0.00000000030, 3.11318420566, 106570.36967048359],
[0.00000000034, 4.26548581082, 90829.86112470538],
[0.00000000031, 5.67743476614, 117873.36400788819],
[0.00000000028, 4.97598935775, 103285.11708910679],
[0.00000000033, 5.18111128318, 114564.89811250778],
[0.00000000027, 0.88054842818, 157636.79740153858],
[0.00000000026, 2.57652351573, 134991.46920492979],
[0.00000000029, 2.64144900778, 26137.89976347840],
[0.00000000028, 3.23650761988, 128850.44281258718],
[0.00000000030, 6.03255187776, 32370.97899156560],
[0.00000000029, 3.23415692694, 104344.49901929598],
[0.00000000032, 3.21019810469, 28421.09953444620],
[0.00000000024, 2.52484264487, 1596.18644228460],
[0.00000000024, 0.27171495756, 24491.71669928959],
[0.00000000026, 1.20902208843, 44181.27784112419],
[0.00000000027, 5.71639245109, 111122.32316754239],
[0.00000000031, 3.68314656803, 28206.66700195260],
[0.00000000030, 2.36500429653, 103711.71527998279],
[0.00000000022, 4.47547965260, 77829.99768684579],
[0.00000000022, 5.93080138405, 98068.53671630539],
[0.00000000021, 4.45887879737, 52815.70356946240],
[0.00000000022, 1.51276188597, 35191.81013569180],
[0.00000000025, 3.67349275753, 853.19638175200],
[0.00000000021, 5.21045664362, 104564.91166173479],
[0.00000000023, 3.52400873624, 100909.03762133139],
[0.00000000021, 0.91705070968, 97580.90196505119],
[0.00000000021, 3.93681460045, 25455.11940226100],
[0.00000000020, 2.51210823023, 104347.73123093879],
[0.00000000027, 2.35592427305, 78690.30761559859],
[0.00000000020, 5.09828683951, 52099.54021187280],
[0.00000000019, 3.37799607043, 45494.58142974879],
[0.00000000021, 1.47540794459, 115674.27666460119],
[0.00000000020, 1.17802900406, 155997.72788435058],
[0.00000000025, 4.46628547605, 146314.13330323418],
[0.00000000023, 2.29934592297, 33967.99229491319],
[0.00000000020, 0.67974525638, 24505.94379329119],
[0.00000000020, 5.32443861216, 25234.70675982219],
[0.00000000018, 4.83011056299, 50593.84693486539],
[0.00000000020, 2.19515561332, 51639.00177105299],
[0.00000000020, 4.54362105039, 26037.90651966999],
[0.00000000018, 3.66945372389, 176953.98994186718],
[0.00000000022, 2.36457126914, 143961.26714946238],
[0.00000000020, 1.91605933726, 53242.30176033840],
[0.00000000017, 3.65797302958, 25938.33994443960],
[0.00000000017, 4.72356636284, 39743.76363275060],
[0.00000000017, 4.63385029370, 70269.18098269838],
[0.00000000023, 3.47296935942, 102132.85546210999],
[0.00000000018, 3.89075237232, 77844.22478084739],
[0.00000000016, 1.39550514982, 119116.85160956658],
[0.00000000017, 3.19413997784, 2333.19639287200],
[0.00000000018, 0.10505670252, 52290.24557183361],
[0.00000000015, 5.66501892458, 7994.52844202420],
[0.00000000017, 5.59546671313, 60055.89543648739],
[0.00000000015, 3.35297565546, 58458.88213313979],
[0.00000000019, 1.88696722328, 1581.95934828300],
[0.00000000016, 3.51339563149, 26094.53170047421],
[0.00000000015, 5.87796844640, 105940.68546158058],
[0.00000000014, 4.90677373859, 632.78373931320],
[0.00000000017, 2.94915136654, 18093.37469954999],
[0.00000000016, 3.30923893089, 26507.38778544939],
[0.00000000017, 2.79032831551, 124156.43985787958],
[0.00000000017, 2.32026007183, 53228.07466633679],
[0.00000000015, 1.27735280723, 103925.01437542078],
[0.00000000014, 0.47578456087, 104138.31347085879],
[0.00000000014, 4.33486658309, 18207.81398823521],
[0.00000000014, 6.25912081869, 102232.84870591838],
[0.00000000016, 5.19489448771, 52022.02747266360],
[0.00000000015, 3.36079341013, 26241.68195205900],
[0.00000000016, 0.62153007569, 71980.63357473118],
[0.00000000016, 0.34240403974, 26081.27458267419],
[0.00000000015, 4.43868814661, 207643.84320240439],
[0.00000000017, 3.44704905407, 183724.70054311278],
[0.00000000016, 0.08608453345, 77410.51304297059],
[0.00000000013, 4.45469253351, 90695.75207512038],
[0.00000000014, 5.26281612633, 391318.54712361297],
[0.00000000013, 2.28140033187, 26521.61487945100],
[0.00000000013, 4.75564434373, 536.80451209540],
[0.00000000013, 3.72895039092, 130419.84594697120],
[0.00000000015, 6.26388997196, 54509.00267602040],
[0.00000000014, 1.32802909705, 20760.42703319140],
[0.00000000012, 0.96182853080, 157057.10981453978],
[0.00000000017, 3.00168933222, 207593.84658050018],
[0.00000000016, 0.54167157981, 52061.36699446317],
[0.00000000016, 3.76004077423, 178063.36849396059],
[0.00000000012, 0.50356687265, 5327.47610838280],
[0.00000000014, 0.65739903621, 84546.78527471398],
[0.00000000014, 2.64166191335, 42153.96900304900],
[0.00000000011, 1.87375624710, 97112.93697469679],
[0.00000000012, 5.28144640817, 26610.48055966799],
[0.00000000012, 1.02715379165, 130012.91751699499],
[0.00000000011, 4.76973198116, 157586.80077963437],
[0.00000000011, 4.03645617358, 26011.63707029860],
[0.00000000012, 1.03774094920, 116917.76426627958],
[0.00000000011, 2.34762914711, 214364.55718174578],
[0.00000000013, 5.96105286469, 49527.35145767539],
[0.00000000013, 0.38784055589, 54294.57014352679],
[0.00000000011, 0.80279403389, 130443.39704322898],
[0.00000000012, 1.91910219792, 140652.80125408198],
[0.00000000011, 4.82050468552, 647.01083331480],
[0.00000000012, 3.95784286024, 72936.23331633979],
[0.00000000010, 2.38363926963, 52698.38370124219],
[0.00000000012, 5.21962000846, 25551.09862947879],
[0.00000000011, 1.24041943634, 51543.02254383520],
[0.00000000010, 1.23610986711, 76667.52298243798],
[0.00000000011, 5.27116774881, 155571.81910783658],
[0.00000000011, 5.98419309923, 107794.18751126219],
[0.00000000010, 0.55390559777, 26941.09952332620],
[0.00000000010, 1.49161844344, 52329.58509363319],
[0.00000000011, 4.68946178137, 26190.99591579279],
[0.00000000009, 5.63092803389, 27684.08958385880],
[0.00000000011, 6.09445403088, 26555.86813192860],
[0.00000000010, 0.09698975387, 29416.03879785439],
[0.00000000010, 0.72339727974, 22759.76748529401],
[0.00000000009, 1.96066446481, 51528.79544983359],
[0.00000000009, 4.28124553384, 121335.60871375339],
[0.00000000008, 4.26127907796, 182085.63102592478],
[0.00000000009, 3.34775259107, 22747.29071487440],
[0.00000000008, 1.25238578145, 129387.24732468258],
[0.00000000008, 3.86388656969, 24864.08530079559],
[0.00000000010, 1.34737181255, 2648.45482547300],
[0.00000000008, 5.72234642822, 161079.37234650398],
[0.00000000009, 5.45351693096, 104778.21075717278],
[0.00000000011, 2.85637796333, 52643.77127350280],
[0.00000000008, 3.27339488052, 27311.72098235281],
[0.00000000010, 1.31510855953, 52125.80966124419],
[0.00000000009, 1.17621493154, 172402.03644480839],
[0.00000000008, 2.43297081646, 131395.11544947959],
[0.00000000009, 0.46231104626, 26624.70765366959],
[0.00000000007, 4.93485551094, 48835.19385644859],
[0.00000000007, 5.92438953036, 130446.62925487179],
[0.00000000007, 5.15107638670, 149.56319713460],
[0.00000000008, 0.00476652316, 209812.60368468695],
[0.00000000008, 5.06558822410, 61279.71327726600],
[0.00000000009, 0.56618846666, 522.57741809380],
[0.00000000007, 2.63009300708, 130459.18546877075],
[0.00000000008, 2.08959717350, 25565.32572348040],
[0.00000000009, 5.37562306264, 170049.17029103659],
[0.00000000008, 4.05554156200, 156100.82065856918],
[0.00000000007, 5.58541192959, 129799.61842155698],
[0.00000000007, 1.76385898252, 129373.02023068098],
[0.00000000006, 4.86066957244, 7880.08915333899],
[0.00000000008, 4.47849277972, 10021.83728009940],
[0.00000000006, 5.30561035943, 77726.90491262719],
[0.00000000006, 1.27631388714, 103917.90082841998],
[0.00000000006, 4.61189217781, 157483.01859105378],
[0.00000000006, 3.96170038596, 123668.80510662538],
[0.00000000006, 1.33523648266, 78903.60671103658],
[0.00000000006, 0.55702386570, 204151.27163553478],
[0.00000000005, 1.55562437906, 26294.08869001139],
[0.00000000006, 2.05839183005, 130652.81480330898],
[0.00000000005, 5.58094407959, 130435.63437251298],
[0.00000000005, 1.47580092631, 78114.14622758799],
[0.00000000006, 4.10195998301, 51707.84129279399],
[0.00000000005, 5.42356096080, 3340.61242669980],
[0.00000000005, 0.71252148739, 103932.12792242158],
[0.00000000005, 3.31021043385, 111590.28815789679],
[0.00000000005, 5.18242316734, 13362.44970679920],
[0.00000000007, 0.02670007799, 130432.40216087017],
[0.00000000006, 5.64961767520, 52225.80290505260],
[0.00000000006, 0.24412111381, 128220.75860368418],
[0.00000000005, 4.45623339313, 145204.75475114079],
[0.00000000006, 5.59932602145, 154938.34595416138],
[0.00000000005, 0.44843767302, 203041.89308344138],
[0.00000000006, 0.61515143577, 126996.94076290558],
[0.00000000006, 3.76267562514, 110634.68841628819],
[0.00000000005, 3.87958020217, 25440.89230825939],
[0.00000000006, 6.12898547290, 132658.27281205778],
[0.00000000006, 1.78589858446, 76681.75007643958],
[0.00000000006, 3.31942003464, 25881.71759313700],
[0.00000000005, 4.83610476376, 78417.48823520739],
[0.00000000005, 1.62128192664, 65831.66677432480],
[0.00000000006, 5.79832326006, 150244.34299945379],
[0.00000000004, 4.90210493212, 123200.84011627098],
[0.00000000004, 0.04822157393, 71582.48457132299],
[0.00000000004, 1.25993980368, 233731.74634397858],
[0.00000000004, 4.09490053686, 143005.66740785378],
[0.00000000004, 0.60263195052, 6681.22485339960],
[0.00000000005, 3.53504145685, 130226.21661243298],
[0.00000000004, 2.52659732174, 132028.58860315479],
[0.00000000004, 5.09490146272, 76.26607127560],
[0.00000000004, 1.41880070183, 31415.37924995700],
[0.00000000005, 5.67226040777, 68241.87214462319],
[0.00000000006, 6.07125845396, 1478.86657406440],
[0.00000000004, 2.90387262796, 128320.75184749259],
[0.00000000004, 3.16756186361, 78378.14871340781],
[0.00000000004, 0.32589274840, 52595.29092702359],
[0.00000000005, 1.78096081490, 116783.65521669458],
[0.00000000004, 4.99518857973, 166740.70439565618],
[0.00000000005, 4.90494970331, 79330.20490191258],
[0.00000000004, 5.23437839920, 206.18554843720],
[0.00000000004, 2.64302747396, 75615.25459924959],
[0.00000000004, 0.81407144130, 75930.51303185058],
[0.00000000004, 0.53239895977, 156507.74908854539],
[0.00000000004, 4.27504704332, 956.28915597060],
[0.00000000004, 3.01307667234, 80596.90581759460],
[0.00000000003, 4.15170143655, 25867.49049913539],
[0.00000000003, 4.02158764895, 52712.61079524379],
[0.00000000004, 5.97032773544, 78731.67441507700],
[0.00000000004, 5.13753166239, 137678.19129947099],
[0.00000000003, 5.38378225170, 79315.97780791098],
[0.00000000003, 4.90402266218, 77630.92568540938],
[0.00000000004, 3.35681065144, 80382.47328510099],
[0.00000000004, 3.34724303278, 55503.94193942859],
[0.00000000003, 4.39477038963, 102755.42612401219],
[0.00000000004, 2.19880101386, 137210.22630911658],
[0.00000000003, 1.92191274920, 87367.61641884019],
[0.00000000004, 3.62687237484, 78149.27013603736],
[0.00000000003, 5.34278285975, 77616.69859140778],
[0.00000000003, 4.04927793779, 183145.01295611398],
[0.00000000003, 2.33740424416, 86143.79857806159],
[0.00000000003, 0.29051326311, 66653.15746634839],
[0.00000000004, 3.19530187424, 103498.41618454478],
[0.00000000003, 1.83670250940, 78187.44335344699],
[0.00000000004, 6.08402133763, 233681.74972207438],
[0.00000000003, 5.44799723236, 52609.51802102519],
[0.00000000003, 3.88568044923, 156531.30018480319],
[0.00000000003, 1.56467339056, 183674.70392120858],
[0.00000000003, 2.37223694472, 11610.55195837420],
[0.00000000004, 2.36349454401, 3328.13565628019],
[0.00000000003, 2.21015804942, 130866.11389874699],
[0.00000000003, 1.00111385284, 12546.48193908300],
[0.00000000003, 5.04736992413, 167850.08294774959],
[0.00000000004, 2.74224804458, 133882.09065283638],
[0.00000000003, 6.04124419781, 16066.06586147480],
[0.00000000003, 2.00390511344, 25984.81036735560],
[0.00000000003, 3.58451231520, 19406.67828817460],
[0.00000000003, 5.58865591583, 52381.99183158559],
[0.00000000003, 5.49839860031, 78786.28684281638],
[0.00000000003, 2.35251877810, 50483.64061364600],
[0.00000000003, 2.23638545873, 417406.45026518717],
[0.00000000003, 0.89820153238, 182188.72380014337],
[0.00000000003, 2.18659555288, 196137.07343261078],
[0.00000000003, 1.23213629886, 183570.92173262799],
[0.00000000003, 0.65362427623, 1162.47470440780],
[0.00000000003, 2.37265737062, 141762.17980617538],
[0.00000000003, 2.37167138660, 103.09277421860],
[0.00000000003, 3.43071585489, 51219.51712717779],
[0.00000000002, 5.43620933898, 240452.46032331996],
[0.00000000002, 4.79210725186, 64901.25971792339],
[0.00000000003, 0.58543714627, 136722.59155786238],
[0.00000000002, 3.65273296014, 53029.00266490040],
[0.00000000003, 1.40305085463, 52278.89905736699],
[0.00000000003, 2.91888451759, 235900.50682626116],
[0.00000000002, 5.24862580724, 32769.12799497380],
[0.00000000003, 0.92825301327, 29428.51556827400],
[0.00000000002, 1.28026650043, 96357.08412427259],
[0.00000000003, 3.47745075021, 49842.60989027639],
[0.00000000003, 1.27522510736, 44295.71712980940],
[0.00000000003, 2.06356044829, 181659.72224941078],
[0.00000000002, 1.82577636633, 181026.24909573558],
[0.00000000002, 3.73653346143, 48847.67062686820],
[0.00000000002, 4.29258038531, 198489.93958638258],
[0.00000000003, 1.30423082531, 26237.46633870879],
[0.00000000002, 5.62405074860, 112231.70171963578],
[0.00000000003, 4.34969907580, 78213.71280281838],
[0.00000000002, 4.40950391344, 155475.15046625677],
[0.00000000002, 5.10859116787, 27669.86248985719],
[0.00000000002, 2.40342983563, 53771.99272543299],
[0.00000000002, 1.76898437388, 104505.39137678158],
[0.00000000002, 1.13321786137, 208173.53416749898],
[0.00000000003, 4.95012664609, 102769.65321801379],
[0.00000000002, 2.37593594042, 51951.46148744649],
[0.00000000003, 0.65556179120, 1692.16566950240],
[0.00000000002, 1.65727778641, 163766.09444104518],
], [
[0.00011830934, 4.79065585784, 26087.90314157420],
[0.00001913516, 0.00000000000, 0.00000000000],
[0.00001044801, 1.21216540536, 52175.80628314840],
[0.00000266213, 4.43418336532, 78263.70942472259],
[0.00000170280, 1.62255638714, 104351.61256629678],
[0.00000096300, 4.80023692017, 130439.51570787099],
[0.00000044692, 1.60758267772, 156527.41884944518],
[0.00000018316, 4.66904655377, 182615.32199101939],
[0.00000006927, 1.43404888930, 208703.22513259358],
[0.00000002479, 4.47495202955, 234791.12827416777],
[0.00000001739, 1.83080039600, 27197.28169366760],
[0.00000000852, 1.22749255198, 260879.03141574195],
[0.00000000641, 4.87358642253, 53285.18483524180],
[0.00000000301, 1.96098924430, 51066.42773105500],
[0.00000000306, 5.03912693671, 24978.52458948080],
[0.00000000284, 4.25874901943, 286966.93455731616],
[0.00000000235, 3.14549432371, 51116.42435295920],
[0.00000000232, 4.22847849119, 31749.23519072640],
[0.00000000186, 5.05207772442, 77154.33087262919],
[0.00000000143, 5.71074961492, 21535.94964451540],
[0.00000000114, 5.62232460770, 27043.50288318280],
[0.00000000123, 1.51066137419, 79373.08797681599],
[0.00000000093, 1.83776226489, 103242.23401420339],
[0.00000000081, 0.85802178989, 57837.13833230060],
[0.00000000079, 5.50027152752, 47623.85278608960],
[0.00000000093, 1.01040170383, 313054.83769889036],
[0.00000000058, 2.35944147105, 53131.40602475700],
[0.00000000074, 2.28645155343, 50586.73338786459],
[0.00000000049, 1.78193753560, 28306.66024576099],
[0.00000000058, 5.88387132512, 77204.32749453338],
[0.00000000060, 0.54679388547, 37410.56723987860],
[0.00000000046, 5.77182292982, 529.69096509460],
[0.00000000052, 3.58488737294, 25558.21217647960],
[0.00000000061, 1.64891174657, 20426.57109242200],
[0.00000000043, 6.15538236294, 51646.11531805379],
[0.00000000042, 4.89875940528, 129330.13715577759],
[0.00000000036, 5.61094806248, 22645.32819660879],
[0.00000000033, 4.34189175312, 32858.61374281979],
[0.00000000037, 4.50512068847, 26107.57290247399],
[0.00000000032, 1.99466664427, 25132.30339996560],
[0.00000000030, 0.76607738630, 5661.33204915220],
[0.00000000027, 4.87180838160, 54394.56338733519],
[0.00000000029, 5.66168505554, 26068.23338067440],
[0.00000000025, 3.31115218239, 1059.38193018920],
[0.00000000029, 2.70280425915, 41962.52073693740],
[0.00000000029, 3.56940606994, 63498.47038145279],
[0.00000000029, 4.01947170286, 339142.74084046457],
[0.00000000028, 0.80200569507, 39609.65458316560],
[0.00000000023, 5.30820497885, 23869.14603738740],
[0.00000000024, 4.86369445330, 46514.47423399620],
[0.00000000027, 3.32081057071, 10213.28554621100],
[0.00000000030, 1.15631768661, 26084.02180621620],
[0.00000000024, 2.71284750937, 26091.78447693220],
[0.00000000021, 5.85119251529, 25874.60404613620],
[0.00000000026, 3.11971794265, 43071.89928903080],
[0.00000000023, 1.14258266850, 58946.51688439399],
[0.00000000021, 4.78965226125, 51220.20654153979],
[0.00000000025, 5.17153436907, 76674.63652943878],
[0.00000000020, 6.05659966832, 25028.52121138500],
[0.00000000017, 4.06375348164, 51535.90899683439],
[0.00000000019, 2.26589689692, 72602.37737557039],
[0.00000000019, 2.02802084878, 73711.75592766379],
[0.00000000020, 2.44092663198, 51749.20809227239],
[0.00000000017, 1.67702029587, 155418.04029735178],
[0.00000000018, 2.11191340126, 26617.59410666880],
[0.00000000019, 0.32685450395, 4551.95349705880],
[0.00000000016, 4.02105643770, 105460.99111839019],
[0.00000000014, 2.35860855509, 26080.78959457339],
[0.00000000013, 3.28426450224, 25661.30495069820],
[0.00000000016, 2.09223320909, 103292.23063610759],
[0.00000000013, 2.08475100066, 49957.04917896160],
[0.00000000014, 5.66400816218, 48733.23133818299],
[0.00000000013, 1.65023710844, 26095.01668857500],
[0.00000000015, 5.43792291298, 25973.46385288896],
[0.00000000012, 5.15541566845, 79219.30916633119],
[0.00000000012, 2.93766606728, 33326.57873317420],
[0.00000000011, 5.16599347976, 15874.61759536320],
[0.00000000015, 3.49521469034, 83925.04147387479],
[0.00000000012, 1.33980027148, 77308.10968311399],
[0.00000000012, 2.74476655782, 19317.19254032860],
[0.00000000014, 5.48457159802, 98690.28051714458],
[0.00000000012, 6.17629016531, 36301.18868778519],
[0.00000000012, 5.16549673414, 1589.07289528380],
[0.00000000010, 3.19718718931, 24498.83024629040],
[0.00000000010, 3.10957426655, 16983.99614745660],
[0.00000000010, 2.67818215946, 77734.01845962799],
[0.00000000012, 1.64438976704, 26202.34243025941],
[0.00000000011, 6.12421691815, 52705.49724824299],
[0.00000000010, 5.42117419251, 14765.23904326980],
[0.00000000011, 1.59577581724, 50057.04242277000],
[0.00000000012, 2.44342322463, 213.29909543800],
[0.00000000011, 4.59333229552, 56727.75978020720],
[0.00000000008, 2.22267415318, 6283.07584999140],
[0.00000000010, 3.63881306668, 65697.55772473979],
[0.00000000008, 0.85708473896, 365230.64398203876],
[0.00000000010, 3.56346926379, 53235.18821333759],
[0.00000000009, 3.03935867498, 78793.40038981718],
[0.00000000008, 2.05186284069, 30639.85663863300],
[0.00000000008, 6.07959531374, 59414.48187474840],
[0.00000000007, 1.48753095657, 29530.47808653960],
[0.00000000007, 0.54370332724, 38519.94579197200],
[0.00000000008, 5.99792913268, 7.11354700080],
[0.00000000009, 6.08426293157, 69159.80243060499],
[0.00000000007, 1.35513014510, 82815.66292178139],
[0.00000000008, 3.00335450338, 40853.14218484400],
[0.00000000007, 3.40544433462, 1066.49547719000],
[0.00000000007, 5.80782632115, 45405.09568190280],
[0.00000000007, 3.82318715536, 1052.26838318840],
[0.00000000006, 4.57200111034, 55618.38122811380],
[0.00000000006, 4.85942618671, 52168.69273614759],
[0.00000000008, 0.34211699258, 79323.09135491178],
[0.00000000006, 0.67823675060, 110012.94461544899],
[0.00000000007, 4.12285655199, 45892.73043315699],
[0.00000000007, 5.41918774642, 1109.37855209340],
[0.00000000007, 3.14407932401, 51962.50718771040],
[0.00000000006, 5.13879522396, 76044.95232053580],
[0.00000000007, 2.06447590782, 124778.18365871879],
[0.00000000006, 1.61443478349, 3442.57494496540],
[0.00000000005, 2.01359728100, 27676.97603685800],
[0.00000000007, 5.49596353318, 23754.70674870219],
[0.00000000006, 0.71445272050, 27147.28507176339],
[0.00000000005, 5.58153663720, 68050.42387851159],
[0.00000000006, 4.72387999717, 52290.24557183361],
[0.00000000005, 1.65565332809, 80482.46652890938],
[0.00000000005, 4.67655631038, 181505.94343892598],
[0.00000000005, 5.35730277715, 12566.15169998280],
[0.00000000005, 2.24953488234, 52061.36699446317],
[0.00000000004, 1.93085125724, 52156.13652224860],
[0.00000000006, 5.23350745087, 129380.13377768178],
[0.00000000005, 6.27908880897, 66941.04532641819],
[0.00000000006, 0.86124028508, 52195.47604404819],
[0.00000000004, 0.23100295125, 89586.37352302698],
[0.00000000005, 4.23944686799, 103396.01282468818],
[0.00000000004, 0.29398633221, 51109.31080595839],
[0.00000000005, 0.38451698643, 955.59974160860],
[0.00000000005, 5.75812965170, 104881.30353139139],
[0.00000000005, 3.78671774559, 52171.92494779040],
[0.00000000004, 5.32828531774, 25448.00585526019],
[0.00000000005, 3.20016226905, 426.59819087600],
[0.00000000005, 3.86489045633, 9103.90699411760],
[0.00000000004, 0.62543334322, 11322.66409830440],
[0.00000000004, 6.07508617692, 2118.76386037840],
[0.00000000004, 2.43638238426, 74821.13447975718],
[0.00000000004, 5.29735530203, 52179.68761850640],
[0.00000000003, 3.19112063073, 13521.75144159140],
[0.00000000004, 5.09850398144, 77837.11123384659],
[0.00000000004, 1.81128771043, 102762.53967101299],
[0.00000000004, 2.92685125689, 639.89728631400],
[0.00000000004, 4.37998582536, 52182.91983014920],
[0.00000000004, 0.90562468300, 77623.81213840858],
[0.00000000004, 3.40653389629, 105410.99449648599],
[0.00000000004, 5.56139758889, 26301.20223701220],
[0.00000000003, 3.84817111044, 2218.75710418680],
[0.00000000004, 3.40685398189, 52389.10537858640],
[0.00000000003, 3.64497587259, 64607.84893354619],
[0.00000000003, 4.90907522926, 99799.65906923798],
[0.00000000003, 0.33551297325, 13655.86049117640],
[0.00000000003, 4.38738526963, 108903.56606335558],
[0.00000000003, 2.71996542810, 38654.05484155699],
[0.00000000003, 5.21639569130, 150866.08680029298],
[0.00000000003, 5.79669813464, 131548.89425996438],
[0.00000000003, 4.24481036893, 136100.84775702319],
[0.00000000003, 4.74285528385, 53764.87917843220],
[0.00000000003, 5.12230469501, 32370.97899156560],
[0.00000000003, 4.91979299090, 18849.22754997420],
[0.00000000003, 1.21305125502, 105307.21230790539],
[0.00000000002, 2.61741407230, 71492.99882347698],
[0.00000000002, 5.29927753161, 64741.95798313119],
[0.00000000002, 2.59250638038, 155468.03691925599],
[0.00000000002, 5.60083003625, 26514.50133245020],
[0.00000000003, 4.14284031224, 85034.42002596818],
[0.00000000002, 3.04958336441, 93028.94846799239],
[0.00000000003, 6.16142033746, 78477.00852016058],
[0.00000000003, 4.49779099000, 76144.94556434419],
[0.00000000002, 2.74114399659, 130969.20667296558],
[0.00000000002, 6.18606575651, 51123.53789995999],
[0.00000000003, 1.68659744145, 28421.09953444620],
[0.00000000002, 1.39891525246, 81706.28436968799],
[0.00000000002, 1.36487993355, 79852.78232000639],
[0.00000000002, 0.86961235954, 129483.91596626239],
[0.00000000002, 0.16105302705, 25021.40766438420],
[0.00000000002, 0.20969999844, 19804.82729158280],
[0.00000000002, 0.99320491085, 162188.75089859738],
[0.00000000002, 3.94039306142, 391318.54712361297],
[0.00000000002, 1.80783236802, 23969.13928119580],
[0.00000000002, 5.12099356220, 51322.60990139639],
[0.00000000002, 2.80140642811, 62389.09182935939],
[0.00000000002, 2.60965333457, 52602.40447402440],
[0.00000000002, 2.72257468038, 7994.52844202420],
[0.00000000002, 5.84222491614, 103821.92160120218],
[0.00000000002, 6.04515878720, 25035.63475838580],
[0.00000000001, 2.34997564292, 85502.38501632259],
[0.00000000001, 0.17409967102, 131498.89763806018],
[0.00000000001, 3.11496551907, 25934.12433108940],
[0.00000000002, 5.12532278095, 78267.59076008058],
[0.00000000001, 5.49175475674, 104331.94280539699],
[0.00000000001, 0.44808516059, 78050.41032928458],
[0.00000000002, 1.92656028088, 102132.85546210999],
[0.00000000002, 1.93198050022, 853.19638175200],
[0.00000000001, 2.42972717822, 94138.32702008578],
[0.00000000002, 5.13550087739, 6770.71060124560],
[0.00000000001, 4.65441500870, 78259.82808936459],
[0.00000000001, 3.99687455490, 188276.65404017158],
[0.00000000001, 4.39069692330, 104371.28232719658],
[0.00000000001, 1.64083661387, 78283.37918562238],
[0.00000000001, 1.50558734911, 78378.14871340781],
[0.00000000002, 6.27597485867, 91785.46086631398],
[0.00000000001, 4.00786092689, 78244.03966382280],
[0.00000000001, 1.70741856509, 28206.66700195260],
[0.00000000001, 5.31900403501, 78149.27013603736],
[0.00000000001, 1.40205887414, 44937.13069154840],
[0.00000000001, 1.03752853909, 104347.73123093879],
[0.00000000001, 0.66520680194, 419.48464387520],
[0.00000000001, 2.46437105095, 104355.49390165479],
[0.00000000001, 0.81835364761, 35191.81013569180],
[0.00000000001, 0.33780670840, 88476.99497093359],
[0.00000000001, 6.08346231930, 70269.18098269838],
[0.00000000001, 1.86810476133, 125887.56221081219],
[0.00000000001, 2.10468974660, 25619.93815121980],
[0.00000000001, 3.99494842792, 71025.03383312259],
[0.00000000001, 0.57714874874, 71980.63357473118],
[0.00000000001, 5.66312942513, 97580.90196505119],
[0.00000000001, 3.06688416266, 129909.82474277639],
[0.00000000001, 5.66709359706, 433.71173787680],
[0.00000000001, 0.91634007063, 103925.01437542078],
[0.00000000001, 6.02359186416, 181555.94006083018],
[0.00000000001, 1.44980129997, 26727.80042788820],
[0.00000000001, 1.45442920390, 207593.84658050018],
[0.00000000001, 1.12941846578, 60055.89543648739],
[0.00000000001, 1.16964771504, 134991.46920492979],
], [
[0.00000235423, 0.35387524604, 26087.90314157420],
[0.00000160537, 0.00000000000, 0.00000000000],
[0.00000018904, 4.36275460261, 52175.80628314840],
[0.00000006376, 2.50715381439, 78263.70942472259],
[0.00000004580, 6.14257817571, 104351.61256629678],
[0.00000003061, 3.12497552681, 130439.51570787099],
[0.00000001732, 6.26642412058, 156527.41884944518],
[0.00000000857, 3.07673166705, 182615.32199101939],
[0.00000000384, 6.14815319932, 208703.22513259358],
[0.00000000159, 2.92437378320, 234791.12827416777],
[0.00000000062, 5.97292432097, 260879.03141574195],
[0.00000000054, 3.31612529961, 27197.28169366760],
[0.00000000023, 2.74287679452, 286966.93455731616],
[0.00000000017, 0.77798463435, 24978.52458948080],
[0.00000000012, 6.24116133415, 53285.18483524180],
[0.00000000008, 5.79551081392, 313054.83769889036],
[0.00000000006, 5.81555175073, 31749.23519072640],
[0.00000000004, 4.67212195693, 51116.42435295920],
[0.00000000004, 3.36833718999, 77154.33087262919],
[0.00000000003, 0.26522113546, 103242.23401420339],
[0.00000000003, 0.79794705473, 27043.50288318280],
[0.00000000004, 0.82832725003, 21535.94964451540],
[0.00000000002, 2.57068697582, 339142.74084046457],
[0.00000000002, 1.82309397040, 1109.37855209340],
[0.00000000002, 0.74986942696, 47623.85278608960],
[0.00000000002, 3.61692083154, 50586.73338786459],
[0.00000000002, 4.70766241226, 51066.42773105500],
[0.00000000001, 3.33688549090, 129330.13715577759],
[0.00000000001, 2.64641192612, 57837.13833230060],
[0.00000000001, 4.93247555987, 25558.21217647960],
[0.00000000002, 5.00344393497, 20426.57109242200],
[0.00000000002, 4.80841415889, 25028.52121138500],
[0.00000000002, 5.85039338716, 1059.38193018920],
[0.00000000001, 1.85116662745, 37410.56723987860],
[0.00000000002, 3.97317842825, 25132.30339996560],
[0.00000000001, 2.14494291300, 79373.08797681599],
[0.00000000001, 2.53223701416, 46514.47423399620],
[0.00000000001, 5.84921632430, 5661.33204915220],
[0.00000000001, 3.81958470276, 53131.40602475700],
[0.00000000001, 1.05410669937, 1589.07289528380],
[0.00000000001, 1.39436798574, 51646.11531805379],
[0.00000000001, 0.36358097174, 22645.32819660879],
[0.00000000001, 2.76609972270, 28306.66024576099],
[0.00000000001, 3.67689055309, 4551.95349705880],
[0.00000000001, 5.39398540975, 32858.61374281979],
[0.00000000001, 3.73579127170, 24498.83024629040],
[0.00000000001, 0.60289607514, 26068.23338067440],
[0.00000000001, 5.78167324673, 26107.57290247399],
[0.00000000001, 3.81913361795, 26091.78447693220],
[0.00000000001, 5.64455351094, 365230.64398203876],
[0.00000000001, 4.87981157471, 10213.28554621100],
[0.00000000001, 2.44816565966, 26084.02180621620],
[0.00000000000, 3.45284067711, 105460.99111839019],
], [
[0.00000004276, 1.74579932115, 26087.90314157420],
[0.00000001023, 3.14159265359, 0.00000000000],
[0.00000000425, 4.03419509143, 52175.80628314840],
[0.00000000257, 0.20643590425, 78263.70942472259],
[0.00000000116, 3.75237354024, 104351.61256629678],
[0.00000000073, 1.18210375402, 130439.51570787099],
[0.00000000051, 4.54581086194, 156527.41884944518],
[0.00000000031, 1.44226942756, 182615.32199101939],
[0.00000000016, 4.56372679459, 208703.22513259358],
[0.00000000008, 1.34684622635, 234791.12827416777],
[0.00000000003, 4.40269422669, 260879.03141574195],
[0.00000000001, 4.69096566687, 27197.28169366760],
[0.00000000001, 1.16082903756, 286966.93455731616],
[0.00000000000, 1.44918128781, 24978.52458948080],
[0.00000000000, 4.18046278690, 313054.83769889036],
], [
[0.00000000106, 3.94555784256, 26087.90314157420],
[0.00000000075, 3.14159265359, 0.00000000000],
[0.00000000022, 1.30514874546, 52175.80628314840],
[0.00000000007, 4.99717136857, 78263.70942472259],
[0.00000000004, 2.05662545278, 104351.61256629678],
[0.00000000002, 5.43162058632, 130439.51570787099],
[0.00000000001, 2.68052517331, 156527.41884944518],
[0.00000000001, 6.00841870284, 182615.32199101939],
[0.00000000000, 2.85941734701, 208703.22513259358],
[0.00000000000, 5.96962108614, 234791.12827416777],
]],
('Mercury', 'R'):[[
[0.39528271652, 0.00000000000, 0.00000000000],
[0.07834131817, 6.19233722599, 26087.90314157420],
[0.00795525557, 2.95989690096, 52175.80628314840],
[0.00121281763, 6.01064153805, 78263.70942472259],
[0.00021921969, 2.77820093975, 104351.61256629678],
[0.00004354065, 5.82894543257, 130439.51570787099],
[0.00000918228, 2.59650562598, 156527.41884944518],
[0.00000260033, 3.02817753482, 27197.28169366760],
[0.00000289955, 1.42441936951, 25028.52121138500],
[0.00000201855, 5.64725040350, 182615.32199101939],
[0.00000201499, 5.59227724202, 31749.23519072640],
[0.00000141980, 6.25264202645, 24978.52458948080],
[0.00000100144, 3.73435608689, 21535.94964451540],
[0.00000077561, 3.66972526976, 20426.57109242200],
[0.00000063277, 4.29905918105, 25558.21217647960],
[0.00000062951, 4.76588899933, 1059.38193018920],
[0.00000066754, 2.52520309182, 5661.33204915220],
[0.00000075500, 4.47428642962, 51116.42435295920],
[0.00000048266, 6.06824478778, 53285.18483524180],
[0.00000045748, 2.41480951648, 208703.22513259358],
[0.00000035224, 1.05917802674, 27043.50288318280],
[0.00000040815, 2.35882016415, 57837.13833230060],
[0.00000044234, 1.21957314874, 15874.61759536320],
[0.00000033873, 0.86381554651, 25661.30495069820],
[0.00000037203, 0.51733821470, 47623.85278608960],
[0.00000030092, 1.79500530627, 37410.56723987860],
[0.00000028417, 3.02063625668, 51066.42773105500],
[0.00000030903, 0.88366335532, 24498.83024629040],
[0.00000026105, 2.15021963174, 39609.65458316560],
[0.00000018699, 4.96496008403, 11322.66409830440],
[0.00000021270, 5.36857139841, 13521.75144159140],
[0.00000019422, 4.98378647655, 10213.28554621100],
[0.00000016941, 3.88765393402, 26617.59410666880],
[0.00000015109, 0.44510589948, 46514.47423399620],
[0.00000017087, 1.24077764194, 77204.32749453338],
[0.00000013940, 1.62573946865, 27147.28507176339],
[0.00000013382, 1.07657890477, 51646.11531805379],
[0.00000015012, 4.28173463507, 41962.52073693740],
[0.00000013977, 4.77056848793, 33326.57873317420],
[0.00000012794, 6.06437138766, 1109.37855209340],
[0.00000013938, 1.99984876578, 25132.30339996560],
[0.00000016297, 2.63293587817, 19804.82729158280],
[0.00000011933, 2.36500939134, 4551.95349705880],
[0.00000010612, 5.46555460932, 234791.12827416777],
[0.00000012754, 2.07613721222, 529.69096509460],
[0.00000012069, 2.84997619452, 79373.08797681599],
[0.00000009069, 1.21263611811, 14765.23904326980],
[0.00000009491, 0.83697007534, 12566.15169998280],
[0.00000009379, 5.41195286503, 83925.04147387479],
[0.00000007499, 2.44636811119, 30639.85663863300],
[0.00000007463, 5.53233943198, 32858.61374281979],
[0.00000007215, 1.17101960691, 16983.99614745660],
[0.00000008492, 3.56622930635, 73711.75592766379],
[0.00000007109, 5.32625264624, 426.59819087600],
[0.00000006863, 1.82313992707, 36301.18868778519],
[0.00000006560, 4.27818149213, 43071.89928903080],
[0.00000008853, 3.87737694074, 50586.73338786459],
[0.00000006885, 5.31108526630, 1589.07289528380],
[0.00000005943, 4.06893157254, 53131.40602475700],
[0.00000007653, 3.91505031889, 51749.20809227239],
[0.00000006460, 6.07127449283, 77154.33087262919],
[0.00000005415, 5.20028107807, 65697.55772473979],
[0.00000005186, 3.56743214904, 6283.07584999140],
[0.00000004090, 3.67593658710, 22645.32819660879],
[0.00000004075, 4.29142111073, 103292.23063610759],
[0.00000004428, 5.69109527379, 45892.73043315699],
[0.00000003426, 0.64911736234, 52705.49724824299],
[0.00000003354, 3.49345105494, 72602.37737557039],
[0.00000004120, 1.65386255382, 25448.00585526019],
[0.00000003261, 1.03195890028, 68050.42387851159],
[0.00000003278, 3.13863529552, 25874.60404613620],
[0.00000003054, 4.12578324522, 77734.01845962799],
[0.00000003614, 2.95861599353, 28306.66024576099],
[0.00000002820, 4.62628436074, 18849.22754997420],
[0.00000002746, 4.67880529205, 53235.18821333759],
[0.00000002713, 3.56874913980, 26068.23338067440],
[0.00000002507, 2.23312085627, 260879.03141574195],
[0.00000003044, 5.90613310181, 105460.99111839019],
[0.00000002755, 5.67587087632, 26107.57290247399],
[0.00000002267, 2.17941340037, 110012.94461544899],
[0.00000002274, 0.50173671332, 32370.97899156560],
[0.00000002741, 4.75427920262, 63498.47038145279],
[0.00000002792, 5.05148206806, 51220.20654153979],
[0.00000002557, 2.95114696617, 26080.78959457339],
[0.00000002135, 0.84621449019, 76674.63652943878],
[0.00000001971, 0.47407494310, 48733.23133818299],
[0.00000001965, 1.37420902653, 7238.67559160000],
[0.00000002526, 0.34535290139, 23969.13928119580],
[0.00000002022, 0.33828477567, 99799.65906923798],
[0.00000001872, 3.93046425037, 38654.05484155699],
[0.00000001873, 0.69327393635, 26091.78447693220],
[0.00000001945, 2.37383894182, 6770.71060124560],
[0.00000001863, 2.26591720786, 26084.02180621620],
[0.00000001750, 5.50651903992, 56727.75978020720],
[0.00000001971, 3.77455887616, 19317.19254032860],
[0.00000001672, 2.15275897581, 26514.50133245020],
[0.00000001703, 4.28965990785, 40853.14218484400],
[0.00000001657, 4.98021773372, 9103.90699411760],
[0.00000002084, 2.19427123968, 26301.20223701220],
[0.00000001818, 4.20870869718, 25938.33994443960],
[0.00000001780, 0.91702846577, 79219.30916633119],
[0.00000001525, 2.15720744047, 27676.97603685800],
[0.00000001533, 1.54503054415, 955.59974160860],
[0.00000001614, 1.27565104562, 25035.63475838580],
[0.00000001743, 0.68269002122, 77837.11123384659],
[0.00000001389, 4.85102048256, 62389.09182935939],
[0.00000001436, 0.05742216761, 23869.14603738740],
[0.00000001563, 5.84795233948, 26095.01668857500],
[0.00000001640, 4.66281337712, 25021.40766438420],
[0.00000001552, 2.83910580545, 103242.23401420339],
[0.00000001249, 1.97225274067, 91785.46086631398],
[0.00000001160, 1.73113341823, 38519.94579197200],
[0.00000001005, 1.05898314860, 129380.13377768178],
[0.00000001041, 2.78036322434, 213.29909543800],
[0.00000001105, 4.55512109515, 26011.63707029860],
[0.00000000979, 2.43870419667, 71980.63357473118],
[0.00000000853, 0.56334001923, 20760.42703319140],
[0.00000000874, 4.53679970936, 639.89728631400],
[0.00000000783, 3.69782403005, 78793.40038981718],
[0.00000000772, 4.08714349549, 94138.32702008578],
[0.00000000797, 0.26237215917, 98690.28051714458],
[0.00000000965, 4.70784179954, 51535.90899683439],
[0.00000000952, 2.53604676495, 29530.47808653960],
[0.00000000773, 2.67893222158, 131548.89425996438],
[0.00000000734, 0.89243669490, 103821.92160120218],
[0.00000000668, 3.73113394924, 46848.33017476560],
[0.00000000828, 2.88184821542, 19406.67828817460],
[0.00000000622, 1.05579535631, 59414.48187474840],
[0.00000000676, 4.50357599360, 25934.12433108940],
[0.00000000602, 5.28399057704, 286966.93455731616],
[0.00000000619, 1.44855037685, 79323.09135491178],
[0.00000000691, 6.19733262608, 51962.50718771040],
[0.00000000563, 5.22994296186, 136100.84775702319],
[0.00000000782, 3.25257254691, 50057.04242277000],
[0.00000000551, 0.33644229836, 52156.13652224860],
[0.00000000705, 4.73705371920, 26241.68195205900],
[0.00000000577, 5.85654734429, 2118.76386037840],
[0.00000000517, 3.93195379429, 102762.53967101299],
[0.00000000635, 4.87720838965, 12432.04265039780],
[0.00000000635, 1.81903685898, 77308.10968311399],
[0.00000000543, 1.40877130839, 44937.13069154840],
[0.00000000556, 5.44324390449, 85034.42002596818],
[0.00000000496, 3.39004132624, 125887.56221081219],
[0.00000000546, 4.78005317483, 22747.29071487440],
[0.00000000520, 6.00172746972, 52168.69273614759],
[0.00000000463, 3.67549187956, 25668.41849769900],
[0.00000000452, 3.53009000682, 58458.88213313979],
[0.00000000474, 5.94330512040, 54394.56338733519],
[0.00000000559, 2.44355554028, 52195.47604404819],
[0.00000000418, 3.73369494476, 103925.01437542078],
[0.00000000397, 0.69014608020, 64741.95798313119],
[0.00000000511, 5.88243734524, 45494.58142974879],
[0.00000000412, 2.26754404446, 82815.66292178139],
[0.00000000425, 5.24511927496, 52389.10537858640],
[0.00000000482, 0.98165400059, 25654.19140369739],
[0.00000000380, 3.74413132157, 52179.68761850640],
[0.00000000359, 5.50961077408, 26555.86813192860],
[0.00000000375, 1.97920050124, 149.56319713460],
[0.00000000385, 5.88991948790, 129330.13715577759],
[0.00000000348, 4.91064019959, 1052.26838318840],
[0.00000000417, 4.32916053867, 51123.53789995999],
[0.00000000425, 1.43228996047, 51109.31080595839],
[0.00000000464, 3.98651628073, 105307.21230790539],
[0.00000000329, 5.20636278221, 52602.40447402440],
[0.00000000354, 1.04383146533, 66941.04532641819],
[0.00000000324, 1.62975761811, 88476.99497093359],
[0.00000000378, 5.31676765847, 52171.92494779040],
[0.00000000440, 1.46381183715, 89586.37352302698],
[0.00000000355, 1.52732265492, 1066.49547719000],
[0.00000000302, 5.21113786435, 53764.87917843220],
[0.00000000301, 5.02488829134, 117873.36400788819],
[0.00000000351, 2.00433341730, 24395.73747207180],
[0.00000000289, 6.19161799918, 26094.53170047421],
[0.00000000286, 3.77170690304, 7.11354700080],
[0.00000000284, 3.10942616808, 49957.04917896160],
[0.00000000385, 2.47184729453, 25234.70675982219],
[0.00000000382, 0.97683830518, 52026.24308601380],
[0.00000000271, 5.74710334372, 25455.11940226100],
[0.00000000375, 0.55187466535, 45405.09568190280],
[0.00000000267, 2.86410554301, 80482.46652890938],
[0.00000000304, 6.00190488272, 2218.75710418680],
[0.00000000259, 1.82921035765, 24505.94379329119],
[0.00000000251, 4.10979574073, 155468.03691925599],
[0.00000000289, 3.05373259745, 26081.27458267419],
[0.00000000242, 5.05501089774, 42153.96900304900],
[0.00000000244, 2.15621668050, 3442.57494496540],
[0.00000000315, 2.61613386386, 52182.91983014920],
[0.00000000256, 3.71117332461, 25619.93815121980],
[0.00000000232, 2.21576531181, 16066.06586147480],
[0.00000000233, 5.49033130906, 98068.53671630539],
[0.00000000236, 4.08612620637, 26013.12154300690],
[0.00000000225, 0.44449338810, 76144.94556434419],
[0.00000000242, 3.29851820234, 6681.22485339960],
[0.00000000227, 1.63236736805, 76.26607127560],
[0.00000000268, 1.09037236588, 18093.37469954999],
[0.00000000255, 4.20635818545, 44181.27784112419],
[0.00000000205, 1.00234895959, 26190.99591579279],
[0.00000000228, 1.46077047931, 77623.81213840858],
[0.00000000197, 1.36693360783, 26727.80042788820],
[0.00000000259, 1.28296039354, 13655.86049117640],
[0.00000000197, 5.73307583430, 157636.79740153858],
[0.00000000196, 0.06606260924, 40565.25432477420],
[0.00000000187, 0.86187283408, 120226.23016165999],
[0.00000000262, 4.14850032709, 24491.71669928959],
[0.00000000244, 4.14399890076, 95247.70557217918],
[0.00000000232, 5.45165695316, 33967.99229491319],
[0.00000000206, 5.59196913034, 55618.38122811380],
[0.00000000203, 1.64252462466, 58946.51688439399],
[0.00000000187, 0.46291089182, 104881.30353139139],
[0.00000000192, 1.82761158300, 25551.09862947879],
[0.00000000200, 1.81376901527, 25863.55834587229],
[0.00000000191, 5.57428963071, 5327.47610838280],
[0.00000000195, 3.31297083154, 124778.18365871879],
[0.00000000169, 1.69270064342, 90695.75207512038],
[0.00000000226, 1.32354627258, 52099.54021187280],
[0.00000000177, 3.29620848300, 25131.61398560359],
[0.00000000178, 2.54823795050, 26720.68688088739],
[0.00000000167, 3.61983109002, 23754.70674870219],
[0.00000000159, 3.48396967776, 25977.69682035479],
[0.00000000150, 5.20072476078, 69159.80243060499],
[0.00000000179, 3.94252428767, 129909.82474277639],
[0.00000000166, 0.40320638452, 100909.03762133139],
[0.00000000176, 2.97410942402, 24925.42843716640],
[0.00000000154, 1.27206049137, 25984.81036735560],
[0.00000000144, 1.89319156163, 64607.84893354619],
[0.00000000145, 2.05409839424, 313054.83769889036],
[0.00000000152, 4.87194153709, 103396.01282468818],
[0.00000000137, 3.86782217557, 24609.03656750980],
[0.00000000141, 1.99770625298, 162188.75089859738],
[0.00000000185, 6.10038742063, 23439.44831610119],
[0.00000000135, 1.27363012793, 52022.02747266360],
[0.00000000127, 0.70464976569, 128850.44281258718],
[0.00000000142, 1.50696203402, 52329.58509363319],
[0.00000000126, 2.70555128398, 28206.66700195260],
[0.00000000126, 1.61963252183, 48835.19385644859],
[0.00000000123, 0.15629905349, 151975.46535238638],
[0.00000000137, 1.77306412615, 35191.81013569180],
[0.00000000147, 4.50311642422, 105410.99449648599],
[0.00000000125, 3.38994834526, 78244.03966382280],
[0.00000000119, 2.77644375904, 78256.59587772179],
[0.00000000156, 2.96616703196, 78050.41032928458],
[0.00000000145, 1.35569389554, 3340.61242669980],
[0.00000000126, 3.97006576134, 29428.51556827400],
[0.00000000128, 5.41891989692, 26162.68474014150],
[0.00000000132, 4.86901248209, 24712.12934172840],
[0.00000000110, 3.87954702440, 85502.38501632259],
[0.00000000127, 5.49703075555, 78283.37918562238],
[0.00000000126, 0.94870979828, 121335.60871375339],
[0.00000000129, 4.00691218396, 72936.23331633979],
[0.00000000102, 0.50487650429, 130012.91751699499],
[0.00000000104, 0.29849788751, 84546.78527471398],
[0.00000000118, 0.76511176346, 131395.11544947959],
[0.00000000120, 4.45261989231, 71025.03383312259],
[0.00000000117, 3.31644134053, 25771.51127191760],
[0.00000000110, 2.63249934300, 71582.48457132299],
[0.00000000097, 2.66105435933, 155418.04029735178],
[0.00000000113, 5.88733575390, 26404.29501123080],
[0.00000000098, 2.01417457095, 78477.00852016058],
[0.00000000103, 0.46416881502, 51756.32163927320],
[0.00000000093, 2.37389467504, 419.48464387520],
[0.00000000125, 1.87932536282, 26610.48055966799],
[0.00000000095, 0.34221817875, 26507.38778544939],
[0.00000000093, 3.80346806552, 26037.90651966999],
[0.00000000091, 2.63082094391, 28421.09953444620],
[0.00000000101, 5.20997240587, 433.71173787680],
[0.00000000096, 4.47724179825, 77197.21394753258],
[0.00000000108, 4.03679713919, 51742.09454527159],
[0.00000000086, 5.14039556935, 26237.46633870879],
[0.00000000092, 3.74335845403, 90829.86112470538],
[0.00000000086, 1.86276413658, 27140.17152476259],
[0.00000000102, 5.40465219833, 26137.89976347840],
[0.00000000086, 4.01653667598, 10021.83728009940],
[0.00000000100, 5.32142188276, 108903.56606335558],
[0.00000000079, 4.68108496987, 27154.39861876420],
[0.00000000092, 5.52103093635, 51322.60990139639],
[0.00000000093, 4.20604773511, 38813.35657634920],
[0.00000000078, 2.88001982141, 29416.03879785439],
[0.00000000095, 4.44018421307, 115674.27666460119],
[0.00000000104, 5.05004528676, 50483.64061364600],
[0.00000000075, 1.78927060530, 143961.26714946238],
[0.00000000086, 0.51423355089, 78267.59076008058],
[0.00000000078, 4.66831173790, 114564.89811250778],
[0.00000000078, 4.20137623264, 1692.16566950240],
[0.00000000086, 4.03030391951, 78114.14622758799],
[0.00000000073, 2.27328552013, 52643.77127350280],
[0.00000000082, 3.73510592110, 853.19638175200],
[0.00000000071, 4.89150553141, 50593.84693486539],
[0.00000000082, 5.22677693918, 27999.10262479140],
[0.00000000093, 1.09569161440, 77211.44104153418],
[0.00000000074, 1.97833720876, 78690.30761559859],
[0.00000000082, 3.59482991001, 71492.99882347698],
[0.00000000083, 4.10355702051, 93028.94846799239],
[0.00000000083, 3.12647584943, 14477.35118320000],
[0.00000000067, 0.24182046727, 66653.15746634839],
[0.00000000074, 5.66833060422, 78270.82297172339],
[0.00000000068, 1.98236355905, 79852.78232000639],
[0.00000000064, 5.55115814500, 25764.39772491679],
[0.00000000064, 6.15935356751, 76044.95232053580],
[0.00000000087, 1.77296830923, 25440.89230825939],
[0.00000000073, 2.06220281759, 111122.32316754239],
[0.00000000066, 2.28151075383, 7880.08915333899],
[0.00000000076, 2.65553220848, 34282.17847478280],
[0.00000000078, 0.40338105541, 49842.60989027639],
[0.00000000064, 0.87558639332, 181555.94006083018],
[0.00000000086, 2.08697748680, 78259.82808936459],
[0.00000000074, 0.86501751700, 50579.61984086379],
[0.00000000082, 1.02659883956, 74821.13447975718],
[0.00000000059, 2.45952644668, 51543.02254383520],
[0.00000000062, 0.94273311929, 25344.91308104160],
[0.00000000058, 2.95861781205, 52182.43484204840],
[0.00000000058, 4.20402726578, 96357.08412427259],
[0.00000000061, 2.81500265978, 26202.34243025941],
[0.00000000057, 2.27689377996, 124156.43985787958],
[0.00000000057, 4.37167017012, 1581.95934828300],
[0.00000000055, 0.12465494356, 25973.46385288896],
[0.00000000054, 4.79303212221, 26164.16921284980],
[0.00000000054, 3.05622204718, 25565.32572348040],
[0.00000000055, 4.51497762833, 103711.71527998279],
[0.00000000054, 3.87143037686, 18207.81398823521],
[0.00000000054, 4.62784653733, 25881.71759313700],
[0.00000000053, 4.32548272270, 70269.18098269838],
[0.00000000050, 2.50066877650, 183724.70054311278],
[0.00000000058, 2.06211216656, 1596.18644228460],
[0.00000000066, 5.20298814290, 26294.08869001139],
[0.00000000047, 0.85039730966, 52101.02468458109],
[0.00000000058, 1.43409045174, 23866.04650697719],
[0.00000000048, 2.35364103056, 81706.28436968799],
[0.00000000052, 0.19368783267, 92741.06060792258],
[0.00000000053, 0.58517949906, 26624.70765366959],
[0.00000000061, 2.61493039721, 49527.35145767539],
[0.00000000047, 3.88384847335, 146314.13330323418],
[0.00000000049, 6.20308247475, 32769.12799497380],
[0.00000000053, 4.37486529196, 78187.44335344699],
[0.00000000048, 5.97568482401, 51013.33157874059],
[0.00000000048, 3.84102043742, 102232.84870591838],
[0.00000000049, 5.05464216653, 7994.52844202420],
[0.00000000044, 5.42890224840, 86143.79857806159],
[0.00000000058, 3.80571138237, 99024.13645791399],
[0.00000000044, 4.02792920142, 147423.51185532758],
[0.00000000058, 6.09746566424, 52169.17772424839],
[0.00000000042, 4.38843836266, 224.34479570190],
[0.00000000043, 1.57859396874, 23976.25282819660],
[0.00000000049, 0.46973350644, 51707.84129279399],
[0.00000000040, 4.41764731583, 52815.70356946240],
[0.00000000046, 3.51985131014, 130969.20667296558],
[0.00000000045, 4.35527612249, 39743.76363275060],
[0.00000000045, 0.78163192715, 25138.72753260440],
[0.00000000049, 0.90057831755, 632.78373931320],
[0.00000000041, 4.04225615670, 52278.89905736699],
[0.00000000039, 2.91829595120, 956.28915597060],
[0.00000000043, 0.13178694356, 2648.45482547300],
[0.00000000038, 0.62377784752, 50696.93970908399],
[0.00000000042, 2.75028269027, 24079.34560241519],
[0.00000000040, 1.64358052897, 39629.32434406539],
[0.00000000037, 5.75760879379, 25867.49049913539],
[0.00000000051, 1.57829002915, 12725.45343477500],
[0.00000000037, 1.62981695072, 129483.91596626239],
[0.00000000045, 0.04645406242, 51219.51712717779],
[0.00000000036, 0.09834373600, 25241.82030682300],
[0.00000000049, 0.07681157050, 150866.08680029298],
[0.00000000034, 4.56091607046, 536.80451209540],
[0.00000000036, 5.59483746723, 52808.59002246159],
[0.00000000039, 5.99500252470, 104138.31347085879],
[0.00000000046, 0.70772608543, 155997.72788435058],
[0.00000000033, 4.54716206885, 78417.48823520739],
[0.00000000041, 4.92673567168, 51639.00177105299],
[0.00000000032, 4.31372208361, 78109.93061423779],
[0.00000000036, 5.69791953426, 26049.77010593640],
[0.00000000034, 3.32168809248, 35472.74414964940],
[0.00000000042, 4.86530735726, 51951.46148744649],
[0.00000000033, 3.73733919231, 154938.34595416138],
[0.00000000041, 2.38147812869, 68241.87214462319],
[0.00000000035, 5.09571047220, 339142.74084046457],
[0.00000000031, 4.31506703539, 52072.71350892979],
[0.00000000032, 3.21248509301, 178063.36849396059],
[0.00000000035, 5.04278529087, 188276.65404017158],
[0.00000000041, 3.22838990589, 1162.47470440780],
[0.00000000030, 2.33061092140, 1478.86657406440],
[0.00000000032, 2.71244280066, 25780.34552060460],
[0.00000000032, 3.80411460420, 157483.01859105378],
[0.00000000030, 0.37624991562, 26421.75908234360],
[0.00000000029, 5.82513433576, 104344.49901929598],
[0.00000000031, 6.02215690021, 26198.10946279360],
[0.00000000040, 1.02201252788, 27819.02549450680],
[0.00000000030, 2.25849995020, 104371.28232719658],
[0.00000000029, 2.67851330746, 110.20632121940],
[0.00000000030, 1.34446903292, 1375.77379984580],
[0.00000000028, 4.62845152557, 74923.09699802278],
[0.00000000037, 3.03899000872, 11610.55195837420],
[0.00000000032, 0.26062549755, 52065.59996192899],
[0.00000000038, 1.25704652400, 131498.89763806018],
[0.00000000032, 1.04832153595, 26086.41866886590],
[0.00000000037, 1.63595908508, 50800.03248330259],
[0.00000000030, 0.15550783905, 104331.94280539699],
[0.00000000026, 0.03549300809, 24815.22211594700],
[0.00000000026, 1.03871337432, 24292.64469785319],
[0.00000000026, 3.54557412535, 156100.82065856918],
[0.00000000027, 0.60333270859, 111590.28815789679],
[0.00000000031, 3.35540556110, 126996.94076290558],
[0.00000000026, 5.73937805822, 54294.57014352679],
[0.00000000026, 2.79743885101, 86457.98475793119],
[0.00000000026, 5.70579806927, 97670.38771289718],
[0.00000000025, 2.34928986187, 24601.92302050899],
[0.00000000025, 5.70613852018, 181505.94343892598],
[0.00000000034, 0.23651097126, 26395.46076254379],
[0.00000000025, 2.19241735868, 52250.58788171570],
[0.00000000025, 1.82880416247, 74.78159856730],
[0.00000000028, 0.57661358158, 125112.03959948818],
[0.00000000024, 2.03938254170, 26521.61487945100],
[0.00000000024, 5.05213893429, 104564.91166173479],
[0.00000000023, 6.23874249128, 75615.25459924959],
[0.00000000026, 3.34519516519, 110634.68841628819],
[0.00000000026, 4.74840245512, 13362.44970679920],
[0.00000000026, 0.15419927428, 22759.76748529401],
[0.00000000027, 2.39568978424, 522.57741809380],
[0.00000000028, 0.25542748453, 103.09277421860],
[0.00000000025, 3.32961707416, 28286.99048486120],
[0.00000000026, 2.07987634823, 29550.14784743939],
[0.00000000032, 1.70464933285, 26089.38761428249],
[0.00000000023, 4.16670746048, 24176.70365835700],
[0.00000000024, 0.08582796512, 51859.41441349179],
[0.00000000025, 5.27240695394, 25936.85547173129],
[0.00000000024, 0.80363857551, 77829.99768684579],
[0.00000000023, 2.30360039127, 77410.51304297059],
[0.00000000030, 1.21286011206, 97112.93697469679],
[0.00000000022, 4.82094558003, 13541.42120249119],
[0.00000000023, 2.65250267545, 52492.19815280499],
[0.00000000026, 6.26936948934, 25939.82441714789],
[0.00000000024, 4.92454390318, 52698.38370124219],
[0.00000000022, 1.23470921550, 103285.11708910679],
[0.00000000023, 3.68813881444, 26729.31670331319],
[0.00000000022, 1.95831083558, 24356.78078864160],
[0.00000000022, 0.78346634338, 104202.04936916218],
[0.00000000021, 2.52931432670, 467.96499035440],
[0.00000000024, 1.84656751628, 76571.54375522019],
[0.00000000025, 2.55626379808, 24822.33566294780],
[0.00000000027, 3.61440862477, 23962.02573419499],
[0.00000000023, 1.18953680418, 141762.17980617538],
[0.00000000020, 5.49778171394, 112231.70171963578],
[0.00000000023, 2.60719608050, 25754.04720080480],
[0.00000000026, 0.75788900266, 55516.41870984820],
[0.00000000026, 2.09375500363, 134991.46920492979],
[0.00000000020, 3.35091650179, 52595.29092702359],
[0.00000000021, 0.36570195077, 97580.90196505119],
[0.00000000024, 0.51085875774, 116917.76426627958],
[0.00000000021, 5.71018496974, 60055.89543648739],
[0.00000000019, 0.56236491686, 52125.80966124419],
[0.00000000019, 2.85801633295, 60370.08161635699],
[0.00000000024, 3.50657176712, 77844.22478084739],
[0.00000000020, 0.53533403977, 26941.09952332620],
[0.00000000019, 6.25214103463, 25973.50403466079],
[0.00000000022, 5.13145226592, 104347.73123093879],
[0.00000000021, 4.13407823619, 103299.34418310839],
[0.00000000019, 0.33492578967, 102018.41617342478],
[0.00000000019, 5.67148210198, 54509.00267602040],
[0.00000000018, 1.90051892916, 52325.36948028299],
[0.00000000019, 4.27364751897, 122444.98726584678],
[0.00000000018, 2.45675888957, 104358.72611329758],
[0.00000000018, 1.05990359493, 27780.06881107659],
[0.00000000018, 1.43297513339, 53242.30176033840],
[0.00000000021, 2.99876487527, 26073.67604757259],
[0.00000000023, 1.86389686355, 116783.65521669458],
[0.00000000018, 4.87152831033, 170049.17029103659],
[0.00000000019, 4.89400475242, 53228.07466633679],
[0.00000000021, 2.47295566818, 27726.97265876220],
[0.00000000020, 4.98762998978, 104778.21075717278],
[0.00000000021, 1.46468188731, 140652.80125408198],
[0.00000000017, 4.05153553008, 76667.52298243798],
[0.00000000020, 4.80985268979, 51528.79544983359],
[0.00000000022, 0.86617331302, 119116.85160956658],
[0.00000000023, 2.08281937549, 52225.80290505260],
[0.00000000018, 1.69333480892, 76681.75007643958],
[0.00000000017, 2.09406764538, 64901.25971792339],
[0.00000000019, 5.00011023502, 105940.68546158058],
[0.00000000019, 0.74020534937, 36109.74042167360],
[0.00000000017, 2.93246868693, 102132.85546210999],
[0.00000000022, 3.55902023067, 104355.49390165479],
[0.00000000021, 3.54390310557, 106570.36967048359],
[0.00000000018, 4.65006394461, 61279.71327726600],
[0.00000000019, 4.43905256177, 647.01083331480],
[0.00000000017, 2.83124480600, 132658.27281205778],
[0.00000000018, 2.89808596608, 26091.83529483729],
[0.00000000017, 5.67044617806, 25788.77674730500],
[0.00000000017, 5.37178978632, 78731.67441507700],
[0.00000000015, 5.25910515843, 150244.34299945379],
[0.00000000019, 1.72681089737, 153.77881048480],
[0.00000000015, 2.16472550978, 26222.01219115920],
[0.00000000015, 1.13029685380, 25042.74830538660],
[0.00000000015, 2.31335544105, 51852.30086649099],
[0.00000000019, 4.38254962804, 24182.43837663380],
[0.00000000015, 5.16465400786, 27684.08958385880],
[0.00000000017, 3.97954718583, 207643.84320240439],
[0.00000000016, 5.74057898460, 25352.02662804239],
[0.00000000014, 3.42441202713, 26823.77965510599],
[0.00000000014, 5.30168284837, 742.99006053260],
[0.00000000014, 2.50431306810, 32132.13172294960],
[0.00000000014, 1.36632464908, 23919.14265929160],
[0.00000000015, 6.07490514430, 78270.33798362259],
[0.00000000019, 4.40557078960, 49953.94964855139],
[0.00000000014, 0.65475293554, 323.50541665740],
[0.00000000014, 0.47093305165, 17893.62780836560],
[0.00000000014, 1.33029112501, 129799.61842155698],
[0.00000000017, 6.02915345940, 26667.59072857300],
[0.00000000014, 1.17588054181, 104275.34649502118],
[0.00000000014, 4.84032377923, 2221.85663459700],
[0.00000000014, 5.53694881682, 77630.92568540938],
[0.00000000013, 5.59791238730, 209812.60368468695],
[0.00000000013, 0.84042148682, 173511.41499690177],
[0.00000000015, 3.96416547461, 51432.81622261579],
[0.00000000015, 3.17020350946, 176953.98994186718],
[0.00000000014, 2.91048815444, 78257.08086582259],
[0.00000000013, 5.34915944924, 80174.90890793978],
[0.00000000018, 1.65795375577, 28256.66362385679],
[0.00000000013, 3.34629064183, 25508.21555457540],
[0.00000000016, 1.32228458025, 27669.86248985719],
[0.00000000013, 1.38990649917, 25024.58905812189],
[0.00000000017, 2.01249037695, 27037.07875054399],
[0.00000000015, 1.99208068531, 52381.99183158559],
[0.00000000013, 2.32883800921, 27005.83342755599],
[0.00000000014, 3.86914390591, 182085.63102592478],
[0.00000000012, 3.97054224711, 78188.92782615528],
[0.00000000016, 5.59174105029, 25446.48957983520],
[0.00000000014, 0.70490117614, 172402.03644480839],
[0.00000000012, 1.54422590258, 52252.07235442399],
[0.00000000014, 3.47518139481, 27177.61193276780],
[0.00000000012, 5.46223056321, 107794.18751126219],
[0.00000000012, 5.76552608362, 50167.24874398939],
[0.00000000016, 2.18648993322, 26308.31578401300],
[0.00000000014, 2.72148386686, 27311.72098235281],
[0.00000000013, 0.55524977232, 75930.51303185058],
[0.00000000012, 2.66601602132, 137210.22630911658],
[0.00000000011, 0.61596543052, 44295.71712980940],
[0.00000000011, 4.76091715459, 155571.81910783658],
[0.00000000014, 5.93896401871, 52290.24557183361],
[0.00000000011, 0.92596625175, 22625.65843570900],
[0.00000000012, 6.19273795549, 51653.22886505459],
[0.00000000014, 0.79969658546, 25953.79409198919],
[0.00000000011, 2.82093111356, 77101.23472031478],
[0.00000000011, 1.26994666311, 26312.24793727610],
[0.00000000013, 2.88923696437, 112545.88789950538],
[0.00000000011, 6.05528757595, 27044.19229754480],
[0.00000000012, 3.29626000869, 52061.36699446317],
[0.00000000011, 3.58945976808, 52712.61079524379],
[0.00000000014, 2.79036507500, 23888.81579828719],
[0.00000000011, 4.15810059578, 45290.65639321759],
[0.00000000011, 2.94979930726, 58857.03113654799],
[0.00000000012, 2.20589728666, 31415.37924995700],
[0.00000000012, 1.34841658603, 51969.62073471119],
[0.00000000011, 3.29585795787, 28736.35796704720],
[0.00000000011, 0.43538573957, 24448.83362438620],
[0.00000000010, 2.85999162474, 130226.21661243298],
[0.00000000013, 4.41880429822, 19958.60610206760],
[0.00000000012, 5.96394058241, 26083.97098831109],
[0.00000000010, 5.44297146700, 163298.12945069079],
[0.00000000012, 1.57767582029, 91805.13062721379],
[0.00000000010, 3.83536418151, 51226.63067417859],
[0.00000000013, 0.34187342138, 157057.10981453978],
[0.00000000010, 1.12787053523, 78903.60671103658],
[0.00000000010, 4.67818130014, 2111.65031337760],
[0.00000000012, 3.56391619799, 77795.74443436819],
[0.00000000011, 5.80720491261, 26102.13023557580],
[0.00000000012, 5.80252382200, 27972.80430499159],
[0.00000000011, 2.47026109919, 26010.15259759030],
[0.00000000013, 4.60245036657, 25032.45336464809],
[0.00000000010, 1.14221106164, 9384.84100807520],
[0.00000000013, 5.56953201474, 22909.75735100660],
[0.00000000010, 4.35806585483, 157586.80077963437],
[0.00000000010, 1.11553298844, 65831.66677432480],
[0.00000000011, 4.67108617661, 50064.15596977079],
[0.00000000011, 2.80726281395, 81591.84508100279],
[0.00000000009, 0.47353753060, 128106.31931499895],
[0.00000000009, 1.42459829123, 104505.39137678158],
[0.00000000009, 2.37565722096, 78896.49316403578],
[0.00000000009, 4.84820485208, 24918.31489016559],
[0.00000000011, 6.23834008870, 30171.89164827860],
[0.00000000011, 1.65565660037, 78039.36462902068],
[0.00000000009, 3.65734666897, 151199.94274106238],
[0.00000000009, 5.40966654859, 130459.18546877075],
[0.00000000010, 0.87714716556, 78366.80219894118],
[0.00000000009, 3.04701773654, 51329.72344839720],
[0.00000000009, 1.96005885441, 26575.53789282839],
[0.00000000010, 1.18004009296, 50270.34151820800],
[0.00000000009, 5.48583841069, 138319.60486120995],
[0.00000000010, 3.21154218694, 77307.42026875199],
[0.00000000009, 5.55407965409, 8194.27533320860],
[0.00000000008, 1.35584545211, 12546.48193908300],
[0.00000000009, 0.42023516699, 27223.58001346740],
[0.00000000010, 1.76704509660, 77726.90491262719],
[0.00000000009, 1.60501838348, 77616.69859140778],
[0.00000000009, 5.46388323313, 16703.06213349900],
[0.00000000009, 1.60520912676, 117893.03376878797],
[0.00000000009, 6.23528739890, 846.08283475120],
[0.00000000009, 5.66619352199, 50910.23880452200],
[0.00000000009, 1.18753574623, 104197.83375581198],
[0.00000000009, 0.69327774851, 26709.64694241340],
[0.00000000010, 5.48870132496, 94329.77528619739],
[0.00000000008, 1.17006056902, 78160.61665050399],
[0.00000000009, 0.49965065220, 27573.19384827740],
[0.00000000011, 6.20705720585, 28102.88481337200],
[0.00000000011, 0.75657533913, 128320.75184749259],
[0.00000000008, 3.86430794820, 103917.90082841998],
[0.00000000009, 3.64580324894, 76784.84285065818],
[0.00000000008, 4.52722085618, 27463.67694142000],
[0.00000000009, 1.73726961641, 28791.51929624980],
[0.00000000011, 1.86762532326, 214364.55718174578],
[0.00000000008, 3.17547134507, 50903.12525752120],
[0.00000000008, 6.23140491980, 148.07872442630],
[0.00000000008, 0.97646930359, 19202.75325164339],
[0.00000000008, 0.87651427964, 151.04766984290],
[0.00000000009, 1.55645109653, 26126.03617721200],
[0.00000000008, 3.12232090039, 22003.91463486980],
[0.00000000008, 3.45204671122, 24203.00197815680],
[0.00000000008, 2.50177739941, 51955.39364070959],
[0.00000000008, 4.20326276911, 50380.54783942739],
[0.00000000008, 2.66681931912, 130432.40216087017],
[0.00000000010, 2.61302801987, 27170.98337386779],
[0.00000000008, 6.15791792940, 37698.45509994840],
[0.00000000008, 5.36718741692, 35077.37084700659],
[0.00000000008, 0.39542025081, 183570.92173262799],
[0.00000000008, 4.37576068847, 123200.84011627098],
[0.00000000008, 3.44870239791, 26402.08932144380],
[0.00000000007, 5.88380837195, 51868.24866217880],
[0.00000000007, 4.80640660702, 26118.23000257860],
[0.00000000008, 5.82773614091, 3328.13565628019],
[0.00000000009, 2.53209611805, 25227.59321282139],
[0.00000000010, 2.52793236150, 35833.22369743080],
[0.00000000008, 4.11204744654, 53906.92863608099],
[0.00000000008, 1.58745297967, 101011.00013959699],
[0.00000000009, 2.57384727244, 2125.87740737920],
[0.00000000007, 2.46084982092, 52137.67324751059],
[0.00000000008, 5.56577535390, 50689.82616208319],
[0.00000000007, 5.98112141065, 52179.73843641149],
[0.00000000010, 5.16567712694, 55638.05098901359],
[0.00000000008, 4.67643518278, 76887.93562487679],
[0.00000000007, 4.36322743599, 155887.52156313117],
[0.00000000009, 0.68598593831, 38.13303563780],
[0.00000000008, 0.46194680162, 181026.24909573558],
[0.00000000008, 0.42442705032, 182188.72380014337],
[0.00000000009, 3.57254516611, 1265.56747862640],
[0.00000000009, 1.65553917926, 65717.22748563958],
[0.00000000010, 3.53066047636, 2008.55753915900],
[0.00000000007, 3.89373397550, 1485.98012106520],
[0.00000000010, 0.82550269560, 39763.43339365039],
[0.00000000007, 4.33817871844, 129373.02023068098],
[0.00000000007, 3.41340083585, 52483.36390411799],
[0.00000000008, 1.23992323880, 76041.85279012559],
[0.00000000007, 0.04567921269, 206.18554843720],
[0.00000000007, 2.56169701158, 207593.84658050018],
[0.00000000009, 1.97148507623, 365230.64398203876],
[0.00000000007, 3.14813276839, 52061.40717623499],
[0.00000000007, 4.86954611488, 27351.06050415239],
[0.00000000008, 6.27520424489, 204151.27163553478],
[0.00000000007, 5.46143749214, 25985.94062330859],
[0.00000000008, 4.44335543148, 26057.57628056979],
[0.00000000007, 1.00677483843, 129387.24732468258],
[0.00000000008, 0.22314041177, 50049.92887576919],
[0.00000000007, 3.98224449185, 13675.53025207620],
[0.00000000007, 4.34489404354, 167850.08294774959],
[0.00000000009, 0.71471851401, 233731.74634397858],
[0.00000000007, 1.69935809006, 54087.00576636560],
[0.00000000007, 6.21044393135, 203041.89308344138],
[0.00000000007, 2.53524305485, 80382.47328510099],
[0.00000000007, 0.03218225075, 31281.27020037200],
[0.00000000007, 5.26037977949, 78338.49102328988],
[0.00000000007, 3.52744190481, 52509.66222391780],
[0.00000000007, 5.24771876203, 1795.25844372100],
[0.00000000007, 5.20875856726, 161079.37234650398],
[0.00000000007, 3.19471628666, 24072.92146977640],
[0.00000000006, 1.58096793180, 143980.93691036216],
[0.00000000009, 0.70414754528, 25169.97285559240],
[0.00000000006, 0.15264531683, 52911.68279668019],
[0.00000000007, 4.28578455720, 51130.65144696079],
[0.00000000007, 3.42650023556, 29396.36903695460],
[0.00000000007, 4.12959254769, 52174.32181044009],
[0.00000000008, 3.79812131071, 137678.19129947099],
[0.00000000007, 5.70602822567, 9745.32055585660],
[0.00000000008, 0.14316432919, 136722.59155786238],
[0.00000000007, 3.78832454636, 26189.86565983980],
[0.00000000007, 5.44664616173, 27566.76971563859],
[0.00000000006, 0.53269408847, 208173.53416749898],
[0.00000000007, 3.95192199993, 145204.75475114079],
[0.00000000006, 1.80610265750, 26830.89320210680],
[0.00000000008, 5.80105964058, 25773.71696170459],
[0.00000000006, 1.20705629404, 26734.91397488900],
[0.00000000008, 3.87508349031, 52041.69723356339],
[0.00000000007, 1.87429126900, 1905.46476494040],
[0.00000000007, 5.68938243001, 158746.17595363196],
[0.00000000008, 3.39884199213, 78153.50310350319],
[0.00000000007, 1.20867598891, 61560.64729122359],
[0.00000000008, 3.30580293572, 130419.84594697120],
[0.00000000007, 0.39338960799, 2199.08734328700],
[0.00000000006, 3.17982806365, 77947.31755506598],
[0.00000000008, 0.88585179650, 220.41264243880],
[0.00000000008, 1.46508855917, 87367.61641884019],
[0.00000000006, 0.60809363482, 118828.96374949679],
[0.00000000008, 5.53182088929, 53814.87580033639],
[0.00000000007, 1.65646088833, 196137.07343261078],
[0.00000000006, 5.74552748087, 55503.94193942859],
[0.00000000006, 1.43996863707, 2333.19639287200],
[0.00000000006, 1.91186990644, 130652.81480330898],
[0.00000000006, 5.06448767269, 50444.68393021580],
[0.00000000006, 1.09838300878, 183674.70392120858],
[0.00000000007, 0.35338852938, 103932.12792242158],
[0.00000000006, 0.28924808590, 54374.89362643540],
[0.00000000006, 2.72829193454, 76255.15188556358],
[0.00000000006, 3.92290484480, 130289.95251073639],
[0.00000000007, 1.27402494790, 46046.50924364180],
[0.00000000007, 2.96149281662, 52755.49387014719],
[0.00000000008, 2.23784693584, 25466.15934073500],
[0.00000000006, 1.78075029765, 78786.28684281638],
[0.00000000008, 4.71972114899, 25014.29411738339],
[0.00000000006, 5.52798470860, 103498.41618454478],
[0.00000000008, 5.43345902063, 949.17560896980],
[0.00000000006, 5.55571041746, 130446.62925487179],
[0.00000000007, 5.36488899884, 77940.20400806518],
[0.00000000006, 0.52080930820, 25004.82290928060],
[0.00000000006, 3.48878406062, 123668.80510662538],
[0.00000000008, 3.02023688443, 26076.85744131030],
[0.00000000008, 5.31586228888, 24388.62392507099],
[0.00000000006, 5.06257578673, 78469.89497315978],
[0.00000000006, 4.79504045120, 52177.29075585669],
[0.00000000006, 4.57296057068, 35211.47989659159],
[0.00000000006, 5.37176342301, 53093.73656913019],
[0.00000000006, 4.26973755729, 130363.24963659538],
[0.00000000006, 5.75364706874, 78580.10129437919],
[0.00000000006, 1.99314462977, 130435.63437251298],
[0.00000000006, 1.55918658153, 39450.35284837340],
[0.00000000008, 4.77256284659, 142871.55835826878],
[0.00000000006, 6.09530056324, 103395.32341032618],
[0.00000000006, 1.29134609458, 102975.83876645098],
[0.00000000006, 1.83917095242, 24402.85101907260],
[0.00000000005, 3.63216834248, 43981.53094993980],
[0.00000000005, 5.64850202903, 28774.62523611540],
[0.00000000007, 4.22124824964, 26098.94884183810],
[0.00000000005, 5.85936922514, 156314.11975400719],
[0.00000000005, 4.97283396704, 102659.44689679438],
[0.00000000005, 1.46473339833, 181659.72224941078],
[0.00000000006, 0.71584342921, 104276.83096772949],
[0.00000000007, 2.49362242764, 51439.92976961659],
[0.00000000006, 0.02944876240, 20043.67456019880],
[0.00000000006, 2.19480801460, 12412.37288949800],
[0.00000000007, 3.28347851449, 183145.01295611398],
[0.00000000005, 3.46807375357, 50536.73676596039],
[0.00000000006, 6.20804958899, 114.39910691340],
[0.00000000006, 2.26035174588, 103718.82882698359],
[0.00000000007, 3.65318062648, 143005.66740785378],
[0.00000000005, 0.12859263642, 51596.11869614960],
[0.00000000007, 0.75531928973, 77520.71936418998],
[0.00000000005, 1.52974136650, 26724.89941359840],
[0.00000000007, 3.81960920375, 62197.64356324779],
[0.00000000005, 5.08212104486, 52609.51802102519],
[0.00000000005, 4.49337901115, 50007.04580086580],
[0.00000000005, 5.03210861040, 1045.15483618760],
[0.00000000005, 6.27674019656, 1272.68102562720],
[0.00000000006, 3.84313039676, 81604.32185142238],
[0.00000000006, 3.27974922227, 144916.86689107098],
[0.00000000005, 0.50987626702, 299.12639426920],
[0.00000000006, 5.10596879808, 78313.70604662679],
[0.00000000005, 4.14575201906, 53867.97195265079],
[0.00000000007, 4.53402175332, 166740.70439565618],
[0.00000000005, 5.57648480152, 106262.81204951399],
[0.00000000007, 3.08562485832, 52027.72755872209],
[0.00000000006, 2.81224506925, 25450.90686955000],
[0.00000000005, 1.51400872659, 28199.55345495179],
[0.00000000006, 1.58495517428, 47803.92991637420],
[0.00000000006, 2.79561551205, 52286.01260436779],
[0.00000000007, 1.80630878142, 23549.65463732060],
[0.00000000007, 3.72396318065, 198489.93958638258],
[0.00000000005, 5.74129147264, 103189.13786188899],
[0.00000000006, 2.94825789213, 56259.79478985279],
[0.00000000005, 4.96546514085, 78413.27262185719],
[0.00000000005, 1.78518845730, 129586.31932611899],
[0.00000000005, 0.31701812829, 78800.51393681798],
[0.00000000005, 0.55478931159, 52817.21984488739],
[0.00000000006, 1.18448496437, 25600.26839032000],
[0.00000000005, 0.42862127579, 179172.74704605396],
[0.00000000006, 3.74336258475, 26247.20487636640],
[0.00000000005, 2.46583763315, 123758.29085447139],
[0.00000000006, 5.09461941443, 53124.98189211819],
[0.00000000006, 0.42320281908, 130443.39704322898],
[0.00000000006, 2.57896380153, 26014.60601571519],
[0.00000000005, 2.23635663946, 24513.05734029200],
[0.00000000005, 5.98752668018, 104344.98400739678],
[0.00000000006, 0.32131472009, 102872.74599223239],
[0.00000000005, 1.95885559875, 53771.99272543299],
[0.00000000007, 2.16257501519, 52024.75861330549],
[0.00000000006, 1.37111815532, 51120.35650622229],
[0.00000000005, 0.15128494504, 78683.19406859778],
[0.00000000005, 4.00810087423, 48713.56157728320],
[0.00000000006, 1.45883115780, 76152.05911134499],
[0.00000000005, 1.72421399237, 28309.75977617119],
[0.00000000005, 0.71424864998, 102755.42612401219],
[0.00000000006, 0.03283607980, 78149.27013603736],
[0.00000000006, 2.69429372458, 78378.14871340781],
[0.00000000006, 1.12570261398, 25647.07785669659],
[0.00000000005, 3.60259399819, 11.04570026390],
[0.00000000006, 4.83171247280, 240452.46032331996],
[0.00000000005, 3.71949948652, 26411.40855823160],
[0.00000000005, 4.55172986205, 79330.20490191258],
[0.00000000005, 0.84232799985, 24551.92639860479],
[0.00000000005, 3.74067330742, 52797.55008398759],
[0.00000000005, 2.92277012561, 54190.78795494619],
[0.00000000005, 3.96038779086, 25657.37279743509],
[0.00000000005, 4.54502031861, 102769.65321801379],
[0.00000000006, 2.35342867622, 27665.24668402200],
[0.00000000005, 3.72877345305, 78213.71280281838],
[0.00000000005, 6.19447408823, 26191.68533015479],
[0.00000000004, 0.53733592588, 77314.53381575279],
[0.00000000004, 1.39917225370, 26290.15653674829],
[0.00000000005, 4.85332036328, 54344.56676543099],
[0.00000000006, 0.92030946706, 23336.35554188260],
[0.00000000006, 0.37487337241, 53265.51507434200],
[0.00000000004, 2.01983013209, 156547.08861034496],
[0.00000000005, 6.13113074115, 26026.17716683400],
[0.00000000004, 4.94928690334, 52663.44103440259],
[0.00000000005, 0.40443457223, 28096.46068073319],
[0.00000000004, 4.40405080911, 130593.29451835579],
[0.00000000004, 4.17440698686, 91919.56991589899],
[0.00000000005, 3.71777436660, 70383.62027138360],
[0.00000000005, 1.52885825328, 51102.19725895759],
[0.00000000004, 1.71609047005, 23762.95373275860],
[0.00000000004, 0.55287089413, 26933.98597632540],
[0.00000000005, 6.02225706023, 128220.75860368418],
[0.00000000005, 1.78226900229, 187167.27548807819],
[0.00000000005, 3.32000517354, 45424.76544280259],
[0.00000000005, 4.64166221826, 24824.74577899600],
[0.00000000005, 3.45997061965, 48847.67062686820],
[0.00000000006, 2.62272580920, 52171.87412988529],
[0.00000000004, 3.62789650971, 53029.00266490040],
[0.00000000006, 2.53652345505, 52190.03337714999],
[0.00000000004, 0.08235213515, 58220.03486452380],
[0.00000000006, 2.56621666334, 51876.67988887919],
[0.00000000005, 5.04323059321, 41494.55574658299],
[0.00000000004, 3.42433134364, 53311.48315504160],
[0.00000000005, 5.60899913389, 1911.19948321720],
[0.00000000004, 1.13990612191, 26183.88236879199],
[0.00000000004, 4.24142693734, 189853.99758261938],
[0.00000000004, 0.21521651200, 19336.86230122839],
[0.00000000005, 0.30306745520, 103883.64757594238],
[0.00000000004, 6.09719517639, 77417.62658997139],
[0.00000000004, 3.38148734662, 316.39186965660],
[0.00000000004, 1.40344660688, 25885.64974640009],
[0.00000000006, 2.54556610763, 54060.70744656579],
[0.00000000005, 4.62289027765, 78339.97549599818],
[0.00000000004, 6.06868163269, 84944.93427812219],
[0.00000000005, 0.64970018860, 3178.14579056760],
[0.00000000004, 5.48109256360, 78225.57638908479],
[0.00000000004, 3.76404568854, 153084.84390447979],
[0.00000000004, 0.18748530762, 52489.99246301800],
[0.00000000005, 1.74044114280, 79315.97780791098],
[0.00000000004, 6.06406108213, 52161.57918914679],
[0.00000000005, 0.28595106407, 26161.20026743319],
[0.00000000004, 2.11074347112, 189386.03259226495],
[0.00000000004, 0.59715530740, 16342.58258571760],
[0.00000000004, 3.91091220587, 101703.15774082378],
[0.00000000004, 1.16130290140, 50264.60679993120],
[0.00000000004, 5.51188515445, 78043.29678228378],
[0.00000000005, 4.39350322600, 53757.76563143139],
[0.00000000004, 5.15437140585, 24285.53115085240],
[0.00000000005, 2.15280343086, 48997.66049258080],
[0.00000000004, 5.35316514819, 104984.39630560997],
[0.00000000005, 5.75390640070, 51841.95034237900],
[0.00000000004, 1.52206374281, 26267.98027185880],
[0.00000000004, 4.66563868021, 104127.26777059489],
[0.00000000004, 2.36671017385, 19.66976089979],
[0.00000000004, 5.10954286080, 31722.93687092660],
[0.00000000004, 1.54518951672, 52206.13314415280],
[0.00000000004, 4.16791904155, 130285.73689738619],
[0.00000000004, 2.93299901703, 31775.53351052620],
[0.00000000005, 4.47247592301, 51112.49219969609],
[0.00000000004, 2.41568769208, 51534.39272140940],
[0.00000000004, 1.74441095464, 26248.31051095900],
[0.00000000004, 5.23856038893, 52396.21892558720],
[0.00000000004, 4.12254586219, 27441.65188659100],
[0.00000000005, 5.17529407091, 19367.18916223280],
[0.00000000004, 4.21064422396, 26279.35140768579],
[0.00000000005, 4.41570881449, 78057.52387628538],
[0.00000000004, 5.30327887066, 25672.35065096209],
[0.00000000005, 1.10382058499, 31903.01400121119],
[0.00000000005, 2.71619626622, 24952.22626968100],
[0.00000000004, 2.28793023586, 235900.50682626116],
[0.00000000004, 1.58884724433, 128747.35003836859],
[0.00000000004, 5.78862899204, 22779.43724619380],
[0.00000000004, 4.22021430561, 1731.12235293260],
[0.00000000004, 4.68318371027, 103814.80805420138],
[0.00000000004, 3.29575966354, 76137.83201734339],
[0.00000000004, 5.47487283809, 132350.71519108818],
[0.00000000004, 2.99265295426, 77741.13200662879],
[0.00000000004, 3.47889610610, 53661.09698985160],
[0.00000000004, 4.76216346874, 156740.71794488319],
[0.00000000004, 1.47799681769, 120417.67842777158],
[0.00000000004, 2.78305398087, 133767.65136415116],
[0.00000000004, 2.87953962922, 25862.07387316400],
[0.00000000004, 1.92972990240, 15406.65260500879],
[0.00000000005, 1.81394930430, 130866.11389874699],
[0.00000000004, 2.62752187758, 24602.61243487099],
[0.00000000004, 3.12567603415, 20894.53608277640],
[0.00000000004, 1.00432915295, 149288.74325784518],
[0.00000000004, 3.47489986602, 26114.20146137400],
[0.00000000004, 4.27251739299, 104991.50985261079],
[0.00000000004, 2.20022040184, 52073.84376488279],
[0.00000000004, 3.77568584773, 14.22709400160],
[0.00000000004, 1.65179392234, 51006.21803173979],
[0.00000000004, 0.72729563393, 25865.04281858059],
[0.00000000004, 5.61140287619, 53258.88651544199],
[0.00000000004, 1.55115346866, 53438.96364572659],
[0.00000000005, 0.91157457367, 25665.23710396129],
[0.00000000005, 6.11073147567, 156507.74908854539],
[0.00000000003, 3.12711312875, 80462.79676800959],
[0.00000000004, 2.21068358470, 76777.72930365738],
[0.00000000004, 0.82472101949, 30689.85326053720],
[0.00000000004, 3.85651603357, 26513.81191808820],
[0.00000000003, 3.76311835707, 77.75054398390],
[0.00000000004, 0.76897521016, 23384.28698689860],
[0.00000000003, 4.58555781046, 57503.28239153120],
[0.00000000004, 3.82967402925, 104454.70534051539],
[0.00000000003, 2.47448927310, 77956.15180375299],
[0.00000000004, 4.93160467297, 391318.54712361297],
[0.00000000004, 1.56118199279, 1055.44977692610],
[0.00000000004, 0.77257538538, 79994.83177765518],
[0.00000000005, 3.11675458540, 26149.62911631439],
[0.00000000003, 4.05641745083, 104248.51979207818],
[0.00000000004, 2.97133561512, 30110.16567353840],
[0.00000000004, 5.60420829330, 156520.30530244438],
[0.00000000004, 5.59378669038, 51315.49635439559],
[0.00000000003, 5.33733887891, 52309.91533273340],
[0.00000000003, 5.47155908699, 149846.19399604558],
[0.00000000003, 0.19039417498, 50290.90511973100],
[0.00000000003, 0.55626990901, 130005.80396999417],
[0.00000000004, 1.22491945176, 25927.49577218939],
[0.00000000004, 1.83119228357, 132028.58860315479],
[0.00000000004, 3.78910193450, 25970.58327335399],
[0.00000000004, 4.12310730501, 33856.26969826880],
[0.00000000004, 3.29497466474, 208276.62694171758],
[0.00000000003, 1.23800163682, 193937.98608932378],
[0.00000000004, 3.81093761011, 49424.25868345679],
[0.00000000004, 6.17742034131, 76991.02839909539],
[0.00000000003, 2.37855052298, 25459.05155552409],
[0.00000000003, 0.06662548789, 54824.26110862140],
[0.00000000003, 0.00882668027, 78571.26704569219],
[0.00000000004, 3.50355655289, 33480.35754365900],
[0.00000000004, 1.42998120813, 23446.56186310200],
[0.00000000004, 4.57967744099, 52213.93931878620],
[0.00000000004, 4.30793307856, 2538.24850425360],
[0.00000000004, 2.64175466237, 80596.90581759460],
[0.00000000004, 2.23067570586, 104819.57755665119],
[0.00000000004, 2.10867686930, 27331.39074325260],
[0.00000000003, 3.74321552731, 28471.09615635040],
[0.00000000003, 5.35951703976, 233681.74972207438],
[0.00000000004, 1.44726666359, 25907.82601128960],
[0.00000000003, 0.77055249403, 23389.45169419700],
[0.00000000004, 5.53731910534, 52098.05573916449],
[0.00000000004, 2.71065844730, 107679.74822257696],
[0.00000000003, 4.85884222947, 1063.31408345230],
[0.00000000003, 6.10322230645, 48091.81777644400],
[0.00000000003, 0.57378510632, 154194.22245657316],
[0.00000000003, 4.65504051632, 25896.45487546260],
[0.00000000003, 2.07685199898, 3.93215326310],
[0.00000000004, 4.67601599622, 18073.70493865020],
[0.00000000003, 4.62237776277, 21716.02677480000],
[0.00000000003, 2.40811934972, 76998.14194609619],
[0.00000000004, 1.45941637429, 1073.60902419080],
[0.00000000003, 4.06965227350, 32808.61712091560],
[0.00000000003, 3.54974279869, 23401.18104703300],
[0.00000000003, 5.94935193305, 6751.04084034580],
[0.00000000003, 4.32590129932, 52400.15107885030],
[0.00000000003, 1.93788940079, 45455.09230380700],
[0.00000000003, 6.08303870194, 53399.62412392700],
[0.00000000003, 4.45999574391, 127098.90328117118],
[0.00000000003, 5.45176028820, 26061.60482177439],
[0.00000000003, 2.26429696537, 27047.02600153180],
[0.00000000004, 1.93735592711, 26603.36701266720],
[0.00000000003, 2.94612910423, 27039.97976483379],
[0.00000000004, 3.64314833794, 860.30992875280],
[0.00000000004, 2.04162116492, 27623.87988454360],
[0.00000000004, 1.02413610685, 25991.92391435639],
[0.00000000004, 3.72190941745, 51257.87599716660],
[0.00000000003, 0.83533616968, 78262.22495201428],
[0.00000000004, 5.84174581609, 25650.25925043430],
[0.00000000003, 3.86698088130, 56777.75640211140],
[0.00000000004, 0.94091162922, 23735.03698780239],
[0.00000000003, 2.87479269049, 159855.55450572536],
[0.00000000004, 2.92372103776, 104358.24112519680],
[0.00000000003, 5.50683793531, 25928.60140678200],
[0.00000000003, 1.50282981980, 4371.87636677420],
[0.00000000003, 2.10941795435, 60170.33472517260],
[0.00000000003, 1.71064218785, 170068.84005193636],
[0.00000000003, 1.97431548371, 104426.39416486409],
[0.00000000003, 2.96711706073, 25984.12095299360],
[0.00000000003, 1.86795145608, 126067.63934109679],
[0.00000000003, 4.74630310296, 54879.42243782400],
[0.00000000004, 3.71365034796, 29580.47470844380],
[0.00000000003, 4.20767161544, 128843.32926558638],
[0.00000000003, 0.91166163253, 76468.45098100159],
[0.00000000003, 6.20945940475, 50160.82461135059],
[0.00000000003, 6.10137777265, 52164.76058288449],
[0.00000000003, 0.31852065143, 28632.57577846660],
[0.00000000003, 2.88816579373, 27360.58416720139],
[0.00000000003, 5.29083364884, 2751.54759969160],
[0.00000000003, 0.87901414893, 1699.27921650320],
[0.00000000003, 0.12942378280, 203375.74902421077],
[0.00000000003, 1.88640533644, 27353.47062020059],
[0.00000000003, 3.77660990144, 24787.07632336920],
[0.00000000003, 5.26339958526, 289185.69166150296],
[0.00000000003, 1.34477523795, 1169.58825140860],
[0.00000000003, 0.07928565452, 104241.40624507738],
[0.00000000003, 4.47916732925, 38634.38508065720],
[0.00000000004, 1.37420794262, 128857.55635958798],
[0.00000000003, 2.08343776186, 50476.52706664519],
[0.00000000003, 4.23656246406, 76358.24465978218],
[0.00000000003, 5.54498269246, 61921.12683900499],
[0.00000000003, 3.80268685478, 25384.26995695679],
[0.00000000003, 5.22182880098, 3462.24470586520],
[0.00000000003, 0.61479556097, 171292.65789271498],
[0.00000000003, 3.12135348664, 162810.49469943657],
[0.00000000003, 4.22351187737, 67608.75720795698],
[0.00000000003, 5.30037747699, 51554.06248230919],
[0.00000000003, 4.58024970278, 34102.10134449819],
[0.00000000003, 2.07639441349, 24072.23205541439],
[0.00000000003, 4.65503825059, 104874.18998439058],
[0.00000000003, 4.53866780815, 28908.73428570040],
[0.00000000003, 1.00191312140, 155460.92337225519],
[0.00000000003, 2.05553254051, 176332.24614102798],
[0.00000000003, 3.94870291510, 155475.15046625677],
[0.00000000003, 1.43273740893, 24719.24288872919],
[0.00000000003, 0.23823986548, 24510.55959912640],
[0.00000000003, 5.21326346293, 1639.06951718800],
[0.00000000003, 2.53461972944, 51861.62010327879],
[0.00000000003, 4.13978656372, 33917.99567300899],
[0.00000000003, 4.34295741397, 16964.32638655680],
[0.00000000003, 0.28015371448, 169093.57054942798],
[0.00000000003, 2.49492450438, 636.99627202420],
[0.00000000003, 4.20183911478, 149642.26895951436],
[0.00000000003, 0.73100534966, 35679.44488694599],
[0.00000000003, 1.18977971170, 143164.96914264598],
[0.00000000003, 1.17691552034, 52145.47942214399],
[0.00000000003, 4.94963823249, 49637.55777889479],
[0.00000000003, 3.00732745961, 24705.01579472759],
[0.00000000003, 5.76323456196, 49976.71893986139],
[0.00000000003, 4.83245208446, 156523.53751408719],
[0.00000000002, 3.69719041336, 24616.15011451060],
[0.00000000003, 0.18439316147, 78597.56536549199],
[0.00000000003, 4.98373933018, 102129.75593169978],
[0.00000000003, 0.02228487734, 1.48447270830],
[0.00000000003, 4.06250318984, 97466.46267636596],
[0.00000000003, 2.65726234287, 13705.85711308060],
[0.00000000002, 0.12883868680, 149756.70824819959],
[0.00000000003, 2.82299563379, 53132.09543911899],
[0.00000000003, 5.99061509510, 29864.33402730900],
[0.00000000003, 3.93018711070, 17098.43543614181],
[0.00000000002, 4.22698039366, 10681.25053656540],
[0.00000000002, 1.31889013785, 25572.43927048119],
[0.00000000002, 3.49816744164, 51092.72605085480],
[0.00000000003, 1.52361691660, 78265.19389743089],
[0.00000000003, 0.52188463522, 52277.76880141400],
[0.00000000003, 3.80600862869, 25124.50043860279],
[0.00000000003, 6.14366757538, 48153.54375118419],
[0.00000000002, 0.58190501461, 27573.88326263939],
[0.00000000003, 5.63901497713, 106470.37642667518],
[0.00000000002, 3.36639066096, 42430.48572729180],
[0.00000000003, 3.08628517069, 4083.98850670440],
[0.00000000002, 6.13024035669, 104035.22069664019],
[0.00000000003, 1.81280963372, 104401.60918820098],
[0.00000000003, 3.34404708133, 130020.03106399579],
[0.00000000002, 1.22333771717, 76094.94894243999],
[0.00000000002, 0.63542334090, 1485.29070670320],
[0.00000000003, 5.24568241255, 6885.14988993081],
[0.00000000003, 2.46305012048, 133882.09065283638],
[0.00000000002, 0.84094631125, 163766.09444104518],
[0.00000000003, 2.12660879166, 42790.96527507320],
[0.00000000002, 2.98805690719, 26235.98186600050],
[0.00000000003, 3.26197855217, 156531.30018480319],
[0.00000000002, 4.50734435605, 25248.93385382380],
[0.00000000002, 4.32859791317, 1685.05212250160],
[0.00000000002, 5.62335584014, 28213.78054895339],
[0.00000000002, 3.87492323552, 199599.31813847595],
[0.00000000002, 2.60597304148, 26713.57333388659],
[0.00000000003, 4.15733644316, 51688.17153189420],
[0.00000000003, 4.33101389874, 220025.88923089796],
[0.00000000002, 4.46567523081, 31127.49138988719],
[0.00000000002, 3.66265576771, 26397.18146422999],
[0.00000000002, 4.68312774052, 49850.85687433279],
[0.00000000002, 4.51215350981, 52812.80255517260],
[0.00000000003, 3.56621882535, 154408.65498906678],
[0.00000000002, 3.95708432187, 1574.84580128220],
[0.00000000002, 2.41940194318, 104668.00443595338],
[0.00000000003, 0.24921211552, 25778.62481891839],
[0.00000000002, 3.18370791629, 207114.15223730978],
[0.00000000002, 4.17768592199, 51734.98099827079],
[0.00000000002, 1.74283332135, 76532.58707178998],
[0.00000000002, 1.36339547692, 6044.22858137540],
[0.00000000002, 2.82219230315, 63786.35824152260],
[0.00000000002, 5.27165023098, 75085.56363415498],
[0.00000000002, 5.76735720320, 25661.99436506020],
[0.00000000002, 5.24666183170, 24734.15439655740],
[0.00000000002, 5.31625926462, 24998.19435038059],
[0.00000000002, 0.17868115875, 177287.84588263658],
[0.00000000003, 5.47127542511, 27388.72995977919],
[0.00000000002, 2.48055036253, 25543.98508247800],
[0.00000000002, 0.16253031708, 23113.29318696320],
[0.00000000003, 1.68453793975, 2703.61615467560],
[0.00000000002, 1.17069889009, 53551.58008299420],
[0.00000000003, 3.06893058902, 230239.17477710896],
[0.00000000003, 5.00145362139, 180496.55813064099],
[0.00000000002, 1.90098213386, 20272.79228193720],
[0.00000000003, 5.06877735444, 440.82528487760],
[0.00000000002, 1.33626564472, 196156.74319351057],
[0.00000000002, 4.50940380454, 65538.25598994759],
[0.00000000002, 4.55891488212, 2324.94940881560],
[0.00000000002, 0.21025125051, 18227.48374913500],
[0.00000000002, 0.58359043648, 156377.85565231058],
[0.00000000002, 4.57189351312, 26926.87242932459],
[0.00000000002, 3.79747475767, 65851.33653522459],
[0.00000000002, 0.30139015500, 50951.98844236979],
[0.00000000002, 3.94570007959, 225687.22128005016],
[0.00000000002, 0.99415397716, 2064.97829370200],
[0.00000000002, 3.49827019018, 78905.12298646157],
[0.00000000002, 4.16512398869, 24864.08530079559],
[0.00000000002, 0.47605198546, 107692.22499299659],
[0.00000000002, 0.02213914405, 197092.67317421938],
[0.00000000002, 0.35795159068, 104301.61594439259],
[0.00000000002, 2.54426644231, 249268.47945736776],
[0.00000000002, 0.35872697789, 25462.23294926180],
[0.00000000002, 0.03956368481, 24189.55192363460],
[0.00000000002, 2.00682967230, 28786.35458895140],
[0.00000000002, 1.64612572499, 40738.70289615879],
[0.00000000002, 1.77509184801, 22595.33157470459],
[0.00000000002, 1.93881159123, 78697.42116259939],
[0.00000000002, 1.06567957268, 21562.24796431520],
[0.00000000003, 4.58782698256, 156954.01704032118],
[0.00000000002, 0.84740706727, 24494.89809302729],
[0.00000000002, 5.98697403459, 283524.35961235073],
[0.00000000002, 4.02135788869, 26238.95081141709],
[0.00000000002, 3.98649649262, 24808.10856894620],
[0.00000000002, 3.06252327958, 57369.17334194619],
[0.00000000002, 6.10258403438, 78115.63070029629],
[0.00000000002, 0.19431714321, 55484.27217852879],
[0.00000000002, 4.26819419359, 90989.16285949759],
[0.00000000002, 2.94941610280, 22065.64060961000],
[0.00000000002, 4.53722544295, 52355.88341343300],
[0.00000000002, 1.97399498955, 430.53034413910],
[0.00000000002, 1.99872081555, 24932.54198416719],
[0.00000000002, 0.37032643194, 26500.27423844859],
[0.00000000002, 3.83480132336, 307.55762096960],
[0.00000000002, 5.81356382744, 51538.81001112419],
[0.00000000002, 6.20773606719, 49.99662190420],
[0.00000000002, 2.40589345998, 77929.85348395319],
[0.00000000002, 4.51719783127, 21067.98465416099],
[0.00000000002, 2.06311358499, 23233.26276766400],
[0.00000000002, 0.29430089395, 24765.22549404280],
[0.00000000002, 2.21513587213, 25675.53204469980],
[0.00000000002, 2.29291278322, 27410.58078910560],
[0.00000000002, 2.39356701559, 242985.40360737636],
[0.00000000002, 4.28957020884, 71378.55953479178],
[0.00000000002, 5.41199778568, 23704.71012679799],
[0.00000000002, 0.54252133289, 3.88133535800],
[0.00000000002, 5.88236623932, 52072.02409456780],
[0.00000000002, 5.78749542412, 78373.91574594198],
[0.00000000002, 5.69226787602, 51040.12941125520],
[0.00000000002, 4.42185841709, 93696.66034953119],
[0.00000000002, 5.15491529148, 78112.66175487968],
[0.00000000002, 2.30493903824, 27883.16158529519],
[0.00000000002, 5.53948896377, 87253.17713015496],
[0.00000000002, 4.75957265478, 52336.21365253320],
[0.00000000002, 6.08199781417, 18043.37807764579],
[0.00000000002, 0.73324052336, 25757.28417791599],
[0.00000000002, 0.91928644358, 52186.85198341230],
[0.00000000002, 3.22142261212, 104771.09721017198],
[0.00000000002, 2.01671301400, 46564.47085590040],
[0.00000000002, 4.39545799671, 41520.85406638280],
[0.00000000002, 2.52858429504, 26140.99929388859],
[0.00000000002, 2.07561943546, 53654.67285721279],
[0.00000000002, 0.08977124652, 25135.82651831460],
[0.00000000002, 1.67350036401, 66826.60603773296],
[0.00000000002, 4.57268426145, 158116.49174472898],
[0.00000000002, 2.84194927894, 78249.48233072099],
[0.00000000002, 3.07002924674, 23432.33476910039],
[0.00000000002, 4.11559657607, 123554.36581794015],
[0.00000000002, 0.05687800902, 26034.80698925980],
[0.00000000002, 4.28354458896, 24484.60315228879],
[0.00000000002, 3.24222429199, 21509.65132471559],
[0.00000000002, 2.52315832958, 210614.42461581076],
[0.00000000002, 4.44247371827, 148532.89040742096],
[0.00000000002, 0.11737800376, 146505.58156934578],
[0.00000000002, 2.41371362390, 54862.52837768960],
[0.00000000002, 4.66022680664, 247223.17092456557],
[0.00000000002, 3.79260774499, 3308.46589538040],
[0.00000000002, 5.83454304626, 2974.60995461100],
[0.00000000002, 5.37878500160, 77622.29586298359],
[0.00000000002, 1.63153524958, 99979.73619952259],
[0.00000000002, 5.18613735503, 50600.96048186620],
[0.00000000002, 2.55420547959, 76064.62208143558],
[0.00000000002, 4.05996888958, 24502.76239955349],
[0.00000000002, 2.47809526116, 179966.86716554638],
[0.00000000002, 1.25528265056, 50912.64892057020],
[0.00000000002, 0.75306774592, 235746.72801577636],
[0.00000000002, 2.97464643769, 31219.54422563180],
[0.00000000001, 0.17722772219, 158438.61833266239],
[0.00000000002, 4.94589808424, 168959.46149984296],
[0.00000000002, 0.63110575282, 415.55249061210],
[0.00000000001, 0.77799418557, 299398.97720771392],
[0.00000000002, 5.97867896248, 164721.69418265378],
[0.00000000002, 5.62955025847, 21819.80896338059],
[0.00000000001, 4.93638931294, 27993.36790651460],
[0.00000000002, 6.22578827437, 74935.57376844239],
[0.00000000002, 1.03965665113, 1802.37199072180],
[0.00000000001, 5.61994219678, 50690.51557644519],
[0.00000000002, 5.02281046549, 422.66603761290],
[0.00000000001, 3.57619837497, 209658.82487420218],
[0.00000000002, 0.11249539090, 38469.94917006779],
[0.00000000002, 0.62470424533, 51745.27593900929],
[0.00000000001, 0.71806518278, 28928.40404660019],
[0.00000000002, 3.91669753023, 76352.50994150538],
[0.00000000002, 3.05277164813, 225.82926841020],
[0.00000000001, 4.33602746737, 4601.95011896300],
], [
[0.00217347739, 4.65617158663, 26087.90314157420],
[0.00044141826, 1.42385543975, 52175.80628314840],
[0.00010094479, 4.47466326316, 78263.70942472259],
[0.00002432804, 1.24226083435, 104351.61256629678],
[0.00001624367, 0.00000000000, 0.00000000000],
[0.00000603996, 4.29303116561, 130439.51570787099],
[0.00000152851, 1.06060779810, 156527.41884944518],
[0.00000039202, 4.11136751416, 182615.32199101939],
[0.00000017760, 4.54424653085, 27197.28169366760],
[0.00000017999, 4.71193725810, 24978.52458948080],
[0.00000010154, 0.87893548494, 208703.22513259358],
[0.00000008086, 3.00540854890, 25028.52121138500],
[0.00000004444, 2.13639058123, 20426.57109242200],
[0.00000004393, 1.48074475165, 51066.42773105500],
[0.00000003510, 3.21171223697, 1059.38193018920],
[0.00000003133, 5.23846336855, 21535.94964451540],
[0.00000002650, 3.92968881423, 234791.12827416777],
[0.00000002498, 2.02623950395, 24498.83024629040],
[0.00000002011, 1.23911360588, 53285.18483524180],
[0.00000001963, 4.04524902962, 5661.33204915220],
[0.00000001546, 2.61849590442, 26617.59410666880],
[0.00000001542, 2.35659537465, 27043.50288318280],
[0.00000001417, 1.37876323533, 1109.37855209340],
[0.00000001295, 5.19094850935, 46514.47423399620],
[0.00000001241, 0.21246226135, 11322.66409830440],
[0.00000001090, 6.23733263925, 27147.28507176339],
[0.00000001271, 0.56437938715, 25132.30339996560],
[0.00000001120, 0.86374628388, 57837.13833230060],
[0.00000001005, 3.28272284427, 37410.56723987860],
[0.00000001177, 4.53194022227, 77154.33087262919],
[0.00000000841, 5.96261035419, 14765.23904326980],
[0.00000000935, 2.37277497611, 25661.30495069820],
[0.00000000742, 0.77751594919, 32858.61374281979],
[0.00000000736, 4.06885296570, 1589.07289528380],
[0.00000000712, 2.70884051645, 16983.99614745660],
[0.00000000863, 5.55308682281, 25558.21217647960],
[0.00000000707, 0.92992556568, 30639.85663863300],
[0.00000000696, 0.69734796212, 260879.03141574195],
[0.00000000678, 2.02193885930, 26068.23338067440],
[0.00000000608, 0.85708468483, 4551.95349705880],
[0.00000000546, 5.38138962861, 26091.78447693220],
[0.00000000608, 3.65993973133, 25448.00585526019],
[0.00000000597, 4.64867954048, 26080.78959457339],
[0.00000000572, 3.50125649521, 10213.28554621100],
[0.00000000515, 4.83662922562, 50586.73338786459],
[0.00000000532, 5.21855381213, 22645.32819660879],
[0.00000000572, 0.62751016416, 13521.75144159140],
[0.00000000516, 3.89421000089, 83925.04147387479],
[0.00000000507, 5.55466020276, 12566.15169998280],
[0.00000000606, 4.50215566301, 28306.66024576099],
[0.00000000533, 0.93587795381, 26107.57290247399],
[0.00000000435, 5.79043985706, 43071.89928903080],
[0.00000000436, 5.86659160961, 25035.63475838580],
[0.00000000429, 0.26260280461, 36301.18868778519],
[0.00000000472, 6.00507778421, 77204.32749453338],
[0.00000000443, 3.86758570847, 26084.02180621620],
[0.00000000487, 4.23950195756, 26095.01668857500],
[0.00000000406, 5.60324652352, 52705.49724824299],
[0.00000000523, 0.06439941262, 25021.40766438420],
[0.00000000379, 1.95647626585, 72602.37737557039],
[0.00000000390, 3.81996185881, 426.59819087600],
[0.00000000418, 2.77521418660, 41962.52073693740],
[0.00000000453, 0.72803137250, 529.69096509460],
[0.00000000358, 6.00165335616, 33326.57873317420],
[0.00000000347, 1.39524259509, 23969.13928119580],
[0.00000000340, 0.24111380317, 26301.20223701220],
[0.00000000325, 4.78747749132, 23869.14603738740],
[0.00000000290, 3.04044859601, 53235.18821333759],
[0.00000000326, 1.30033833957, 103242.23401420339],
[0.00000000316, 2.22791434675, 19317.19254032860],
[0.00000000264, 3.93160763696, 6770.71060124560],
[0.00000000332, 3.59235758173, 51220.20654153979],
[0.00000000223, 2.76528831516, 103292.23063610759],
[0.00000000215, 3.97996009773, 56727.75978020720],
[0.00000000235, 2.24050503260, 25874.60404613620],
[0.00000000215, 6.16660008496, 51646.11531805379],
[0.00000000208, 2.74551899929, 40853.14218484400],
[0.00000000204, 3.44654782597, 9103.90699411760],
[0.00000000197, 0.80026289238, 27676.97603685800],
[0.00000000205, 3.20844012088, 18849.22754997420],
[0.00000000196, 1.99924288764, 48733.23133818299],
[0.00000000218, 2.11865566044, 73711.75592766379],
[0.00000000189, 0.65681038131, 110012.94461544899],
[0.00000000207, 5.89082708705, 31749.23519072640],
[0.00000000184, 3.74837387583, 286966.93455731616],
[0.00000000174, 5.81264188702, 68050.42387851159],
[0.00000000163, 4.00380715262, 79373.08797681599],
[0.00000000152, 5.07389967152, 52156.13652224860],
[0.00000000151, 2.83369443311, 955.59974160860],
[0.00000000151, 0.40953650210, 26514.50133245020],
[0.00000000147, 2.32191248197, 38654.05484155699],
[0.00000000154, 3.26437373895, 38519.94579197200],
[0.00000000185, 0.98966099528, 29530.47808653960],
[0.00000000150, 3.69230644689, 65697.55772473979],
[0.00000000132, 2.71837382155, 77734.01845962799],
[0.00000000140, 2.05736044462, 6283.07584999140],
[0.00000000122, 3.31361750281, 62389.09182935939],
[0.00000000123, 2.07840148125, 25668.41849769900],
[0.00000000118, 0.51913709271, 51535.90899683439],
[0.00000000121, 2.15433834534, 52179.68761850640],
[0.00000000151, 2.66028539824, 25654.19140369739],
[0.00000000113, 2.33243126122, 78793.40038981718],
[0.00000000124, 3.13058661995, 51109.31080595839],
[0.00000000150, 2.60376479044, 639.89728631400],
[0.00000000123, 2.65137961558, 51123.53789995999],
[0.00000000106, 1.31393069594, 47623.85278608960],
[0.00000000112, 5.00798069297, 98690.28051714458],
[0.00000000107, 5.12738291017, 99799.65906923798],
[0.00000000123, 6.13795219131, 1066.49547719000],
[0.00000000106, 1.42997322881, 52168.69273614759],
[0.00000000104, 4.51477063494, 25234.70675982219],
[0.00000000120, 4.06567300860, 45892.73043315699],
[0.00000000092, 4.72811907093, 2118.76386037840],
[0.00000000112, 4.78983902693, 53131.40602475700],
[0.00000000096, 5.03438502363, 32370.97899156560],
[0.00000000091, 4.22099920434, 50057.04242277000],
[0.00000000091, 4.35481864546, 129330.13715577759],
[0.00000000106, 0.14583281261, 12432.04265039780],
[0.00000000084, 0.32848825294, 1052.26838318840],
[0.00000000084, 5.81442139422, 129380.13377768178],
[0.00000000093, 0.34539006564, 77308.10968311399],
[0.00000000078, 1.17633266287, 76674.63652943878],
[0.00000000107, 1.01316358023, 52182.91983014920],
[0.00000000082, 6.11445014523, 79323.09135491178],
[0.00000000085, 2.50332044483, 7238.67559160000],
[0.00000000072, 1.56170832500, 49957.04917896160],
[0.00000000076, 1.62577226881, 15874.61759536320],
[0.00000000091, 5.75408440781, 24491.71669928959],
[0.00000000092, 3.97747935513, 52195.47604404819],
[0.00000000068, 0.44378826429, 91785.46086631398],
[0.00000000078, 0.63585741399, 52171.92494779040],
[0.00000000064, 2.57311321703, 94138.32702008578],
[0.00000000065, 2.12942233842, 7.11354700080],
[0.00000000062, 3.70751240431, 136100.84775702319],
[0.00000000068, 1.18946361248, 54394.56338733519],
[0.00000000079, 3.35596277474, 52389.10537858640],
[0.00000000064, 5.09677055426, 51962.50718771040],
[0.00000000060, 6.25938912295, 24505.94379329119],
[0.00000000061, 0.73867692725, 82815.66292178139],
[0.00000000063, 1.29883580487, 2218.75710418680],
[0.00000000070, 5.28692696943, 45405.09568190280],
[0.00000000057, 1.92365363632, 20760.42703319140],
[0.00000000054, 0.89448628916, 71980.63357473118],
[0.00000000051, 4.71710385051, 105460.99111839019],
[0.00000000054, 6.22009952451, 44937.13069154840],
[0.00000000052, 3.43365769233, 25551.09862947879],
[0.00000000052, 5.77930503293, 66941.04532641819],
[0.00000000048, 0.51937745535, 313054.83769889036],
[0.00000000052, 5.71476972233, 103821.92160120218],
[0.00000000047, 3.82203240163, 53764.87917843220],
[0.00000000050, 5.76150579489, 25938.33994443960],
[0.00000000047, 5.52705163618, 77837.11123384659],
[0.00000000043, 5.84994474092, 63498.47038145279],
[0.00000000052, 2.63638299982, 18093.37469954999],
[0.00000000042, 5.39178421925, 64741.95798313119],
[0.00000000041, 1.87113963554, 125887.56221081219],
[0.00000000045, 4.04603530632, 55618.38122811380],
[0.00000000039, 3.50934954924, 52602.40447402440],
[0.00000000048, 0.72400634326, 33967.99229491319],
[0.00000000051, 6.02427997984, 13655.86049117640],
[0.00000000038, 0.09359107033, 88476.99497093359],
[0.00000000038, 1.84297739511, 78244.03966382280],
[0.00000000041, 5.74927951755, 26727.80042788820],
[0.00000000045, 5.73633413733, 44181.27784112419],
[0.00000000035, 0.81793649503, 23439.44831610119],
[0.00000000038, 5.17914668407, 23754.70674870219],
[0.00000000036, 4.81782090538, 51116.42435295920],
[0.00000000041, 2.91943000674, 26241.68195205900],
[0.00000000032, 1.91760062435, 58458.88213313979],
[0.00000000033, 1.27507180487, 131548.89425996438],
[0.00000000032, 5.01820692941, 46848.33017476560],
[0.00000000030, 3.95444605179, 26555.86813192860],
[0.00000000031, 1.17911028239, 59414.48187474840],
[0.00000000030, 0.55604674983, 3442.57494496540],
[0.00000000034, 3.55745328485, 433.71173787680],
[0.00000000033, 5.36229697065, 104881.30353139139],
[0.00000000030, 1.24209931344, 26202.34243025941],
[0.00000000033, 3.55673853222, 25440.89230825939],
[0.00000000029, 2.98847901150, 27154.39861876420],
[0.00000000035, 3.23888704617, 25455.11940226100],
[0.00000000033, 1.77322555881, 124778.18365871879],
[0.00000000028, 4.35951220773, 80482.46652890938],
[0.00000000030, 5.14555074991, 51756.32163927320],
[0.00000000029, 0.03524298861, 79219.30916633119],
[0.00000000027, 2.59555966553, 155468.03691925599],
[0.00000000027, 1.05480537311, 28421.09953444620],
[0.00000000030, 5.72087736840, 51742.09454527159],
[0.00000000029, 5.20529460359, 78267.59076008058],
[0.00000000026, 1.11551342052, 155418.04029735178],
[0.00000000030, 6.10884155937, 26011.63707029860],
[0.00000000027, 3.38666053174, 103396.01282468818],
[0.00000000025, 3.48592449926, 117873.36400788819],
[0.00000000025, 1.69043243445, 25973.46385288896],
[0.00000000026, 6.19577940400, 77197.21394753258],
[0.00000000024, 1.47972864008, 28206.66700195260],
[0.00000000023, 3.86767325148, 16066.06586147480],
[0.00000000027, 4.06858086478, 78270.82297172339],
[0.00000000022, 4.03528313026, 419.48464387520],
[0.00000000023, 3.38426107540, 58946.51688439399],
[0.00000000022, 1.33669336918, 51322.60990139639],
[0.00000000023, 2.23954141042, 103925.01437542078],
[0.00000000024, 3.65673385174, 26610.48055966799],
[0.00000000021, 4.49565014938, 78256.59587772179],
[0.00000000021, 3.69266624882, 77623.81213840858],
[0.00000000028, 5.71652736884, 77211.44104153418],
[0.00000000021, 3.97119771059, 98068.53671630539],
[0.00000000021, 5.61140929496, 120226.23016165999],
[0.00000000025, 1.73460075205, 853.19638175200],
[0.00000000024, 2.89897553229, 105410.99449648599],
[0.00000000020, 6.15988447425, 213.29909543800],
[0.00000000021, 0.42126764910, 149.56319713460],
[0.00000000020, 4.41588880947, 29416.03879785439],
[0.00000000024, 2.43220296378, 50579.61984086379],
[0.00000000020, 0.47739908961, 162188.75089859738],
[0.00000000021, 0.18110422167, 35191.81013569180],
[0.00000000019, 2.38756251160, 26037.90651966999],
[0.00000000020, 0.61997291259, 85034.42002596818],
[0.00000000018, 4.60331561584, 76044.95232053580],
[0.00000000018, 3.06180224259, 50593.84693486539],
[0.00000000022, 0.45787269756, 1596.18644228460],
[0.00000000019, 1.76795970776, 78050.41032928458],
[0.00000000019, 3.58333941723, 27140.17152476259],
[0.00000000021, 0.15585183693, 78477.00852016058],
[0.00000000018, 1.81330190957, 25565.32572348040],
[0.00000000021, 3.45385724015, 102762.53967101299],
[0.00000000022, 4.62891777236, 19406.67828817460],
[0.00000000019, 5.28998871939, 26624.70765366959],
[0.00000000016, 4.37908924360, 25131.61398560359],
[0.00000000019, 2.69598918032, 105307.21230790539],
[0.00000000018, 4.13274028026, 5327.47610838280],
[0.00000000018, 1.10819559505, 76144.94556434419],
[0.00000000018, 2.04678515653, 71492.99882347698],
[0.00000000015, 0.52406345582, 42153.96900304900],
[0.00000000018, 0.71897799959, 78283.37918562238],
[0.00000000020, 3.87105632280, 51749.20809227239],
[0.00000000014, 0.06732488000, 25984.81036735560],
[0.00000000019, 2.51337817026, 129909.82474277639],
[0.00000000018, 3.79705759661, 108903.56606335558],
[0.00000000014, 2.30467577173, 18207.81398823521],
[0.00000000014, 4.91192145857, 151975.46535238638],
[0.00000000014, 4.25365079026, 157636.79740153858],
[0.00000000014, 3.82494343251, 7880.08915333899],
[0.00000000014, 0.47442483304, 26137.89976347840],
[0.00000000015, 1.41820144369, 40565.25432477420],
[0.00000000016, 1.92985195149, 49842.60989027639],
[0.00000000016, 2.97241905198, 71025.03383312259],
[0.00000000013, 0.07086712207, 76.26607127560],
[0.00000000013, 2.19019855275, 90829.86112470538],
[0.00000000014, 1.68395491426, 6681.22485339960],
[0.00000000012, 2.16242752229, 29428.51556827400],
[0.00000000013, 0.55373605944, 79852.78232000639],
[0.00000000012, 2.10236188465, 24609.03656750980],
[0.00000000012, 3.49372354820, 64607.84893354619],
[0.00000000013, 3.16312334997, 25881.71759313700],
[0.00000000012, 0.32301447482, 78690.30761559859],
[0.00000000016, 3.67591976897, 78259.82808936459],
[0.00000000012, 0.81060544329, 81706.28436968799],
[0.00000000015, 2.57802360273, 93028.94846799239],
[0.00000000013, 3.55704873434, 339142.74084046457],
[0.00000000012, 3.14169564714, 114564.89811250778],
[0.00000000011, 4.96251639039, 84546.78527471398],
[0.00000000011, 2.93160493628, 536.80451209540],
[0.00000000011, 0.04474275203, 19804.82729158280],
[0.00000000011, 2.39391294657, 10021.83728009940],
[0.00000000011, 3.22530161123, 90695.75207512038],
[0.00000000012, 0.71785378975, 26294.08869001139],
[0.00000000011, 3.51130712506, 7994.52844202420],
[0.00000000011, 1.78813511249, 69159.80243060499],
[0.00000000010, 1.89377082198, 24925.42843716640],
[0.00000000012, 6.06775243662, 52329.58509363319],
[0.00000000012, 0.11656433296, 51543.02254383520],
[0.00000000012, 0.01462307671, 1581.95934828300],
[0.00000000010, 3.60476399042, 49527.35145767539],
[0.00000000009, 5.35498571113, 2648.45482547300],
[0.00000000010, 2.54352513591, 52815.70356946240],
[0.00000000009, 5.25498849885, 130012.91751699499],
[0.00000000010, 5.63770719377, 181555.94006083018],
[0.00000000011, 1.65385601347, 26507.38778544939],
[0.00000000011, 4.93008131424, 104331.94280539699],
[0.00000000010, 0.35445064092, 26521.61487945100],
[0.00000000010, 2.79303258728, 39743.76363275060],
[0.00000000009, 0.71144667758, 25764.39772491679],
[0.00000000008, 4.22951187793, 181505.94343892598],
[0.00000000008, 0.17514303190, 129483.91596626239],
[0.00000000010, 1.16786157884, 25934.12433108940],
[0.00000000010, 2.50335300453, 103299.34418310839],
[0.00000000009, 3.18692590406, 39629.32434406539],
[0.00000000010, 3.98242351264, 522.57741809380],
[0.00000000011, 0.23158217376, 51639.00177105299],
[0.00000000009, 0.30008658313, 27999.10262479140],
[0.00000000011, 4.84801040284, 150866.08680029298],
[0.00000000011, 5.94731028211, 38813.35657634920],
[0.00000000008, 4.66199260294, 26094.53170047421],
[0.00000000008, 0.71995165086, 52643.77127350280],
[0.00000000008, 3.31825277790, 24395.73747207180],
[0.00000000008, 2.52932369592, 26190.99591579279],
[0.00000000008, 5.11541081184, 25619.93815121980],
[0.00000000008, 1.18625312267, 25867.49049913539],
[0.00000000008, 0.31593558687, 51528.79544983359],
[0.00000000010, 2.12019897039, 130969.20667296558],
[0.00000000008, 0.24131547257, 143961.26714946238],
[0.00000000007, 5.90865595918, 23976.25282819660],
[0.00000000008, 4.88221803127, 22759.76748529401],
[0.00000000007, 3.17202081415, 632.78373931320],
[0.00000000008, 2.40875907837, 146314.13330323418],
[0.00000000007, 6.03640433343, 53242.30176033840],
[0.00000000007, 0.86406939215, 104358.72611329758],
[0.00000000007, 3.45761762182, 26237.46633870879],
[0.00000000009, 3.30628597530, 12725.45343477500],
[0.00000000007, 0.74174993099, 124156.43985787958],
[0.00000000008, 5.62600154280, 131395.11544947959],
[0.00000000007, 2.52679818243, 77829.99768684579],
[0.00000000008, 1.93255904016, 77844.22478084739],
[0.00000000007, 3.69439677930, 85502.38501632259],
[0.00000000007, 5.14299105203, 35472.74414964940],
[0.00000000008, 1.52116219771, 26081.27458267419],
[0.00000000008, 3.50246944455, 25863.55834587229],
[0.00000000008, 5.17598738878, 23962.02573419499],
[0.00000000009, 2.01720755803, 104355.49390165479],
[0.00000000007, 0.57777174711, 86143.79857806159],
[0.00000000007, 2.03534300720, 100909.03762133139],
[0.00000000006, 3.30402834266, 104564.91166173479],
[0.00000000006, 5.26635186541, 50696.93970908399],
[0.00000000006, 3.60993601694, 27684.08958385880],
[0.00000000008, 5.97157930225, 131498.89763806018],
[0.00000000006, 4.43204136420, 54294.57014352679],
[0.00000000006, 4.16183734880, 54509.00267602040],
[0.00000000007, 4.35729742194, 52290.24557183361],
[0.00000000007, 4.88364528875, 26941.09952332620],
[0.00000000007, 3.84735933689, 34282.17847478280],
[0.00000000006, 0.71889591582, 89586.37352302698],
[0.00000000006, 4.77410201490, 104138.31347085879],
[0.00000000006, 5.81016662275, 70269.18098269838],
[0.00000000007, 3.59164938122, 188276.65404017158],
[0.00000000006, 1.42397911026, 102132.85546210999],
[0.00000000006, 5.15043168056, 97580.90196505119],
[0.00000000008, 2.67404385604, 647.01083331480],
[0.00000000005, 4.58227258685, 25977.69682035479],
[0.00000000007, 6.18437842544, 128850.44281258718],
[0.00000000005, 0.05338946228, 13541.42120249119],
[0.00000000006, 5.55589010148, 155997.72788435058],
[0.00000000005, 5.54731935938, 96357.08412427259],
[0.00000000006, 0.36201698821, 26308.31578401300],
[0.00000000005, 3.05584811656, 103285.11708910679],
[0.00000000005, 4.80319811501, 51013.33157874059],
[0.00000000006, 3.04691542636, 13362.44970679920],
[0.00000000005, 5.59905054438, 76667.52298243798],
[0.00000000005, 3.15313951574, 26164.16921284980],
[0.00000000006, 1.15194666645, 27311.72098235281],
[0.00000000005, 6.16463589751, 76681.75007643958],
[0.00000000005, 2.77667883666, 224.34479570190],
[0.00000000005, 4.27775147717, 14477.35118320000],
[0.00000000005, 5.50743820134, 52125.80966124419],
[0.00000000006, 0.68838699976, 26720.68688088739],
[0.00000000005, 4.44878671847, 25227.59321282139],
[0.00000000005, 4.88707969684, 52061.36699446317],
[0.00000000005, 3.66186576821, 25241.82030682300],
[0.00000000005, 1.76383923429, 178063.36849396059],
[0.00000000005, 3.09083817171, 115674.27666460119],
[0.00000000005, 1.73277038612, 956.28915597060],
[0.00000000006, 0.59128664983, 134991.46920492979],
[0.00000000005, 1.39435703220, 104344.49901929598],
[0.00000000005, 5.66016557162, 45290.65639321759],
[0.00000000005, 2.69362119172, 50064.15596977079],
[0.00000000005, 4.11526724305, 209812.60368468695],
[0.00000000006, 3.72633598860, 26162.68474014150],
[0.00000000004, 1.01205356829, 183724.70054311278],
[0.00000000005, 2.02484630372, 52712.61079524379],
[0.00000000005, 4.47460304849, 77410.51304297059],
[0.00000000005, 0.42971081835, 52698.38370124219],
[0.00000000005, 1.56442459236, 11610.55195837420],
[0.00000000004, 0.62582613574, 22747.29071487440],
[0.00000000004, 1.51592730997, 66653.15746634839],
[0.00000000005, 6.10277243405, 97112.93697469679],
[0.00000000004, 1.00562353481, 51219.51712717779],
[0.00000000004, 0.31906550066, 48835.19385644859],
[0.00000000005, 4.98644771495, 51653.22886505459],
[0.00000000005, 4.34429010560, 32132.13172294960],
[0.00000000004, 2.92125579020, 78417.48823520739],
[0.00000000004, 5.99601868842, 121335.60871375339],
[0.00000000005, 3.13172791066, 61279.71327726600],
[0.00000000005, 2.13824746365, 39609.65458316560],
[0.00000000005, 5.68604378667, 119116.85160956658],
[0.00000000004, 2.73202591375, 1692.16566950240],
[0.00000000004, 5.78251523942, 26734.91397488900],
[0.00000000005, 0.77777359038, 103711.71527998279],
[0.00000000005, 0.91021434517, 71582.48457132299],
[0.00000000004, 3.03035393128, 52072.71350892979],
[0.00000000004, 0.45156085724, 31415.37924995700],
[0.00000000004, 3.93028686443, 104371.28232719658],
[0.00000000004, 4.54919541216, 26198.10946279360],
[0.00000000004, 2.66986199617, 24176.70365835700],
[0.00000000004, 3.50110688244, 74821.13447975718],
[0.00000000004, 5.75284691398, 25138.72753260440],
[0.00000000004, 5.44367911308, 72936.23331633979],
[0.00000000004, 1.60493978664, 176953.98994186718],
[0.00000000004, 1.93554854399, 50049.92887576919],
[0.00000000003, 3.90053130991, 107794.18751126219],
[0.00000000003, 5.45429683058, 44295.71712980940],
[0.00000000004, 0.60054840458, 104347.73123093879],
[0.00000000004, 0.88305624488, 60055.89543648739],
[0.00000000004, 6.20681068925, 140652.80125408198],
[0.00000000003, 1.44572212087, 130226.21661243298],
[0.00000000004, 4.37750242770, 32769.12799497380],
[0.00000000004, 1.75525459469, 110634.68841628819],
[0.00000000003, 0.66980197410, 26222.01219115920],
[0.00000000004, 2.20364417845, 182085.63102592478],
[0.00000000003, 5.60615263810, 129387.24732468258],
[0.00000000003, 0.96551693568, 207593.84658050018],
[0.00000000004, 4.51472339809, 52169.17772424839],
[0.00000000004, 0.86790293541, 24822.33566294780],
[0.00000000003, 2.05745330337, 156100.82065856918],
[0.00000000004, 0.27139822027, 214364.55718174578],
[0.00000000003, 3.63958954831, 102232.84870591838],
[0.00000000003, 3.33824382272, 170049.17029103659],
[0.00000000003, 6.15959485239, 12546.48193908300],
[0.00000000003, 0.54712514364, 1911.19948321720],
[0.00000000003, 5.53215106225, 323.50541665740],
[0.00000000003, 5.78740917576, 27780.06881107659],
[0.00000000004, 3.60062257669, 105940.68546158058],
[0.00000000003, 5.23668974633, 17893.62780836560],
[0.00000000003, 3.21536557308, 155571.81910783658],
[0.00000000004, 3.78439308193, 68241.87214462319],
[0.00000000004, 0.35026324282, 53228.07466633679],
[0.00000000003, 1.39462627029, 110.20632121940],
[0.00000000003, 2.98585442540, 102769.65321801379],
[0.00000000003, 5.54914760118, 52101.02468458109],
[0.00000000004, 5.31358771393, 116917.76426627958],
[0.00000000004, 5.02170245911, 130443.39704322898],
[0.00000000003, 3.39708771017, 104778.21075717278],
[0.00000000003, 1.35333080979, 52182.43484204840],
[0.00000000003, 3.53872943291, 28791.51929624980],
[0.00000000003, 0.32151031474, 75615.25459924959],
[0.00000000003, 2.81736551277, 78187.44335344699],
[0.00000000003, 3.41370464721, 77616.69859140778],
[0.00000000003, 2.72102083462, 157586.80077963437],
[0.00000000004, 0.37990458940, 365230.64398203876],
[0.00000000003, 5.29398694468, 183570.92173262799],
[0.00000000003, 0.53039476474, 35077.37084700659],
[0.00000000003, 0.96990585284, 25780.34552060460],
[0.00000000004, 5.03799187214, 103932.12792242158],
[0.00000000003, 0.57063116288, 52250.58788171570],
[0.00000000003, 4.90694398172, 27044.19229754480],
[0.00000000003, 5.64342324025, 78903.60671103658],
[0.00000000003, 3.90829945174, 130446.62925487179],
[0.00000000004, 5.39121442451, 52022.02747266360],
[0.00000000003, 5.38325956945, 172402.03644480839],
[0.00000000003, 3.62725946038, 161079.37234650398],
[0.00000000003, 0.02159890719, 130652.81480330898],
[0.00000000003, 5.26052772975, 55516.41870984820],
[0.00000000003, 1.45533607551, 77101.23472031478],
[0.00000000003, 2.45621582046, 207643.84320240439],
[0.00000000003, 3.04264756378, 74923.09699802278],
[0.00000000003, 3.27797530359, 27669.86248985719],
[0.00000000004, 6.20795181771, 3340.61242669980],
[0.00000000003, 2.86818821459, 79330.20490191258],
[0.00000000003, 5.42245453158, 36109.74042167360],
[0.00000000003, 1.11238018002, 2125.87740737920],
[0.00000000003, 4.70325749301, 52595.29092702359],
[0.00000000003, 4.14290639481, 25446.48957983520],
[0.00000000003, 4.11874155864, 1478.86657406440],
[0.00000000003, 4.41727880469, 128220.75860368418],
[0.00000000003, 5.84301330450, 65831.66677432480],
[0.00000000003, 0.63458746349, 112231.70171963578],
[0.00000000003, 5.20358469660, 157057.10981453978],
[0.00000000003, 4.22446997246, 53399.62412392700],
[0.00000000003, 6.08145059717, 26724.89941359840],
[0.00000000003, 3.32246989691, 111122.32316754239],
[0.00000000003, 1.11208497752, 78378.14871340781],
[0.00000000003, 1.18205388535, 80382.47328510099],
[0.00000000003, 3.98183946807, 25352.02662804239],
[0.00000000003, 5.17537238750, 225687.22128005016],
[0.00000000002, 3.19970010923, 64901.25971792339],
[0.00000000003, 5.90368046078, 104505.39137678158],
[0.00000000003, 2.15712281571, 28736.35796704720],
[0.00000000002, 0.27988699718, 52325.36948028299],
[0.00000000002, 1.09392137734, 24998.19435038059],
[0.00000000003, 1.72654636472, 130419.84594697120],
[0.00000000003, 6.24477199702, 51969.62073471119],
[0.00000000003, 3.27154613105, 77630.92568540938],
[0.00000000002, 1.80684819652, 123668.80510662538],
[0.00000000002, 3.75304905922, 150244.34299945379],
[0.00000000003, 2.04107819596, 76784.84285065818],
[0.00000000003, 4.07589828594, 97670.38771289718],
[0.00000000002, 3.43439078149, 52609.51802102519],
[0.00000000002, 0.51530246334, 133882.09065283638],
[0.00000000003, 4.75031746198, 204151.27163553478],
[0.00000000002, 5.57618391474, 24292.64469785319],
[0.00000000002, 2.22207407093, 78213.71280281838],
[0.00000000002, 6.08590562625, 39450.35284837340],
[0.00000000003, 4.42541702442, 51955.39364070959],
[0.00000000003, 5.48323931966, 220.41264243880],
[0.00000000003, 5.24728665819, 26709.64694241340],
[0.00000000003, 4.52126286883, 20043.67456019880],
[0.00000000002, 1.69429787369, 53029.00266490040],
[0.00000000003, 0.98781948776, 80596.90581759460],
[0.00000000002, 2.72291536990, 23866.04650697719],
[0.00000000002, 2.23117481869, 26402.08932144380],
[0.00000000003, 2.32561622864, 145204.75475114079],
[0.00000000003, 3.55406019317, 52225.80290505260],
[0.00000000003, 0.82939608505, 87253.17713015496],
[0.00000000003, 3.59850686303, 52396.21892558720],
[0.00000000002, 0.25549281668, 22909.75735100660],
[0.00000000002, 4.18932113589, 81591.84508100279],
[0.00000000002, 5.58984236569, 104202.04936916218],
[0.00000000002, 1.59325428260, 206.18554843720],
[0.00000000002, 2.33240745085, 157483.01859105378],
[0.00000000002, 3.78499822852, 78731.67441507700],
[0.00000000003, 1.73139148586, 77741.13200662879],
[0.00000000002, 1.98761216006, 102018.41617342478],
[0.00000000002, 3.82447809654, 1162.47470440780],
[0.00000000002, 3.73613869026, 24601.92302050899],
[0.00000000002, 4.87002033008, 51859.41441349179],
[0.00000000002, 0.10623356446, 111590.28815789679],
[0.00000000002, 4.43911582586, 78270.33798362259],
[0.00000000002, 2.47821765975, 78114.14622758799],
[0.00000000002, 5.83346201740, 181026.24909573558],
[0.00000000002, 2.27341561267, 25953.79409198919],
[0.00000000002, 2.73852323809, 123200.84011627098],
[0.00000000002, 2.35063735347, 78109.93061423779],
[0.00000000002, 0.45168929332, 2111.65031337760],
[0.00000000002, 4.46926491505, 25450.90686955000],
[0.00000000002, 3.97278244291, 52808.59002246159],
[0.00000000002, 0.58667782465, 128320.75184749259],
[0.00000000002, 3.05065649587, 102755.42612401219],
[0.00000000002, 1.13486054740, 52492.19815280499],
[0.00000000002, 4.64642529286, 60370.08161635699],
[0.00000000002, 3.68035435205, 52309.91533273340],
[0.00000000002, 5.93910800197, 78160.61665050399],
[0.00000000002, 1.26706232000, 58857.03113654799],
[0.00000000002, 5.09637370849, 26823.77965510599],
[0.00000000002, 3.88808196008, 16703.06213349900],
[0.00000000002, 0.00715741623, 130866.11389874699],
[0.00000000002, 3.63338095338, 51852.30086649099],
[0.00000000002, 5.67927933196, 103917.90082841998],
[0.00000000002, 1.35964203538, 3328.13565628019],
[0.00000000002, 6.13531665590, 129373.02023068098],
[0.00000000002, 3.74140255139, 52381.99183158559],
[0.00000000002, 0.37783717379, 53771.99272543299],
[0.00000000002, 0.70779949763, 26667.59072857300],
[0.00000000002, 2.05372686428, 70383.62027138360],
[0.00000000002, 6.06999395703, 23919.14265929160],
[0.00000000002, 1.22493486348, 103498.41618454478],
[0.00000000002, 4.00058813480, 129799.61842155698],
[0.00000000002, 1.62085169147, 78149.27013603736],
[0.00000000002, 1.81898501228, 25771.51127191760],
[0.00000000002, 6.22451796390, 52252.07235442399],
[0.00000000002, 0.20849484282, 25754.04720080480],
[0.00000000002, 2.38916713246, 51226.63067417859],
[0.00000000002, 4.34697979051, 26404.29501123080],
[0.00000000002, 2.87638496001, 167850.08294774959],
[0.00000000002, 4.01638193690, 51868.24866217880],
[0.00000000002, 3.38565068956, 77726.90491262719],
[0.00000000002, 5.73512271075, 189853.99758261938],
[0.00000000002, 3.93444553575, 50910.23880452200],
[0.00000000002, 3.62039658007, 6885.14988993081],
[0.00000000002, 1.76492939350, 92741.06060792258],
[0.00000000002, 2.58190149030, 154938.34595416138],
[0.00000000002, 5.37279792857, 52278.89905736699],
[0.00000000002, 3.37039086197, 2221.85663459700],
[0.00000000002, 6.07737780217, 94329.77528619739],
[0.00000000002, 5.16106622649, 26729.31670331319],
[0.00000000002, 1.58212922198, 26013.12154300690],
[0.00000000002, 5.77714525422, 25600.26839032000],
[0.00000000002, 1.88481234244, 27177.61193276780],
[0.00000000002, 5.68695965343, 50264.60679993120],
[0.00000000002, 6.07601531670, 141762.17980617538],
[0.00000000002, 4.33545610317, 8194.27533320860],
[0.00000000002, 1.10189365852, 1223.81784077861],
[0.00000000002, 1.68048369897, 27250.37784598199],
[0.00000000002, 5.32044002117, 151199.94274106238],
[0.00000000002, 1.33411828477, 78257.08086582259],
[0.00000000002, 5.40842531044, 95247.70557217918],
[0.00000000002, 4.55349965747, 37698.45509994840],
[0.00000000002, 2.71889214634, 173511.41499690177],
[0.00000000002, 1.95076646341, 143005.66740785378],
[0.00000000002, 2.00346690661, 26073.67604757259],
[0.00000000002, 1.78781584986, 48847.67062686820],
[0.00000000002, 5.89586766332, 26312.24793727610],
[0.00000000002, 1.99160321093, 26189.86565983980],
[0.00000000002, 0.40598906242, 25773.71696170459],
[0.00000000002, 3.36946627953, 26575.53789282839],
[0.00000000002, 4.77845331095, 136722.59155786238],
[0.00000000002, 1.11920130054, 51315.49635439559],
[0.00000000002, 4.99966961564, 78800.51393681798],
[0.00000000002, 2.50164995664, 19202.75325164339],
[0.00000000002, 5.31192385841, 23384.28698689860],
[0.00000000002, 2.93563622378, 137678.19129947099],
[0.00000000002, 5.00974264854, 182188.72380014337],
[0.00000000002, 2.82066370220, 118828.96374949679],
[0.00000000002, 1.23355180586, 52286.01260436779],
[0.00000000002, 0.27866926000, 24356.78078864160],
[0.00000000002, 2.19163720361, 26395.46076254379],
[0.00000000002, 2.41579406356, 147423.51185532758],
[0.00000000002, 1.80661945912, 860.30992875280],
[0.00000000001, 3.75687703582, 34082.43158359840],
[0.00000000001, 5.85918351804, 163766.09444104518],
[0.00000000001, 4.84627694564, 27170.98337386779],
[0.00000000002, 3.12958128871, 195047.36464141717],
[0.00000000002, 0.59313712363, 74.78159856730],
[0.00000000002, 4.60111717878, 25004.82290928060],
[0.00000000001, 1.14751201091, 55503.94193942859],
[0.00000000002, 4.55507467591, 132658.27281205778],
[0.00000000001, 1.61844283111, 24079.34560241519],
[0.00000000002, 1.99970840056, 17098.43543614181],
[0.00000000002, 4.95650007002, 24448.83362438620],
[0.00000000001, 6.20512620421, 2333.19639287200],
[0.00000000002, 1.27464400058, 144916.86689107098],
[0.00000000002, 6.17677089224, 87367.61641884019],
[0.00000000001, 1.29983905478, 154194.22245657316],
[0.00000000002, 4.47232796046, 130432.40216087017],
[0.00000000001, 4.48574397522, 101703.15774082378],
[0.00000000002, 2.19277171383, 103.09277421860],
[0.00000000001, 1.80796273878, 25508.21555457540],
[0.00000000001, 5.48664013700, 22625.65843570900],
[0.00000000001, 0.74294839995, 78896.49316403578],
[0.00000000001, 3.51165251141, 26421.75908234360],
[0.00000000001, 5.55668995710, 220025.88923089796],
[0.00000000002, 4.08809950869, 25466.15934073500],
[0.00000000002, 2.89128653047, 166740.70439565618],
[0.00000000001, 3.92791860433, 189386.03259226495],
[0.00000000001, 0.33128467520, 76571.54375522019],
[0.00000000002, 1.98187462633, 81604.32185142238],
[0.00000000001, 3.57210475329, 78786.28684281638],
[0.00000000002, 1.13879447241, 61165.27398858079],
[0.00000000001, 5.62721081889, 122444.98726584678],
[0.00000000001, 0.51173156424, 113341.08027172917],
[0.00000000001, 0.63238768568, 130459.18546877075],
[0.00000000001, 0.62172861766, 138319.60486120995],
[0.00000000002, 0.35135879351, 132028.58860315479],
[0.00000000001, 1.68473271541, 28286.99048486120],
[0.00000000002, 2.61859360479, 61560.64729122359],
[0.00000000001, 3.42727473387, 130435.63437251298],
[0.00000000002, 3.42836265136, 65717.22748563958],
[0.00000000001, 2.98248327032, 846.08283475120],
[0.00000000001, 5.35146960556, 1265.56747862640],
[0.00000000001, 4.88379701920, 205260.65018762815],
[0.00000000001, 1.38681194099, 467.96499035440],
[0.00000000001, 5.78967137689, 76152.05911134499],
[0.00000000001, 1.64625172020, 75930.51303185058],
[0.00000000001, 0.08732855602, 103718.82882698359],
[0.00000000001, 0.74831854153, 51534.39272140940],
[0.00000000001, 1.98744571247, 26411.40855823160],
[0.00000000002, 0.58716824437, 52065.59996192899],
[0.00000000001, 5.83388253183, 104275.34649502118],
[0.00000000001, 2.07307900948, 78188.92782615528],
[0.00000000001, 4.54379329814, 203041.89308344138],
[0.00000000001, 3.67961974137, 116783.65521669458],
[0.00000000001, 2.76419827660, 52812.80255517260],
[0.00000000001, 5.76246998806, 1375.77379984580],
[0.00000000001, 3.49542841313, 79315.97780791098],
[0.00000000001, 3.09408892186, 9384.84100807520],
[0.00000000002, 2.99230815235, 91805.13062721379],
[0.00000000001, 2.31818985780, 58220.03486452380],
[0.00000000001, 2.52061585089, 91919.56991589899],
[0.00000000001, 0.20823485438, 54879.42243782400],
[0.00000000001, 4.44457464944, 6044.22858137540],
[0.00000000001, 0.49331056411, 104819.57755665119],
[0.00000000001, 5.98062907857, 106570.36967048359],
[0.00000000001, 3.43578051874, 51841.95034237900],
[0.00000000001, 1.50478057782, 137210.22630911658],
[0.00000000001, 0.85871789181, 25985.94062330859],
[0.00000000001, 0.00464768227, 196137.07343261078],
[0.00000000001, 4.31601888279, 50483.64061364600],
[0.00000000001, 3.82192552665, 25928.60140678200],
[0.00000000001, 2.13422641639, 62197.64356324779],
[0.00000000001, 0.26342054765, 1795.25844372100],
[0.00000000001, 3.33069384141, 19.66976089979],
[0.00000000001, 5.04672208460, 26247.20487636640],
[0.00000000001, 3.69091550110, 77307.42026875199],
[0.00000000001, 0.68629642431, 26102.13023557580],
[0.00000000001, 5.61963025660, 104197.83375581198],
[0.00000000001, 0.41026701894, 636.99627202420],
[0.00000000001, 2.73690252229, 170068.84005193636],
[0.00000000001, 2.97981003623, 78057.52387628538],
[0.00000000001, 2.84174115238, 168959.46149984296],
[0.00000000001, 6.19695864555, 241561.83887541336],
[0.00000000001, 2.31427972623, 179172.74704605396],
[0.00000000001, 0.82072277702, 51329.72344839720],
[0.00000000001, 5.23954201903, 99024.13645791399],
[0.00000000001, 1.86269361791, 45494.58142974879],
[0.00000000001, 3.54450921353, 78338.49102328988],
[0.00000000001, 4.60745432488, 156507.74908854539],
[0.00000000001, 1.62346464256, 128106.31931499895],
[0.00000000001, 0.72186155433, 27005.83342755599],
[0.00000000001, 2.30344666604, 50380.54783942739],
[0.00000000001, 1.18658609813, 8989.46770543239],
[0.00000000001, 6.25857682168, 50800.03248330259],
[0.00000000001, 0.99962008973, 163298.12945069079],
[0.00000000001, 2.86790873835, 38634.38508065720],
[0.00000000001, 3.61827980669, 106262.81204951399],
[0.00000000001, 0.61515728295, 78469.89497315978],
[0.00000000001, 4.60636743786, 126996.94076290558],
[0.00000000001, 4.48187053152, 231348.55332920236],
[0.00000000001, 5.19829793680, 142871.55835826878],
[0.00000000001, 5.68864830775, 3178.14579056760],
[0.00000000001, 4.89753750946, 53265.51507434200],
[0.00000000001, 3.68051221186, 2703.61615467560],
[0.00000000001, 0.01737531330, 103814.80805420138],
[0.00000000001, 1.79348974875, 183145.01295611398],
[0.00000000001, 6.16564988887, 199599.31813847595],
[0.00000000001, 0.63301837081, 51439.92976961659],
[0.00000000001, 2.29427904310, 1485.98012106520],
[0.00000000001, 1.44184009822, 112545.88789950538],
[0.00000000001, 0.55411127132, 42790.96527507320],
[0.00000000001, 5.07507945312, 54824.26110862140],
[0.00000000001, 5.10858625008, 107679.74822257696],
[0.00000000001, 5.50068575093, 27819.02549450680],
[0.00000000001, 5.60579347269, 153084.84390447979],
[0.00000000001, 4.92352598929, 51596.11869614960],
[0.00000000001, 6.10538330268, 181659.72224941078],
], [
[0.00003117867, 3.08231840296, 26087.90314157420],
[0.00001245396, 6.15183317423, 52175.80628314840],
[0.00000424822, 2.92583352960, 78263.70942472259],
[0.00000136130, 5.97983925842, 104351.61256629678],
[0.00000042175, 2.74936980629, 130439.51570787099],
[0.00000021759, 3.14159265359, 0.00000000000],
[0.00000012793, 5.80143162209, 156527.41884944518],
[0.00000003825, 2.56993599584, 182615.32199101939],
[0.00000001042, 3.14648120079, 24978.52458948080],
[0.00000001131, 5.62142196970, 208703.22513259358],
[0.00000000483, 6.14307654520, 27197.28169366760],
[0.00000000332, 2.38992575670, 234791.12827416777],
[0.00000000320, 6.20674766565, 51066.42773105500],
[0.00000000120, 0.56745598887, 20426.57109242200],
[0.00000000113, 3.28048907943, 24498.83024629040],
[0.00000000105, 4.36663468239, 25028.52121138500],
[0.00000000097, 5.44128884026, 260879.03141574195],
[0.00000000095, 1.70276410782, 1059.38193018920],
[0.00000000103, 2.98038190305, 77154.33087262919],
[0.00000000074, 1.28630381800, 26617.59410666880],
[0.00000000057, 2.96753362980, 1109.37855209340],
[0.00000000066, 5.68201233964, 25132.30339996560],
[0.00000000053, 3.63699398162, 46514.47423399620],
[0.00000000059, 3.10922979724, 27043.50288318280],
[0.00000000053, 0.66673109494, 21535.94964451540],
[0.00000000043, 4.69270605698, 27147.28507176339],
[0.00000000042, 2.77372510028, 1589.07289528380],
[0.00000000036, 4.39741248058, 14765.23904326980],
[0.00000000035, 1.80468389323, 11322.66409830440],
[0.00000000043, 6.07426254990, 28306.66024576099],
[0.00000000033, 5.34572581657, 25448.00585526019],
[0.00000000031, 5.66489075070, 30639.85663863300],
[0.00000000031, 2.36104565226, 32858.61374281979],
[0.00000000031, 4.27403143366, 16983.99614745660],
[0.00000000033, 3.22976052744, 23869.14603738740],
[0.00000000031, 0.50041076120, 22645.32819660879],
[0.00000000028, 2.21390393577, 286966.93455731616],
[0.00000000033, 6.03682885493, 103242.23401420339],
[0.00000000025, 4.23934105457, 52705.49724824299],
[0.00000000023, 2.59711556958, 23969.13928119580],
[0.00000000027, 2.10665521901, 25558.21217647960],
[0.00000000021, 0.40892383580, 72602.37737557039],
[0.00000000025, 5.69513499802, 5661.33204915220],
[0.00000000022, 4.86064608327, 26301.20223701220],
[0.00000000024, 0.66522740624, 19317.19254032860],
[0.00000000020, 5.61847810688, 4551.95349705880],
[0.00000000021, 2.30083904827, 51220.20654153979],
[0.00000000018, 0.48839037250, 26068.23338067440],
[0.00000000016, 6.07779022342, 50586.73338786459],
[0.00000000016, 1.47218845921, 53235.18821333759],
[0.00000000017, 2.94277588966, 53285.18483524180],
[0.00000000015, 2.39097980793, 83925.04147387479],
[0.00000000015, 3.85502950028, 26091.78447693220],
[0.00000000014, 4.13753968603, 12566.15169998280],
[0.00000000015, 5.51545801304, 6770.71060124560],
[0.00000000014, 5.67708505049, 57837.13833230060],
[0.00000000014, 5.73775080815, 27676.97603685800],
[0.00000000016, 5.69298300679, 26107.57290247399],
[0.00000000014, 5.00837046884, 37410.56723987860],
[0.00000000015, 5.72321978212, 29530.47808653960],
[0.00000000012, 1.18827026407, 40853.14218484400],
[0.00000000013, 2.34101240702, 26084.02180621620],
[0.00000000012, 2.43920574243, 56727.75978020720],
[0.00000000012, 1.12086684687, 43071.89928903080],
[0.00000000012, 1.86975778356, 9103.90699411760],
[0.00000000012, 4.90236416950, 36301.18868778519],
[0.00000000010, 2.33297570685, 426.59819087600],
[0.00000000011, 2.80390774003, 129330.13715577759],
[0.00000000010, 5.86382886189, 26202.34243025941],
[0.00000000009, 0.03545904481, 25234.70675982219],
[0.00000000011, 0.92571990717, 639.89728631400],
[0.00000000010, 3.94827815051, 25661.30495069820],
[0.00000000009, 0.00145195768, 49957.04917896160],
[0.00000000008, 5.42702003399, 110012.94461544899],
[0.00000000008, 3.39306818321, 25973.46385288896],
[0.00000000009, 4.83499870418, 38519.94579197200],
[0.00000000008, 5.65148718768, 53131.40602475700],
[0.00000000009, 5.73812314204, 51116.42435295920],
[0.00000000008, 1.98050481337, 13521.75144159140],
[0.00000000009, 0.95963913886, 78793.40038981718],
[0.00000000008, 5.24647237181, 313054.83769889036],
[0.00000000008, 3.52212788936, 52156.13652224860],
[0.00000000007, 3.57060093012, 48733.23133818299],
[0.00000000008, 3.47359025801, 98690.28051714458],
[0.00000000008, 5.32679971128, 51646.11531805379],
[0.00000000010, 5.07319693095, 25874.60404613620],
[0.00000000008, 4.34411026261, 31749.23519072640],
[0.00000000007, 3.44556423722, 26080.78959457339],
[0.00000000007, 5.28088749622, 77308.10968311399],
[0.00000000007, 3.46667099767, 2118.76386037840],
[0.00000000007, 1.96360039314, 10213.28554621100],
[0.00000000007, 1.18631489114, 103292.23063610759],
[0.00000000007, 4.28693259279, 955.59974160860],
[0.00000000007, 0.88520158736, 38654.05484155699],
[0.00000000009, 2.12100150030, 18849.22754997420],
[0.00000000008, 2.75301666365, 26095.01668857500],
[0.00000000007, 4.98530328971, 529.69096509460],
[0.00000000007, 0.20928215626, 33326.57873317420],
[0.00000000006, 4.54286088482, 79323.09135491178],
[0.00000000006, 0.60060875587, 52179.68761850640],
[0.00000000006, 1.21940434381, 41962.52073693740],
[0.00000000006, 1.74585091288, 62389.09182935939],
[0.00000000006, 2.13481309441, 51535.90899683439],
[0.00000000006, 4.92478078408, 26514.50133245020],
[0.00000000007, 4.18249532118, 77204.32749453338],
[0.00000000007, 1.68449319925, 52389.10537858640],
[0.00000000005, 4.28220819106, 68050.42387851159],
[0.00000000007, 1.69076988754, 12432.04265039780],
[0.00000000006, 3.73803069606, 45405.09568190280],
[0.00000000005, 2.61320374120, 79373.08797681599],
[0.00000000005, 2.82458540907, 54394.56338733519],
[0.00000000004, 6.27439443684, 52168.69273614759],
[0.00000000005, 4.50767453332, 13655.86049117640],
[0.00000000006, 2.41451327257, 52195.47604404819],
[0.00000000005, 5.35396003655, 52171.92494779040],
[0.00000000005, 5.48187638039, 82815.66292178139],
[0.00000000004, 2.46695073802, 55618.38122811380],
[0.00000000004, 2.40470389725, 53764.87917843220],
[0.00000000004, 4.24591997877, 66941.04532641819],
[0.00000000004, 3.26730161531, 7238.67559160000],
[0.00000000004, 4.24517841791, 129380.13377768178],
[0.00000000004, 5.46706523938, 50057.04242277000],
[0.00000000004, 2.17208918484, 136100.84775702319],
[0.00000000004, 5.86573287261, 155418.04029735178],
[0.00000000004, 4.15256069197, 32370.97899156560],
[0.00000000004, 2.92358717546, 2218.75710418680],
[0.00000000004, 2.22141015932, 33967.99229491319],
[0.00000000005, 5.74788858603, 52182.91983014920],
[0.00000000004, 0.97295961632, 44181.27784112419],
[0.00000000003, 5.78273085505, 28421.09953444620],
[0.00000000003, 3.65975480266, 99799.65906923798],
[0.00000000004, 3.98623592167, 26727.80042788820],
[0.00000000003, 2.65056124435, 76674.63652943878],
[0.00000000003, 4.91152657563, 47623.85278608960],
[0.00000000004, 1.60135504353, 77734.01845962799],
[0.00000000003, 0.26868606771, 78244.03966382280],
[0.00000000003, 4.58298191655, 1066.49547719000],
[0.00000000003, 4.04696774318, 18093.37469954999],
[0.00000000003, 1.04981780528, 94138.32702008578],
[0.00000000003, 0.82425633309, 73711.75592766379],
[0.00000000003, 5.12180734718, 1052.26838318840],
[0.00000000003, 1.58544193974, 51109.31080595839],
[0.00000000003, 0.22337858409, 124778.18365871879],
[0.00000000003, 3.08207297479, 76044.95232053580],
[0.00000000003, 6.26000429251, 853.19638175200],
[0.00000000003, 3.89747679105, 64741.95798313119],
[0.00000000003, 1.86869273254, 52602.40447402440],
[0.00000000004, 0.01480665337, 7.11354700080],
[0.00000000003, 1.95420622178, 103396.01282468818],
[0.00000000003, 6.00022344367, 29416.03879785439],
[0.00000000003, 1.05827389660, 51123.53789995999],
[0.00000000003, 3.93336187090, 104881.30353139139],
[0.00000000002, 4.80666683935, 88476.99497093359],
[0.00000000002, 2.56919394798, 51962.50718771040],
[0.00000000002, 5.19328838214, 91785.46086631398],
[0.00000000003, 4.94448744333, 44937.13069154840],
[0.00000000002, 0.39272598961, 23754.70674870219],
[0.00000000003, 3.64926786888, 78267.59076008058],
[0.00000000002, 1.93776267237, 117873.36400788819],
[0.00000000002, 0.16310879863, 28206.66700195260],
[0.00000000002, 2.74232958068, 52290.24557183361],
[0.00000000002, 1.94114905421, 7994.52844202420],
[0.00000000002, 0.39437121176, 125887.56221081219],
[0.00000000002, 1.03418813348, 155468.03691925599],
[0.00000000002, 2.06866763231, 339142.74084046457],
[0.00000000002, 1.29912216629, 105410.99449648599],
[0.00000000002, 0.54124189090, 74821.13447975718],
[0.00000000002, 2.12346357366, 65697.55772473979],
[0.00000000002, 2.54143985834, 78270.82297172339],
[0.00000000002, 4.87063627681, 35191.81013569180],
[0.00000000002, 0.51631216786, 71492.99882347698],
[0.00000000002, 0.73976887550, 18207.81398823521],
[0.00000000002, 5.50150244414, 78283.37918562238],
[0.00000000002, 4.78661791721, 78477.00852016058],
[0.00000000002, 4.40683761496, 103821.92160120218],
[0.00000000002, 3.07092516027, 78256.59587772179],
[0.00000000002, 5.01301614244, 3442.57494496540],
[0.00000000002, 2.58799752737, 181505.94343892598],
[0.00000000002, 4.95243490606, 129483.91596626239],
[0.00000000002, 4.12821833516, 77211.44104153418],
[0.00000000002, 4.05475453577, 120226.23016165999],
[0.00000000002, 3.34041291655, 151975.46535238638],
[0.00000000002, 3.27812728356, 51322.60990139639],
[0.00000000002, 4.06092192484, 77837.11123384659],
[0.00000000002, 5.22546741404, 162188.75089859738],
[0.00000000002, 5.57497617017, 71980.63357473118],
[0.00000000002, 1.86655156569, 23439.44831610119],
[0.00000000002, 4.79020891265, 15874.61759536320],
[0.00000000002, 2.43202419279, 45892.73043315699],
[0.00000000001, 4.91443985635, 78690.30761559859],
[0.00000000002, 2.55186486587, 39609.65458316560],
[0.00000000002, 2.04705904795, 433.71173787680],
[0.00000000001, 6.06582167254, 102132.85546210999],
[0.00000000002, 0.36512406083, 6283.07584999140],
[0.00000000002, 5.96418661485, 78050.41032928458],
[0.00000000001, 0.66730245858, 58458.88213313979],
[0.00000000001, 2.46652537811, 98068.53671630539],
[0.00000000002, 3.24884087108, 150866.08680029298],
[0.00000000002, 0.33626385981, 52061.36699446317],
[0.00000000001, 1.58214319162, 114564.89811250778],
[0.00000000001, 1.86505965946, 27140.17152476259],
[0.00000000001, 4.70954784660, 77197.21394753258],
[0.00000000001, 3.30080224324, 104331.94280539699],
[0.00000000002, 2.15014442693, 78259.82808936459],
[0.00000000001, 4.16909637294, 51742.09454527159],
[0.00000000002, 0.61993180902, 130969.20667296558],
[0.00000000001, 5.64166202504, 81706.28436968799],
[0.00000000001, 1.28449131177, 27154.39861876420],
[0.00000000001, 0.20716724934, 131548.89425996438],
[0.00000000001, 5.01586042695, 105460.99111839019],
[0.00000000001, 2.20142137730, 104371.28232719658],
[0.00000000001, 0.71547903080, 103925.01437542078],
[0.00000000001, 1.69298852699, 71025.03383312259],
[0.00000000002, 1.01857337375, 93028.94846799239],
[0.00000000002, 0.99564225222, 129909.82474277639],
[0.00000000001, 3.04953117213, 26941.09952332620],
[0.00000000001, 1.54774252742, 104564.91166173479],
[0.00000000001, 1.29736654025, 26241.68195205900],
[0.00000000002, 0.39879309478, 104355.49390165479],
[0.00000000001, 1.73442408485, 64607.84893354619],
[0.00000000001, 3.52887677711, 97580.90196505119],
[0.00000000001, 3.55488474055, 84546.78527471398],
[0.00000000001, 2.68991734615, 59414.48187474840],
[0.00000000001, 2.23301107736, 107794.18751126219],
[0.00000000001, 6.04185199127, 104344.49901929598],
[0.00000000001, 2.33178230942, 108903.56606335558],
[0.00000000001, 5.23291332097, 134991.46920492979],
[0.00000000001, 5.42420842294, 79852.78232000639],
[0.00000000001, 5.56485897392, 104358.72611329758],
[0.00000000001, 2.03042058117, 76144.94556434419],
[0.00000000001, 4.42403586918, 25021.40766438420],
[0.00000000001, 4.07362401058, 181555.94006083018],
[0.00000000001, 4.39544806298, 131498.89763806018],
[0.00000000001, 3.37653548744, 22759.76748529401],
[0.00000000001, 3.34598726101, 24864.08530079559],
[0.00000000001, 0.81949463309, 52815.70356946240],
[0.00000000001, 4.13026377404, 2648.45482547300],
[0.00000000001, 1.40701146170, 103285.11708910679],
[0.00000000001, 2.72338212355, 419.48464387520],
[0.00000000001, 2.86239729930, 63498.47038145279],
[0.00000000001, 4.60118276053, 19804.82729158280],
[0.00000000001, 3.76488909896, 51749.20809227239],
[0.00000000001, 5.71167880995, 78378.14871340781],
[0.00000000001, 3.11068504003, 54294.57014352679],
[0.00000000001, 5.17191010522, 1596.18644228460],
[0.00000000001, 0.84666659977, 26037.90651966999],
[0.00000000001, 1.27214241387, 39743.76363275060],
[0.00000000001, 3.62572271343, 51756.32163927320],
[0.00000000001, 0.99401491673, 50579.61984086379],
[0.00000000001, 2.65940437112, 79219.30916633119],
[0.00000000001, 2.78122688424, 157636.79740153858],
[0.00000000001, 5.02865728622, 365230.64398203876],
[0.00000000001, 4.26629771518, 26724.89941359840],
[0.00000000001, 0.69459147389, 90829.86112470538],
[0.00000000001, 3.74834736873, 44295.71712980940],
[0.00000000001, 2.67181600104, 5327.47610838280],
[0.00000000001, 5.10769130141, 58946.51688439399],
[0.00000000001, 0.55503171074, 69159.80243060499],
[0.00000000001, 4.68391610322, 90695.75207512038],
[0.00000000001, 5.17372763616, 149.56319713460],
[0.00000000001, 5.26044215633, 25934.12433108940],
[0.00000000001, 5.13679156205, 104347.73123093879],
[0.00000000001, 0.91197645609, 103299.34418310839],
[0.00000000001, 5.89466975855, 27311.72098235281],
[0.00000000001, 0.91206378451, 77829.99768684579],
[0.00000000001, 0.82686052448, 146314.13330323418],
[0.00000000001, 5.01041490382, 25450.90686955000],
[0.00000000001, 0.74891931364, 10021.83728009940],
[0.00000000001, 3.75910629606, 25619.93815121980],
[0.00000000001, 1.57855828108, 61279.71327726600],
[0.00000000001, 5.22196769252, 77623.81213840858],
[0.00000000001, 5.44280337360, 52643.77127350280],
[0.00000000001, 3.38760463430, 49842.60989027639],
[0.00000000001, 4.04176416141, 25565.32572348040],
[0.00000000001, 1.99169557218, 105940.68546158058],
[0.00000000001, 2.40126368211, 26555.86813192860],
[0.00000000001, 3.28153684541, 78149.27013603736],
[0.00000000001, 1.50606534242, 50593.84693486539],
[0.00000000001, 4.99390846744, 143961.26714946238],
[0.00000000001, 4.36279289081, 70269.18098269838],
[0.00000000001, 0.56330446870, 29428.51556827400],
[0.00000000001, 1.96827343473, 188276.65404017158],
[0.00000000001, 6.14024093350, 3328.13565628019],
[0.00000000001, 4.38278455115, 52329.58509363319],
[0.00000000001, 5.32677211586, 26137.89976347840],
[0.00000000001, 5.49001686286, 7880.08915333899],
[0.00000000001, 2.08096369099, 26610.48055966799],
[0.00000000001, 2.81808749734, 54509.00267602040],
[0.00000000001, 3.85620334673, 26624.70765366959],
[0.00000000001, 1.15157832957, 536.80451209540],
[0.00000000001, 3.62974919098, 130012.91751699499],
[0.00000000001, 0.35977888560, 105307.21230790539],
[0.00000000001, 2.75970257539, 55503.94193942859],
[0.00000000001, 3.95087871071, 119116.85160956658],
[0.00000000001, 2.02746284465, 85034.42002596818],
[0.00000000001, 0.01631363612, 25668.41849769900],
[0.00000000001, 4.69497491223, 1581.95934828300],
[0.00000000001, 4.43589881789, 53242.30176033840],
[0.00000000001, 0.02851648548, 213.29909543800],
[0.00000000001, 2.42155941603, 25551.09862947879],
[0.00000000001, 4.51335885923, 12546.48193908300],
[0.00000000001, 3.07012190290, 104138.31347085879],
[0.00000000001, 4.25105785914, 65831.66677432480],
[0.00000000001, 0.26591217377, 89586.37352302698],
[0.00000000001, 3.25491459524, 46848.33017476560],
[0.00000000001, 5.00501348827, 51639.00177105299],
[0.00000000000, 5.50334834007, 124156.43985787958],
[0.00000000000, 4.83101429854, 76.26607127560],
[0.00000000000, 4.34030366776, 80482.46652890938],
[0.00000000001, 3.55161443787, 116917.76426627958],
[0.00000000000, 4.96302997387, 26521.61487945100],
[0.00000000001, 0.12176395772, 6681.22485339960],
[0.00000000001, 0.06932929209, 48847.67062686820],
[0.00000000001, 0.08695556653, 26507.38778544939],
[0.00000000000, 1.50601747714, 632.78373931320],
[0.00000000000, 3.68453733674, 25035.63475838580],
[0.00000000000, 2.10077795936, 86143.79857806159],
[0.00000000000, 2.61352703953, 53399.62412392700],
[0.00000000000, 0.84481589887, 25881.71759313700],
[0.00000000000, 3.95854005744, 95247.70557217918],
[0.00000000001, 4.47600641528, 97112.93697469679],
[0.00000000001, 0.40812953108, 77844.22478084739],
[0.00000000000, 4.89912517892, 25984.81036735560],
[0.00000000000, 5.16843610094, 52698.38370124219],
[0.00000000000, 3.99449121788, 131395.11544947959],
[0.00000000000, 5.65446547429, 80596.90581759460],
], [
[0.00000032676, 1.67971635359, 26087.90314157420],
[0.00000024166, 4.63403168997, 52175.80628314840],
[0.00000012133, 1.38983781545, 78263.70942472259],
[0.00000005140, 4.43915386930, 104351.61256629678],
[0.00000001981, 1.20733880274, 130439.51570787099],
[0.00000001460, 3.14159265359, 0.00000000000],
[0.00000000719, 4.25913631362, 156527.41884944518],
[0.00000000250, 1.02794425848, 182615.32199101939],
[0.00000000084, 4.08008618813, 208703.22513259358],
[0.00000000028, 0.85051616237, 234791.12827416777],
[0.00000000023, 1.60029451014, 24978.52458948080],
[0.00000000011, 4.58074493182, 27197.28169366760],
[0.00000000012, 4.65878660390, 51066.42773105500],
[0.00000000009, 3.90622332667, 260879.03141574195],
[0.00000000005, 1.43247327249, 77154.33087262919],
[0.00000000004, 1.37106678794, 53285.18483524180],
[0.00000000003, 0.67217979275, 286966.93455731616],
[0.00000000002, 5.31135121818, 20426.57109242200],
[0.00000000002, 1.54812921017, 1109.37855209340],
[0.00000000002, 4.48222146022, 103242.23401420339],
[0.00000000002, 0.20057520755, 1059.38193018920],
[0.00000000002, 4.21865197056, 25132.30339996560],
[0.00000000001, 2.11997334018, 46514.47423399620],
[0.00000000001, 3.24267833975, 27147.28507176339],
[0.00000000001, 1.33238537892, 1589.07289528380],
[0.00000000001, 5.14405498793, 72602.37737557039],
[0.00000000001, 6.14595652541, 26617.59410666880],
[0.00000000001, 3.90494988936, 4551.95349705880],
[0.00000000001, 2.85134614467, 14765.23904326980],
[0.00000000001, 3.74339959279, 313054.83769889036],
[0.00000000001, 2.82234410581, 52705.49724824299],
[0.00000000001, 1.70132625273, 23869.14603738740],
[0.00000000001, 1.44102444460, 27043.50288318280],
[0.00000000001, 1.25358423340, 129330.13715577759],
[0.00000000001, 0.32054002273, 9103.90699411760],
[0.00000000001, 0.90273607509, 51220.20654153979],
[0.00000000001, 4.28935605425, 27676.97603685800],
[0.00000000001, 4.41206223998, 79373.08797681599],
[0.00000000001, 3.23518929162, 26301.20223701220],
[0.00000000001, 2.25667255668, 21535.94964451540],
[0.00000000001, 4.70414203873, 50586.73338786459],
[0.00000000001, 1.88608259832, 98690.28051714458],
[0.00000000001, 5.90420893056, 40853.14218484400],
[0.00000000001, 4.46892853356, 53131.40602475700],
[0.00000000001, 3.83684899837, 77308.10968311399],
[0.00000000001, 1.31974603498, 54394.56338733519],
[0.00000000001, 0.74728939443, 32858.61374281979],
[0.00000000001, 6.27673970277, 53235.18821333759],
[0.00000000001, 4.14814578610, 29530.47808653960],
[0.00000000001, 0.87302135775, 83925.04147387479],
[0.00000000001, 5.20339566427, 26068.23338067440],
[0.00000000001, 2.88631079597, 79323.09135491178],
[0.00000000001, 5.39853672849, 19317.19254032860],
[0.00000000001, 5.73721596586, 78793.40038981718],
[0.00000000000, 1.85241611022, 25973.46385288896],
[0.00000000000, 4.31134434847, 26202.34243025941],
[0.00000000000, 4.74305205780, 49957.04917896160],
[0.00000000001, 3.87802524387, 82815.66292178139],
[0.00000000000, 4.28937691652, 155418.04029735178],
[0.00000000001, 3.35625397389, 37410.56723987860],
[0.00000000000, 2.00313301846, 22645.32819660879],
[0.00000000000, 2.49236829957, 25028.52121138500],
[0.00000000000, 0.01947787727, 25558.21217647960],
[0.00000000001, 4.13825019881, 3442.57494496540],
[0.00000000000, 2.81832388305, 25874.60404613620],
[0.00000000000, 2.53416253042, 12566.15169998280],
[0.00000000001, 4.46169102731, 28306.66024576099],
[0.00000000001, 2.16986592809, 45405.09568190280],
[0.00000000000, 2.27621739263, 26091.78447693220],
[0.00000000000, 1.95034764539, 52156.13652224860],
[0.00000000000, 4.03054078678, 30639.85663863300],
[0.00000000000, 5.76722418743, 43071.89928903080],
[0.00000000000, 4.12739704581, 26107.57290247399],
[0.00000000000, 1.37713138665, 31749.23519072640],
[0.00000000001, 3.54716896556, 51646.11531805379],
[0.00000000000, 3.39161595850, 36301.18868778519],
[0.00000000000, 4.34410863436, 57837.13833230060],
[0.00000000000, 5.62082960690, 639.89728631400],
[0.00000000000, 3.16268062826, 529.69096509460],
[0.00000000000, 0.77186843357, 26084.02180621620],
[0.00000000000, 3.78612072314, 110012.94461544899],
[0.00000000000, 5.50453358586, 51116.42435295920],
[0.00000000000, 0.04709131420, 52389.10537858640],
[0.00000000000, 3.93991894858, 6770.71060124560],
[0.00000000000, 1.41961180167, 76674.63652943878],
[0.00000000000, 2.61258742182, 66941.04532641819],
[0.00000000000, 0.70544164813, 426.59819087600],
[0.00000000000, 0.91883551986, 55618.38122811380],
[0.00000000000, 5.30612883135, 52179.68761850640],
[0.00000000000, 2.00604152518, 2118.76386037840],
[0.00000000000, 1.08640210817, 56727.75978020720],
[0.00000000000, 3.92743267498, 58946.51688439399],
[0.00000000000, 5.52202827702, 38654.05484155699],
[0.00000000000, 1.57363600114, 24498.83024629040],
[0.00000000000, 3.49522546958, 5661.33204915220],
[0.00000000000, 0.63375195581, 51535.90899683439],
[0.00000000000, 1.34305878069, 105460.99111839019],
[0.00000000000, 0.44820055565, 339142.74084046457],
[0.00000000000, 1.39951362362, 2218.75710418680],
[0.00000000000, 0.63311095079, 18849.22754997420],
[0.00000000000, 0.82120127326, 52195.47604404819],
[0.00000000000, 2.78211363987, 47623.85278608960],
[0.00000000000, 0.94752126944, 53764.87917843220],
[0.00000000000, 3.75988526858, 52171.92494779040],
[0.00000000000, 0.44351435910, 136100.84775702319],
[0.00000000000, 1.44824925227, 76044.95232053580],
[0.00000000000, 4.83985082201, 78244.03966382280],
[0.00000000000, 0.04522486479, 62389.09182935939],
[0.00000000000, 6.28144869714, 213.29909543800],
[0.00000000000, 5.17875557687, 955.59974160860],
[0.00000000000, 4.62674052433, 52168.69273614759],
[0.00000000000, 2.19907823066, 77204.32749453338],
[0.00000000000, 3.40216597806, 26514.50133245020],
[0.00000000000, 2.89630853457, 13655.86049117640],
[0.00000000000, 3.92639394174, 50057.04242277000],
[0.00000000000, 0.27991454535, 11322.66409830440],
[0.00000000000, 5.63968341805, 103292.23063610759],
[0.00000000000, 1.86829495425, 48733.23133818299],
[0.00000000000, 5.77443179008, 105410.99449648599],
], [
[0.00000000394, 0.36735403840, 26087.90314157420],
[0.00000000387, 3.18568771507, 52175.80628314840],
[0.00000000270, 6.16983616444, 78263.70942472259],
[0.00000000149, 2.91591904641, 104351.61256629678],
[0.00000000071, 5.95867889641, 130439.51570787099],
[0.00000000031, 2.72386700044, 156527.41884944518],
[0.00000000017, 0.00000000000, 0.00000000000],
[0.00000000012, 5.77775334056, 182615.32199101939],
[0.00000000005, 2.54506442647, 208703.22513259358],
[0.00000000002, 5.59978443851, 234791.12827416777],
[0.00000000001, 2.33785160871, 260879.03141574195],
[0.00000000000, 5.37943916893, 286966.93455731616],
[0.00000000000, 3.09643524101, 51066.42773105500],
[0.00000000000, 0.09342858750, 24978.52458948080],
[0.00000000000, 6.02837115675, 53285.18483524180],
[0.00000000000, 6.13600004668, 77154.33087262919],
[0.00000000000, 2.93310416266, 27197.28169366760],
[0.00000000000, 2.89897922039, 103242.23401420339],
], [
[0.00000000006, 3.98900269603, 26087.90314157420],
[0.00000000006, 1.55248278782, 52175.80628314840],
[0.00000000005, 4.65461721116, 78263.70942472259],
[0.00000000004, 1.40238366492, 104351.61256629678],
[0.00000000002, 4.44231488663, 130439.51570787099],
[0.00000000001, 3.14159265359, 0.00000000000],
[0.00000000001, 1.21278177664, 156527.41884944518],
[0.00000000001, 4.26149026340, 182615.32199101939],
[0.00000000000, 0.99831133595, 208703.22513259358],
[0.00000000000, 4.00267064210, 234791.12827416777],
]],
('Venus', 'L'):[[
[3.17614666774, 0.00000000000, 0.00000000000],
[0.01353968419, 5.59313319619, 10213.28554621100],
[0.00089891645, 5.30650048468, 20426.57109242200],
[0.00005477201, 4.41630652531, 7860.41939243920],
[0.00003455732, 2.69964470778, 11790.62908865880],
[0.00002372061, 2.99377539568, 3930.20969621960],
[0.00001317108, 5.18668219093, 26.29831979980],
[0.00001664069, 4.25018935030, 1577.34354244780],
[0.00001438322, 4.15745043958, 9683.59458111640],
[0.00001200521, 6.15357115319, 30639.85663863300],
[0.00000761380, 1.95014702120, 529.69096509460],
[0.00000707676, 1.06466707214, 775.52261132400],
[0.00000584836, 3.99839884762, 191.44826611160],
[0.00000769314, 0.81629615911, 9437.76293488700],
[0.00000499915, 4.12340210074, 15720.83878487840],
[0.00000326221, 4.59056473097, 10404.73381232260],
[0.00000429498, 3.58642859752, 19367.18916223280],
[0.00000326967, 5.67736583705, 5507.55323866740],
[0.00000231937, 3.16251057072, 9153.90361602180],
[0.00000179695, 4.65337915578, 1109.37855209340],
[0.00000128263, 4.22604493736, 20.77539549240],
[0.00000155464, 5.57043888948, 19651.04848109800],
[0.00000127907, 0.96209822685, 5661.33204915220],
[0.00000105547, 1.53721191253, 801.82093112380],
[0.00000085722, 0.35589249966, 3154.68708489560],
[0.00000099121, 0.83288185132, 213.29909543800],
[0.00000098804, 5.39389655503, 13367.97263110660],
[0.00000082094, 3.21596990826, 18837.49819713819],
[0.00000088031, 3.88868860307, 9999.98645077300],
[0.00000071577, 0.11145739345, 11015.10647733480],
[0.00000056122, 4.24039855475, 7.11354700080],
[0.00000070239, 0.67458813282, 23581.25817731760],
[0.00000050796, 0.24531603049, 11322.66409830440],
[0.00000046111, 5.31576465717, 18073.70493865020],
[0.00000044574, 6.06282201966, 40853.14218484400],
[0.00000042594, 5.32873337210, 2352.86615377180],
[0.00000042635, 1.79955421680, 7084.89678111520],
[0.00000041177, 0.36240972161, 382.89653222320],
[0.00000035749, 2.70448479296, 10206.17199921020],
[0.00000033893, 2.02347322198, 6283.07584999140],
[0.00000029138, 3.59230925768, 22003.91463486980],
[0.00000028479, 2.22375414002, 1059.38193018920],
[0.00000029850, 4.02176977477, 10239.58386601080],
[0.00000033252, 2.10025596509, 27511.46787353720],
[0.00000030172, 4.94191919890, 13745.34623902240],
[0.00000029252, 3.51392387787, 283.85931886520],
[0.00000024424, 2.70177493852, 8624.21265092720],
[0.00000020274, 3.79493637509, 14143.49524243060],
[0.00000024322, 4.27814493315, 5.52292430740],
[0.00000026260, 0.54067587552, 17298.18232732620],
[0.00000020492, 0.58547075036, 38.02767263580],
[0.00000018988, 4.13811500642, 4551.95349705880],
[0.00000023739, 4.82870797552, 6872.67311951120],
[0.00000015885, 1.50067222283, 8635.94200376320],
[0.00000019069, 6.12025580313, 29050.78374334920],
[0.00000018269, 3.04740408477, 19999.97290154599],
[0.00000013656, 4.41336292334, 3532.06069281140],
[0.00000017094, 3.52161526430, 31441.67756975680],
[0.00000010955, 2.84562790076, 18307.80723204360],
[0.00000011048, 2.58361219075, 9786.68735533500],
[0.00000009904, 1.08737710389, 7064.12138562280],
[0.00000010576, 0.85419784436, 10596.18207843420],
[0.00000009231, 5.52471655579, 12566.15169998280],
[0.00000011599, 5.81007422699, 19896.88012732740],
[0.00000011807, 1.91250672543, 21228.39202354580],
[0.00000010105, 2.34270786693, 10742.97651130560],
[0.00000008154, 1.92331359797, 15.25247118500],
[0.00000008893, 1.97291388515, 10186.98722641120],
[0.00000009352, 4.94508904764, 35371.88726597640],
[0.00000006821, 4.39733188968, 8662.24032356300],
[0.00000006688, 1.55310437864, 14945.31617355440],
[0.00000006413, 2.17677652923, 10988.80815753500],
[0.00000005802, 1.93462125906, 3340.61242669980],
[0.00000005950, 2.96578175391, 4732.03062734340],
[0.00000005275, 5.01877102496, 28286.99048486120],
[0.00000007047, 1.00111452053, 632.78373931320],
[0.00000005048, 4.27886209626, 29580.47470844380],
[0.00000006305, 0.35506331180, 103.09277421860],
[0.00000005959, 5.04792949464, 245.83164622940],
[0.00000004651, 0.85218058876, 6770.71060124560],
[0.00000005580, 0.48723384809, 522.57741809380],
[0.00000005327, 3.03115417024, 10021.83728009940],
[0.00000005010, 5.77375166500, 28521.09277825460],
[0.00000004608, 1.93302108394, 4705.73230754360],
[0.00000005526, 3.36797048901, 25158.60171976540],
[0.00000003863, 4.89351531412, 25934.12433108940],
[0.00000005303, 0.08161426841, 39302.09696219600],
[0.00000004254, 5.36046113295, 21535.94964451540],
[0.00000003763, 1.05304597315, 19.66976089979],
[0.00000004407, 4.02575374517, 74.78159856730],
[0.00000004145, 1.14356412295, 9676.48103411560],
[0.00000004318, 4.38289970585, 316.39186965660],
[0.00000003642, 6.11733529325, 3128.38876509580],
[0.00000003238, 5.39551036769, 419.48464387520],
[0.00000003909, 4.05263635330, 9690.70812811720],
[0.00000003152, 0.72553551731, 16496.36139620240],
[0.00000003496, 0.72414615705, 3723.50895892300],
[0.00000003755, 3.80208713127, 19786.67380610799],
[0.00000002891, 3.33782737770, 32217.20018108080],
[0.00000003016, 1.57249112496, 17277.40693183380],
[0.00000003825, 0.19612312903, 426.59819087600],
[0.00000003798, 0.45524571743, 10316.37832042960],
[0.00000002570, 1.20813474107, 13936.79450513400],
[0.00000002796, 3.65128969074, 206.18554843720],
[0.00000002466, 3.61988676373, 1551.04522264800],
[0.00000003108, 1.50325806664, 43232.30665841560],
[0.00000002976, 4.79415001304, 29088.81141598500],
[0.00000002217, 3.59623681714, 24356.78078864160],
[0.00000002227, 4.96059221940, 536.80451209540],
[0.00000002397, 3.45249688427, 19374.30270923360],
[0.00000002462, 0.53295178258, 19360.07561523199],
[0.00000002205, 2.70399309963, 12592.45001978260],
[0.00000002230, 3.01413465913, 18875.52586977400],
[0.00000001858, 4.06129152783, 2379.16447357160],
[0.00000001807, 3.15086214479, 9573.38825989700],
[0.00000002238, 5.52216925076, 10138.50394764370],
[0.00000002195, 2.32046770554, 8094.52168583260],
[0.00000002101, 2.90421302975, 9967.45389998160],
[0.00000001916, 4.56513949099, 2218.75710418680],
[0.00000001467, 2.42640162465, 10234.06094170340],
[0.00000001726, 5.59790693845, 20452.86941222180],
[0.00000001455, 2.44757248737, 1589.07289528380],
[0.00000001991, 4.04623390359, 31749.23519072640],
[0.00000001406, 2.71736996917, 16983.99614745660],
[0.00000001658, 0.11252373292, 153.77881048480],
[0.00000001851, 2.92898027939, 47162.51635463520],
[0.00000001492, 1.07513892753, 9103.90699411760],
[0.00000001247, 2.48433565896, 17778.11626694899],
[0.00000001549, 4.20553654300, 3442.57494496540],
[0.00000001243, 3.95452438599, 170.67287061920],
[0.00000001694, 6.20694480406, 33019.02111220460],
[0.00000001221, 4.77931820602, 30110.16567353840],
[0.00000001206, 0.30531303095, 29864.33402730900],
[0.00000001238, 5.05581820608, 20213.27199698400],
[0.00000001152, 3.26229919481, 11.72935283600],
[0.00000001179, 1.69491074791, 20400.27277262220],
[0.00000001165, 2.88995128147, 574.34479833480],
[0.00000001306, 0.14519588607, 9146.79006902100],
[0.00000001113, 1.52598846804, 10426.58464164900],
[0.00000001104, 2.58791423813, 18849.22754997420],
[0.00000001045, 0.57539216420, 15874.61759536320],
[0.00000001360, 2.41976595457, 38734.37832446560],
[0.00000000981, 4.37930727798, 110.20632121940],
[0.00000001095, 0.49492867814, 51066.42773105500],
[0.00000001146, 4.54241454215, 10220.39909321180],
[0.00000000981, 1.65915064733, 10103.07922499160],
[0.00000001270, 4.69374306132, 9050.81084180320],
[0.00000001065, 4.41645258887, 22805.73556599360],
[0.00000000854, 2.34437926957, 6681.22485339960],
[0.00000001104, 0.49781459714, 1.48447270830],
[0.00000001075, 1.09857593161, 377.37360791580],
[0.00000001114, 4.35024775806, 51092.72605085480],
[0.00000000829, 5.41196274578, 27991.40181316000],
[0.00000000900, 2.74195379617, 41962.52073693740],
[0.00000001010, 2.96092073452, 135.62532501000],
[0.00000000768, 3.98260860494, 18844.61174413899],
[0.00000001018, 1.36891050752, 36949.23080842420],
[0.00000000726, 1.67728773965, 21202.09370374600],
[0.00000000727, 0.89048212541, 467.96499035440],
[0.00000000869, 2.93767679827, 10192.51015071860],
[0.00000000696, 5.35698039414, 10063.72234907640],
[0.00000000920, 4.17128923588, 18734.40542291960],
[0.00000000691, 1.50594097883, 27197.28169366760],
[0.00000000835, 0.48050621092, 20618.01935853360],
[0.00000000711, 0.19750098222, 18830.38465013739],
[0.00000000811, 0.16685071959, 12432.04265039780],
[0.00000000756, 3.79022623226, 9161.01716302260],
[0.00000000622, 5.33659507738, 9411.46461508720],
[0.00000000862, 5.72705356405, 10175.15251057320],
[0.00000000853, 0.10404188453, 2107.03450754240],
[0.00000000742, 3.96365892051, 813.55028395980],
[0.00000000705, 0.71229660616, 220.41264243880],
[0.00000000584, 1.71900692700, 36.02786667740],
[0.00000000612, 0.36418385449, 949.17560896980],
[0.00000000587, 1.58648949290, 6.62855890001],
[0.00000000581, 5.49288908804, 6309.37416979120],
[0.00000000581, 4.80353237853, 24150.08005134500],
[0.00000000516, 6.07328802561, 38.13303563780],
[0.00000000627, 5.47281424954, 9580.50180689780],
[0.00000000601, 1.40500080774, 1162.47470440780],
[0.00000000620, 4.00681042667, 9992.87290377220],
[0.00000000611, 3.62010998629, 7255.56965173440],
[0.00000000697, 2.22359630727, 348.92442044800],
[0.00000000693, 5.77432072851, 55022.93574707440],
[0.00000000494, 0.29761886866, 7058.59846131540],
[0.00000000563, 0.24172140474, 37410.56723987860],
[0.00000000487, 5.86917216517, 10137.01947493540],
[0.00000000493, 2.04534833854, 735.87651353180],
[0.00000000636, 2.79707392326, 40879.44050464380],
[0.00000000519, 4.13945657630, 16522.65971600220],
[0.00000000535, 4.60569597820, 19573.37471066999],
[0.00000000555, 5.88120421263, 26735.94526221320],
[0.00000000440, 5.61490649795, 23958.63178523340],
[0.00000000541, 0.62494922735, 10007.09999777380],
[0.00000000427, 4.02335620501, 14.22709400160],
[0.00000000434, 0.29028429049, 9264.10993724120],
[0.00000000451, 1.66320363626, 26087.90314157420],
[0.00000000422, 3.38413582674, 10787.63034454580],
[0.00000000569, 5.14001758731, 27490.69247804480],
[0.00000000421, 4.23407313457, 39793.76025465480],
[0.00000000458, 5.28786368820, 49.75702547180],
[0.00000000418, 5.69097790790, 14765.23904326980],
[0.00000000475, 0.97544690438, 1052.26838318840],
[0.00000000387, 4.41665162999, 21.85082932640],
[0.00000000523, 2.90512426870, 20235.12282631040],
[0.00000000506, 5.26999314618, 29999.95935231900],
[0.00000000438, 2.49457071132, 20956.26205751660],
[0.00000000530, 0.71368442157, 33794.54372352860],
[0.00000000382, 1.92119365480, 3.93215326310],
[0.00000000365, 3.81715328784, 20419.45754542119],
[0.00000000426, 2.06384083608, 38204.68735937100],
[0.00000000496, 0.44077356179, 9835.91193829520],
[0.00000000410, 4.93346326003, 19264.09638801420],
[0.00000000380, 3.79573358631, 8521.11987670860],
[0.00000000334, 5.51158557799, 10251.31321884680],
[0.00000000412, 2.56129670728, 77.67377042800],
[0.00000000418, 2.37865963521, 32.53255079140],
[0.00000000325, 6.03020523465, 18947.70451835760],
[0.00000000400, 0.91999360201, 227.47613278900],
[0.00000000437, 0.91420135162, 58953.14544329400],
[0.00000000360, 0.82477639126, 22.77520145080],
[0.00000000413, 4.22381905655, 44809.65020086340],
[0.00000000375, 3.15657291896, 19992.85935454519],
[0.00000000371, 6.05370874275, 20007.08644854680],
[0.00000000361, 5.44371227904, 19470.28193645139],
[0.00000000386, 5.28120540405, 47623.85278608960],
[0.00000000389, 0.73216672240, 19050.79729257620],
[0.00000000320, 2.84811591194, 10199.05845220940],
[0.00000000386, 3.88754165531, 1975.49254585600],
[0.00000000276, 4.33979180814, 20809.46762464520],
[0.00000000276, 0.50647429773, 9830.38901398780],
[0.00000000309, 3.79299100668, 18204.71445782499],
[0.00000000377, 0.73768791281, 11506.76976979360],
[0.00000000322, 0.96138442100, 30666.15495843280],
[0.00000000363, 1.30472406690, 9367.20271145980],
[0.00000000366, 2.79972786028, 11272.66747640020],
[0.00000000271, 4.66141338193, 846.08283475120],
[0.00000000259, 0.42031175750, 39264.06928956020],
[0.00000000285, 0.40546033634, 30.91412563500],
[0.00000000247, 4.80676426942, 36147.40987730040],
[0.00000000264, 2.71608177583, 11.04570026390],
[0.00000000233, 2.76423842887, 187.92514776260],
[0.00000000248, 1.60765612338, 10497.14486507620],
[0.00000000271, 0.82348919630, 19793.78735310880],
[0.00000000225, 3.80080957016, 8631.32619792800],
[0.00000000263, 1.92311689852, 37724.75341974820],
[0.00000000214, 5.01663795092, 639.89728631400],
[0.00000000289, 0.12342601246, 20277.00789528740],
[0.00000000210, 0.12771800254, 29.82143814880],
[0.00000000227, 4.18036609801, 17468.85519794540],
[0.00000000274, 2.34929343000, 62883.35513951360],
[0.00000000260, 5.65254501655, 48739.85989708300],
[0.00000000271, 4.95325404028, 4214.06901508480],
[0.00000000219, 2.08775228014, 194.97138446060],
[0.00000000191, 2.49267248333, 568.82187402740],
[0.00000000250, 1.52909737354, 6037.24420376200],
[0.00000000231, 5.23674429498, 491.66329245880],
[0.00000000182, 4.98046042571, 18418.01355326299],
[0.00000000188, 2.82273639603, 1385.89527633620],
[0.00000000204, 4.09939796199, 14919.01785375460],
[0.00000000176, 3.82400982460, 9360.08916445900],
[0.00000000198, 2.76491873243, 10217.21769947410],
[0.00000000168, 5.19268384202, 1066.49547719000],
[0.00000000199, 1.95301487982, 7564.83072073800],
[0.00000000171, 2.59623459612, 20405.79569692960],
[0.00000000172, 5.29332132623, 11764.33076885900],
[0.00000000165, 2.88557908025, 10207.76262190360],
[0.00000000164, 3.25435371801, 3914.95722503460],
[0.00000000200, 3.82443218090, 18314.92077904440],
[0.00000000169, 1.78341902878, 31022.75317085620],
[0.00000000179, 0.90840065587, 7880.08915333899],
[0.00000000163, 2.79665037814, 41.55079098480],
[0.00000000154, 3.90796293476, 30213.25844775700],
[0.00000000153, 0.07463240782, 28528.20632525540],
[0.00000000194, 5.95838706838, 8617.09910392640],
[0.00000000171, 4.58206324409, 20447.34648791440],
[0.00000000150, 2.11647586229, 17248.42530185440],
[0.00000000149, 2.17259986320, 9929.42622734580],
[0.00000000191, 0.82310353823, 52670.06959330260],
[0.00000000148, 2.94315921485, 41654.96311596780],
[0.00000000149, 4.49798039726, 30831.30490474460],
[0.00000000184, 2.46923348701, 34596.36465465240],
[0.00000000146, 2.69452930300, 43071.89928903080],
[0.00000000159, 2.11137713570, 19317.19254032860],
[0.00000000154, 2.76536164654, 28513.97923125379],
[0.00000000140, 4.94595038686, 9256.99639024040],
[0.00000000141, 2.57248458154, 13553.89797291080],
[0.00000000137, 1.66482327575, 2636.72547263700],
[0.00000000140, 5.23039605990, 22645.32819660879],
[0.00000000132, 5.35690599728, 19624.75016129820],
[0.00000000140, 2.90637712614, 48947.66387067660],
[0.00000000129, 3.95303623681, 32858.61374281979],
[0.00000000156, 6.01143316387, 29057.89729034999],
[0.00000000134, 5.75241675118, 68050.42387851159],
[0.00000000154, 3.66827363753, 276.74577186440],
[0.00000000176, 3.77298381177, 66813.56483573320],
[0.00000000126, 5.00217740223, 27461.71084806540],
[0.00000000135, 1.34807013920, 53285.18483524180],
[0.00000000150, 0.25029475344, 290.97286586600],
[0.00000000152, 3.13035670092, 29043.67019634839],
[0.00000000169, 5.04348109430, 73.29712585900],
[0.00000000166, 5.39219948035, 41236.03871706720],
[0.00000000163, 5.59796070987, 7576.56007357400],
[0.00000000126, 0.77391784606, 49.99662190420],
[0.00000000163, 0.44241846674, 20350.30502114640],
[0.00000000136, 3.09066368912, 418.92439890060],
[0.00000000154, 0.47086190960, 28418.00000403600],
[0.00000000120, 0.88536981986, 29573.36116144300],
[0.00000000132, 1.48009769040, 17085.95866572220],
[0.00000000126, 1.39497760964, 966.97087743560],
[0.00000000143, 3.84026797958, 14128.24277124560],
[0.00000000147, 2.11627427804, 34363.36559755600],
[0.00000000106, 2.04696932293, 37674.99639427640],
[0.00000000106, 1.43873202489, 27682.14074415640],
[0.00000000149, 0.09286508794, 8144.27871130440],
[0.00000000103, 0.01992041470, 18300.69368504279],
[0.00000000121, 3.57602835443, 45.14121963660],
[0.00000000125, 0.11630302078, 149.56319713460],
[0.00000000102, 4.17947097730, 2333.19639287200],
[0.00000000099, 1.51324741657, 10419.47109464820],
[0.00000000133, 3.02183293676, 76251.32777062019],
[0.00000000136, 4.17517197268, 3646.35037735440],
[0.00000000123, 0.44045588682, 515.46387109300],
[0.00000000113, 5.69261397718, 10110.19277199240],
[0.00000000098, 6.23797900467, 202.25339517410],
[0.00000000099, 3.75627530197, 59728.66805461800],
[0.00000000101, 4.62832557536, 65236.22129328540],
[0.00000000111, 1.25947267588, 10846.06928552420],
[0.00000000110, 5.87455577536, 38500.27603107220],
[0.00000000128, 6.01024562160, 90394.82301305079],
[0.00000000091, 1.77665981007, 1539.31586981200],
[0.00000000092, 0.99804571578, 95.97922721780],
[0.00000000120, 3.93060866244, 38526.57435087200],
[0.00000000117, 2.24143299549, 56600.27928952220],
[0.00000000118, 6.09121325940, 29786.66025688100],
[0.00000000098, 4.60938156207, 11787.10597030980],
[0.00000000097, 3.92727733144, 11794.15220700780],
[0.00000000093, 5.23395435043, 14169.79356223040],
[0.00000000096, 5.27525709038, 8734.41897214660],
[0.00000000094, 0.18166654805, 67589.08744705719],
[0.00000000110, 4.96279287076, 48417.97290558199],
[0.00000000086, 0.39533409505, 3956.50801601940],
[0.00000000085, 5.69642646462, 37703.97802425580],
[0.00000000114, 5.19676285428, 70743.77453195279],
[0.00000000081, 5.51324815184, 412.37109687440],
[0.00000000089, 2.13409771828, 44768.09940987860],
[0.00000000084, 6.02475904578, 10632.77019008620],
[0.00000000085, 4.60912614442, 45585.17281218740],
[0.00000000078, 4.47358603432, 114.43928868521],
[0.00000000097, 4.02223363535, 10218.80847051840],
[0.00000000081, 1.03870237004, 9793.80090233580],
[0.00000000092, 0.80301220092, 24383.07910844140],
[0.00000000087, 2.15124790938, 28313.28880466100],
[0.00000000075, 5.17868679355, 63658.87775083760],
[0.00000000078, 5.81927313665, 567.71863773040],
[0.00000000075, 1.72618192481, 19580.48825767080],
[0.00000000071, 0.10259261764, 90695.75207512038],
[0.00000000077, 6.16012067704, 1573.82042409880],
[0.00000000076, 5.12884307551, 49515.38250840700],
[0.00000000069, 0.29569499484, 10175.25787357520],
[0.00000000061, 4.80385549281, 19889.76658032659],
[0.00000000060, 4.56685040226, 30426.55754319500],
[0.00000000062, 4.16222812699, 42430.48572729180],
[0.00000000050, 6.17899839001, 22779.43724619380],
[0.00000000048, 1.52546758016, 20639.87018786000],
[0.00000000046, 4.41738494249, 34570.06633485260],
[0.00000000037, 4.69675087759, 44007.82926973960],
], [
[10213.52943052898, 0.00000000000, 0.00000000000],
[0.00095707712, 2.46424448979, 10213.28554621100],
[0.00014444977, 0.51624564679, 20426.57109242200],
[0.00000213374, 1.79547929368, 30639.85663863300],
[0.00000151669, 6.10635282369, 1577.34354244780],
[0.00000173904, 2.65535879443, 26.29831979980],
[0.00000082233, 5.70234133730, 191.44826611160],
[0.00000069734, 2.68136034979, 9437.76293488700],
[0.00000052408, 3.60013087656, 775.52261132400],
[0.00000038318, 1.03379038025, 529.69096509460],
[0.00000029633, 1.25056322354, 5507.55323866740],
[0.00000025056, 6.10664792855, 10404.73381232260],
[0.00000017772, 6.19369798901, 1109.37855209340],
[0.00000016510, 2.64330452640, 7.11354700080],
[0.00000014230, 5.45138233941, 9153.90361602180],
[0.00000012607, 1.24464400689, 40853.14218484400],
[0.00000011627, 4.97604495371, 213.29909543800],
[0.00000012563, 1.88122199199, 382.89653222320],
[0.00000008869, 0.95282732248, 13367.97263110660],
[0.00000007374, 4.39476760580, 10206.17199921020],
[0.00000006552, 2.28168808058, 2352.86615377180],
[0.00000006255, 4.08056644034, 3154.68708489560],
[0.00000006697, 5.05673427795, 801.82093112380],
[0.00000004084, 4.12103826030, 18837.49819713819],
[0.00000004882, 3.44515199115, 11015.10647733480],
[0.00000003549, 6.19934345402, 5.52292430740],
[0.00000003448, 1.77405651704, 11322.66409830440],
[0.00000004290, 0.08154809210, 6283.07584999140],
[0.00000003694, 2.48453945256, 5661.33204915220],
[0.00000003555, 1.48036949420, 1059.38193018920],
[0.00000003023, 2.24092938317, 18073.70493865020],
[0.00000003000, 0.39169917698, 15.25247118500],
[0.00000002563, 0.35147506973, 22003.91463486980],
[0.00000002774, 1.45683830639, 10239.58386601080],
[0.00000002951, 5.34618097429, 7084.89678111520],
[0.00000002344, 2.36652432105, 17298.18232732620],
[0.00000002405, 2.36085282088, 10596.18207843420],
[0.00000001720, 4.72129626061, 10186.98722641120],
[0.00000002209, 2.07730338665, 8635.94200376320],
[0.00000002122, 4.47091605309, 8624.21265092720],
[0.00000001527, 0.67146857292, 14143.49524243060],
[0.00000001473, 2.59350470099, 7064.12138562280],
[0.00000001311, 0.90408820221, 12566.15169998280],
[0.00000001474, 5.92236241437, 9786.68735533500],
[0.00000001237, 2.59740787132, 4551.95349705880],
[0.00000001219, 2.83617320088, 9676.48103411560],
[0.00000001116, 3.83715584719, 21228.39202354580],
[0.00000001006, 4.26200749078, 426.59819087600],
[0.00000001150, 2.35531987378, 9690.70812811720],
[0.00000001219, 2.27324315182, 522.57741809380],
[0.00000001150, 0.81088598778, 10742.97651130560],
[0.00000001101, 3.74248783564, 18307.80723204360],
[0.00000001031, 2.03889374176, 38.02767263580],
[0.00000000971, 6.10590045414, 3532.06069281140],
[0.00000000844, 4.75124127613, 10988.80815753500],
[0.00000000908, 1.06613723738, 10021.83728009940],
[0.00000000824, 0.23090829723, 28286.99048486120],
[0.00000000821, 2.60456032773, 19.66976089979],
[0.00000000728, 0.10716917942, 4705.73230754360],
[0.00000000744, 3.33129778857, 536.80451209540],
[0.00000000816, 1.27303930175, 19896.88012732740],
[0.00000000929, 1.08024621325, 11790.62908865880],
[0.00000000797, 2.23891816523, 3723.50895892300],
[0.00000000704, 5.95307260017, 20.77539549240],
[0.00000000665, 0.21346689192, 7860.41939243920],
[0.00000000733, 2.22147883292, 19360.07561523199],
[0.00000000702, 1.76206343944, 19374.30270923360],
[0.00000000575, 2.38792087791, 6770.71060124560],
[0.00000000538, 1.52023264138, 25934.12433108940],
[0.00000000690, 4.01873754171, 19651.04848109800],
[0.00000000532, 4.41576130890, 574.34479833480],
[0.00000000540, 2.15936134728, 16496.36139620240],
[0.00000000576, 5.41170044566, 206.18554843720],
[0.00000000482, 0.40815793538, 3340.61242669980],
[0.00000000501, 3.08578363577, 245.83164622940],
[0.00000000488, 5.22311611589, 25158.60171976540],
[0.00000000450, 0.21279844600, 11.72935283600],
[0.00000000432, 1.32004964493, 103.09277421860],
[0.00000000434, 5.91094755233, 19786.67380610799],
[0.00000000564, 0.38776462529, 19367.18916223280],
[0.00000000421, 2.71057839701, 13936.79450513400],
[0.00000000549, 6.08792865644, 3930.20969621960],
[0.00000000478, 4.70234715828, 14945.31617355440],
[0.00000000408, 4.80890663927, 32217.20018108080],
[0.00000000404, 2.85003595942, 29864.33402730900],
[0.00000000407, 2.94002049006, 10220.39909321180],
[0.00000000359, 0.72354778897, 419.48464387520],
[0.00000000449, 1.44520508753, 8662.24032356300],
[0.00000000353, 2.22195492336, 51066.42773105500],
[0.00000000324, 1.40308439067, 29580.47470844380],
[0.00000000443, 1.93864353398, 9146.79006902100],
[0.00000000314, 0.96837035284, 20618.01935853360],
[0.00000000324, 5.10759068171, 24356.78078864160],
[0.00000000324, 1.80146948625, 18830.38465013739],
[0.00000000370, 6.16895004656, 2218.75710418680],
[0.00000000278, 2.20429108375, 18844.61174413899],
[0.00000000286, 3.08459438435, 17277.40693183380],
[0.00000000383, 0.13890934755, 4732.03062734340],
[0.00000000292, 0.43528982259, 29088.81141598500],
[0.00000000273, 5.84415407168, 9573.38825989700],
[0.00000000324, 2.14144542781, 9999.98645077300],
[0.00000000264, 5.20407029554, 220.41264243880],
[0.00000000254, 0.34411959301, 28521.09277825460],
[0.00000000300, 3.76014360906, 8094.52168583260],
[0.00000000301, 3.64457981649, 20400.27277262220],
[0.00000000287, 1.84003536598, 1589.07289528380],
[0.00000000206, 0.97167234723, 10234.06094170340],
[0.00000000212, 0.24173677600, 36.02786667740],
[0.00000000216, 5.88618923030, 18875.52586977400],
[0.00000000198, 1.89506914939, 20452.86941222180],
[0.00000000258, 6.27611355094, 1551.04522264800],
[0.00000000197, 2.09222675324, 9683.59458111640],
[0.00000000217, 5.79472589364, 9103.90699411760],
[0.00000000188, 0.39123199129, 19573.37471066999],
[0.00000000195, 6.23142464829, 30110.16567353840],
[0.00000000187, 5.49670351645, 170.67287061920],
[0.00000000178, 4.90042854659, 10787.63034454580],
[0.00000000188, 1.62614804098, 9161.01716302260],
[0.00000000211, 2.71884568392, 15720.83878487840],
[0.00000000177, 1.88170417337, 33019.02111220460],
[0.00000000209, 2.66033422116, 3442.57494496540],
[0.00000000164, 4.92240093026, 10426.58464164900],
[0.00000000186, 5.13678812068, 7255.56965173440],
[0.00000000177, 5.70206821967, 9992.87290377220],
[0.00000000214, 2.70027196648, 3128.38876509580],
[0.00000000208, 3.38876526854, 17778.11626694899],
[0.00000000147, 4.25008782855, 16983.99614745660],
[0.00000000148, 3.46404418130, 21202.09370374600],
[0.00000000189, 1.43553862242, 2379.16447357160],
[0.00000000139, 2.99154379541, 110.20632121940],
[0.00000000159, 5.23851679605, 10007.09999777380],
[0.00000000136, 0.88942869764, 22805.73556599360],
[0.00000000155, 5.90500835975, 12592.45001978260],
[0.00000000151, 0.03422618975, 27991.40181316000],
[0.00000000153, 4.01743770323, 33794.54372352860],
[0.00000000121, 0.51392111799, 21535.94964451540],
[0.00000000109, 2.25388616761, 26735.94526221320],
[0.00000000109, 0.78612823474, 6681.22485339960],
[0.00000000122, 4.84805105466, 19992.85935454519],
[0.00000000112, 3.31796669604, 36949.23080842420],
[0.00000000106, 3.34507236765, 10103.07922499160],
[0.00000000114, 4.36384000196, 20007.08644854680],
[0.00000000098, 5.07711736751, 135.62532501000],
[0.00000000120, 5.41870615047, 37724.75341974820],
[0.00000000103, 2.62610244425, 20213.27199698400],
[0.00000000085, 5.04808202087, 9830.38901398780],
[0.00000000103, 2.01549383816, 45585.17281218740],
[0.00000000088, 2.62613816931, 21.85082932640],
[0.00000000084, 3.50355880173, 639.89728631400],
[0.00000000099, 0.61079620895, 41654.96311596780],
[0.00000000088, 3.63836700262, 49515.38250840700],
[0.00000000098, 2.42401801881, 23581.25817731760],
[0.00000000081, 0.46468679835, 77.67377042800],
[0.00000000092, 4.82530051729, 29043.67019634839],
[0.00000000102, 4.27051236894, 15874.61759536320],
[0.00000000090, 4.34075776744, 29057.89729034999],
[0.00000000081, 0.01896422336, 24150.08005134500],
[0.00000000093, 1.79250830018, 12432.04265039780],
[0.00000000087, 5.25157021446, 14128.24277124560],
[0.00000000089, 5.65756996753, 377.37360791580],
[0.00000000097, 5.67942873241, 227.47613278900],
[0.00000000076, 2.93363913259, 38204.68735937100],
[0.00000000091, 2.60544242067, 1052.26838318840],
[0.00000000087, 3.82284200928, 27511.46787353720],
[0.00000000073, 4.75280755154, 40879.44050464380],
[0.00000000067, 3.54815262526, 30666.15495843280],
[0.00000000067, 5.81350818057, 20809.46762464520],
[0.00000000064, 4.24772678145, 153.77881048480],
[0.00000000064, 2.99454749109, 27197.28169366760],
[0.00000000070, 4.03868009742, 56600.27928952220],
[0.00000000071, 4.33628806850, 39264.06928956020],
[0.00000000069, 1.73648747605, 37410.56723987860],
[0.00000000065, 1.08206062736, 68050.42387851159],
[0.00000000062, 4.77698454650, 3914.95722503460],
[0.00000000061, 4.96121014691, 34596.36465465240],
[0.00000000063, 5.04865067599, 53445.59220462660],
[0.00000000058, 3.74010494151, 1066.49547719000],
[0.00000000057, 5.39355890141, 20419.45754542119],
[0.00000000057, 3.59399518494, 735.87651353180],
[0.00000000065, 2.10322000074, 74.78159856730],
[0.00000000073, 1.31083648835, 11272.66747640020],
[0.00000000055, 1.33161298098, 18300.69368504279],
[0.00000000065, 4.21150522641, 49.75702547180],
[0.00000000061, 5.66161679402, 17468.85519794540],
[0.00000000053, 4.30231233835, 18849.22754997420],
[0.00000000055, 2.63906959481, 52670.06959330260],
[0.00000000050, 5.69803054279, 39793.76025465480],
[0.00000000049, 0.77345264124, 35371.88726597640],
[0.00000000048, 6.00565977593, 283.85931886520],
[0.00000000047, 2.63299859494, 51868.24866217880],
[0.00000000046, 0.05105081843, 38526.57435087200],
[0.00000000050, 4.37549274002, 28513.97923125379],
[0.00000000046, 2.93422086586, 27682.14074415640],
[0.00000000051, 5.45979584751, 60530.48898574180],
[0.00000000045, 5.59492908223, 467.96499035440],
[0.00000000045, 2.34680401001, 9411.46461508720],
[0.00000000045, 0.02999265111, 44809.65020086340],
[0.00000000043, 5.62725673544, 14.22709400160],
[0.00000000047, 3.73567275749, 64460.69868196140],
[0.00000000046, 0.12586526756, 57375.80190084620],
[0.00000000044, 2.03114426076, 18314.92077904440],
[0.00000000039, 0.99375127466, 94138.32702008578],
[0.00000000053, 0.41974404621, 30831.30490474460],
[0.00000000055, 1.38351566741, 38500.27603107220],
[0.00000000041, 4.47012768909, 40077.61957352000],
[0.00000000041, 0.36665992484, 19999.97290154599],
[0.00000000040, 3.06358586355, 813.55028395980],
[0.00000000040, 2.16802870803, 59728.66805461800],
[0.00000000037, 1.08739100421, 17085.95866572220],
[0.00000000039, 1.31040309875, 48739.85989708300],
[0.00000000036, 1.43280677914, 42456.78404709160],
[0.00000000037, 0.14190533464, 29050.78374334920],
[0.00000000037, 3.66792179278, 20956.26205751660],
[0.00000000025, 3.38876180652, 7058.59846131540],
[0.00000000031, 6.16829805337, 10192.51015071860],
], [
[0.00054127076, 0.00000000000, 0.00000000000],
[0.00003891460, 0.34514360047, 10213.28554621100],
[0.00001337880, 2.02011286082, 20426.57109242200],
[0.00000023836, 2.04592119012, 26.29831979980],
[0.00000019331, 3.53527371458, 30639.85663863300],
[0.00000009984, 3.97130221102, 775.52261132400],
[0.00000007046, 1.51962593409, 1577.34354244780],
[0.00000006014, 0.99926757893, 191.44826611160],
[0.00000003163, 4.36095475762, 9437.76293488700],
[0.00000002125, 2.65810625752, 40853.14218484400],
[0.00000001934, 3.39287946981, 382.89653222320],
[0.00000001460, 6.04899046273, 529.69096509460],
[0.00000001346, 2.94633106219, 5507.55323866740],
[0.00000001025, 1.40598904981, 10404.73381232260],
[0.00000001221, 3.73339139385, 3154.68708489560],
[0.00000001033, 3.52858472904, 11015.10647733480],
[0.00000000955, 5.11133878923, 801.82093112380],
[0.00000000742, 1.49198584483, 1109.37855209340],
[0.00000000525, 3.32087042103, 213.29909543800],
[0.00000000578, 0.92614279843, 10239.58386601080],
[0.00000000602, 5.19220099775, 7084.89678111520],
[0.00000000431, 2.67159914364, 13367.97263110660],
[0.00000000389, 4.14116341739, 8635.94200376320],
[0.00000000355, 1.12061570874, 9153.90361602180],
[0.00000000301, 3.90047984197, 10596.18207843420],
[0.00000000212, 5.32697688872, 18837.49819713819],
[0.00000000260, 0.22761369281, 2352.86615377180],
[0.00000000243, 4.70747902991, 6283.07584999140],
[0.00000000196, 4.10467294392, 11790.62908865880],
[0.00000000194, 6.01197759470, 7860.41939243920],
[0.00000000140, 4.97015671653, 14143.49524243060],
[0.00000000134, 4.10529011674, 17298.18232732620],
[0.00000000119, 3.39375528828, 11322.66409830440],
[0.00000000126, 0.09854516140, 18073.70493865020],
[0.00000000122, 5.92478855457, 574.34479833480],
[0.00000000107, 0.35660030184, 1059.38193018920],
[0.00000000108, 2.25352052666, 12566.15169998280],
[0.00000000093, 5.48716819776, 10021.83728009940],
[0.00000000084, 4.89744332968, 18307.80723204360],
[0.00000000074, 2.35354025573, 426.59819087600],
[0.00000000093, 4.99316908815, 14945.31617355440],
[0.00000000069, 3.86409065860, 51066.42773105500],
[0.00000000082, 5.36280178643, 10186.98722641120],
[0.00000000077, 3.75728548372, 3723.50895892300],
[0.00000000063, 5.39882267787, 21228.39202354580],
[0.00000000056, 4.11564786973, 7064.12138562280],
[0.00000000056, 6.26920407723, 32217.20018108080],
[0.00000000060, 5.02186497542, 19367.18916223280],
[0.00000000058, 5.13263709670, 20400.27277262220],
[0.00000000051, 4.52870390511, 22003.91463486980],
[0.00000000041, 3.83822107919, 16496.36139620240],
[0.00000000041, 3.36020411807, 4705.73230754360],
[0.00000000043, 5.98371820588, 15720.83878487840],
[0.00000000047, 0.18498155367, 18875.52586977400],
[0.00000000038, 0.52232581277, 1551.04522264800],
[0.00000000039, 5.05391675878, 10742.97651130560],
[0.00000000036, 3.16242472203, 20452.86941222180],
[0.00000000035, 5.17462577483, 29088.81141598500],
[0.00000000035, 3.47325394141, 24356.78078864160],
[0.00000000031, 4.74511706231, 28521.09277825460],
[0.00000000029, 0.19383091192, 19896.88012732740],
[0.00000000033, 1.80059867635, 20618.01935853360],
[0.00000000024, 0.14022912457, 21202.09370374600],
[0.00000000022, 4.73565067573, 10988.80815753500],
[0.00000000018, 0.74039763161, 25158.60171976540],
[0.00000000019, 1.53770232218, 28286.99048486120],
[0.00000000014, 1.49084059765, 30110.16567353840],
[0.00000000013, 4.72171283479, 29864.33402730900],
[0.00000000013, 5.79700427846, 29580.47470844380],
[0.00000000014, 3.69205225010, 27511.46787353720],
], [
[0.00000135742, 4.80389020993, 10213.28554621100],
[0.00000077846, 3.66876371591, 20426.57109242200],
[0.00000026023, 0.00000000000, 0.00000000000],
[0.00000001214, 5.31970006917, 30639.85663863300],
[0.00000000254, 4.15021671822, 40853.14218484400],
[0.00000000008, 5.55523563261, 51066.42773105500],
[0.00000000008, 1.40501229148, 1577.34354244780],
[0.00000000006, 1.27791479726, 10404.73381232260],
[0.00000000006, 5.76447068962, 10239.58386601080],
], [
[0.00000114016, 3.14159265359, 0.00000000000],
[0.00000003209, 5.20514170164, 20426.57109242200],
[0.00000001714, 2.51099591706, 10213.28554621100],
[0.00000000050, 0.71356059861, 30639.85663863300],
[0.00000000023, 5.68127607034, 40853.14218484400],
], [
[0.00000000874, 3.14159265359, 0.00000000000],
[0.00000000117, 0.54643013000, 20426.57109242200],
[0.00000000118, 1.90548541922, 10213.28554621100],
[0.00000000002, 1.07734277826, 40853.14218484400],
[0.00000000002, 1.89460223529, 30639.85663863300],
]],
('Venus', 'B'):[[
[0.05923638472, 0.26702775813, 10213.28554621100],
[0.00040107978, 1.14737178106, 20426.57109242200],
[0.00032814918, 3.14159265359, 0.00000000000],
[0.00001011392, 1.08946123021, 30639.85663863300],
[0.00000149458, 6.25390296069, 18073.70493865020],
[0.00000137788, 0.86020146523, 1577.34354244780],
[0.00000129973, 3.67152483651, 9437.76293488700],
[0.00000119507, 3.70468812804, 2352.86615377180],
[0.00000107971, 4.53903677647, 22003.91463486980],
[0.00000092029, 1.53954562706, 9153.90361602180],
[0.00000052982, 2.28138172277, 5507.55323866740],
[0.00000045617, 0.72319641722, 10239.58386601080],
[0.00000038855, 2.93437865147, 10186.98722641120],
[0.00000043491, 6.14015776699, 11790.62908865880],
[0.00000041700, 5.99126845246, 19896.88012732740],
[0.00000039644, 3.86842095901, 8635.94200376320],
[0.00000039175, 3.94960351174, 529.69096509460],
[0.00000033320, 4.83194909595, 14143.49524243060],
[0.00000023711, 2.90646621218, 10988.80815753500],
[0.00000023500, 2.00770618322, 13367.97263110660],
[0.00000021809, 2.69701424951, 19651.04848109800],
[0.00000020653, 0.98666685459, 775.52261132400],
[0.00000016976, 4.13711782135, 10021.83728009940],
[0.00000017835, 5.96268643102, 25934.12433108940],
[0.00000014949, 5.61075168206, 10404.73381232260],
[0.00000018579, 1.80529277514, 40853.14218484400],
[0.00000015407, 3.29563855296, 11015.10647733480],
[0.00000012936, 5.42651448496, 29580.47470844380],
[0.00000011962, 3.57604253827, 10742.97651130560],
[0.00000011827, 1.19070919600, 8624.21265092720],
[0.00000011466, 5.12780364967, 6283.07584999140],
[0.00000009484, 2.75167834335, 191.44826611160],
[0.00000013129, 5.70735942511, 9683.59458111640],
[0.00000008583, 0.43182249199, 9786.68735533500],
[0.00000009763, 0.14614896296, 20618.01935853360],
[0.00000008148, 1.30548515603, 15720.83878487840],
[0.00000006050, 6.26541665966, 11322.66409830440],
[0.00000005955, 4.92235372433, 1059.38193018920],
[0.00000006983, 3.44920932146, 17298.18232732620],
[0.00000006228, 1.13312070908, 29864.33402730900],
[0.00000006186, 4.92498052443, 19367.18916223280],
[0.00000006155, 2.42413946900, 4705.73230754360],
[0.00000005204, 3.42528906628, 9103.90699411760],
[0.00000006000, 3.57639095526, 3154.68708489560],
[0.00000004796, 3.86676184909, 7860.41939243920],
[0.00000005289, 4.99182712443, 7084.89678111520],
[0.00000004070, 5.58798144740, 12566.15169998280],
[0.00000003942, 5.68758787835, 10206.17199921020],
[0.00000003797, 3.89520601076, 10192.51015071860],
[0.00000003798, 6.06410995916, 10234.06094170340],
[0.00000003579, 0.73789669235, 4551.95349705880],
[0.00000003641, 2.61501257205, 15874.61759536320],
[0.00000003266, 0.97517223854, 23581.25817731760],
[0.00000002813, 0.29951755546, 9411.46461508720],
[0.00000003048, 2.51085146990, 33794.54372352860],
[0.00000002559, 4.58043833032, 801.82093112380],
[0.00000002462, 5.05790874754, 29050.78374334920],
[0.00000002593, 5.73113176751, 20213.27199698400],
[0.00000002625, 4.24272906574, 213.29909543800],
[0.00000002246, 0.82112963936, 28286.99048486120],
[0.00000002229, 2.22457598233, 10426.58464164900],
[0.00000001742, 1.48394229233, 7058.59846131540],
[0.00000001660, 5.42775825275, 32217.20018108080],
[0.00000001491, 4.64883377941, 1109.37855209340],
[0.00000002010, 0.75702888128, 9999.98645077300],
[0.00000001562, 3.93962080463, 37724.75341974820],
[0.00000001538, 2.17309577080, 21535.94964451540],
[0.00000001546, 4.70759186462, 14945.31617355440],
[0.00000001200, 1.48282382657, 9830.38901398780],
[0.00000001224, 5.55090394449, 5661.33204915220],
[0.00000001111, 1.20276209213, 9573.38825989700],
[0.00000001064, 1.98891375536, 26.29831979980],
[0.00000001041, 5.38535116069, 7.11354700080],
[0.00000001036, 1.16719443387, 8662.24032356300],
[0.00000001143, 3.20596958337, 3532.06069281140],
[0.00000001201, 0.81913312536, 8094.52168583260],
[0.00000001005, 2.38429892132, 27511.46787353720],
[0.00000001047, 4.56525030769, 20419.45754542119],
[0.00000000968, 6.18496721871, 25158.60171976540],
[0.00000001044, 1.98055689074, 10596.18207843420],
[0.00000000962, 0.48573513747, 23958.63178523340],
[0.00000000846, 0.01566400887, 3128.38876509580],
[0.00000000792, 5.39686899735, 24356.78078864160],
[0.00000000858, 5.34692750735, 41654.96311596780],
[0.00000000757, 6.25904553773, 20452.86941222180],
[0.00000000801, 4.62406152514, 9929.42622734580],
[0.00000000802, 5.37234892520, 10497.14486507620],
[0.00000000750, 3.85219782842, 21228.39202354580],
[0.00000000700, 1.98097957188, 3930.20969621960],
[0.00000000719, 6.11596800207, 10218.80847051840],
[0.00000000672, 6.23429601219, 14765.23904326980],
[0.00000000639, 5.37566437358, 1589.07289528380],
[0.00000000605, 2.42330391120, 10251.31321884680],
[0.00000000726, 6.16683781802, 18875.52586977400],
[0.00000000613, 5.99731180690, 4732.03062734340],
[0.00000000720, 3.84286345199, 10207.76262190360],
[0.00000000637, 6.17053891156, 10220.39909321180],
[0.00000000515, 1.03001478293, 22779.43724619380],
[0.00000000574, 0.43813688572, 17085.95866572220],
[0.00000000510, 1.41065159851, 9161.01716302260],
[0.00000000569, 3.34601425125, 3340.61242669980],
[0.00000000608, 1.25236241968, 10175.25787357520],
[0.00000000524, 2.39794248670, 26087.90314157420],
[0.00000000542, 1.34665646732, 29088.81141598500],
[0.00000000527, 4.01994270827, 18849.22754997420],
[0.00000000569, 1.65498800378, 39264.06928956020],
[0.00000000518, 4.96996115446, 30213.25844775700],
[0.00000000514, 5.78413007838, 12592.45001978260],
[0.00000000538, 4.56198493922, 10063.72234907640],
[0.00000000484, 4.18538027381, 14919.01785375460],
[0.00000000493, 4.79939382739, 9146.79006902100],
[0.00000000427, 3.76876868949, 11272.66747640020],
[0.00000000495, 0.49175293655, 45585.17281218740],
[0.00000000494, 3.74345863918, 31441.67756975680],
[0.00000000524, 0.97991794166, 30110.16567353840],
[0.00000000483, 1.87898057316, 51066.42773105500],
[0.00000000505, 3.70047474212, 20400.27277262220],
[0.00000000351, 4.34026574490, 10137.01947493540],
[0.00000000355, 5.56672554631, 18837.49819713819],
[0.00000000328, 3.78427378910, 6681.22485339960],
[0.00000000349, 4.20550749672, 20956.26205751660],
[0.00000000333, 4.44969281739, 28521.09277825460],
[0.00000000296, 2.83205515646, 17277.40693183380],
[0.00000000311, 2.57334132897, 20809.46762464520],
[0.00000000294, 0.75089224483, 3149.16416058820],
[0.00000000377, 3.98143308775, 21202.09370374600],
[0.00000000272, 5.56183082489, 16496.36139620240],
[0.00000000314, 0.02584607093, 13745.34623902240],
[0.00000000263, 0.55328410985, 36147.40987730040],
[0.00000000286, 5.16408902215, 426.59819087600],
[0.00000000279, 4.29871615943, 19999.97290154599],
[0.00000000280, 1.92925047377, 49515.38250840700],
[0.00000000265, 4.81168402147, 20235.12282631040],
[0.00000000273, 5.12740051559, 35371.88726597640],
[0.00000000306, 5.28903794869, 382.89653222320],
[0.00000000223, 2.50591724074, 26709.64694241340],
[0.00000000235, 5.96522395118, 10198.03307502600],
[0.00000000234, 3.52866583267, 10228.53801739600],
[0.00000000224, 6.24561979789, 7064.12138562280],
[0.00000000251, 2.84739274245, 33019.02111220460],
[0.00000000196, 1.50610393790, 31749.23519072640],
[0.00000000192, 1.69321442572, 13341.67431130680],
[0.00000000180, 6.19353087076, 39793.76025465480],
[0.00000000199, 1.16433321880, 22805.73556599360],
[0.00000000180, 3.72646417141, 1551.04522264800],
[0.00000000173, 3.35235705827, 53445.59220462660],
[0.00000000195, 1.51901264131, 43232.30665841560],
[0.00000000174, 2.84049662693, 9967.45389998160],
[0.00000000163, 4.29160537719, 36949.23080842420],
[0.00000000169, 0.37000676558, 10459.11719244040],
[0.00000000137, 5.61149803116, 10529.67741586760],
[0.00000000139, 0.87847805052, 16522.65971600220],
[0.00000000139, 4.12576475427, 36301.18868778519],
[0.00000000127, 5.14447758616, 5481.25491886760],
[0.00000000131, 3.11317801589, 9896.89367655440],
[0.00000000131, 0.89697384735, 3442.57494496540],
[0.00000000121, 1.32802112907, 38734.37832446560],
[0.00000000122, 1.59017183044, 10110.19277199240],
[0.00000000123, 2.33714216061, 10316.37832042960],
[0.00000000133, 2.90682399304, 9793.80090233580],
[0.00000000111, 2.52077634760, 13936.79450513400],
[0.00000000120, 0.36076947165, 536.80451209540],
[0.00000000115, 2.53355582059, 26735.94526221320],
[0.00000000108, 2.65839634325, 10232.95530711079],
[0.00000000108, 0.55230439694, 10193.61578531121],
[0.00000000138, 1.06919239240, 65236.22129328540],
[0.00000000101, 3.17012502017, 19317.19254032860],
[0.00000000127, 5.63110477712, 10288.06714477830],
[0.00000000127, 3.86278127025, 10138.50394764370],
[0.00000000137, 2.93350659460, 47162.51635463520],
[0.00000000095, 5.03917884334, 52175.80628314840],
[0.00000000094, 0.71308489207, 38500.27603107220],
[0.00000000092, 5.46204624886, 11764.33076885900],
[0.00000000096, 1.52914774412, 9690.70812811720],
[0.00000000101, 0.83318284426, 6489.77658728800],
[0.00000000115, 3.76443612245, 522.57741809380],
[0.00000000089, 2.53312656681, 10735.86296430480],
[0.00000000082, 0.85628515615, 2379.16447357160],
[0.00000000103, 5.22683237620, 103.09277421860],
[0.00000000090, 2.12423586627, 28313.28880466100],
[0.00000000090, 0.39668501735, 9580.50180689780],
[0.00000000074, 6.02680095550, 3723.50895892300],
[0.00000000081, 5.25045057985, 10419.47109464820],
[0.00000000080, 4.23724598221, 10007.09999777380],
[0.00000000091, 2.48874147947, 10846.06928552420],
[0.00000000085, 3.82784790321, 51868.24866217880],
[0.00000000081, 2.26235214191, 3903.91137641980],
[0.00000000097, 0.77295091600, 18307.80723204360],
[0.00000000094, 0.17063414792, 6872.67311951120],
[0.00000000080, 5.62254102739, 29999.95935231900],
[0.00000000068, 2.71762936670, 16983.99614745660],
[0.00000000066, 0.76731351736, 20.77539549240],
[0.00000000075, 0.36155638007, 39302.09696219600],
[0.00000000075, 2.27327165974, 8521.11987670860],
[0.00000000058, 2.14482855875, 8631.32619792800],
[0.00000000064, 5.83569051301, 2118.76386037840],
[0.00000000058, 2.98524209824, 19889.76658032659],
[0.00000000054, 1.78260668333, 40077.61957352000],
[0.00000000055, 4.70485939861, 639.89728631400],
[0.00000000060, 5.89661892920, 41962.52073693740],
[0.00000000066, 2.24746237999, 74.78159856730],
[0.00000000061, 3.40726181591, 27490.69247804480],
[0.00000000051, 3.07811180039, 24150.08005134500],
[0.00000000057, 2.30081371235, 20529.66386664059],
[0.00000000052, 2.37192464233, 29573.36116144300],
[0.00000000052, 4.76610409132, 57375.80190084620],
[0.00000000047, 1.61630288856, 30831.30490474460],
[0.00000000054, 5.89684197257, 19903.99367432819],
[0.00000000040, 5.32101847424, 42430.48572729180],
[0.00000000051, 5.29186795569, 29587.58825544460],
], [
[0.00513347602, 1.80364310797, 10213.28554621100],
[0.00004380100, 3.38615711591, 20426.57109242200],
[0.00000196586, 2.53001197486, 30639.85663863300],
[0.00000199162, 0.00000000000, 0.00000000000],
[0.00000014031, 2.27087044687, 9437.76293488700],
[0.00000012958, 1.50735622957, 18073.70493865020],
[0.00000011941, 5.60462450426, 1577.34354244780],
[0.00000010324, 5.24224313355, 2352.86615377180],
[0.00000009294, 6.07545631303, 22003.91463486980],
[0.00000007441, 1.50257909439, 11790.62908865880],
[0.00000008031, 0.29371105198, 9153.90361602180],
[0.00000007514, 5.08081885990, 10186.98722641120],
[0.00000004669, 3.87801635015, 10239.58386601080],
[0.00000004399, 3.58872736593, 40853.14218484400],
[0.00000003975, 1.28397121206, 10404.73381232260],
[0.00000004657, 0.75073886819, 5507.55323866740],
[0.00000003783, 4.33004753984, 19651.04848109800],
[0.00000003390, 4.88976070903, 10988.80815753500],
[0.00000003555, 1.25927550356, 19896.88012732740],
[0.00000003479, 5.50797002160, 529.69096509460],
[0.00000002884, 0.08549582037, 14143.49524243060],
[0.00000001786, 0.37134513186, 13367.97263110660],
[0.00000001600, 1.68378002982, 20618.01935853360],
[0.00000001539, 1.21683853657, 25934.12433108940],
[0.00000001341, 2.90077139758, 15720.83878487840],
[0.00000000993, 1.74681248965, 11322.66409830440],
[0.00000001165, 6.13437155401, 7860.41939243920],
[0.00000001115, 0.66743690380, 29580.47470844380],
[0.00000000923, 2.25384969096, 10021.83728009940],
[0.00000000965, 1.36425494833, 9683.59458111640],
[0.00000000973, 0.39071758442, 6283.07584999140],
[0.00000000805, 0.53331923557, 8624.21265092720],
[0.00000000913, 0.76046003719, 8635.94200376320],
[0.00000000991, 0.55319879330, 19367.18916223280],
[0.00000000609, 2.62364470139, 23581.25817731760],
[0.00000000532, 5.10925676528, 9786.68735533500],
[0.00000000476, 6.17672999981, 11015.10647733480],
[0.00000000472, 1.69672629200, 17298.18232732620],
[0.00000000503, 2.65840772485, 29864.33402730900],
[0.00000000456, 5.01205315518, 10742.97651130560],
[0.00000000478, 3.94100005156, 775.52261132400],
[0.00000000477, 3.71554345922, 10596.18207843420],
[0.00000000347, 2.34551062680, 9411.46461508720],
[0.00000000458, 2.31894399069, 9999.98645077300],
[0.00000000374, 3.76878356974, 21228.39202354580],
[0.00000000440, 4.33400244581, 15874.61759536320],
[0.00000000349, 1.31468836511, 10234.06094170340],
[0.00000000310, 5.45422332781, 10192.51015071860],
[0.00000000346, 0.94242286364, 1059.38193018920],
[0.00000000308, 4.90145899142, 3930.20969621960],
[0.00000000331, 4.89498986674, 10206.17199921020],
[0.00000000269, 2.39650266204, 801.82093112380],
[0.00000000269, 0.00589873499, 9830.38901398780],
[0.00000000261, 3.48196147279, 7058.59846131540],
[0.00000000290, 0.10953964861, 29050.78374334920],
[0.00000000283, 6.12133736787, 20419.45754542119],
[0.00000000232, 3.07845850030, 12566.15169998280],
[0.00000000265, 4.02431894973, 33794.54372352860],
[0.00000000220, 2.37315851889, 4551.95349705880],
[0.00000000247, 3.07626728158, 28286.99048486120],
[0.00000000202, 3.56872121409, 21535.94964451540],
[0.00000000225, 5.76888896320, 213.29909543800],
[0.00000000217, 0.88382111135, 20213.27199698400],
[0.00000000172, 6.12653050186, 9161.01716302260],
[0.00000000195, 5.47240855400, 37724.75341974820],
[0.00000000153, 4.07656151671, 27511.46787353720],
[0.00000000174, 1.33676849359, 32217.20018108080],
[0.00000000157, 5.98474214437, 26.29831979980],
[0.00000000163, 5.45519134760, 10426.58464164900],
[0.00000000129, 2.08748660996, 3128.38876509580],
[0.00000000131, 1.51959002513, 10218.80847051840],
[0.00000000139, 4.42330401713, 10220.39909321180],
[0.00000000126, 2.62296638037, 22779.43724619380],
[0.00000000146, 4.69869606856, 25158.60171976540],
[0.00000000172, 6.13435208788, 18837.49819713819],
[0.00000000157, 5.44507403858, 4705.73230754360],
[0.00000000117, 6.18296175153, 20400.27277262220],
[0.00000000164, 3.30849473132, 51066.42773105500],
[0.00000000113, 3.64412860654, 7.11354700080],
[0.00000000109, 5.21220660788, 8662.24032356300],
[0.00000000133, 1.78047296245, 191.44826611160],
[0.00000000117, 0.14681677884, 9146.79006902100],
[0.00000000116, 0.61940521198, 41654.96311596780],
[0.00000000096, 1.49631428731, 7084.89678111520],
[0.00000000096, 1.21744230443, 10198.03307502600],
[0.00000000082, 1.45863866349, 10207.76262190360],
[0.00000000085, 6.04057728058, 21202.09370374600],
[0.00000000083, 0.19985600927, 14919.01785375460],
[0.00000000077, 5.50132310610, 5661.33204915220],
[0.00000000077, 2.00173927326, 10228.53801739600],
[0.00000000093, 1.85466268819, 45585.17281218740],
[0.00000000066, 3.25826124156, 1109.37855209340],
[0.00000000089, 0.64100435648, 3154.68708489560],
[0.00000000061, 3.80043027736, 11272.66747640020],
[0.00000000077, 1.85516358950, 3532.06069281140],
[0.00000000062, 0.81341290651, 382.89653222320],
[0.00000000072, 2.35312965005, 9103.90699411760],
[0.00000000053, 3.21969389511, 20452.86941222180],
[0.00000000067, 1.42090542131, 24356.78078864160],
[0.00000000056, 2.97733070198, 30110.16567353840],
[0.00000000051, 4.22406663447, 20809.46762464520],
[0.00000000058, 6.20761936031, 29088.81141598500],
[0.00000000061, 3.27309494322, 49515.38250840700],
[0.00000000046, 5.49443476235, 31441.67756975680],
[0.00000000050, 4.16651052942, 13341.67431130680],
[0.00000000047, 1.25473247769, 33019.02111220460],
[0.00000000047, 2.03402044389, 23958.63178523340],
[0.00000000036, 5.24409311105, 3149.16416058820],
[0.00000000038, 4.15337829669, 18849.22754997420],
[0.00000000042, 0.43005959574, 1589.07289528380],
[0.00000000041, 1.21289342964, 12592.45001978260],
[0.00000000038, 5.91928287144, 28521.09277825460],
[0.00000000033, 3.98241699279, 4732.03062734340],
[0.00000000035, 2.24417218267, 16496.36139620240],
[0.00000000040, 6.13293942728, 26087.90314157420],
[0.00000000044, 1.78123294860, 426.59819087600],
[0.00000000041, 3.16744909855, 39264.06928956020],
[0.00000000033, 4.96183427323, 536.80451209540],
[0.00000000034, 0.12963030501, 30213.25844775700],
[0.00000000036, 5.41167321573, 522.57741809380],
[0.00000000027, 4.44250239485, 17277.40693183380],
[0.00000000034, 5.94541303751, 9929.42622734580],
[0.00000000033, 0.40689057274, 10497.14486507620],
[0.00000000023, 2.59067946967, 10175.25787357520],
[0.00000000022, 0.69625017371, 19999.97290154599],
[0.00000000023, 3.76162101633, 10251.31321884680],
[0.00000000023, 0.62711494266, 35371.88726597640],
[0.00000000022, 4.64142978776, 19889.76658032659],
[0.00000000020, 4.01315480107, 26709.64694241340],
[0.00000000020, 4.03344400680, 29573.36116144300],
[0.00000000023, 0.90416640595, 8094.52168583260],
[0.00000000022, 1.92092469688, 17085.95866572220],
[0.00000000019, 5.04938942644, 6681.22485339960],
], [
[0.00022377665, 3.38509143877, 10213.28554621100],
[0.00000281739, 0.00000000000, 0.00000000000],
[0.00000173164, 5.25563766915, 20426.57109242200],
[0.00000026945, 3.87040891568, 30639.85663863300],
[0.00000001174, 0.09768632072, 10186.98722641120],
[0.00000000685, 3.19139067811, 11790.62908865880],
[0.00000000788, 4.36515965295, 10239.58386601080],
[0.00000000592, 5.22270440328, 40853.14218484400],
[0.00000000515, 6.12821215207, 10988.80815753500],
[0.00000000538, 0.57550272342, 2352.86615377180],
[0.00000000540, 3.11657836329, 18073.70493865020],
[0.00000000454, 2.79306867629, 10404.73381232260],
[0.00000000374, 6.10468482446, 9437.76293488700],
[0.00000000431, 4.00778431184, 1577.34354244780],
[0.00000000360, 6.01747842320, 19651.04848109800],
[0.00000000375, 1.31319959789, 22003.91463486980],
[0.00000000354, 5.12509281266, 9153.90361602180],
[0.00000000150, 4.58623687118, 15720.83878487840],
[0.00000000164, 5.41790158607, 5507.55323866740],
[0.00000000159, 2.78191550878, 19896.88012732740],
[0.00000000157, 0.65774905071, 529.69096509460],
[0.00000000155, 2.54824315372, 9683.59458111640],
[0.00000000109, 2.01866665583, 14143.49524243060],
[0.00000000106, 2.28289033017, 6283.07584999140],
[0.00000000115, 3.23636374193, 20618.01935853360],
[0.00000000128, 5.32400510939, 13367.97263110660],
[0.00000000087, 3.28265082435, 11322.66409830440],
[0.00000000090, 5.23585072275, 10596.18207843420],
[0.00000000055, 4.82369879741, 7058.59846131540],
[0.00000000044, 0.58444963462, 10206.17199921020],
[0.00000000044, 2.34401612969, 19367.18916223280],
[0.00000000038, 4.55053233088, 9999.98645077300],
[0.00000000039, 5.84340580032, 10220.39909321180],
[0.00000000036, 4.41006216127, 51066.42773105500],
[0.00000000039, 3.14348236386, 9411.46461508720],
[0.00000000033, 4.55748660340, 10742.97651130560],
[0.00000000037, 2.79630938717, 25934.12433108940],
[0.00000000034, 0.55287110072, 11015.10647733480],
[0.00000000034, 2.25809144959, 29580.47470844380],
[0.00000000038, 1.88638747393, 801.82093112380],
[0.00000000034, 1.22706917271, 10021.83728009940],
[0.00000000027, 4.83867137637, 9830.38901398780],
[0.00000000027, 4.31140179350, 23581.25817731760],
[0.00000000027, 2.17187621336, 8635.94200376320],
[0.00000000020, 5.66581696952, 21228.39202354580],
[0.00000000024, 2.17208107850, 18849.22754997420],
[0.00000000020, 5.29318634138, 775.52261132400],
[0.00000000019, 2.73486845601, 3128.38876509580],
[0.00000000013, 3.40362915274, 1059.38193018920],
[0.00000000014, 0.05074160195, 7860.41939243920],
[0.00000000014, 5.43035907265, 26.29831979980],
[0.00000000012, 3.24834347355, 9103.90699411760],
[0.00000000013, 5.04826725887, 7.11354700080],
[0.00000000015, 1.42027402522, 29050.78374334920],
[0.00000000010, 4.98138067490, 10426.58464164900],
[0.00000000011, 0.85773045784, 17298.18232732620],
[0.00000000011, 4.23048200054, 29864.33402730900],
[0.00000000010, 0.26447399758, 3930.20969621960],
[0.00000000011, 1.46728576671, 20419.45754542119],
], [
[0.00000646671, 4.99166565277, 10213.28554621100],
[0.00000019952, 3.14159265359, 0.00000000000],
[0.00000005540, 0.77376923951, 20426.57109242200],
[0.00000002526, 5.44493763020, 30639.85663863300],
[0.00000000079, 1.51447613604, 10186.98722641120],
[0.00000000056, 0.63647808442, 40853.14218484400],
[0.00000000058, 5.70731176550, 10239.58386601080],
[0.00000000031, 4.72523061067, 11790.62908865880],
[0.00000000026, 1.02068113372, 10988.80815753500],
[0.00000000025, 5.60599130442, 9437.76293488700],
[0.00000000017, 2.05293621864, 2352.86615377180],
[0.00000000011, 4.33056892256, 10404.73381232260],
[0.00000000009, 1.36283915068, 19651.04848109800],
[0.00000000007, 4.69592781899, 18073.70493865020],
[0.00000000006, 2.97926526705, 22003.91463486980],
], [
[0.00000014102, 0.31537190181, 10213.28554621100],
[0.00000000190, 2.35466404492, 20426.57109242200],
[0.00000000164, 0.74476215141, 30639.85663863300],
[0.00000000214, 3.14159265359, 0.00000000000],
[0.00000000004, 2.34190883009, 40853.14218484400],
], [
[0.00000000239, 2.05201727566, 10213.28554621100],
[0.00000000039, 0.00000000000, 0.00000000000],
[0.00000000011, 3.82500275251, 20426.57109242200],
[0.00000000009, 2.32953116868, 30639.85663863300],
]],
('Venus', 'R'):[[
[0.72334820905, 0.00000000000, 0.00000000000],
[0.00489824185, 4.02151832268, 10213.28554621100],
[0.00001658058, 4.90206728012, 20426.57109242200],
[0.00001632093, 2.84548851892, 7860.41939243920],
[0.00001378048, 1.12846590600, 11790.62908865880],
[0.00000498399, 2.58682187717, 9683.59458111640],
[0.00000373958, 1.42314837063, 3930.20969621960],
[0.00000263616, 5.52938185920, 9437.76293488700],
[0.00000237455, 2.55135903978, 15720.83878487840],
[0.00000221983, 2.01346776772, 19367.18916223280],
[0.00000119467, 3.01975365264, 10404.73381232260],
[0.00000125896, 2.72769833559, 1577.34354244780],
[0.00000076178, 1.59577224486, 9153.90361602180],
[0.00000085336, 3.98607953754, 19651.04848109800],
[0.00000074347, 4.11957854039, 5507.55323866740],
[0.00000041904, 1.64273363458, 18837.49819713819],
[0.00000042493, 3.81864530735, 13367.97263110660],
[0.00000039430, 5.39019422358, 23581.25817731760],
[0.00000029042, 5.67739528728, 5661.33204915220],
[0.00000027555, 5.72392407794, 775.52261132400],
[0.00000027283, 4.82151812709, 11015.10647733480],
[0.00000031274, 2.31806719544, 9999.98645077300],
[0.00000019700, 4.96157560245, 11322.66409830440],
[0.00000019809, 0.53189326492, 27511.46787353720],
[0.00000013567, 3.75530870628, 18073.70493865020],
[0.00000012921, 1.13381083556, 10206.17199921020],
[0.00000016215, 0.56453834290, 529.69096509460],
[0.00000011821, 5.09025877427, 3154.68708489560],
[0.00000011728, 0.23432298744, 7084.89678111520],
[0.00000013079, 5.24353197586, 17298.18232732620],
[0.00000013180, 3.37207825651, 13745.34623902240],
[0.00000009097, 3.07004895769, 1109.37855209340],
[0.00000010818, 2.45024712908, 10239.58386601080],
[0.00000011438, 4.56838894696, 29050.78374334920],
[0.00000008377, 5.78327612352, 30639.85663863300],
[0.00000008193, 1.95023111860, 22003.91463486980],
[0.00000009308, 1.61615909286, 2352.86615377180],
[0.00000010652, 1.95528396140, 31441.67756975680],
[0.00000010357, 1.20234990061, 15874.61759536320],
[0.00000009585, 1.46639856228, 19999.97290154599],
[0.00000006506, 2.17390732263, 14143.49524243060],
[0.00000007562, 1.13789564977, 8624.21265092720],
[0.00000006434, 0.84419623033, 6283.07584999140],
[0.00000005898, 0.01093731110, 8635.94200376320],
[0.00000005632, 3.94956548631, 12566.15169998280],
[0.00000005523, 1.27394296557, 18307.80723204360],
[0.00000004488, 2.47835729057, 191.44826611160],
[0.00000004529, 4.73027770400, 19896.88012732740],
[0.00000006193, 3.25881250939, 6872.67311951120],
[0.00000006070, 0.35337419942, 21228.39202354580],
[0.00000004315, 2.59737099519, 4551.95349705880],
[0.00000006005, 3.37874723475, 35371.88726597640],
[0.00000003852, 1.01162850357, 9786.68735533500],
[0.00000004033, 0.00050855580, 801.82093112380],
[0.00000003920, 5.56542869407, 10596.18207843420],
[0.00000002709, 5.80195530112, 7064.12138562280],
[0.00000003216, 0.39767254848, 10186.98722641120],
[0.00000003089, 6.26174762876, 14945.31617355440],
[0.00000002982, 4.21196716354, 28521.09277825460],
[0.00000003284, 0.70709821006, 10742.97651130560],
[0.00000003484, 4.79878191875, 39302.09696219600],
[0.00000003172, 1.80518954174, 25158.60171976540],
[0.00000002463, 0.68708153678, 10988.80815753500],
[0.00000002374, 3.77948685343, 21535.94964451540],
[0.00000002198, 2.82996372521, 8662.24032356300],
[0.00000001958, 5.41763804167, 16496.36139620240],
[0.00000001876, 2.63426768393, 29580.47470844380],
[0.00000001902, 2.85782199133, 3532.06069281140],
[0.00000001706, 3.67573010379, 26.29831979980],
[0.00000001817, 0.41611036449, 4705.73230754360],
[0.00000001858, 1.50368318296, 10021.83728009940],
[0.00000002087, 6.22112874639, 43232.30665841560],
[0.00000001950, 2.21447019683, 19786.67380610799],
[0.00000001497, 0.00134773824, 17277.40693183380],
[0.00000001819, 3.23144993268, 29088.81141598500],
[0.00000001423, 5.85979618707, 9676.48103411560],
[0.00000001223, 5.55818994329, 6770.71060124560],
[0.00000001140, 5.92088900094, 13936.79450513400],
[0.00000001484, 2.47665429253, 31749.23519072640],
[0.00000001185, 1.42087628351, 4732.03062734340],
[0.00000001323, 2.48821075422, 9690.70812811720],
[0.00000001249, 1.88323673734, 19374.30270923360],
[0.00000001270, 5.24647873116, 19360.07561523199],
[0.00000001402, 5.17536780118, 10316.37832042960],
[0.00000001042, 3.05454698508, 25934.12433108940],
[0.00000001174, 1.42913732999, 18875.52586977400],
[0.00000001278, 1.35747287297, 47162.51635463520],
[0.00000000917, 6.26337648765, 20618.01935853360],
[0.00000000905, 1.12740203561, 12592.45001978260],
[0.00000001093, 4.64451720605, 33019.02111220460],
[0.00000001014, 1.09259406433, 1059.38193018920],
[0.00000000783, 2.02118183873, 24356.78078864160],
[0.00000000779, 0.41585274010, 3340.61242669980],
[0.00000000700, 1.14936815714, 16983.99614745660],
[0.00000000878, 0.87852464964, 38734.37832446560],
[0.00000000623, 0.89976912165, 17778.11626694899],
[0.00000000608, 1.58476225197, 9573.38825989700],
[0.00000000800, 3.94213003073, 10138.50394764370],
[0.00000000760, 1.31851313748, 9967.45389998160],
[0.00000000802, 2.78173370208, 51092.72605085480],
[0.00000000664, 4.45864682400, 3128.38876509580],
[0.00000000674, 5.11214939998, 382.89653222320],
[0.00000000530, 0.85392938403, 10234.06094170340],
[0.00000000509, 3.56809374595, 28286.99048486120],
[0.00000000600, 4.25927726907, 41962.52073693740],
[0.00000000601, 5.78144137895, 213.29909543800],
[0.00000000595, 2.83045104588, 22805.73556599360],
[0.00000000673, 6.06079908421, 36949.23080842420],
[0.00000000535, 5.85422519711, 9103.90699411760],
[0.00000000544, 5.44806074800, 3723.50895892300],
[0.00000000492, 3.83802404893, 27991.40181316000],
[0.00000000635, 0.76494024849, 8094.52168583260],
[0.00000000434, 6.22214487735, 27197.28169366760],
[0.00000000459, 3.55062885479, 20213.27199698400],
[0.00000000398, 6.16269975784, 10426.58464164900],
[0.00000000378, 2.41665947591, 18844.61174413899],
[0.00000000421, 4.86552697954, 9146.79006902100],
[0.00000000500, 4.20351458644, 55022.93574707440],
[0.00000000404, 4.95834410782, 37410.56723987860],
[0.00000000402, 2.97963246945, 10220.39909321180],
[0.00000000464, 2.59869499733, 18734.40542291960],
[0.00000000352, 0.08963076359, 10103.07922499160],
[0.00000000348, 4.90260339364, 18830.38465013739],
[0.00000000338, 3.22520096478, 24150.08005134500],
[0.00000000375, 6.17532088136, 26087.90314157420],
[0.00000000425, 1.20052578280, 40879.44050464380],
[0.00000000408, 3.12833060705, 9050.81084180320],
[0.00000000385, 1.94284690176, 283.85931886520],
[0.00000000337, 4.87838699272, 12432.04265039780],
[0.00000000326, 4.27369741426, 26735.94526221320],
[0.00000000309, 0.50597475053, 38204.68735937100],
[0.00000000329, 3.88430599153, 29864.33402730900],
[0.00000000313, 1.36138752543, 10192.51015071860],
[0.00000000347, 3.58439807209, 27490.69247804480],
[0.00000000251, 3.78618457047, 10063.72234907640],
[0.00000000244, 3.83523342668, 9411.46461508720],
[0.00000000281, 4.50895206233, 32217.20018108080],
[0.00000000237, 0.87748812245, 6681.22485339960],
[0.00000000315, 5.62657778233, 58953.14544329400],
[0.00000000311, 4.15626121491, 10175.15251057320],
[0.00000000247, 2.53637594113, 16522.65971600220],
[0.00000000219, 5.08729383251, 7058.59846131540],
[0.00000000291, 3.72567217056, 29999.95935231900],
[0.00000000267, 2.97685503991, 19573.37471066999],
[0.00000000280, 3.70200084294, 47623.85278608960],
[0.00000000239, 3.94545782067, 9580.50180689780],
[0.00000000246, 2.18244883930, 9161.01716302260],
[0.00000000253, 2.69506547016, 3442.57494496540],
[0.00000000265, 2.62811801237, 44809.65020086340],
[0.00000000194, 4.78926136175, 33794.54372352860],
[0.00000000187, 3.65620881095, 20452.86941222180],
[0.00000000224, 2.43601863127, 9992.87290377220],
[0.00000000193, 2.55112161845, 2379.16447357160],
[0.00000000201, 1.90356905733, 1551.04522264800],
[0.00000000176, 4.29837616553, 10137.01947493540],
[0.00000000184, 6.16061560223, 36147.40987730040],
[0.00000000175, 2.71984797040, 20809.46762464520],
[0.00000000186, 2.55098927966, 14919.01785375460],
[0.00000000161, 4.13272567123, 23958.63178523340],
[0.00000000221, 4.83552377614, 20277.00789528740],
[0.00000000160, 1.81472642729, 10787.63034454580],
[0.00000000199, 5.74259798330, 30666.15495843280],
[0.00000000160, 4.46270605493, 18947.70451835760],
[0.00000000187, 2.98688597588, 2218.75710418680],
[0.00000000189, 5.34607810282, 10007.09999777380],
[0.00000000198, 0.77846666692, 62883.35513951360],
[0.00000000144, 5.00261963924, 9264.10993724120],
[0.00000000171, 2.05212624568, 7255.56965173440],
[0.00000000188, 4.08173534559, 48739.85989708300],
[0.00000000146, 3.94191715702, 6309.37416979120],
[0.00000000146, 5.06313558118, 39264.06928956020],
[0.00000000135, 5.93689169614, 37724.75341974820],
[0.00000000139, 2.81266025896, 20.77539549240],
[0.00000000177, 5.16224804657, 9835.91193829520],
[0.00000000119, 1.37254262864, 40077.61957352000],
[0.00000000120, 0.21443767468, 31022.75317085620],
[0.00000000128, 2.92458887798, 7.11354700080],
[0.00000000150, 5.73646272556, 632.78373931320],
[0.00000000106, 0.62224833817, 11272.66747640020],
[0.00000000114, 2.63301326520, 17468.85519794540],
[0.00000000123, 6.22518843711, 53285.18483524180],
[0.00000000107, 1.17258978900, 43071.89928903080],
[0.00000000103, 1.09613781581, 41654.96311596780],
[0.00000000109, 2.01412667085, 20419.45754542119],
[0.00000000102, 4.23406964348, 10251.31321884680],
[0.00000000116, 1.27731728606, 10199.05845220940],
[0.00000000103, 5.25887538465, 9830.38901398780],
[0.00000000112, 2.24436894064, 18204.71445782499],
[0.00000000111, 2.23547857955, 8521.11987670860],
[0.00000000118, 0.23754207200, 10497.14486507620],
[0.00000000123, 0.88054816668, 34596.36465465240],
[0.00000000102, 4.39438646620, 18300.69368504279],
[0.00000000131, 6.01711652115, 9367.20271145980],
[0.00000000100, 5.00532389609, 10175.25787357520],
[0.00000000107, 0.41270197502, 40853.14218484400],
[0.00000000132, 5.45008342761, 11506.76976979360],
[0.00000000098, 1.07722950958, 13553.89797291080],
[0.00000000094, 2.91720097590, 44007.82926973960],
[0.00000000097, 1.04004223634, 68050.42387851159],
[0.00000000127, 2.20215372683, 66813.56483573320],
[0.00000000111, 1.57823839032, 29043.67019634839],
[0.00000000118, 2.33268176890, 18314.92077904440],
[0.00000000090, 2.42353056125, 32858.61374281979],
[0.00000000109, 3.82796787296, 19470.28193645139],
[0.00000000111, 4.47666957576, 29057.89729034999],
[0.00000000101, 3.41528493660, 19264.09638801420],
[0.00000000092, 3.66289799512, 22645.32819660879],
[0.00000000094, 6.07530805791, 10846.06928552420],
[0.00000000114, 4.02718653431, 7576.56007357400],
[0.00000000087, 6.01842459303, 17085.95866572220],
[0.00000000109, 5.46886607309, 52670.06959330260],
[0.00000000107, 0.54805946713, 34363.36559755600],
[0.00000000108, 5.44460610707, 19050.79729257620],
[0.00000000076, 6.15177368654, 27682.14074415640],
[0.00000000107, 4.80525404063, 8144.27871130440],
[0.00000000073, 1.60549217847, 20956.26205751660],
[0.00000000097, 5.13542051130, 22779.43724619380],
[0.00000000068, 2.31300447144, 8631.32619792800],
[0.00000000091, 4.28652743953, 10110.19277199240],
[0.00000000093, 5.27290609264, 522.57741809380],
[0.00000000071, 3.65565961690, 11764.33076885900],
[0.00000000089, 1.79712963206, 45585.17281218740],
[0.00000000067, 2.25900071584, 9360.08916445900],
[0.00000000085, 0.67062144972, 56600.27928952220],
[0.00000000080, 1.58278081077, 19992.85935454519],
[0.00000000065, 6.23472325597, 10419.47109464820],
[0.00000000064, 0.53356325917, 17248.42530185440],
[0.00000000085, 4.52011215904, 29786.66025688100],
[0.00000000068, 4.48235266554, 10632.77019008620],
[0.00000000064, 4.33495700921, 47938.03896595920],
[0.00000000071, 3.03858484137, 11787.10597030980],
[0.00000000087, 4.81823063172, 2107.03450754240],
[0.00000000070, 2.35648061034, 11794.15220700780],
[0.00000000080, 2.33248094128, 38526.57435087200],
[0.00000000070, 3.70454061100, 8734.41897214660],
[0.00000000077, 4.49569185467, 20007.08644854680],
[0.00000000072, 1.19410424468, 10217.21769947410],
[0.00000000068, 2.01841060183, 14128.24277124560],
[0.00000000064, 5.39293951654, 7880.08915333899],
[0.00000000066, 3.20467071127, 14765.23904326980],
[0.00000000080, 3.41620457770, 48417.97290558199],
[0.00000000080, 3.39651161571, 245.83164622940],
[0.00000000066, 5.85414440204, 9793.80090233580],
[0.00000000082, 3.62592908644, 70743.77453195279],
[0.00000000058, 4.95174942212, 30110.16567353840],
[0.00000000079, 6.24161471033, 6037.24420376200],
[0.00000000069, 5.50183658445, 19793.78735310880],
[0.00000000056, 1.24148350566, 10207.76262190360],
[0.00000000070, 2.45123308846, 10218.80847051840],
[0.00000000064, 5.53983104501, 10735.86296430480],
[0.00000000054, 3.62259713240, 27461.71084806540],
[0.00000000073, 1.75882480924, 1589.07289528380],
[0.00000000075, 3.38244819846, 4214.06901508480],
[0.00000000054, 0.64971567468, 9929.42622734580],
[0.00000000054, 3.40959637230, 18418.01355326299],
[0.00000000056, 3.65815006538, 14169.79356223040],
[0.00000000056, 0.71243223808, 9896.89367655440],
[0.00000000052, 1.33348131940, 20400.27277262220],
[0.00000000067, 3.12806595400, 5481.25491886760],
[0.00000000058, 0.54482893546, 28313.28880466100],
[0.00000000054, 0.15603935681, 19580.48825767080],
[0.00000000051, 3.37515473510, 9256.99639024040],
[0.00000000063, 3.38848970950, 49515.38250840700],
[0.00000000069, 4.90917651401, 63498.47038145279],
[0.00000000057, 5.07437742030, 18521.10632748160],
[0.00000000050, 1.59156823654, 18631.31264870099],
[0.00000000054, 6.25816208666, 37674.99639427640],
[0.00000000057, 5.48065460919, 24383.07910844140],
[0.00000000045, 1.10466490660, 10408.25693067160],
[0.00000000051, 3.61196470313, 426.59819087600],
[0.00000000057, 2.09567711267, 60530.48898574180],
[0.00000000060, 5.94659889997, 13897.66359620120],
[0.00000000051, 5.47238517720, 57837.13833230060],
[0.00000000051, 2.32438478428, 19779.56025910719],
[0.00000000052, 3.23766328818, 18940.59097135679],
[0.00000000043, 5.74921510909, 51868.24866217880],
[0.00000000048, 1.12206254877, 9779.57380833420],
[0.00000000058, 3.08646083897, 12074.48840752400],
[0.00000000046, 4.07536026888, 7863.94251078820],
[0.00000000045, 4.75746520642, 7856.89627409019],
[0.00000000054, 4.43528236634, 8617.09910392640],
[0.00000000050, 3.70569982975, 42456.78404709160],
[0.00000000044, 1.29248911155, 69166.43098950500],
[0.00000000046, 0.41229872114, 7564.83072073800],
[0.00000000044, 6.17937388307, 13341.67431130680],
[0.00000000053, 4.71388531889, 53445.59220462660],
[0.00000000041, 3.48003037828, 37895.42629036740],
[0.00000000040, 1.23305546260, 10228.53801739600],
[0.00000000053, 5.04979874661, 74673.98422817240],
[0.00000000039, 1.36646013032, 21202.09370374600],
[0.00000000039, 2.15376025201, 8947.71806758460],
[0.00000000041, 6.17532984460, 65236.22129328540],
[0.00000000052, 1.29052331493, 90394.82301305079],
[0.00000000039, 0.70253732683, 18093.37469954999],
[0.00000000052, 1.18164377451, 10211.80107350270],
[0.00000000047, 1.78672260794, 10401.21069397360],
[0.00000000040, 3.66961416802, 10198.03307502600],
[0.00000000051, 2.71698589018, 94325.03270927040],
[0.00000000036, 1.25091711620, 10323.49186743040],
[0.00000000049, 1.21335959420, 9721.62225375220],
[0.00000000042, 6.05968230173, 105460.99111839019],
[0.00000000046, 5.06978748275, 20350.30502114640],
[0.00000000040, 1.97645050921, 32243.49850088060],
[0.00000000036, 4.96702216961, 36301.18868778519],
[0.00000000037, 5.29642935562, 38.02767263580],
[0.00000000039, 0.52064327313, 26709.64694241340],
[0.00000000035, 2.34112124655, 58946.51688439399],
[0.00000000034, 1.82989750626, 17675.02349273040],
[0.00000000034, 0.76493664110, 55798.45835839840],
[0.00000000035, 1.09353675147, 69159.80243060499],
[0.00000000031, 5.59148330297, 10639.88373708700],
[0.00000000032, 3.32960781870, 71519.29714327680],
[0.00000000031, 5.98191446392, 24341.52831745660],
[0.00000000031, 0.68615213145, 10202.23984594710],
[0.00000000030, 4.42039942947, 10459.11719244040],
[0.00000000029, 1.30367701539, 20103.06567576459],
[0.00000000031, 4.51793347997, 2957.71589447660],
[0.00000000035, 4.05634321290, 19903.99367432819],
[0.00000000030, 1.32113757427, 574.34479833480],
[0.00000000029, 3.36506645849, 10288.06714477830],
[0.00000000029, 1.40019042576, 9988.94075050910],
[0.00000000032, 0.21932095318, 24978.52458948080],
[0.00000000034, 5.22945947227, 8673.96967639900],
[0.00000000039, 4.50883171158, 16004.69810374360],
[0.00000000028, 2.32945945641, 11392.48008525060],
[0.00000000034, 3.92498967835, 536.80451209540],
[0.00000000032, 5.46972716255, 64607.84893354619],
[0.00000000028, 2.38858990128, 20235.12282631040],
[0.00000000030, 3.34585843979, 39793.76025465480],
[0.00000000026, 5.36096904409, 1478.86657406440],
], [
[0.00034551039, 0.89198710598, 10213.28554621100],
[0.00000234203, 1.77224942714, 20426.57109242200],
[0.00000233998, 3.14159265359, 0.00000000000],
[0.00000023864, 1.11274502648, 9437.76293488700],
[0.00000010568, 4.59168210921, 1577.34354244780],
[0.00000009124, 4.53540907003, 10404.73381232260],
[0.00000006599, 5.97703999838, 5507.55323866740],
[0.00000004667, 3.87683960551, 9153.90361602180],
[0.00000003840, 5.66196924375, 13367.97263110660],
[0.00000002666, 2.82413291285, 10206.17199921020],
[0.00000002194, 2.05314419626, 775.52261132400],
[0.00000002094, 2.55137285015, 18837.49819713819],
[0.00000001782, 2.64808558644, 30639.85663863300],
[0.00000001845, 1.87612936641, 11015.10647733480],
[0.00000001303, 0.20613045603, 11322.66409830440],
[0.00000001169, 0.79431893441, 17298.18232732620],
[0.00000001001, 6.16555101536, 10239.58386601080],
[0.00000000915, 4.59854496966, 1109.37855209340],
[0.00000000884, 0.66706834422, 18073.70493865020],
[0.00000000849, 5.58641571940, 12566.15169998280],
[0.00000001071, 4.94792017474, 6283.07584999140],
[0.00000000887, 2.47785193216, 3154.68708489560],
[0.00000000904, 0.81413053841, 10596.18207843420],
[0.00000000818, 0.90016838097, 5661.33204915220],
[0.00000000845, 5.48504338112, 529.69096509460],
[0.00000000824, 3.74837629121, 7084.89678111520],
[0.00000000652, 5.07444932607, 22003.91463486980],
[0.00000000847, 0.44119876869, 8635.94200376320],
[0.00000000638, 4.10125791268, 191.44826611160],
[0.00000000615, 3.14417599741, 10186.98722641120],
[0.00000000527, 5.86792949279, 2352.86615377180],
[0.00000000520, 5.33201358267, 14143.49524243060],
[0.00000000576, 2.25212731258, 21228.39202354580],
[0.00000000662, 2.86880467345, 8624.21265092720],
[0.00000000554, 2.17186191243, 18307.80723204360],
[0.00000000515, 4.34331395104, 9786.68735533500],
[0.00000000501, 5.56479589366, 10742.97651130560],
[0.00000000426, 1.02161443120, 7064.12138562280],
[0.00000000418, 1.26803034691, 9676.48103411560],
[0.00000000391, 0.78974645621, 9690.70812811720],
[0.00000000334, 3.18175822557, 10988.80815753500],
[0.00000000375, 0.66142254036, 19360.07561523199],
[0.00000000364, 0.19369831864, 19374.30270923360],
[0.00000000313, 1.09734397626, 4551.95349705880],
[0.00000000330, 0.58817502306, 16496.36139620240],
[0.00000000339, 5.76768761396, 10021.83728009940],
[0.00000000291, 3.65846764668, 25158.60171976540],
[0.00000000223, 4.33581625553, 19786.67380610799],
[0.00000000266, 3.57408827667, 801.82093112380],
[0.00000000274, 5.73346687248, 11790.62908865880],
[0.00000000275, 5.65814317085, 19896.88012732740],
[0.00000000212, 4.27038489878, 4705.73230754360],
[0.00000000230, 6.13406345590, 1059.38193018920],
[0.00000000204, 4.87348390351, 7860.41939243920],
[0.00000000241, 1.13551531894, 26.29831979980],
[0.00000000206, 0.31907973682, 382.89653222320],
[0.00000000216, 2.54741101724, 19651.04848109800],
[0.00000000212, 3.15264941106, 14945.31617355440],
[0.00000000163, 1.13604744392, 13936.79450513400],
[0.00000000151, 5.11341268743, 28521.09277825460],
[0.00000000151, 0.81278755582, 6770.71060124560],
[0.00000000150, 5.02227334847, 29088.81141598500],
[0.00000000146, 1.37568138685, 10220.39909321180],
[0.00000000127, 4.49298610074, 3532.06069281140],
[0.00000000121, 6.26589208179, 29580.47470844380],
[0.00000000147, 6.16092774714, 8662.24032356300],
[0.00000000114, 0.00114012635, 25934.12433108940],
[0.00000000115, 3.56897715344, 24356.78078864160],
[0.00000000124, 0.67547060274, 3723.50895892300],
[0.00000000145, 0.36415036222, 9146.79006902100],
[0.00000000104, 4.27865011376, 9573.38825989700],
[0.00000000136, 5.09581116181, 19367.18916223280],
[0.00000000102, 1.53637788668, 17277.40693183380],
[0.00000000117, 0.57543238496, 9999.98645077300],
[0.00000000092, 0.22936081655, 18830.38465013739],
[0.00000000112, 4.04771058036, 9103.90699411760],
[0.00000000098, 3.78447692407, 213.29909543800],
[0.00000000085, 5.84471458481, 10234.06094170340],
[0.00000000079, 0.64440357793, 18844.61174413899],
[0.00000000084, 0.56950139213, 9683.59458111640],
[0.00000000107, 1.77067111589, 17778.11626694899],
[0.00000000081, 6.19048382717, 20618.01935853360],
[0.00000000087, 0.15771136594, 33019.02111220460],
[0.00000000082, 4.80683817059, 3930.20969621960],
[0.00000000086, 2.21505615071, 8094.52168583260],
[0.00000000064, 2.69215119482, 16983.99614745660],
[0.00000000069, 0.83385751986, 3128.38876509580],
[0.00000000081, 4.88025042367, 4732.03062734340],
[0.00000000059, 3.34348033725, 10787.63034454580],
[0.00000000061, 0.04044699966, 9161.01716302260],
[0.00000000064, 4.13127333938, 9992.87290377220],
[0.00000000060, 6.24603986632, 32217.20018108080],
[0.00000000054, 3.38449893196, 10426.58464164900],
[0.00000000054, 5.15939119644, 28286.99048486120],
[0.00000000063, 4.32339245083, 12592.45001978260],
[0.00000000060, 4.48753846170, 18875.52586977400],
[0.00000000057, 3.64912085313, 10007.09999777380],
[0.00000000049, 5.10267262491, 19573.37471066999],
[0.00000000047, 5.79444960738, 68050.42387851159],
[0.00000000052, 3.56658420552, 7255.56965173440],
[0.00000000050, 1.61783309819, 36949.23080842420],
[0.00000000053, 2.64370544855, 15874.61759536320],
[0.00000000040, 3.93466530964, 20419.45754542119],
[0.00000000051, 0.79154899901, 23581.25817731760],
[0.00000000038, 1.77428239418, 10103.07922499160],
[0.00000000049, 1.12423644455, 3442.57494496540],
[0.00000000040, 5.22874487975, 21535.94964451540],
[0.00000000038, 1.12473430132, 7.11354700080],
[0.00000000038, 0.11510547453, 11272.66747640020],
[0.00000000036, 2.02476324983, 7058.59846131540],
[0.00000000047, 0.05589432390, 12432.04265039780],
[0.00000000034, 3.45481114998, 9830.38901398780],
[0.00000000045, 4.59817214088, 10192.51015071860],
[0.00000000037, 4.93959675364, 3340.61242669980],
[0.00000000044, 0.70533027806, 20213.27199698400],
[0.00000000034, 2.16487642765, 64460.69868196140],
[0.00000000031, 1.57612397319, 36147.40987730040],
[0.00000000028, 2.56454760402, 94138.32702008578],
[0.00000000033, 1.08907268562, 29864.33402730900],
[0.00000000029, 0.59718407064, 59728.66805461800],
[0.00000000031, 3.04423979263, 40879.44050464380],
[0.00000000035, 0.32247158762, 1589.07289528380],
[0.00000000031, 3.27727318906, 19992.85935454519],
[0.00000000027, 5.83705748551, 17085.95866572220],
[0.00000000032, 2.64260788260, 41962.52073693740],
[0.00000000028, 4.90613317287, 29050.78374334920],
[0.00000000025, 4.55050389739, 14919.01785375460],
[0.00000000028, 3.58851614957, 40853.14218484400],
[0.00000000029, 2.79705093386, 20007.08644854680],
[0.00000000033, 0.93862065616, 15720.83878487840],
[0.00000000024, 2.74970637101, 18947.70451835760],
[0.00000000024, 4.38966861409, 46386.99374331120],
[0.00000000024, 0.73361964525, 9411.46461508720],
[0.00000000028, 4.19559784013, 37674.99639427640],
[0.00000000023, 1.00023735538, 22779.43724619380],
[0.00000000026, 0.46990555736, 13745.34623902240],
[0.00000000028, 4.65181292126, 1551.04522264800],
[0.00000000025, 4.18690270765, 44007.82926973960],
[0.00000000022, 0.98102807789, 426.59819087600],
[0.00000000030, 1.24986033487, 27461.71084806540],
[0.00000000027, 3.94986823486, 17468.85519794540],
[0.00000000021, 6.09897508157, 18300.69368504279],
[0.00000000025, 4.75875623888, 27991.40181316000],
[0.00000000022, 2.95281481673, 40077.61957352000],
[0.00000000028, 6.12038264955, 38500.27603107220],
[0.00000000022, 4.11184201321, 19779.56025910719],
[0.00000000027, 3.72446446080, 19793.78735310880],
[0.00000000020, 4.27086627368, 31441.67756975680],
[0.00000000022, 4.99040169444, 31022.75317085620],
[0.00000000023, 1.33505132122, 65236.22129328540],
[0.00000000021, 4.46897353468, 53285.18483524180],
[0.00000000020, 4.15140915983, 2218.75710418680],
[0.00000000025, 2.18447182965, 27511.46787353720],
[0.00000000019, 1.43653410349, 27197.28169366760],
[0.00000000027, 1.22555218015, 42430.48572729180],
[0.00000000019, 3.65054338893, 49515.38250840700],
[0.00000000022, 5.88380811711, 10218.80847051840],
[0.00000000018, 2.29853355765, 19264.09638801420],
[0.00000000017, 5.44429906531, 6681.22485339960],
[0.00000000020, 3.68116637773, 14128.24277124560],
[0.00000000021, 4.30316190532, 44809.65020086340],
[0.00000000020, 2.48583613985, 33794.54372352860],
[0.00000000017, 3.02735393984, 28528.20632525540],
[0.00000000019, 5.92656850674, 22805.73556599360],
[0.00000000022, 5.30827572791, 10207.76262190360],
[0.00000000020, 0.75829381378, 18314.92077904440],
[0.00000000017, 5.63315744126, 16522.65971600220],
[0.00000000016, 1.71021408448, 536.80451209540],
[0.00000000015, 5.27016880041, 53445.59220462660],
[0.00000000017, 5.61443395877, 47938.03896595920],
[0.00000000015, 5.81110284451, 43071.89928903080],
[0.00000000015, 4.96237667003, 19999.97290154599],
[0.00000000018, 0.55618686515, 14765.23904326980],
[0.00000000014, 3.48144272414, 29786.66025688100],
[0.00000000015, 5.84132627836, 10228.53801739600],
[0.00000000016, 1.05720065324, 26735.94526221320],
[0.00000000014, 6.08462030302, 35371.88726597640],
[0.00000000014, 2.84532871890, 574.34479833480],
[0.00000000015, 5.34517715140, 10198.03307502600],
[0.00000000013, 0.45004137509, 20452.86941222180],
], [
[0.00001406587, 5.06366395190, 10213.28554621100],
[0.00000015529, 5.47321687981, 20426.57109242200],
[0.00000013059, 0.00000000000, 0.00000000000],
[0.00000001099, 2.78883988292, 9437.76293488700],
[0.00000000488, 6.27806914496, 1577.34354244780],
[0.00000000361, 6.11914188253, 10404.73381232260],
[0.00000000310, 1.38984998403, 5507.55323866740],
[0.00000000389, 1.95017779915, 11015.10647733480],
[0.00000000372, 2.33222828423, 775.52261132400],
[0.00000000207, 5.63406721595, 10239.58386601080],
[0.00000000168, 1.10765197296, 13367.97263110660],
[0.00000000175, 6.16674652950, 30639.85663863300],
[0.00000000168, 3.64495311632, 7084.89678111520],
[0.00000000120, 5.85815843789, 9153.90361602180],
[0.00000000160, 2.21564938463, 3154.68708489560],
[0.00000000118, 2.62358866565, 8635.94200376320],
[0.00000000112, 2.36235956804, 10596.18207843420],
[0.00000000092, 0.72664449269, 12566.15169998280],
[0.00000000067, 3.76089669118, 18837.49819713819],
[0.00000000065, 2.47983709990, 11790.62908865880],
[0.00000000048, 4.26620187144, 2352.86615377180],
[0.00000000048, 5.50898189550, 191.44826611160],
[0.00000000048, 2.54730918293, 17298.18232732620],
[0.00000000046, 3.40293459332, 14143.49524243060],
[0.00000000041, 1.83997113019, 11322.66409830440],
[0.00000000037, 6.17871126027, 1109.37855209340],
[0.00000000039, 4.77190210316, 18073.70493865020],
[0.00000000035, 3.10133256432, 4705.73230754360],
[0.00000000046, 3.30090415967, 6283.07584999140],
[0.00000000034, 3.91721765773, 10021.83728009940],
[0.00000000034, 3.24663787383, 22003.91463486980],
[0.00000000042, 3.39360926939, 14945.31617355440],
[0.00000000044, 4.42979374073, 7860.41939243920],
[0.00000000034, 2.16381407025, 16496.36139620240],
[0.00000000031, 0.45714618479, 26.29831979980],
[0.00000000035, 3.62868651241, 801.82093112380],
[0.00000000032, 1.84138997078, 382.89653222320],
[0.00000000025, 3.32908650295, 18307.80723204360],
[0.00000000026, 3.64313769818, 29088.81141598500],
[0.00000000029, 3.82967178810, 10186.98722641120],
[0.00000000022, 3.17741520378, 28521.09277825460],
[0.00000000021, 2.52643834111, 529.69096509460],
[0.00000000025, 5.71401244457, 21202.09370374600],
[0.00000000021, 3.77813434325, 21228.39202354580],
[0.00000000019, 5.24505118517, 19896.88012732740],
[0.00000000018, 4.62463651925, 19651.04848109800],
[0.00000000016, 3.35893297896, 28286.99048486120],
[0.00000000015, 5.05571633205, 33019.02111220460],
[0.00000000014, 2.83786355803, 19786.67380610799],
[0.00000000014, 1.79922718553, 9830.38901398780],
[0.00000000014, 3.14801263138, 19367.18916223280],
[0.00000000014, 3.57896195191, 10988.80815753500],
[0.00000000013, 3.06303088617, 10742.97651130560],
[0.00000000013, 5.43981998532, 25158.60171976540],
[0.00000000015, 4.83166312889, 18875.52586977400],
[0.00000000012, 2.54141086214, 7064.12138562280],
[0.00000000012, 4.45255110769, 15720.83878487840],
[0.00000000010, 1.87933121728, 24356.78078864160],
[0.00000000011, 2.58708635685, 9103.90699411760],
[0.00000000010, 2.17901309900, 3723.50895892300],
[0.00000000008, 3.63520673832, 1059.38193018920],
[0.00000000008, 4.67523115598, 25934.12433108940],
[0.00000000009, 5.97856553283, 9683.59458111640],
], [
[0.00000049582, 3.22263554520, 10213.28554621100],
[0.00000000831, 3.21219077104, 20426.57109242200],
[0.00000000112, 3.14159265359, 0.00000000000],
[0.00000000013, 3.77448689585, 30639.85663863300],
[0.00000000009, 4.19802043629, 10239.58386601080],
[0.00000000006, 0.20714935358, 10186.98722641120],
[0.00000000005, 0.68781956122, 8635.94200376320],
], [
[0.00000000573, 0.92229697820, 10213.28554621100],
[0.00000000040, 0.95468912157, 20426.57109242200],
[0.00000000006, 3.14159265359, 0.00000000000],
], [
[0.00000000045, 0.30032866722, 10213.28554621100],
[0.00000000002, 5.29627718483, 20426.57109242200],
]],
('Earth', 'L'):[[
[1.75347045673, 0.00000000000, 0.00000000000],
[0.03341656456, 4.66925680417, 6283.07584999140],
[0.00034894275, 4.62610241759, 12566.15169998280],
[0.00003417571, 2.82886579606, 3.52311834900],
[0.00003497056, 2.74411800971, 5753.38488489680],
[0.00003135896, 3.62767041758, 77713.77146812050],
[0.00002676218, 4.41808351397, 7860.41939243920],
[0.00002342687, 6.13516237631, 3930.20969621960],
[0.00001273166, 2.03709655772, 529.69096509460],
[0.00001324292, 0.74246356352, 11506.76976979360],
[0.00000901855, 2.04505443513, 26.29831979980],
[0.00001199167, 1.10962944315, 1577.34354244780],
[0.00000857223, 3.50849156957, 398.14900340820],
[0.00000779786, 1.17882652114, 5223.69391980220],
[0.00000990250, 5.23268129594, 5884.92684658320],
[0.00000753141, 2.53339053818, 5507.55323866740],
[0.00000505264, 4.58292563052, 18849.22754997420],
[0.00000492379, 4.20506639861, 775.52261132400],
[0.00000356655, 2.91954116867, 0.06731030280],
[0.00000284125, 1.89869034186, 796.29800681640],
[0.00000242810, 0.34481140906, 5486.77784317500],
[0.00000317087, 5.84901952218, 11790.62908865880],
[0.00000271039, 0.31488607649, 10977.07880469900],
[0.00000206160, 4.80646606059, 2544.31441988340],
[0.00000205385, 1.86947813692, 5573.14280143310],
[0.00000202261, 2.45767795458, 6069.77675455340],
[0.00000126184, 1.08302630210, 20.77539549240],
[0.00000155516, 0.83306073807, 213.29909543800],
[0.00000115132, 0.64544911683, 0.98032106820],
[0.00000102851, 0.63599846727, 4694.00295470760],
[0.00000101724, 4.26679821365, 7.11354700080],
[0.00000099206, 6.20992940258, 2146.16541647520],
[0.00000132212, 3.41118275555, 2942.46342329160],
[0.00000097607, 0.68101272270, 155.42039943420],
[0.00000085128, 1.29870743025, 6275.96230299060],
[0.00000074651, 1.75508916159, 5088.62883976680],
[0.00000101895, 0.97569221824, 15720.83878487840],
[0.00000084711, 3.67080093025, 71430.69561812909],
[0.00000073547, 4.67926565481, 801.82093112380],
[0.00000073874, 3.50319443167, 3154.68708489560],
[0.00000078756, 3.03698313141, 12036.46073488820],
[0.00000079637, 1.80791330700, 17260.15465469040],
[0.00000085803, 5.98322631256, 161000.68573767410],
[0.00000056963, 2.78430398043, 6286.59896834040],
[0.00000061148, 1.81839811024, 7084.89678111520],
[0.00000069627, 0.83297596966, 9437.76293488700],
[0.00000056116, 4.38694880779, 14143.49524243060],
[0.00000062449, 3.97763880587, 8827.39026987480],
[0.00000051145, 0.28306864501, 5856.47765911540],
[0.00000055577, 3.47006009062, 6279.55273164240],
[0.00000041036, 5.36817351402, 8429.24126646660],
[0.00000051605, 1.33282746983, 1748.01641306700],
[0.00000051992, 0.18914945834, 12139.55350910680],
[0.00000049000, 0.48735065033, 1194.44701022460],
[0.00000039200, 6.16832995016, 10447.38783960440],
[0.00000035566, 1.77597314691, 6812.76681508600],
[0.00000036770, 6.04133859347, 10213.28554621100],
[0.00000036596, 2.56955238628, 1059.38193018920],
[0.00000033291, 0.59309499459, 17789.84561978500],
[0.00000035954, 1.70876111898, 2352.86615377180],
[0.00000040938, 2.39850881707, 19651.04848109800],
[0.00000030047, 2.73975123935, 1349.86740965880],
[0.00000030412, 0.44294464135, 83996.84731811189],
[0.00000023663, 0.48473567763, 8031.09226305840],
[0.00000023574, 2.06527720049, 3340.61242669980],
[0.00000021089, 4.14825464101, 951.71840625060],
[0.00000024738, 0.21484762138, 3.59042865180],
[0.00000025352, 3.16470953405, 4690.47983635860],
[0.00000022820, 5.22197888032, 4705.73230754360],
[0.00000021419, 1.42563735525, 16730.46368959580],
[0.00000021891, 5.55594302562, 553.56940284240],
[0.00000017481, 4.56052900359, 135.06508003540],
[0.00000019925, 5.22208471269, 12168.00269657460],
[0.00000019860, 5.77470167653, 6309.37416979120],
[0.00000020300, 0.37133792946, 283.85931886520],
[0.00000014421, 4.19315332546, 242.72860397400],
[0.00000016225, 5.98837722564, 11769.85369316640],
[0.00000015077, 4.19567181073, 6256.77753019160],
[0.00000019124, 3.82219996949, 23581.25817731760],
[0.00000018888, 5.38626880969, 149854.40013480789],
[0.00000014346, 3.72355084422, 38.02767263580],
[0.00000017898, 2.21490735647, 13367.97263110660],
[0.00000012054, 2.62229588349, 955.59974160860],
[0.00000011287, 0.17739328092, 4164.31198961300],
[0.00000013971, 4.40138139996, 6681.22485339960],
[0.00000013621, 1.88934471407, 7632.94325965020],
[0.00000012503, 1.13052412208, 5.52292430740],
[0.00000010498, 5.35909518669, 1592.59601363280],
[0.00000009803, 0.99947478995, 11371.70468975820],
[0.00000009220, 4.57138609781, 4292.33083295040],
[0.00000010327, 6.19982566125, 6438.49624942560],
[0.00000012003, 1.00351456700, 632.78373931320],
[0.00000010827, 0.32734520222, 103.09277421860],
[0.00000008356, 4.53902685948, 25132.30339996560],
[0.00000010005, 6.02914963280, 5746.27133789600],
[0.00000008409, 3.29946744189, 7234.79425624200],
[0.00000008006, 5.82145271907, 28.44918746780],
[0.00000010523, 0.93871805506, 11926.25441366880],
[0.00000007686, 3.12142363172, 7238.67559160000],
[0.00000009378, 2.62414241032, 5760.49843189760],
[0.00000008127, 6.11228001785, 4732.03062734340],
[0.00000009232, 0.48343968736, 522.57741809380],
[0.00000009802, 5.24413991147, 27511.46787353720],
[0.00000007871, 0.99590177926, 5643.17856367740],
[0.00000008123, 6.27053013650, 426.59819087600],
[0.00000009048, 5.33686335897, 6386.16862421000],
[0.00000008620, 4.16538210888, 7058.59846131540],
[0.00000006297, 4.71724819317, 6836.64525283380],
[0.00000007575, 3.97382858911, 11499.65622279280],
[0.00000007756, 2.95729056763, 23013.53953958720],
[0.00000007314, 0.60652505806, 11513.88331679440],
[0.00000005955, 2.87641047971, 6283.14316029419],
[0.00000006534, 5.79072926033, 18073.70493865020],
[0.00000007188, 3.99831508699, 74.78159856730],
[0.00000007346, 4.38582365437, 316.39186965660],
[0.00000005413, 5.39199024641, 419.48464387520],
[0.00000005127, 2.36062848786, 10973.55568635000],
[0.00000007056, 0.32258441903, 263.08392337280],
[0.00000006625, 3.66475158672, 17298.18232732620],
[0.00000006762, 5.91132535899, 90955.55169449610],
[0.00000004938, 5.73672165674, 9917.69687450980],
[0.00000005547, 2.45152597661, 12352.85260454480],
[0.00000005958, 3.32051344676, 6283.00853968860],
[0.00000004471, 2.06385999536, 7079.37385680780],
[0.00000006153, 1.45823331144, 233141.31440436149],
[0.00000004348, 4.42342175480, 5216.58037280140],
[0.00000006123, 1.07494905258, 19804.82729158280],
[0.00000004488, 3.65285037150, 206.18554843720],
[0.00000004020, 0.83995823171, 20.35531939880],
[0.00000005188, 4.06503864016, 6208.29425142410],
[0.00000005307, 0.38217636096, 31441.67756975680],
[0.00000003785, 2.34369213733, 3.88133535800],
[0.00000004497, 3.27230796845, 11015.10647733480],
[0.00000004132, 0.92128915753, 3738.76143010800],
[0.00000003521, 5.97844807108, 3894.18182954220],
[0.00000004215, 1.90601120623, 245.83164622940],
[0.00000003701, 5.03069397926, 536.80451209540],
[0.00000003865, 1.82634360607, 11856.21865142450],
[0.00000003652, 1.01838584934, 16200.77272450120],
[0.00000003390, 0.97785123922, 8635.94200376320],
[0.00000003737, 2.95380107829, 3128.38876509580],
[0.00000003507, 3.71291946325, 6290.18939699220],
[0.00000003086, 3.64646921512, 10.63666534980],
[0.00000003397, 1.10590684017, 14712.31711645800],
[0.00000003334, 0.83684924911, 6496.37494542940],
[0.00000002805, 2.58504514144, 14314.16811304980],
[0.00000003650, 1.08344142571, 88860.05707098669],
[0.00000003388, 3.20185096055, 5120.60114558360],
[0.00000003252, 3.47859752062, 6133.51265285680],
[0.00000002553, 3.94869034189, 1990.74501704100],
[0.00000003520, 2.05559692878, 244287.60000722769],
[0.00000002565, 1.56071784900, 23543.23050468179],
[0.00000002621, 3.85639359951, 266.60704172180],
[0.00000002955, 3.39692949667, 9225.53927328300],
[0.00000002876, 6.02635617464, 154717.60988768269],
[0.00000002395, 1.16131956403, 10984.19235169980],
[0.00000003161, 1.32798718453, 10873.98603048040],
[0.00000003163, 5.08946464629, 21228.39202354580],
[0.00000002361, 4.27212906992, 6040.34724601740],
[0.00000003030, 1.80209931347, 35371.88726597640],
[0.00000002343, 3.57689860500, 10969.96525769820],
[0.00000002618, 2.57870156528, 22483.84857449259],
[0.00000002113, 3.71393780256, 65147.61976813770],
[0.00000002019, 0.81393923319, 170.67287061920],
[0.00000002003, 0.38091017375, 6172.86952877200],
[0.00000002506, 3.74379142438, 10575.40668294180],
[0.00000002381, 0.10581361289, 7.04623669800],
[0.00000001949, 4.86892513469, 36.02786667740],
[0.00000002074, 4.22794774570, 5650.29211067820],
[0.00000001924, 5.59460549860, 6282.09552892320],
[0.00000001949, 1.07002512703, 5230.80746680300],
[0.00000001988, 5.19736046771, 6262.30045449900],
[0.00000001887, 3.74365662683, 23.87843774780],
[0.00000001787, 1.25929682929, 12559.03815298200],
[0.00000001883, 1.90364058477, 15.25247118500],
[0.00000001816, 3.68083868442, 15110.46611986620],
[0.00000001701, 4.41105895380, 110.20632121940],
[0.00000001990, 3.93295788548, 6206.80977871580],
[0.00000002103, 0.75354917468, 13521.75144159140],
[0.00000001774, 0.48747535361, 1551.04522264800],
[0.00000001882, 0.86684493432, 22003.91463486980],
[0.00000001924, 1.22898324132, 709.93304855830],
[0.00000002009, 4.62850921980, 6037.24420376200],
[0.00000001924, 0.60231842508, 6284.05617105960],
[0.00000001596, 3.98332956992, 13916.01910964160],
[0.00000001664, 4.41939715469, 8662.24032356300],
[0.00000001971, 1.04560500503, 18209.33026366019],
[0.00000001942, 4.31335979989, 6244.94281435360],
[0.00000001476, 0.93271367331, 2379.16447357160],
[0.00000001810, 0.49112137707, 1.48447270830],
[0.00000001346, 1.51574702235, 4136.91043351620],
[0.00000001528, 5.61835711404, 6127.65545055720],
[0.00000001791, 3.22187270126, 39302.09696219600],
[0.00000001747, 3.05638656738, 18319.53658487960],
[0.00000001431, 4.51153808594, 20426.57109242200],
[0.00000001695, 0.22047718414, 25158.60171976540],
[0.00000001242, 4.46665769933, 17256.63153634140],
[0.00000001463, 4.69242679213, 14945.31617355440],
[0.00000001205, 1.86912144659, 4590.91018048900],
[0.00000001192, 2.74227166898, 12569.67481833180],
[0.00000001222, 5.18120087482, 5333.90024102160],
[0.00000001390, 5.42894648983, 143571.32428481648],
[0.00000001473, 1.70479245805, 11712.95531823080],
[0.00000001362, 2.61069503292, 6062.66320755260],
[0.00000001148, 6.03001800540, 3634.62102451840],
[0.00000001198, 5.15294130422, 10177.25767953360],
[0.00000001266, 0.11421493643, 18422.62935909819],
[0.00000001411, 1.09908857534, 3496.03282613400],
[0.00000001349, 2.99805109633, 17654.78053974960],
[0.00000001253, 2.79850152848, 167283.76158766549],
[0.00000001311, 1.60942984879, 5481.25491886760],
[0.00000001079, 6.20304501787, 3.28635741780],
[0.00000001181, 1.20653776978, 131.54196168640],
[0.00000001254, 5.45103277798, 6076.89030155420],
[0.00000001035, 2.32142722747, 7342.45778018060],
[0.00000001117, 0.38838354256, 949.17560896980],
[0.00000000966, 3.18341890851, 11087.28512591840],
[0.00000001171, 3.39635049962, 12562.62858163380],
[0.00000001121, 0.72627490378, 220.41264243880],
[0.00000001024, 2.19378315386, 11403.67699557500],
[0.00000000888, 3.91173199285, 4686.88940770680],
[0.00000000910, 1.98802695087, 735.87651353180],
[0.00000000830, 0.48984915507, 24072.92146977640],
[0.00000001096, 6.17377835617, 5436.99301524020],
[0.00000000908, 0.44959639433, 7477.52286021600],
[0.00000000974, 1.52996238356, 9623.68827669120],
[0.00000000840, 1.79543266333, 5429.87946823940],
[0.00000000778, 6.17699177946, 38.13303563780],
[0.00000000776, 4.09855402433, 14.22709400160],
[0.00000001068, 4.64200173735, 43232.30665841560],
[0.00000000954, 1.49988435748, 1162.47470440780],
[0.00000000907, 0.86986870809, 10344.29506538580],
[0.00000000931, 4.06044689031, 28766.92442448400],
[0.00000000739, 5.04368197372, 639.89728631400],
[0.00000000937, 3.46884698960, 1589.07289528380],
[0.00000000763, 5.86304932998, 16858.48253293320],
[0.00000000953, 4.20801492835, 11190.37790013700],
[0.00000000708, 1.72899988940, 13095.84266507740],
[0.00000000969, 1.64439522215, 29088.81141598500],
[0.00000000717, 0.16688678895, 11.72935283600],
[0.00000000962, 3.53092337542, 12416.58850284820],
[0.00000000747, 5.77866940346, 12592.45001978260],
[0.00000000672, 1.91095796194, 3.93215326310],
[0.00000000671, 5.46240843677, 18052.92954315780],
[0.00000000675, 6.28311558823, 4535.05943692440],
[0.00000000684, 0.39975012080, 5849.36411211460],
[0.00000000799, 0.29851185294, 12132.43996210600],
[0.00000000758, 0.96370823331, 1052.26838318840],
[0.00000000782, 5.33878339919, 13517.87010623340],
[0.00000000730, 1.70106160291, 17267.26820169119],
[0.00000000749, 2.59599901875, 11609.86254401220],
[0.00000000734, 2.78417782952, 640.87760738220],
[0.00000000688, 5.15048287468, 16496.36139620240],
[0.00000000770, 1.62469589333, 4701.11650170840],
[0.00000000633, 2.20587893893, 25934.12433108940],
[0.00000000760, 4.21317219403, 377.37360791580],
[0.00000000584, 2.13420121623, 10557.59416082380],
[0.00000000574, 0.24250054587, 9779.10867612540],
[0.00000000573, 3.16435264609, 533.21408344360],
[0.00000000685, 3.19344289472, 12146.66705610760],
[0.00000000675, 0.96179233959, 10454.50138660520],
[0.00000000648, 1.46327342555, 6268.84875598980],
[0.00000000589, 2.50543543638, 3097.88382272579],
[0.00000000551, 5.28099026956, 9388.00590941520],
[0.00000000696, 3.65342150016, 4804.20927592700],
[0.00000000669, 2.51030077026, 2388.89402044920],
[0.00000000550, 0.06883864342, 20199.09495963300],
[0.00000000629, 4.13350995675, 45892.73043315699],
[0.00000000678, 6.09190163533, 135.62532501000],
[0.00000000593, 1.50136257618, 226858.23855437008],
[0.00000000542, 3.58573645173, 6148.01076995600],
[0.00000000682, 5.02203067788, 17253.04110768959],
[0.00000000565, 4.29309238610, 11933.36796066960],
[0.00000000486, 0.77746204893, 27.40155609680],
[0.00000000503, 0.58963565969, 15671.08175940660],
[0.00000000616, 4.06539884128, 227.47613278900],
[0.00000000583, 6.12695541996, 18875.52586977400],
[0.00000000537, 2.15056440980, 21954.15760939799],
[0.00000000669, 6.06986269566, 47162.51635463520],
[0.00000000475, 0.40343842110, 6915.85958930460],
[0.00000000540, 2.83444222174, 5326.78669402080],
[0.00000000530, 5.26359885263, 10988.80815753500],
[0.00000000582, 3.24533095664, 153.77881048480],
[0.00000000641, 3.24711791371, 2107.03450754240],
[0.00000000621, 3.09698523779, 33019.02111220460],
[0.00000000466, 3.14982372198, 10440.27429260360],
[0.00000000466, 0.90708835657, 5966.68398033480],
[0.00000000528, 0.81926454470, 813.55028395980],
[0.00000000603, 3.81378921927, 316428.22867391503],
[0.00000000559, 1.81894804124, 17996.03116822220],
[0.00000000437, 2.28625594435, 6303.85124548380],
[0.00000000518, 4.86069178322, 20597.24396304120],
[0.00000000424, 6.23520018693, 6489.26139842860],
[0.00000000518, 6.17617826756, 0.24381748350],
[0.00000000404, 5.72804304258, 5642.19824260920],
[0.00000000458, 1.34117773915, 6287.00800325450],
[0.00000000548, 5.68454458320, 155427.54293624099],
[0.00000000547, 1.03391472061, 3646.35037735440],
[0.00000000428, 4.69800981138, 846.08283475120],
[0.00000000413, 6.02520699406, 6279.48542133960],
[0.00000000534, 3.03030638223, 66567.48586525429],
[0.00000000383, 1.49056949125, 19800.94595622480],
[0.00000000410, 5.28319622279, 18451.07854656599],
[0.00000000352, 4.68891600359, 4907.30205014560],
[0.00000000480, 5.36572651091, 348.92442044800],
[0.00000000344, 5.89157452896, 6546.15977336420],
[0.00000000340, 0.37557426440, 13119.72110282519],
[0.00000000434, 4.98417785901, 6702.56049386660],
[0.00000000332, 2.68902519126, 29296.61538957860],
[0.00000000448, 2.16478480251, 5905.70224207560],
[0.00000000344, 2.06546633735, 49.75702547180],
[0.00000000315, 1.24023811803, 4061.21921539440],
[0.00000000324, 2.30897526929, 5017.50837136500],
[0.00000000413, 0.17171692962, 6286.66627864320],
[0.00000000431, 3.86601101393, 12489.88562870720],
[0.00000000349, 4.55372342974, 4933.20844033260],
[0.00000000323, 0.41971136084, 10770.89325626180],
[0.00000000341, 2.68612860807, 11.04570026390],
[0.00000000316, 3.52936906658, 17782.73207278420],
[0.00000000315, 5.63357264999, 568.82187402740],
[0.00000000340, 3.83571212349, 10660.68693504240],
[0.00000000297, 0.62691416712, 20995.39296644940],
[0.00000000405, 1.00085779471, 16460.33352952499],
[0.00000000414, 1.21998752076, 51092.72605085480],
[0.00000000336, 4.71465945226, 6179.98307577280],
[0.00000000361, 3.71227508354, 28237.23345938940],
[0.00000000385, 6.21925225757, 24356.78078864160],
[0.00000000327, 1.05606504715, 11919.14086666800],
[0.00000000327, 6.14222420989, 6254.62666252360],
[0.00000000268, 2.47224339737, 664.75604513000],
[0.00000000269, 1.86207884109, 23141.55838292460],
[0.00000000345, 0.93461290184, 6058.73105428950],
[0.00000000296, 4.51687557180, 6418.14093002680],
[0.00000000353, 4.50033653082, 36949.23080842420],
[0.00000000260, 4.04963546305, 6525.80445396540],
[0.00000000298, 2.20046722622, 156137.47598479928],
[0.00000000253, 3.49900838384, 29864.33402730900],
[0.00000000254, 2.44901693835, 5331.35744374080],
[0.00000000296, 0.84347588787, 5729.50644714900],
[0.00000000298, 1.29194706125, 22805.73556599360],
[0.00000000241, 2.00721280805, 16737.57723659660],
[0.00000000311, 1.23668016334, 6281.59137728310],
[0.00000000240, 2.51650377121, 6245.04817735560],
[0.00000000332, 3.55576945724, 7668.63742494250],
[0.00000000264, 4.44052061202, 12964.30070339100],
[0.00000000257, 1.79654471948, 11080.17157891760],
[0.00000000260, 3.33077598420, 5888.44996493220],
[0.00000000285, 0.30886361430, 11823.16163945020],
[0.00000000290, 5.70141882483, 77.67377042800],
[0.00000000255, 4.00939664440, 5881.40372823420],
[0.00000000253, 4.73318493678, 16723.35014259500],
[0.00000000228, 0.95333661324, 5540.08578945880],
[0.00000000319, 1.38633229189, 163096.18036118349],
[0.00000000224, 1.65156322696, 10027.90319572920],
[0.00000000226, 0.34106460604, 17796.95916678580],
[0.00000000236, 4.19817431922, 19.66976089979],
[0.00000000280, 4.14080268970, 12539.85338018300],
[0.00000000275, 5.50306930248, 32.53255079140],
[0.00000000223, 5.23334210294, 56.89837493560],
[0.00000000217, 6.08587881787, 6805.65326808520],
[0.00000000280, 4.52472044653, 6016.46880826960],
[0.00000000227, 5.06509843737, 6277.55292568400],
[0.00000000226, 5.17755154305, 11720.06886523160],
[0.00000000245, 3.96486270306, 22.77520145080],
[0.00000000220, 4.72078081970, 6.62855890001],
[0.00000000207, 5.71701403951, 41.55079098480],
[0.00000000204, 3.91227411250, 2699.73481931760],
[0.00000000209, 0.86881969011, 6321.10352262720],
[0.00000000200, 2.11984445273, 4274.51831083240],
[0.00000000200, 5.39839888163, 6019.99192661860],
[0.00000000209, 5.67606291663, 11293.47067435560],
[0.00000000252, 1.64965729351, 9380.95967271720],
[0.00000000275, 5.04826903506, 73.29712585900],
[0.00000000208, 1.88207277133, 11300.58422135640],
[0.00000000272, 0.74640926842, 1975.49254585600],
[0.00000000199, 3.30836672397, 22743.40937951640],
[0.00000000269, 4.48560812155, 64471.99124174489],
[0.00000000192, 2.17464236325, 5863.59120611620],
[0.00000000228, 5.85373115869, 128.01884333740],
[0.00000000261, 2.64321183295, 55022.93574707440],
[0.00000000220, 5.75012110079, 29.42950853600],
[0.00000000187, 4.03230554718, 467.96499035440],
[0.00000000200, 5.60556112058, 1066.49547719000],
[0.00000000231, 1.09802712785, 12341.80690428090],
[0.00000000199, 0.29500625200, 149.56319713460],
[0.00000000249, 5.10473210814, 7875.67186362420],
[0.00000000208, 0.93013835019, 14919.01785375460],
[0.00000000179, 0.87104393079, 12721.57209941700],
[0.00000000203, 1.56920753653, 28286.99048486120],
[0.00000000179, 2.47036386443, 16062.18452611680],
[0.00000000198, 3.54061588502, 30.91412563500],
[0.00000000171, 3.45356518113, 5327.47610838280],
[0.00000000183, 0.72325421604, 6272.03014972750],
[0.00000000216, 2.97174580686, 19402.79695281660],
[0.00000000168, 2.51550550242, 23937.85638974100],
[0.00000000195, 0.09045393425, 156.40072050240],
[0.00000000179, 4.49471798090, 31415.37924995700],
[0.00000000216, 0.42177594328, 23539.70738633280],
[0.00000000189, 0.37542530191, 9814.60410029120],
[0.00000000218, 2.36835880025, 16627.37091537720],
[0.00000000166, 4.23182968446, 16840.67001081519],
[0.00000000200, 2.02153258098, 16097.67995028260],
[0.00000000169, 0.91318727000, 95.97922721780],
[0.00000000211, 5.73370637657, 151.89728108520],
[0.00000000204, 0.42643085174, 515.46387109300],
[0.00000000212, 3.00233538977, 12043.57428188900],
[0.00000000192, 5.46153589821, 6379.05507720920],
[0.00000000165, 1.38698167064, 4171.42553661380],
[0.00000000160, 6.23798383332, 202.25339517410],
[0.00000000215, 0.20889073407, 5621.84292321040],
[0.00000000181, 4.12439203622, 13341.67431130680],
[0.00000000153, 1.24460848836, 29826.30635467320],
[0.00000000150, 3.12999753018, 799.82112516540],
[0.00000000175, 4.55671604437, 239424.39025435288],
[0.00000000192, 1.33928820063, 394.62588505920],
[0.00000000149, 2.65697593276, 21.33564046700],
[0.00000000146, 5.58021191726, 412.37109687440],
[0.00000000156, 3.75650175503, 12323.42309600880],
[0.00000000143, 3.75708566606, 58864.54391814630],
[0.00000000143, 3.28248547724, 29.82143814880],
[0.00000000144, 1.07862546598, 1265.56747862640],
[0.00000000148, 0.23389236655, 10021.83728009940],
[0.00000000193, 5.92751083086, 40879.44050464380],
[0.00000000140, 4.97612440269, 158.94351778320],
[0.00000000148, 2.61640453469, 17157.06188047180],
[0.00000000141, 3.66871308723, 26084.02180621620],
[0.00000000147, 5.09968173403, 661.23292678100],
[0.00000000146, 4.96885605695, 57375.80190084620],
[0.00000000142, 0.78678347839, 12779.45079542080],
[0.00000000134, 4.79432636012, 111.18664228760],
[0.00000000140, 1.27748013377, 107.66352393860],
[0.00000000169, 2.74893543762, 26735.94526221320],
[0.00000000165, 3.95288000638, 6357.85744855870],
[0.00000000183, 5.43418358741, 369.69981594040],
[0.00000000134, 3.09132862833, 17.81252211800],
[0.00000000132, 3.05633896779, 22490.96212149340],
[0.00000000134, 4.09472795832, 6599.46771964800],
[0.00000000181, 4.22950689891, 966.97087743560],
[0.00000000152, 5.28885894415, 12669.24447420140],
[0.00000000150, 5.86819430908, 97238.62754448749],
[0.00000000142, 5.87266532526, 22476.73502749179],
[0.00000000145, 5.07330784304, 87.30820453981],
[0.00000000133, 5.65471067133, 31.97230581680],
[0.00000000124, 2.83326217072, 12566.21901028560],
[0.00000000135, 3.12861731644, 32217.20018108080],
[0.00000000137, 0.86487461904, 9924.81042151060],
[0.00000000172, 1.98369595114, 174242.46596404970],
[0.00000000170, 4.41115280254, 327574.51427678125],
[0.00000000151, 0.46542099527, 39609.65458316560],
[0.00000000148, 2.13439571118, 491.66329245880],
[0.00000000153, 3.78801830344, 17363.24742890899],
[0.00000000165, 5.31654110459, 16943.76278503380],
[0.00000000165, 4.06747587817, 58953.14544329400],
[0.00000000118, 0.63846333239, 6.06591562980],
[0.00000000159, 0.86086959274, 221995.02880149524],
[0.00000000119, 5.96432932413, 1385.89527633620],
[0.00000000114, 5.16516114595, 25685.87280280800],
[0.00000000112, 3.39403722178, 21393.54196985760],
[0.00000000112, 4.92889233335, 56.80326216980],
[0.00000000119, 2.40637635942, 18635.92845453620],
[0.00000000115, 0.23374479051, 418.92439890060],
[0.00000000122, 0.93575234049, 24492.40611365159],
[0.00000000115, 4.58880032176, 26709.64694241340],
[0.00000000130, 4.85539251000, 22345.26037610820],
[0.00000000140, 1.09413073202, 44809.65020086340],
[0.00000000112, 6.05401806281, 433.71173787680],
[0.00000000104, 1.54931540602, 127.95153303460],
[0.00000000105, 4.82620858888, 33794.54372352860],
[0.00000000102, 4.12448497391, 15664.03552270859],
[0.00000000107, 4.67919356465, 77690.75950573849],
[0.00000000118, 4.52320170120, 19004.64794940840],
[0.00000000107, 5.71774478555, 77736.78343050249],
[0.00000000143, 1.81201813018, 4214.06901508480],
[0.00000000125, 1.14419195615, 625.67019231240],
[0.00000000124, 3.27736514057, 12566.08438968000],
[0.00000000110, 1.08682570828, 2787.04302385740],
[0.00000000105, 1.78318141871, 18139.29450141590],
[0.00000000102, 4.75119578149, 12242.64628332540],
[0.00000000137, 1.43510636754, 86464.61331683119],
[0.00000000101, 4.91289409429, 401.67212175720],
[0.00000000129, 1.23567904485, 12029.34718788740],
[0.00000000138, 2.45654707999, 7576.56007357400],
[0.00000000103, 0.40004073416, 90279.92316810328],
[0.00000000108, 0.98989774940, 5636.06501667660],
[0.00000000117, 5.17362872063, 34520.30930938080],
[0.00000000100, 3.95534628189, 5547.19933645960],
[0.00000000098, 1.28118280598, 21548.96236929180],
[0.00000000097, 3.34717130592, 16310.97904572060],
[0.00000000098, 4.37041908717, 34513.26307268280],
[0.00000000125, 2.72164432960, 24065.80792277559],
[0.00000000102, 0.66938025772, 10239.58386601080],
[0.00000000119, 1.21689479331, 1478.86657406440],
[0.00000000094, 1.99595224256, 13362.44970679920],
[0.00000000094, 4.30965982872, 26880.31981303260],
[0.00000000095, 2.89807657534, 34911.41207609100],
[0.00000000106, 1.00156653590, 16522.65971600220],
[0.00000000097, 0.89642320201, 71980.63357473118],
[0.00000000116, 4.19967201116, 206.70073729660],
[0.00000000099, 1.37437847718, 1039.02661079040],
[0.00000000126, 3.21642544972, 305281.94307104882],
[0.00000000094, 0.68997876060, 7834.12107263940],
[0.00000000094, 5.58132218606, 3104.93005942380],
[0.00000000095, 3.03823741110, 8982.81066930900],
[0.00000000108, 0.52696637156, 276.74577186440],
[0.00000000124, 3.43899862683, 172146.97134054029],
[0.00000000102, 1.04031728553, 95143.13292097810],
[0.00000000104, 3.39218586218, 290.97286586600],
[0.00000000110, 3.68205877433, 22380.75580027400],
[0.00000000117, 0.78475956902, 83286.91426955358],
[0.00000000083, 0.18241793425, 15141.39079431200],
[0.00000000089, 4.45371820659, 792.77488846740],
[0.00000000082, 4.80703651241, 6819.88036208680],
[0.00000000087, 3.43122851097, 27707.54249429480],
[0.00000000101, 5.32081603011, 2301.58581590939],
[0.00000000082, 0.87060089842, 10241.20229116720],
[0.00000000086, 4.61919461931, 36147.40987730040],
[0.00000000095, 2.87032884659, 23020.65308658799],
[0.00000000088, 3.21133165690, 33326.57873317420],
[0.00000000080, 1.84900424847, 21424.46664430340],
[0.00000000101, 4.18796434479, 30666.15495843280],
[0.00000000107, 5.77864921649, 34115.11406927460],
[0.00000000104, 1.08739495962, 6288.59877429880],
[0.00000000110, 3.32898859416, 72140.62866668739],
[0.00000000087, 4.40657711727, 142.17862703620],
[0.00000000109, 1.94546030825, 24279.10701821359],
[0.00000000087, 4.32472045435, 742.99006053260],
[0.00000000107, 4.91580912547, 277.03499374140],
[0.00000000088, 2.10180220766, 26482.17080962440],
[0.00000000086, 4.01887374432, 12491.37010141550],
[0.00000000106, 5.49092372854, 62883.35513951360],
[0.00000000080, 6.19781316983, 6709.67404086740],
[0.00000000088, 2.09872810657, 238004.52415723629],
[0.00000000083, 4.90662164029, 51.28033786241],
[0.00000000095, 4.13387406591, 18216.44381066100],
[0.00000000078, 6.06949391680, 148434.53403769129],
[0.00000000079, 3.03048221644, 838.96928775040],
[0.00000000074, 5.49813051211, 29026.48522950779],
[0.00000000073, 3.05008665738, 567.71863773040],
[0.00000000084, 0.46604373274, 45.14121963660],
[0.00000000093, 2.52267536308, 48739.85989708300],
[0.00000000076, 1.76418124905, 41654.96311596780],
[0.00000000067, 5.77851227793, 6311.52503745920],
[0.00000000062, 3.32967880172, 15508.61512327440],
[0.00000000079, 5.59773841328, 71960.38658322369],
[0.00000000057, 3.90629505268, 5999.21653112620],
[0.00000000061, 0.05695043232, 7856.89627409019],
[0.00000000061, 5.63297958433, 7863.94251078820],
[0.00000000065, 3.72178394016, 12573.26524698360],
[0.00000000057, 4.18217219541, 26087.90314157420],
[0.00000000066, 3.92262333487, 69853.35207568129],
[0.00000000053, 5.51119362045, 77710.24834977149],
[0.00000000053, 4.88573986961, 77717.29458646949],
[0.00000000062, 2.88876342225, 9411.46461508720],
[0.00000000051, 1.12657183874, 82576.98122099529],
[0.00000000045, 2.95671076719, 24602.61243487099],
[0.00000000040, 5.55145719241, 12565.17137891460],
[0.00000000039, 1.20838190039, 18842.11400297339],
[0.00000000045, 3.18590558749, 45585.17281218740],
[0.00000000049, 2.44790934886, 13613.80427733600],
], [
[6283.31966747491, 0.00000000000, 0.00000000000],
[0.00206058863, 2.67823455584, 6283.07584999140],
[0.00004303430, 2.63512650414, 12566.15169998280],
[0.00000425264, 1.59046980729, 3.52311834900],
[0.00000108977, 2.96618001993, 1577.34354244780],
[0.00000093478, 2.59212835365, 18849.22754997420],
[0.00000119261, 5.79557487799, 26.29831979980],
[0.00000072122, 1.13846158196, 529.69096509460],
[0.00000067768, 1.87472304791, 398.14900340820],
[0.00000067327, 4.40918235168, 5507.55323866740],
[0.00000059027, 2.88797038460, 5223.69391980220],
[0.00000055976, 2.17471680261, 155.42039943420],
[0.00000045407, 0.39803079805, 796.29800681640],
[0.00000036369, 0.46624739835, 775.52261132400],
[0.00000028958, 2.64707383882, 7.11354700080],
[0.00000019097, 1.84628332577, 5486.77784317500],
[0.00000020844, 5.34138275149, 0.98032106820],
[0.00000018508, 4.96855124577, 213.29909543800],
[0.00000016233, 0.03216483047, 2544.31441988340],
[0.00000017293, 2.99116864949, 6275.96230299060],
[0.00000015832, 1.43049285325, 2146.16541647520],
[0.00000014615, 1.20532366323, 10977.07880469900],
[0.00000011877, 3.25804815607, 5088.62883976680],
[0.00000011514, 2.07502418155, 4694.00295470760],
[0.00000009721, 4.23925472239, 1349.86740965880],
[0.00000009969, 1.30262991097, 6286.59896834040],
[0.00000009452, 2.69957062864, 242.72860397400],
[0.00000012461, 2.83432285512, 1748.01641306700],
[0.00000011808, 5.27379790480, 1194.44701022460],
[0.00000008577, 5.64475868067, 951.71840625060],
[0.00000010641, 0.76614199202, 553.56940284240],
[0.00000007576, 5.30062664886, 2352.86615377180],
[0.00000005834, 1.76649917904, 1059.38193018920],
[0.00000006385, 2.65033984967, 9437.76293488700],
[0.00000005223, 5.66135767624, 71430.69561812909],
[0.00000005305, 0.90857521574, 3154.68708489560],
[0.00000006101, 4.66632584188, 4690.47983635860],
[0.00000004330, 0.24102555403, 6812.76681508600],
[0.00000005041, 1.42490103709, 6438.49624942560],
[0.00000004259, 0.77355900599, 10447.38783960440],
[0.00000005198, 1.85353197345, 801.82093112380],
[0.00000003744, 2.00119516488, 8031.09226305840],
[0.00000003558, 2.42901552681, 14143.49524243060],
[0.00000003372, 3.86210700128, 1592.59601363280],
[0.00000003374, 0.88776219727, 12036.46073488820],
[0.00000003175, 3.18785710594, 4705.73230754360],
[0.00000003221, 0.61599835472, 8429.24126646660],
[0.00000004132, 5.23992859705, 7084.89678111520],
[0.00000002970, 6.07026318493, 4292.33083295040],
[0.00000002900, 2.32464208411, 20.35531939880],
[0.00000003504, 4.79975694359, 6279.55273164240],
[0.00000002950, 1.43108874817, 5746.27133789600],
[0.00000002697, 4.80368225199, 7234.79425624200],
[0.00000002531, 6.22290682655, 6836.64525283380],
[0.00000002745, 0.93466065396, 5760.49843189760],
[0.00000003250, 3.39954640038, 7632.94325965020],
[0.00000002277, 5.00277837672, 17789.84561978500],
[0.00000002075, 3.95534978634, 10213.28554621100],
[0.00000002061, 2.22411683077, 5856.47765911540],
[0.00000002252, 5.67166499885, 11499.65622279280],
[0.00000002148, 5.20184578235, 11513.88331679440],
[0.00000001886, 0.53198320577, 3340.61242669980],
[0.00000001875, 4.73511970207, 83996.84731811189],
[0.00000002060, 2.54987293999, 25132.30339996560],
[0.00000001794, 1.47435409831, 4164.31198961300],
[0.00000001778, 3.02473091781, 5.52292430740],
[0.00000002029, 0.90960209983, 6256.77753019160],
[0.00000002075, 2.26767270157, 522.57741809380],
[0.00000001772, 3.02622802353, 5753.38488489680],
[0.00000001569, 6.12410242782, 5216.58037280140],
[0.00000001590, 4.63713748247, 3.28635741780],
[0.00000001542, 4.20004448567, 13367.97263110660],
[0.00000001427, 1.19088061711, 3894.18182954220],
[0.00000001375, 3.09301252193, 135.06508003540],
[0.00000001359, 4.24532506641, 426.59819087600],
[0.00000001340, 5.76511818622, 6040.34724601740],
[0.00000001284, 3.08524663344, 5643.17856367740],
[0.00000001250, 3.07748157144, 11926.25441366880],
[0.00000001551, 3.07665451458, 6681.22485339960],
[0.00000001268, 2.09196018331, 6290.18939699220],
[0.00000001144, 3.24444699514, 12168.00269657460],
[0.00000001248, 3.44504937285, 536.80451209540],
[0.00000001118, 2.31829670425, 16730.46368959580],
[0.00000001105, 5.31966001019, 23.87843774780],
[0.00000001051, 3.75015946014, 7860.41939243920],
[0.00000001025, 2.44688534235, 1990.74501704100],
[0.00000000962, 0.81771017882, 3.88133535800],
[0.00000000910, 0.41727865299, 7079.37385680780],
[0.00000000883, 5.16833917651, 11790.62908865880],
[0.00000000957, 4.07673573735, 6127.65545055720],
[0.00000001110, 3.90096793825, 11506.76976979360],
[0.00000000802, 3.88778875582, 10973.55568635000],
[0.00000000780, 2.39934293755, 1589.07289528380],
[0.00000000758, 1.30034364248, 103.09277421860],
[0.00000000749, 4.96275803300, 6496.37494542940],
[0.00000000765, 3.36312388424, 36.02786667740],
[0.00000000915, 5.41543742089, 206.18554843720],
[0.00000000776, 2.57589093871, 11371.70468975820],
[0.00000000772, 3.98369209464, 955.59974160860],
[0.00000000749, 5.17890001805, 10969.96525769820],
[0.00000000806, 0.34218864254, 9917.69687450980],
[0.00000000728, 5.20962563787, 38.02767263580],
[0.00000000685, 2.77592961854, 20.77539549240],
[0.00000000636, 4.28242193632, 28.44918746780],
[0.00000000608, 5.63278508906, 10984.19235169980],
[0.00000000704, 5.60738823665, 3738.76143010800],
[0.00000000685, 0.38876148682, 15.25247118500],
[0.00000000601, 0.73489602442, 419.48464387520],
[0.00000000716, 2.65279791438, 6309.37416979120],
[0.00000000584, 5.54502568227, 17298.18232732620],
[0.00000000650, 1.13379656406, 7058.59846131540],
[0.00000000688, 2.59683891779, 3496.03282613400],
[0.00000000485, 0.44467180946, 12352.85260454480],
[0.00000000528, 2.74936967681, 3930.20969621960],
[0.00000000597, 5.27668281777, 10575.40668294180],
[0.00000000583, 3.18929067810, 4732.03062734340],
[0.00000000526, 5.01697321546, 5884.92684658320],
[0.00000000540, 1.29175137075, 640.87760738220],
[0.00000000473, 5.49953306970, 5230.80746680300],
[0.00000000406, 5.21248452189, 220.41264243880],
[0.00000000395, 1.87474483222, 16200.77272450120],
[0.00000000370, 3.84921354713, 18073.70493865020],
[0.00000000367, 0.88533542778, 6283.14316029419],
[0.00000000379, 0.37983009325, 10177.25767953360],
[0.00000000356, 3.84145204913, 11712.95531823080],
[0.00000000374, 5.01577520608, 7.04623669800],
[0.00000000381, 4.30250406634, 6062.66320755260],
[0.00000000471, 0.86381834647, 6069.77675455340],
[0.00000000367, 1.32943839763, 6283.00853968860],
[0.00000000460, 5.19667219575, 6284.05617105960],
[0.00000000333, 5.54256205741, 4686.88940770680],
[0.00000000341, 4.36522989934, 7238.67559160000],
[0.00000000336, 4.00205876835, 3097.88382272579],
[0.00000000359, 6.22679790284, 245.83164622940],
[0.00000000307, 2.35299010924, 170.67287061920],
[0.00000000343, 3.77164927143, 6076.89030155420],
[0.00000000296, 5.44152227481, 17260.15465469040],
[0.00000000328, 0.13837875384, 11015.10647733480],
[0.00000000268, 1.13904550630, 12569.67481833180],
[0.00000000263, 0.00538633678, 4136.91043351620],
[0.00000000282, 5.04399837480, 7477.52286021600],
[0.00000000288, 3.13401177517, 12559.03815298200],
[0.00000000259, 0.93882269387, 5642.19824260920],
[0.00000000292, 1.98420020514, 12132.43996210600],
[0.00000000247, 3.84244798532, 5429.87946823940],
[0.00000000245, 5.70467521726, 65147.61976813770],
[0.00000000241, 0.99480969552, 3634.62102451840],
[0.00000000246, 3.06168069935, 110.20632121940],
[0.00000000239, 6.11855909114, 11856.21865142450],
[0.00000000263, 0.66348415419, 21228.39202354580],
[0.00000000262, 1.51070507866, 12146.66705610760],
[0.00000000230, 1.75927314884, 9779.10867612540],
[0.00000000223, 2.00967043606, 6172.86952877200],
[0.00000000246, 1.10411690865, 6282.09552892320],
[0.00000000221, 3.03945240854, 8635.94200376320],
[0.00000000214, 4.03840869663, 14314.16811304980],
[0.00000000236, 5.46915070580, 13916.01910964160],
[0.00000000224, 4.68408089456, 24072.92146977640],
[0.00000000212, 2.13695625494, 5849.36411211460],
[0.00000000207, 3.07724246401, 11.72935283600],
[0.00000000207, 6.10306282747, 23543.23050468179],
[0.00000000266, 1.00709566823, 2388.89402044920],
[0.00000000217, 6.27837036335, 17267.26820169119],
[0.00000000204, 2.34615348695, 266.60704172180],
[0.00000000195, 5.55015549753, 6133.51265285680],
[0.00000000188, 2.52667166175, 6525.80445396540],
[0.00000000185, 0.90960768344, 18319.53658487960],
[0.00000000177, 1.73429218289, 154717.60988768269],
[0.00000000187, 4.76483647432, 4535.05943692440],
[0.00000000186, 4.63080493407, 10440.27429260360],
[0.00000000215, 2.81255454560, 7342.45778018060],
[0.00000000172, 1.45551888559, 9225.53927328300],
[0.00000000162, 3.30661909388, 639.89728631400],
[0.00000000168, 2.17671416605, 27.40155609680],
[0.00000000160, 1.68164180475, 15110.46611986620],
[0.00000000158, 0.13519771874, 13095.84266507740],
[0.00000000183, 0.56281322071, 13517.87010623340],
[0.00000000179, 3.58450811616, 87.30820453981],
[0.00000000152, 2.84070476818, 5650.29211067820],
[0.00000000182, 0.44065530624, 17253.04110768959],
[0.00000000160, 5.95767264171, 4701.11650170840],
[0.00000000142, 1.46290137520, 11087.28512591840],
[0.00000000142, 2.04464036087, 20426.57109242200],
[0.00000000131, 5.40912137746, 2699.73481931760],
[0.00000000144, 2.07312090485, 25158.60171976540],
[0.00000000147, 6.15106982168, 9623.68827669120],
[0.00000000141, 5.55739979498, 10454.50138660520],
[0.00000000135, 0.06098110407, 16723.35014259500],
[0.00000000124, 5.81218025669, 17256.63153634140],
[0.00000000124, 2.36293551623, 4933.20844033260],
[0.00000000126, 3.47435905118, 22483.84857449259],
[0.00000000159, 5.63954754618, 5729.50644714900],
[0.00000000123, 3.92815963256, 17996.03116822220],
[0.00000000148, 3.02509280598, 1551.04522264800],
[0.00000000120, 5.91904349732, 6206.80977871580],
[0.00000000134, 3.11122937825, 21954.15760939799],
[0.00000000119, 5.52141123450, 709.93304855830],
[0.00000000122, 3.00813429479, 19800.94595622480],
[0.00000000127, 1.37618620001, 14945.31617355440],
[0.00000000141, 2.56889468729, 1052.26838318840],
[0.00000000123, 2.83671175442, 11919.14086666800],
[0.00000000118, 0.81934438215, 5331.35744374080],
[0.00000000151, 2.68731829165, 11769.85369316640],
[0.00000000119, 5.08835797638, 5481.25491886760],
[0.00000000153, 2.46021790779, 11933.36796066960],
[0.00000000108, 1.04936452145, 11403.67699557500],
[0.00000000128, 0.99794735107, 8827.39026987480],
[0.00000000144, 2.54869747042, 227.47613278900],
[0.00000000150, 4.50631437136, 2379.16447357160],
[0.00000000107, 1.79272017026, 13119.72110282519],
[0.00000000107, 4.43556814486, 18422.62935909819],
[0.00000000109, 0.29269062317, 16737.57723659660],
[0.00000000141, 3.18979826258, 6262.30045449900],
[0.00000000122, 4.23040027813, 29.42950853600],
[0.00000000111, 5.16954029551, 17782.73207278420],
[0.00000000100, 3.52213872761, 18052.92954315780],
[0.00000000108, 1.08514212991, 16858.48253293320],
[0.00000000106, 1.96085248410, 74.78159856730],
[0.00000000110, 2.30582372873, 16460.33352952499],
[0.00000000097, 3.50918940210, 5333.90024102160],
[0.00000000099, 3.56417337974, 735.87651353180],
[0.00000000094, 5.01857894228, 3128.38876509580],
[0.00000000097, 1.65579893894, 533.21408344360],
[0.00000000092, 0.89217162285, 29296.61538957860],
[0.00000000123, 3.16062050433, 9380.95967271720],
[0.00000000102, 1.20493500565, 23020.65308658799],
[0.00000000088, 2.21296088224, 12721.57209941700],
[0.00000000089, 1.54264720310, 20199.09495963300],
[0.00000000113, 4.83320707870, 16496.36139620240],
[0.00000000121, 6.19860353182, 9388.00590941520],
[0.00000000089, 4.08082274765, 22805.73556599360],
[0.00000000098, 1.09181832830, 12043.57428188900],
[0.00000000086, 1.13655027605, 143571.32428481648],
[0.00000000088, 5.96980472191, 107.66352393860],
[0.00000000082, 5.01340404594, 22003.91463486980],
[0.00000000094, 1.69615700473, 23006.42599258639],
[0.00000000081, 3.00657814365, 2118.76386037840],
[0.00000000098, 1.39215287161, 8662.24032356300],
[0.00000000077, 3.33555190840, 15720.83878487840],
[0.00000000082, 5.86880116464, 2787.04302385740],
[0.00000000076, 5.67183650604, 14.22709400160],
[0.00000000081, 6.16619455699, 1039.02661079040],
[0.00000000076, 3.21449884756, 111.18664228760],
[0.00000000078, 1.37531518377, 21947.11137270000],
[0.00000000074, 3.58814195051, 11609.86254401220],
[0.00000000077, 4.84846488388, 22743.40937951640],
[0.00000000090, 1.48869013606, 15671.08175940660],
[0.00000000082, 3.48618399109, 29088.81141598500],
[0.00000000069, 3.55746476593, 4590.91018048900],
[0.00000000069, 1.93625656075, 135.62532501000],
[0.00000000070, 2.66548322237, 18875.52586977400],
[0.00000000069, 5.41478093731, 26735.94526221320],
[0.00000000079, 5.15154513662, 12323.42309600880],
[0.00000000094, 3.62899392448, 77713.77146812050],
[0.00000000078, 4.17011182047, 1066.49547719000],
[0.00000000071, 3.89435637865, 22779.43724619380],
[0.00000000063, 4.53968787714, 8982.81066930900],
[0.00000000069, 0.96028230548, 14919.01785375460],
[0.00000000076, 3.29092216589, 2942.46342329160],
[0.00000000063, 4.09167842893, 16062.18452611680],
[0.00000000065, 3.34580407184, 51.28033786241],
[0.00000000065, 5.75757544877, 52670.06959330260],
[0.00000000068, 5.75884067555, 21424.46664430340],
[0.00000000057, 5.45122399850, 12592.45001978260],
[0.00000000057, 5.25043362558, 20995.39296644940],
[0.00000000073, 0.53299090807, 2301.58581590939],
[0.00000000070, 4.31243357502, 19402.79695281660],
[0.00000000067, 2.53852336668, 377.37360791580],
[0.00000000056, 3.20816844695, 24889.57479599160],
[0.00000000053, 3.17816599142, 18451.07854656599],
[0.00000000053, 3.61529270216, 77.67377042800],
[0.00000000053, 0.45467549335, 30666.15495843280],
[0.00000000061, 0.14807288453, 23013.53953958720],
[0.00000000051, 3.32803972907, 56.89837493560],
[0.00000000052, 3.41177624177, 23141.55838292460],
[0.00000000058, 3.13638677202, 309.27832265580],
[0.00000000070, 2.50592323465, 31415.37924995700],
[0.00000000052, 5.10673376738, 17796.95916678580],
[0.00000000067, 6.27917920454, 22345.26037610820],
[0.00000000050, 0.42577644151, 25685.87280280800],
[0.00000000048, 0.70204553333, 1162.47470440780],
[0.00000000066, 3.64350022359, 15265.88651930040],
[0.00000000050, 5.74382917440, 19.66976089979],
[0.00000000050, 4.69825387775, 28237.23345938940],
[0.00000000047, 5.74015846442, 12139.55350910680],
[0.00000000054, 1.97301333704, 23581.25817731760],
[0.00000000049, 4.98223579027, 10021.83728009940],
[0.00000000046, 5.41431705539, 33019.02111220460],
[0.00000000051, 1.23882053879, 12539.85338018300],
[0.00000000046, 2.41369976086, 98068.53671630539],
[0.00000000044, 0.80750593746, 167283.76158766549],
[0.00000000045, 4.39613584445, 433.71173787680],
[0.00000000044, 2.57358208785, 12964.30070339100],
[0.00000000046, 0.26142733448, 11.04570026390],
[0.00000000045, 2.46230645202, 51868.24866217880],
[0.00000000048, 0.89551707131, 56600.27928952220],
[0.00000000057, 1.86416707010, 25287.72379939980],
[0.00000000042, 5.26377513431, 26084.02180621620],
[0.00000000049, 3.17757670611, 6303.85124548380],
[0.00000000052, 3.65266055509, 7872.14874527520],
[0.00000000040, 1.81891629936, 34596.36465465240],
[0.00000000043, 1.94164978061, 1903.43681250120],
[0.00000000041, 0.74461854136, 23937.85638974100],
[0.00000000048, 6.26034008181, 28286.99048486120],
[0.00000000045, 5.45575017530, 60530.48898574180],
[0.00000000040, 2.92105728682, 21548.96236929180],
[0.00000000040, 0.04502010161, 38526.57435087200],
[0.00000000053, 3.64791042082, 11925.27409260060],
[0.00000000041, 5.04048954693, 27832.03821928320],
[0.00000000042, 5.19292937193, 19004.64794940840],
[0.00000000040, 2.57120233428, 24356.78078864160],
[0.00000000038, 3.49190341464, 226858.23855437008],
[0.00000000039, 4.61184303844, 95.97922721780],
[0.00000000043, 2.20648228147, 13521.75144159140],
[0.00000000040, 5.83461945819, 16193.65917750039],
[0.00000000045, 3.73714372195, 7875.67186362420],
[0.00000000043, 1.14078465002, 49.75702547180],
[0.00000000037, 1.29390383811, 310.84079886840],
[0.00000000038, 0.95970925950, 664.75604513000],
[0.00000000037, 4.27532649462, 6709.67404086740],
[0.00000000038, 2.20108541046, 28628.33622609960],
[0.00000000039, 0.85957361635, 16522.65971600220],
[0.00000000040, 4.35214003837, 48739.85989708300],
[0.00000000036, 1.68167662194, 10344.29506538580],
[0.00000000040, 5.13217319067, 15664.03552270859],
[0.00000000036, 3.72187132496, 30774.50164257480],
[0.00000000036, 3.32158458257, 16207.88627150200],
[0.00000000045, 3.94202418608, 10988.80815753500],
[0.00000000039, 1.51948786199, 12029.34718788740],
[0.00000000026, 3.87685883180, 6262.72053059260],
[0.00000000024, 4.91804163466, 19651.04848109800],
[0.00000000023, 0.29300197709, 13362.44970679920],
[0.00000000021, 3.18605672363, 6277.55292568400],
[0.00000000021, 6.07546891132, 18139.29450141590],
[0.00000000022, 2.31199937177, 6303.43116939020],
[0.00000000021, 3.58418394393, 18209.33026366019],
[0.00000000026, 2.06801296900, 12573.26524698360],
[0.00000000021, 1.56857722317, 13341.67431130680],
[0.00000000024, 5.72605158675, 29864.33402730900],
[0.00000000024, 1.40237993205, 14712.31711645800],
[0.00000000025, 5.71466092822, 25934.12433108940],
], [
[0.00052918870, 0.00000000000, 0.00000000000],
[0.00008719837, 1.07209665242, 6283.07584999140],
[0.00000309125, 0.86728818832, 12566.15169998280],
[0.00000027339, 0.05297871691, 3.52311834900],
[0.00000016334, 5.18826691036, 26.29831979980],
[0.00000015752, 3.68457889430, 155.42039943420],
[0.00000009541, 0.75742297675, 18849.22754997420],
[0.00000008937, 2.05705419118, 77713.77146812050],
[0.00000006952, 0.82673305410, 775.52261132400],
[0.00000005064, 4.66284525271, 1577.34354244780],
[0.00000004061, 1.03057162962, 7.11354700080],
[0.00000003463, 5.14074632811, 796.29800681640],
[0.00000003169, 6.05291851171, 5507.55323866740],
[0.00000003020, 1.19246506441, 242.72860397400],
[0.00000002886, 6.11652627155, 529.69096509460],
[0.00000003810, 3.44050803490, 5573.14280143310],
[0.00000002714, 0.30637881025, 398.14900340820],
[0.00000002371, 4.38118838167, 5223.69391980220],
[0.00000002538, 2.27992810679, 553.56940284240],
[0.00000002079, 3.75435330484, 0.98032106820],
[0.00000001675, 0.90216407959, 951.71840625060],
[0.00000001534, 5.75900462759, 1349.86740965880],
[0.00000001224, 2.97328088405, 2146.16541647520],
[0.00000001449, 4.36415913970, 1748.01641306700],
[0.00000001341, 3.72061130861, 1194.44701022460],
[0.00000001254, 2.94846826628, 6438.49624942560],
[0.00000000999, 5.98640014468, 6286.59896834040],
[0.00000000917, 4.79788687522, 5088.62883976680],
[0.00000000828, 3.31321076572, 213.29909543800],
[0.00000001103, 1.27104454479, 161000.68573767410],
[0.00000000762, 3.41582762988, 5486.77784317500],
[0.00000001044, 0.60409577691, 3154.68708489560],
[0.00000000887, 5.23465144638, 7084.89678111520],
[0.00000000645, 1.60096192515, 2544.31441988340],
[0.00000000681, 3.43155669169, 4694.00295470760],
[0.00000000605, 2.47806340546, 10977.07880469900],
[0.00000000706, 6.19393222575, 4690.47983635860],
[0.00000000643, 1.98042503148, 801.82093112380],
[0.00000000502, 1.44394375363, 6836.64525283380],
[0.00000000490, 2.34129524194, 1592.59601363280],
[0.00000000458, 1.30876448575, 4292.33083295040],
[0.00000000431, 0.03526421494, 7234.79425624200],
[0.00000000379, 3.17030522615, 6309.37416979120],
[0.00000000348, 0.99049550009, 6040.34724601740],
[0.00000000386, 1.57019797263, 71430.69561812909],
[0.00000000347, 0.67013291338, 1059.38193018920],
[0.00000000458, 3.81499443681, 149854.40013480789],
[0.00000000302, 1.91760044838, 10447.38783960440],
[0.00000000307, 3.55343347416, 8031.09226305840],
[0.00000000395, 4.93701776616, 7632.94325965020],
[0.00000000314, 3.18093696547, 2352.86615377180],
[0.00000000282, 4.41936437052, 9437.76293488700],
[0.00000000276, 2.71314254553, 3894.18182954220],
[0.00000000298, 2.52037474210, 6127.65545055720],
[0.00000000230, 1.37790215549, 4705.73230754360],
[0.00000000252, 0.55330133471, 6279.55273164240],
[0.00000000255, 5.26570187369, 6812.76681508600],
[0.00000000275, 0.67264264272, 25132.30339996560],
[0.00000000178, 0.92820785174, 1990.74501704100],
[0.00000000221, 0.63897368842, 6256.77753019160],
[0.00000000155, 0.77319790838, 14143.49524243060],
[0.00000000150, 2.40470465561, 426.59819087600],
[0.00000000196, 6.06877865012, 640.87760738220],
[0.00000000137, 2.21679460145, 8429.24126646660],
[0.00000000127, 3.26094223174, 17789.84561978500],
[0.00000000128, 5.47237279946, 12036.46073488820],
[0.00000000122, 2.16291082757, 10213.28554621100],
[0.00000000118, 0.45789822268, 7058.59846131540],
[0.00000000141, 2.34932647403, 11506.76976979360],
[0.00000000100, 0.85621569847, 6290.18939699220],
[0.00000000092, 5.10587476002, 7079.37385680780],
[0.00000000126, 2.65428307012, 88860.05707098669],
[0.00000000106, 5.85646710022, 7860.41939243920],
[0.00000000084, 3.57457554262, 16730.46368959580],
[0.00000000089, 4.21433259618, 83996.84731811189],
[0.00000000097, 5.57938280855, 13367.97263110660],
[0.00000000102, 2.05853060226, 87.30820453981],
[0.00000000080, 4.73792651816, 11926.25441366880],
[0.00000000080, 5.41418965044, 10973.55568635000],
[0.00000000106, 4.10978997399, 3496.03282613400],
[0.00000000102, 3.62650006043, 244287.60000722769],
[0.00000000075, 4.89483161769, 5643.17856367740],
[0.00000000087, 0.42863750683, 11015.10647733480],
[0.00000000069, 1.88908760720, 10177.25767953360],
[0.00000000089, 1.35567273119, 6681.22485339960],
[0.00000000066, 0.99455837265, 6525.80445396540],
[0.00000000067, 5.51240997070, 3097.88382272579],
[0.00000000076, 2.72016814799, 4164.31198961300],
[0.00000000063, 1.44349902540, 9917.69687450980],
[0.00000000078, 3.51469733747, 11856.21865142450],
[0.00000000085, 0.50956043858, 10575.40668294180],
[0.00000000067, 3.62043033405, 16496.36139620240],
[0.00000000055, 5.24637517308, 3340.61242669980],
[0.00000000048, 5.43966777314, 20426.57109242200],
[0.00000000064, 5.79535817813, 2388.89402044920],
[0.00000000046, 5.43499966519, 6275.96230299060],
[0.00000000050, 3.86263598617, 5729.50644714900],
[0.00000000044, 1.52269529228, 12168.00269657460],
[0.00000000057, 4.96352373486, 14945.31617355440],
[0.00000000045, 1.00861230160, 8635.94200376320],
[0.00000000043, 3.30685683359, 9779.10867612540],
[0.00000000042, 0.63481258930, 2699.73481931760],
[0.00000000041, 5.67996766641, 11712.95531823080],
[0.00000000056, 4.34024451468, 90955.55169449610],
[0.00000000041, 5.81722212845, 709.93304855830],
[0.00000000053, 6.17052087143, 233141.31440436149],
[0.00000000037, 3.12495025087, 16200.77272450120],
[0.00000000035, 5.76973458495, 12569.67481833180],
[0.00000000037, 0.31656444326, 24356.78078864160],
[0.00000000035, 0.96229051027, 17298.18232732620],
[0.00000000033, 5.23130355867, 5331.35744374080],
[0.00000000035, 0.62517020593, 25158.60171976540],
[0.00000000035, 0.80004512129, 13916.01910964160],
[0.00000000037, 2.89336088688, 12721.57209941700],
[0.00000000030, 4.50198402401, 23543.23050468179],
[0.00000000030, 5.31355708693, 18319.53658487960],
[0.00000000029, 3.47275229977, 13119.72110282519],
[0.00000000029, 3.11002782516, 4136.91043351620],
[0.00000000032, 5.52273255667, 5753.38488489680],
[0.00000000035, 3.79699996680, 143571.32428481648],
[0.00000000026, 1.50634201907, 154717.60988768269],
[0.00000000030, 3.53519084118, 6284.05617105960],
[0.00000000023, 4.41808025967, 5884.92684658320],
[0.00000000025, 1.38477355808, 65147.61976813770],
[0.00000000023, 3.49782549797, 7477.52286021600],
[0.00000000019, 3.14329413716, 6496.37494542940],
[0.00000000019, 2.20135125199, 18073.70493865020],
[0.00000000019, 4.95020255309, 3930.20969621960],
[0.00000000019, 0.57998702747, 31415.37924995700],
[0.00000000021, 1.75474323399, 12139.55350910680],
[0.00000000019, 3.92233070499, 19651.04848109800],
[0.00000000014, 0.98131213224, 12559.03815298200],
[0.00000000019, 4.93309333729, 2942.46342329160],
[0.00000000016, 5.55997534558, 8827.39026987480],
[0.00000000013, 1.68808165516, 4535.05943692440],
[0.00000000013, 0.33982116161, 4933.20844033260],
[0.00000000012, 1.85426309994, 5856.47765911540],
[0.00000000010, 4.82763996845, 13095.84266507740],
[0.00000000011, 5.38005490571, 11790.62908865880],
[0.00000000010, 1.40815507226, 10988.80815753500],
[0.00000000011, 3.05005267431, 17260.15465469040],
[0.00000000010, 4.93364992366, 12352.85260454480],
], [
[0.00000289226, 5.84384198723, 6283.07584999140],
[0.00000034955, 0.00000000000, 0.00000000000],
[0.00000016819, 5.48766912348, 12566.15169998280],
[0.00000002962, 5.19577265202, 155.42039943420],
[0.00000001288, 4.72200252235, 3.52311834900],
[0.00000000635, 5.96925937141, 242.72860397400],
[0.00000000714, 5.30045809128, 18849.22754997420],
[0.00000000402, 3.78682982419, 553.56940284240],
[0.00000000072, 4.29768126180, 6286.59896834040],
[0.00000000067, 0.90721687647, 6127.65545055720],
[0.00000000036, 5.24029648014, 6438.49624942560],
[0.00000000024, 5.16003960716, 25132.30339996560],
[0.00000000023, 3.01921570335, 6309.37416979120],
[0.00000000017, 5.82863573502, 6525.80445396540],
[0.00000000017, 3.67772863930, 71430.69561812909],
[0.00000000009, 4.58467294499, 1577.34354244780],
[0.00000000008, 1.40626662824, 11856.21865142450],
[0.00000000008, 5.07561257196, 6256.77753019160],
[0.00000000007, 2.82473374405, 83996.84731811189],
[0.00000000005, 2.71488713339, 10977.07880469900],
[0.00000000005, 3.76879847273, 12036.46073488820],
[0.00000000005, 4.28412873331, 6275.96230299060],
], [
[0.00000114084, 3.14159265359, 0.00000000000],
[0.00000007717, 4.13446589358, 6283.07584999140],
[0.00000000765, 3.83803776214, 12566.15169998280],
[0.00000000420, 0.41925861858, 155.42039943420],
[0.00000000040, 3.59847585840, 18849.22754997420],
[0.00000000041, 3.14398414077, 3.52311834900],
[0.00000000035, 5.00298940826, 5573.14280143310],
[0.00000000013, 0.48794833701, 77713.77146812050],
[0.00000000010, 5.64801766350, 6127.65545055720],
[0.00000000008, 2.84160570605, 161000.68573767410],
[0.00000000002, 0.54912904658, 6438.49624942560],
], [
[0.00000000878, 3.14159265359, 0.00000000000],
[0.00000000172, 2.76579069510, 6283.07584999140],
[0.00000000050, 2.01353298182, 155.42039943420],
[0.00000000028, 2.21496423926, 12566.15169998280],
[0.00000000005, 1.75600058765, 18849.22754997420],
]],
('Earth', 'B'):[[
[0.00000279620, 3.19870156017, 84334.66158130829],
[0.00000101643, 5.42248619256, 5507.55323866740],
[0.00000080445, 3.88013204458, 5223.69391980220],
[0.00000043806, 3.70444689758, 2352.86615377180],
[0.00000031933, 4.00026369781, 1577.34354244780],
[0.00000022724, 3.98473831560, 1047.74731175470],
[0.00000016392, 3.56456119782, 5856.47765911540],
[0.00000018141, 4.98367470263, 6283.07584999140],
[0.00000014443, 3.70275614914, 9437.76293488700],
[0.00000014304, 3.41117857525, 10213.28554621100],
[0.00000011246, 4.82820690530, 14143.49524243060],
[0.00000010900, 2.08574562327, 6812.76681508600],
[0.00000009714, 3.47303947752, 4694.00295470760],
[0.00000010367, 4.05663927946, 71092.88135493269],
[0.00000008775, 4.44016515669, 5753.38488489680],
[0.00000008366, 4.99251512180, 7084.89678111520],
[0.00000006921, 4.32559054073, 6275.96230299060],
[0.00000009145, 1.14182646613, 6620.89011318780],
[0.00000007194, 3.60193205752, 529.69096509460],
[0.00000007698, 5.55425745881, 167621.57585086189],
[0.00000005285, 2.48446991566, 4705.73230754360],
[0.00000005208, 6.24992674537, 18073.70493865020],
[0.00000004529, 2.33827747356, 6309.37416979120],
[0.00000005579, 4.41023653738, 7860.41939243920],
[0.00000004743, 0.70995680136, 5884.92684658320],
[0.00000004301, 1.10255777773, 6681.22485339960],
[0.00000003849, 1.82229412531, 5486.77784317500],
[0.00000004093, 5.11700141207, 13367.97263110660],
[0.00000003681, 0.43793170356, 3154.68708489560],
[0.00000003420, 5.42034800952, 6069.77675455340],
[0.00000003617, 6.04641937526, 3930.20969621960],
[0.00000003670, 4.58210192227, 12194.03291462090],
[0.00000002918, 1.95463881126, 10977.07880469900],
[0.00000002797, 5.61259275048, 11790.62908865880],
[0.00000002502, 0.60499729367, 6496.37494542940],
[0.00000002319, 5.01648216014, 1059.38193018920],
[0.00000002684, 1.39470396488, 22003.91463486980],
[0.00000002428, 3.24183056052, 78051.58573131690],
[0.00000002120, 4.30691000285, 5643.17856367740],
[0.00000002257, 3.15557225618, 90617.73743129970],
[0.00000001813, 3.75574218285, 3340.61242669980],
[0.00000002226, 2.79699346659, 12036.46073488820],
[0.00000001888, 0.86991545823, 8635.94200376320],
[0.00000001517, 1.95852055701, 398.14900340820],
[0.00000001581, 3.19976230948, 5088.62883976680],
[0.00000001421, 6.25530883827, 2544.31441988340],
[0.00000001595, 0.25619915135, 17298.18232732620],
[0.00000001391, 4.69964175561, 7058.59846131540],
[0.00000001478, 2.81808207569, 25934.12433108940],
[0.00000001481, 3.65823554806, 11506.76976979360],
[0.00000001693, 4.95689385293, 156475.29024799570],
[0.00000001183, 1.29343061246, 775.52261132400],
[0.00000001114, 2.37889311846, 3738.76143010800],
[0.00000000994, 4.30088900425, 9225.53927328300],
[0.00000000924, 3.06451026812, 4164.31198961300],
[0.00000000867, 0.55606931068, 8429.24126646660],
[0.00000000988, 5.97286104208, 7079.37385680780],
[0.00000000824, 1.50984806173, 10447.38783960440],
[0.00000000915, 0.12635654592, 11015.10647733480],
[0.00000000742, 1.99159139281, 26087.90314157420],
[0.00000001039, 3.14159265359, 0.00000000000],
[0.00000000850, 4.24120016095, 29864.33402730900],
[0.00000000755, 2.89631873320, 4732.03062734340],
[0.00000000714, 1.37548118603, 2146.16541647520],
[0.00000000708, 1.91406542362, 8031.09226305840],
[0.00000000746, 0.57893808616, 796.29800681640],
[0.00000000802, 5.12339137230, 2942.46342329160],
[0.00000000751, 1.67479850166, 21228.39202354580],
[0.00000000602, 4.09976538826, 64809.80550494129],
[0.00000000594, 3.49580704962, 16496.36139620240],
[0.00000000592, 4.59481504319, 4690.47983635860],
[0.00000000530, 5.73979295200, 8827.39026987480],
[0.00000000503, 5.66433137112, 33794.54372352860],
[0.00000000483, 1.57106522411, 801.82093112380],
[0.00000000438, 0.06707733767, 3128.38876509580],
[0.00000000423, 2.86944595927, 12566.15169998280],
[0.00000000504, 3.26207669160, 7632.94325965020],
[0.00000000552, 1.02926440457, 239762.20451754928],
[0.00000000427, 3.67434378210, 213.29909543800],
[0.00000000404, 1.46193297142, 15720.83878487840],
[0.00000000503, 4.85802444134, 6290.18939699220],
[0.00000000417, 0.81920713533, 5216.58037280140],
[0.00000000365, 0.01002966162, 12168.00269657460],
[0.00000000363, 1.28376436579, 6206.80977871580],
[0.00000000353, 4.70059133110, 7234.79425624200],
[0.00000000415, 0.96862624175, 4136.91043351620],
[0.00000000387, 3.09145061418, 25158.60171976540],
[0.00000000373, 2.65119262792, 7342.45778018060],
[0.00000000361, 2.97762937739, 9623.68827669120],
[0.00000000418, 3.75759994446, 5230.80746680300],
[0.00000000396, 1.22507712354, 6438.49624942560],
[0.00000000322, 1.21162178805, 8662.24032356300],
[0.00000000284, 5.64170320068, 1589.07289528380],
[0.00000000379, 1.72248432748, 14945.31617355440],
[0.00000000320, 3.94161159962, 7330.82316174610],
[0.00000000313, 5.47602376446, 1194.44701022460],
[0.00000000292, 1.38971327603, 11769.85369316640],
[0.00000000305, 0.80429352049, 37724.75341974820],
[0.00000000257, 5.81382809757, 426.59819087600],
[0.00000000265, 6.10358507671, 6836.64525283380],
[0.00000000250, 4.56452895547, 7477.52286021600],
[0.00000000266, 2.62926282354, 7238.67559160000],
[0.00000000263, 6.22089501237, 6133.51265285680],
[0.00000000306, 2.79682380531, 1748.01641306700],
[0.00000000236, 2.46093023714, 11371.70468975820],
[0.00000000316, 1.62662805006, 250908.49012041549],
[0.00000000216, 3.68721275185, 5849.36411211460],
[0.00000000230, 0.36165162947, 5863.59120611620],
[0.00000000233, 5.03509933858, 20426.57109242200],
[0.00000000200, 5.86073159059, 4535.05943692440],
[0.00000000277, 4.65400292395, 82239.16695779889],
[0.00000000209, 3.72323200804, 10973.55568635000],
[0.00000000199, 5.05186622555, 5429.87946823940],
[0.00000000256, 2.40923279770, 19651.04848109800],
[0.00000000210, 4.50691909144, 29088.81141598500],
[0.00000000181, 6.00294783127, 4292.33083295040],
[0.00000000249, 0.12900984422, 154379.79562448629],
[0.00000000209, 3.87759458598, 17789.84561978500],
[0.00000000225, 3.18339652605, 18875.52586977400],
[0.00000000191, 4.53897489299, 18477.10876461230],
[0.00000000172, 2.09694183014, 13095.84266507740],
[0.00000000182, 3.16107943500, 16730.46368959580],
[0.00000000188, 2.22746128596, 41654.96311596780],
[0.00000000164, 5.18686275017, 5481.25491886760],
[0.00000000160, 2.49298855159, 12592.45001978260],
[0.00000000155, 1.59595438230, 10021.83728009940],
[0.00000000135, 0.21349051064, 10988.80815753500],
[0.00000000178, 3.80375177970, 23581.25817731760],
[0.00000000123, 1.66800739151, 15110.46611986620],
[0.00000000122, 2.72678272244, 18849.22754997420],
[0.00000000126, 1.17675512910, 14919.01785375460],
[0.00000000142, 3.95053441332, 337.81426319640],
[0.00000000116, 6.06340906229, 6709.67404086740],
[0.00000000137, 3.52143246757, 12139.55350910680],
[0.00000000136, 2.92179113542, 32217.20018108080],
[0.00000000110, 3.51203379263, 18052.92954315780],
[0.00000000147, 4.63371971408, 22805.73556599360],
[0.00000000108, 5.45280814878, 7.11354700080],
[0.00000000148, 0.65447253687, 95480.94718417450],
[0.00000000119, 5.92110458985, 33019.02111220460],
[0.00000000110, 5.34824206306, 639.89728631400],
[0.00000000106, 3.71081682629, 14314.16811304980],
[0.00000000139, 6.17607198418, 24356.78078864160],
[0.00000000118, 5.59738712670, 161338.50000087050],
[0.00000000117, 3.65065271640, 45585.17281218740],
[0.00000000127, 4.74596574209, 49515.38250840700],
[0.00000000120, 1.04211499785, 6915.85958930460],
[0.00000000120, 5.60638811846, 5650.29211067820],
[0.00000000115, 3.10668213289, 14712.31711645800],
[0.00000000099, 0.69018940049, 12779.45079542080],
[0.00000000097, 1.07908724794, 9917.69687450980],
[0.00000000093, 2.62295197319, 17260.15465469040],
[0.00000000099, 4.45774681732, 4933.20844033260],
[0.00000000123, 1.37488922089, 28286.99048486120],
[0.00000000121, 5.19767249813, 27511.46787353720],
[0.00000000105, 0.87192267806, 77375.95720492408],
[0.00000000087, 3.93637812950, 17654.78053974960],
[0.00000000122, 2.23956068680, 83997.09113559539],
[0.00000000087, 4.18201600952, 22779.43724619380],
[0.00000000104, 4.59580877295, 1349.86740965880],
[0.00000000102, 2.83545248411, 12352.85260454480],
[0.00000000102, 3.97386522171, 10818.13528691580],
[0.00000000101, 4.32892825857, 36147.40987730040],
[0.00000000094, 5.00001709261, 150192.21439800429],
[0.00000000077, 3.97199369296, 1592.59601363280],
[0.00000000100, 6.07733097102, 26735.94526221320],
[0.00000000086, 5.26029638250, 28313.28880466100],
[0.00000000093, 4.31900620254, 44809.65020086340],
[0.00000000076, 6.22743405935, 13521.75144159140],
[0.00000000072, 1.55820597747, 6256.77753019160],
[0.00000000082, 4.95202664555, 10575.40668294180],
[0.00000000082, 1.69647647075, 1990.74501704100],
[0.00000000075, 2.29836095644, 3634.62102451840],
[0.00000000075, 2.66367876557, 16200.77272450120],
[0.00000000087, 0.26630214764, 31441.67756975680],
[0.00000000077, 2.25530954137, 5235.32853823670],
[0.00000000076, 1.09869730846, 12903.96596317920],
[0.00000000058, 4.28246138307, 12559.03815298200],
[0.00000000064, 5.51112830114, 173904.65170085328],
[0.00000000056, 2.60133794851, 73188.37597844210],
[0.00000000055, 5.81483150022, 143233.51002162008],
[0.00000000054, 3.38482031504, 323049.11878710288],
[0.00000000039, 3.28500401343, 71768.50988132549],
[0.00000000039, 3.11239910690, 96900.81328129109],
], [
[0.00000009030, 3.89729061890, 5507.55323866740],
[0.00000006177, 1.73038850355, 5223.69391980220],
[0.00000003800, 5.24404145734, 2352.86615377180],
[0.00000002834, 2.47345037450, 1577.34354244780],
[0.00000001817, 0.41874743765, 6283.07584999140],
[0.00000001499, 1.83320979291, 5856.47765911540],
[0.00000001466, 5.69401926017, 5753.38488489680],
[0.00000001301, 2.18890066314, 9437.76293488700],
[0.00000001233, 4.95222451476, 10213.28554621100],
[0.00000001021, 0.12866660208, 7860.41939243920],
[0.00000000982, 0.09005453285, 14143.49524243060],
[0.00000000865, 1.73949953555, 3930.20969621960],
[0.00000000581, 2.26949174067, 5884.92684658320],
[0.00000000524, 5.65662503159, 529.69096509460],
[0.00000000473, 6.22750969242, 6309.37416979120],
[0.00000000451, 1.53288619213, 18073.70493865020],
[0.00000000364, 3.61614477374, 13367.97263110660],
[0.00000000372, 3.22470721320, 6275.96230299060],
[0.00000000268, 2.34341267879, 11790.62908865880],
[0.00000000322, 0.94084045832, 6069.77675455340],
[0.00000000232, 0.26781182579, 7058.59846131540],
[0.00000000216, 6.05952221329, 10977.07880469900],
[0.00000000232, 2.93325646109, 22003.91463486980],
[0.00000000204, 3.86264841382, 6496.37494542940],
[0.00000000202, 2.81892511133, 15720.83878487840],
[0.00000000185, 4.93512381859, 12036.46073488820],
[0.00000000220, 3.99305643742, 6812.76681508600],
[0.00000000166, 1.74970002999, 11506.76976979360],
[0.00000000212, 1.57166285369, 4694.00295470760],
[0.00000000157, 1.08259734788, 5643.17856367740],
[0.00000000154, 5.99434678412, 5486.77784317500],
[0.00000000144, 5.23285656085, 78051.58573131690],
[0.00000000144, 1.16454655948, 90617.73743129970],
[0.00000000137, 2.67760436027, 6290.18939699220],
[0.00000000180, 2.06509026215, 7084.89678111520],
[0.00000000121, 5.90212574947, 9225.53927328300],
[0.00000000150, 2.00175038718, 5230.80746680300],
[0.00000000149, 5.06157254516, 17298.18232732620],
[0.00000000118, 5.39979058038, 3340.61242669980],
[0.00000000161, 3.32421999691, 6283.31966747490],
[0.00000000121, 4.36722193162, 19651.04848109800],
[0.00000000116, 5.83462858507, 4705.73230754360],
[0.00000000128, 4.35489873365, 25934.12433108940],
[0.00000000143, 0.00000000000, 0.00000000000],
[0.00000000109, 2.52157834166, 6438.49624942560],
[0.00000000099, 2.70727488041, 5216.58037280140],
[0.00000000103, 0.93782340879, 8827.39026987480],
[0.00000000082, 4.29214680390, 8635.94200376320],
[0.00000000079, 2.24085737326, 1059.38193018920],
[0.00000000097, 5.50959692365, 29864.33402730900],
[0.00000000072, 0.21891639822, 21228.39202354580],
[0.00000000071, 2.86755026812, 6681.22485339960],
[0.00000000074, 2.20184828895, 37724.75341974820],
[0.00000000063, 4.45586625948, 7079.37385680780],
[0.00000000061, 0.63918772258, 33794.54372352860],
[0.00000000047, 2.09070235724, 3128.38876509580],
[0.00000000047, 3.32543843300, 26087.90314157420],
[0.00000000049, 1.60680905005, 6702.56049386660],
[0.00000000057, 0.11215813438, 29088.81141598500],
[0.00000000056, 5.47982934911, 775.52261132400],
[0.00000000050, 1.89396788463, 12139.55350910680],
[0.00000000047, 2.97214907240, 20426.57109242200],
[0.00000000041, 5.55329394890, 11015.10647733480],
[0.00000000041, 5.91861144924, 23581.25817731760],
[0.00000000045, 4.95273290181, 5863.59120611620],
[0.00000000050, 3.62740835096, 41654.96311596780],
[0.00000000037, 6.09033460601, 64809.80550494129],
[0.00000000037, 5.86153655431, 12566.15169998280],
[0.00000000046, 1.65798680284, 25158.60171976540],
[0.00000000038, 2.00673650251, 426.59819087600],
[0.00000000036, 6.24373396652, 6283.14316029419],
[0.00000000036, 0.40465162918, 6283.00853968860],
[0.00000000032, 6.03707103538, 2942.46342329160],
[0.00000000041, 4.86809570283, 1592.59601363280],
[0.00000000028, 4.38359423735, 7632.94325965020],
[0.00000000028, 6.03334294232, 17789.84561978500],
[0.00000000026, 3.88971333608, 5331.35744374080],
[0.00000000026, 5.94932724051, 16496.36139620240],
[0.00000000031, 1.44666331503, 16730.46368959580],
[0.00000000026, 6.26376705837, 23543.23050468179],
[0.00000000033, 0.93797239147, 213.29909543800],
[0.00000000026, 3.71858432944, 13095.84266507740],
[0.00000000027, 0.60565274405, 10988.80815753500],
[0.00000000023, 4.44388985550, 18849.22754997420],
[0.00000000028, 1.53862289477, 6279.48542133960],
[0.00000000028, 1.96831814872, 6286.66627864320],
[0.00000000028, 5.78094918529, 15110.46611986620],
[0.00000000026, 2.48165809843, 5729.50644714900],
[0.00000000020, 3.85655029499, 9623.68827669120],
[0.00000000021, 5.83006047147, 7234.79425624200],
[0.00000000021, 0.69628570421, 398.14900340820],
[0.00000000022, 5.02222806555, 6127.65545055720],
[0.00000000020, 3.47611265290, 6148.01076995600],
[0.00000000020, 0.90769829044, 5481.25491886760],
[0.00000000020, 0.03081589303, 6418.14093002680],
[0.00000000020, 3.74220084927, 1589.07289528380],
[0.00000000021, 4.00149269576, 3154.68708489560],
[0.00000000018, 1.58348238359, 2118.76386037840],
[0.00000000019, 0.85407021371, 14712.31711645800],
], [
[0.00000001662, 1.62703209173, 84334.66158130829],
[0.00000000492, 2.41382223971, 1047.74731175470],
[0.00000000344, 2.24353004539, 5507.55323866740],
[0.00000000258, 6.00906896311, 5223.69391980220],
[0.00000000131, 0.95447345240, 6283.07584999140],
[0.00000000086, 1.67530247303, 7860.41939243920],
[0.00000000090, 0.97606804452, 1577.34354244780],
[0.00000000090, 0.37899871725, 2352.86615377180],
[0.00000000089, 6.25807507963, 10213.28554621100],
[0.00000000075, 0.84213523741, 167621.57585086189],
[0.00000000052, 1.70501566089, 14143.49524243060],
[0.00000000057, 6.15295833679, 12194.03291462090],
[0.00000000051, 1.27616016740, 5753.38488489680],
[0.00000000051, 5.37229738682, 6812.76681508600],
[0.00000000034, 1.73672994279, 7058.59846131540],
[0.00000000038, 2.77761031485, 10988.80815753500],
[0.00000000046, 3.38617099014, 156475.29024799570],
[0.00000000021, 1.95248349228, 8827.39026987480],
[0.00000000018, 3.33419222028, 8429.24126646660],
[0.00000000019, 4.32945160287, 17789.84561978500],
[0.00000000017, 0.66191210656, 6283.00853968860],
[0.00000000018, 3.74885333072, 11769.85369316640],
[0.00000000017, 4.23058370776, 10977.07880469900],
[0.00000000017, 1.78116162721, 5486.77784317500],
[0.00000000021, 1.36972913918, 12036.46073488820],
[0.00000000017, 2.79601092529, 796.29800681640],
[0.00000000015, 0.43087848850, 11790.62908865880],
[0.00000000017, 1.35132152761, 78051.58573131690],
[0.00000000015, 1.17032155085, 213.29909543800],
[0.00000000018, 2.85221514199, 5088.62883976680],
[0.00000000017, 0.21780913672, 6283.14316029419],
[0.00000000013, 1.21201504386, 25132.30339996560],
[0.00000000012, 1.12953712197, 90617.73743129970],
[0.00000000012, 5.13714452592, 7079.37385680780],
[0.00000000013, 3.79842135217, 4933.20844033260],
[0.00000000012, 4.89407978213, 3738.76143010800],
[0.00000000015, 6.05682328852, 398.14900340820],
[0.00000000014, 4.81029291856, 4694.00295470760],
[0.00000000011, 0.61684523405, 3128.38876509580],
[0.00000000011, 5.32876538500, 6040.34724601740],
[0.00000000014, 5.27227350286, 4535.05943692440],
[0.00000000011, 2.39292099451, 5331.35744374080],
[0.00000000010, 4.45296532710, 6525.80445396540],
[0.00000000014, 4.66400985037, 8031.09226305840],
[0.00000000010, 3.22472385926, 9437.76293488700],
[0.00000000011, 3.80913404437, 801.82093112380],
[0.00000000010, 5.15032130575, 11371.70468975820],
[0.00000000013, 0.98720797401, 5729.50644714900],
[0.00000000009, 5.94191743597, 7632.94325965020],
], [
[0.00000000011, 0.23877262399, 7860.41939243920],
[0.00000000009, 1.16069982609, 5507.55323866740],
[0.00000000008, 1.65357552925, 5884.92684658320],
[0.00000000008, 2.86720038197, 7058.59846131540],
[0.00000000007, 3.04818741666, 5486.77784317500],
[0.00000000007, 2.59437103785, 529.69096509460],
[0.00000000008, 4.02863090524, 6256.77753019160],
[0.00000000008, 2.42003508927, 5753.38488489680],
[0.00000000006, 0.84181087594, 6275.96230299060],
[0.00000000006, 5.40160929468, 1577.34354244780],
[0.00000000007, 2.73399865247, 6309.37416979120],
], [
[0.00000000004, 0.79662198849, 6438.49624942560],
[0.00000000005, 0.84308705203, 1047.74731175470],
[0.00000000005, 0.05711572303, 84334.66158130829],
[0.00000000003, 3.46779895686, 6279.55273164240],
[0.00000000003, 2.89822201212, 6127.65545055720],
]],
('Earth', 'R'):[[
[1.00013988799, 0.00000000000, 0.00000000000],
[0.01670699626, 3.09846350771, 6283.07584999140],
[0.00013956023, 3.05524609620, 12566.15169998280],
[0.00003083720, 5.19846674381, 77713.77146812050],
[0.00001628461, 1.17387749012, 5753.38488489680],
[0.00001575568, 2.84685245825, 7860.41939243920],
[0.00000924799, 5.45292234084, 11506.76976979360],
[0.00000542444, 4.56409149777, 3930.20969621960],
[0.00000472110, 3.66100022149, 5884.92684658320],
[0.00000328780, 5.89983646482, 5223.69391980220],
[0.00000345983, 0.96368617687, 5507.55323866740],
[0.00000306784, 0.29867139512, 5573.14280143310],
[0.00000174844, 3.01193636534, 18849.22754997420],
[0.00000243189, 4.27349536153, 11790.62908865880],
[0.00000211829, 5.84714540314, 1577.34354244780],
[0.00000185752, 5.02194447178, 10977.07880469900],
[0.00000109835, 5.05510636285, 5486.77784317500],
[0.00000098316, 0.88681311277, 6069.77675455340],
[0.00000086499, 5.68959778254, 15720.83878487840],
[0.00000085825, 1.27083733351, 161000.68573767410],
[0.00000062916, 0.92177108832, 529.69096509460],
[0.00000057056, 2.01374292014, 83996.84731811189],
[0.00000064903, 0.27250613787, 17260.15465469040],
[0.00000049384, 3.24501240359, 2544.31441988340],
[0.00000055736, 5.24159798933, 71430.69561812909],
[0.00000042515, 6.01110242003, 6275.96230299060],
[0.00000046963, 2.57805070386, 775.52261132400],
[0.00000038968, 5.36071738169, 4694.00295470760],
[0.00000044661, 5.53715807302, 9437.76293488700],
[0.00000035660, 1.67468058995, 12036.46073488820],
[0.00000031921, 0.18368229781, 5088.62883976680],
[0.00000031846, 1.77775642085, 398.14900340820],
[0.00000033193, 0.24370300098, 7084.89678111520],
[0.00000038245, 2.39255343974, 8827.39026987480],
[0.00000028464, 1.21344868176, 6286.59896834040],
[0.00000037490, 0.82952922332, 19651.04848109800],
[0.00000036957, 4.90107591914, 12139.55350910680],
[0.00000034537, 1.84270693282, 2942.46342329160],
[0.00000026275, 4.58896850401, 10447.38783960440],
[0.00000024596, 3.78660875483, 8429.24126646660],
[0.00000023587, 0.26866117066, 796.29800681640],
[0.00000027793, 1.89934330904, 6279.55273164240],
[0.00000023927, 4.99598548138, 5856.47765911540],
[0.00000020349, 4.65267995431, 2146.16541647520],
[0.00000023287, 2.80783650928, 14143.49524243060],
[0.00000022103, 1.95004702988, 3154.68708489560],
[0.00000019506, 5.38227371393, 2352.86615377180],
[0.00000017958, 0.19871379385, 6812.76681508600],
[0.00000017174, 4.43315560735, 10213.28554621100],
[0.00000016190, 5.23160507859, 17789.84561978500],
[0.00000017314, 6.15200787916, 16730.46368959580],
[0.00000013814, 5.18962074032, 8031.09226305840],
[0.00000018833, 0.67306674027, 149854.40013480789],
[0.00000018331, 2.25348733734, 23581.25817731760],
[0.00000013641, 3.68516118804, 4705.73230754360],
[0.00000013139, 0.65289581324, 13367.97263110660],
[0.00000010414, 4.33285688538, 11769.85369316640],
[0.00000009978, 4.20126336355, 6309.37416979120],
[0.00000010169, 1.59390681369, 4690.47983635860],
[0.00000007564, 2.62560597390, 6256.77753019160],
[0.00000009661, 3.67586791220, 27511.46787353720],
[0.00000006743, 0.56270332741, 3340.61242669980],
[0.00000008743, 6.06359123461, 1748.01641306700],
[0.00000007786, 3.67371235637, 12168.00269657460],
[0.00000006633, 5.66149277792, 11371.70468975820],
[0.00000007712, 0.31242577789, 7632.94325965020],
[0.00000006592, 3.13576266188, 801.82093112380],
[0.00000007460, 5.64757188143, 11926.25441366880],
[0.00000006933, 2.92384586400, 6681.22485339960],
[0.00000006802, 1.42329806420, 23013.53953958720],
[0.00000006115, 5.13393615454, 1194.44701022460],
[0.00000006477, 2.64986648492, 19804.82729158280],
[0.00000005233, 4.62434053374, 6438.49624942560],
[0.00000006147, 3.02863936662, 233141.31440436149],
[0.00000004608, 1.72194702724, 7234.79425624200],
[0.00000004221, 1.55697533729, 7238.67559160000],
[0.00000005314, 2.40716580847, 11499.65622279280],
[0.00000005128, 5.32398965690, 11513.88331679440],
[0.00000004770, 0.25554312006, 11856.21865142450],
[0.00000005519, 2.09089154502, 17298.18232732620],
[0.00000005625, 4.34052903053, 90955.55169449610],
[0.00000004578, 4.46569641570, 5746.27133789600],
[0.00000003788, 4.90729383510, 4164.31198961300],
[0.00000005337, 5.09957905104, 31441.67756975680],
[0.00000003967, 1.20054555174, 1349.86740965880],
[0.00000004008, 3.03007204392, 1059.38193018920],
[0.00000003476, 0.76080277030, 10973.55568635000],
[0.00000004232, 1.05485713117, 5760.49843189760],
[0.00000004582, 3.76570026763, 6386.16862421000],
[0.00000003335, 3.13829943354, 6836.64525283380],
[0.00000003418, 3.00072390334, 4292.33083295040],
[0.00000003598, 5.70718084323, 5643.17856367740],
[0.00000003237, 4.16448773994, 9917.69687450980],
[0.00000004154, 2.59941292162, 7058.59846131540],
[0.00000003362, 4.54577697964, 4732.03062734340],
[0.00000002978, 1.30561268820, 6283.14316029419],
[0.00000002765, 0.51311975679, 26.29831979980],
[0.00000002802, 5.66263240521, 8635.94200376320],
[0.00000002927, 5.73787481548, 16200.77272450120],
[0.00000003164, 1.69140262657, 11015.10647733480],
[0.00000002598, 2.96244118586, 25132.30339996560],
[0.00000003519, 3.62639325753, 244287.60000722769],
[0.00000002676, 4.20725700850, 18073.70493865020],
[0.00000002978, 1.74971565805, 6283.00853968860],
[0.00000002287, 1.06975704977, 14314.16811304980],
[0.00000002863, 5.92838131397, 14712.31711645800],
[0.00000003071, 0.23793217002, 35371.88726597640],
[0.00000002656, 0.89959301780, 12352.85260454480],
[0.00000002415, 2.79975176257, 709.93304855830],
[0.00000002814, 3.51488206882, 21228.39202354580],
[0.00000001977, 2.61358297550, 951.71840625060],
[0.00000002548, 2.47684686575, 6208.29425142410],
[0.00000001999, 0.56090388160, 7079.37385680780],
[0.00000002305, 1.05376461628, 22483.84857449259],
[0.00000001855, 2.86090681163, 5216.58037280140],
[0.00000002157, 1.31396741861, 154717.60988768269],
[0.00000001970, 4.36929875289, 167283.76158766549],
[0.00000001635, 5.85571606764, 10984.19235169980],
[0.00000001754, 2.14452408833, 6290.18939699220],
[0.00000002154, 6.03828341543, 10873.98603048040],
[0.00000001714, 3.70157691113, 1592.59601363280],
[0.00000001541, 6.21598380732, 23543.23050468179],
[0.00000001611, 1.99824499377, 10969.96525769820],
[0.00000001712, 1.34295663542, 3128.38876509580],
[0.00000001642, 5.55026665339, 6496.37494542940],
[0.00000001502, 5.43948825854, 155.42039943420],
[0.00000001827, 5.91227480261, 3738.76143010800],
[0.00000001726, 2.16764983583, 10575.40668294180],
[0.00000001532, 5.35683107070, 13521.75144159140],
[0.00000001829, 1.66006148731, 39302.09696219600],
[0.00000001605, 1.90928637633, 6133.51265285680],
[0.00000001282, 2.46014880418, 13916.01910964160],
[0.00000001211, 4.41360631550, 3894.18182954220],
[0.00000001394, 1.77801929354, 9225.53927328300],
[0.00000001571, 4.95512957592, 25158.60171976540],
[0.00000001205, 1.19212540615, 3.52311834900],
[0.00000001132, 2.69830084955, 6040.34724601740],
[0.00000001504, 5.77002730341, 18209.33026366019],
[0.00000001393, 1.62621805428, 5120.60114558360],
[0.00000001077, 2.93931554233, 17256.63153634140],
[0.00000001232, 0.71655165307, 143571.32428481648],
[0.00000001087, 0.99769687939, 955.59974160860],
[0.00000001068, 5.28472576231, 65147.61976813770],
[0.00000000980, 5.10949204607, 6172.86952877200],
[0.00000001169, 3.11664290862, 14945.31617355440],
[0.00000001202, 4.02992510402, 553.56940284240],
[0.00000000979, 2.00000879212, 15110.46611986620],
[0.00000000962, 4.02380771400, 6282.09552892320],
[0.00000000999, 3.62643002790, 6262.30045449900],
[0.00000001030, 5.84989900289, 213.29909543800],
[0.00000001014, 2.84221578218, 8662.24032356300],
[0.00000001185, 1.51330541132, 17654.78053974960],
[0.00000000967, 2.67081017562, 5650.29211067820],
[0.00000001222, 2.65423784904, 88860.05707098669],
[0.00000000981, 2.36370360283, 6206.80977871580],
[0.00000001033, 0.13874927606, 11712.95531823080],
[0.00000001103, 3.08477302937, 43232.30665841560],
[0.00000000781, 2.53372735932, 16496.36139620240],
[0.00000001019, 3.04569392376, 6037.24420376200],
[0.00000000795, 5.80662989111, 5230.80746680300],
[0.00000000813, 3.57710279439, 10177.25767953360],
[0.00000000962, 5.31470594766, 6284.05617105960],
[0.00000000721, 5.96264301567, 12559.03815298200],
[0.00000000966, 2.74714939953, 6244.94281435360],
[0.00000000921, 0.10155275926, 29088.81141598500],
[0.00000000692, 3.89764447548, 1589.07289528380],
[0.00000000719, 5.91791450402, 4136.91043351620],
[0.00000000772, 4.05505682353, 6127.65545055720],
[0.00000000712, 5.49291532439, 22003.91463486980],
[0.00000000672, 1.60700490811, 11087.28512591840],
[0.00000000690, 4.50539825563, 426.59819087600],
[0.00000000854, 3.26104981596, 20426.57109242200],
[0.00000000656, 4.32410182940, 16858.48253293320],
[0.00000000840, 2.59572585222, 28766.92442448400],
[0.00000000692, 0.61650089011, 11403.67699557500],
[0.00000000700, 3.40901167143, 7.11354700080],
[0.00000000726, 0.04243053594, 5481.25491886760],
[0.00000000557, 4.78317696534, 20199.09495963300],
[0.00000000649, 1.04027912958, 6062.66320755260],
[0.00000000633, 5.70229959167, 45892.73043315699],
[0.00000000592, 6.11836729658, 9623.68827669120],
[0.00000000523, 3.62840021266, 5333.90024102160],
[0.00000000604, 5.57734696185, 10344.29506538580],
[0.00000000496, 2.21023499449, 1990.74501704100],
[0.00000000691, 1.96071732602, 12416.58850284820],
[0.00000000640, 1.59074172032, 18319.53658487960],
[0.00000000625, 3.82362791378, 13517.87010623340],
[0.00000000663, 5.08444996779, 283.85931886520],
[0.00000000475, 1.17025894287, 12569.67481833180],
[0.00000000664, 4.50029469969, 47162.51635463520],
[0.00000000569, 0.16310365162, 17267.26820169119],
[0.00000000568, 3.86100969474, 6076.89030155420],
[0.00000000539, 4.83282276086, 18422.62935909819],
[0.00000000466, 0.75872342878, 7342.45778018060],
[0.00000000541, 3.07212190507, 226858.23855437008],
[0.00000000458, 0.26774483096, 4590.91018048900],
[0.00000000610, 1.53597051291, 33019.02111220460],
[0.00000000617, 2.62356328726, 11190.37790013700],
[0.00000000548, 4.55798855791, 18875.52586977400],
[0.00000000633, 4.60110281228, 66567.48586525429],
[0.00000000596, 5.78202396722, 632.78373931320],
[0.00000000533, 5.01786882904, 12132.43996210600],
[0.00000000603, 5.38458554802, 316428.22867391503],
[0.00000000469, 0.59168241917, 21954.15760939799],
[0.00000000548, 3.50613163558, 17253.04110768959],
[0.00000000502, 0.98804327589, 11609.86254401220],
[0.00000000568, 1.98497313089, 7668.63742494250],
[0.00000000482, 1.62141803864, 12146.66705610760],
[0.00000000391, 3.68718382989, 18052.92954315780],
[0.00000000457, 3.77205737340, 156137.47598479928],
[0.00000000401, 5.28260651958, 15671.08175940660],
[0.00000000469, 1.80963184268, 12562.62858163380],
[0.00000000508, 3.36399024699, 20597.24396304120],
[0.00000000450, 5.66054299250, 10454.50138660520],
[0.00000000375, 4.98534633105, 9779.10867612540],
[0.00000000523, 0.97215560834, 155427.54293624099],
[0.00000000403, 5.13939866506, 1551.04522264800],
[0.00000000372, 3.69883738807, 9388.00590941520],
[0.00000000367, 4.43875659716, 4535.05943692440],
[0.00000000406, 4.20863156600, 12592.45001978260],
[0.00000000360, 2.53924644657, 242.72860397400],
[0.00000000471, 4.61907324819, 5436.99301524020],
[0.00000000441, 5.83872966262, 3496.03282613400],
[0.00000000385, 4.94496680973, 24356.78078864160],
[0.00000000349, 6.15018231784, 19800.94595622480],
[0.00000000355, 0.21895678106, 5429.87946823940],
[0.00000000344, 5.62993724928, 2379.16447357160],
[0.00000000380, 2.72105213143, 11933.36796066960],
[0.00000000432, 0.24221790536, 17996.03116822220],
[0.00000000378, 5.22517556974, 7477.52286021600],
[0.00000000337, 5.10888041439, 5849.36411211460],
[0.00000000315, 0.57827745123, 10557.59416082380],
[0.00000000318, 4.49953141399, 3634.62102451840],
[0.00000000323, 1.54274281393, 10440.27429260360],
[0.00000000309, 5.76839284397, 20.77539549240],
[0.00000000301, 2.34727604008, 4686.88940770680],
[0.00000000414, 5.93237602310, 51092.72605085480],
[0.00000000361, 2.16398609550, 28237.23345938940],
[0.00000000288, 0.18376252189, 13095.84266507740],
[0.00000000277, 5.12952205045, 13119.72110282519],
[0.00000000327, 6.19222146204, 6268.84875598980],
[0.00000000273, 0.30522428863, 23141.55838292460],
[0.00000000267, 5.76152585786, 5966.68398033480],
[0.00000000308, 5.99280509979, 22805.73556599360],
[0.00000000345, 2.92489919444, 36949.23080842420],
[0.00000000253, 5.20995219509, 24072.92146977640],
[0.00000000342, 5.72702586209, 16460.33352952499],
[0.00000000261, 2.00304796059, 6148.01076995600],
[0.00000000238, 5.08264392839, 6915.85958930460],
[0.00000000249, 2.94762789744, 135.06508003540],
[0.00000000306, 3.89764686987, 10988.80815753500],
[0.00000000305, 0.05827812117, 4701.11650170840],
[0.00000000319, 2.95712862064, 163096.18036118349],
[0.00000000209, 4.43768461442, 6546.15977336420],
[0.00000000270, 2.06643178717, 4804.20927592700],
[0.00000000217, 0.73691592312, 6303.85124548380],
[0.00000000206, 0.32075959415, 25934.12433108940],
[0.00000000218, 0.18428135264, 28286.99048486120],
[0.00000000205, 5.21312087405, 20995.39296644940],
[0.00000000199, 0.44384292491, 16737.57723659660],
[0.00000000230, 6.06567392849, 6287.00800325450],
[0.00000000219, 1.29194216300, 5326.78669402080],
[0.00000000201, 1.74700937253, 22743.40937951640],
[0.00000000207, 4.45440927276, 6279.48542133960],
[0.00000000269, 6.05640445030, 64471.99124174489],
[0.00000000190, 0.99256176518, 29296.61538957860],
[0.00000000238, 5.42471431221, 39609.65458316560],
[0.00000000262, 5.26961924198, 522.57741809380],
[0.00000000210, 4.68618183158, 6254.62666252360],
[0.00000000197, 2.80624554080, 4933.20844033260],
[0.00000000252, 4.36220154608, 40879.44050464380],
[0.00000000261, 1.07241516738, 55022.93574707440],
[0.00000000189, 3.82966734476, 419.48464387520],
[0.00000000185, 4.14324541379, 5642.19824260920],
[0.00000000247, 3.44855612987, 6702.56049386660],
[0.00000000205, 4.04424043223, 536.80451209540],
[0.00000000191, 3.14082686083, 16723.35014259500],
[0.00000000222, 5.16263907319, 23539.70738633280],
[0.00000000180, 4.56214752149, 6489.26139842860],
[0.00000000219, 0.80382553358, 16627.37091537720],
[0.00000000227, 0.60156339452, 5905.70224207560],
[0.00000000168, 0.88753528161, 16062.18452611680],
[0.00000000158, 0.92127725775, 23937.85638974100],
[0.00000000157, 4.69607868164, 6805.65326808520],
[0.00000000207, 4.88410451334, 6286.66627864320],
[0.00000000160, 4.95943826846, 10021.83728009940],
[0.00000000166, 0.97126433565, 3097.88382272579],
[0.00000000209, 5.75663411805, 3646.35037735440],
[0.00000000175, 6.12762824412, 239424.39025435288],
[0.00000000173, 3.13887234973, 6179.98307577280],
[0.00000000157, 3.62822058179, 18451.07854656599],
[0.00000000157, 4.67695912235, 6709.67404086740],
[0.00000000146, 3.09506069735, 4907.30205014560],
[0.00000000165, 2.27139128760, 10660.68693504240],
[0.00000000201, 1.67701267433, 2107.03450754240],
[0.00000000144, 3.96947747592, 6019.99192661860],
[0.00000000171, 5.91302216729, 6058.73105428950],
[0.00000000144, 2.13155655120, 26084.02180621620],
[0.00000000151, 0.67417383554, 2388.89402044920],
[0.00000000189, 5.07122281033, 263.08392337280],
[0.00000000146, 5.10373877968, 10770.89325626180],
[0.00000000187, 1.23915444627, 19402.79695281660],
[0.00000000174, 0.08407293391, 9380.95967271720],
[0.00000000137, 1.26247412309, 12566.21901028560],
[0.00000000137, 3.52826010842, 639.89728631400],
[0.00000000148, 1.76124372592, 5888.44996493220],
[0.00000000164, 2.39195095081, 6357.85744855870],
[0.00000000146, 2.43675816553, 5881.40372823420],
[0.00000000161, 1.15721259372, 26735.94526221320],
[0.00000000131, 2.51859277344, 6599.46771964800],
[0.00000000153, 5.85203687779, 6281.59137728310],
[0.00000000151, 3.72338532649, 12669.24447420140],
[0.00000000132, 2.38417741883, 6525.80445396540],
[0.00000000129, 0.75556744143, 5017.50837136500],
[0.00000000127, 0.00254936441, 10027.90319572920],
[0.00000000148, 2.85102145528, 6418.14093002680],
[0.00000000143, 5.74460279367, 26087.90314157420],
[0.00000000172, 0.41289962240, 174242.46596404970],
[0.00000000136, 4.15497742275, 6311.52503745920],
[0.00000000170, 5.98194913129, 327574.51427678125],
[0.00000000124, 1.65497607604, 32217.20018108080],
[0.00000000136, 2.48430783417, 13341.67431130680],
[0.00000000165, 2.49667924600, 58953.14544329400],
[0.00000000123, 3.45660563754, 6277.55292568400],
[0.00000000117, 0.86065134175, 6245.04817735560],
[0.00000000149, 5.61358280963, 5729.50644714900],
[0.00000000153, 0.26860029950, 245.83164622940],
[0.00000000128, 0.71204006588, 103.09277421860],
[0.00000000159, 2.43166592149, 221995.02880149524],
[0.00000000130, 2.80707316718, 6016.46880826960],
[0.00000000137, 1.70657709294, 12566.08438968000],
[0.00000000111, 1.56305648432, 17782.73207278420],
[0.00000000113, 3.58302904101, 25685.87280280800],
[0.00000000109, 3.26403795962, 6819.88036208680],
[0.00000000122, 0.34120688217, 1162.47470440780],
[0.00000000119, 5.84644718278, 12721.57209941700],
[0.00000000144, 2.28899679126, 12489.88562870720],
[0.00000000137, 5.82029768354, 44809.65020086340],
[0.00000000107, 2.42818544140, 5547.19933645960],
[0.00000000134, 1.26539982939, 5331.35744374080],
[0.00000000103, 5.96518130595, 6321.10352262720],
[0.00000000109, 0.33808549034, 11300.58422135640],
[0.00000000129, 5.89187277327, 12029.34718788740],
[0.00000000122, 5.77325634636, 11919.14086666800],
[0.00000000107, 6.24998989350, 77690.75950573849],
[0.00000000107, 1.00535580713, 77736.78343050249],
[0.00000000143, 0.24122178432, 4214.06901508480],
[0.00000000143, 0.88529649733, 7576.56007357400],
[0.00000000107, 2.92124030496, 31415.37924995700],
[0.00000000099, 5.70862227072, 5540.08578945880],
[0.00000000110, 0.37528037383, 5863.59120611620],
[0.00000000104, 4.44107178366, 2118.76386037840],
[0.00000000098, 5.95877916706, 4061.21921539440],
[0.00000000113, 1.24206857385, 84672.47584450469],
[0.00000000124, 2.55619029867, 12539.85338018300],
[0.00000000110, 3.66952094329, 238004.52415723629],
[0.00000000112, 4.32512422943, 97238.62754448749],
[0.00000000097, 3.70151541181, 11720.06886523160],
[0.00000000120, 1.26895630252, 12043.57428188900],
[0.00000000094, 2.56461130309, 19004.64794940840],
[0.00000000117, 3.65425622684, 34520.30930938080],
[0.00000000098, 0.13589994287, 11080.17157891760],
[0.00000000097, 5.38330115253, 7834.12107263940],
[0.00000000097, 2.46722096722, 71980.63357473118],
[0.00000000095, 5.36958330451, 6288.59877429880],
[0.00000000111, 5.01961920313, 11823.16163945020],
[0.00000000090, 2.72299804525, 26880.31981303260],
[0.00000000099, 0.90164266377, 18635.92845453620],
[0.00000000126, 4.78722177847, 305281.94307104882],
[0.00000000093, 0.21240380046, 18139.29450141590],
[0.00000000124, 5.00979495566, 172146.97134054029],
[0.00000000099, 5.67090026475, 16522.65971600220],
[0.00000000092, 2.28180963676, 12491.37010141550],
[0.00000000090, 4.50544881196, 40077.61957352000],
[0.00000000100, 2.00639461612, 12323.42309600880],
[0.00000000095, 5.68801979087, 14919.01785375460],
[0.00000000087, 1.86043406047, 27707.54249429480],
[0.00000000105, 3.02903468417, 22345.26037610820],
[0.00000000087, 5.43970168638, 6272.03014972750],
[0.00000000089, 1.63389387182, 33326.57873317420],
[0.00000000082, 5.58298993353, 10241.20229116720],
[0.00000000094, 5.47749711149, 9924.81042151060],
[0.00000000082, 4.71988314145, 15141.39079431200],
[0.00000000097, 5.61458778738, 2787.04302385740],
[0.00000000096, 3.89073946348, 6379.05507720920],
[0.00000000081, 3.13038482444, 36147.40987730040],
[0.00000000110, 4.89978492291, 72140.62866668739],
[0.00000000097, 5.20764563059, 6303.43116939020],
[0.00000000082, 5.26342716139, 9814.60410029120],
[0.00000000109, 2.35555589770, 83286.91426955358],
[0.00000000097, 2.58492958057, 30666.15495843280],
[0.00000000093, 1.32651591333, 23020.65308658799],
[0.00000000078, 3.99588630754, 11293.47067435560],
[0.00000000090, 0.57771932738, 26482.17080962440],
[0.00000000106, 3.92012705073, 62883.35513951360],
[0.00000000098, 2.94397773524, 316.39186965660],
[0.00000000076, 3.96310417608, 29026.48522950779],
[0.00000000078, 1.97068529306, 90279.92316810328],
[0.00000000076, 0.23027966596, 21424.46664430340],
[0.00000000080, 2.23099742212, 266.60704172180],
[0.00000000079, 1.46227790922, 8982.81066930900],
[0.00000000102, 4.92129953565, 5621.84292321040],
[0.00000000100, 0.39243148321, 24279.10701821359],
[0.00000000071, 1.52014858474, 33794.54372352860],
[0.00000000076, 0.22880641443, 57375.80190084620],
[0.00000000091, 0.96515913904, 48739.85989708300],
[0.00000000075, 2.77638585157, 12964.30070339100],
[0.00000000077, 5.18846946344, 11520.99686379520],
[0.00000000068, 0.50006599129, 4274.51831083240],
[0.00000000075, 2.07323762803, 15664.03552270859],
[0.00000000074, 1.01884134928, 6393.28217121080],
[0.00000000077, 0.46665178780, 16207.88627150200],
[0.00000000081, 4.10452219483, 161710.61878623239],
[0.00000000067, 3.83840630887, 6262.72053059260],
[0.00000000071, 3.91415523291, 7875.67186362420],
[0.00000000081, 0.91938383237, 74.78159856730],
[0.00000000083, 4.69916218791, 23006.42599258639],
[0.00000000063, 2.32556465878, 6279.19451463340],
[0.00000000065, 5.41938745446, 28628.33622609960],
[0.00000000065, 3.02336771694, 5959.57043333400],
[0.00000000064, 3.31033198370, 2636.72547263700],
[0.00000000064, 0.18375587519, 1066.49547719000],
[0.00000000080, 5.81239171612, 12341.80690428090],
[0.00000000066, 2.15105504851, 38.02767263580],
[0.00000000062, 2.43313614978, 10138.10951694860],
[0.00000000060, 3.16153906470, 5490.30096152400],
[0.00000000069, 0.30764736334, 7018.95236352320],
[0.00000000068, 2.24442548639, 24383.07910844140],
[0.00000000078, 1.39649386463, 9411.46461508720],
[0.00000000063, 0.72976362625, 6286.95718534940],
[0.00000000073, 4.95125917731, 6453.74872061060],
[0.00000000078, 0.32736023459, 6528.90749622080],
[0.00000000059, 4.95362151577, 35707.71008290740],
[0.00000000070, 2.37962727525, 15508.61512327440],
[0.00000000073, 1.35229143111, 5327.47610838280],
[0.00000000072, 5.91833527334, 10881.09957748120],
[0.00000000059, 5.36231868425, 10239.58386601080],
[0.00000000059, 1.63156134967, 61306.01159706580],
[0.00000000054, 4.29491690425, 21947.11137270000],
[0.00000000057, 5.89190132575, 34513.26307268280],
[0.00000000074, 1.38235845304, 9967.45389998160],
[0.00000000053, 3.86543309344, 32370.97899156560],
[0.00000000055, 4.51794544854, 34911.41207609100],
[0.00000000063, 5.41479412056, 11502.83761653050],
[0.00000000063, 2.34416220742, 11510.70192305670],
[0.00000000068, 0.77493931112, 29864.33402730900],
[0.00000000060, 5.57024703495, 5756.90800324580],
[0.00000000072, 2.80863088166, 10866.87248347960],
[0.00000000061, 2.69736991384, 82576.98122099529],
[0.00000000063, 5.32068807257, 3116.65941225980],
[0.00000000052, 1.02278758099, 6272.43918464160],
[0.00000000069, 5.00698550308, 25287.72379939980],
[0.00000000066, 6.12047940728, 12074.48840752400],
[0.00000000051, 2.59519527563, 11396.56344857420],
[0.00000000056, 2.57995973521, 17892.93839400359],
[0.00000000059, 0.44167237620, 250570.67585721909],
[0.00000000059, 3.84070143543, 5483.25472482600],
[0.00000000049, 0.54704693048, 22594.05489571199],
[0.00000000065, 2.38423614501, 52670.06959330260],
[0.00000000069, 5.34363738671, 66813.56483573320],
[0.00000000057, 5.42770501007, 310145.15282392364],
[0.00000000053, 1.17760296075, 149.56319713460],
[0.00000000061, 4.02090887211, 34596.36465465240],
[0.00000000049, 4.18361320516, 18606.49894600020],
[0.00000000055, 0.83886167974, 20452.86941222180],
[0.00000000050, 1.46327331958, 37455.72649597440],
[0.00000000048, 4.53854727167, 29822.78323632420],
[0.00000000058, 3.34847975377, 33990.61834428620],
[0.00000000065, 1.45522693982, 76251.32777062019],
[0.00000000056, 2.35650663692, 37724.75341974820],
[0.00000000052, 2.61551081496, 5999.21653112620],
[0.00000000053, 0.17334326094, 77717.29458646949],
[0.00000000053, 0.79879700631, 77710.24834977149],
[0.00000000047, 0.43240779709, 735.87651353180],
[0.00000000053, 4.58763261686, 11616.97609101300],
[0.00000000048, 6.20230111054, 4171.42553661380],
[0.00000000052, 1.09723616404, 640.87760738220],
[0.00000000057, 3.42008310383, 50317.20343953080],
[0.00000000053, 1.01528448581, 149144.46708624958],
[0.00000000047, 3.00924906195, 52175.80628314840],
[0.00000000052, 2.03254070404, 6293.71251534120],
[0.00000000048, 0.12356889734, 13362.44970679920],
[0.00000000045, 3.37963782356, 10763.77970926100],
[0.00000000047, 5.50981287869, 12779.45079542080],
[0.00000000062, 5.45209070099, 949.17560896980],
[0.00000000061, 2.93237974631, 5791.41255753260],
[0.00000000044, 2.87440620802, 8584.66166590080],
[0.00000000046, 4.03141796560, 10667.80048204320],
[0.00000000047, 3.89902931422, 3903.91137641980],
[0.00000000046, 2.75700467329, 6993.00889854970],
[0.00000000045, 1.93386293300, 206.18554843720],
[0.00000000047, 2.57670800912, 11492.54267579200],
[0.00000000044, 3.62570223167, 63658.87775083760],
[0.00000000051, 0.84536826273, 12345.73905754400],
[0.00000000043, 0.01524970172, 37853.87549938260],
[0.00000000041, 3.27146326065, 8858.31494432060],
[0.00000000045, 3.03765521215, 65236.22129328540],
[0.00000000047, 1.44447548944, 21393.54196985760],
[0.00000000058, 5.45843180927, 1975.49254585600],
[0.00000000050, 2.13285524146, 12573.26524698360],
[0.00000000041, 1.32190847146, 2547.83753823240],
[0.00000000047, 3.67579608544, 28313.28880466100],
[0.00000000041, 2.24013475126, 8273.82086703240],
[0.00000000047, 6.21438985953, 10991.30589870060],
[0.00000000042, 3.01631817350, 853.19638175200],
[0.00000000056, 1.09773690181, 77376.20102240759],
[0.00000000040, 2.35698541041, 2699.73481931760],
[0.00000000043, 5.28030898459, 17796.95916678580],
[0.00000000054, 2.59175932091, 22910.44676536859],
[0.00000000054, 0.88027764102, 71960.38658322369],
[0.00000000055, 0.07988899477, 83467.15635301729],
[0.00000000039, 1.12867321442, 9910.58332750900],
[0.00000000040, 1.35670430524, 27177.85152920020],
[0.00000000039, 4.39624220245, 5618.31980486140],
[0.00000000042, 4.78798367468, 7856.89627409019],
[0.00000000047, 2.75482175292, 18202.21671665939],
[0.00000000039, 1.97008298629, 24491.42579258340],
[0.00000000042, 4.04346599946, 7863.94251078820],
[0.00000000038, 0.49178679251, 38650.17350619900],
[0.00000000036, 4.86047906533, 4157.19844261220],
[0.00000000043, 5.64354880978, 1062.90504853820],
[0.00000000036, 3.98066313627, 12565.17137891460],
[0.00000000042, 2.30753932657, 6549.68289171320],
[0.00000000040, 5.39694918320, 9498.21223063460],
[0.00000000040, 3.30603243754, 23536.11695768099],
[0.00000000050, 6.15760345261, 78051.34191383338],
], [
[0.00103018608, 1.10748969588, 6283.07584999140],
[0.00001721238, 1.06442301418, 12566.15169998280],
[0.00000702215, 3.14159265359, 0.00000000000],
[0.00000032346, 1.02169059149, 18849.22754997420],
[0.00000030799, 2.84353804832, 5507.55323866740],
[0.00000024971, 1.31906709482, 5223.69391980220],
[0.00000018485, 1.42429748614, 1577.34354244780],
[0.00000010078, 5.91378194648, 10977.07880469900],
[0.00000008634, 0.27146150602, 5486.77784317500],
[0.00000008654, 1.42046854427, 6275.96230299060],
[0.00000005069, 1.68613426734, 5088.62883976680],
[0.00000004985, 6.01401770704, 6286.59896834040],
[0.00000004669, 5.98724494073, 529.69096509460],
[0.00000004395, 0.51800238019, 4694.00295470760],
[0.00000003872, 4.74969833437, 2544.31441988340],
[0.00000003750, 5.07097685568, 796.29800681640],
[0.00000004100, 1.08424786092, 9437.76293488700],
[0.00000003518, 0.02290216272, 83996.84731811189],
[0.00000003436, 0.94937019624, 71430.69561812909],
[0.00000003221, 6.15628775313, 2146.16541647520],
[0.00000003414, 5.41218322538, 775.52261132400],
[0.00000002863, 5.48432847146, 10447.38783960440],
[0.00000002520, 0.24276941146, 398.14900340820],
[0.00000002201, 4.95216196651, 6812.76681508600],
[0.00000002186, 0.41991743105, 8031.09226305840],
[0.00000002838, 3.42034351366, 2352.86615377180],
[0.00000002554, 6.13241878525, 6438.49624942560],
[0.00000001932, 5.31374608366, 8429.24126646660],
[0.00000002429, 3.09164528262, 4690.47983635860],
[0.00000001730, 1.53686208550, 4705.73230754360],
[0.00000002250, 3.68863633842, 7084.89678111520],
[0.00000002093, 1.28191783032, 1748.01641306700],
[0.00000001441, 0.81656250862, 14143.49524243060],
[0.00000001483, 3.22225357771, 7234.79425624200],
[0.00000001754, 3.22883705112, 6279.55273164240],
[0.00000001583, 4.09702349428, 11499.65622279280],
[0.00000001575, 5.53890170575, 3154.68708489560],
[0.00000001847, 1.82040335363, 7632.94325965020],
[0.00000001504, 3.63293385726, 11513.88331679440],
[0.00000001337, 4.64440864339, 6836.64525283380],
[0.00000001275, 2.69341415363, 1349.86740965880],
[0.00000001352, 6.15101580257, 5746.27133789600],
[0.00000001125, 3.35673439497, 17789.84561978500],
[0.00000001470, 3.65282991755, 1194.44701022460],
[0.00000001177, 2.57676109092, 13367.97263110660],
[0.00000001101, 4.49748696552, 4292.33083295040],
[0.00000001234, 5.65036509521, 5760.49843189760],
[0.00000000984, 0.65517395136, 5856.47765911540],
[0.00000000928, 2.32420318751, 10213.28554621100],
[0.00000001077, 5.82812169132, 12036.46073488820],
[0.00000000916, 0.76613009583, 16730.46368959580],
[0.00000000877, 1.50137505051, 11926.25441366880],
[0.00000001023, 5.62076589825, 6256.77753019160],
[0.00000000851, 0.65709335533, 155.42039943420],
[0.00000000802, 4.10519132088, 951.71840625060],
[0.00000000857, 1.41661697538, 5753.38488489680],
[0.00000000994, 1.14418521187, 1059.38193018920],
[0.00000000813, 1.63948433322, 6681.22485339960],
[0.00000000662, 4.55200452260, 5216.58037280140],
[0.00000000644, 4.19478168733, 6040.34724601740],
[0.00000000626, 1.50767713598, 5643.17856367740],
[0.00000000590, 6.18277145205, 4164.31198961300],
[0.00000000635, 0.52413263542, 6290.18939699220],
[0.00000000650, 0.97935690350, 25132.30339996560],
[0.00000000568, 2.30125315873, 10973.55568635000],
[0.00000000547, 5.27256412213, 3340.61242669980],
[0.00000000547, 2.20144422886, 1592.59601363280],
[0.00000000526, 0.92464258226, 11371.70468975820],
[0.00000000490, 5.90951388655, 3894.18182954220],
[0.00000000478, 1.66857963179, 12168.00269657460],
[0.00000000516, 3.59803483887, 10969.96525769820],
[0.00000000518, 3.97914412373, 17298.18232732620],
[0.00000000534, 5.03740926442, 9917.69687450980],
[0.00000000487, 2.50545369269, 6127.65545055720],
[0.00000000416, 4.04828175503, 10984.19235169980],
[0.00000000538, 5.54081539805, 553.56940284240],
[0.00000000402, 2.16544019233, 7860.41939243920],
[0.00000000553, 2.32177369366, 11506.76976979360],
[0.00000000367, 3.39152532250, 6496.37494542940],
[0.00000000360, 5.34379853282, 7079.37385680780],
[0.00000000337, 3.61563704045, 11790.62908865880],
[0.00000000456, 0.30754294809, 801.82093112380],
[0.00000000417, 3.70009308674, 10575.40668294180],
[0.00000000381, 5.82033971802, 7058.59846131540],
[0.00000000321, 0.31988767355, 16200.77272450120],
[0.00000000364, 1.08414306177, 6309.37416979120],
[0.00000000294, 4.54798604957, 11856.21865142450],
[0.00000000290, 1.26473978562, 8635.94200376320],
[0.00000000399, 4.16998866302, 26.29831979980],
[0.00000000262, 5.08316906342, 10177.25767953360],
[0.00000000243, 2.25746091190, 11712.95531823080],
[0.00000000237, 1.05070575346, 242.72860397400],
[0.00000000275, 3.45319481756, 5884.92684658320],
[0.00000000255, 5.38496831087, 21228.39202354580],
[0.00000000307, 4.24313526604, 3738.76143010800],
[0.00000000216, 3.46037894728, 213.29909543800],
[0.00000000196, 0.69029243914, 1990.74501704100],
[0.00000000198, 5.16301829964, 12352.85260454480],
[0.00000000214, 3.91876200279, 13916.01910964160],
[0.00000000212, 4.00861198517, 5230.80746680300],
[0.00000000184, 5.59805976614, 6283.14316029419],
[0.00000000184, 2.85275392124, 7238.67559160000],
[0.00000000179, 2.54259058334, 14314.16811304980],
[0.00000000225, 1.64458698399, 4732.03062734340],
[0.00000000236, 5.58826125715, 6069.77675455340],
[0.00000000187, 2.72805985443, 6062.66320755260],
[0.00000000184, 6.04216273598, 6283.00853968860],
[0.00000000230, 3.62591335086, 6284.05617105960],
[0.00000000163, 2.19117396803, 18073.70493865020],
[0.00000000172, 0.97612950740, 3930.20969621960],
[0.00000000215, 1.04672844028, 3496.03282613400],
[0.00000000169, 4.75084479006, 17267.26820169119],
[0.00000000152, 0.19390712179, 9779.10867612540],
[0.00000000182, 5.16288118255, 17253.04110768959],
[0.00000000149, 0.80944184260, 709.93304855830],
[0.00000000163, 2.19209570390, 6076.89030155420],
[0.00000000186, 5.01159497089, 11015.10647733480],
[0.00000000134, 0.97765485759, 65147.61976813770],
[0.00000000141, 4.38421981312, 4136.91043351620],
[0.00000000158, 4.60974280627, 9623.68827669120],
[0.00000000133, 3.30508592837, 154717.60988768269],
[0.00000000163, 6.11782626245, 3.52311834900],
[0.00000000174, 1.58078542187, 7.11354700080],
[0.00000000141, 0.49976927274, 25158.60171976540],
[0.00000000124, 6.03440460031, 9225.53927328300],
[0.00000000150, 5.30166336812, 13517.87010623340],
[0.00000000127, 1.92389511438, 22483.84857449259],
[0.00000000121, 2.37813129011, 167283.76158766549],
[0.00000000120, 3.98423684853, 4686.88940770680],
[0.00000000117, 5.81072642211, 12569.67481833180],
[0.00000000122, 5.60973054224, 5642.19824260920],
[0.00000000157, 3.40236426002, 16496.36139620240],
[0.00000000129, 2.10705116371, 1589.07289528380],
[0.00000000116, 0.55839966736, 5849.36411211460],
[0.00000000123, 1.52961392771, 12559.03815298200],
[0.00000000111, 0.44848279675, 6172.86952877200],
[0.00000000123, 5.81645568991, 6282.09552892320],
[0.00000000150, 4.26278409223, 3128.38876509580],
[0.00000000106, 2.27437761356, 5429.87946823940],
[0.00000000104, 4.42743707728, 23543.23050468179],
[0.00000000121, 0.39459045915, 12132.43996210600],
[0.00000000104, 2.41842602527, 426.59819087600],
[0.00000000110, 5.80381480447, 16858.48253293320],
[0.00000000100, 2.93805577485, 4535.05943692440],
[0.00000000097, 3.97935904984, 6133.51265285680],
[0.00000000110, 6.22339014386, 12146.66705610760],
[0.00000000098, 0.87576563709, 6525.80445396540],
[0.00000000098, 3.15248421301, 10440.27429260360],
[0.00000000095, 2.46168411100, 3097.88382272579],
[0.00000000088, 0.23371480284, 13119.72110282519],
[0.00000000098, 5.77016493489, 7342.45778018060],
[0.00000000092, 6.03915555063, 20426.57109242200],
[0.00000000096, 5.56909292561, 2388.89402044920],
[0.00000000081, 1.32131147691, 5650.29211067820],
[0.00000000086, 3.94529200528, 10454.50138660520],
[0.00000000076, 2.70729716925, 143571.32428481648],
[0.00000000091, 5.64100034152, 8827.39026987480],
[0.00000000076, 1.80783856698, 28286.99048486120],
[0.00000000081, 1.90858992196, 29088.81141598500],
[0.00000000075, 3.40955892978, 5481.25491886760],
[0.00000000069, 4.49936170873, 17256.63153634140],
[0.00000000088, 1.10098454357, 11769.85369316640],
[0.00000000066, 2.78285801977, 536.80451209540],
[0.00000000068, 3.88179770758, 17260.15465469040],
[0.00000000084, 1.59303306354, 9380.95967271720],
[0.00000000088, 3.88076636762, 7477.52286021600],
[0.00000000061, 6.17558202197, 11087.28512591840],
[0.00000000060, 4.34824715818, 6206.80977871580],
[0.00000000082, 4.59843208943, 9388.00590941520],
[0.00000000079, 1.63131230601, 4933.20844033260],
[0.00000000078, 4.20905757484, 5729.50644714900],
[0.00000000057, 5.48157926651, 18319.53658487960],
[0.00000000060, 1.01261781084, 12721.57209941700],
[0.00000000056, 1.63031935692, 15720.83878487840],
[0.00000000055, 0.24926735018, 15110.46611986620],
[0.00000000061, 5.93059279661, 12539.85338018300],
[0.00000000055, 4.84298966314, 13095.84266507740],
[0.00000000067, 6.11690589247, 8662.24032356300],
[0.00000000054, 5.73750638571, 3634.62102451840],
[0.00000000074, 1.05466745829, 16460.33352952499],
[0.00000000053, 2.29084335688, 16062.18452611680],
[0.00000000064, 2.13513767927, 7875.67186362420],
[0.00000000067, 0.07096807518, 14945.31617355440],
[0.00000000051, 2.31511194429, 6262.72053059260],
[0.00000000057, 5.77055471237, 12043.57428188900],
[0.00000000056, 4.41980790431, 4701.11650170840],
[0.00000000059, 5.87963500073, 5331.35744374080],
[0.00000000058, 2.30546168628, 955.59974160860],
[0.00000000049, 1.93839278478, 5333.90024102160],
[0.00000000048, 2.69973662261, 6709.67404086740],
[0.00000000064, 1.64379897981, 6262.30045449900],
[0.00000000046, 3.98449608961, 98068.53671630539],
[0.00000000050, 3.68875893005, 12323.42309600880],
[0.00000000045, 3.30068569697, 22003.91463486980],
[0.00000000047, 1.26317154881, 11919.14086666800],
[0.00000000045, 0.89150445122, 51868.24866217880],
[0.00000000043, 1.61526242998, 6277.55292568400],
[0.00000000043, 5.74295325645, 11403.67699557500],
[0.00000000044, 3.43070646822, 10021.83728009940],
[0.00000000056, 0.02481833774, 15671.08175940660],
[0.00000000055, 3.14274403422, 33019.02111220460],
[0.00000000045, 3.00877289177, 8982.81066930900],
[0.00000000046, 0.73303568429, 6303.43116939020],
[0.00000000049, 1.60455690285, 6303.85124548380],
[0.00000000045, 0.40210030323, 6805.65326808520],
[0.00000000053, 0.94869680175, 10988.80815753500],
[0.00000000041, 1.61122384329, 6819.88036208680],
[0.00000000055, 0.89439119424, 11933.36796066960],
[0.00000000045, 3.88495384656, 60530.48898574180],
[0.00000000040, 4.75740908001, 38526.57435087200],
[0.00000000040, 1.49921251887, 18451.07854656599],
[0.00000000040, 3.77498297228, 26087.90314157420],
[0.00000000051, 1.70258603562, 1551.04522264800],
[0.00000000039, 2.97100699926, 2118.76386037840],
[0.00000000053, 5.19854123078, 77713.77146812050],
[0.00000000047, 4.26356628717, 21424.46664430340],
[0.00000000037, 0.62902722802, 24356.78078864160],
[0.00000000036, 0.11087914947, 10344.29506538580],
[0.00000000036, 0.77037556319, 12029.34718788740],
[0.00000000035, 3.30933994515, 24072.92146977640],
[0.00000000035, 5.93650887012, 31570.79964939120],
[0.00000000036, 2.15108874765, 30774.50164257480],
[0.00000000036, 1.75078825382, 16207.88627150200],
[0.00000000033, 5.06264177921, 226858.23855437008],
[0.00000000034, 6.16891378800, 24491.42579258340],
[0.00000000035, 3.19120695549, 32217.20018108080],
[0.00000000034, 2.31528650443, 55798.45835839840],
[0.00000000032, 4.21446357042, 15664.03552270859],
[0.00000000039, 1.24979117796, 6418.14093002680],
[0.00000000037, 4.11943655770, 2787.04302385740],
[0.00000000032, 1.62887710890, 639.89728631400],
[0.00000000038, 5.89832942685, 640.87760738220],
[0.00000000032, 1.72442327688, 27433.88921587499],
[0.00000000031, 2.78828943753, 12139.55350910680],
[0.00000000035, 4.44608896525, 18202.21671665939],
[0.00000000034, 3.96287980676, 18216.44381066100],
[0.00000000033, 4.73611335874, 16723.35014259500],
[0.00000000034, 1.43910280005, 49515.38250840700],
[0.00000000031, 0.23302920161, 23581.25817731760],
[0.00000000029, 2.02633840220, 11609.86254401220],
[0.00000000030, 2.54923230240, 9924.81042151060],
[0.00000000032, 4.91793198558, 11300.58422135640],
[0.00000000028, 0.26187189577, 13521.75144159140],
[0.00000000028, 3.84568936822, 2699.73481931760],
[0.00000000029, 1.83149729794, 29822.78323632420],
[0.00000000033, 4.60320094415, 19004.64794940840],
[0.00000000027, 4.46183450287, 6702.56049386660],
[0.00000000030, 4.46494072240, 36147.40987730040],
[0.00000000027, 0.03211931363, 6279.78949257360],
[0.00000000026, 5.46497324333, 6245.04817735560],
[0.00000000035, 4.52695674113, 36949.23080842420],
[0.00000000027, 3.52528177609, 10770.89325626180],
[0.00000000026, 1.48499438453, 11080.17157891760],
[0.00000000035, 2.82154380962, 19402.79695281660],
[0.00000000025, 2.46339998836, 6279.48542133960],
[0.00000000026, 4.97688894643, 16737.57723659660],
[0.00000000026, 2.36136541526, 17996.03116822220],
[0.00000000029, 4.15148654061, 45892.73043315699],
[0.00000000026, 4.50714272714, 17796.95916678580],
[0.00000000027, 4.72625223674, 1066.49547719000],
[0.00000000025, 2.89309528854, 6286.66627864320],
[0.00000000027, 0.37462444357, 12964.30070339100],
[0.00000000029, 4.94860010533, 5863.59120611620],
[0.00000000031, 3.93096113577, 29864.33402730900],
[0.00000000024, 6.14987193584, 18606.49894600020],
[0.00000000024, 3.74225964547, 29026.48522950779],
[0.00000000025, 5.70460621565, 27707.54249429480],
[0.00000000025, 5.33928840652, 15141.39079431200],
[0.00000000027, 3.02320897140, 6286.36220740920],
[0.00000000023, 0.28364955406, 5327.47610838280],
[0.00000000026, 1.34240461687, 18875.52586977400],
[0.00000000024, 1.33998410121, 19800.94595622480],
[0.00000000025, 6.00172494004, 6489.26139842860],
[0.00000000022, 1.81777974484, 6288.59877429880],
[0.00000000022, 3.58603606640, 6915.85958930460],
[0.00000000029, 2.09564449439, 15265.88651930040],
[0.00000000022, 1.02173599251, 11925.27409260060],
[0.00000000022, 4.74660932338, 28230.18722269139],
[0.00000000021, 2.30688751432, 5999.21653112620],
[0.00000000021, 3.22654944430, 25934.12433108940],
[0.00000000021, 3.04956726238, 6566.93516885660],
[0.00000000027, 5.35653084499, 33794.54372352860],
[0.00000000028, 3.91168324815, 18208.34994259200],
[0.00000000020, 1.52296293311, 135.06508003540],
[0.00000000022, 4.66462839521, 13362.44970679920],
[0.00000000019, 1.78121167862, 156137.47598479928],
[0.00000000019, 2.99969102221, 19651.04848109800],
[0.00000000019, 2.86664273362, 18422.62935909819],
[0.00000000025, 0.94995632141, 31415.37924995700],
[0.00000000019, 4.71432851499, 77690.75950573849],
[0.00000000019, 2.54227398241, 77736.78343050249],
[0.00000000020, 5.91915117116, 48739.85989708300],
], [
[0.00004359385, 5.78455133738, 6283.07584999140],
[0.00000123633, 5.57934722157, 12566.15169998280],
[0.00000012341, 3.14159265359, 0.00000000000],
[0.00000008792, 3.62777733395, 77713.77146812050],
[0.00000005689, 1.86958905084, 5573.14280143310],
[0.00000003301, 5.47027913302, 18849.22754997420],
[0.00000001471, 4.48028885617, 5507.55323866740],
[0.00000001013, 2.81456417694, 5223.69391980220],
[0.00000000854, 3.10878241236, 1577.34354244780],
[0.00000001102, 2.84173992403, 161000.68573767410],
[0.00000000648, 5.47349498544, 775.52261132400],
[0.00000000609, 1.37969434104, 6438.49624942560],
[0.00000000499, 4.41649242250, 6286.59896834040],
[0.00000000417, 0.90242451175, 10977.07880469900],
[0.00000000402, 3.20376585290, 5088.62883976680],
[0.00000000351, 1.81079227770, 5486.77784317500],
[0.00000000467, 3.65753702738, 7084.89678111520],
[0.00000000458, 5.38585314743, 149854.40013480789],
[0.00000000304, 3.51701098693, 796.29800681640],
[0.00000000266, 6.17413982699, 6836.64525283380],
[0.00000000279, 1.84120501086, 4694.00295470760],
[0.00000000260, 1.41629543251, 2146.16541647520],
[0.00000000266, 3.13832905677, 71430.69561812909],
[0.00000000321, 5.35313367048, 3154.68708489560],
[0.00000000238, 2.17720020018, 155.42039943420],
[0.00000000293, 4.61501268144, 4690.47983635860],
[0.00000000229, 4.75969588070, 7234.79425624200],
[0.00000000211, 0.21868065485, 4705.73230754360],
[0.00000000201, 4.21905743357, 1349.86740965880],
[0.00000000195, 4.57808285364, 529.69096509460],
[0.00000000253, 2.81496293039, 1748.01641306700],
[0.00000000182, 5.70454011389, 6040.34724601740],
[0.00000000179, 6.02897097053, 4292.33083295040],
[0.00000000186, 1.58690991244, 6309.37416979120],
[0.00000000170, 2.90220009715, 9437.76293488700],
[0.00000000166, 1.99984925026, 8031.09226305840],
[0.00000000158, 0.04783713552, 2544.31441988340],
[0.00000000197, 2.01083639502, 1194.44701022460],
[0.00000000165, 5.78372596778, 83996.84731811189],
[0.00000000214, 3.38285934319, 7632.94325965020],
[0.00000000140, 0.36401486094, 10447.38783960440],
[0.00000000151, 0.95153163031, 6127.65545055720],
[0.00000000136, 1.48426306582, 2352.86615377180],
[0.00000000127, 5.48475435134, 951.71840625060],
[0.00000000126, 5.26866506592, 6279.55273164240],
[0.00000000125, 3.75754889288, 6812.76681508600],
[0.00000000101, 4.95015746147, 398.14900340820],
[0.00000000102, 0.68468295277, 1592.59601363280],
[0.00000000100, 1.14568935785, 3894.18182954220],
[0.00000000129, 0.76540016965, 553.56940284240],
[0.00000000109, 5.41063597567, 6256.77753019160],
[0.00000000075, 5.84804322893, 242.72860397400],
[0.00000000095, 1.94452244083, 11856.21865142450],
[0.00000000077, 0.69373708195, 8429.24126646660],
[0.00000000100, 5.19725292131, 244287.60000722769],
[0.00000000080, 6.18440483705, 1059.38193018920],
[0.00000000069, 5.25699888595, 14143.49524243060],
[0.00000000085, 5.39484725499, 25132.30339996560],
[0.00000000066, 0.51779993906, 801.82093112380],
[0.00000000055, 5.16878202461, 7058.59846131540],
[0.00000000051, 3.88759155247, 12036.46073488820],
[0.00000000050, 5.57636570536, 6290.18939699220],
[0.00000000061, 2.24359003264, 8635.94200376320],
[0.00000000050, 5.54441900966, 1990.74501704100],
[0.00000000056, 4.00301078040, 13367.97263110660],
[0.00000000052, 4.13138898038, 7860.41939243920],
[0.00000000052, 3.90943054011, 26.29831979980],
[0.00000000041, 3.57128482780, 7079.37385680780],
[0.00000000056, 2.76959005761, 90955.55169449610],
[0.00000000042, 1.91461189199, 7477.52286021600],
[0.00000000042, 0.42728171713, 10213.28554621100],
[0.00000000042, 1.09413724455, 709.93304855830],
[0.00000000039, 3.93298068961, 10973.55568635000],
[0.00000000038, 6.17935925345, 9917.69687450980],
[0.00000000049, 0.83021145241, 11506.76976979360],
[0.00000000053, 1.45828359397, 233141.31440436149],
[0.00000000047, 6.21568666789, 6681.22485339960],
[0.00000000037, 0.36359309980, 10177.25767953360],
[0.00000000035, 3.33024911524, 5643.17856367740],
[0.00000000034, 5.63446915337, 6525.80445396540],
[0.00000000035, 5.36033855038, 25158.60171976540],
[0.00000000034, 5.36319798321, 4933.20844033260],
[0.00000000033, 4.24722336872, 12569.67481833180],
[0.00000000043, 5.26370903404, 10575.40668294180],
[0.00000000042, 5.08837645072, 11015.10647733480],
[0.00000000040, 1.98334703186, 6284.05617105960],
[0.00000000042, 4.22496037505, 88860.05707098669],
[0.00000000029, 3.19088628170, 11926.25441366880],
[0.00000000029, 0.15217616684, 12168.00269657460],
[0.00000000030, 1.61904744136, 9779.10867612540],
[0.00000000027, 0.76388991416, 1589.07289528380],
[0.00000000036, 2.74712003443, 3738.76143010800],
[0.00000000033, 3.08807829566, 3930.20969621960],
[0.00000000031, 5.34906619513, 143571.32428481648],
[0.00000000025, 0.10240267494, 22483.84857449259],
[0.00000000030, 3.47110495524, 14945.31617355440],
[0.00000000024, 1.10425016019, 4535.05943692440],
[0.00000000024, 1.58037259780, 6496.37494542940],
[0.00000000023, 3.87710321433, 6275.96230299060],
[0.00000000025, 3.94529778970, 3128.38876509580],
[0.00000000023, 3.44685609601, 4136.91043351620],
[0.00000000023, 3.83156029849, 5753.38488489680],
[0.00000000022, 1.86956128067, 16730.46368959580],
[0.00000000025, 2.42188933855, 5729.50644714900],
[0.00000000020, 1.78208352927, 17789.84561978500],
[0.00000000021, 4.30363087400, 16858.48253293320],
[0.00000000021, 0.49258939822, 29088.81141598500],
[0.00000000025, 1.33030250444, 6282.09552892320],
[0.00000000027, 2.54785812264, 3496.03282613400],
[0.00000000022, 1.11232521950, 12721.57209941700],
[0.00000000021, 5.97759081637, 7.11354700080],
[0.00000000019, 0.80292033311, 16062.18452611680],
[0.00000000023, 4.12454848769, 2388.89402044920],
[0.00000000022, 4.92663152168, 18875.52586977400],
[0.00000000023, 5.68902059771, 16460.33352952499],
[0.00000000023, 4.97346265647, 17260.15465469040],
[0.00000000023, 3.03021283729, 66567.48586525429],
[0.00000000016, 3.89740925257, 5331.35744374080],
[0.00000000017, 3.08268671348, 154717.60988768269],
[0.00000000016, 3.95085099736, 3097.88382272579],
[0.00000000016, 3.99041783945, 6283.14316029419],
[0.00000000020, 6.10644140189, 167283.76158766549],
[0.00000000015, 4.09775914607, 11712.95531823080],
[0.00000000016, 5.71769940700, 17298.18232732620],
[0.00000000016, 3.28894009404, 5884.92684658320],
[0.00000000015, 5.64785377164, 12559.03815298200],
[0.00000000016, 4.43452080930, 6283.00853968860],
[0.00000000014, 2.31721603062, 5481.25491886760],
[0.00000000014, 4.43479032305, 13517.87010623340],
[0.00000000014, 4.73209312936, 7342.45778018060],
[0.00000000012, 0.64705975463, 18073.70493865020],
[0.00000000011, 1.51443332200, 16200.77272450120],
[0.00000000011, 0.88708889185, 21228.39202354580],
[0.00000000014, 4.50116508534, 640.87760738220],
[0.00000000011, 4.64339996198, 11790.62908865880],
[0.00000000011, 1.31064298246, 4164.31198961300],
[0.00000000009, 3.02238989305, 23543.23050468179],
[0.00000000009, 2.04999402381, 22003.91463486980],
[0.00000000009, 4.91488110218, 213.29909543800],
], [
[0.00000144595, 4.27319435148, 6283.07584999140],
[0.00000006729, 3.91697608662, 12566.15169998280],
[0.00000000774, 0.00000000000, 0.00000000000],
[0.00000000247, 3.73019298781, 18849.22754997420],
[0.00000000036, 2.80081409050, 6286.59896834040],
[0.00000000033, 5.62216602775, 6127.65545055720],
[0.00000000019, 3.71292621802, 6438.49624942560],
[0.00000000016, 4.26011484232, 6525.80445396540],
[0.00000000016, 3.50416887054, 6256.77753019160],
[0.00000000014, 3.62127621114, 25132.30339996560],
[0.00000000011, 4.39200958819, 4705.73230754360],
[0.00000000011, 5.22327127059, 6040.34724601740],
[0.00000000010, 4.28045254647, 83996.84731811189],
[0.00000000009, 1.56864096494, 5507.55323866740],
[0.00000000011, 1.37795688024, 6309.37416979120],
[0.00000000010, 5.19937959068, 71430.69561812909],
[0.00000000009, 0.47275199930, 6279.55273164240],
[0.00000000009, 0.74642756529, 5729.50644714900],
[0.00000000007, 2.97374891560, 775.52261132400],
[0.00000000007, 3.28615691021, 7058.59846131540],
[0.00000000007, 2.19184402142, 6812.76681508600],
[0.00000000005, 3.15419034438, 529.69096509460],
[0.00000000006, 4.54725567047, 1059.38193018920],
[0.00000000005, 1.51104406936, 7079.37385680780],
[0.00000000007, 2.98052059053, 6681.22485339960],
[0.00000000005, 2.30961231391, 12036.46073488820],
[0.00000000005, 3.71102966917, 6290.18939699220],
], [
[0.00000003858, 2.56384387339, 6283.07584999140],
[0.00000000306, 2.26769501230, 12566.15169998280],
[0.00000000053, 3.44031471924, 5573.14280143310],
[0.00000000015, 2.04794573436, 18849.22754997420],
[0.00000000013, 2.05688873673, 77713.77146812050],
[0.00000000007, 4.41218854480, 161000.68573767410],
[0.00000000005, 5.26154653107, 6438.49624942560],
[0.00000000005, 4.07695126049, 6127.65545055720],
[0.00000000006, 3.81514213664, 149854.40013480789],
[0.00000000003, 1.28175749811, 6286.59896834040],
], [
[0.00000000086, 1.21579741687, 6283.07584999140],
[0.00000000012, 0.65617264033, 12566.15169998280],
[0.00000000001, 0.38068797142, 18849.22754997420],
]],
('Mars', 'L'):[[
[6.20347711583, 0.00000000000, 0.00000000000],
[0.18656368100, 5.05037100303, 3340.61242669980],
[0.01108216792, 5.40099836958, 6681.22485339960],
[0.00091798394, 5.75478745111, 10021.83728009940],
[0.00027744987, 5.97049512942, 3.52311834900],
[0.00010610230, 2.93958524973, 2281.23049651060],
[0.00012315897, 0.84956081238, 2810.92146160520],
[0.00008926772, 4.15697845939, 0.01725365220],
[0.00008715688, 6.11005159792, 13362.44970679920],
[0.00006797552, 0.36462243626, 398.14900340820],
[0.00007774867, 3.33968655074, 5621.84292321040],
[0.00003575079, 1.66186540141, 2544.31441988340],
[0.00004161101, 0.22814975330, 2942.46342329160],
[0.00003075250, 0.85696597082, 191.44826611160],
[0.00002628122, 0.64806143570, 3337.08930835080],
[0.00002937543, 6.07893711408, 0.06731030280],
[0.00002389420, 5.03896401349, 796.29800681640],
[0.00002579842, 0.02996706197, 3344.13554504880],
[0.00001528140, 1.14979306228, 6151.53388830500],
[0.00001798808, 0.65634026844, 529.69096509460],
[0.00001264356, 3.62275092231, 5092.15195811580],
[0.00001286232, 3.06795924626, 2146.16541647520],
[0.00001546408, 2.91579633392, 1751.53953141600],
[0.00001024907, 3.69334293555, 8962.45534991020],
[0.00000891567, 0.18293899090, 16703.06213349900],
[0.00000858760, 2.40093704204, 2914.01423582380],
[0.00000832718, 2.46418591282, 3340.59517304760],
[0.00000832724, 4.49495753458, 3340.62968035200],
[0.00000712899, 3.66336014788, 1059.38193018920],
[0.00000748724, 3.82248399468, 155.42039943420],
[0.00000723863, 0.67497565801, 3738.76143010800],
[0.00000635557, 2.92182704275, 8432.76438481560],
[0.00000655163, 0.48864075176, 3127.31333126180],
[0.00000550472, 3.81001205408, 0.98032106820],
[0.00000552746, 4.47478863016, 1748.01641306700],
[0.00000425972, 0.55365138172, 6283.07584999140],
[0.00000415132, 0.49662314774, 213.29909543800],
[0.00000472164, 3.62547819410, 1194.44701022460],
[0.00000306552, 0.38052862973, 6684.74797174860],
[0.00000312141, 0.99853322843, 6677.70173505060],
[0.00000293199, 4.22131277914, 20.77539549240],
[0.00000302377, 4.48618150321, 3532.06069281140],
[0.00000274028, 0.54222141841, 3340.54511639700],
[0.00000281073, 5.88163372945, 1349.86740965880],
[0.00000231185, 1.28240685294, 3870.30339179440],
[0.00000283600, 5.76885494123, 3149.16416058820],
[0.00000236114, 5.75504515576, 3333.49887969900],
[0.00000274035, 0.13372501211, 3340.67973700260],
[0.00000299396, 2.78323705697, 6254.62666252360],
[0.00000204161, 2.82133266185, 1221.84856632140],
[0.00000238857, 5.37155471672, 4136.91043351620],
[0.00000188639, 1.49103016486, 9492.14631500480],
[0.00000221225, 3.50466672203, 382.89653222320],
[0.00000179196, 1.00561112574, 951.71840625060],
[0.00000172110, 0.43943041719, 5486.77784317500],
[0.00000193126, 3.35715137745, 3.59042865180],
[0.00000144305, 1.41874193418, 135.06508003540],
[0.00000160011, 3.94854735192, 4562.46099302120],
[0.00000174068, 2.41360332576, 553.56940284240],
[0.00000130993, 4.04491720264, 12303.06777661000],
[0.00000138245, 4.30145176915, 7.11354700080],
[0.00000128062, 1.80665643332, 5088.62883976680],
[0.00000139897, 3.32592516164, 2700.71514038580],
[0.00000128102, 2.20806651008, 1592.59601363280],
[0.00000116945, 3.12805282207, 7903.07341972100],
[0.00000110375, 1.05195079687, 242.72860397400],
[0.00000113486, 3.70070798123, 1589.07289528380],
[0.00000100090, 3.24343740861, 11773.37681151540],
[0.00000095592, 0.53954181149, 20043.67456019880],
[0.00000098947, 4.84558294740, 6681.24210705180],
[0.00000104541, 0.78535382076, 8827.39026987480],
[0.00000084187, 3.98970720730, 4399.99435688900],
[0.00000086931, 2.20186740523, 11243.68584642080],
[0.00000071437, 2.80307550016, 3185.19202726560],
[0.00000072091, 5.84672102525, 5884.92684658320],
[0.00000073476, 2.18428012567, 8429.24126646660],
[0.00000098946, 2.81481140371, 6681.20759974740],
[0.00000068414, 2.73834914412, 2288.34404351140],
[0.00000086751, 1.02092221563, 7079.37385680780],
[0.00000065320, 2.68118597578, 28.44918746780],
[0.00000083749, 3.20256130990, 4690.47983635860],
[0.00000075034, 0.76643418252, 6467.92575796160],
[0.00000068984, 3.76399731788, 6041.32756708560],
[0.00000066706, 0.73630620766, 3723.50895892300],
[0.00000063314, 4.52771470470, 426.59819087600],
[0.00000061683, 6.16831509419, 2274.11694950980],
[0.00000052256, 0.89941531307, 9623.68827669120],
[0.00000055488, 4.60625467020, 4292.33083295040],
[0.00000051332, 4.14823636534, 3341.59274776800],
[0.00000056629, 5.06250410206, 15.25247118500],
[0.00000063376, 0.91296240798, 3553.91152213780],
[0.00000045829, 0.78784235062, 1990.74501704100],
[0.00000048542, 3.95670418719, 4535.05943692440],
[0.00000041223, 6.02019329922, 3894.18182954220],
[0.00000041939, 3.58326425115, 8031.09226305840],
[0.00000056396, 1.68727150304, 6872.67311951120],
[0.00000055909, 3.46260833495, 263.08392337280],
[0.00000051678, 2.81307492682, 3339.63210563160],
[0.00000040671, 3.13832621829, 9595.23908922340],
[0.00000038107, 0.73401946320, 10025.36039844840],
[0.00000039495, 5.63225392160, 3097.88382272579],
[0.00000044174, 3.19529736702, 5628.95647021120],
[0.00000036716, 2.63720775102, 692.15760122680],
[0.00000045905, 0.28718981497, 5614.72937620960],
[0.00000038352, 5.82880707426, 3191.04922956520],
[0.00000038206, 2.34835984063, 162.46663613220],
[0.00000032562, 0.48400659333, 6681.29216370240],
[0.00000037135, 0.68508150774, 2818.03500860600],
[0.00000031168, 3.98160912982, 20.35531939880],
[0.00000032561, 0.89250316888, 6681.15754309680],
[0.00000037752, 4.15482955299, 2803.80791460440],
[0.00000033626, 6.11992401052, 6489.77658728800],
[0.00000029007, 2.42707385674, 3319.83703120740],
[0.00000038790, 1.35198498795, 10018.31416175040],
[0.00000033148, 1.14023770004, 5.52292430740],
[0.00000027584, 1.59691203058, 7210.91581849420],
[0.00000028686, 5.72055456734, 7477.52286021600],
[0.00000034031, 2.59544082509, 11769.85369316640],
[0.00000025380, 0.52093116112, 10.63666534980],
[0.00000026357, 1.34532646574, 3496.03282613400],
[0.00000024554, 4.00323183088, 11371.70468975820],
[0.00000025637, 0.24963523420, 522.57741809380],
[0.00000027278, 4.55645328122, 3361.38782219220],
[0.00000023764, 1.84058377256, 12832.75874170460],
[0.00000022816, 3.52628212106, 1648.44675719740],
[0.00000022274, 0.72106133721, 266.60704172180],
[0.00000021202, 3.11824472284, 2957.71589447660],
[0.00000020158, 3.67131504946, 1758.65307841680],
[0.00000021530, 6.15388757177, 3264.34635542420],
[0.00000020093, 1.08247416065, 7064.12138562280],
[0.00000021343, 4.28218757863, 4032.77002792660],
[0.00000027540, 6.08389942337, 6674.11130639880],
[0.00000019849, 2.37668920745, 10713.99488132620],
[0.00000025512, 3.43242352804, 3443.70520091840],
[0.00000022542, 5.64861703438, 2388.89402044920],
[0.00000024378, 0.96994696413, 632.78373931320],
[0.00000023079, 4.74990214223, 3347.72597370060],
[0.00000017709, 3.69742343974, 3344.20285535160],
[0.00000022662, 3.95446324417, 4989.05918389720],
[0.00000022604, 5.24082917494, 3205.54734666440],
[0.00000016811, 5.48619684111, 3.88133535800],
[0.00000018422, 4.22535881468, 2787.04302385740],
[0.00000022737, 4.98520896596, 7632.94325965020],
[0.00000016648, 2.52823633184, 14584.29827312060],
[0.00000020963, 4.27878216453, 5099.26550511660],
[0.00000016042, 1.76786752521, 3475.67750673520],
[0.00000015816, 3.13240869691, 59.37386191360],
[0.00000018113, 3.25756020453, 3337.02199804800],
[0.00000019295, 3.23911854642, 7.04623669800],
[0.00000016772, 4.39731507110, 15643.68020330980],
[0.00000017555, 4.09197396097, 74.78159856730],
[0.00000013704, 2.54117018160, 4933.20844033260],
[0.00000016011, 1.54669633224, 14054.60730802600],
[0.00000013547, 4.04152185347, 4929.68532198360],
[0.00000014566, 3.45210993051, 7373.38245462640],
[0.00000013926, 5.40797129468, 10973.55568635000],
[0.00000014246, 0.59808746067, 23.87843774780],
[0.00000014023, 1.44218648988, 10404.73381232260],
[0.00000016051, 3.79409950488, 2118.76386037840],
[0.00000013714, 3.59050634457, 15113.98923821520],
[0.00000018038, 4.25391532000, 2487.41604494780],
[0.00000015846, 0.56901288692, 103.09277421860],
[0.00000013403, 5.16920432994, 10213.28554621100],
[0.00000016069, 2.36895958451, 3265.83082813250],
[0.00000012773, 0.10483085657, 7234.79425624200],
[0.00000012199, 1.73079687044, 36.02786667740],
[0.00000012283, 5.19940030635, 10021.85453375160],
[0.00000011945, 5.47997890162, 2921.12778282460],
[0.00000011890, 4.76593905835, 5828.02847164760],
[0.00000012283, 3.16862882612, 10021.82002644720],
[0.00000013274, 6.17806905340, 1744.42598441520],
[0.00000011777, 5.72731550900, 0.42007609361],
[0.00000012340, 2.52146766331, 2906.90068882300],
[0.00000014458, 4.38010658432, 316.39186965660],
[0.00000010639, 3.45016942919, 639.89728631400],
[0.00000010925, 0.60397688999, 5085.03841111500],
[0.00000010645, 5.47696728127, 419.48464387520],
[0.00000010797, 1.37191539718, 10419.98628350760],
[0.00000010565, 1.09061610786, 12168.00269657460],
[0.00000009578, 4.89489266197, 3230.40610548040],
[0.00000009808, 5.83632873998, 14314.16811304980],
[0.00000009720, 6.28282606427, 9225.53927328300],
[0.00000009146, 1.10220667397, 9808.53818466140],
[0.00000012733, 1.79883375851, 13745.34623902240],
[0.00000009779, 3.60056884868, 206.18554843720],
[0.00000012156, 4.42295240981, 14712.31711645800],
[0.00000008801, 3.97218590685, 170.67287061920],
[0.00000010685, 4.33894776374, 7740.60678358880],
[0.00000010041, 1.38294666830, 3583.34103067380],
[0.00000008499, 4.29275471153, 0.42988312670],
[0.00000009882, 2.69148019691, 36.60536530420],
[0.00000010585, 0.89641284928, 23384.28698689860],
[0.00000008478, 2.86886131803, 9381.93999378540],
[0.00000009560, 4.33382353581, 131.54196168640],
[0.00000008433, 3.15239733970, 6525.80445396540],
[0.00000007517, 1.24476310635, 6894.52394883760],
[0.00000006753, 1.58869332894, 6836.64525283380],
[0.00000006666, 4.38910103043, 66.48740891440],
[0.00000006697, 5.77315870484, 5202.35827933520],
[0.00000006188, 1.57847967850, 3325.35995551480],
[0.00000008392, 2.90734956761, 43.71891230500],
[0.00000006427, 6.03333185624, 574.34479833480],
[0.00000006296, 0.06976040737, 1964.83862685400],
[0.00000006144, 5.43713363624, 1861.74585263540],
[0.00000008180, 0.43967386003, 2707.82868738660],
[0.00000006532, 1.24907069366, 12964.30070339100],
[0.00000007341, 4.95693808975, 3767.21061757580],
[0.00000006134, 3.16322441707, 6680.24453233140],
[0.00000005937, 4.22752447794, 4459.36821880260],
[0.00000005848, 4.30379700916, 7875.67186362420],
[0.00000005895, 0.77226207039, 2699.73481931760],
[0.00000005962, 3.01318151415, 3369.06161416760],
[0.00000006307, 1.77830983983, 2178.13772229200],
[0.00000006103, 4.49866000852, 6682.20517446780],
[0.00000005770, 0.96127853878, 13916.01910964160],
[0.00000005725, 4.93042706875, 2384.32327072920],
[0.00000007576, 6.16308742022, 6531.66165626500],
[0.00000007285, 0.52756973131, 10575.40668294180],
[0.00000005212, 3.48999909365, 12935.85151592320],
[0.00000005266, 4.51201042373, 6144.42034130420],
[0.00000006632, 3.48100908925, 1118.75579210280],
[0.00000005182, 3.25459432228, 2391.43681773000],
[0.00000005214, 0.01023839897, 533.21408344360],
[0.00000005436, 6.18510045571, 8425.65083781480],
[0.00000005491, 3.42235890731, 3134.42687826260],
[0.00000005773, 3.55190490896, 8969.56889691100],
[0.00000005093, 0.60873962999, 8955.34180290940],
[0.00000004798, 4.63144694279, 4569.57454002200],
[0.00000005773, 5.92316959013, 640.87760738220],
[0.00000005661, 0.75892958537, 3120.19978426100],
[0.00000004912, 1.70762118141, 13358.92658845020],
[0.00000005438, 4.29256867866, 3503.07906283200],
[0.00000004631, 3.34058594066, 3116.26763099790],
[0.00000005823, 2.39009621568, 3302.47939106200],
[0.00000005095, 1.12497131307, 5331.35744374080],
[0.00000004409, 1.38708732950, 17256.63153634140],
[0.00000004193, 0.19116539271, 9830.38901398780],
[0.00000004164, 0.43798301495, 1066.49547719000],
[0.00000004220, 1.69427060019, 13524.91634293140],
[0.00000005192, 3.63500646439, 536.80451209540],
[0.00000005664, 0.50446281443, 5305.45105355380],
[0.00000005264, 5.40031180025, 3355.86489788480],
[0.00000005403, 5.96867227489, 3074.00538497800],
[0.00000004046, 0.83826342101, 10021.90459040220],
[0.00000004153, 3.14497570817, 8439.87793181640],
[0.00000004820, 1.09025983917, 13365.97282514820],
[0.00000004906, 3.73078406569, 1228.96211332220],
[0.00000004576, 0.99344843456, 6158.64743530580],
[0.00000004211, 3.87091723842, 3312.16323923200],
[0.00000004917, 6.25051681717, 17654.78053974960],
[0.00000003597, 6.07298181151, 10818.13528691580],
[0.00000003547, 1.87663674277, 17395.21973472580],
[0.00000003734, 1.37011069213, 3973.39616601300],
[0.00000004422, 2.89974680697, 6247.51311552280],
[0.00000003975, 4.03441621102, 1052.26838318840],
[0.00000004466, 4.59188422424, 5518.75014899180],
[0.00000003445, 4.26610076208, 3178.14579056760],
[0.00000003607, 4.24527056399, 8329.67161059700],
[0.00000003511, 1.95133364438, 10177.25767953360],
[0.00000003300, 0.68865737747, 149.56319713460],
[0.00000003235, 3.90171358031, 27.40155609680],
[0.00000003946, 5.81982010903, 6261.74020952440],
[0.00000003387, 0.14377701728, 10014.72373309860],
[0.00000003374, 0.74722238154, 6048.44111408640],
[0.00000003090, 3.98540766861, 2648.45482547300],
[0.00000003821, 5.23987859516, 5724.93569742900],
[0.00000003026, 0.34314724795, 220.41264243880],
[0.00000004052, 1.24671617482, 10021.76996979660],
[0.00000002937, 0.73100893561, 2.75151061100],
[0.00000003084, 3.79925632319, 169.58018313300],
[0.00000004040, 2.91258200196, 22747.29071487440],
[0.00000003246, 4.90760526525, 6702.00024889200],
[0.00000003223, 0.92640008610, 16865.52876963120],
[0.00000002879, 1.47180601483, 3346.13535100720],
[0.00000003723, 0.49978317761, 1.48447270830],
[0.00000002798, 3.26910698548, 9168.64089834740],
[0.00000003347, 0.68791690253, 3863.18984479360],
[0.00000003440, 2.77706064625, 6660.44945790720],
[0.00000002798, 2.79673379094, 16858.48253293320],
[0.00000002753, 4.41190782119, 3415.39402526710],
[0.00000002703, 0.19222683184, 3237.51965248120],
[0.00000002719, 3.26628341377, 3914.95722503460],
[0.00000002941, 3.76169133143, 6784.31762761820],
[0.00000003078, 5.48104322207, 3335.08950239240],
[0.00000002701, 5.08537226206, 6688.33840040040],
[0.00000002606, 4.83032556909, 4672.66731424060],
[0.00000002883, 2.64068086362, 3320.25710730100],
[0.00000003089, 4.39619824300, 1332.05488754080],
[0.00000003438, 1.93467064449, 10551.52824519400],
[0.00000003433, 0.20933510815, 6604.95878212400],
[0.00000002513, 2.88151502604, 17924.91069982040],
[0.00000002683, 3.68680362407, 3603.69635007260],
[0.00000002696, 2.66931776730, 10184.30391623160],
[0.00000002386, 1.05710815775, 3607.21946842160],
[0.00000002444, 3.46901444423, 6298.32832117640],
[0.00000002566, 5.55941956468, 6546.15977336420],
[0.00000002354, 0.85896789940, 3351.24909204960],
[0.00000002304, 6.07210985790, 1214.73501932060],
[0.00000002387, 4.30419979225, 3360.96774609859],
[0.00000003109, 2.18099805904, 16173.37116840440],
[0.00000002907, 3.43894993113, 2693.60159338500],
[0.00000002550, 4.18354174372, 3546.79797513700],
[0.00000002991, 2.37500894603, 13517.87010623340],
[0.00000002508, 5.99249607455, 5729.50644714900],
[0.00000002202, 5.58486973955, 664.75604513000],
[0.00000002467, 2.81052575497, 15110.46611986620],
[0.00000002154, 3.59696831702, 6677.63442474780],
[0.00000002166, 3.35965682842, 589.06482700820],
[0.00000002112, 4.57048853017, 6127.65545055720],
[0.00000002178, 3.21663279493, 20199.09495963300],
[0.00000002260, 3.62776666288, 7799.98064550240],
[0.00000002703, 5.89441421026, 6438.49624942560],
[0.00000002201, 4.69972051344, 17277.40693183380],
[0.00000002131, 2.51801264340, 1545.35398297880],
[0.00000002093, 4.03688419630, 6684.81528205140],
[0.00000002249, 5.26171743929, 5618.31980486140],
[0.00000002117, 4.80404492675, 3657.00429635640],
[0.00000002265, 3.87401620754, 110.20632121940],
[0.00000002521, 4.21237950687, 2494.52959194860],
[0.00000002492, 6.10452779411, 3329.97576135000],
[0.00000002154, 4.59093274516, 5625.36604155940],
[0.00000001929, 1.21920197307, 21.85082932640],
[0.00000002343, 0.90613584736, 227.47613278900],
[0.00000001871, 2.03707390080, 56.89837493560],
[0.00000001894, 4.12432529517, 3399.98628861340],
[0.00000002271, 3.78951734652, 7910.18696672180],
[0.00000001876, 3.02034887080, 4885.96640967860],
[0.00000002145, 4.74972617629, 18984.29263000960],
[0.00000002035, 2.75110234296, 128.01884333740],
[0.00000001770, 2.73496011079, 6606.44325483230],
[0.00000001733, 1.70571779606, 6.68366387410],
[0.00000001743, 2.22986352012, 17085.95866572220],
[0.00000001723, 1.98207274526, 735.87651353180],
[0.00000001814, 0.92405242552, 4555.34744602040],
[0.00000001661, 3.07319305915, 1692.16566950240],
[0.00000002332, 5.05223613332, 20618.01935853360],
[0.00000001653, 3.86316179052, 699.27114822760],
[0.00000001890, 4.14080522607, 5459.37628707820],
[0.00000001680, 3.49750704538, 3347.65866339780],
[0.00000001909, 2.11478314309, 6816.28993343500],
[0.00000001918, 3.31232891649, 3333.56619000180],
[0.00000001707, 4.88386665097, 3407.09983561420],
[0.00000001577, 3.51777131580, 13362.43245314700],
[0.00000001827, 1.14937084769, 2807.39834325620],
[0.00000002094, 1.78938870686, 20597.24396304120],
[0.00000001577, 5.54854302324, 13362.46696045140],
[0.00000001677, 4.39073937265, 8270.29774868340],
[0.00000001561, 0.80246904730, 3017.10701004240],
[0.00000001552, 2.66876850182, 3024.22055704320],
[0.00000001708, 2.09721350898, 2814.44457995420],
[0.00000002109, 1.48733908496, 2679.37949991880],
[0.00000001547, 2.12956399169, 661.23292678100],
[0.00000001764, 5.90517079295, 3326.38533269820],
[0.00000001503, 4.34389183170, 13936.79450513400],
[0.00000001504, 0.83367652471, 4775.76008845920],
[0.00000001543, 5.82417982389, 3344.49376205780],
[0.00000001458, 1.42630589706, 15508.61512327440],
[0.00000001648, 2.88801518612, 8273.82086703240],
[0.00000001527, 1.10261249454, 2675.85638156980],
[0.00000001800, 5.17144672709, 38.13303563780],
[0.00000001439, 0.48751113425, 76.26607127560],
[0.00000001478, 4.63008666184, 19800.94595622480],
[0.00000001770, 2.18315009072, 2301.58581590939],
[0.00000001712, 2.60291779744, 29.42950853600],
[0.00000001416, 2.46912016889, 2597.62236616720],
[0.00000001835, 3.93223068469, 6843.69148953180],
[0.00000001437, 3.48241890037, 3281.23856478620],
[0.00000001385, 4.18004525683, 2284.75361485960],
[0.00000001479, 3.88994194685, 6034.21402008480],
[0.00000001469, 2.91808856545, 12722.55242048520],
[0.00000001824, 3.94139541752, 18454.60166491500],
[0.00000001368, 1.71899681607, 13760.59871020740],
[0.00000001406, 2.42916192473, 853.19638175200],
[0.00000001361, 4.69126219798, 11081.21921028860],
[0.00000001375, 4.90787845983, 3304.58456002240],
[0.00000001544, 3.23251603238, 156.40072050240],
[0.00000001543, 1.13497136095, 3336.73109134180],
[0.00000001385, 2.90281983822, 1581.95934828300],
[0.00000001311, 6.21748423079, 2547.83753823240],
[0.00000001377, 2.56537541792, 568.82187402740],
[0.00000001474, 4.65215247212, 394.62588505920],
[0.00000001619, 0.07481583409, 1435.14766175940],
[0.00000001369, 0.08979359617, 7895.95987272020],
[0.00000001272, 5.84659079053, 21.33564046700],
[0.00000001331, 3.80007277718, 13119.72110282519],
[0.00000001202, 5.90681878458, 187.92514776260],
[0.00000001284, 5.30205682052, 6571.01853218020],
[0.00000001468, 5.91503888421, 3339.12795399150],
[0.00000001497, 2.57629850836, 151.89728108520],
[0.00000001270, 4.08996241400, 4356.27544458400],
[0.00000001159, 0.00546309207, 799.82112516540],
[0.00000001154, 1.81024985603, 158.94351778320],
[0.00000001170, 4.15567553953, 14.22709400160],
[0.00000001349, 0.39391022745, 2540.79130153440],
[0.00000001403, 4.89956428847, 4039.88357492740],
[0.00000001188, 3.46422365287, 1015.66301788420],
[0.00000001136, 5.54132891775, 13553.89797291080],
[0.00000001282, 4.52288421340, 3929.67725370800],
[0.00000001124, 1.40102701439, 13149.15061136120],
[0.00000001254, 3.84775964741, 3980.50971301380],
[0.00000001121, 5.04552583589, 23141.55838292460],
[0.00000001088, 0.89388884633, 3340.19235060619],
[0.00000001476, 4.20852908107, 16460.33352952499],
[0.00000001084, 5.70551481838, 3760.09707057500],
[0.00000001197, 1.24543578245, 26724.89941359840],
[0.00000001253, 5.82286965998, 3344.54457996290],
[0.00000001078, 6.24742453183, 17.81252211800],
[0.00000001462, 2.27467510211, 369.69981594040],
[0.00000001044, 4.34158344243, 2277.70737816160],
[0.00000001099, 4.08747611117, 802.36392244620],
[0.00000001122, 4.31726854418, 107.66352393860],
[0.00000001148, 0.42666214138, 949.17560896980],
[0.00000001183, 0.31560034120, 1162.47470440780],
[0.00000001130, 3.46061330657, 5732.04924442980],
[0.00000001059, 1.34075999078, 2149.68853482420],
[0.00000001126, 5.22902222299, 194.97138446060],
[0.00000000977, 3.44426658417, 9779.10867612540],
[0.00000001134, 0.13507173479, 12566.15169998280],
[0.00000001185, 3.65682936623, 6456.88005769770],
[0.00000000962, 4.85370284827, 3510.19260983280],
[0.00000001033, 2.47380728164, 31.97230581680],
[0.00000001172, 1.72927931309, 6923.95345737360],
[0.00000000986, 1.05152205629, 16335.83780453660],
[0.00000001292, 6.02388659607, 3316.73398895200],
[0.00000000932, 1.56812178735, 111.18664228760],
[0.00000001130, 2.06879370733, 3376.64029337720],
[0.00000000924, 0.82106390115, 3364.49086444760],
[0.00000001005, 5.48594935121, 11236.57229942000],
[0.00000000936, 1.58837554752, 10235.13637553740],
[0.00000001063, 1.93321644244, 87.30820453981],
[0.00000000945, 5.10393817688, 8013.27974094040],
[0.00000000957, 4.41421752360, 433.71173787680],
[0.00000000921, 1.71021166461, 2067.93140107260],
[0.00000000910, 1.91562889347, 401.67212175720],
[0.00000000931, 4.61327789373, 5415.65737477320],
[0.00000001033, 3.98512631089, 10596.18207843420],
[0.00000000908, 5.30549216988, 7107.82304427560],
[0.00000000945, 0.21610469082, 9872.27408296480],
[0.00000000991, 2.76931703924, 5938.23479286700],
[0.00000000918, 4.37217510741, 1854.63230563460],
[0.00000000889, 1.81025662091, 2409.24933984800],
[0.00000001058, 3.63303046818, 7255.56965173440],
[0.00000000860, 2.78826625605, 5621.86017686260],
[0.00000000860, 0.75749461239, 5621.82566955820],
[0.00000000850, 3.82228424021, 272.67295735160],
[0.00000000851, 0.25287875945, 11766.26326451460],
[0.00000000853, 1.84243320985, 2142.64229812620],
[0.00000001030, 0.42255009123, 1596.18644228460],
[0.00000000826, 1.26069501589, 20206.14119633100],
[0.00000000835, 4.64394754967, 127.95153303460],
[0.00000001046, 3.50232998647, 9866.41688066520],
[0.00000000824, 2.42928138519, 11.04570026390],
[0.00000001090, 6.06536924506, 3341.03250279340],
[0.00000000808, 1.17345081945, 6460.81221096080],
[0.00000000821, 0.19617131185, 22743.40937951640],
[0.00000000804, 5.03144428114, 2.54279728080],
[0.00000001074, 2.80025232939, 3077.52850332700],
[0.00000000794, 4.57067003887, 5223.69391980220],
[0.00000000822, 0.90150471199, 8646.06348025360],
[0.00000000884, 1.71007411939, 3.93215326310],
[0.00000000850, 1.24977903471, 12295.95422960920],
[0.00000000926, 3.02847055739, 3377.21779200400],
[0.00000000779, 1.97930055918, 5408.54382777240],
[0.00000000960, 6.16414205869, 8542.97070603500],
[0.00000000785, 4.63077378309, 3341.04230982650],
[0.00000000752, 3.51125131831, 10020.85695903120],
[0.00000000749, 2.50286751020, 2295.45759051220],
[0.00000000801, 4.54004277501, 1039.02661079040],
[0.00000000735, 3.91703254169, 12310.18132361080],
[0.00000000784, 3.24368310213, 3384.33133900480],
[0.00000000719, 3.35536995801, 11780.49035851620],
[0.00000000940, 3.58974561600, 23539.70738633280],
[0.00000000865, 1.12444569157, 206.70073729660],
[0.00000000731, 5.61232905415, 16062.18452611680],
[0.00000000823, 2.65316808033, 3169.93955608060],
[0.00000000903, 4.86743346013, 931.36308685180],
[0.00000000705, 1.46305394620, 792.77488846740],
[0.00000000754, 2.89691411536, 3296.89351439480],
[0.00000000736, 2.21038016464, 146.81168652360],
[0.00000000785, 2.32844966721, 3340.18254357310],
[0.00000000685, 2.34948834397, 1.18064265210],
[0.00000000677, 4.33803507050, 3877.41693879520],
[0.00000000729, 3.56726385957, 485.97205278960],
[0.00000000668, 5.16798891078, 12721.57209941700],
[0.00000000713, 4.80558699772, 4142.97634914600],
[0.00000000842, 1.59708732155, 16304.91313009080],
[0.00000000698, 1.91829605833, 6665.97238221460],
[0.00000000698, 4.64681188157, 11216.28429032400],
[0.00000000684, 3.88514563357, 846.08283475120],
[0.00000000666, 2.23927960017, 20735.83216142559],
[0.00000000638, 2.05380863176, 16699.53901514999],
[0.00000000726, 5.04566216294, 3329.56672643590],
[0.00000000697, 0.30680314664, 19676.45023123640],
[0.00000000650, 3.23944472757, 9588.12554222260],
[0.00000000736, 2.24443728739, 11250.79939342160],
[0.00000000692, 1.76465916332, 51.28033786241],
[0.00000000645, 0.07661067442, 52.26031491280],
[0.00000000685, 2.72118140264, 6643.09181776180],
[0.00000000684, 1.26157751115, 142.17862703620],
[0.00000000635, 3.85231847116, 6.06591562980],
[0.00000000819, 6.04967230806, 19402.79695281660],
[0.00000000664, 3.60223930010, 1903.43681250120],
[0.00000000613, 4.96450118774, 8859.36257569160],
[0.00000000615, 5.74467417840, 6696.47732458460],
[0.00000000622, 1.64154132852, 24150.08005134500],
[0.00000000659, 0.12506816965, 8116.37251515900],
[0.00000000679, 1.94943016061, 12995.22537783680],
[0.00000000616, 4.94607504516, 9485.03276800400],
[0.00000000793, 2.84922599989, 29.49181830340],
[0.00000000597, 5.72067567055, 3113.13629391080],
[0.00000000763, 0.42513533173, 3873.82651014340],
[0.00000000587, 1.31684217558, 9499.25986200560],
[0.00000000592, 4.34796024028, 3826.58447948940],
[0.00000000652, 5.53658742492, 9065.54812412880],
[0.00000000583, 0.59190068342, 26084.02180621620],
[0.00000000603, 0.77135566630, 3342.09689940810],
[0.00000000701, 3.35897774328, 6709.67404086740],
[0.00000000574, 1.08976979801, 6357.71943674220],
[0.00000000750, 4.84737198179, 10022.81760116760],
[0.00000000588, 5.65927128604, 2171.02417529120],
[0.00000000632, 3.84852695407, 16276.46394262300],
[0.00000000632, 1.43230388645, 16706.58525184800],
[0.00000000780, 1.15181502540, 377.37360791580],
[0.00000000554, 4.18192049239, 382.87927857100],
[0.00000000568, 0.03816333919, 6414.61781167780],
[0.00000000569, 2.57704345512, 35.56273446860],
[0.00000000566, 0.62804830762, 3189.56475685690],
[0.00000000687, 5.61456944029, 155.35308913140],
[0.00000000563, 2.57358138188, 19406.67828817460],
[0.00000000693, 1.15645091892, 966.97087743560],
[0.00000000576, 1.60357663736, 3192.53370227350],
[0.00000000621, 2.23214771591, 3274.12501778540],
[0.00000000586, 6.17266280012, 9602.35263622420],
[0.00000000541, 0.53968808391, 13171.00144068760],
[0.00000000570, 3.11852290115, 2221.85663459700],
[0.00000000542, 0.41889651002, 1641.33321019660],
[0.00000000532, 0.16606105669, 5511.63660199100],
[0.00000000530, 3.78205188174, 7270.28968040780],
[0.00000000575, 5.48929613719, 2075.04494807340],
[0.00000000670, 3.67090656417, 6475.03930496240],
[0.00000000509, 4.21526585284, 7380.49600162720],
[0.00000000510, 1.59587338243, 13362.38239649640],
[0.00000000494, 2.13711598060, 2604.73591316800],
[0.00000000534, 1.03109772656, 1478.86657406440],
[0.00000000506, 5.92145494356, 685.04405422600],
[0.00000000469, 0.83917541691, 3041.48603243060],
[0.00000000468, 1.97135671591, 2412.77245819700],
[0.00000000468, 4.57635781664, 11670.28403729680],
[0.00000000559, 1.47641018288, 8671.96987044060],
[0.00000000475, 2.07517976424, 5835.14201864840],
[0.00000000466, 2.92801596791, 2277.29834324750],
[0.00000000478, 6.13550464878, 4825.54491639400],
[0.00000000502, 0.77928275348, 4407.10790388980],
[0.00000000462, 3.80503324215, 11140.59307220220],
[0.00000000499, 3.25557381873, 1744.49329471800],
[0.00000000525, 0.74022979976, 1265.56747862640],
[0.00000000521, 6.27577138682, 3981.49003408200],
[0.00000000482, 0.14820337530, 14158.74771361560],
[0.00000000460, 2.03348517376, 25685.87280280800],
[0.00000000510, 4.27704405425, 3472.15438838620],
[0.00000000444, 1.95486223268, 3226.21331978640],
[0.00000000575, 0.59007504383, 2766.26762836500],
[0.00000000437, 5.63861950911, 8958.93223156120],
[0.00000000492, 6.10071747922, 2285.16264977370],
[0.00000000572, 5.10308842466, 8564.30634650200],
[0.00000000430, 4.12851356192, 13.24177239800],
[0.00000000544, 4.78254843814, 9380.95967271720],
[0.00000000430, 3.83861916944, 1765.76662541760],
[0.00000000499, 4.26055736809, 6652.77566593180],
[0.00000000541, 0.84245625839, 4981.94563689640],
[0.00000000591, 2.01874828234, 27490.69247804480],
[0.00000000438, 1.36437546581, 12509.25332504720],
[0.00000000470, 4.70961176845, 3723.49170527080],
[0.00000000421, 1.76100140625, 956.28915597060],
[0.00000000413, 0.49206034039, 13355.33615979840],
[0.00000000412, 0.29353415123, 2810.93871525740],
[0.00000000412, 3.24865417750, 18451.07854656599],
[0.00000000412, 1.70721395764, 7314.00859271280],
[0.00000000412, 4.54594776716, 2810.90420795300],
[0.00000000448, 3.04254429984, 5636.07001721200],
[0.00000000510, 1.18739936388, 13362.51701710200],
[0.00000000408, 1.32068176489, 20809.46762464520],
[0.00000000427, 1.16100742040, 19004.64794940840],
[0.00000000420, 3.49180180953, 1655.56030419820],
[0.00000000433, 0.55429134487, 9945.57120882380],
[0.00000000424, 4.60854671688, 6518.75821726740],
[0.00000000415, 5.67120343816, 99.56965586960],
[0.00000000476, 5.94537443289, 48835.19385644859],
[0.00000000405, 5.63206200287, 3450.81874791920],
[0.00000000495, 4.38317490235, 2480.30249794700],
[0.00000000415, 3.61905205961, 2089.78223039900],
[0.00000000395, 0.25208772249, 1375.77379984580],
[0.00000000421, 2.26337694295, 13892.14067189380],
[0.00000000391, 5.25566087245, 10042.61267559180],
[0.00000000504, 4.91016850189, 8965.97846825920],
[0.00000000417, 3.45088934666, 279.78650435240],
[0.00000000389, 0.98703891513, 7203.80227149340],
[0.00000000431, 2.11881719623, 56.80326216980],
[0.00000000497, 1.63121523594, 22345.26037610820],
[0.00000000377, 4.06263841184, 10124.93005431800],
[0.00000000377, 3.16019395941, 224.34479570190],
[0.00000000378, 5.82532048605, 6675.70192909220],
[0.00000000377, 0.05833226835, 905.45669666480],
[0.00000000445, 0.33560120738, 515.46387109300],
[0.00000000426, 2.66458973231, 4076.48894023160],
[0.00000000489, 0.75760372851, 3561.02506913860],
[0.00000000389, 0.50283826580, 2825.14855560680],
[0.00000000396, 5.14198726837, 5195.24473233440],
[0.00000000414, 3.12530321804, 10001.06188460700],
[0.00000000502, 5.02356488339, 73.29712585900],
[0.00000000432, 3.31538359140, 5617.91076994730],
[0.00000000359, 4.97622870666, 5820.91492464680],
[0.00000000359, 5.42072227300, 6019.99192661860],
[0.00000000449, 3.79544854612, 4996.17273089800],
[0.00000000374, 2.85563965649, 2111.65031337760],
[0.00000000426, 0.24129917209, 5625.77507647350],
[0.00000000423, 3.60507971235, 8226.57883637840],
[0.00000000402, 4.51813719510, 4392.88080988820],
[0.00000000391, 4.26714089799, 21795.21409161479],
[0.00000000447, 4.25776540974, 18052.92954315780],
[0.00000000355, 4.17584780659, 6740.59871531320],
[0.00000000353, 1.81574804066, 6686.74777770700],
[0.00000000462, 3.22304237134, 2011.10033643980],
[0.00000000341, 3.22071023668, 4253.18267036540],
[0.00000000475, 4.28822688035, 367.22432896240],
[0.00000000462, 2.91312544527, 418.92439890060],
[0.00000000416, 4.83203726375, 8535.85715903420],
[0.00000000431, 3.22440150226, 21265.52312652020],
[0.00000000333, 3.99300815003, 1353.39052800780],
[0.00000000340, 0.71636465254, 15664.03552270859],
[0.00000000416, 2.58443168474, 5753.38488489680],
[0.00000000356, 2.35639379021, 4.57074972000],
[0.00000000330, 4.04831945983, 3.10304225540],
[0.00000000381, 4.06283076724, 1062.90504853820],
[0.00000000431, 5.42246026973, 26482.17080962440],
[0.00000000328, 4.06276954550, 6944.30877677240],
[0.00000000334, 5.10221163477, 22324.90505670940],
[0.00000000400, 2.28211698182, 3209.07046501340],
[0.00000000420, 2.44159662565, 6155.05700665400],
[0.00000000375, 1.09229714548, 4246.06912336460],
[0.00000000449, 4.38183542571, 5106.37905211740],
[0.00000000330, 2.55172725319, 19513.98359510420],
[0.00000000319, 4.05704496382, 5430.39465709880],
[0.00000000310, 4.99907184482, 5095.67507646480],
[0.00000000344, 0.62691832180, 9389.05354078620],
[0.00000000319, 3.31673970253, 596.17837400900],
[0.00000000305, 4.66942910910, 6756.00645196690],
[0.00000000409, 6.07568936266, 50.83245930580],
[0.00000000377, 5.42211267415, 1190.92389187560],
[0.00000000342, 2.67821304845, 6148.01076995600],
[0.00000000298, 5.91093444215, 9886.77220006400],
[0.00000000299, 5.44077050156, 10028.95082710020],
[0.00000000315, 1.03304445564, 3490.17562383440],
[0.00000000369, 3.93279262125, 1879.55837475340],
[0.00000000304, 4.56372485787, 7483.58877584580],
[0.00000000330, 3.29725079066, 286.96236112060],
[0.00000000290, 3.43850024020, 6418.14093002680],
[0.00000000289, 2.82766045300, 3171.03224356680],
[0.00000000317, 4.13345374602, 1883.08149310240],
[0.00000000294, 0.01906732590, 202.25339517410],
[0.00000000310, 4.37565854379, 2796.69436760360],
[0.00000000364, 0.54935210242, 290.48547946960],
[0.00000000291, 2.39413982848, 29026.48522950779],
[0.00000000286, 5.76562894312, 5642.19824260920],
[0.00000000392, 3.01171327788, 10721.10842832700],
[0.00000000318, 4.93376925851, 1197.97012857360],
[0.00000000315, 2.84437840100, 10610.90210710760],
[0.00000000299, 1.18299169304, 550.04628449340],
[0.00000000336, 4.30769818760, 5989.06725217280],
[0.00000000315, 1.41407863340, 6947.83189512140],
[0.00000000294, 6.16453752963, 8982.81066930900],
[0.00000000285, 2.82644088669, 9654.61295113700],
[0.00000000281, 0.27739627997, 8166.15734309380],
[0.00000000279, 4.08648927643, 5355.23588148860],
[0.00000000330, 3.11968019451, 41.55079098480],
[0.00000000275, 5.89019272334, 3337.86091608880],
[0.00000000275, 4.00268079937, 3620.39893105220],
[0.00000000292, 3.06830662617, 4.36203638980],
[0.00000000317, 0.01919037405, 2267.00340250900],
[0.00000000272, 1.70373580224, 3742.28454845700],
[0.00000000294, 0.16019381973, 6670.58818804980],
[0.00000000264, 2.07967576148, 3735.23831175900],
[0.00000000262, 4.49437120405, 6887.41040183680],
[0.00000000307, 3.03375977801, 6660.86953400080],
[0.00000000280, 0.47728086796, 5401.43028077160],
[0.00000000268, 0.46331887242, 6578.13207918100],
[0.00000000312, 3.62016422039, 255.97037637200],
[0.00000000278, 5.62032972822, 3378.74546233760],
[0.00000000268, 2.97528422526, 21947.11137270000],
[0.00000000303, 2.71946492092, 3313.21087060300],
[0.00000000263, 3.85883671333, 28628.33622609960],
[0.00000000257, 0.25607724431, 19146.75926614180],
[0.00000000282, 2.29169514758, 2008.55753915900],
[0.00000000301, 0.83275594655, 2806.98930834210],
[0.00000000264, 3.78635346388, 3936.79080070880],
[0.00000000254, 1.28062508539, 95.97922721780],
[0.00000000250, 5.58493858560, 412.37109687440],
[0.00000000284, 4.71065509252, 5621.91023351320],
[0.00000000286, 5.11854366190, 5621.77561290760],
[0.00000000254, 5.77068701321, 5813.29118932200],
[0.00000000311, 2.67573060947, 912.57024366560],
[0.00000000252, 4.19548440341, 24.85875881600],
[0.00000000255, 1.80023727978, 3193.80074017620],
[0.00000000247, 2.94199704738, 310.84079886840],
[0.00000000261, 5.68285399692, 3133.91168940320],
[0.00000000255, 4.46589323429, 5490.30096152400],
[0.00000000247, 2.28207487665, 246.25172232300],
[0.00000000257, 5.64335704456, 10706.88133432540],
[0.00000000246, 0.26910281348, 22.76849660940],
[0.00000000241, 0.03931394254, 9070.11887384880],
[0.00000000283, 1.30585259585, 4025.65648092580],
[0.00000000272, 1.28327911416, 1442.26120876020],
[0.00000000294, 4.02082336381, 2814.85361486830],
[0.00000000249, 4.92144829429, 31022.75317085620],
[0.00000000237, 3.07683243726, 9947.05568153210],
[0.00000000236, 6.05766380360, 948.19528790160],
[0.00000000309, 3.45153658664, 25287.72379939980],
[0.00000000232, 4.99538565545, 1505.28780909299],
[0.00000000275, 1.20294105507, 6691.86151874940],
[0.00000000305, 2.73902403412, 176.69373013380],
[0.00000000231, 5.13610567818, 6997.61672305620],
[0.00000000237, 0.90339496046, 8.09386806900],
[0.00000000229, 0.63250047970, 23017.06265793620],
[0.00000000249, 6.05357589804, 2060.81785407180],
[0.00000000270, 2.14769161882, 2973.38809773740],
[0.00000000241, 4.63019900075, 1612.95133303160],
[0.00000000227, 5.94537053649, 2942.48067694380],
[0.00000000269, 5.93687481153, 4005.36847182980],
[0.00000000227, 3.91459879933, 2942.44616963940],
[0.00000000238, 5.14570745178, 721.13923120620],
[0.00000000275, 1.06902528739, 3343.36393731080],
[0.00000000232, 3.52110290510, 6674.17861670160],
[0.00000000277, 0.19619249083, 270.19747037360],
[0.00000000274, 0.30235979008, 5607.61582920880],
[0.00000000233, 5.75237138576, 604.84974070480],
[0.00000000214, 3.38626276995, 647.01083331480],
[0.00000000282, 0.29694635625, 12323.42309600880],
[0.00000000282, 3.18114716742, 6364.83298374300],
[0.00000000264, 4.64751563064, 1346.34429130980],
[0.00000000280, 4.64995184564, 6701.58017279840],
[0.00000000246, 3.03036675631, 3304.00706139560],
[0.00000000213, 4.80555095681, 8830.91338822380],
[0.00000000220, 1.54642908481, 23546.75362303080],
[0.00000000214, 1.35475764936, 184.84990797020],
[0.00000000228, 4.29420876593, 2970.91261075940],
[0.00000000229, 2.53361265404, 3710.31224264020],
[0.00000000273, 1.89943168433, 270.13016007080],
[0.00000000284, 3.28345980607, 16063.16484718500],
[0.00000000211, 5.84341192825, 1971.95217385480],
[0.00000000214, 0.22905754741, 5.19919116580],
[0.00000000246, 4.55971876123, 6040.34724601740],
[0.00000000229, 1.24432891752, 3568.08855948880],
[0.00000000216, 3.20098680120, 362.12113673080],
[0.00000000201, 2.45025935972, 20426.57109242200],
[0.00000000223, 2.07804482295, 17101.21113690720],
[0.00000000271, 3.49210901141, 3436.59165391760],
[0.00000000226, 0.42945734871, 557.09252119140],
[0.00000000264, 5.05794940070, 2938.94030494260],
[0.00000000207, 6.03491870748, 22487.37169284160],
[0.00000000197, 5.62923956977, 5209.47182633600],
[0.00000000211, 2.26445749553, 765.79306444640],
[0.00000000202, 0.88670673933, 767.84881934860],
[0.00000000212, 1.85965510753, 4782.87363546000],
[0.00000000194, 4.77420671032, 6850.80503653260],
[0.00000000192, 0.51565572072, 323.50541665740],
[0.00000000209, 4.79794980231, 14047.49376102520],
[0.00000000193, 2.56057288512, 18606.49894600020],
[0.00000000209, 1.46088434217, 5.85720229960],
[0.00000000214, 0.97578687412, 17468.85519794540],
[0.00000000196, 4.08789826861, 3262.86188271590],
[0.00000000198, 3.99111216230, 10018.24685144760],
[0.00000000235, 1.11133081576, 625.67019231240],
[0.00000000197, 0.48692287381, 15106.87569121440],
[0.00000000214, 5.33581901309, 955.24152459960],
[0.00000000199, 0.40088144456, 7586.68155006440],
[0.00000000251, 5.57906426342, 138.58819838440],
[0.00000000208, 4.11480858445, 1755.06264976500],
[0.00000000210, 2.30499661227, 53.30794628380],
[0.00000000253, 1.27099771143, 309.27832265580],
[0.00000000242, 3.71426781511, 3212.59358336240],
[0.00000000178, 3.06961783443, 1437.17561419860],
[0.00000000203, 0.28410501881, 582.99891137840],
[0.00000000190, 0.10457198807, 26087.90314157420],
[0.00000000178, 0.53068485806, 7366.26890762560],
[0.00000000245, 4.20195166994, 8436.28750316460],
[0.00000000176, 3.66697456425, 6688.27109009760],
[0.00000000177, 4.48104044431, 8799.98871377800],
[0.00000000181, 3.57461078885, 15121.10278521600],
[0.00000000198, 3.55065962909, 24606.13555322000],
[0.00000000187, 3.45440079747, 1329.51209026000],
[0.00000000176, 5.81532365473, 12406.16055082860],
[0.00000000235, 1.28568802052, 4427.39591298580],
[0.00000000179, 1.55718466444, 3362.46325602620],
[0.00000000174, 1.61086801253, 30065.51184029820],
[0.00000000199, 0.07164714815, 375.76573157020],
[0.00000000174, 4.58412775793, 3283.71405176420],
[0.00000000171, 5.82189798695, 23937.85638974100],
[0.00000000182, 2.57146189845, 418.50432280700],
[0.00000000168, 5.13131619552, 21393.54196985760],
[0.00000000183, 4.93161962050, 9468.26787725700],
[0.00000000167, 1.48091400654, 2619.47319549360],
[0.00000000169, 5.12437031125, 3223.29255847960],
[0.00000000188, 3.41823914376, 5032.77809620220],
[0.00000000181, 0.50010974122, 2125.87740737920],
[0.00000000164, 1.71077130702, 15849.86575174700],
[0.00000000202, 6.21085922593, 3909.43430072720],
[0.00000000171, 5.86158194602, 625.62513619720],
[0.00000000165, 3.85569118220, 13207.02930736500],
[0.00000000163, 2.04373367430, 3347.29609057390],
[0.00000000160, 2.83784244321, 5888.44996493220],
[0.00000000212, 2.32801112252, 3232.94890276120],
[0.00000000163, 4.23488695195, 31968.94865279940],
[0.00000000159, 1.48046671186, 249.90446074220],
[0.00000000160, 0.21960307161, 12942.96506292400],
[0.00000000220, 3.90787704883, 9638.94074787620],
[0.00000000161, 2.94093367568, 3370.04193523580],
[0.00000000159, 5.59017475732, 1442.27846241240],
[0.00000000221, 3.82548751198, 1954.71715036360],
[0.00000000192, 4.62595272276, 3336.68027343670],
[0.00000000164, 1.59200641542, 386.41965057220],
[0.00000000169, 5.45784867095, 259.56080502380],
[0.00000000201, 0.95077053594, 29424.63423291600],
[0.00000000174, 1.15216485688, 6382.09845913040],
[0.00000000163, 1.16606667991, 4289.78803566960],
[0.00000000187, 3.22135956460, 2751.54759969160],
[0.00000000162, 4.79372588575, 24889.57479599160],
[0.00000000192, 0.88040946364, 5244.04923920100],
[0.00000000160, 2.85034784370, 9374.82644678460],
[0.00000000172, 2.38601254063, 2281.24775016280],
[0.00000000202, 4.12164786769, 7321.12213971360],
[0.00000000156, 4.55171204694, 27682.14074415640],
[0.00000000170, 4.62851491273, 10824.20120254560],
[0.00000000157, 0.91363725609, 4503.08713110760],
[0.00000000156, 5.58255618318, 10448.43547097540],
[0.00000000157, 0.92229160815, 15636.56665630900],
[0.00000000171, 5.43820628341, 11904.91877320180],
[0.00000000180, 1.89091405241, 13575.74880223720],
[0.00000000198, 4.42539692212, 10025.42770875120],
[0.00000000158, 4.12087914642, 11240.16272807180],
[0.00000000211, 2.42218772392, 8749.15625447220],
[0.00000000183, 1.47934835951, 6677.34351804160],
[0.00000000197, 1.43469282909, 14061.72085502680],
[0.00000000170, 4.32424842659, 742.99006053260],
[0.00000000170, 2.92905324873, 9093.99731159660],
[0.00000000160, 2.79797608932, 1461.05405194640],
[0.00000000174, 5.37738922471, 3318.76159737340],
[0.00000000172, 0.35524089578, 2281.21324285840],
[0.00000000147, 2.76602235522, 4193.80880845180],
[0.00000000151, 4.23962231148, 3368.01398279660],
[0.00000000157, 1.01295201512, 24336.00539314920],
[0.00000000165, 0.58335652806, 15906.76412668260],
[0.00000000149, 5.69553079999, 31570.79964939120],
[0.00000000154, 5.28504381510, 1481.40937134520],
[0.00000000163, 1.81288628510, 18849.22754997420],
[0.00000000145, 3.57053080979, 3497.01314720220],
[0.00000000156, 3.56978076425, 21791.69097326579],
[0.00000000143, 0.56704903096, 13212.88650966460],
[0.00000000155, 0.08429188155, 6657.34641565180],
[0.00000000184, 2.54999403339, 24076.44458812540],
[0.00000000146, 1.16594990123, 526.16784674560],
[0.00000000144, 4.19229335185, 2771.79055267240],
[0.00000000169, 3.10771037057, 239.20548562500],
[0.00000000144, 6.26688878164, 6679.74038069130],
[0.00000000174, 2.37509025280, 3397.51080163540],
[0.00000000163, 3.88047919138, 16703.04487984680],
[0.00000000161, 1.73958633312, 2185.25126929280],
[0.00000000164, 0.62146994730, 1538.24043597800],
[0.00000000182, 6.16856014864, 6685.10618875760],
[0.00000000140, 4.08200595943, 4186.69526145100],
[0.00000000192, 4.47709998867, 57.87869600380],
[0.00000000151, 3.06451266512, 838.96928775040],
[0.00000000139, 1.12767399649, 6682.70932610790],
[0.00000000187, 4.97174626997, 6681.65473652630],
[0.00000000150, 5.69209290362, 9360.60435331840],
[0.00000000160, 5.66336382679, 10927.29397676420],
[0.00000000137, 3.46860408347, 5562.46906129680],
[0.00000000192, 5.27908098216, 34363.36559755600],
[0.00000000137, 5.87023088486, 2945.98654164060],
[0.00000000180, 1.07686767816, 15806.14683944200],
[0.00000000135, 0.34109799474, 7322.10246078180],
[0.00000000169, 2.27408583150, 379.37341387420],
[0.00000000172, 3.83276777655, 6621.85099148600],
[0.00000000134, 0.89486611090, 13286.18363552360],
[0.00000000168, 3.24434245132, 11614.43329373220],
[0.00000000135, 6.03727673544, 1214.80232962340],
[0.00000000150, 0.81912738038, 3416.87849797540],
[0.00000000136, 5.06627117467, 14421.83163698840],
[0.00000000138, 5.19336961955, 13363.43002786740],
[0.00000000163, 5.91124428824, 16703.07938715119],
[0.00000000181, 3.31978654659, 139.69813952280],
[0.00000000162, 4.05905033891, 1795.25844372100],
[0.00000000132, 0.40901506100, 1083.26036793700],
[0.00000000156, 0.12304144640, 1107.13880568480],
[0.00000000158, 6.25022915072, 6666.99775939800],
[0.00000000131, 3.95250083817, 3.45580804620],
[0.00000000147, 4.94673462086, 15010.89646399660],
[0.00000000140, 6.13853404667, 12729.66596748600],
[0.00000000131, 5.43398849473, 25665.51748340920],
[0.00000000135, 5.06017183369, 11876.46958573400],
[0.00000000128, 2.86969332730, 6549.68289171320],
[0.00000000174, 5.18169887171, 28230.18722269139],
[0.00000000179, 3.25589354429, 4922.57177498280],
[0.00000000139, 5.33624615245, 23958.63178523340],
[0.00000000127, 5.78406495652, 14577.18472611980],
[0.00000000128, 1.27276688747, 8584.66166590080],
[0.00000000133, 0.39052474466, 12410.73130054860],
[0.00000000134, 1.09641189843, 8962.43809625800],
[0.00000000125, 3.20445201519, 29.88204361020],
[0.00000000136, 3.62250122667, 3511.28529731900],
[0.00000000162, 5.36465149996, 2472.67876262220],
[0.00000000150, 0.40179894287, 1111.64224510200],
[0.00000000129, 1.94909076932, 19645.52555679060],
[0.00000000172, 5.21328160366, 6747.71226231400],
[0.00000000126, 4.39378462616, 21548.96236929180],
[0.00000000146, 3.85987749053, 13361.46938573100],
[0.00000000156, 5.24740844581, 6645.19698672220],
[0.00000000137, 4.94588047257, 20995.39296644940],
[0.00000000131, 1.72431469184, 11925.27409260060],
[0.00000000136, 2.04268940441, 10654.62101941260],
[0.00000000140, 1.54439148652, 8219.46528937760],
[0.00000000127, 6.16695075115, 10016.31435579200],
[0.00000000155, 5.47145482987, 2.96894541660],
[0.00000000132, 6.25626202928, 13227.38462676380],
[0.00000000121, 3.74135485334, 10294.51023745100],
[0.00000000134, 3.12718351732, 8962.47260356240],
[0.00000000122, 0.77282907794, 4936.79886898440],
[0.00000000125, 4.23213631052, 15650.79375031060],
[0.00000000157, 1.79175545524, 16489.76303806100],
[0.00000000155, 4.15655698197, 56.38318607620],
[0.00000000134, 1.53268827347, 708.98980227659],
[0.00000000136, 4.01025697673, 9797.49248439750],
[0.00000000156, 4.61556268820, 3354.83952070140],
[0.00000000131, 4.47476808853, 11776.89992986440],
[0.00000000118, 1.17466010141, 4606.17990532620],
[0.00000000128, 0.12648796247, 6681.64492949320],
[0.00000000122, 0.13511377940, 8322.55806359620],
[0.00000000119, 1.29139116350, 10544.41469819320],
[0.00000000128, 4.44966050740, 13465.54248101780],
[0.00000000119, 4.01709629990, 14481.20549890200],
[0.00000000147, 1.81590279650, 685.11136452880],
[0.00000000137, 4.78402836071, 3613.28538405140],
[0.00000000151, 1.48428558337, 9698.33186344200],
[0.00000000136, 2.47757608387, 10156.90236013480],
[0.00000000123, 2.42353206298, 6.13322593260],
[0.00000000117, 5.40635440024, 688.63448287780],
[0.00000000153, 5.00372030984, 14556.89671702380],
[0.00000000133, 3.15773785434, 1125.86933910360],
[0.00000000153, 1.94292660454, 6533.14612897330],
[0.00000000124, 4.94608245253, 12825.64519470380],
[0.00000000117, 1.13528750738, 4452.25467180180],
[0.00000000115, 3.34121813462, 10001.48196070061],
[0.00000000115, 3.44586362144, 7696.88787128380],
[0.00000000117, 0.72489390402, 27.46886639960],
[0.00000000132, 2.41318250916, 6717.25272007700],
[0.00000000118, 0.35995031424, 27832.03821928320],
[0.00000000157, 1.73929012934, 11560.07771607740],
[0.00000000148, 2.14023976341, 15265.88651930040],
[0.00000000113, 1.29183863745, 26880.31981303260],
[0.00000000151, 0.95890610457, 6530.17718355670],
[0.00000000153, 5.62679784282, 9911.63095888000],
[0.00000000157, 0.09791378159, 138.51749687070],
[0.00000000119, 2.16883964744, 7082.89697515680],
[0.00000000113, 5.43102427558, 422.02744115600],
[0.00000000130, 2.13493506322, 117.81280289200],
[0.00000000140, 2.51194591630, 28.98162997940],
[0.00000000128, 1.23822751200, 6680.80477730600],
[0.00000000111, 4.60294776614, 25135.82651831460],
[0.00000000118, 0.34226497704, 4140.43355186520],
[0.00000000112, 4.02233737541, 6314.00052443720],
[0.00000000134, 3.35926214730, 11247.20896476980],
[0.00000000120, 6.09430372868, 4106.40549114620],
[0.00000000117, 0.03006245187, 7.67379197540],
[0.00000000109, 3.62630036582, 3344.11829139661],
[0.00000000109, 1.94277745743, 16702.99482319620],
[0.00000000114, 4.87315937546, 6151.51663465280],
[0.00000000109, 5.65707270595, 3344.15279870100],
[0.00000000108, 0.72637519191, 10.56935504700],
[0.00000000128, 5.77326416186, 13369.56325380000],
[0.00000000147, 4.73848506543, 11610.91017538320],
[0.00000000145, 4.95495312886, 9859.37064396720],
[0.00000000111, 3.28808788953, 257.01800774300],
[0.00000000112, 4.79777726412, 12140.60114047780],
[0.00000000109, 3.73199687068, 13635.12266415080],
[0.00000000117, 1.20057736014, 6705.10329114740],
[0.00000000149, 4.91688353237, 277.03499374140],
[0.00000000108, 3.37299798972, 6717.83021870380],
[0.00000000106, 0.53379407701, 5085.10572141780],
[0.00000000125, 4.62770076269, 9329.67967887260],
[0.00000000107, 4.60288570375, 1957.72507985320],
[0.00000000113, 4.04786119569, 6953.89781075120],
[0.00000000106, 0.75378922686, 149.89747512680],
[0.00000000114, 0.62074562387, 6151.55114195720],
[0.00000000108, 5.22204692781, 1556.56814695540],
[0.00000000104, 1.02502614223, 4878.85286267780],
[0.00000000133, 1.15811543786, 816.65332621520],
[0.00000000134, 1.69834857217, 183.86958690200],
[0.00000000104, 2.58832774275, 14591.41182012140],
[0.00000000107, 4.42117075795, 7.13080065300],
[0.00000000126, 0.03750399181, 16.83220104979],
[0.00000000102, 1.20624870972, 11986.67590695340],
[0.00000000102, 2.97579561878, 29822.78323632420],
[0.00000000116, 4.73049067619, 13366.04013545100],
[0.00000000130, 4.10484632841, 35.60779058380],
[0.00000000113, 3.69200525056, 44.65383324020],
[0.00000000111, 5.12900291511, 146.79443287140],
[0.00000000126, 1.82187459534, 26887.36604973060],
[0.00000000121, 6.08309355316, 7100.70949727480],
[0.00000000105, 6.16606590276, 9175.75444534820],
[0.00000000132, 2.97955203077, 1250.83019630080],
[0.00000000106, 5.08419485009, 8742.04270747140],
[0.00000000120, 0.59116561391, 31172.65064598300],
[0.00000000112, 3.70888430091, 10050.28646756720],
[0.00000000100, 1.82077956276, 12012.58229714040],
[0.00000000107, 4.86100312387, 7899.55030137200],
[0.00000000099, 0.72997085174, 18977.17908300880],
[0.00000000107, 5.25025570307, 63.73589830340],
[0.00000000099, 2.79139996703, 17932.02424682120],
[0.00000000097, 4.94370173613, 28109.21461605200],
[0.00000000122, 4.18676567644, 19617.07636932279],
[0.00000000121, 3.14207351411, 9278.84721956680],
[0.00000000112, 1.43537110436, 16232.74503031800],
[0.00000000096, 2.57929371627, 12715.43887348440],
[0.00000000096, 2.51396484677, 3535.58381116040],
[0.00000000112, 6.19137312195, 6685.15700666270],
[0.00000000109, 1.53428110338, 16703.12944380180],
[0.00000000096, 4.29245810274, 7906.59653807000],
[0.00000000096, 3.08847844641, 3468.63127003720],
[0.00000000095, 6.09186084700, 10037.08975128440],
[0.00000000094, 1.79812841802, 20047.19767854780],
[0.00000000110, 4.24859410294, 3337.07205469860],
[0.00000000093, 2.17945548408, 16066.06586147480],
[0.00000000115, 5.44548079869, 11353.89216764020],
[0.00000000098, 1.89605054783, 33406.12426699800],
[0.00000000101, 3.00793005829, 3528.53757446240],
[0.00000000096, 5.40659912420, 5749.86176654780],
[0.00000000113, 3.93443805059, 7167.19690618920],
[0.00000000092, 3.58985964414, 6724.94376570460],
[0.00000000119, 3.90561570260, 11346.77862063940],
[0.00000000097, 2.57280790230, 1747.60737815290],
[0.00000000118, 3.82111723459, 9072.66167112960],
[0.00000000096, 0.72646224606, 3152.68727893721],
[0.00000000092, 6.23928508055, 24491.42579258340],
[0.00000000099, 1.86991802881, 72.05573335480],
[0.00000000094, 1.51091806861, 9801.42463766060],
[0.00000000091, 4.94377681711, 8756.26980147300],
[0.00000000095, 2.58771497236, 11663.17049029600],
[0.00000000093, 0.66092443320, 30.99198474860],
[0.00000000088, 2.47386826588, 17232.75309859360],
[0.00000000100, 0.19616913512, 11883.58313273480],
[0.00000000094, 0.61277732908, 73.63546321960],
[0.00000000091, 6.04139177526, 153.92523352440],
[0.00000000095, 0.30865798871, 29168.59654624120],
[0.00000000110, 6.27936643935, 3337.10656200300],
[0.00000000087, 2.09287965409, 10264.56588407340],
[0.00000000089, 3.27633365389, 3002.36972771680],
[0.00000000091, 1.89622049447, 37895.42629036740],
[0.00000000118, 3.88268323672, 1236.07566032300],
[0.00000000094, 2.27819061990, 4845.90023579280],
[0.00000000085, 3.07438636612, 9983.70424446160],
[0.00000000086, 3.94463425808, 16.76489074700],
[0.00000000099, 4.58890225582, 3774.32416457660],
[0.00000000086, 1.27758598252, 34513.26307268280],
[0.00000000118, 6.10625309129, 454.90936652730],
[0.00000000096, 6.08772700197, 1755.47168467910],
[0.00000000085, 4.73193631802, 4576.68808702280],
[0.00000000116, 0.88573303872, 16511.61386738740],
[0.00000000083, 3.13948373813, 10191.41746323240],
[0.00000000083, 0.36972674664, 9755.23023837760],
[0.00000000112, 2.26524635842, 10006.58480891440],
[0.00000000087, 4.25461508452, 8.16813658240],
[0.00000000087, 5.31716927554, 1868.85939963620],
[0.00000000115, 3.30507830050, 14157.70008224460],
[0.00000000087, 2.90507350729, 36.99559061100],
[0.00000000083, 3.58400049244, 12928.73796892240],
[0.00000000086, 2.46839611271, 113.72943956840],
[0.00000000096, 2.99829695985, 6510.55198278040],
[0.00000000084, 1.34333260788, 4133.38731516720],
[0.00000000093, 2.41895388985, 20040.15144184979],
[0.00000000085, 5.92093268818, 12299.54465826100],
[0.00000000082, 4.71321236549, 7733.49323658800],
[0.00000000081, 5.26971110105, 12199.97500239140],
[0.00000000080, 4.34410099751, 7218.02936549500],
[0.00000000095, 0.02613500045, 2.90101428980],
[0.00000000094, 6.22018441621, 20043.69181385099],
[0.00000000085, 4.66573809999, 8638.94993325280],
[0.00000000079, 2.89839604813, 22854.59602180400],
[0.00000000104, 0.94882888784, 2735.76268599500],
[0.00000000080, 1.68097745917, 12839.87228870540],
[0.00000000085, 1.95515305721, 4686.95671800959],
[0.00000000094, 0.58147434179, 14128.24277124560],
[0.00000000091, 1.16317999954, 3495.96551583120],
[0.00000000084, 4.04104644774, 9815.65173166220],
[0.00000000082, 1.83662951627, 19190.47817844680],
[0.00000000080, 4.04733274699, 3188.71514561460],
[0.00000000084, 2.71620952175, 12089.76868117200],
[0.00000000080, 2.77363158210, 9495.66943335380],
[0.00000000078, 5.77285430206, 10397.60301166960],
[0.00000000084, 0.78188080031, 7214.43893684320],
[0.00000000094, 2.14762315943, 13532.02988993220],
[0.00000000101, 5.76349087526, 1484.93248969420],
[0.00000000082, 3.11421789241, 8446.99147881720],
[0.00000000096, 5.85152670536, 3492.50970778500],
[0.00000000079, 4.69625309523, 5298.33750655300],
[0.00000000097, 3.97960395898, 18208.34994259200],
[0.00000000105, 1.74376904536, 36.64856292950],
[0.00000000094, 4.18941238607, 20043.65730654660],
[0.00000000075, 3.46629875063, 13341.67431130680],
[0.00000000092, 2.67278833288, 6680.79497027290],
[0.00000000075, 4.59723160021, 9993.38809263160],
[0.00000000087, 0.91979096638, 8425.71814811760],
[0.00000000074, 0.42228487063, 48429.28218232440],
[0.00000000074, 0.48470953224, 11456.98494185880],
[0.00000000077, 0.10707484151, 1371.41176345600],
[0.00000000093, 1.38010528069, 3145.64104223920],
[0.00000000075, 5.28061257070, 12306.59089495900],
[0.00000000079, 3.78666386040, 7.57867920960],
[0.00000000073, 4.42902162523, 14.73728232560],
[0.00000000084, 3.41538432898, 6637.50594109460],
[0.00000000093, 3.41302342683, 1596.11913198180],
[0.00000000071, 3.13537213242, 9488.62319665580],
[0.00000000079, 2.33442828498, 12465.53441274220],
[0.00000000078, 2.21525134547, 2810.98877190800],
[0.00000000099, 0.48801369293, 17499.36014031540],
[0.00000000075, 4.10299895268, 5525.86369599260],
[0.00000000071, 4.04186021414, 259.49349472100],
[0.00000000073, 2.20102876718, 30774.50164257480],
[0.00000000074, 4.93439968296, 13517.80279593060],
[0.00000000071, 5.32625652676, 6670.17915313570],
[0.00000000078, 2.17664185326, 13421.82356871280],
[0.00000000088, 5.38469204503, 17762.44406368820],
[0.00000000081, 2.48353174238, 73.60095591520],
[0.00000000092, 1.13088448190, 7747.72033058960],
[0.00000000070, 1.16361323015, 5220.17080145320],
[0.00000000084, 5.83220387910, 22.37827130260],
[0.00000000076, 5.21065604639, 4271.97551355160],
[0.00000000080, 4.01817623627, 3311.18291816379],
[0.00000000068, 2.45937697940, 6279.55273164240],
[0.00000000067, 4.31723563048, 2281.29780681340],
[0.00000000067, 4.88776321797, 4379.63903749020],
[0.00000000069, 3.57006764536, 14955.04572043200],
[0.00000000078, 2.62374773232, 2810.85415130240],
[0.00000000067, 4.76301301456, 6812.76681508600],
[0.00000000070, 5.60319851277, 13383.22510229160],
[0.00000000070, 3.05647570196, 10081.21114201300],
[0.00000000081, 4.91537623765, 3333.92876282570],
[0.00000000082, 5.49204987110, 5483.25472482600],
[0.00000000065, 3.50466797067, 9161.52735134660],
[0.00000000065, 2.79212460026, 13497.51478683460],
[0.00000000070, 0.93640431668, 6106.88005506480],
[0.00000000073, 2.57583496978, 6614.73744448520],
[0.00000000070, 0.84170070580, 16695.94858649819],
[0.00000000069, 1.10040627005, 2544.33167353560],
[0.00000000063, 6.05841309176, 6453.74872061060],
[0.00000000069, 2.67053540192, 2641.34127847220],
[0.00000000086, 1.73112264739, 6286.59896834040],
[0.00000000062, 5.49002783256, 4957.08687808040],
[0.00000000072, 3.38857910283, 3184.21170619740],
[0.00000000069, 5.35281990892, 2544.29716623120],
[0.00000000064, 4.79175268505, 3181.66890891660],
[0.00000000060, 6.18449904353, 3361.94806716680],
[0.00000000065, 1.48236627574, 4819.47900076420],
[0.00000000054, 3.66018290396, 2917.53735417280],
[0.00000000064, 4.72286914683, 2281.16318620780],
[0.00000000053, 4.65521663671, 3448.27595063840],
[0.00000000060, 0.77450276964, 3319.27678623280],
[0.00000000051, 1.45142985881, 3547.31316399640],
[0.00000000051, 4.81258158513, 4403.51747523800],
[0.00000000050, 0.37366902835, 3322.79990458180],
[0.00000000050, 4.68787711774, 3253.30422216000],
[0.00000000067, 4.63578431535, 4694.00295470760],
[0.00000000049, 3.17471347671, 5452.26274007740],
[0.00000000051, 2.54791773443, 4001.84535348080],
[0.00000000048, 2.81171553464, 3372.58473251660],
[0.00000000054, 4.45945188023, 10284.92120347220],
[0.00000000053, 3.85131213520, 9758.75335672660],
[0.00000000051, 1.11244863072, 6901.63749583840],
[0.00000000062, 1.42198009630, 6830.78805053420],
[0.00000000055, 5.61672988180, 45494.58142974879],
[0.00000000054, 0.61701959453, 4716.38622654560],
[0.00000000054, 4.28556326526, 2910.49111747480],
[0.00000000045, 3.14626081312, 13951.51453380740],
[0.00000000050, 4.16235480519, 12979.55317457600],
[0.00000000046, 1.66182208107, 7768.00833968560],
[0.00000000045, 5.07701425888, 14951.52260208300],
[0.00000000043, 4.31723459530, 5881.40372823420],
[0.00000000045, 2.39713581676, 8852.24902869080],
[0.00000000043, 2.10202660495, 3337.15661865360],
[0.00000000048, 0.19934255781, 1905.46476494040],
[0.00000000056, 5.25687695855, 12808.88030395680],
[0.00000000049, 2.06320966659, 4296.90158267040],
[0.00000000042, 6.07282126953, 4295.85395129940],
[0.00000000043, 1.74571613780, 3130.83644961080],
[0.00000000050, 2.27112469544, 3427.92063123960],
[0.00000000050, 0.30214747765, 3358.42494881780],
[0.00000000043, 5.05297177283, 3229.42578441220],
[0.00000000054, 6.11998016428, 16894.51039961060],
[0.00000000043, 1.90603004035, 3451.79906898740],
[0.00000000039, 0.50727886431, 10011.20061474960],
[0.00000000052, 3.17851184154, 2324.94940881560],
[0.00000000038, 4.88249540246, 3499.55594448300],
[0.00000000039, 5.28113083211, 3343.15522398060],
[0.00000000039, 4.98185580267, 3468.56395973440],
[0.00000000047, 2.16244218985, 10027.36020440680],
[0.00000000037, 5.84953090935, 6791.43117461900],
[0.00000000048, 5.03779546898, 7064.10413197060],
[0.00000000038, 0.58076516432, 8966.38750317330],
[0.00000000051, 3.36181117037, 8976.68244391180],
[0.00000000042, 4.13725767158, 8336.78515759780],
[0.00000000038, 5.75425648893, 4531.53631857540],
[0.00000000038, 3.55681323215, 5351.71276313960],
[0.00000000040, 2.79414141035, 3067.93946934820],
[0.00000000040, 4.99798468494, 10042.19259949820],
[0.00000000037, 1.82286411009, 10017.95594474140],
[0.00000000036, 6.02115369796, 6474.52411610300],
[0.00000000044, 3.01299253859, 7417.10136693140],
[0.00000000045, 2.33470159894, 3123.79021291280],
[0.00000000039, 4.91767933978, 8034.61538140740],
], [
[3340.85627474342, 0.00000000000, 0.00000000000],
[0.01458227051, 3.60426053609, 3340.61242669980],
[0.00164901343, 3.92631250962, 6681.22485339960],
[0.00019963338, 4.26594061030, 10021.83728009940],
[0.00003452399, 4.73210386365, 3.52311834900],
[0.00002485480, 4.61277567318, 13362.44970679920],
[0.00000841551, 4.45858256765, 2281.23049651060],
[0.00000537566, 5.01589727492, 398.14900340820],
[0.00000521041, 4.99422678175, 3344.13554504880],
[0.00000432614, 2.56066402860, 191.44826611160],
[0.00000429656, 5.31646162367, 155.42039943420],
[0.00000381747, 3.53881289437, 796.29800681640],
[0.00000314129, 4.96335266049, 16703.06213349900],
[0.00000282804, 3.15967518204, 2544.31441988340],
[0.00000205664, 4.56891455660, 2146.16541647520],
[0.00000168805, 1.32894813366, 3337.08930835080],
[0.00000157587, 4.18501035954, 1751.53953141600],
[0.00000133686, 2.23325104196, 0.98032106820],
[0.00000116561, 2.21347652545, 1059.38193018920],
[0.00000117591, 6.02407213861, 6151.53388830500],
[0.00000113595, 5.42803224317, 3738.76143010800],
[0.00000133563, 5.97421903927, 1748.01641306700],
[0.00000091098, 1.09627836591, 1349.86740965880],
[0.00000083301, 5.29636626272, 6684.74797174860],
[0.00000113876, 2.12869455089, 1194.44701022460],
[0.00000080776, 4.42813405865, 529.69096509460],
[0.00000079531, 2.24864266330, 8962.45534991020],
[0.00000072505, 5.84208163240, 242.72860397400],
[0.00000072946, 2.50189460554, 951.71840625060],
[0.00000071487, 3.85636094435, 2914.01423582380],
[0.00000085342, 3.90854841008, 553.56940284240],
[0.00000067582, 5.02327686473, 382.89653222320],
[0.00000065089, 1.01802439311, 3340.59517304760],
[0.00000065089, 3.04879603978, 3340.62968035200],
[0.00000061508, 4.15183159800, 3149.16416058820],
[0.00000048477, 4.87362121538, 213.29909543800],
[0.00000046584, 1.31452419914, 3185.19202726560],
[0.00000056520, 3.88813699320, 4136.91043351620],
[0.00000047613, 1.18238046057, 3333.49887969900],
[0.00000041343, 0.71385375517, 1592.59601363280],
[0.00000040055, 5.31611875491, 20043.67456019880],
[0.00000040272, 2.72542480614, 7.11354700080],
[0.00000032886, 5.41067411968, 6283.07584999140],
[0.00000028244, 0.04534124888, 9492.14631500480],
[0.00000022294, 5.88516997273, 3870.30339179440],
[0.00000022431, 5.46592525433, 20.35531939880],
[0.00000022612, 0.83775884934, 3097.88382272579],
[0.00000021418, 5.37934044204, 3340.54511639700],
[0.00000023335, 6.16762213077, 3532.06069281140],
[0.00000026579, 3.88960724782, 1221.84856632140],
[0.00000022797, 1.54504711003, 2274.11694950980],
[0.00000020431, 2.36353950189, 1589.07289528380],
[0.00000020186, 3.36375535766, 5088.62883976680],
[0.00000026554, 5.11271747607, 2700.71514038580],
[0.00000019675, 2.57805423988, 12303.06777661000],
[0.00000019468, 0.49216434489, 6677.70173505060],
[0.00000021104, 3.52525428062, 15.25247118500],
[0.00000021425, 4.97081508139, 3340.67973700260],
[0.00000018505, 5.57863503922, 1990.74501704100],
[0.00000017811, 6.12537931996, 4292.33083295040],
[0.00000016472, 2.60291845066, 3341.59274776800],
[0.00000016599, 1.25519718278, 3894.18182954220],
[0.00000019455, 2.53112676345, 4399.99435688900],
[0.00000015000, 1.03464802434, 2288.34404351140],
[0.00000020029, 4.73119428749, 4690.47983635860],
[0.00000015381, 2.47009470350, 4535.05943692440],
[0.00000019964, 5.78652958398, 7079.37385680780],
[0.00000015307, 2.26515985343, 3723.50895892300],
[0.00000014705, 3.36979890389, 6681.24210705180],
[0.00000013535, 2.12334410410, 5486.77784317500],
[0.00000012950, 5.61929676688, 10025.36039844840],
[0.00000012682, 2.95022113262, 3496.03282613400],
[0.00000013644, 1.97739547259, 5614.72937620960],
[0.00000013013, 1.51424752315, 5628.95647021120],
[0.00000014705, 1.33902715586, 6681.20759974740],
[0.00000011353, 6.23438193885, 135.06508003540],
[0.00000013275, 3.42243595774, 5621.84292321040],
[0.00000010867, 5.28184140482, 2818.03500860600],
[0.00000011850, 3.12701832949, 426.59819087600],
[0.00000010472, 2.73581537999, 2787.04302385740],
[0.00000011132, 5.84178807242, 2803.80791460440],
[0.00000011764, 2.58551521265, 8432.76438481560],
[0.00000011854, 5.47630686910, 3553.91152213780],
[0.00000008490, 1.91378007528, 11773.37681151540],
[0.00000009708, 4.52957217749, 6489.77658728800],
[0.00000008562, 3.16141186861, 162.46663613220],
[0.00000010958, 4.15771850822, 2388.89402044920],
[0.00000008133, 1.61295625304, 2957.71589447660],
[0.00000008840, 4.23294294197, 7477.52286021600],
[0.00000008034, 5.69983564288, 6041.32756708560],
[0.00000008344, 2.18273563186, 23.87843774780],
[0.00000007696, 5.71877332978, 9623.68827669120],
[0.00000008695, 4.43542512603, 5092.15195811580],
[0.00000008434, 3.16292250873, 3347.72597370060],
[0.00000006664, 5.07517838003, 8031.09226305840],
[0.00000008650, 4.33256981793, 3339.63210563160],
[0.00000007372, 6.17831593269, 3583.34103067380],
[0.00000005726, 3.68120120299, 8429.24126646660],
[0.00000006186, 3.54165967734, 692.15760122680],
[0.00000005438, 1.05129689580, 4933.20844033260],
[0.00000006108, 1.66240879939, 6525.80445396540],
[0.00000005154, 1.14703246368, 28.44918746780],
[0.00000004850, 5.29254832907, 6681.29216370240],
[0.00000005467, 6.12511022569, 2487.41604494780],
[0.00000004866, 3.10475368803, 5.52292430740],
[0.00000006360, 2.11896608283, 5884.92684658320],
[0.00000005223, 0.37446264120, 12832.75874170460],
[0.00000004710, 0.23326120326, 36.02786667740],
[0.00000004954, 2.44806818502, 5099.26550511660],
[0.00000004861, 5.60505298870, 6467.92575796160],
[0.00000004706, 0.02998416568, 7210.91581849420],
[0.00000004845, 5.70115105957, 6681.15754309680],
[0.00000005496, 2.01006612503, 522.57741809380],
[0.00000004964, 1.51006845561, 1744.42598441520],
[0.00000004443, 0.31208413867, 10018.31416175040],
[0.00000005381, 0.18359380473, 2942.46342329160],
[0.00000004075, 3.95582108330, 3.88133535800],
[0.00000005462, 0.19274227117, 7632.94325965020],
[0.00000004110, 1.59535768711, 7234.79425624200],
[0.00000004287, 2.87635993968, 2810.92146160520],
[0.00000005276, 2.22638595594, 3127.31333126180],
[0.00000004450, 4.17005729081, 2906.90068882300],
[0.00000005144, 5.66878565669, 23384.28698689860],
[0.00000003844, 2.26442183160, 2699.73481931760],
[0.00000003514, 1.76463961051, 1758.65307841680],
[0.00000003351, 2.66194137496, 4929.68532198360],
[0.00000004299, 4.43057446968, 640.87760738220],
[0.00000003140, 1.75866226873, 9595.23908922340],
[0.00000003716, 2.91969220147, 15643.68020330980],
[0.00000003249, 6.13937134379, 10419.98628350760],
[0.00000003077, 2.56115174488, 7064.12138562280],
[0.00000003208, 2.32519453080, 5085.03841111500],
[0.00000002930, 1.27797225349, 574.34479833480],
[0.00000002771, 1.75664216142, 639.89728631400],
[0.00000003325, 2.58945297384, 2118.76386037840],
[0.00000003187, 2.86646751510, 7740.60678358880],
[0.00000002780, 0.43157089331, 5828.02847164760],
[0.00000002824, 0.98500544471, 3191.04922956520],
[0.00000003016, 1.86555882509, 7.04623669800],
[0.00000003364, 1.52847138842, 6674.11130639880],
[0.00000002672, 3.70855172347, 10021.85453375160],
[0.00000002636, 3.11790581052, 6836.64525283380],
[0.00000002672, 1.67778079449, 10021.82002644720],
[0.00000002563, 3.77294986894, 2921.12778282460],
[0.00000002509, 0.30454165124, 3475.67750673520],
[0.00000002400, 0.96972421975, 3319.83703120740],
[0.00000002262, 2.81394314950, 7875.67186362420],
[0.00000002395, 2.96002707485, 6682.20517446780],
[0.00000002210, 0.61263930586, 10973.55568635000],
[0.00000002248, 4.12382007742, 59.37386191360],
[0.00000002426, 5.91508357946, 5331.35744374080],
[0.00000002158, 2.17583545077, 15113.98923821520],
[0.00000001941, 5.47668312685, 11371.70468975820],
[0.00000001903, 5.11165653855, 1066.49547719000],
[0.00000002370, 3.87889340214, 3355.86489788480],
[0.00000002299, 1.15914205086, 3320.25710730100],
[0.00000001944, 5.89081872133, 6894.52394883760],
[0.00000001843, 3.07643314617, 3325.35995551480],
[0.00000001809, 4.97905218276, 1648.44675719740],
[0.00000002136, 1.91364787635, 8969.56889691100],
[0.00000002099, 3.00410255642, 6254.62666252360],
[0.00000001915, 3.55907431740, 3767.21061757580],
[0.00000001991, 5.37274107053, 206.18554843720],
[0.00000001685, 5.49701299817, 266.60704172180],
[0.00000001646, 1.31923405548, 3264.34635542420],
[0.00000001732, 1.81361103995, 536.80451209540],
[0.00000001723, 3.25900379342, 7903.07341972100],
[0.00000001564, 5.75428852012, 3360.96774609859],
[0.00000001589, 1.73273563259, 3134.42687826260],
[0.00000001690, 2.43213510013, 3120.19978426100],
[0.00000001549, 1.54016426558, 8425.65083781480],
[0.00000001536, 5.88431472627, 20.77539549240],
[0.00000001460, 4.89733072879, 9830.38901398780],
[0.00000002023, 5.94808387002, 13365.97282514820],
[0.00000001991, 3.11613326265, 3361.38782219220],
[0.00000001401, 2.24482184868, 3344.20285535160],
[0.00000001365, 4.58006320751, 10818.13528691580],
[0.00000001392, 5.48931017516, 170.67287061920],
[0.00000001360, 3.07974035205, 6127.65545055720],
[0.00000001345, 1.18653158091, 14584.29827312060],
[0.00000001717, 5.62501515015, 6158.64743530580],
[0.00000001408, 1.82072980335, 3337.02199804800],
[0.00000001736, 2.01921900546, 10575.40668294180],
[0.00000001402, 4.50079374387, 5729.50644714900],
[0.00000001266, 5.91088435118, 9808.53818466140],
[0.00000001433, 6.05024653324, 12964.30070339100],
[0.00000001223, 0.82796258263, 419.48464387520],
[0.00000001393, 1.05117949107, 6438.49624942560],
[0.00000001272, 1.50116723856, 8439.87793181640],
[0.00000001143, 4.89747373731, 220.41264243880],
[0.00000001183, 3.52587190041, 6688.33840040040],
[0.00000001132, 6.19236255633, 6144.42034130420],
[0.00000001154, 2.23058485970, 8955.34180290940],
[0.00000001129, 3.44264300692, 10177.25767953360],
[0.00000001152, 5.29913300616, 27.40155609680],
[0.00000001274, 4.58421238440, 6247.51311552280],
[0.00000001093, 2.82623332360, 4569.57454002200],
[0.00000001303, 0.44350560735, 87.30820453981],
[0.00000001335, 2.14204457730, 11243.68584642080],
[0.00000001102, 1.96260837539, 6298.32832117640],
[0.00000001066, 2.89865914321, 10404.73381232260],
[0.00000001027, 4.79269049654, 3914.95722503460],
[0.00000001015, 0.22847818730, 3230.40610548040],
[0.00000001041, 3.73274497451, 10213.28554621100],
[0.00000001154, 4.14326179244, 6261.74020952440],
[0.00000001306, 3.67645557029, 2301.58581590939],
[0.00000001145, 5.12292846748, 4562.46099302120],
[0.00000001275, 5.14333847164, 2693.60159338500],
[0.00000000914, 1.22398892152, 103.09277421860],
[0.00000000955, 1.52875141393, 3369.06161416760],
[0.00000000908, 0.48223420834, 13358.92658845020],
[0.00000000892, 1.35161136807, 1214.73501932060],
[0.00000000998, 3.29665881950, 3178.14579056760],
[0.00000000980, 1.69212466625, 43.71891230500],
[0.00000000919, 2.45445889752, 13916.01910964160],
[0.00000000899, 5.94990531529, 12168.00269657460],
[0.00000000891, 5.63297246408, 10021.90459040220],
[0.00000000922, 3.91483430303, 9225.53927328300],
[0.00000000930, 0.24073004700, 6923.95345737360],
[0.00000000923, 1.10396074450, 29.42950853600],
[0.00000000816, 4.65198282005, 2707.82868738660],
[0.00000000791, 6.08595583868, 2384.32327072920],
[0.00000000820, 4.80968546763, 533.21408344360],
[0.00000000758, 2.06012386134, 12935.85151592320],
[0.00000000738, 1.03564559078, 14314.16811304980],
[0.00000000908, 0.69862047595, 16173.37116840440],
[0.00000000700, 4.08788234610, 5202.35827933520],
[0.00000000829, 2.01062325398, 9866.41688066520],
[0.00000000887, 6.04145842617, 10021.76996979660],
[0.00000000768, 1.39532897827, 8273.82086703240],
[0.00000000873, 4.45446600602, 3316.73398895200],
[0.00000000673, 3.02440642752, 1039.02661079040],
[0.00000000660, 2.83410276989, 107.66352393860],
[0.00000000838, 0.39195370222, 10551.52824519400],
[0.00000000708, 3.27560955336, 18984.29263000960],
[0.00000000658, 6.01853128902, 26724.89941359840],
[0.00000000685, 1.98132615912, 1228.96211332220],
[0.00000000595, 0.10260171285, 111.18664228760],
[0.00000000563, 1.59138368358, 2391.43681773000],
[0.00000000555, 2.70801962190, 4555.34744602040],
[0.00000000696, 2.89276686038, 2648.45482547300],
[0.00000000587, 4.56017988729, 6680.24453233140],
[0.00000000540, 2.86002662919, 5459.37628707820],
[0.00000000530, 5.64877399946, 6034.21402008480],
[0.00000000520, 0.20012848836, 13760.59871020740],
[0.00000000552, 5.08766140543, 1903.43681250120],
[0.00000000512, 3.21411265909, 11081.21921028860],
[0.00000000641, 5.19459033638, 6048.44111408640],
[0.00000000677, 3.87723948458, 13517.87010623340],
[0.00000000534, 0.23224033336, 51.28033786241],
[0.00000000670, 3.69368226469, 3335.08950239240],
[0.00000000486, 2.41879628327, 3364.49086444760],
[0.00000000500, 4.31447859057, 3344.49376205780],
[0.00000000481, 1.56481992611, 1964.83862685400],
[0.00000000504, 2.47456295599, 3863.18984479360],
[0.00000000523, 0.65856269237, 853.19638175200],
[0.00000000481, 0.12971954679, 66.48740891440],
[0.00000000535, 2.98601678918, 8270.29774868340],
[0.00000000450, 2.02303462834, 13362.43245314700],
[0.00000000448, 5.59827312967, 149.56319713460],
[0.00000000519, 2.75931838722, 3503.07906283200],
[0.00000000534, 4.77352933347, 1118.75579210280],
[0.00000000450, 4.05380888708, 13362.46696045140],
[0.00000000439, 4.83194205477, 3116.26763099790],
[0.00000000567, 5.67483490268, 227.47613278900],
[0.00000000459, 3.44555998004, 6702.00024889200],
[0.00000000545, 2.01193901951, 7910.18696672180],
[0.00000000425, 2.79854459343, 433.71173787680],
[0.00000000429, 4.30113040289, 16858.48253293320],
[0.00000000409, 0.05448009540, 3304.58456002240],
[0.00000000434, 5.70806855136, 21.85082932640],
[0.00000000399, 4.93233684937, 9779.10867612540],
[0.00000000532, 1.31038986189, 6660.44945790720],
[0.00000000398, 5.31345458361, 13119.72110282519],
[0.00000000459, 2.53671963587, 74.78159856730],
[0.00000000384, 2.29906801437, 12310.18132361080],
[0.00000000467, 5.12562716972, 1596.18644228460],
[0.00000000516, 5.84767782422, 1052.26838318840],
[0.00000000414, 4.75409582610, 3981.49003408200],
[0.00000000365, 3.73271671549, 5518.75014899180],
[0.00000000367, 0.13506394328, 56.89837493560],
[0.00000000459, 0.15582180531, 9381.93999378540],
[0.00000000392, 2.15845463651, 3980.50971301380],
[0.00000000396, 1.48538591462, 17924.91069982040],
[0.00000000456, 0.64517343174, 6816.28993343500],
[0.00000000358, 5.87219240658, 3607.21946842160],
[0.00000000490, 0.65766946042, 3376.64029337720],
[0.00000000365, 1.91816243676, 3347.65866339780],
[0.00000000397, 1.80006148744, 7895.95987272020],
[0.00000000336, 2.14687780119, 6677.63442474780],
[0.00000000340, 2.88185925998, 17256.63153634140],
[0.00000000334, 6.13670038311, 5724.93569742900],
[0.00000000339, 4.08527025169, 664.75604513000],
[0.00000000432, 2.52188285182, 18454.60166491500],
[0.00000000336, 4.22863444521, 6696.47732458460],
[0.00000000342, 5.96724705923, 3546.79797513700],
[0.00000000326, 4.02557052581, 6872.67311951120],
[0.00000000323, 5.05444843838, 3237.51965248120],
[0.00000000324, 2.89151245241, 8329.67161059700],
[0.00000000321, 6.25886976298, 10235.13637553740],
[0.00000000333, 2.57725424455, 6684.81528205140],
[0.00000000356, 6.27424874986, 8671.96987044060],
[0.00000000319, 5.05665355586, 36.60536530420],
[0.00000000305, 3.88755666972, 7107.82304427560],
[0.00000000322, 6.28125601341, 16706.58525184800],
[0.00000000334, 3.15240620873, 11216.28429032400],
[0.00000000287, 6.16467002771, 3973.39616601300],
[0.00000000283, 2.67802456636, 3877.41693879520],
[0.00000000283, 1.66293157090, 1692.16566950240],
[0.00000000276, 2.94210551399, 3415.39402526710],
[0.00000000275, 0.53418048945, 17395.21973472580],
[0.00000000355, 3.31406527401, 10022.81760116760],
[0.00000000311, 1.50310910269, 6660.86953400080],
[0.00000000269, 1.84517097065, 11780.49035851620],
[0.00000000270, 4.42425307819, 310.84079886840],
[0.00000000275, 3.58464612058, 128.01884333740],
[0.00000000275, 2.22523539580, 3017.10701004240],
[0.00000000312, 5.15950395287, 7255.56965173440],
[0.00000000299, 0.72552273097, 155.35308913140],
[0.00000000353, 5.70047798350, 16460.33352952499],
[0.00000000267, 5.97864271046, 9499.25986200560],
[0.00000000270, 0.77063210836, 11236.57229942000],
[0.00000000339, 3.36092148900, 5625.36604155940],
[0.00000000315, 2.33795159922, 3281.23856478620],
[0.00000000247, 3.71002922076, 7373.38245462640],
[0.00000000328, 0.18162415648, 5618.31980486140],
[0.00000000247, 6.27486009856, 15508.61512327440],
[0.00000000292, 0.14989609091, 16304.91313009080],
[0.00000000326, 4.53606745007, 2178.13772229200],
[0.00000000286, 5.47710043383, 9168.64089834740],
[0.00000000246, 1.49838712480, 15110.46611986620],
[0.00000000262, 2.58821936465, 3336.73109134180],
[0.00000000244, 0.84015413449, 16062.18452611680],
[0.00000000245, 0.37772563756, 12721.57209941700],
[0.00000000250, 2.26824758119, 6784.31762761820],
[0.00000000248, 6.22740483254, 13149.15061136120],
[0.00000000255, 4.93078809107, 14158.74771361560],
[0.00000000240, 6.15843594225, 19800.94595622480],
[0.00000000249, 5.47044926479, 4407.10790388980],
[0.00000000235, 5.38750866169, 76.26607127560],
[0.00000000258, 6.10384464886, 2480.30249794700],
[0.00000000306, 5.35546231697, 2766.26762836500],
[0.00000000236, 5.25670707064, 13171.00144068760],
[0.00000000224, 4.52466909993, 12566.15169998280],
[0.00000000220, 5.83694256642, 13936.79450513400],
[0.00000000271, 1.42460945147, 14054.60730802600],
[0.00000000213, 0.21127914063, 1505.28780909299],
[0.00000000267, 5.16501015011, 3205.54734666440],
[0.00000000212, 4.26202838353, 6546.15977336420],
[0.00000000211, 6.21401684263, 3253.30422216000],
[0.00000000233, 3.72007597749, 3346.13535100720],
[0.00000000274, 2.91986569135, 10713.99488132620],
[0.00000000201, 3.36695295492, 6.68366387410],
[0.00000000223, 3.08788599159, 401.67212175720],
[0.00000000234, 2.24268269202, 110.20632121940],
[0.00000000264, 2.08178742740, 6475.03930496240],
[0.00000000231, 4.53806384480, 9602.35263622420],
[0.00000000213, 2.85452302656, 5415.65737477320],
[0.00000000195, 0.99589439506, 5642.19824260920],
[0.00000000259, 0.00464351114, 9380.95967271720],
[0.00000000197, 3.32573550633, 3657.00429635640],
[0.00000000228, 5.33299975472, 3561.02506913860],
[0.00000000193, 1.25502846507, 6606.44325483230],
[0.00000000199, 1.13665869139, 685.04405422600],
[0.00000000227, 4.49610509002, 589.06482700820],
[0.00000000217, 5.48740879816, 10596.18207843420],
[0.00000000192, 4.26501800444, 3333.56619000180],
[0.00000000188, 1.44301618203, 4885.96640967860],
[0.00000000178, 4.82506490541, 9070.11887384880],
[0.00000000184, 5.69637552141, 3351.24909204960],
[0.00000000187, 0.76021337348, 16699.53901514999],
[0.00000000226, 0.82767654373, 3265.83082813250],
[0.00000000204, 6.20933387021, 394.62588505920],
[0.00000000176, 3.89567349231, 10028.95082710020],
[0.00000000174, 3.68843293982, 735.87651353180],
[0.00000000173, 2.44269377255, 3603.69635007260],
[0.00000000177, 1.24154853329, 12722.55242048520],
[0.00000000184, 4.77203925989, 286.96236112060],
[0.00000000171, 4.67140116008, 20199.09495963300],
[0.00000000170, 5.13753345526, 1332.05488754080],
[0.00000000201, 2.37863157745, 16276.46394262300],
[0.00000000209, 0.57156268506, 11250.79939342160],
[0.00000000164, 1.98441291396, 10014.72373309860],
[0.00000000191, 0.60250751218, 56.80326216980],
[0.00000000171, 6.22556266993, 17277.40693183380],
[0.00000000166, 1.05948008727, 19513.98359510420],
[0.00000000163, 1.59661610701, 1437.17561419860],
[0.00000000165, 3.36308723589, 6665.97238221460],
[0.00000000184, 3.20554894393, 263.08392337280],
[0.00000000212, 3.10485836003, 4039.88357492740],
[0.00000000176, 3.41768939214, 9468.26787725700],
[0.00000000163, 1.39275730949, 8982.81066930900],
[0.00000000213, 3.39734274482, 931.36308685180],
[0.00000000189, 4.54004144896, 8542.97070603500],
[0.00000000191, 1.15555618959, 3169.93955608060],
[0.00000000155, 1.41249963094, 22.76849660940],
[0.00000000153, 5.14168081601, 156.40072050240],
[0.00000000159, 3.64996617906, 8013.27974094040],
[0.00000000151, 1.93804487507, 3384.33133900480],
[0.00000000157, 0.58554505759, 158.94351778320],
[0.00000000173, 2.72517427493, 2807.39834325620],
[0.00000000159, 0.67192454133, 13892.14067189380],
[0.00000000150, 2.66045714174, 19004.64794940840],
[0.00000000192, 5.73782632783, 206.70073729660],
[0.00000000143, 3.19213280913, 6843.69148953180],
[0.00000000194, 1.32358882667, 19402.79695281660],
[0.00000000143, 2.36478163720, 13207.02930736500],
[0.00000000140, 1.88800568840, 11766.26326451460],
[0.00000000144, 0.69018080218, 17085.95866572220],
[0.00000000183, 5.98085295555, 13362.51701710200],
[0.00000000161, 2.92764155222, 5.85720229960],
[0.00000000162, 6.07051064413, 6701.58017279840],
[0.00000000192, 0.86266150575, 2814.44457995420],
[0.00000000182, 5.26446797092, 3873.82651014340],
[0.00000000137, 0.41563614709, 5820.91492464680],
[0.00000000144, 3.02314051168, 708.98980227659],
[0.00000000184, 4.61314496499, 3329.97576135000],
[0.00000000131, 3.48156082643, 367.22432896240],
[0.00000000173, 3.09922849765, 12295.95422960920],
[0.00000000135, 2.23311632892, 15664.03552270859],
[0.00000000147, 1.95810911154, 5732.04924442980],
[0.00000000158, 1.48909254724, 29.49181830340],
[0.00000000127, 5.55534080040, 3368.01398279660],
[0.00000000129, 1.78002583252, 22743.40937951640],
[0.00000000132, 2.81496895377, 21795.21409161479],
[0.00000000127, 5.73090203501, 3340.19235060619],
[0.00000000164, 1.87613918877, 6709.67404086740],
[0.00000000123, 3.61238958991, 22324.90505670940],
[0.00000000129, 4.92064308735, 2540.79130153440],
[0.00000000121, 6.16922638434, 20206.14119633100],
[0.00000000122, 5.79901866314, 1854.63230563460],
[0.00000000133, 0.50941998058, 3274.12501778540],
[0.00000000151, 1.61342807879, 1107.13880568480],
[0.00000000165, 2.02795177586, 290.48547946960],
[0.00000000125, 0.52719797619, 2604.73591316800],
[0.00000000144, 5.68526782434, 8827.39026987480],
[0.00000000126, 3.80246508251, 765.79306444640],
[0.00000000116, 1.79450246249, 647.01083331480],
[0.00000000126, 2.00195272473, 699.27114822760],
[0.00000000147, 6.22619740782, 6040.34724601740],
[0.00000000119, 2.05840518265, 15121.10278521600],
[0.00000000114, 2.74877091470, 6460.81221096080],
[0.00000000155, 1.78154091696, 21265.52312652020],
[0.00000000146, 3.37351237411, 1861.74585263540],
[0.00000000118, 4.07281676691, 418.50432280700],
[0.00000000116, 0.10434606071, 13362.38239649640],
[0.00000000129, 0.78419803719, 3427.92063123960],
[0.00000000152, 0.32620694442, 3443.70520091840],
[0.00000000110, 0.56398082486, 661.23292678100],
[0.00000000111, 4.05380946072, 568.82187402740],
[0.00000000108, 3.17700641574, 3448.27595063840],
[0.00000000138, 4.47698517191, 3326.38533269820],
[0.00000000108, 4.89922372003, 9588.12554222260],
[0.00000000114, 4.80828825403, 6657.34641565180],
[0.00000000108, 4.10637483972, 13553.89797291080],
[0.00000000125, 0.33573243959, 18849.22754997420],
[0.00000000115, 3.18885465852, 2409.24933984800],
[0.00000000104, 3.23074163851, 3472.15438838620],
[0.00000000104, 0.09799515047, 30065.51184029820],
[0.00000000112, 1.64487733528, 10001.06188460700],
[0.00000000143, 3.53781769283, 6518.75821726740],
[0.00000000113, 5.20979306912, 2125.87740737920],
[0.00000000104, 2.77582098882, 38.13303563780],
[0.00000000133, 5.88513337452, 5835.14201864840],
[0.00000000105, 4.11662579413, 6675.70192909220],
[0.00000000102, 0.60100887043, 10264.56588407340],
[0.00000000101, 3.78636130664, 10042.61267559180],
[0.00000000139, 1.80936944447, 12323.42309600880],
[0.00000000101, 2.47217208753, 7380.49600162720],
[0.00000000130, 2.53454569863, 11769.85369316640],
[0.00000000100, 5.72291104291, 14.22709400160],
[0.00000000135, 4.20237564510, 4672.66731424060],
[0.00000000133, 0.34413768012, 16489.76303806100],
[0.00000000098, 1.44874403589, 3370.04193523580],
[0.00000000131, 1.31336606248, 3313.21087060300],
[0.00000000111, 3.12463539337, 309.27832265580],
[0.00000000101, 3.15369992044, 24150.08005134500],
[0.00000000102, 6.13479937096, 2277.70737816160],
[0.00000000099, 0.10085261274, 12839.87228870540],
[0.00000000134, 2.91637947295, 57.87869600380],
[0.00000000104, 3.30283052330, 3399.98628861340],
[0.00000000108, 4.92699760221, 802.36392244620],
[0.00000000106, 2.89298330043, 7799.98064550240],
[0.00000000112, 3.12761163915, 5989.06725217280],
[0.00000000094, 3.42562596561, 3510.19260983280],
[0.00000000102, 0.94285421551, 3209.07046501340],
[0.00000000096, 0.79636181668, 3024.22055704320],
[0.00000000093, 1.08979608844, 14577.18472611980],
[0.00000000097, 3.56551535742, 14421.83163698840],
[0.00000000092, 5.02279637510, 2494.52959194860],
[0.00000000123, 5.83481108101, 7747.72033058960],
[0.00000000111, 3.31406538379, 11610.91017538320],
[0.00000000118, 5.00845322960, 1581.95934828300],
[0.00000000091, 2.36839307589, 11140.59307220220],
[0.00000000099, 2.93269536697, 2067.93140107260],
[0.00000000124, 3.15220420912, 22345.26037610820],
[0.00000000090, 0.85462370851, 17232.75309859360],
[0.00000000125, 1.54866979468, 1435.14766175940],
[0.00000000113, 4.57220387105, 14712.31711645800],
[0.00000000103, 0.11158194413, 11.04570026390],
[0.00000000113, 2.41110151532, 5244.04923920100],
[0.00000000091, 1.77184730280, 2221.85663459700],
[0.00000000114, 1.92696878615, 8226.57883637840],
[0.00000000118, 0.29322259611, 2945.98654164060],
[0.00000000089, 4.49875865671, 21947.11137270000],
[0.00000000104, 1.36766858693, 4032.77002792660],
[0.00000000116, 4.67476277278, 272.67295735160],
[0.00000000105, 3.73327973850, 4989.05918389720],
[0.00000000095, 0.34653808205, 13517.80279593060],
[0.00000000086, 2.70925448214, 7218.02936549500],
[0.00000000112, 5.27572276726, 17499.36014031540],
[0.00000000114, 3.37335971932, 2938.94030494260],
[0.00000000090, 0.26623024836, 9485.03276800400],
[0.00000000086, 3.66786582491, 6997.61672305620],
[0.00000000087, 4.07823608680, 18606.49894600020],
[0.00000000117, 5.61863859185, 16511.61386738740],
[0.00000000084, 2.80171829534, 8584.66166590080],
[0.00000000086, 5.87459621301, 73.60095591520],
[0.00000000090, 1.07789160729, 10721.10842832700],
[0.00000000084, 0.78729386249, 146.81168652360],
[0.00000000112, 2.31690430881, 9638.94074787620],
[0.00000000083, 5.90575201511, 16858.41522263039],
[0.00000000082, 4.31690557700, 9374.82644678460],
[0.00000000083, 1.41315204958, 22854.59602180400],
[0.00000000084, 0.90320571725, 2171.02417529120],
[0.00000000082, 1.59442952041, 9947.05568153210],
[0.00000000082, 0.44163602941, 4782.87363546000],
[0.00000000086, 5.18335054161, 12410.73130054860],
[0.00000000085, 3.61669636863, 8965.97846825920],
[0.00000000097, 5.35511765140, 4996.17273089800],
[0.00000000085, 2.36814442737, 1062.90504853820],
[0.00000000078, 1.75580354602, 2060.81785407180],
[0.00000000087, 0.98702744399, 10156.90236013480],
[0.00000000098, 0.35294347682, 23546.75362303080],
[0.00000000101, 1.03298143418, 20040.15144184979],
[0.00000000088, 0.56201084357, 17101.21113690720],
[0.00000000082, 2.65765057749, 12979.55317457600],
[0.00000000085, 1.07007237991, 10706.88133432540],
[0.00000000082, 0.80588396320, 20735.83216142559],
[0.00000000092, 4.87180501294, 9389.05354078620],
[0.00000000078, 3.22869264518, 11925.27409260060],
[0.00000000074, 5.59171946181, 8535.85715903420],
[0.00000000080, 0.42260849968, 956.28915597060],
[0.00000000082, 1.47379060963, 16.83220104979],
[0.00000000073, 3.76950560688, 8859.36257569160],
[0.00000000073, 4.59130182630, 362.12113673080],
[0.00000000072, 5.15373872266, 9872.27408296480],
[0.00000000098, 2.47740242208, 5401.43028077160],
[0.00000000071, 0.08395696279, 15849.86575174700],
[0.00000000078, 0.04212599783, 16703.12944380180],
[0.00000000075, 3.77172360793, 4845.90023579280],
[0.00000000072, 2.01742377451, 1329.51209026000],
[0.00000000076, 0.30413402871, 72.05573335480],
[0.00000000097, 5.15109318550, 1.48447270830],
[0.00000000070, 0.33648335823, 23141.55838292460],
[0.00000000068, 0.34828385806, 20047.19767854780],
[0.00000000078, 1.42772075938, 16063.16484718500],
[0.00000000081, 2.37498404818, 16703.04487984680],
[0.00000000069, 3.66727984195, 13363.43002786740],
[0.00000000067, 1.77194706681, 18451.07854656599],
[0.00000000073, 0.41181711796, 33406.12426699800],
[0.00000000067, 3.15946840380, 8799.98871377800],
[0.00000000067, 4.07602260745, 10448.43547097540],
[0.00000000068, 1.78981361818, 224.34479570190],
[0.00000000066, 1.01449371817, 4193.80880845180],
[0.00000000067, 4.89249339125, 12082.65513417120],
[0.00000000081, 0.61914094848, 949.17560896980],
[0.00000000066, 3.39914635235, 10184.30391623160],
[0.00000000064, 5.50528849889, 4936.79886898440],
[0.00000000064, 1.82608235490, 3077.52850332700],
[0.00000000069, 2.48571574894, 10018.24685144760],
[0.00000000064, 2.80447322320, 20809.46762464520],
[0.00000000068, 0.97907335430, 6717.25272007700],
[0.00000000087, 2.45966764758, 7321.12213971360],
[0.00000000062, 1.69131771765, 632.78373931320],
[0.00000000081, 4.40575713075, 16703.07938715119],
[0.00000000063, 3.63625395496, 25685.87280280800],
[0.00000000075, 5.54907590704, 16872.64231663200],
[0.00000000061, 0.33159827734, 12012.58229714040],
[0.00000000063, 3.16314818302, 11670.28403729680],
[0.00000000062, 0.23148800541, 7314.00859271280],
[0.00000000078, 1.65377731167, 11614.43329373220],
[0.00000000068, 1.10866475394, 6155.05700665400],
[0.00000000068, 4.45713540461, 9175.75444534820],
[0.00000000081, 3.66553577428, 15265.88651930040],
[0.00000000068, 5.59792852411, 377.37360791580],
[0.00000000059, 6.25689995147, 41427.48698317880],
[0.00000000072, 3.39739853142, 685.11136452880],
[0.00000000062, 0.11206359088, 14047.49376102520],
[0.00000000057, 4.31819630987, 95.97922721780],
[0.00000000070, 5.98596344975, 6531.66165626500],
[0.00000000066, 5.93804470886, 3490.17562383440],
[0.00000000056, 5.11205539684, 7322.10246078180],
[0.00000000056, 3.36788837326, 4379.63903749020],
[0.00000000056, 2.20908914878, 6688.27109009760],
[0.00000000057, 4.57828186723, 10037.08975128440],
[0.00000000057, 0.04695703833, 24889.57479599160],
[0.00000000065, 2.70973517401, 19617.07636932279],
[0.00000000068, 3.51423189318, 14556.89671702380],
[0.00000000056, 5.94452825242, 21548.96236929180],
[0.00000000056, 3.94541346495, 25665.51748340920],
[0.00000000055, 0.45166365461, 16702.99482319620],
[0.00000000062, 0.05229160039, 14061.72085502680],
[0.00000000055, 1.14774475393, 4459.36821880260],
[0.00000000065, 6.21442820689, 6947.83189512140],
[0.00000000056, 5.01712943722, 485.97205278960],
[0.00000000065, 1.51615558729, 5511.63660199100],
[0.00000000072, 4.90742373357, 25287.72379939980],
[0.00000000057, 5.31542907454, 28628.33622609960],
[0.00000000055, 4.02023620788, 4005.36847182980],
[0.00000000054, 5.51196184505, 44.65383324020],
[0.00000000053, 0.46840976995, 19645.52555679060],
[0.00000000053, 4.51539970261, 9886.77220006400],
[0.00000000069, 3.37092084432, 41.55079098480],
[0.00000000072, 4.66520155151, 6685.10618875760],
[0.00000000052, 2.05209599225, 7366.26890762560],
[0.00000000052, 6.25882226723, 12509.25332504720],
[0.00000000060, 0.33350021257, 13575.74880223720],
[0.00000000059, 5.94433755684, 625.67019231240],
[0.00000000050, 2.65624501709, 10124.93005431800],
[0.00000000068, 2.92105834159, 10025.42770875120],
[0.00000000051, 2.88289068067, 39601.89191244960],
[0.00000000069, 1.09637075565, 24076.44458812540],
[0.00000000052, 2.65290577481, 15650.79375031060],
[0.00000000052, 3.28683313010, 6756.00645196690],
[0.00000000054, 5.34683925496, 6578.13207918100],
[0.00000000054, 2.77410607136, 6705.10329114740],
[0.00000000049, 2.65700209900, 6944.30877677240],
[0.00000000053, 5.67436244967, 1883.08149310240],
[0.00000000048, 5.68336050679, 8646.06348025360],
[0.00000000051, 0.11390643300, 17402.33328172660],
[0.00000000065, 1.03099992649, 4106.40549114620],
[0.00000000060, 1.00159365247, 151.89728108520],
[0.00000000050, 3.84651247899, 45494.58142974879],
[0.00000000047, 3.03959709242, 5408.54382777240],
[0.00000000063, 4.16165369755, 8186.51266249260],
[0.00000000046, 2.69368087378, 16547.64173406480],
[0.00000000051, 2.99576014378, 3774.32416457660],
[0.00000000044, 2.00664763411, 6418.14093002680],
[0.00000000045, 4.01853755929, 19406.67828817460],
[0.00000000058, 3.14474753550, 4025.65648092580],
[0.00000000050, 2.59881540437, 6621.85099148600],
[0.00000000043, 4.87912487459, 6414.61781167780],
[0.00000000042, 5.20400092044, 4447.75123238460],
[0.00000000051, 1.99634375899, 5032.77809620220],
[0.00000000043, 1.28813888865, 6643.09181776180],
[0.00000000040, 0.96801618560, 14591.41182012140],
[0.00000000039, 1.84985100829, 10001.48196070061],
[0.00000000039, 5.69967200167, 6106.88005506480],
[0.00000000038, 3.27498743518, 18052.92954315780],
[0.00000000039, 2.84167905068, 6652.77566593180],
[0.00000000044, 0.57891618854, 16865.52876963120],
[0.00000000043, 4.61937364869, 3341.03250279340],
[0.00000000042, 6.02555835659, 6691.86151874940],
[0.00000000034, 4.97734992350, 6670.58818804980],
[0.00000000033, 1.39167727215, 4825.54491639400],
[0.00000000035, 6.02955363644, 3568.08855948880],
[0.00000000035, 0.31961016732, 6645.19698672220],
[0.00000000032, 5.63043769073, 3511.28529731900],
[0.00000000031, 5.42978464210, 9945.57120882380],
[0.00000000038, 5.66461657503, 3416.87849797540],
[0.00000000030, 0.98518793666, 20426.57109242200],
[0.00000000038, 0.12870962242, 6604.95878212400],
[0.00000000037, 5.48374357342, 3311.18291816379],
[0.00000000032, 6.11106979810, 4392.88080988820],
[0.00000000031, 3.18481282781, 3341.04230982650],
[0.00000000034, 2.32358226279, 9072.66167112960],
[0.00000000039, 4.11042361929, 3312.16323923200],
[0.00000000027, 0.57810321636, 3391.89276456221],
[0.00000000029, 2.48646403166, 9815.65173166220],
[0.00000000031, 0.44265747667, 3451.79906898740],
[0.00000000027, 6.13498177783, 3362.46325602620],
[0.00000000027, 6.21846173482, 5223.69391980220],
[0.00000000027, 2.94945830517, 7203.80227149340],
[0.00000000027, 3.26179855800, 8756.26980147300],
[0.00000000027, 3.94385271700, 23958.63178523340],
[0.00000000033, 3.77237326006, 12808.88030395680],
[0.00000000030, 4.75096367323, 15906.76412668260],
[0.00000000031, 0.88248871193, 3340.18254357310],
[0.00000000025, 0.31303295413, 6571.01853218020],
[0.00000000031, 4.29076841627, 10020.85695903120],
[0.00000000026, 2.22427360058, 10050.28646756720],
[0.00000000025, 0.67881122439, 23937.85638974100],
[0.00000000031, 1.72899093511, 13745.34623902240],
[0.00000000024, 0.20355912395, 3229.42578441220],
[0.00000000032, 3.37195631109, 2284.75361485960],
], [
[0.00058015791, 2.04979463279, 3340.61242669980],
[0.00054187645, 0.00000000000, 0.00000000000],
[0.00013908426, 2.45742359888, 6681.22485339960],
[0.00002465104, 2.80000020929, 10021.83728009940],
[0.00000398379, 3.14118428289, 13362.44970679920],
[0.00000222022, 3.19436080019, 3.52311834900],
[0.00000120957, 0.54325292454, 155.42039943420],
[0.00000061517, 3.48529427371, 16703.06213349900],
[0.00000053638, 3.54191121461, 3344.13554504880],
[0.00000034268, 6.00188499119, 2281.23049651060],
[0.00000031665, 4.14015171788, 191.44826611160],
[0.00000029839, 1.99870679845, 796.29800681640],
[0.00000023168, 4.33403365928, 242.72860397400],
[0.00000021659, 3.44532466378, 398.14900340820],
[0.00000016044, 6.11000472441, 2146.16541647520],
[0.00000020370, 5.42191375400, 553.56940284240],
[0.00000014927, 6.09541783564, 3185.19202726560],
[0.00000016227, 0.65678953303, 0.98032106820],
[0.00000014317, 2.61851897591, 1349.86740965880],
[0.00000014416, 4.01923812101, 951.71840625060],
[0.00000011934, 3.86122163021, 6684.74797174860],
[0.00000015648, 1.22086121940, 1748.01641306700],
[0.00000011260, 4.71822363671, 2544.31441988340],
[0.00000013352, 0.60189008414, 1194.44701022460],
[0.00000010396, 0.25038714677, 382.89653222320],
[0.00000009468, 0.68170713564, 1059.38193018920],
[0.00000009229, 3.83209092321, 20043.67456019880],
[0.00000009005, 3.88271826102, 3738.76143010800],
[0.00000007501, 5.46498630412, 1751.53953141600],
[0.00000006497, 5.47773072872, 1592.59601363280],
[0.00000006311, 2.34104793674, 3097.88382272579],
[0.00000006859, 2.57522504136, 3149.16416058820],
[0.00000005870, 1.14783576679, 7.11354700080],
[0.00000006681, 2.37843690339, 4136.91043351620],
[0.00000004647, 4.42957708526, 6151.53388830500],
[0.00000004166, 3.68631477611, 5614.72937620960],
[0.00000004764, 2.89684755585, 3333.49887969900],
[0.00000004045, 6.12493402657, 5628.95647021120],
[0.00000003653, 4.06679068397, 1990.74501704100],
[0.00000003618, 2.46868561769, 529.69096509460],
[0.00000003277, 0.68101740787, 8962.45534991020],
[0.00000003253, 2.79565340390, 3894.18182954220],
[0.00000003091, 4.56861203364, 3496.03282613400],
[0.00000002921, 5.41458945995, 2914.01423582380],
[0.00000002921, 1.23050883841, 2787.04302385740],
[0.00000002784, 1.38911141844, 4292.33083295040],
[0.00000002620, 1.04061894134, 3341.59274776800],
[0.00000002888, 3.41062353663, 3337.08930835080],
[0.00000002418, 0.96341462666, 4535.05943692440],
[0.00000002357, 4.84628239765, 9492.14631500480],
[0.00000002593, 5.74934234498, 3340.59517304760],
[0.00000002191, 3.26449527357, 213.29909543800],
[0.00000002594, 1.49510566123, 3340.62968035200],
[0.00000002344, 4.18104725028, 10025.36039844840],
[0.00000002630, 4.67640929857, 3583.34103067380],
[0.00000002602, 2.64911714813, 2388.89402044920],
[0.00000001830, 0.97181050149, 1589.07289528380],
[0.00000002416, 1.04749173375, 4399.99435688900],
[0.00000002386, 4.27072575550, 7079.37385680780],
[0.00000002187, 0.16036551231, 6525.80445396540],
[0.00000002344, 0.01425578204, 4690.47983635860],
[0.00000001617, 4.95614491689, 5088.62883976680],
[0.00000001633, 1.10703599922, 12303.06777661000],
[0.00000002126, 0.48290227706, 2700.71514038580],
[0.00000001629, 4.94267977718, 1221.84856632140],
[0.00000001504, 0.11031912519, 2957.71589447660],
[0.00000001759, 3.81170701376, 3723.50895892300],
[0.00000001401, 3.85907867678, 6283.07584999140],
[0.00000001338, 5.29685392418, 6677.70173505060],
[0.00000001763, 2.51660121293, 2810.92146160520],
[0.00000001392, 2.73498041122, 7477.52286021600],
[0.00000001431, 2.97747408389, 6489.77658728800],
[0.00000001236, 3.77245965590, 2699.73481931760],
[0.00000001234, 1.88931735265, 6681.24210705180],
[0.00000001513, 2.92614134711, 640.87760738220],
[0.00000001234, 6.14168429036, 6681.20759974740],
[0.00000001408, 1.54395721611, 3347.72597370060],
[0.00000001038, 5.82880072933, 4933.20844033260],
[0.00000001156, 1.50825464304, 426.59819087600],
[0.00000001362, 4.17794297520, 23384.28698689860],
[0.00000001135, 3.77506455273, 3870.30339179440],
[0.00000000916, 3.81726339298, 5092.15195811580],
[0.00000000853, 3.82520490669, 3340.54511639700],
[0.00000001077, 5.05062828760, 5621.84292321040],
[0.00000001074, 3.81446920470, 3553.91152213780],
[0.00000000847, 3.41702696402, 3340.67973700260],
[0.00000000920, 1.91108056416, 3532.06069281140],
[0.00000000738, 4.25786145387, 9623.68827669120],
[0.00000000908, 4.12911006922, 162.46663613220],
[0.00000000647, 3.10301033831, 7234.79425624200],
[0.00000000800, 5.20674574801, 87.30820453981],
[0.00000000657, 1.57895580467, 2487.41604494780],
[0.00000000650, 2.78932995437, 574.34479833480],
[0.00000000659, 5.16655918817, 12832.75874170460],
[0.00000000712, 5.79288230676, 3339.63210563160],
[0.00000000660, 0.25125103909, 8969.56889691100],
[0.00000000527, 4.62218528897, 10419.98628350760],
[0.00000000607, 3.84724721085, 5486.77784317500],
[0.00000000500, 4.66323134619, 6836.64525283380],
[0.00000000509, 0.32548381735, 8031.09226305840],
[0.00000000613, 1.72250879737, 7632.94325965020],
[0.00000000516, 1.37906978509, 7740.60678358880],
[0.00000000469, 1.31324778369, 7875.67186362420],
[0.00000000442, 5.34515135225, 10018.31416175040],
[0.00000000496, 4.49656852602, 692.15760122680],
[0.00000000544, 1.44465369200, 15643.68020330980],
[0.00000000467, 1.40928870138, 6682.20517446780],
[0.00000000547, 4.42021065522, 5331.35744374080],
[0.00000000433, 1.25048504108, 4929.68532198360],
[0.00000000409, 3.80689273098, 6681.29216370240],
[0.00000000403, 1.57190239310, 6127.65545055720],
[0.00000000401, 4.59976459753, 7210.91581849420],
[0.00000000406, 0.60945437905, 11773.37681151540],
[0.00000000367, 0.97726583907, 6041.32756708560],
[0.00000000361, 0.13117924893, 639.89728631400],
[0.00000000411, 4.21323421517, 6681.15754309680],
[0.00000000441, 4.49050100878, 13365.97282514820],
[0.00000000474, 5.18562524130, 2301.58581590939],
[0.00000000334, 2.21001303889, 10021.85453375160],
[0.00000000370, 5.02880065186, 6923.95345737360],
[0.00000000333, 0.18229887483, 10021.82002644720],
[0.00000000342, 2.49988747611, 6438.49624942560],
[0.00000000320, 1.32374476890, 2118.76386037840],
[0.00000000330, 2.98027481579, 5729.50644714900],
[0.00000000340, 0.51409045792, 9866.41688066520],
[0.00000000283, 4.03219455446, 8955.34180290940],
[0.00000000281, 3.33891891806, 9830.38901398780],
[0.00000000271, 1.53144358045, 1039.02661079040],
[0.00000000252, 3.04356928941, 10818.13528691580],
[0.00000000270, 2.22972724035, 5828.02847164760],
[0.00000000259, 4.24406546278, 6894.52394883760],
[0.00000000237, 5.07818982743, 8429.24126646660],
[0.00000000263, 2.00552313665, 3767.21061757580],
[0.00000000241, 4.06396704332, 7064.12138562280],
[0.00000000250, 0.45422818547, 6298.32832117640],
[0.00000000240, 1.94655459341, 6688.33840040040],
[0.00000000209, 0.03043017984, 3914.95722503460],
[0.00000000218, 4.53201818250, 26724.89941359840],
[0.00000000246, 3.85272742042, 4562.46099302120],
[0.00000000254, 1.19313236635, 8432.76438481560],
[0.00000000231, 1.70340106651, 2942.46342329160],
[0.00000000209, 3.82345999055, 6467.92575796160],
[0.00000000175, 3.26444055581, 3981.49003408200],
[0.00000000210, 3.55052707697, 10575.40668294180],
[0.00000000162, 5.95176683701, 310.84079886840],
[0.00000000165, 5.04267055142, 10177.25767953360],
[0.00000000198, 0.80464315638, 15113.98923821520],
[0.00000000188, 1.99007233842, 3127.31333126180],
[0.00000000188, 4.55406803143, 12964.30070339100],
[0.00000000163, 2.14874886056, 10973.55568635000],
[0.00000000154, 4.35708331036, 3360.96774609859],
[0.00000000169, 2.40504327781, 3355.86489788480],
[0.00000000164, 5.53875620970, 16173.37116840440],
[0.00000000144, 0.30186831602, 1903.43681250120],
[0.00000000161, 3.18977924032, 6674.11130639880],
[0.00000000135, 1.65570006128, 3325.35995551480],
[0.00000000143, 6.25825818399, 9595.23908922340],
[0.00000000158, 6.14255608340, 8273.82086703240],
[0.00000000170, 5.98413937993, 3320.25710730100],
[0.00000000124, 1.74571336137, 11081.21921028860],
[0.00000000146, 2.22851709304, 3178.14579056760],
[0.00000000126, 5.02927593525, 3475.67750673520],
[0.00000000123, 4.99342648375, 13760.59871020740],
[0.00000000141, 4.56735815490, 10021.76996979660],
[0.00000000118, 5.42945437851, 13358.92658845020],
[0.00000000116, 4.22080571309, 5884.92684658320],
[0.00000000119, 4.09962692144, 10021.90459040220],
[0.00000000124, 1.79723243306, 18984.29263000960],
[0.00000000135, 1.00085140609, 18454.60166491500],
[0.00000000106, 5.76342924005, 2288.34404351140],
[0.00000000103, 0.63812052706, 12310.18132361080],
[0.00000000100, 4.37946945260, 9808.53818466140],
[0.00000000104, 4.01151451052, 13916.01910964160],
[0.00000000125, 4.94825577002, 10551.52824519400],
[0.00000000098, 5.91086068785, 14584.29827312060],
[0.00000000126, 1.55752034021, 8270.29774868340],
[0.00000000098, 2.52869810530, 3191.04922956520],
[0.00000000095, 5.50808311620, 3319.83703120740],
[0.00000000108, 1.67115668669, 11216.28429032400],
[0.00000000090, 1.71281301325, 1505.28780909299],
[0.00000000088, 0.42472333366, 11371.70468975820],
[0.00000000089, 4.83867235269, 16706.58525184800],
[0.00000000106, 1.78998252916, 10022.81760116760],
[0.00000000087, 5.89602688150, 16858.48253293320],
[0.00000000085, 0.55423657166, 13362.43245314700],
[0.00000000091, 1.61117547913, 24093.27678917520],
[0.00000000083, 0.55328893146, 3344.20285535160],
[0.00000000083, 1.06830368571, 3364.49086444760],
[0.00000000084, 6.22980173043, 3369.06161416760],
[0.00000000085, 2.58442459869, 13362.46696045140],
[0.00000000079, 3.08636079495, 2818.03500860600],
[0.00000000077, 1.53791408869, 5459.37628707820],
[0.00000000075, 3.34890581175, 9070.11887384880],
[0.00000000097, 2.99973987655, 3316.73398895200],
[0.00000000084, 5.55309637085, 3427.92063123960],
[0.00000000089, 4.16432726564, 6158.64743530580],
[0.00000000078, 3.72375730390, 13171.00144068760],
[0.00000000083, 0.11917380846, 3337.02199804800],
[0.00000000073, 4.91632010974, 13362.38239649640],
[0.00000000076, 4.52961122356, 708.98980227659],
[0.00000000071, 5.37905772348, 10264.56588407340],
[0.00000000084, 1.93007660929, 9468.26787725700],
[0.00000000073, 5.28498987702, 4845.90023579280],
[0.00000000080, 4.81193020727, 13149.15061136120],
[0.00000000076, 4.77873149036, 8671.96987044060],
[0.00000000069, 0.86312560839, 13207.02930736500],
[0.00000000070, 1.22001285505, 2274.11694950980],
[0.00000000070, 0.53977528244, 13119.72110282519],
[0.00000000070, 0.09801356525, 1437.17561419860],
[0.00000000069, 2.23597403243, 7107.82304427560],
[0.00000000074, 0.67876411085, 16460.33352952499],
[0.00000000068, 0.54393617190, 12935.85151592320],
[0.00000000084, 5.11617356640, 13892.14067189380],
[0.00000000078, 5.27206373031, 853.19638175200],
[0.00000000065, 4.74504626032, 6144.42034130420],
[0.00000000065, 2.89744951086, 7903.07341972100],
[0.00000000089, 5.44755326514, 13517.87010623340],
[0.00000000073, 3.81554166604, 3503.07906283200],
[0.00000000066, 0.47312197978, 3980.50971301380],
[0.00000000065, 1.38901912957, 3253.30422216000],
[0.00000000086, 5.44050231013, 6816.28993343500],
[0.00000000072, 3.44697351738, 14158.74771361560],
[0.00000000086, 4.50213985772, 13362.51701710200],
[0.00000000074, 1.34701853675, 3361.38782219220],
[0.00000000076, 6.04002959430, 5085.03841111500],
[0.00000000065, 0.07623776004, 5099.26550511660],
[0.00000000066, 2.09160717290, 14421.83163698840],
[0.00000000077, 2.75740817982, 19402.79695281660],
[0.00000000059, 3.61679189501, 7322.10246078180],
[0.00000000060, 4.67079289372, 10235.13637553740],
[0.00000000064, 6.17220244155, 9381.93999378540],
[0.00000000066, 0.35824154106, 7255.56965173440],
[0.00000000059, 4.52818219212, 9499.25986200560],
[0.00000000065, 1.86765892646, 11610.91017538320],
[0.00000000074, 3.12276411101, 1107.13880568480],
[0.00000000060, 1.35069679183, 19800.94595622480],
[0.00000000055, 0.64581579779, 6677.63442474780],
[0.00000000055, 0.65206957868, 7373.38245462640],
[0.00000000055, 0.41979092764, 9779.10867612540],
[0.00000000074, 3.85276242820, 2766.26762836500],
[0.00000000056, 2.49261586879, 5642.19824260920],
[0.00000000055, 2.62555306434, 14314.16811304980],
[0.00000000054, 3.95212835807, 4032.77002792660],
[0.00000000055, 0.51062350773, 15110.46611986620],
[0.00000000053, 5.88757767795, 21265.52312652020],
[0.00000000051, 5.99253934388, 21947.11137270000],
[0.00000000049, 5.16723732129, 20047.19767854780],
[0.00000000067, 1.53758821512, 9380.95967271720],
[0.00000000057, 5.34893894346, 17101.21113690720],
[0.00000000049, 1.92678602770, 12721.57209941700],
[0.00000000046, 2.31590320480, 10028.95082710020],
[0.00000000052, 4.92463460288, 16304.91313009080],
[0.00000000050, 1.69803302925, 9225.53927328300],
[0.00000000045, 2.91271003676, 8982.81066930900],
[0.00000000044, 4.38728556203, 12168.00269657460],
[0.00000000047, 4.44933635857, 6872.67311951120],
[0.00000000043, 2.13295656057, 22324.90505670940],
[0.00000000050, 1.34759191325, 8439.87793181640],
[0.00000000044, 0.89037464728, 20752.66436247540],
[0.00000000041, 2.76164156557, 6696.47732458460],
[0.00000000042, 4.45031185062, 10404.73381232260],
[0.00000000044, 3.20262780268, 22743.40937951640],
[0.00000000042, 3.54559408987, 30376.35263916660],
[0.00000000042, 0.82118836477, 20597.24396304120],
[0.00000000052, 4.59037852162, 22345.26037610820],
[0.00000000042, 3.79872109079, 28628.33622609960],
[0.00000000041, 2.36253602080, 16062.18452611680],
[0.00000000050, 1.48377570574, 6040.34724601740],
[0.00000000041, 5.33088551342, 765.79306444640],
[0.00000000039, 1.57984331116, 24889.57479599160],
[0.00000000038, 0.21571600948, 9168.64089834740],
[0.00000000038, 3.47667842127, 1066.49547719000],
[0.00000000052, 0.81427285458, 9638.94074787620],
[0.00000000041, 0.04356010851, 6660.86953400080],
[0.00000000046, 0.89345529755, 16703.04487984680],
[0.00000000044, 0.85335841824, 17468.85519794540],
[0.00000000039, 0.27098916103, 11614.43329373220],
[0.00000000036, 3.93388136028, 33716.96506586640],
[0.00000000047, 3.90896957151, 5244.04923920100],
[0.00000000034, 2.37310468308, 10213.28554621100],
[0.00000000034, 4.85454495742, 14469.58851248400],
[0.00000000035, 1.96497348634, 6702.00024889200],
[0.00000000033, 2.14488758889, 13363.43002786740],
[0.00000000046, 2.92422266239, 16703.07938715119],
[0.00000000035, 1.78692835372, 2648.45482547300],
[0.00000000033, 4.24484480826, 8584.66166590080],
[0.00000000043, 6.09391349922, 6660.44945790720],
[0.00000000035, 5.72426647579, 16699.53901514999],
[0.00000000031, 1.95254273311, 6665.97238221460],
[0.00000000028, 5.88548900893, 19513.98359510420],
[0.00000000030, 4.38908125588, 12295.95422960920],
[0.00000000029, 6.25276686131, 17924.91069982040],
[0.00000000025, 4.89000247975, 30065.51184029820],
[0.00000000026, 2.43119321236, 6518.75821726740],
[0.00000000028, 3.97032105354, 4407.10790388980],
[0.00000000025, 1.88631752737, 4379.63903749020],
[0.00000000028, 3.06196380356, 6247.51311552280],
[0.00000000029, 5.98057498931, 6680.24453233140],
[0.00000000032, 4.65556810177, 6701.58017279840],
[0.00000000026, 0.76018385758, 3863.18984479360],
[0.00000000023, 0.31107548102, 8827.39026987480],
[0.00000000022, 1.11553014451, 6684.81528205140],
[0.00000000020, 4.81193192299, 15508.61512327440],
[0.00000000019, 5.11656455993, 12012.58229714040],
[0.00000000026, 1.07254469525, 8425.65083781480],
[0.00000000021, 2.68436255141, 6261.74020952440],
[0.00000000022, 2.15631095909, 3335.08950239240],
[0.00000000017, 0.03684125273, 3877.41693879520],
[0.00000000017, 2.84467149903, 3344.49376205780],
[0.00000000020, 5.41519706836, 3205.54734666440],
], [
[0.00001482423, 0.44434694876, 3340.61242669980],
[0.00000662095, 0.88469178686, 6681.22485339960],
[0.00000188268, 1.28799982497, 10021.83728009940],
[0.00000041474, 1.64850786997, 13362.44970679920],
[0.00000022661, 2.05267665262, 155.42039943420],
[0.00000025994, 0.00000000000, 0.00000000000],
[0.00000008024, 1.99858757687, 16703.06213349900],
[0.00000010454, 1.58006906385, 3.52311834900],
[0.00000004900, 2.82452457966, 242.72860397400],
[0.00000003782, 2.01914272515, 3344.13554504880],
[0.00000003176, 4.59144897927, 3185.19202726560],
[0.00000003134, 0.65044714325, 553.56940284240],
[0.00000001684, 5.53835848782, 951.71840625060],
[0.00000001511, 5.71795850828, 191.44826611160],
[0.00000001448, 0.45869142895, 796.29800681640],
[0.00000001442, 2.34368495577, 20043.67456019880],
[0.00000001302, 5.36284013048, 0.98032106820],
[0.00000001169, 4.14601161433, 1349.86740965880],
[0.00000001133, 2.38180830662, 6684.74797174860],
[0.00000001037, 1.76892750558, 382.89653222320],
[0.00000000894, 5.33688328934, 1194.44701022460],
[0.00000000807, 2.74798886181, 1748.01641306700],
[0.00000000640, 6.10665147849, 3496.03282613400],
[0.00000000558, 1.85212342360, 398.14900340820],
[0.00000000567, 5.85922384979, 7.11354700080],
[0.00000000647, 3.17645475605, 3583.34103067380],
[0.00000000452, 5.98109989317, 2787.04302385740],
[0.00000000508, 1.01139298015, 3149.16416058820],
[0.00000000519, 4.93376176788, 6525.80445396540],
[0.00000000405, 1.27295444059, 2281.23049651060],
[0.00000000399, 2.32888685659, 3738.76143010800],
[0.00000000472, 0.84411483892, 4136.91043351620],
[0.00000000333, 5.42704539231, 1059.38193018920],
[0.00000000313, 3.70599897858, 3097.88382272579],
[0.00000000281, 5.74581724084, 3341.59274776800],
[0.00000000287, 2.69304799864, 10025.36039844840],
[0.00000000237, 5.68519881994, 4535.05943692440],
[0.00000000215, 2.49494803822, 1990.74501704100],
[0.00000000260, 2.67996877129, 23384.28698689860],
[0.00000000269, 1.10390153866, 2388.89402044920],
[0.00000000186, 4.86408411823, 2957.71589447660],
[0.00000000176, 3.86618588087, 1592.59601363280],
[0.00000000177, 0.85374318134, 3894.18182954220],
[0.00000000191, 4.58805692093, 3337.08930835080],
[0.00000000185, 5.80899316550, 4399.99435688900],
[0.00000000143, 1.15592612974, 7477.52286021600],
[0.00000000173, 2.70622920014, 7079.37385680780],
[0.00000000146, 1.37569151302, 6489.77658728800],
[0.00000000121, 3.24333934982, 9492.14631500480],
[0.00000000116, 5.71639819530, 12303.06777661000],
[0.00000000111, 2.69566947038, 6151.53388830500],
[0.00000000103, 3.53587741373, 6923.95345737360],
[0.00000000097, 5.23712981002, 8962.45534991020],
[0.00000000089, 0.05951324220, 6127.65545055720],
[0.00000000093, 5.29818155587, 9866.41688066520],
[0.00000000084, 5.68544044325, 4292.33083295040],
[0.00000000091, 6.16223680965, 6682.20517446780],
[0.00000000081, 4.32723330620, 4933.20844033260],
[0.00000000077, 5.63189824170, 1589.07289528380],
[0.00000000102, 6.26937663026, 3347.72597370060],
[0.00000000076, 3.05724276091, 13365.97282514820],
[0.00000000063, 3.12770931753, 10419.98628350760],
[0.00000000062, 1.45647168723, 7234.79425624200],
[0.00000000069, 4.82266605869, 6677.70173505060],
[0.00000000064, 1.73713448446, 3870.30339179440],
[0.00000000058, 4.85723088492, 5486.77784317500],
[0.00000000058, 6.09849516790, 7875.67186362420],
[0.00000000063, 4.14716431158, 3340.59517304760],
[0.00000000065, 6.17932665318, 3340.62968035200],
[0.00000000057, 1.48905992502, 5729.50644714900],
[0.00000000060, 6.08710604997, 7740.60678358880],
[0.00000000056, 1.96253427165, 3553.91152213780],
[0.00000000059, 0.89874385953, 3339.63210563160],
[0.00000000053, 3.04776975379, 26724.89941359840],
[0.00000000061, 3.63390789623, 12832.75874170460],
[0.00000000059, 0.22989746040, 6681.24210705180],
[0.00000000053, 3.97996929188, 5092.15195811580],
[0.00000000059, 4.48255178273, 6681.20759974740],
[0.00000000045, 3.88055745121, 10264.56588407340],
[0.00000000058, 4.85371375265, 5621.84292321040],
[0.00000000049, 4.03623343126, 16173.37116840440],
[0.00000000061, 2.90942510134, 5331.35744374080],
[0.00000000043, 1.80990718340, 9830.38901398780],
[0.00000000044, 4.10828944542, 4690.47983635860],
[0.00000000044, 3.49332765553, 13760.59871020740],
[0.00000000048, 1.81207342615, 3723.50895892300],
[0.00000000041, 1.59906754314, 10818.13528691580],
[0.00000000041, 2.05797417369, 6681.29216370240],
[0.00000000038, 3.38619280993, 16706.58525184800],
[0.00000000041, 2.53336616026, 6681.15754309680],
[0.00000000041, 1.79026132252, 3340.54511639700],
[0.00000000050, 4.70324784090, 8273.82086703240],
[0.00000000037, 3.37898394417, 30065.51184029820],
[0.00000000039, 2.65566008587, 6894.52394883760],
[0.00000000035, 2.58475025674, 9623.68827669120],
[0.00000000037, 6.07442797404, 4929.68532198360],
[0.00000000042, 3.04642561189, 12964.30070339100],
[0.00000000037, 5.23784488646, 6298.32832117640],
[0.00000000043, 6.17835198533, 15643.68020330980],
[0.00000000034, 2.44806511268, 7210.91581849420],
[0.00000000038, 0.26295105909, 10022.81760116760],
[0.00000000028, 0.74281728305, 10021.85453375160],
[0.00000000028, 4.99536302577, 10021.82002644720],
[0.00000000034, 5.04118058624, 8969.56889691100],
[0.00000000025, 2.59849002421, 8955.34180290940],
[0.00000000030, 1.14354290938, 2146.16541647520],
[0.00000000027, 0.26980783576, 18984.29263000960],
[0.00000000025, 0.39810308575, 6688.33840040040],
[0.00000000024, 5.64558695441, 13207.02930736500],
[0.00000000027, 6.24398988438, 5088.62883976680],
[0.00000000024, 0.25455613132, 11081.21921028860],
[0.00000000023, 0.53673547304, 3333.49887969900],
[0.00000000024, 1.80155161992, 6674.11130639880],
[0.00000000029, 4.39953507920, 10018.31416175040],
[0.00000000023, 2.91040060956, 10551.52824519400],
[0.00000000022, 1.20895727897, 529.69096509460],
[0.00000000026, 0.08254324904, 7632.94325965020],
[0.00000000026, 1.81668969835, 6283.07584999140],
[0.00000000021, 0.67232850824, 6836.64525283380],
[0.00000000017, 5.19518401928, 2914.01423582380],
[0.00000000017, 5.16488977775, 8031.09226305840],
[0.00000000021, 3.62973082412, 5884.92684658320],
[0.00000000018, 5.06870872024, 2544.31441988340],
[0.00000000014, 2.50522181917, 7064.12138562280],
[0.00000000017, 0.41835598950, 9468.26787725700],
[0.00000000011, 2.21363101654, 6438.49624942560],
[0.00000000013, 1.38424462832, 3340.67973700260],
[0.00000000012, 3.28248484262, 8671.96987044060],
[0.00000000014, 0.23027665815, 3767.21061757580],
], [
[0.00000113969, 3.14159265359, 0.00000000000],
[0.00000028725, 5.63662412043, 6681.22485339960],
[0.00000024447, 5.13868481454, 3340.61242669980],
[0.00000011187, 6.03161074431, 10021.83728009940],
[0.00000003190, 3.56267988299, 155.42039943420],
[0.00000003252, 0.13228350651, 13362.44970679920],
[0.00000000787, 0.49340783377, 16703.06213349900],
[0.00000000776, 1.31734531594, 242.72860397400],
[0.00000000494, 3.06356214498, 3185.19202726560],
[0.00000000374, 2.15785846355, 553.56940284240],
[0.00000000331, 6.23159792887, 3.52311834900],
[0.00000000197, 0.44350153983, 3344.13554504880],
[0.00000000181, 0.81531283571, 20043.67456019880],
[0.00000000168, 3.73509781785, 3496.03282613400],
[0.00000000086, 0.79259553758, 6684.74797174860],
[0.00000000115, 1.66898531261, 3583.34103067380],
[0.00000000092, 3.40530361815, 6525.80445396540],
[0.00000000064, 4.47443580658, 2787.04302385740],
[0.00000000045, 5.17216217058, 3097.88382272579],
[0.00000000041, 1.21875027733, 23384.28698689860],
[0.00000000036, 5.53975653407, 3149.16416058820],
[0.00000000039, 5.40966345885, 4136.91043351620],
[0.00000000028, 4.85378781404, 6127.65545055720],
[0.00000000027, 0.42811091036, 3738.76143010800],
[0.00000000032, 1.22337093927, 10025.36039844840],
[0.00000000025, 1.56348878811, 26724.89941359840],
[0.00000000029, 2.40178626971, 3894.18182954220],
[0.00000000023, 4.16371253947, 3341.59274776800],
[0.00000000022, 5.98429191667, 7477.52286021600],
[0.00000000019, 2.03228980685, 6923.95345737360],
[0.00000000020, 3.79275573433, 9866.41688066520],
[0.00000000021, 4.27532111122, 6836.64525283380],
[0.00000000015, 1.56315497374, 13365.97282514820],
[0.00000000011, 1.33261955275, 2281.23049651060],
[0.00000000009, 6.15390464542, 6489.77658728800],
[0.00000000007, 4.23894194106, 4535.05943692440],
], [
[0.00000000710, 4.04089996521, 6681.22485339960],
[0.00000000868, 3.14159265359, 0.00000000000],
[0.00000000510, 4.49214901625, 10021.83728009940],
[0.00000000357, 5.07435505061, 155.42039943420],
[0.00000000223, 3.51351884241, 3340.61242669980],
[0.00000000199, 4.85313666795, 13362.44970679920],
[0.00000000100, 6.09089356066, 242.72860397400],
[0.00000000069, 5.19017483537, 16703.06213349900],
[0.00000000064, 1.55783055571, 3185.19202726560],
[0.00000000035, 3.68246171643, 553.56940284240],
[0.00000000025, 5.22079788019, 3496.03282613400],
[0.00000000024, 0.17861991485, 3583.34103067380],
[0.00000000019, 5.59184714460, 20043.67456019880],
[0.00000000014, 5.95565787085, 23384.28698689860],
[0.00000000012, 1.93859256739, 6525.80445396540],
]],
('Mars', 'B'):[[
[0.03197134986, 3.76832042432, 3340.61242669980],
[0.00298033234, 4.10616996243, 6681.22485339960],
[0.00289104742, 0.00000000000, 0.00000000000],
[0.00031365538, 4.44651052853, 10021.83728009940],
[0.00003484100, 4.78812547889, 13362.44970679920],
[0.00000442999, 5.65233015876, 3337.08930835080],
[0.00000443401, 5.02642620491, 3344.13554504880],
[0.00000399109, 5.13056814700, 16703.06213349900],
[0.00000292506, 3.79290644595, 2281.23049651060],
[0.00000181982, 6.13648011704, 6151.53388830500],
[0.00000163159, 4.26399626634, 529.69096509460],
[0.00000159678, 2.23194610246, 1059.38193018920],
[0.00000139323, 2.41796344238, 8962.45534991020],
[0.00000149297, 2.16501209917, 5621.84292321040],
[0.00000142686, 1.18215016110, 3340.59517304760],
[0.00000142685, 3.21292180820, 3340.62968035200],
[0.00000082544, 5.36667872319, 6684.74797174860],
[0.00000073640, 5.09187524843, 398.14900340820],
[0.00000072660, 5.53775710437, 6283.07584999140],
[0.00000086377, 5.74429648412, 3738.76143010800],
[0.00000083276, 5.98866315739, 6677.70173505060],
[0.00000060116, 3.67960808826, 796.29800681640],
[0.00000063111, 0.73049113369, 5884.92684658320],
[0.00000062338, 4.85071999184, 2942.46342329160],
[0.00000046951, 5.54339723804, 3340.54511639700],
[0.00000046953, 5.13486627234, 3340.67973700260],
[0.00000046630, 5.47361665459, 20043.67456019880],
[0.00000045588, 2.13262507507, 2810.92146160520],
[0.00000041269, 0.20003189001, 9492.14631500480],
[0.00000047199, 4.52184736343, 3149.16416058820],
[0.00000038540, 4.08008443274, 4136.91043351620],
[0.00000033069, 4.06581918329, 1751.53953141600],
[0.00000029694, 5.92218297386, 3532.06069281140],
[0.00000032736, 2.62071056958, 2914.01423582380],
[0.00000029521, 2.75342566734, 12303.06777661000],
[0.00000028169, 2.06282533993, 5486.77784317500],
[0.00000028618, 4.94710527914, 3870.30339179440],
[0.00000026603, 3.55085844020, 6681.24210705180],
[0.00000026603, 1.52008675291, 6681.20759974740],
[0.00000023336, 2.27624532707, 1589.07289528380],
[0.00000026052, 2.60064548916, 4399.99435688900],
[0.00000022637, 2.27507466406, 1194.44701022460],
[0.00000018887, 6.04416196149, 7079.37385680780],
[0.00000014846, 3.41358603159, 5088.62883976680],
[0.00000019947, 2.67365368471, 8432.76438481560],
[0.00000014682, 5.89211938785, 9623.68827669120],
[0.00000014152, 2.42512744356, 3333.49887969900],
[0.00000013310, 2.62839773036, 426.59819087600],
[0.00000014008, 1.67425558329, 6254.62666252360],
[0.00000015104, 2.81013535571, 3496.03282613400],
[0.00000013011, 5.70759434129, 10025.36039844840],
[0.00000012080, 1.51804981987, 3185.19202726560],
[0.00000013183, 0.04521207632, 10018.31416175040],
[0.00000011554, 5.57418971820, 191.44826611160],
[0.00000011196, 0.55829576311, 5092.15195811580],
[0.00000011530, 2.13314819584, 11773.37681151540],
[0.00000010435, 5.72414012635, 6467.92575796160],
[0.00000009846, 0.86942245495, 1592.59601363280],
[0.00000009761, 1.09342288660, 2544.31441988340],
[0.00000008754, 5.47281660412, 6681.29216370240],
[0.00000008937, 4.83790385610, 6489.77658728800],
[0.00000008652, 4.72118876809, 213.29909543800],
[0.00000008797, 2.86597575792, 3341.59274776800],
[0.00000008384, 2.65895230037, 4535.05943692440],
[0.00000008213, 4.82608134710, 3553.91152213780],
[0.00000008799, 1.52910882795, 3339.63210563160],
[0.00000008103, 1.00994045172, 9225.53927328300],
[0.00000008754, 5.88131160438, 6681.15754309680],
[0.00000007209, 4.41679446871, 7477.52286021600],
[0.00000008560, 4.79003986337, 4690.47983635860],
[0.00000006087, 1.89071507516, 9595.23908922340],
[0.00000006974, 0.53246284561, 12832.75874170460],
[0.00000005584, 6.18909308524, 4292.33083295040],
[0.00000005038, 6.06393121994, 7210.91581849420],
[0.00000005126, 0.11856805000, 4562.46099302120],
[0.00000004863, 1.33051301524, 3894.18182954220],
[0.00000005592, 3.97792577165, 3127.31333126180],
[0.00000004965, 5.74589127183, 1990.74501704100],
[0.00000005530, 5.81711987294, 23384.28698689860],
[0.00000004184, 3.88899446923, 10021.85453375160],
[0.00000004184, 1.85821885540, 10021.82002644720],
[0.00000004685, 1.11750235736, 3319.83703120740],
[0.00000003954, 2.65573703692, 4929.68532198360],
[0.00000005174, 3.62343554596, 2700.71514038580],
[0.00000004639, 6.14089337232, 7.11354700080],
[0.00000004686, 3.27731664264, 3361.38782219220],
[0.00000004999, 3.09121636067, 15643.68020330980],
[0.00000003919, 2.96552252075, 7740.60678358880],
[0.00000003361, 1.85016770821, 2957.71589447660],
[0.00000004246, 4.19639278630, 2146.16541647520],
[0.00000004101, 6.22532797325, 10213.28554621100],
[0.00000003124, 0.08536218671, 10419.98628350760],
[0.00000003079, 2.41163389513, 3344.20285535160],
[0.00000003093, 1.98041729732, 3337.02199804800],
[0.00000003044, 4.38894419912, 1221.84856632140],
[0.00000002879, 2.93292197885, 2787.04302385740],
[0.00000003372, 4.45558202843, 6674.11130639880],
[0.00000002510, 4.06249795775, 6872.67311951120],
[0.00000002616, 1.23659420897, 4933.20844033260],
[0.00000003011, 4.33965766608, 2388.89402044920],
[0.00000003094, 2.40385309455, 2118.76386037840],
[0.00000002516, 2.30275910483, 3723.50895892300],
[0.00000002192, 1.68877598700, 639.89728631400],
[0.00000002157, 6.07600403318, 9808.53818466140],
[0.00000002686, 2.38172448359, 15113.98923821520],
[0.00000002156, 2.87771528495, 6041.32756708560],
[0.00000002495, 3.87395320804, 7903.07341972100],
[0.00000002253, 0.47469626036, 3475.67750673520],
[0.00000002443, 3.02632351975, 3767.21061757580],
[0.00000001937, 0.38000997629, 13358.92658845020],
[0.00000002213, 3.91982326360, 3205.54734666440],
[0.00000002385, 6.23883456815, 12964.30070339100],
[0.00000001806, 2.38408432339, 11243.68584642080],
[0.00000002265, 1.85773885180, 6525.80445396540],
[0.00000001642, 1.86812936557, 6680.24453233140],
[0.00000001616, 3.39954231101, 8429.24126646660],
[0.00000001646, 0.73261192032, 2274.11694950980],
[0.00000001910, 6.04319894051, 13365.97282514820],
[0.00000001492, 2.99360929050, 7875.67186362420],
[0.00000001567, 1.76860259924, 382.89653222320],
[0.00000001459, 1.40571286543, 14584.29827312060],
[0.00000001527, 5.79343536555, 6894.52394883760],
[0.00000001409, 5.17099876287, 9830.38901398780],
[0.00000001665, 3.60183854165, 2288.34404351140],
[0.00000001616, 2.19447775480, 8827.39026987480],
[0.00000001746, 0.10485504333, 3583.34103067380],
[0.00000001637, 3.20410489018, 6682.20517446780],
[0.00000001269, 2.02253791623, 155.42039943420],
[0.00000001507, 5.80795976424, 1748.01641306700],
[0.00000001296, 2.92899986522, 9381.93999378540],
[0.00000001291, 2.98932404463, 6836.64525283380],
[0.00000001377, 5.80980821450, 10021.90459040220],
[0.00000001357, 0.32856318286, 4032.77002792660],
[0.00000001377, 6.21830533138, 10021.76996979660],
[0.00000001227, 2.20421067322, 12935.85151592320],
[0.00000001080, 4.75502761725, 10818.13528691580],
[0.00000001016, 1.33950348904, 12566.15169998280],
[0.00000001083, 0.87622049125, 16173.37116840440],
[0.00000000957, 5.29505019432, 1066.49547719000],
[0.00000001035, 2.44286811558, 1052.26838318840],
[0.00000001153, 4.73786864168, 8031.09226305840],
[0.00000001042, 1.73541825729, 3369.06161416760],
[0.00000000899, 1.87265511538, 3077.52850332700],
[0.00000000892, 2.51347636401, 3603.69635007260],
[0.00000000904, 0.27361540197, 3325.35995551480],
[0.00000000883, 5.46537936740, 5614.72937620960],
[0.00000000949, 0.04595688771, 7064.12138562280],
[0.00000000872, 3.61205859852, 6702.00024889200],
[0.00000000842, 5.61713543212, 8955.34180290940],
[0.00000000842, 0.57536275896, 3191.04922956520],
[0.00000000904, 4.11832249537, 3355.86489788480],
[0.00000001044, 2.65889542110, 3312.16323923200],
[0.00000000807, 2.26443259820, 8969.56889691100],
[0.00000001046, 6.11317298058, 5331.35744374080],
[0.00000000933, 0.82551054416, 3503.07906283200],
[0.00000000946, 1.92368414869, 5628.95647021120],
[0.00000000978, 4.55697167317, 3097.88382272579],
[0.00000000846, 4.65096242323, 6438.49624942560],
[0.00000000901, 1.46788821922, 6660.44945790720],
[0.00000000739, 4.97716008834, 10014.72373309860],
[0.00000000762, 3.42576079312, 18984.29263000960],
[0.00000000934, 0.35014113954, 3264.34635542420],
[0.00000000894, 0.34991139502, 10551.52824519400],
[0.00000000665, 6.05561837558, 7632.94325965020],
[0.00000000605, 4.68480399923, 5729.50644714900],
[0.00000000593, 2.97207045977, 3178.14579056760],
[0.00000000617, 2.19529512598, 13362.43245314700],
[0.00000000579, 3.32303439858, 11081.21921028860],
[0.00000000579, 2.31217959727, 6677.63442474780],
[0.00000000572, 4.27984088783, 6546.15977336420],
[0.00000000584, 4.51625727923, 1648.44675719740],
[0.00000000626, 4.60715188203, 2487.41604494780],
[0.00000000649, 2.17894376907, 6298.32832117640],
[0.00000000617, 4.22635718375, 13362.46696045140],
[0.00000000550, 3.11161314141, 6144.42034130420],
[0.00000000551, 3.27081871281, 6127.65545055720],
[0.00000000536, 0.18973312148, 3346.13535100720],
[0.00000000557, 6.13686769377, 26724.89941359840],
[0.00000000571, 5.65341463660, 2921.12778282460],
[0.00000000552, 5.75724124958, 149.56319713460],
[0.00000000638, 4.49647258906, 3.52311834900],
[0.00000000552, 1.07795672495, 536.80451209540],
[0.00000000537, 4.19207200801, 3335.08950239240],
[0.00000000567, 2.62806466971, 2648.45482547300],
[0.00000000641, 3.24534699403, 3347.72597370060],
[0.00000000546, 2.76744357149, 5459.37628707820],
[0.00000000556, 4.98610303145, 6531.66165626500],
[0.00000000578, 2.74445077242, 6684.81528205140],
[0.00000000613, 3.01718810256, 8270.29774868340],
[0.00000000558, 5.89236366633, 6158.64743530580],
[0.00000000489, 4.59082197201, 522.57741809380],
[0.00000000445, 3.64293918046, 10713.99488132620],
[0.00000000539, 0.59284523316, 553.56940284240],
[0.00000000434, 1.99641894213, 26087.90314157420],
[0.00000000459, 4.84216944554, 1758.65307841680],
[0.00000000423, 3.77854586358, 6688.33840040040],
[0.00000000421, 3.10245838137, 8329.67161059700],
[0.00000000421, 4.43540354818, 103.09277421860],
[0.00000000502, 3.03141512630, 3360.96774609859],
[0.00000000422, 5.99158563064, 242.72860397400],
[0.00000000401, 2.06012045711, 3980.50971301380],
[0.00000000410, 5.85255605682, 3351.24909204960],
[0.00000000375, 2.50803340920, 6784.31762761820],
[0.00000000407, 0.30117328390, 16304.91313009080],
[0.00000000507, 1.35016417800, 3320.25710730100],
[0.00000000385, 1.06248122739, 7234.79425624200],
[0.00000000519, 4.61705823333, 7373.38245462640],
[0.00000000401, 0.51161484292, 17085.95866572220],
[0.00000000371, 0.41707432281, 13760.59871020740],
[0.00000000476, 0.81142637639, 6816.28993343500],
[0.00000000348, 3.36497054127, 8439.87793181640],
[0.00000000366, 6.05186692577, 3607.21946842160],
[0.00000000402, 2.67375675473, 18454.60166491500],
[0.00000000439, 0.41122589061, 10404.73381232260],
[0.00000000412, 4.81039654306, 3329.97576135000],
[0.00000000413, 0.21011211689, 13149.15061136120],
[0.00000000363, 2.19017574725, 9866.41688066520],
[0.00000000337, 5.46398740226, 6604.95878212400],
[0.00000000340, 1.73392662280, 1692.16566950240],
[0.00000000344, 3.58310197017, 7107.82304427560],
[0.00000000420, 2.77274750272, 2906.90068882300],
[0.00000000335, 2.02339633221, 3333.56619000180],
[0.00000000336, 2.78173647754, 4989.05918389720],
[0.00000000354, 5.41265456299, 951.71840625060],
[0.00000000328, 0.43464916253, 6923.95345737360],
[0.00000000422, 1.57591737080, 8273.82086703240],
[0.00000000324, 4.99165215532, 11371.70468975820],
[0.00000000351, 4.60766539695, 3074.00538497800],
[0.00000000333, 4.86991808664, 3863.18984479360],
[0.00000000319, 1.44510282827, 11769.85369316640],
[0.00000000296, 5.25637576704, 76.26607127560],
[0.00000000349, 1.62483962938, 17924.91069982040],
[0.00000000293, 2.20643287367, 3347.65866339780],
[0.00000000315, 4.55227306770, 5828.02847164760],
[0.00000000280, 1.42134291540, 6606.44325483230],
[0.00000000336, 1.56854533505, 1581.95934828300],
[0.00000000343, 0.27605726543, 10973.55568635000],
[0.00000000271, 0.08314924409, 10235.13637553740],
[0.00000000280, 0.76436434398, 853.19638175200],
[0.00000000317, 4.91466081381, 3443.70520091840],
[0.00000000257, 0.15709629188, 12168.00269657460],
[0.00000000237, 3.13380421805, 74.78159856730],
[0.00000000271, 1.83008759256, 3399.98628861340],
[0.00000000233, 3.20163702613, 10177.25767953360],
[0.00000000312, 0.28436027987, 13745.34623902240],
[0.00000000273, 4.53535816659, 3344.49376205780],
[0.00000000235, 0.67980074869, 17395.21973472580],
[0.00000000262, 3.84436620806, 9168.64089834740],
[0.00000000271, 4.94509131052, 692.15760122680],
[0.00000000254, 2.19491751584, 3281.23856478620],
[0.00000000220, 1.65400798925, 3546.79797513700],
[0.00000000283, 5.57884389098, 3973.39616601300],
[0.00000000229, 5.93153003758, 3364.49086444760],
[0.00000000223, 4.82744958322, 9779.10867612540],
[0.00000000222, 0.71788606092, 16699.53901514999],
[0.00000000219, 0.09831940529, 16706.58525184800],
[0.00000000221, 1.66596576205, 10575.40668294180],
[0.00000000259, 1.10208840059, 1744.42598441520],
[0.00000000243, 1.52425310144, 14054.60730802600],
[0.00000000273, 6.12932898811, 3336.73109134180],
[0.00000000232, 4.73422268172, 3316.73398895200],
[0.00000000210, 5.97305256642, 419.48464387520],
[0.00000000213, 5.35378111313, 1596.18644228460],
[0.00000000197, 3.32400761027, 5085.03841111500],
[0.00000000193, 0.90522037315, 14314.16811304980],
[0.00000000192, 2.63243342989, 433.71173787680],
[0.00000000188, 1.14983778034, 13892.14067189380],
[0.00000000200, 4.79567916236, 6261.74020952440],
[0.00000000204, 2.32272167710, 13916.01910964160],
[0.00000000191, 5.08454560792, 2178.13772229200],
[0.00000000191, 5.88821293073, 3340.19235060619],
[0.00000000236, 0.97341490472, 3230.40610548040],
[0.00000000200, 3.60041329896, 3304.58456002240],
[0.00000000165, 2.91701234796, 3415.39402526710],
[0.00000000191, 4.77647338120, 3341.03250279340],
[0.00000000174, 2.20549134205, 10020.85695903120],
[0.00000000161, 2.64795288862, 3304.00706139560],
[0.00000000173, 3.54115285115, 10022.81760116760],
[0.00000000154, 2.45916882835, 12722.55242048520],
[0.00000000160, 1.73968020026, 3377.21779200400],
[0.00000000196, 0.78013533938, 3376.64029337720],
[0.00000000153, 0.27328628499, 13362.38239649640],
[0.00000000190, 2.65143864216, 3657.00429635640],
[0.00000000172, 5.71092117488, 2384.32327072920],
[0.00000000157, 1.00235389487, 3209.07046501340],
[0.00000000150, 3.39592748537, 3472.15438838620],
[0.00000000165, 5.86551673354, 2803.80791460440],
[0.00000000154, 0.32136196834, 6665.97238221460],
[0.00000000178, 3.34059693754, 11216.28429032400],
[0.00000000192, 0.66079944629, 3134.42687826260],
[0.00000000161, 2.87915391245, 4392.88080988820],
[0.00000000159, 3.72249746113, 13517.87010623340],
[0.00000000168, 0.55746622745, 110.20632121940],
[0.00000000158, 5.67248197213, 4407.10790388980],
[0.00000000161, 1.76789928464, 6709.67404086740],
[0.00000000158, 5.50643845256, 13171.00144068760],
[0.00000000129, 1.21297315367, 19513.98359510420],
[0.00000000173, 0.17070148373, 3024.22055704320],
[0.00000000132, 4.25407099272, 16858.48253293320],
[0.00000000125, 2.88510294667, 17256.63153634140],
[0.00000000124, 2.59724598646, 12310.18132361080],
[0.00000000170, 4.05945259741, 2818.03500860600],
[0.00000000121, 5.23997785185, 9872.27408296480],
[0.00000000142, 3.02798835989, 3511.28529731900],
[0.00000000165, 2.53171951288, 16276.46394262300],
[0.00000000153, 6.14783670557, 13362.51701710200],
[0.00000000119, 4.15694365082, 3760.09707057500],
[0.00000000120, 0.64287725481, 4459.36821880260],
[0.00000000130, 4.95002309460, 13553.89797291080],
[0.00000000120, 0.17087854222, 8671.96987044060],
[0.00000000112, 0.16822264326, 135.06508003540],
[0.00000000137, 3.34809361979, 3341.04230982650],
[0.00000000125, 1.32195559043, 1349.86740965880],
[0.00000000111, 3.14151030451, 13524.91634293140],
[0.00000000119, 5.95361348050, 12295.95422960920],
[0.00000000131, 5.09769375731, 14158.74771361560],
[0.00000000141, 1.37128440708, 3169.93955608060],
[0.00000000112, 3.35831868034, 5989.06725217280],
[0.00000000104, 5.00696041032, 13119.72110282519],
[0.00000000110, 5.23317664736, 1375.77379984580],
[0.00000000105, 2.72692368303, 1162.47470440780],
[0.00000000104, 1.73769165705, 2221.85663459700],
[0.00000000137, 1.04576950390, 3340.18254357310],
[0.00000000106, 6.13415161313, 162.46663613220],
[0.00000000119, 2.63312561442, 7321.12213971360],
[0.00000000105, 3.09551802365, 20618.01935853360],
[0.00000000099, 4.25515697974, 23539.70738633280],
[0.00000000108, 1.01854506729, 3265.83082813250],
[0.00000000119, 4.07277528003, 10184.30391623160],
[0.00000000096, 1.81122023425, 10001.06188460700],
[0.00000000093, 3.58905885066, 5099.26550511660],
[0.00000000095, 4.94756054764, 3981.49003408200],
[0.00000000094, 5.37493368020, 13355.33615979840],
[0.00000000095, 0.13037485775, 15508.61512327440],
[0.00000000103, 0.43484130196, 1861.74585263540],
[0.00000000090, 3.76370412628, 22324.90505670940],
[0.00000000091, 3.95041101283, 10042.61267559180],
[0.00000000106, 4.30186500383, 640.87760738220],
[0.00000000109, 6.18873749839, 1478.86657406440],
[0.00000000088, 1.79608901332, 6247.51311552280],
[0.00000000102, 5.58754073056, 2766.26762836500],
[0.00000000110, 0.94707767481, 3274.12501778540],
[0.00000000084, 4.45487801845, 6696.47732458460],
[0.00000000085, 2.74791518135, 3407.09983561420],
[0.00000000087, 4.51145821088, 220.41264243880],
[0.00000000101, 5.94930983227, 8425.65083781480],
[0.00000000082, 0.01837230371, 9499.25986200560],
[0.00000000080, 0.42550989980, 18052.92954315780],
[0.00000000083, 2.96589752213, 6652.77566593180],
[0.00000000080, 4.61446168762, 3914.95722503460],
[0.00000000079, 1.50228636499, 2111.65031337760],
[0.00000000089, 3.52977975496, 9485.03276800400],
[0.00000000086, 0.41976545794, 956.28915597060],
[0.00000000088, 5.46013317934, 16460.33352952499],
[0.00000000091, 2.09965252231, 949.17560896980],
[0.00000000104, 1.72206104768, 3296.89351439480],
[0.00000000103, 1.25691413032, 3384.33133900480],
[0.00000000084, 5.78647729498, 5518.75014899180],
[0.00000000079, 1.79313426804, 38.13303563780],
[0.00000000073, 0.10667695992, 29822.78323632420],
[0.00000000087, 2.11654357529, 3450.81874791920],
[0.00000000072, 3.89476829327, 9380.95967271720],
[0.00000000075, 2.59340305340, 1964.83862685400],
[0.00000000098, 4.01577665825, 6843.69148953180],
[0.00000000074, 5.32032289064, 11766.26326451460],
[0.00000000068, 0.04775525953, 2125.87740737920],
[0.00000000069, 6.07427052412, 26482.17080962440],
[0.00000000069, 2.05018999200, 29424.63423291600],
[0.00000000084, 0.16960920719, 263.08392337280],
[0.00000000068, 5.03013252197, 9070.11887384880],
[0.00000000076, 2.00296087293, 224.34479570190],
[0.00000000078, 2.17362706851, 30220.93223973240],
[0.00000000066, 3.85497672006, 19406.67828817460],
[0.00000000066, 5.70059718737, 33561.54466643220],
[0.00000000067, 0.16600936321, 22743.40937951640],
[0.00000000065, 4.65423392949, 2807.39834325620],
[0.00000000069, 3.34387224268, 11670.28403729680],
[0.00000000087, 4.97838021880, 1118.75579210280],
[0.00000000063, 0.18907106180, 30065.51184029820],
[0.00000000064, 4.61909647015, 9886.77220006400],
[0.00000000073, 0.93706647938, 20735.83216142559],
[0.00000000060, 5.83757395809, 8646.06348025360],
[0.00000000062, 4.81389895867, 20199.09495963300],
[0.00000000059, 5.00150762621, 6414.61781167780],
[0.00000000068, 3.84252763135, 6571.01853218020],
[0.00000000062, 2.81689634717, 6944.30877677240],
[0.00000000065, 4.49078808776, 632.78373931320],
[0.00000000058, 5.64889513615, 9945.57120882380],
[0.00000000070, 2.51605694403, 9638.94074787620],
[0.00000000057, 3.28105791201, 206.18554843720],
[0.00000000057, 2.97448265957, 21795.21409161479],
[0.00000000056, 2.23565630779, 20995.39296644940],
[0.00000000057, 1.88614831237, 18451.07854656599],
[0.00000000071, 4.82445647307, 8542.97070603500],
[0.00000000061, 3.65945073900, 14421.83163698840],
[0.00000000056, 3.13789031275, 8799.98871377800],
[0.00000000057, 4.89927831599, 9602.35263622420],
[0.00000000065, 3.37109873211, 11610.91017538320],
[0.00000000067, 1.92945007459, 21265.52312652020],
[0.00000000055, 1.95164531764, 9588.12554222260],
[0.00000000057, 2.82240075154, 10124.93005431800],
[0.00000000057, 6.10407356832, 19800.94595622480],
[0.00000000055, 5.20976473824, 3237.51965248120],
[0.00000000057, 4.12235760406, 10028.95082710020],
[0.00000000055, 1.41700952855, 15906.76412668260],
[0.00000000053, 2.16328741039, 6418.14093002680],
[0.00000000060, 2.64683840328, 10018.24685144760],
[0.00000000068, 5.36539876845, 1228.96211332220],
[0.00000000051, 5.73824213507, 6048.44111408640],
[0.00000000053, 0.31937174553, 12721.57209941700],
[0.00000000051, 0.06312524105, 20206.14119633100],
[0.00000000049, 4.53401402385, 6675.70192909220],
[0.00000000051, 1.15475560534, 10156.90236013480],
[0.00000000064, 4.56332268770, 16703.07938715119],
[0.00000000060, 3.61007443614, 9468.26787725700],
[0.00000000059, 3.08413561767, 10025.42770875120],
[0.00000000064, 2.53229538141, 16703.04487984680],
[0.00000000056, 3.31988072467, 6518.75821726740],
[0.00000000047, 1.44559165677, 6643.09181776180],
[0.00000000050, 1.92342238827, 11614.43329373220],
[0.00000000047, 4.03794177027, 23958.63178523340],
[0.00000000046, 3.70927352724, 8859.36257569160],
[0.00000000060, 2.55506470511, 11780.49035851620],
[0.00000000047, 1.69256878711, 6660.86953400080],
[0.00000000044, 6.09481217162, 6460.81221096080],
[0.00000000044, 2.63040622140, 13936.79450513400],
[0.00000000053, 0.77878945764, 16865.52876963120],
[0.00000000049, 1.83368544550, 17654.78053974960],
[0.00000000048, 0.52828042378, 6686.74777770700],
[0.00000000042, 4.30347553493, 9065.54812412880],
[0.00000000042, 5.71964550673, 7203.80227149340],
[0.00000000041, 0.98427208931, 20426.57109242200],
[0.00000000051, 3.54335413699, 20597.24396304120],
[0.00000000041, 0.21219617682, 7314.00859271280],
[0.00000000038, 2.53074981011, 13207.02930736500],
[0.00000000039, 5.15577369902, 6670.58818804980],
[0.00000000051, 3.25271478667, 7799.98064550240],
[0.00000000049, 0.77060706107, 17101.21113690720],
[0.00000000038, 6.06684699984, 9389.05354078620],
[0.00000000043, 0.51983815091, 16489.76303806100],
[0.00000000036, 0.84102576439, 23937.85638974100],
], [
[0.00350068845, 5.36847836211, 3340.61242669980],
[0.00014116030, 3.14159265359, 0.00000000000],
[0.00009670755, 5.47877786506, 6681.22485339960],
[0.00001471918, 3.20205766795, 10021.83728009940],
[0.00000425864, 3.40843812875, 13362.44970679920],
[0.00000102039, 0.77617286189, 3337.08930835080],
[0.00000078848, 3.71768293865, 16703.06213349900],
[0.00000026171, 2.48293558065, 2281.23049651060],
[0.00000032708, 3.45803723682, 5621.84292321040],
[0.00000020712, 1.44120802297, 6151.53388830500],
[0.00000018294, 6.03102943125, 529.69096509460],
[0.00000015680, 3.93075566599, 8962.45534991020],
[0.00000016975, 4.81115186866, 3344.13554504880],
[0.00000013067, 0.97324736181, 6677.70173505060],
[0.00000015622, 2.78241383265, 3340.59517304760],
[0.00000015622, 4.81318636318, 3340.62968035200],
[0.00000013771, 1.67983063909, 3532.06069281140],
[0.00000012711, 4.04546734935, 20043.67456019880],
[0.00000014268, 0.24640247719, 2942.46342329160],
[0.00000012493, 2.25620513522, 5884.92684658320],
[0.00000008800, 0.34079528233, 398.14900340820],
[0.00000008637, 1.75213704409, 2544.31441988340],
[0.00000008903, 5.95437916504, 2810.92146160520],
[0.00000008102, 0.84279830287, 6283.07584999140],
[0.00000009250, 4.35071778619, 3496.03282613400],
[0.00000008085, 4.29614034209, 6684.74797174860],
[0.00000005811, 3.55479498415, 5092.15195811580],
[0.00000005864, 3.69652093329, 5486.77784317500],
[0.00000005618, 0.03475872145, 3185.19202726560],
[0.00000005148, 0.85886443528, 3340.54511639700],
[0.00000005145, 0.45169791514, 3340.67973700260],
[0.00000004898, 4.12922007874, 1059.38193018920],
[0.00000003471, 5.07253485267, 5088.62883976680],
[0.00000003102, 3.11487063736, 3339.63210563160],
[0.00000003013, 1.00910437496, 2914.01423582380],
[0.00000003171, 1.24730004776, 3738.76143010800],
[0.00000003194, 2.86899092087, 1751.53953141600],
[0.00000002304, 1.38460565999, 3870.30339179440],
[0.00000002233, 2.91238180064, 3894.18182954220],
[0.00000002792, 4.27117916474, 8432.76438481560],
[0.00000002431, 0.14615904873, 4690.47983635860],
[0.00000002577, 2.78651098185, 6254.62666252360],
[0.00000001996, 1.51200589223, 4292.33083295040],
[0.00000001860, 5.15222219319, 796.29800681640],
[0.00000002014, 5.48528849094, 3127.31333126180],
[0.00000001922, 4.37668623732, 23384.28698689860],
[0.00000002248, 4.46756441051, 10025.36039844840],
[0.00000001782, 2.70229954651, 4136.91043351620],
[0.00000001621, 2.26742355334, 3149.16416058820],
[0.00000001452, 1.53948251192, 9492.14631500480],
[0.00000001373, 3.20232312108, 2146.16541647520],
[0.00000001332, 5.67966837010, 1592.59601363280],
[0.00000001378, 4.12087865376, 3723.50895892300],
[0.00000001215, 0.33914405698, 6674.11130639880],
[0.00000001168, 3.52407129935, 11773.37681151540],
[0.00000001179, 6.15475441355, 213.29909543800],
[0.00000001173, 1.26036608440, 3341.59274776800],
[0.00000001211, 0.97241747335, 6467.92575796160],
[0.00000001204, 0.95200561837, 10018.31416175040],
[0.00000001107, 1.44142157852, 2787.04302385740],
[0.00000001194, 0.84501638145, 1194.44701022460],
[0.00000001043, 3.98123209815, 12303.06777661000],
[0.00000001029, 1.21951732572, 4535.05943692440],
[0.00000000939, 2.99716248257, 7477.52286021600],
[0.00000001303, 1.12409937702, 4399.99435688900],
[0.00000001032, 4.26592917807, 1990.74501704100],
[0.00000001230, 0.37904885593, 6525.80445396540],
[0.00000000989, 2.37220445455, 9225.53927328300],
[0.00000000946, 3.14940196742, 6489.77658728800],
[0.00000001013, 5.90131661122, 3097.88382272579],
[0.00000000913, 2.86098924372, 2388.89402044920],
[0.00000000954, 4.90448639106, 3583.34103067380],
[0.00000000866, 4.92421595837, 6681.24210705180],
[0.00000000797, 4.53307543814, 7079.37385680780],
[0.00000000866, 2.89344915945, 6681.20759974740],
[0.00000000659, 0.33901474348, 2957.71589447660],
[0.00000000670, 3.23650405278, 9595.23908922340],
[0.00000000782, 1.56739177814, 3333.49887969900],
[0.00000000641, 4.46918721250, 6836.64525283380],
[0.00000000611, 3.97393774087, 6041.32756708560],
[0.00000000738, 3.78715624780, 4562.46099302120],
[0.00000000558, 2.92718433901, 1589.07289528380],
[0.00000000513, 0.96852780537, 9623.68827669120],
[0.00000000508, 4.07262127921, 7.11354700080],
[0.00000000512, 1.53960708348, 7740.60678358880],
[0.00000000481, 3.51023225206, 155.42039943420],
[0.00000000528, 6.06190721770, 4933.20844033260],
[0.00000000558, 2.09491968451, 2288.34404351140],
[0.00000000445, 3.42439886280, 6680.24453233140],
[0.00000000482, 4.73460866232, 13365.97282514820],
[0.00000000534, 4.88536251621, 3361.38782219220],
[0.00000000520, 6.19100285186, 6438.49624942560],
[0.00000000441, 1.82408206251, 3325.35995551480],
[0.00000000487, 2.72879191049, 3319.83703120740],
[0.00000000417, 4.48716253276, 7903.07341972100],
[0.00000000430, 0.62845892205, 5614.72937620960],
[0.00000000395, 4.89021898045, 10419.98628350760],
[0.00000000380, 1.91138845097, 3553.91152213780],
[0.00000000358, 4.21584518245, 426.59819087600],
[0.00000000409, 4.53421956625, 3360.96774609859],
[0.00000000426, 5.47172830908, 3205.54734666440],
[0.00000000330, 1.00078638665, 8955.34180290940],
[0.00000000322, 2.42607399606, 2274.11694950980],
[0.00000000316, 3.22064089430, 1221.84856632140],
[0.00000000312, 3.66073476074, 3337.02199804800],
[0.00000000310, 4.09100416919, 3344.20285535160],
[0.00000000295, 2.87635162282, 7210.91581849420],
[0.00000000329, 5.64440592793, 12832.75874170460],
[0.00000000306, 1.52567836482, 7875.67186362420],
[0.00000000284, 0.56373187712, 6681.29216370240],
[0.00000000358, 4.21258737082, 1052.26838318840],
[0.00000000347, 1.52200237477, 10213.28554621100],
[0.00000000268, 3.57749600251, 9830.38901398780],
[0.00000000346, 1.65247014273, 6682.20517446780],
[0.00000000269, 4.45182417080, 9381.93999378540],
[0.00000000285, 0.97118840317, 6681.15754309680],
[0.00000000256, 3.67744143301, 1066.49547719000],
[0.00000000269, 1.78448639785, 6127.65545055720],
[0.00000000312, 4.63751658715, 5331.35744374080],
[0.00000000317, 6.15274242841, 3320.25710730100],
[0.00000000245, 4.71030710599, 26724.89941359840],
[0.00000000249, 3.31328995337, 10818.13528691580],
[0.00000000240, 4.87364672707, 6144.42034130420],
[0.00000000239, 1.35709001659, 7064.12138562280],
[0.00000000237, 3.19837233399, 5729.50644714900],
[0.00000000278, 1.50842060340, 4929.68532198360],
[0.00000000274, 3.61160906396, 191.44826611160],
[0.00000000248, 3.93789974497, 11243.68584642080],
[0.00000000242, 2.57630671866, 3355.86489788480],
[0.00000000241, 1.89683861728, 15643.68020330980],
[0.00000000228, 0.71217112323, 9866.41688066520],
[0.00000000246, 0.16913226579, 2700.71514038580],
[0.00000000219, 0.03864812268, 522.57741809380],
[0.00000000215, 3.44260776071, 8827.39026987480],
[0.00000000206, 5.23615052385, 6923.95345737360],
[0.00000000202, 0.60277862639, 10021.82002644720],
[0.00000000226, 2.43332503270, 8429.24126646660],
[0.00000000202, 2.63373646725, 10021.85453375160],
[0.00000000199, 3.26545613445, 382.89653222320],
[0.00000000198, 4.50685315424, 242.72860397400],
[0.00000000215, 2.12744795327, 553.56940284240],
[0.00000000177, 3.92599588022, 8031.09226305840],
[0.00000000162, 3.94498519498, 2921.12778282460],
[0.00000000199, 4.22948972595, 3312.16323923200],
[0.00000000188, 0.67072289565, 6298.32832117640],
[0.00000000160, 2.90951395323, 6872.67311951120],
[0.00000000155, 1.24529852403, 3364.49086444760],
[0.00000000186, 2.44723831367, 3503.07906283200],
[0.00000000139, 5.75493557040, 7632.94325965020],
[0.00000000149, 0.49665393273, 8969.56889691100],
[0.00000000132, 4.97828413367, 1748.01641306700],
[0.00000000130, 0.66881298338, 10014.72373309860],
[0.00000000128, 2.80753554051, 14584.29827312060],
[0.00000000176, 2.37291314099, 2118.76386037840],
[0.00000000127, 1.76223414864, 11081.21921028860],
[0.00000000127, 0.26234206855, 13358.92658845020],
[0.00000000163, 5.83356697025, 639.89728631400],
[0.00000000129, 2.02607662846, 3346.13535100720],
[0.00000000155, 1.57189307640, 3767.21061757580],
[0.00000000133, 4.20989922795, 11371.70468975820],
[0.00000000114, 2.12636383988, 6688.33840040040],
[0.00000000130, 1.33114943655, 3347.72597370060],
[0.00000000110, 5.78893316282, 16173.37116840440],
[0.00000000105, 3.27202438053, 15113.98923821520],
[0.00000000117, 5.66812806862, 536.80451209540],
[0.00000000106, 1.21268139587, 7234.79425624200],
[0.00000000108, 0.94652521237, 9808.53818466140],
[0.00000000121, 4.22204758443, 6158.64743530580],
[0.00000000124, 4.92495255567, 12964.30070339100],
[0.00000000142, 3.85764234922, 6894.52394883760],
[0.00000000099, 5.62543167000, 10973.55568635000],
[0.00000000100, 2.56456804207, 3178.14579056760],
[0.00000000131, 0.08971075365, 8273.82086703240],
[0.00000000112, 3.14240135508, 3316.73398895200],
[0.00000000095, 0.64723185059, 2487.41604494780],
[0.00000000087, 4.14322802003, 3603.69635007260],
[0.00000000087, 3.50260474148, 3077.52850332700],
[0.00000000096, 5.13010621713, 3304.58456002240],
[0.00000000082, 4.87880877413, 5828.02847164760],
[0.00000000083, 2.04400907684, 18984.29263000960],
[0.00000000085, 3.33671991814, 1758.65307841680],
[0.00000000099, 3.28955694324, 17654.78053974960],
[0.00000000078, 0.89238228021, 2699.73481931760],
[0.00000000095, 0.32948273562, 3863.18984479360],
[0.00000000083, 0.80327899268, 5085.03841111500],
[0.00000000091, 1.48623539837, 8270.29774868340],
[0.00000000075, 4.91191036053, 10021.76996979660],
[0.00000000079, 4.25171159471, 7373.38245462640],
[0.00000000084, 2.16662156833, 12566.15169998280],
[0.00000000088, 2.78893554858, 11769.85369316640],
[0.00000000095, 0.29428946155, 5628.95647021120],
[0.00000000076, 5.23354729169, 13760.59871020740],
[0.00000000092, 1.40883592065, 3336.73109134180],
[0.00000000069, 3.50477916910, 10713.99488132620],
[0.00000000079, 0.61833410504, 951.71840625060],
[0.00000000070, 1.93458925881, 3475.67750673520],
[0.00000000066, 5.01996258363, 16706.58525184800],
[0.00000000067, 3.68731475523, 4032.77002792660],
[0.00000000071, 1.71691035008, 10575.40668294180],
[0.00000000086, 1.82073461894, 10404.73381232260],
[0.00000000064, 2.43149744819, 2648.45482547300],
[0.00000000062, 0.25250107112, 3980.50971301380],
[0.00000000062, 3.16420520010, 13517.87010623340],
[0.00000000078, 1.41762772678, 3.52311834900],
[0.00000000086, 3.34935714534, 1581.95934828300],
[0.00000000064, 3.75812808116, 1596.18644228460],
[0.00000000061, 1.37421861116, 419.48464387520],
[0.00000000055, 1.11154560464, 433.71173787680],
[0.00000000061, 5.33515994167, 853.19638175200],
[0.00000000059, 0.80382380790, 13362.43245314700],
[0.00000000055, 0.37478855406, 149.56319713460],
[0.00000000053, 0.55329112916, 14314.16811304980],
[0.00000000059, 0.07234691744, 6531.66165626500],
[0.00000000059, 2.83458587563, 13362.46696045140],
[0.00000000059, 4.13409540555, 4407.10790388980],
[0.00000000057, 5.57913927474, 3376.64029337720],
[0.00000000049, 4.58036235824, 10551.52824519400],
[0.00000000050, 2.01769015785, 10022.81760116760],
[0.00000000055, 1.36081433917, 21393.54196985760],
[0.00000000048, 1.59939595487, 18052.92954315780],
[0.00000000045, 4.97928157994, 8671.96987044060],
[0.00000000044, 2.58542985685, 13916.01910964160],
[0.00000000047, 1.40206686464, 8425.65083781480],
[0.00000000043, 0.21864618144, 9779.10867612540],
[0.00000000042, 6.22365857047, 3914.95722503460],
[0.00000000048, 3.44104044998, 692.15760122680],
[0.00000000043, 3.21191030055, 6247.51311552280],
[0.00000000055, 4.01321481700, 10177.25767953360],
[0.00000000053, 2.93285711320, 3981.49003408200],
[0.00000000039, 5.54634215618, 6702.00024889200],
[0.00000000041, 2.46188112193, 6660.44945790720],
[0.00000000049, 3.04236065330, 640.87760738220],
[0.00000000039, 1.62689158397, 3335.08950239240],
[0.00000000038, 3.31198341709, 1744.42598441520],
[0.00000000038, 6.16317067723, 2818.03500860600],
[0.00000000038, 4.03534957207, 103.09277421860],
[0.00000000044, 0.91040525278, 5459.37628707820],
[0.00000000049, 1.88325571471, 11216.28429032400],
[0.00000000046, 5.62762941168, 9168.64089834740],
[0.00000000035, 1.65976191407, 12168.00269657460],
[0.00000000047, 4.52334272666, 10021.90459040220],
[0.00000000039, 2.08367076229, 13745.34623902240],
[0.00000000039, 4.76186135572, 20597.24396304120],
[0.00000000039, 3.00951950244, 3344.49376205780],
[0.00000000037, 1.33065895739, 12295.95422960920],
[0.00000000040, 3.96893429107, 13171.00144068760],
[0.00000000032, 0.91212661789, 12310.18132361080],
[0.00000000032, 2.22618836835, 7107.82304427560],
[0.00000000032, 4.96078703650, 24734.15439655740],
[0.00000000037, 3.30085609301, 20995.39296644940],
[0.00000000033, 3.70858397913, 10020.85695903120],
[0.00000000031, 4.18674524484, 17256.63153634140],
[0.00000000034, 3.25657016622, 14054.60730802600],
[0.00000000032, 5.75360661734, 6546.15977336420],
[0.00000000031, 3.16209740784, 12935.85151592320],
[0.00000000037, 2.14901622101, 6665.97238221460],
[0.00000000030, 0.21926429217, 6660.86953400080],
[0.00000000030, 3.55459460301, 9070.11887384880],
[0.00000000029, 2.97927335664, 2766.26762836500],
[0.00000000029, 4.65051930186, 10235.13637553740],
[0.00000000030, 5.16882435400, 16304.91313009080],
[0.00000000032, 5.01760544488, 3191.04922956520],
[0.00000000029, 2.93988761068, 6696.47732458460],
[0.00000000029, 5.06447742493, 5099.26550511660],
[0.00000000029, 5.68073325802, 3329.97576135000],
[0.00000000029, 0.43949269085, 3351.24909204960],
[0.00000000032, 1.37056688814, 6040.34724601740],
[0.00000000032, 1.42334455474, 76.26607127560],
[0.00000000033, 0.36423446435, 6604.95878212400],
[0.00000000033, 4.85478789063, 6701.58017279840],
[0.00000000030, 3.33348460172, 3369.06161416760],
[0.00000000028, 0.60182098585, 11766.26326451460],
[0.00000000026, 1.05197848649, 13207.02930736500],
[0.00000000026, 5.03535225585, 30065.51184029820],
[0.00000000034, 3.65553061498, 14158.74771361560],
[0.00000000025, 4.60925601393, 8329.67161059700],
[0.00000000025, 2.05970140678, 17395.21973472580],
[0.00000000030, 5.22285260441, 9485.03276800400],
[0.00000000025, 4.84964369679, 1648.44675719740],
[0.00000000026, 5.47626814223, 3074.00538497800],
[0.00000000024, 2.45239543931, 17085.95866572220],
[0.00000000029, 5.36428737888, 2707.82868738660],
[0.00000000024, 5.57488544800, 10264.56588407340],
[0.00000000025, 4.22744782935, 1692.16566950240],
[0.00000000023, 6.09244870438, 20199.09495963300],
[0.00000000028, 1.30366587075, 8439.87793181640],
[0.00000000032, 2.13597148493, 9468.26787725700],
], [
[0.00016726690, 0.60221392419, 3340.61242669980],
[0.00004986799, 3.14159265359, 0.00000000000],
[0.00000302141, 5.55871276021, 6681.22485339960],
[0.00000025767, 1.89662673499, 13362.44970679920],
[0.00000021452, 0.91749968618, 10021.83728009940],
[0.00000011820, 2.24240738700, 3337.08930835080],
[0.00000007985, 2.24892866611, 16703.06213349900],
[0.00000002960, 5.89425825808, 3496.03282613400],
[0.00000002445, 5.18770525274, 5621.84292321040],
[0.00000001428, 1.25238140580, 2281.23049651060],
[0.00000001779, 2.58759968520, 20043.67456019880],
[0.00000001501, 3.18533003542, 3532.06069281140],
[0.00000001259, 4.80695172904, 3185.19202726560],
[0.00000001029, 2.35029907056, 6677.70173505060],
[0.00000001109, 3.80982317372, 5884.92684658320],
[0.00000000928, 0.29719160927, 3344.13554504880],
[0.00000000860, 3.11698318930, 6151.53388830500],
[0.00000000853, 1.33003321402, 529.69096509460],
[0.00000000883, 5.18681316017, 5486.77784317500],
[0.00000001100, 1.82962075794, 2942.46342329160],
[0.00000000815, 3.40910567373, 2544.31441988340],
[0.00000000702, 5.49076132554, 8962.45534991020],
[0.00000000644, 0.31400306761, 5088.62883976680],
[0.00000000745, 4.30248377111, 3340.59517304760],
[0.00000000586, 4.48071459693, 3894.18182954220],
[0.00000000681, 5.40951261308, 2810.92146160520],
[0.00000000745, 0.05006463495, 3340.62968035200],
[0.00000000542, 4.68895461946, 3339.63210563160],
[0.00000000497, 4.65665197749, 5092.15195811580],
[0.00000000460, 1.06670343610, 3097.88382272579],
[0.00000000423, 3.08034568777, 4292.33083295040],
[0.00000000381, 2.24933115190, 6283.07584999140],
[0.00000000429, 1.70668733378, 4690.47983635860],
[0.00000000339, 2.92195933142, 23384.28698689860],
[0.00000000310, 5.63324402105, 3723.50895892300],
[0.00000000287, 1.98619629868, 398.14900340820],
[0.00000000298, 2.58990636818, 6684.74797174860],
[0.00000000323, 5.15230144390, 6525.80445396540],
[0.00000000247, 2.36923535528, 3340.54511639700],
[0.00000000247, 1.96071951597, 3340.67973700260],
[0.00000000223, 4.75562842441, 2146.16541647520],
[0.00000000240, 3.53331653789, 3583.34103067380],
[0.00000000238, 4.69268478666, 6254.62666252360],
[0.00000000198, 6.21548965568, 2787.04302385740],
[0.00000000202, 4.25439775032, 3333.49887969900],
[0.00000000158, 1.89216973387, 6674.11130639880],
[0.00000000185, 2.99350590687, 10025.36039844840],
[0.00000000177, 1.41002572971, 6438.49624942560],
[0.00000000138, 1.23172102079, 3127.31333126180],
[0.00000000153, 5.93528616595, 6836.64525283380],
[0.00000000106, 5.35414400998, 3738.76143010800],
[0.00000000102, 3.67040445208, 1059.38193018920],
[0.00000000136, 1.06039656714, 2388.89402044920],
[0.00000000093, 5.04434801864, 155.42039943420],
[0.00000000093, 2.70817394910, 8955.34180290940],
[0.00000000108, 6.13917250674, 1748.01641306700],
[0.00000000116, 5.97739483530, 2914.01423582380],
[0.00000000099, 1.50221319099, 1751.53953141600],
[0.00000000092, 2.68470906437, 1990.74501704100],
[0.00000000077, 4.01966292109, 1592.59601363280],
[0.00000000076, 4.49660101731, 4562.46099302120],
[0.00000000076, 5.67354102576, 6041.32756708560],
[0.00000000078, 0.79220883728, 2288.34404351140],
[0.00000000074, 5.84795427965, 3341.59274776800],
[0.00000000080, 5.48556941416, 8432.76438481560],
[0.00000000065, 2.11705931744, 10018.31416175040],
[0.00000000066, 5.08073805943, 2957.71589447660],
[0.00000000059, 3.79695096075, 6923.95345737360],
[0.00000000061, 4.51116100631, 4933.20844033260],
[0.00000000059, 0.27765984344, 6127.65545055720],
[0.00000000052, 5.84885902302, 4535.05943692440],
[0.00000000051, 1.45495904398, 7477.52286021600],
[0.00000000054, 1.50278239577, 6489.77658728800],
[0.00000000056, 5.23212313891, 9866.41688066520],
[0.00000000057, 4.73711357046, 2274.11694950980],
[0.00000000051, 2.48654805044, 6467.92575796160],
[0.00000000047, 3.25899585469, 26724.89941359840],
[0.00000000048, 1.12255878532, 1349.86740965880],
[0.00000000048, 2.87122326236, 242.72860397400],
[0.00000000045, 1.61358524585, 5729.50644714900],
[0.00000000043, 2.24334731490, 7.11354700080],
[0.00000000044, 4.61065704096, 11773.37681151540],
[0.00000000042, 3.32038536161, 13365.97282514820],
[0.00000000047, 5.10736479739, 8969.56889691100],
[0.00000000044, 4.64194663616, 4399.99435688900],
[0.00000000039, 5.45779680648, 8031.09226305840],
[0.00000000044, 5.21409542420, 4136.91043351620],
[0.00000000045, 4.26206063790, 796.29800681640],
[0.00000000048, 3.04342098072, 5331.35744374080],
[0.00000000042, 2.12882700518, 213.29909543800],
[0.00000000038, 2.49365585516, 951.71840625060],
[0.00000000037, 3.44816851943, 3325.35995551480],
[0.00000000038, 3.13981385980, 3149.16416058820],
[0.00000000039, 3.64984946180, 553.56940284240],
[0.00000000036, 0.54858124109, 7632.94325965020],
[0.00000000032, 4.29985057106, 3355.86489788480],
[0.00000000037, 6.26349600634, 6682.20517446780],
[0.00000000037, 3.83188032092, 3870.30339179440],
[0.00000000031, 4.94959395405, 6680.24453233140],
[0.00000000035, 6.14813219827, 3360.96774609859],
[0.00000000029, 0.54115054572, 6681.29216370240],
[0.00000000035, 1.49899662719, 3320.25710730100],
[0.00000000033, 0.19183878029, 3347.72597370060],
[0.00000000036, 3.28055425527, 1589.07289528380],
[0.00000000031, 5.66015228291, 1066.49547719000],
[0.00000000028, 4.18178455540, 7210.91581849420],
[0.00000000025, 1.21627749818, 9492.14631500480],
[0.00000000029, 2.02283118033, 7234.79425624200],
[0.00000000024, 2.96777681837, 7064.12138562280],
[0.00000000024, 2.16823248221, 10419.98628350760],
[0.00000000022, 4.67496434823, 1194.44701022460],
[0.00000000022, 5.01797528499, 9595.23908922340],
[0.00000000028, 4.19843924702, 8429.24126646660],
[0.00000000023, 6.21195010050, 7740.60678358880],
[0.00000000025, 1.45100528915, 6872.67311951120],
[0.00000000024, 1.93342510858, 2699.73481931760],
[0.00000000028, 5.87009898150, 1052.26838318840],
[0.00000000025, 2.49707182259, 2118.76386037840],
[0.00000000020, 0.15682384975, 3205.54734666440],
[0.00000000019, 3.82087005916, 12303.06777661000],
[0.00000000020, 6.26534330674, 7875.67186362420],
[0.00000000019, 0.99282533197, 522.57741809380],
[0.00000000018, 4.11668144665, 426.59819087600],
[0.00000000020, 3.28531167827, 9225.53927328300],
[0.00000000019, 5.72169822815, 11371.70468975820],
[0.00000000018, 4.76871968197, 382.89653222320],
[0.00000000017, 0.96519535826, 191.44826611160],
[0.00000000017, 0.86184324841, 10973.55568635000],
[0.00000000018, 6.22706341047, 9381.93999378540],
[0.00000000015, 0.54135050421, 640.87760738220],
], [
[0.00000606506, 1.98050633529, 3340.61242669980],
[0.00000042611, 0.00000000000, 0.00000000000],
[0.00000013652, 1.79588228800, 6681.22485339960],
[0.00000002730, 3.45377082121, 10021.83728009940],
[0.00000000929, 3.75226159072, 3337.08930835080],
[0.00000000607, 0.10618486408, 13362.44970679920],
[0.00000000617, 1.14471772765, 3496.03282613400],
[0.00000000479, 0.70504966293, 16703.06213349900],
[0.00000000185, 3.28778562029, 3185.19202726560],
[0.00000000169, 0.29980532608, 5621.84292321040],
[0.00000000158, 1.09025317222, 20043.67456019880],
[0.00000000123, 2.55664973413, 3097.88382272579],
[0.00000000126, 4.74517022983, 3532.06069281140],
[0.00000000093, 6.03607685759, 3894.18182954220],
[0.00000000099, 4.92257049901, 2544.31441988340],
[0.00000000106, 3.41315845439, 2942.46342329160],
[0.00000000062, 6.25738949900, 3339.63210563160],
[0.00000000058, 4.64867983361, 4292.33083295040],
[0.00000000050, 3.75358626972, 6677.70173505060],
[0.00000000050, 1.89408668049, 5088.62883976680],
[0.00000000058, 3.65295480755, 6525.80445396540],
[0.00000000045, 0.38295906298, 5486.77784317500],
[0.00000000052, 3.25535694335, 4690.47983635860],
[0.00000000044, 1.89342588822, 3583.34103067380],
[0.00000000037, 0.04871920725, 2146.16541647520],
[0.00000000039, 0.91787211117, 3723.50895892300],
[0.00000000051, 5.24063514394, 5884.92684658320],
[0.00000000036, 2.79633276263, 529.69096509460],
[0.00000000032, 1.44641701752, 23384.28698689860],
[0.00000000024, 5.41362501363, 3340.59517304760],
[0.00000000023, 4.70639896508, 2787.04302385740],
[0.00000000021, 1.12581894224, 3340.62968035200],
[0.00000000021, 0.51744721589, 8962.45534991020],
[0.00000000018, 0.36433365806, 155.42039943420],
[0.00000000018, 5.53170427847, 3333.49887969900],
[0.00000000019, 4.34401282378, 6151.53388830500],
[0.00000000021, 2.94765501590, 398.14900340820],
[0.00000000020, 5.96181389299, 5092.15195811580],
[0.00000000017, 0.80891817293, 1194.44701022460],
[0.00000000011, 0.43817745316, 1059.38193018920],
[0.00000000014, 1.06654064248, 6836.64525283380],
], [
[0.00000011334, 3.45724352586, 3340.61242669980],
[0.00000013369, 0.00000000000, 0.00000000000],
[0.00000000744, 0.50445805257, 6681.22485339960],
[0.00000000148, 1.05056602649, 10021.83728009940],
[0.00000000102, 2.66185835593, 3496.03282613400],
[0.00000000053, 5.27888218929, 3337.08930835080],
[0.00000000022, 4.09971603267, 3097.88382272579],
[0.00000000023, 1.72422342130, 3185.19202726560],
[0.00000000013, 5.41704779112, 16703.06213349900],
[0.00000000013, 2.06957065662, 13362.44970679920],
[0.00000000010, 0.95989595600, 3894.18182954220],
], [
[0.00000000457, 4.86794125358, 3340.61242669980],
[0.00000000053, 5.30547050586, 6681.22485339960],
[0.00000000012, 5.75114070583, 10021.83728009940],
[0.00000000013, 4.17736925293, 3496.03282613400],
[0.00000000007, 0.00000000000, 0.00000000000],
]],
('Mars', 'R'):[[
[1.53033488276, 0.00000000000, 0.00000000000],
[0.14184953153, 3.47971283519, 3340.61242669980],
[0.00660776357, 3.81783442097, 6681.22485339960],
[0.00046179117, 4.15595316284, 10021.83728009940],
[0.00008109738, 5.55958460165, 2810.92146160520],
[0.00007485315, 1.77238998069, 5621.84292321040],
[0.00005523193, 1.36436318880, 2281.23049651060],
[0.00003825160, 4.49407182408, 13362.44970679920],
[0.00002306539, 0.09081742493, 2544.31441988340],
[0.00001999399, 5.36059605227, 3337.08930835080],
[0.00002484385, 4.92545577893, 2942.46342329160],
[0.00001960198, 4.74249386323, 3344.13554504880],
[0.00001167115, 2.11261501155, 5092.15195811580],
[0.00001102828, 5.00908264160, 398.14900340820],
[0.00000899077, 4.40790433994, 529.69096509460],
[0.00000992252, 5.83862401067, 6151.53388830500],
[0.00000807348, 2.10216647104, 1059.38193018920],
[0.00000797910, 3.44839026172, 796.29800681640],
[0.00000740980, 1.49906336892, 2146.16541647520],
[0.00000692340, 2.13378814785, 8962.45534991020],
[0.00000633144, 0.89353285018, 3340.59517304760],
[0.00000725583, 1.24516913473, 8432.76438481560],
[0.00000633140, 2.92430448169, 3340.62968035200],
[0.00000574352, 0.82896196337, 2914.01423582380],
[0.00000526187, 5.38292276228, 3738.76143010800],
[0.00000629976, 1.28738135858, 1751.53953141600],
[0.00000472776, 5.19850457873, 3127.31333126180],
[0.00000348095, 4.83219198908, 16703.06213349900],
[0.00000283702, 2.90692294913, 3532.06069281140],
[0.00000279552, 5.25749247548, 6283.07584999140],
[0.00000233827, 5.10546492529, 5486.77784317500],
[0.00000219428, 5.58340248784, 191.44826611160],
[0.00000269891, 3.76394728622, 5884.92684658320],
[0.00000208333, 5.25476080773, 3340.54511639700],
[0.00000275224, 2.90818883832, 1748.01641306700],
[0.00000275501, 1.21767967781, 6254.62666252360],
[0.00000239133, 2.03669896238, 1194.44701022460],
[0.00000223190, 4.19861593779, 3149.16416058820],
[0.00000182686, 5.08062683355, 6684.74797174860],
[0.00000186213, 5.69871555748, 6677.70173505060],
[0.00000175995, 5.95341786369, 3870.30339179440],
[0.00000178613, 4.18423025538, 3333.49887969900],
[0.00000208336, 4.84626442122, 3340.67973700260],
[0.00000228128, 3.25529020620, 6872.67311951120],
[0.00000144286, 0.21296012258, 5088.62883976680],
[0.00000163534, 3.79889068111, 4136.91043351620],
[0.00000133120, 1.53910106710, 7903.07341972100],
[0.00000141759, 2.47790321309, 4562.46099302120],
[0.00000114941, 4.31745088059, 1349.86740965880],
[0.00000118781, 2.12178071222, 1589.07289528380],
[0.00000102096, 6.18138550087, 9492.14631500480],
[0.00000128555, 5.49883294915, 8827.39026987480],
[0.00000111538, 0.55339169625, 11243.68584642080],
[0.00000082498, 1.62227044590, 11773.37681151540],
[0.00000083212, 0.61553380568, 8429.24126646660],
[0.00000084470, 0.62274593110, 1592.59601363280],
[0.00000086659, 1.74988330093, 2700.71514038580],
[0.00000071826, 2.47489899385, 12303.06777661000],
[0.00000085312, 1.61621097912, 4690.47983635860],
[0.00000063641, 2.67334126661, 426.59819087600],
[0.00000068599, 2.40197828418, 4399.99435688900],
[0.00000058559, 4.72052787516, 213.29909543800],
[0.00000062015, 1.10065866221, 1221.84856632140],
[0.00000066509, 2.21307705185, 6041.32756708560],
[0.00000055811, 1.23288325946, 3185.19202726560],
[0.00000054989, 5.72691385306, 951.71840625060],
[0.00000052418, 3.02366828926, 4292.33083295040],
[0.00000055686, 5.44686699242, 3723.50895892300],
[0.00000058959, 3.26242666052, 6681.24210705180],
[0.00000044629, 2.01473640390, 8031.09226305840],
[0.00000058959, 1.23165502899, 6681.20759974740],
[0.00000042444, 2.26551590902, 155.42039943420],
[0.00000038956, 2.57760416009, 3341.59274776800],
[0.00000051561, 5.72326937712, 7079.37385680780],
[0.00000048939, 5.61614696751, 3553.91152213780],
[0.00000045414, 5.43290921705, 6467.92575796160],
[0.00000036435, 4.43921812388, 3894.18182954220],
[0.00000035980, 1.15966567007, 2288.34404351140],
[0.00000035265, 5.49029710802, 1990.74501704100],
[0.00000042191, 1.63253742760, 5628.95647021120],
[0.00000044292, 5.00341366850, 5614.72937620960],
[0.00000033623, 5.17029029766, 20043.67456019880],
[0.00000043256, 1.03732072925, 11769.85369316640],
[0.00000039237, 1.24237122859, 3339.63210563160],
[0.00000031943, 4.59258406791, 2274.11694950980],
[0.00000030345, 2.44177670130, 11371.70468975820],
[0.00000032259, 2.38215172582, 4535.05943692440],
[0.00000031870, 4.37521442752, 3.52311834900],
[0.00000029350, 4.06034813442, 3097.88382272579],
[0.00000031972, 1.93970478412, 382.89653222320],
[0.00000026166, 5.58466944895, 9623.68827669120],
[0.00000027904, 4.25805969214, 3191.04922956520],
[0.00000033065, 0.85467740581, 553.56940284240],
[0.00000027543, 1.57668567401, 9595.23908922340],
[0.00000025159, 0.81355213242, 10713.99488132620],
[0.00000022070, 0.85747723964, 3319.83703120740],
[0.00000024772, 5.38970742761, 2818.03500860600],
[0.00000023359, 6.01453778225, 3496.03282613400],
[0.00000024732, 2.58034797703, 2803.80791460440],
[0.00000019365, 5.18528750472, 6681.29216370240],
[0.00000019122, 5.41968559451, 10025.36039844840],
[0.00000019364, 5.59378382138, 6681.15754309680],
[0.00000018330, 5.79567324240, 7064.12138562280],
[0.00000018193, 5.61307426173, 7.11354700080],
[0.00000020392, 4.53637816869, 6489.77658728800],
[0.00000021260, 6.19160142215, 14054.60730802600],
[0.00000017094, 1.55004739305, 2957.71589447660],
[0.00000022791, 3.41709388606, 7632.94325965020],
[0.00000020585, 2.98697279083, 3361.38782219220],
[0.00000018005, 2.81431094394, 4032.77002792660],
[0.00000017049, 6.15528099726, 10404.73381232260],
[0.00000016488, 3.84534700818, 10973.55568635000],
[0.00000016052, 0.92823508003, 14584.29827312060],
[0.00000021027, 2.38474290907, 4989.05918389720],
[0.00000016267, 1.92321585819, 7373.38245462640],
[0.00000016291, 6.28233085307, 7210.91581849420],
[0.00000018585, 4.07325116588, 2388.89402044920],
[0.00000015977, 4.58368417141, 3264.34635542420],
[0.00000019913, 2.73518445950, 5099.26550511660],
[0.00000019661, 1.86285979000, 3443.70520091840],
[0.00000016500, 4.14061745086, 7477.52286021600],
[0.00000019495, 6.03778234182, 10018.31416175040],
[0.00000015104, 2.65433427561, 2787.04302385740],
[0.00000019099, 0.22623441108, 13745.34623902240],
[0.00000017163, 3.18825562972, 3347.72597370060],
[0.00000013423, 2.12818658793, 3344.20285535160],
[0.00000015410, 2.20773507960, 2118.76386037840],
[0.00000017238, 3.67067776368, 3205.54734666440],
[0.00000013113, 4.27490214998, 14314.16811304980],
[0.00000016451, 2.86641622696, 14712.31711645800],
[0.00000013734, 1.68629769646, 3337.02199804800],
[0.00000016659, 4.52130808861, 6674.11130639880],
[0.00000011830, 0.19684525299, 3475.67750673520],
[0.00000011767, 3.22897247987, 5828.02847164760],
[0.00000011886, 4.82057654742, 7234.79425624200],
[0.00000010609, 1.73997337551, 639.89728631400],
[0.00000011154, 0.23859830185, 12832.75874170460],
[0.00000011030, 0.44541706440, 10213.28554621100],
[0.00000010240, 5.74758340632, 242.72860397400],
[0.00000010051, 2.45102946726, 4929.68532198360],
[0.00000010061, 0.78907665448, 9381.93999378540],
[0.00000010065, 5.37506605762, 5085.03841111500],
[0.00000011902, 0.79897698904, 3265.83082813250],
[0.00000008990, 0.96463418322, 4933.20844033260],
[0.00000008970, 4.18326774405, 9225.53927328300],
[0.00000008982, 1.98501418026, 15113.98923821520],
[0.00000008324, 1.93694866513, 1648.44675719740],
[0.00000007833, 2.04997447879, 1758.65307841680],
[0.00000007957, 3.92331072722, 2921.12778282460],
[0.00000010224, 2.66497189021, 2487.41604494780],
[0.00000008277, 0.94860765546, 2906.90068882300],
[0.00000007371, 0.84378341481, 692.15760122680],
[0.00000007545, 5.68031160782, 13916.01910964160],
[0.00000007912, 2.81294761885, 15643.68020330980],
[0.00000006958, 3.32193127272, 3230.40610548040],
[0.00000007426, 6.09656283295, 3583.34103067380],
[0.00000006402, 4.19806996774, 5202.35827933520],
[0.00000006529, 6.11929252710, 135.06508003540],
[0.00000006130, 0.00117252232, 6836.64525283380],
[0.00000006226, 6.10683955669, 17256.63153634140],
[0.00000008193, 5.24811458833, 10575.40668294180],
[0.00000006168, 3.60069207439, 10021.85453375160],
[0.00000006169, 1.56992114335, 10021.82002644720],
[0.00000005671, 0.13650306660, 13524.91634293140],
[0.00000006257, 4.50450768937, 8425.65083781480],
[0.00000005249, 2.70122358603, 4459.36821880260],
[0.00000006479, 2.74267498287, 7740.60678358880],
[0.00000005530, 6.06408145092, 10419.98628350760],
[0.00000005536, 5.74996063243, 12168.00269657460],
[0.00000006826, 4.69327545839, 17654.78053974960],
[0.00000005005, 4.68382632238, 522.57741809380],
[0.00000006328, 3.31896726895, 3767.21061757580],
[0.00000004734, 0.00755678425, 3325.35995551480],
[0.00000005032, 2.33696685608, 1052.26838318840],
[0.00000004661, 5.15051711401, 1066.49547719000],
[0.00000004724, 5.77956037309, 9808.53818466140],
[0.00000005136, 1.57259709878, 6525.80445396540],
[0.00000004522, 1.44218620352, 3369.06161416760],
[0.00000006189, 4.58996159356, 6531.66165626500],
[0.00000006205, 4.48164856516, 22747.29071487440],
[0.00000005329, 4.55145599182, 1744.42598441520],
[0.00000004511, 5.94511266539, 6894.52394883760],
[0.00000004330, 3.10901365758, 4569.57454002200],
[0.00000005366, 5.08043436437, 2707.82868738660],
[0.00000005134, 1.28568358496, 8439.87793181640],
[0.00000004127, 5.48538052912, 2699.73481931760],
[0.00000005394, 5.21695066244, 5305.45105355380],
[0.00000004449, 5.56764082611, 16865.52876963120],
[0.00000003898, 1.48782434790, 9168.64089834740],
[0.00000003863, 1.23050803930, 16858.48253293320],
[0.00000003766, 0.27090392616, 17395.21973472580],
[0.00000004683, 3.05668892586, 5518.75014899180],
[0.00000004258, 2.79090145790, 3503.07906283200],
[0.00000003864, 0.37957291785, 10177.25767953360],
[0.00000003992, 1.84424768030, 3134.42687826260],
[0.00000003643, 2.95318600206, 6144.42034130420],
[0.00000003654, 1.58063207414, 6680.24453233140],
[0.00000003931, 1.98436570971, 8969.56889691100],
[0.00000003350, 2.72637081667, 7875.67186362420],
[0.00000003623, 2.91544991631, 6682.20517446780],
[0.00000004392, 0.81931997702, 3302.47939106200],
[0.00000004062, 5.46935175827, 3120.19978426100],
[0.00000003319, 1.77193665786, 3116.26763099790],
[0.00000003510, 1.18027333874, 10184.30391623160],
[0.00000004008, 1.33675167812, 6247.51311552280],
[0.00000003603, 0.15469852619, 2178.13772229200],
[0.00000003313, 3.12853663982, 17277.40693183380],
[0.00000004138, 4.39568891039, 3074.00538497800],
[0.00000003201, 3.36492925275, 2384.32327072920],
[0.00000003991, 3.82867836910, 3355.86489788480],
[0.00000004205, 1.90532279170, 263.08392337280],
[0.00000003743, 4.25458024187, 6261.74020952440],
[0.00000003111, 1.65445053349, 20199.09495963300],
[0.00000003634, 5.55063049451, 632.78373931320],
[0.00000002892, 1.91514920700, 12935.85151592320],
[0.00000003373, 5.50812408522, 23384.28698689860],
[0.00000003312, 5.83174680245, 5331.35744374080],
[0.00000003124, 5.44069658195, 6048.44111408640],
[0.00000003813, 0.80274487430, 13517.87010623340],
[0.00000003612, 3.68140265686, 5724.93569742900],
[0.00000002813, 1.68598843422, 2391.43681773000],
[0.00000002902, 5.30666239739, 8955.34180290940],
[0.00000003225, 2.29832592489, 3312.16323923200],
[0.00000003863, 3.48188264725, 20618.01935853360],
[0.00000002738, 5.49768261369, 149.56319713460],
[0.00000002809, 4.76933217397, 1964.83862685400],
[0.00000002711, 2.69244730345, 3178.14579056760],
[0.00000002711, 2.38275660721, 2648.45482547300],
[0.00000002743, 1.09492569851, 536.80451209540],
[0.00000002821, 5.91845472246, 12964.30070339100],
[0.00000002716, 6.10377796874, 3973.39616601300],
[0.00000002487, 3.87703916286, 1861.74585263540],
[0.00000002617, 2.65526535627, 8329.67161059700],
[0.00000002938, 5.68402398615, 6158.64743530580],
[0.00000002336, 3.24847913311, 4672.66731424060],
[0.00000002318, 1.69214259672, 3914.95722503460],
[0.00000002371, 4.75067664712, 103.09277421860],
[0.00000002963, 0.23381699914, 20597.24396304120],
[0.00000002190, 6.18344448099, 3346.13535100720],
[0.00000002444, 1.92547995169, 7799.98064550240],
[0.00000002121, 4.87491216115, 9830.38901398780],
[0.00000002532, 5.39550087270, 3863.18984479360],
[0.00000002101, 2.84309138388, 3415.39402526710],
[0.00000002176, 0.58632570025, 162.46663613220],
[0.00000002106, 3.06229353931, 19800.94595622480],
[0.00000002347, 3.90795942709, 3335.08950239240],
[0.00000002031, 5.52057907797, 10021.90459040220],
[0.00000001997, 2.77243710569, 13936.79450513400],
[0.00000002139, 5.40620646615, 266.60704172180],
[0.00000002147, 0.08966987600, 13358.92658845020],
[0.00000001996, 2.62541669265, 20.77539549240],
[0.00000001961, 4.88521794174, 3237.51965248120],
[0.00000002216, 1.06829128652, 3320.25710730100],
[0.00000002131, 3.02112533027, 5625.36604155940],
[0.00000002124, 3.68620121537, 5618.31980486140],
[0.00000001938, 1.29006691721, 17924.91069982040],
[0.00000002555, 4.91826220321, 6604.95878212400],
[0.00000002561, 2.10055088914, 7910.18696672180],
[0.00000001820, 5.57528712663, 3351.24909204960],
[0.00000001786, 5.77310414452, 3607.21946842160],
[0.00000001780, 4.48010071981, 10818.13528691580],
[0.00000002106, 5.75526661975, 13365.97282514820],
[0.00000001987, 2.61151965233, 3546.79797513700],
[0.00000001799, 2.73192475257, 3360.96774609859],
[0.00000001715, 1.50805385053, 1692.16566950240],
[0.00000001752, 2.21455466761, 13119.72110282519],
[0.00000001913, 3.32230688971, 6702.00024889200],
[0.00000001724, 1.43449979531, 4885.96640967860],
[0.00000002050, 1.19293239093, 6660.44945790720],
[0.00000001774, 2.18404386388, 6784.31762761820],
[0.00000001722, 4.86031154305, 10014.72373309860],
[0.00000001773, 2.09448668554, 3603.69635007260],
[0.00000001606, 3.48105136801, 23141.55838292460],
[0.00000001621, 5.73820120882, 4555.34744602040],
[0.00000001579, 1.88769198841, 6298.32832117640],
[0.00000001530, 5.16381564230, 76.26607127560],
[0.00000001615, 3.24110713658, 3657.00429635640],
[0.00000001576, 3.52622401575, 6688.33840040040],
[0.00000002034, 2.63620520451, 16460.33352952499],
[0.00000002025, 5.92907541624, 10021.76996979660],
[0.00000001689, 4.41053057494, 5729.50644714900],
[0.00000001878, 4.53291044847, 3329.97576135000],
[0.00000001530, 4.76331644411, 7895.95987272020],
[0.00000001529, 1.35289110986, 1581.95934828300],
[0.00000001807, 1.86212004697, 2693.60159338500],
[0.00000001855, 2.38561742394, 6843.69148953180],
[0.00000001518, 3.98476157750, 6546.15977336420],
[0.00000001389, 1.82099537095, 9779.10867612540],
[0.00000001447, 2.35649936427, 6034.21402008480],
[0.00000001386, 5.55304113895, 4775.76008845920],
[0.00000001372, 1.07224580315, 12722.55242048520],
[0.00000001423, 4.46530428193, 574.34479833480],
[0.00000001424, 2.57162391016, 3399.98628861340],
[0.00000001380, 5.76156315252, 16335.83780453660],
[0.00000001338, 2.97604558638, 6127.65545055720],
[0.00000001479, 4.74310691166, 12566.15169998280],
[0.00000001706, 0.30579918494, 10551.52824519400],
[0.00000001281, 2.00285974432, 6677.63442474780],
[0.00000001350, 0.78892333409, 853.19638175200],
[0.00000001534, 4.33326399444, 640.87760738220],
[0.00000001247, 1.02503908468, 3024.22055704320],
[0.00000001289, 1.92786975543, 3347.65866339780],
[0.00000001243, 2.44217806237, 6684.81528205140],
[0.00000001453, 1.74218016403, 3333.56619000180],
[0.00000001675, 1.79693456330, 1118.75579210280],
[0.00000001491, 2.59386711806, 2494.52959194860],
[0.00000001293, 3.31710472549, 3407.09983561420],
[0.00000001188, 4.92989260576, 22743.40937951640],
[0.00000001329, 1.99426530402, 1228.96211332220],
[0.00000001373, 2.53354987340, 5459.37628707820],
[0.00000001183, 4.25338096667, 3344.49376205780],
[0.00000001231, 2.50206227837, 4356.27544458400],
[0.00000001243, 2.65176267860, 74.78159856730],
[0.00000001285, 4.34087881585, 3326.38533269820],
[0.00000001119, 1.91321862491, 3281.23856478620],
[0.00000001094, 5.50748655535, 3017.10701004240],
[0.00000001259, 3.77654662830, 11236.57229942000],
[0.00000001285, 1.38335267684, 3077.52850332700],
[0.00000001100, 1.17130732373, 6606.44325483230],
[0.00000001115, 5.81275569652, 2675.85638156980],
[0.00000001380, 5.70641426169, 2807.39834325620],
[0.00000001256, 3.35479933251, 4039.88357492740],
[0.00000001187, 2.41348693872, 10596.18207843420],
[0.00000001052, 3.33521939538, 3304.58456002240],
[0.00000001188, 5.84735836632, 3336.73109134180],
[0.00000001072, 2.78383184435, 8270.29774868340],
[0.00000001105, 3.03463252672, 3929.67725370800],
[0.00000001013, 3.52026711847, 8013.27974094040],
[0.00000001079, 0.51857999039, 2814.44457995420],
[0.00000000999, 4.72734008760, 533.21408344360],
[0.00000001131, 0.52584038526, 6816.28993343500],
[0.00000001191, 0.60874292520, 2301.58581590939],
[0.00000001313, 2.07273299121, 23539.70738633280],
[0.00000000996, 4.03971126547, 16062.18452611680],
[0.00000000954, 5.90340414098, 20206.14119633100],
[0.00000000993, 0.07132588892, 24150.08005134500],
[0.00000001051, 2.22096534870, 3980.50971301380],
[0.00000001089, 1.25512213569, 5938.23479286700],
[0.00000000912, 2.54221161167, 433.71173787680],
[0.00000001249, 0.60003625956, 16173.37116840440],
[0.00000001027, 4.95999945094, 19676.45023123640],
[0.00000001108, 4.34209448160, 3339.12795399150],
[0.00000001188, 6.21563747433, 2679.37949991880],
[0.00000000849, 0.82548606454, 2597.62236616720],
[0.00000001145, 4.48151980872, 19402.79695281660],
[0.00000000948, 1.30280088857, 8273.82086703240],
[0.00000001016, 5.14464815830, 1596.18644228460],
[0.00000000832, 5.60623652030, 3340.19235060619],
[0.00000001035, 4.71893106874, 419.48464387520],
[0.00000000903, 0.45419000582, 12995.22537783680],
[0.00000001089, 0.51294377637, 11250.79939342160],
[0.00000000840, 5.30858028008, 26084.02180621620],
[0.00000000990, 2.06776368865, 7255.56965173440],
[0.00000000808, 6.25630819993, 15508.61512327440],
[0.00000000806, 3.09007612135, 5415.65737477320],
[0.00000000782, 4.62274599734, 2547.83753823240],
[0.00000000963, 2.10680539916, 6456.88005769770],
[0.00000000778, 3.56602161857, 12721.57209941700],
[0.00000000873, 5.09097164784, 2540.79130153440],
[0.00000000772, 3.08101797047, 11081.21921028860],
[0.00000000965, 2.33106703115, 18454.60166491500],
[0.00000000859, 4.14788214122, 6438.49624942560],
[0.00000001012, 4.45011664540, 3316.73398895200],
[0.00000000906, 4.29336078401, 3344.54457996290],
[0.00000000741, 2.61446403580, 2284.75361485960],
[0.00000000790, 6.03436225041, 12509.25332504720],
[0.00000000738, 0.52092422137, 18052.92954315780],
[0.00000000737, 4.11165247543, 3760.09707057500],
[0.00000000727, 3.28066632751, 3510.19260983280],
[0.00000001006, 0.45037465289, 27490.69247804480],
[0.00000000923, 2.78717931388, 1332.05488754080],
[0.00000000756, 0.86881841787, 1545.35398297880],
[0.00000000774, 3.71535541900, 6571.01853218020],
[0.00000000900, 2.74944190055, 316.39186965660],
[0.00000000704, 1.89617185328, 13362.43245314700],
[0.00000000701, 2.21328293796, 20995.39296644940],
[0.00000000701, 3.92689438700, 13362.46696045140],
[0.00000000695, 5.52658147215, 3364.49086444760],
[0.00000000764, 1.88253040972, 5732.04924442980],
[0.00000000693, 0.34849213821, 5835.14201864840],
[0.00000000698, 1.79132650081, 206.18554843720],
[0.00000000687, 0.11649928911, 13760.59871020740],
[0.00000000827, 0.49766945172, 3376.64029337720],
[0.00000000686, 0.23965591265, 2409.24933984800],
[0.00000000672, 0.51352450554, 25685.87280280800],
[0.00000000699, 5.90167595080, 19004.64794940840],
[0.00000000647, 3.01091875955, 5223.69391980220],
[0.00000000643, 4.88507402785, 11766.26326451460],
[0.00000000723, 3.28296530537, 4142.97634914600],
[0.00000000660, 4.27334393830, 1214.73501932060],
[0.00000000675, 0.48874492682, 5408.54382777240],
[0.00000000809, 3.13310075522, 18984.29263000960],
[0.00000000646, 3.63004914186, 7107.82304427560],
[0.00000000831, 4.49449658957, 3341.03250279340],
[0.00000000680, 0.16949964513, 110.20632121940],
[0.00000000592, 6.03272224596, 20809.46762464520],
[0.00000000627, 4.93438097728, 9872.27408296480],
[0.00000000698, 1.45709305452, 3377.21779200400],
[0.00000000583, 4.01887095237, 664.75604513000],
[0.00000000591, 4.01381288194, 19406.67828817460],
[0.00000000571, 1.20823284619, 5621.86017686260],
[0.00000000680, 4.72905586557, 8116.37251515900],
[0.00000000739, 3.19765996917, 9380.95967271720],
[0.00000000571, 5.46064659057, 5621.82566955820],
[0.00000000702, 0.14107083764, 6923.95345737360],
[0.00000000598, 3.05986754375, 3341.04230982650],
[0.00000000601, 2.17944973698, 7270.28968040780],
[0.00000000572, 0.42001145821, 15110.46611986620],
[0.00000000655, 1.08706089359, 3169.93955608060],
[0.00000000582, 1.68224967199, 26087.90314157420],
[0.00000000543, 2.42716241058, 170.67287061920],
[0.00000000543, 1.68460678113, 11780.49035851620],
[0.00000000533, 2.63982684952, 2277.70737816160],
[0.00000000550, 2.54220679987, 7380.49600162720],
[0.00000000576, 1.69042028754, 3384.33133900480],
[0.00000000535, 5.01279223460, 1375.77379984580],
[0.00000000579, 5.99182453047, 2149.68853482420],
[0.00000000598, 0.75754342787, 3340.18254357310],
[0.00000000575, 1.33793171924, 3296.89351439480],
[0.00000000689, 0.02993986536, 22345.26037610820],
[0.00000000526, 6.14212516186, 13149.15061136120],
[0.00000000540, 5.54137118955, 8646.06348025360],
[0.00000000528, 2.74183495775, 3826.58447948940],
[0.00000000689, 6.28205551764, 12295.95422960920],
[0.00000000499, 0.25665224668, 2142.64229812620],
[0.00000000498, 5.91370528026, 6460.81221096080],
[0.00000000588, 3.39977690249, 3329.56672643590],
[0.00000000507, 0.63367870048, 20735.83216142559],
[0.00000000590, 3.87951788923, 9065.54812412880],
[0.00000000509, 2.59333214746, 3877.41693879520],
[0.00000000486, 4.01113864377, 23937.85638974100],
[0.00000000541, 1.55072392536, 2221.85663459700],
[0.00000000482, 0.00200643783, 10235.13637553740],
[0.00000000474, 4.14503805378, 3113.13629391080],
[0.00000000523, 2.89171162726, 6040.34724601740],
[0.00000000458, 4.08131432844, 1162.47470440780],
[0.00000000493, 2.98933582802, 1039.02661079040],
[0.00000000489, 4.88201647585, 5511.63660199100],
[0.00000000537, 1.24870344441, 48835.19385644859],
[0.00000000585, 5.53384919340, 4981.94563689640],
[0.00000000462, 5.38999453893, 15664.03552270859],
[0.00000000531, 1.22287288928, 10721.10842832700],
[0.00000000440, 4.69966067585, 799.82112516540],
[0.00000000588, 5.15076051189, 3873.82651014340],
[0.00000000465, 5.49236978535, 3342.09689940810],
[0.00000000545, 5.91813092143, 1478.86657406440],
[0.00000000440, 2.28287871244, 12310.18132361080],
[0.00000000436, 0.12478564862, 956.28915597060],
[0.00000000573, 3.86388572602, 26482.17080962440],
[0.00000000429, 1.20474317285, 28.44918746780],
[0.00000000435, 3.75437730899, 5195.24473233440],
[0.00000000457, 1.45606713663, 5636.07001721200],
[0.00000000553, 5.30628175145, 2766.26762836500],
[0.00000000494, 0.63303483918, 3274.12501778540],
[0.00000000530, 3.18458612574, 8535.85715903420],
[0.00000000535, 1.89165024367, 9866.41688066520],
[0.00000000433, 0.33270291162, 6665.97238221460],
[0.00000000404, 4.67939964590, 4825.54491639400],
[0.00000000402, 3.25727658426, 5820.91492464680],
[0.00000000415, 1.41915166067, 21947.11137270000],
[0.00000000414, 3.32843373219, 8859.36257569160],
[0.00000000403, 1.68400791606, 9588.12554222260],
[0.00000000399, 0.93465630912, 2295.45759051220],
[0.00000000402, 0.85364636108, 29026.48522950779],
[0.00000000494, 4.57792960199, 8542.97070603500],
[0.00000000413, 2.60545132222, 38.13303563780],
[0.00000000413, 5.44081623497, 4407.10790388980],
[0.00000000404, 5.33168348188, 3189.56475685690],
[0.00000000385, 1.90313951519, 10020.85695903120],
[0.00000000454, 1.18358809702, 10610.90210710760],
[0.00000000381, 4.90212003667, 19146.75926614180],
[0.00000000415, 3.07892141478, 11216.28429032400],
[0.00000000378, 0.19461412344, 2067.93140107260],
[0.00000000418, 1.14626975196, 6643.09181776180],
[0.00000000426, 4.33863084563, 220.41264243880],
[0.00000000412, 0.02314567339, 3192.53370227350],
[0.00000000391, 4.75902617217, 6414.61781167780],
[0.00000000399, 1.37708573980, 9654.61295113700],
[0.00000000381, 2.74120772781, 1854.63230563460],
[0.00000000378, 4.16366866018, 13553.89797291080],
[0.00000000409, 3.12117409635, 3723.49170527080],
[0.00000000379, 5.87578711682, 6357.71943674220],
[0.00000000375, 3.29175394061, 31022.75317085620],
[0.00000000358, 3.99134138048, 8958.93223156120],
[0.00000000390, 2.01175211992, 1903.43681250120],
[0.00000000373, 1.27018251531, 2111.65031337760],
[0.00000000493, 4.66294641806, 1435.14766175940],
[0.00000000379, 4.08720452061, 10706.88133432540],
[0.00000000461, 1.90122301470, 25287.72379939980],
[0.00000000364, 3.25231136840, 5095.67507646480],
[0.00000000382, 2.18684874688, 16276.46394262300],
[0.00000000359, 2.29096599931, 28628.33622609960],
[0.00000000362, 4.15084528423, 6696.47732458460],
[0.00000000374, 5.78780163439, 3490.17562383440],
[0.00000000386, 4.73230339383, 3981.49003408200],
[0.00000000344, 5.79156714790, 26880.31981303260],
[0.00000000368, 3.44405073824, 15.25247118500],
[0.00000000410, 1.76294940448, 6709.67404086740],
[0.00000000339, 1.71242500987, 224.34479570190],
[0.00000000373, 2.71286157688, 3472.15438838620],
[0.00000000334, 1.10569460106, 59.37386191360],
[0.00000000394, 4.02046774116, 2075.04494807340],
[0.00000000402, 3.27520695853, 931.36308685180],
[0.00000000318, 3.28892524780, 9485.03276800400],
[0.00000000319, 4.05344391333, 3450.81874791920],
[0.00000000341, 6.08567978892, 17085.95866572220],
[0.00000000378, 0.71609301686, 3209.07046501340],
[0.00000000326, 4.58257191106, 8982.81066930900],
[0.00000000369, 6.17228742886, 8671.96987044060],
[0.00000000308, 1.01924467785, 18606.49894600020],
[0.00000000370, 2.84011243059, 4392.88080988820],
[0.00000000303, 5.00239879717, 2810.93871525740],
[0.00000000303, 2.97162741204, 2810.90420795300],
[0.00000000419, 2.79830562400, 5106.37905211740],
[0.00000000358, 1.15955325186, 4076.48894023160],
[0.00000000360, 5.83226123310, 26724.89941359840],
[0.00000000298, 5.57160706753, 3041.48603243060],
[0.00000000298, 3.06970285022, 11670.28403729680],
[0.00000000388, 5.01197738185, 12323.42309600880],
[0.00000000336, 4.60208332758, 9602.35263622420],
[0.00000000371, 2.23508025241, 4996.17273089800],
[0.00000000300, 6.04069385215, 9499.25986200560],
[0.00000000345, 1.74260482164, 5617.91076994730],
[0.00000000302, 3.01127349940, 7483.58877584580],
[0.00000000289, 0.39479288685, 2412.77245819700],
[0.00000000289, 2.21430640344, 11140.59307220220],
[0.00000000330, 5.81605457596, 4246.06912336460],
[0.00000000394, 2.12229107240, 6475.03930496240],
[0.00000000301, 5.26147877814, 9945.57120882380],
[0.00000000338, 4.94717046909, 5625.77507647350],
[0.00000000372, 5.46968662800, 3561.02506913860],
[0.00000000279, 0.54063870001, 3226.21331978640],
[0.00000000291, 5.21021494024, 13171.00144068760],
[0.00000000384, 3.23921380878, 10022.81760116760],
[0.00000000309, 3.17514941939, 14047.49376102520],
[0.00000000273, 1.68203034215, 4253.18267036540],
[0.00000000272, 0.11218647217, 7314.00859271280],
[0.00000000281, 5.15132055967, 2825.14855560680],
[0.00000000292, 3.33720586058, 9468.26787725700],
[0.00000000316, 1.41719074976, 589.06482700820],
[0.00000000264, 0.48845594730, 16699.53901514999],
[0.00000000266, 1.69694779915, 647.01083331480],
[0.00000000318, 2.47072726153, 8436.28750316460],
[0.00000000260, 2.54459932529, 20.35531939880],
[0.00000000275, 2.78608579994, 2970.91261075940],
[0.00000000295, 5.96367554548, 4025.65648092580],
[0.00000000268, 3.01034973031, 6518.75821726740],
[0.00000000259, 5.20888482695, 7366.26890762560],
[0.00000000298, 2.71010678192, 6652.77566593180],
[0.00000000276, 0.78545108300, 3735.23831175900],
[0.00000000305, 6.19137255377, 6677.34351804160],
[0.00000000265, 3.25145629239, 24889.57479599160],
[0.00000000260, 3.99612605351, 2171.02417529120],
[0.00000000252, 4.14773813625, 5642.19824260920],
[0.00000000254, 1.38470256851, 846.08283475120],
[0.00000000258, 2.03261985834, 2089.78223039900],
[0.00000000298, 3.81212222628, 28230.18722269139],
[0.00000000241, 2.96550398155, 27682.14074415640],
[0.00000000259, 4.79545870271, 6657.34641565180],
[0.00000000238, 1.18977479528, 3171.03224356680],
[0.00000000256, 1.01427800277, 568.82187402740],
[0.00000000236, 5.56425829084, 14.22709400160],
[0.00000000304, 3.81556245925, 1190.92389187560],
[0.00000000237, 1.37222961867, 2277.29834324750],
[0.00000000239, 2.47752611026, 5430.39465709880],
[0.00000000234, 4.34929504798, 6675.70192909220],
[0.00000000239, 0.14012746335, 3742.28454845700],
[0.00000000286, 5.04045301355, 5607.61582920880],
[0.00000000305, 4.59739079660, 6685.10618875760],
[0.00000000254, 5.03693878366, 1905.46476494040],
[0.00000000323, 1.67390215145, 4922.57177498280],
[0.00000000232, 4.82565548677, 9070.11887384880],
[0.00000000236, 2.40662610715, 3620.39893105220],
[0.00000000260, 5.72282468723, 17468.85519794540],
[0.00000000259, 6.15179402778, 16706.58525184800],
[0.00000000263, 0.63922292958, 2008.55753915900],
[0.00000000300, 3.78527265088, 34363.36559755600],
[0.00000000226, 1.86970344963, 6418.14093002680],
[0.00000000239, 0.04616997400, 13362.38239649640],
[0.00000000241, 4.85896907298, 14158.74771361560],
[0.00000000225, 1.70179250908, 18451.07854656599],
[0.00000000288, 2.26316945288, 6621.85099148600],
[0.00000000231, 2.19861265305, 3936.79080070880],
[0.00000000251, 5.51232121883, 3416.87849797540],
[0.00000000245, 3.30613942274, 1197.97012857360],
[0.00000000253, 4.54308131689, 2285.16264977370],
[0.00000000225, 5.50822507089, 4936.79886898440],
[0.00000000249, 1.06089727346, 3313.21087060300],
[0.00000000309, 6.21936675838, 16304.91313009080],
[0.00000000244, 1.94855224181, 3.59042865180],
[0.00000000287, 5.70461951656, 792.77488846740],
[0.00000000254, 5.34446995416, 5401.43028077160],
[0.00000000263, 1.49663212332, 6364.83298374300],
[0.00000000223, 2.66825139116, 31968.94865279940],
[0.00000000222, 2.48370132727, 5355.23588148860],
[0.00000000220, 5.20799024654, 23017.06265793620],
[0.00000000215, 2.72743996418, 6740.59871531320],
[0.00000000218, 1.30797197521, 29822.78323632420],
[0.00000000270, 0.90714939427, 6155.05700665400],
[0.00000000216, 4.73975263349, 6679.74038069130],
[0.00000000211, 3.72756562629, 10042.61267559180],
[0.00000000211, 2.61999755641, 10124.93005431800],
[0.00000000293, 6.07059383381, 14061.72085502680],
[0.00000000219, 2.98472846458, 131.54196168640],
[0.00000000210, 5.27496906319, 13355.33615979840],
[0.00000000259, 1.25267305830, 2641.34127847220],
[0.00000000208, 3.30241021109, 6850.80503653260],
[0.00000000226, 5.48438086246, 7203.80227149340],
[0.00000000243, 2.44748800604, 3311.18291816379],
[0.00000000208, 1.13500579457, 5888.44996493220],
[0.00000000251, 4.67012983729, 6666.99775939800],
[0.00000000227, 1.59926413307, 10001.06188460700],
[0.00000000264, 3.72622435628, 6747.71226231400],
[0.00000000216, 0.34122804918, 6686.74777770700],
[0.00000000260, 3.67749190896, 6645.19698672220],
[0.00000000209, 4.31928920378, 3337.86091608880],
[0.00000000218, 4.08068730999, 3378.74546233760],
[0.00000000275, 1.64274205426, 2011.10033643980],
[0.00000000204, 0.73237459784, 3.93215326310],
[0.00000000219, 0.88584017263, 19513.98359510420],
[0.00000000205, 2.60851826933, 2771.79055267240],
[0.00000000215, 2.99299817517, 10824.20120254560],
[0.00000000249, 0.99914444136, 5753.38488489680],
[0.00000000225, 0.23309143434, 4782.87363546000],
[0.00000000275, 0.86215660461, 8749.15625447220],
[0.00000000201, 2.87118854159, 21548.96236929180],
[0.00000000246, 3.34468800742, 3333.92876282570],
[0.00000000203, 4.11410443276, 31570.79964939120],
[0.00000000202, 4.96805650734, 8166.15734309380],
[0.00000000232, 2.69372584349, 5989.06725217280],
[0.00000000214, 4.83852070026, 6681.64492949320],
[0.00000000258, 2.66551831451, 1062.90504853820],
[0.00000000197, 0.55202541352, 735.87651353180],
[0.00000000256, 2.76274941586, 2480.30249794700],
[0.00000000216, 4.02506717011, 3133.91168940320],
[0.00000000193, 1.52645682146, 949.17560896980],
[0.00000000209, 0.67348618655, 13892.14067189380],
[0.00000000220, 1.52502617699, 6660.86953400080],
[0.00000000223, 1.09348882524, 6148.01076995600],
[0.00000000192, 2.90571322264, 8799.98871377800],
[0.00000000243, 3.36420301442, 8965.97846825920],
[0.00000000206, 5.11175800472, 4140.43355186520],
[0.00000000189, 1.06641624209, 9374.82644678460],
[0.00000000240, 5.92078519032, 13362.51701710200],
[0.00000000248, 5.79997873732, 15806.14683944200],
[0.00000000193, 3.19008521814, 6756.00645196690],
[0.00000000237, 4.11979030463, 22487.37169284160],
[0.00000000218, 0.84212090761, 6717.25272007700],
[0.00000000200, 2.43100846630, 10018.24685144760],
[0.00000000199, 5.81238461796, 4289.78803566960],
[0.00000000214, 5.95026024979, 6680.80477730600],
[0.00000000192, 3.06285109033, 32765.24665961580],
[0.00000000229, 1.68884404323, 11614.43329373220],
[0.00000000185, 3.13072183492, 3253.30422216000],
[0.00000000246, 2.58151525126, 1795.25844372100],
[0.00000000187, 4.06797969837, 14577.18472611980],
[0.00000000185, 0.96747889626, 2604.73591316800],
[0.00000000184, 1.46731725339, 1437.17561419860],
[0.00000000186, 2.55094700069, 3188.71514561460],
[0.00000000211, 4.23522784526, 16703.07938715119],
[0.00000000196, 2.80582160764, 2796.69436760360],
[0.00000000198, 5.92372067560, 4133.38731516720],
[0.00000000238, 2.30957041178, 1879.55837475340],
[0.00000000224, 3.13550652378, 3613.28538405140],
[0.00000000223, 1.81801741599, 3184.21170619740],
[0.00000000199, 3.64983703995, 4271.97551355160],
[0.00000000181, 2.71721121316, 4186.69526145100],
[0.00000000184, 2.03051030984, 6674.17861670160],
[0.00000000182, 1.54431442810, 9947.05568153210],
[0.00000000179, 4.38762678121, 9886.77220006400],
[0.00000000181, 1.80044971979, 6717.83021870380],
[0.00000000190, 4.97714900529, 6670.58818804980],
[0.00000000247, 5.77972128678, 29424.63423291600],
[0.00000000194, 5.90745451439, 6705.10329114740],
[0.00000000224, 5.61893896091, 227.47613278900],
[0.00000000182, 2.77233344458, 6887.41040183680],
[0.00000000224, 1.94094757956, 8226.57883637840],
[0.00000000181, 4.61381081330, 3361.94806716680],
[0.00000000203, 5.24659800837, 7586.68155006440],
[0.00000000183, 5.23826533455, 6578.13207918100],
[0.00000000207, 0.88292186428, 10156.90236013480],
[0.00000000232, 0.75375986797, 3232.94890276120],
[0.00000000179, 5.89794151802, 4452.25467180180],
[0.00000000177, 6.16223629155, 3547.31316399640],
[0.00000000177, 0.19292898030, 401.67212175720],
[0.00000000173, 3.89814064100, 6019.99192661860],
[0.00000000172, 2.42933586666, 6944.30877677240],
[0.00000000201, 6.18392570315, 6947.83189512140],
[0.00000000183, 5.82189570737, 8962.43809625800],
[0.00000000189, 2.71231990816, 742.99006053260],
[0.00000000172, 3.86810071059, 10028.95082710020],
[0.00000000188, 5.22462530948, 2125.87740737920],
[0.00000000196, 1.88388569900, 5032.77809620220],
[0.00000000209, 5.78130707501, 3343.36393731080],
[0.00000000167, 6.26758992296, 15849.86575174700],
[0.00000000189, 2.38894304278, 3212.59358336240],
[0.00000000208, 5.62485439431, 31172.65064598300],
[0.00000000170, 1.07346401060, 20426.57109242200],
[0.00000000183, 5.21160560654, 27832.03821928320],
[0.00000000181, 2.19756653553, 16703.04487984680],
[0.00000000214, 1.66101921272, 21265.52312652020],
[0.00000000165, 2.10517924574, 6688.27109009760],
[0.00000000172, 0.85495655009, 14591.41182012140],
[0.00000000164, 1.68898542913, 3468.63127003720],
[0.00000000183, 1.56948199057, 8962.47260356240],
[0.00000000191, 5.54553650068, 2806.98930834210],
[0.00000000162, 4.06699160265, 5209.47182633600],
[0.00000000165, 3.44003333876, 14421.83163698840],
[0.00000000163, 2.42152585351, 6314.00052443720],
[0.00000000189, 0.57681608522, 2973.38809773740],
[0.00000000169, 2.86190807726, 5490.30096152400],
[0.00000000174, 1.69333072403, 1744.49329471800],
[0.00000000224, 2.35886332922, 9638.94074787620],
[0.00000000207, 3.13737248079, 3336.68027343670],
[0.00000000221, 3.14807587279, 11610.91017538320],
[0.00000000158, 5.87599422932, 4606.17990532620],
[0.00000000166, 4.61834424167, 9175.75444534820],
[0.00000000162, 5.40045489036, 23.87843774780],
[0.00000000158, 5.57047764661, 4503.08713110760],
[0.00000000156, 3.08339691033, 3448.27595063840],
[0.00000000202, 2.56469307457, 7321.12213971360],
[0.00000000164, 1.10347159072, 3710.31224264020],
[0.00000000158, 3.65995745934, 6997.61672305620],
[0.00000000169, 1.85985317117, 1329.51209026000],
[0.00000000211, 1.66624816725, 3304.00706139560],
[0.00000000206, 1.81572746145, 1596.11913198180],
[0.00000000169, 0.46310427277, 17101.21113690720],
[0.00000000159, 5.73384451559, 1265.56747862640],
[0.00000000159, 0.92643196778, 4001.84535348080],
[0.00000000189, 2.74163850920, 2910.49111747480],
[0.00000000181, 5.48699984659, 3319.27678623280],
[0.00000000156, 5.95462118470, 8584.66166590080],
[0.00000000158, 3.38732507447, 8742.04270747140],
[0.00000000171, 3.11406750626, 5621.91023351320],
[0.00000000199, 2.86370198218, 10025.42770875120],
[0.00000000173, 4.73384838991, 9389.05354078620],
[0.00000000160, 3.06861532268, 1612.95133303160],
[0.00000000203, 1.71629299113, 699.27114822760],
[0.00000000198, 0.56267868345, 15265.88651930040],
[0.00000000186, 2.44573687199, 2814.85361486830],
[0.00000000167, 0.44417942260, 37895.42629036740],
[0.00000000152, 5.08616610530, 3322.79990458180],
[0.00000000162, 2.58982908935, 1883.08149310240],
[0.00000000178, 4.58774508034, 6685.15700666270],
[0.00000000191, 4.12771141768, 9911.63095888000],
[0.00000000185, 4.32284898739, 323.50541665740],
[0.00000000199, 1.83524172935, 3436.59165391760],
[0.00000000199, 6.00292619279, 4427.39591298580],
[0.00000000153, 3.46447669590, 22324.90505670940],
[0.00000000171, 3.52256446633, 5621.77561290760],
[0.00000000165, 3.32970937124, 1272.68102562720],
[0.00000000149, 0.13370088791, 36.02786667740],
[0.00000000149, 1.23280447264, 4193.80880845180],
[0.00000000156, 0.13018524921, 11925.27409260060],
[0.00000000146, 1.24102730441, 3372.58473251660],
[0.00000000154, 5.63537863362, 3185.25933756840],
[0.00000000197, 3.23364188440, 3774.32416457660],
[0.00000000180, 3.47485722477, 8564.30634650200],
[0.00000000185, 2.18248214016, 802.36392244620],
[0.00000000145, 2.62035460481, 3368.01398279660],
[0.00000000180, 6.01236697222, 6691.86151874940],
[0.00000000148, 2.51710178830, 3262.86188271590],
[0.00000000151, 4.17118896078, 16894.51039961060],
[0.00000000185, 3.03939668350, 3354.83952070140],
[0.00000000143, 3.37267915445, 3468.56395973440],
[0.00000000160, 2.16705959730, 0.98032106820],
[0.00000000190, 1.63240538938, 2324.94940881560],
[0.00000000140, 1.27592043896, 6549.68289171320],
[0.00000000186, 1.44849264278, 1015.66301788420],
[0.00000000141, 4.19208049402, 5813.29118932200],
[0.00000000153, 5.97405255778, 3568.08855948880],
[0.00000000136, 0.45455359025, 3193.80074017620],
[0.00000000188, 0.98977442882, 2538.24850425360],
[0.00000000157, 3.32117477144, 3181.66890891660],
[0.00000000164, 1.67705754742, 2751.54759969160],
[0.00000000134, 5.26327877742, 13212.88650966460],
[0.00000000184, 0.73082474043, 369.69981594040],
[0.00000000145, 5.54086212771, 3152.68727893721],
[0.00000000139, 3.30464120245, 6151.51663465280],
[0.00000000132, 0.96753793729, 3487.42411322340],
[0.00000000148, 1.55321724063, 7696.88787128380],
[0.00000000140, 5.39000757800, 2945.98654164060],
[0.00000000155, 4.35207037526, 4005.36847182980],
[0.00000000142, 5.13441372991, 1641.33321019660],
[0.00000000131, 2.48606821423, 1353.39052800780],
[0.00000000131, 2.18754536881, 1765.76662541760],
[0.00000000133, 3.01300582040, 3283.71405176420],
[0.00000000177, 2.37558492362, 11346.77862063940],
[0.00000000145, 0.79525636457, 2281.24775016280],
[0.00000000133, 5.96263652624, 34513.26307268280],
[0.00000000165, 1.32559153826, 6510.55198278040],
[0.00000000132, 4.31118469609, 1971.95217385480],
[0.00000000176, 3.17539133688, 6701.58017279840],
[0.00000000140, 1.18723558164, 1461.05405194640],
[0.00000000128, 6.07261046225, 3362.46325602620],
[0.00000000139, 5.33541181199, 6151.55114195720],
[0.00000000143, 1.04060603784, 3351.65812696370],
[0.00000000138, 1.96009952022, 2014.62345478880],
[0.00000000127, 2.12310260285, 2917.53735417280],
[0.00000000142, 0.29094317859, 3212.66089366520],
[0.00000000128, 0.49974456440, 10264.56588407340],
[0.00000000125, 1.62548810323, 10191.41746323240],
[0.00000000128, 3.55358985291, 3223.29255847960],
[0.00000000140, 5.87379732521, 6382.09845913040],
[0.00000000129, 2.90428606882, 6812.76681508600],
[0.00000000127, 4.03101399507, 10448.43547097540],
[0.00000000128, 3.23265469000, 4576.68808702280],
[0.00000000124, 2.02283056331, 6724.94376570460],
[0.00000000134, 0.19295362623, 3130.83644961080],
[0.00000000145, 5.04767049759, 2281.21324285840],
[0.00000000143, 4.45744983982, 7100.70949727480],
[0.00000000133, 5.00404182123, 11883.58313273480],
[0.00000000124, 0.73925895836, 1485.98012106520],
[0.00000000123, 0.47283015475, 3347.29609057390],
[0.00000000137, 5.73370922615, 5244.04923920100],
[0.00000000152, 5.01464455460, 3358.42494881780],
[0.00000000122, 1.37003015612, 3370.04193523580],
[0.00000000143, 1.95740753086, 2921.68802779920],
[0.00000000123, 3.94139290312, 4957.08687808040],
[0.00000000130, 0.90844304292, 3427.92063123960],
[0.00000000135, 3.56996218538, 3229.42578441220],
[0.00000000143, 5.30225767870, 14128.24277124560],
[0.00000000134, 2.47836558803, 7167.19690618920],
[0.00000000150, 5.89116199733, 966.97087743560],
[0.00000000123, 3.58787674774, 3318.76159737340],
[0.00000000153, 0.37199746202, 6533.14612897330],
[0.00000000145, 1.73326841661, 6637.50594109460],
[0.00000000133, 3.27553306809, 11876.46958573400],
[0.00000000119, 5.15087396729, 15636.56665630900],
[0.00000000117, 3.70999224131, 3343.15522398060],
[0.00000000115, 5.99541570797, 11986.67590695340],
[0.00000000152, 5.66662339960, 6530.17718355670],
[0.00000000123, 0.05231448642, 9801.42463766060],
[0.00000000130, 1.42377926040, 16063.16484718500],
[0.00000000120, 4.19579234337, 604.84974070480],
[0.00000000126, 1.38788085609, 169.58018313300],
[0.00000000122, 0.18785107006, 18849.22754997420],
[0.00000000113, 4.67731144918, 24491.42579258340],
[0.00000000122, 1.21803689218, 3067.93946934820],
[0.00000000118, 3.92389195187, 2963.23881878400],
[0.00000000137, 0.80076862963, 3123.79021291280],
[0.00000000124, 0.77274469912, 12465.53441274220],
[0.00000000132, 4.73888023892, 2267.00340250900],
[0.00000000122, 3.66231014052, 8756.26980147300],
[0.00000000113, 3.74955221887, 21393.54196985760],
[0.00000000153, 5.00596002145, 15906.76412668260],
[0.00000000109, 1.46394078440, 2854.64037391020],
[0.00000000125, 6.00744459186, 1442.26120876020],
[0.00000000140, 0.64532646558, 13532.02988993220],
[0.00000000108, 2.11691804278, 43.71891230500],
[0.00000000130, 1.43185911960, 3370.10424500320],
[0.00000000133, 2.31239626151, 9072.66167112960],
[0.00000000107, 5.68864833782, 4878.85286267780],
[0.00000000116, 3.91262234002, 11904.91877320180],
[0.00000000106, 1.99989592271, 3497.01314720220],
[0.00000000106, 5.79020088316, 1.48447270830],
[0.00000000105, 1.79751699456, 3517.30615683360],
[0.00000000130, 0.80396347034, 3397.51080163540],
[0.00000000107, 5.29449090921, 10.63666534980],
[0.00000000137, 0.47037516401, 13575.74880223720],
[0.00000000104, 5.03145022037, 1751.52227776380],
[0.00000000146, 2.57659804831, 3308.64012088300],
[0.00000000103, 3.29589452622, 4379.63903749020],
[0.00000000104, 0.77903634693, 1751.55678506820],
[0.00000000118, 4.11892224522, 10927.29397676420],
[0.00000000106, 2.25714927822, 13207.02930736500],
[0.00000000126, 1.10289326962, 6680.79497027290],
[0.00000000105, 1.41449747957, 10081.21114201300],
[0.00000000110, 6.16072219971, 3338.06962941900],
[0.00000000113, 0.61947991056, 13421.82356871280],
[0.00000000139, 2.21345603147, 1954.71715036360],
[0.00000000102, 3.81767069895, 6670.17915313570],
[0.00000000101, 3.44583422545, 1505.28780909299],
[0.00000000105, 2.46134952447, 5525.86369599260],
[0.00000000119, 5.64454862995, 8425.71814811760],
[0.00000000101, 1.87446179141, 9161.52735134660],
[0.00000000111, 5.46183253107, 7214.43893684320],
[0.00000000123, 0.14056284625, 16489.76303806100],
[0.00000000128, 0.00452525697, 2185.25126929280],
[0.00000000106, 6.20225179330, 3717.98603461560],
[0.00000000099, 1.70554147455, 1655.56030419820],
[0.00000000100, 1.76373681853, 3002.36972771680],
[0.00000000101, 0.55693458655, 3337.15661865360],
[0.00000000101, 0.56441794685, 30774.50164257480],
[0.00000000098, 1.93983799659, 5562.46906129680],
[0.00000000130, 5.65255471249, 2735.76268599500],
[0.00000000125, 6.18575288406, 9698.33186344200],
[0.00000000100, 2.35767934317, 3337.07205469860],
[0.00000000100, 3.76317527562, 3344.15279870100],
[0.00000000105, 5.33897491215, 5096.08411137890],
[0.00000000103, 1.24189801298, 1385.89527633620],
[0.00000000101, 1.42727612221, 37455.72649597440],
[0.00000000096, 2.55328478399, 4466.48176580340],
[0.00000000097, 5.86779127410, 5220.17080145320],
[0.00000000101, 2.61513508379, 16858.41522263039],
[0.00000000107, 4.23943588615, 8823.86715152580],
[0.00000000100, 4.38845221965, 3337.10656200300],
[0.00000000100, 1.73240240188, 3344.11829139661],
[0.00000000101, 3.51764169063, 4694.00295470760],
[0.00000000096, 3.16895015703, 12825.64519470380],
[0.00000000101, 6.24060604565, 2942.53073359440],
[0.00000000103, 1.09500325425, 12089.76868117200],
[0.00000000106, 5.57931664756, 39048.32250960720],
[0.00000000126, 3.40521738550, 6681.65473652630],
[0.00000000105, 2.52404371984, 1755.06264976500],
[0.00000000115, 6.10031030713, 3145.64104223920],
[0.00000000092, 5.06385191401, 5085.10572141780],
[0.00000000097, 1.11670836674, 3341.79306935190],
[0.00000000092, 5.83209800268, 6682.70932610790],
[0.00000000121, 2.39411154886, 18208.34994259200],
[0.00000000110, 2.51677822824, 1045.15483618760],
[0.00000000091, 1.07173725022, 927.83996850280],
[0.00000000096, 3.60155667418, 13363.43002786740],
[0.00000000097, 5.34224904711, 7636.46637799920],
[0.00000000094, 1.20811080231, 9495.66943335380],
[0.00000000090, 4.17568982529, 0.06731030280],
[0.00000000097, 3.20862890174, 5298.33750655300],
[0.00000000092, 3.20029831258, 4403.51747523800],
[0.00000000090, 3.79900428724, 685.04405422600],
[0.00000000101, 2.12778329280, 10050.28646756720],
[0.00000000098, 3.89390262307, 2373.64154926420],
[0.00000000090, 4.49046504054, 6453.74872061060],
[0.00000000096, 5.13129666936, 7792.86709850160],
[0.00000000089, 4.51228904794, 10037.08975128440],
[0.00000000098, 0.65689906709, 2810.98877190800],
[0.00000000114, 4.15908543927, 9090.47419324760],
[0.00000000094, 4.78960145866, 35707.71008290740],
[0.00000000087, 6.26525215858, 34554.81386366760],
[0.00000000087, 1.50181194995, 9983.70424446160],
[0.00000000087, 1.43790822626, 9488.62319665580],
[0.00000000090, 2.79573736864, 47477.56377607380],
[0.00000000094, 5.68919291448, 6106.88005506480],
[0.00000000087, 0.74049208991, 41990.78593289880],
[0.00000000101, 0.99308133443, 6614.73744448520],
[0.00000000115, 3.49732055752, 4.50343941720],
[0.00000000086, 0.18628425275, 216.82221378700],
[0.00000000099, 1.06539589813, 2810.85415130240],
[0.00000000087, 3.02856210899, 7218.02936549500],
[0.00000000085, 4.58476007089, 1699.27921650320],
[0.00000000088, 4.47996444588, 21957.68072774700],
[0.00000000106, 6.12011880730, 4819.47900076420],
[0.00000000089, 3.88600719587, 12199.97500239140],
[0.00000000097, 2.70091698598, 3339.43178404770],
[0.00000000118, 1.02739527200, 34115.11406927460],
[0.00000000101, 0.36591831115, 2942.39611298880],
[0.00000000084, 5.66081869654, 1169.58825140860],
[0.00000000086, 1.91214909013, 55516.41870984820],
[0.00000000084, 4.30909434949, 4150.08989614680],
[0.00000000094, 1.36645151323, 9093.99731159660],
[0.00000000097, 2.26544245706, 13361.46938573100],
[0.00000000099, 1.16054562056, 128.01884333740],
[0.00000000094, 1.10573952457, 4591.44262300060],
[0.00000000092, 0.74386387542, 4845.90023579280],
[0.00000000101, 1.51570299040, 7807.09419250320],
[0.00000000096, 1.02187746571, 2899.78714182220],
[0.00000000086, 0.66787658068, 2957.73314812880],
[0.00000000087, 3.49676189640, 4061.75165790600],
[0.00000000095, 3.35452781355, 661.23292678100],
[0.00000000087, 0.04840436087, 23546.75362303080],
[0.00000000114, 2.83270741566, 394.62588505920],
[0.00000000081, 3.44420073782, 148.07872442630],
[0.00000000081, 1.27062968985, 4893.07995667940],
[0.00000000083, 5.48462687348, 4349.16189758320],
[0.00000000105, 3.47842036130, 3413.90955255880],
[0.00000000084, 4.33209852801, 51449.32426327820],
[0.00000000093, 1.59775582035, 5088.21980485270],
[0.00000000088, 3.29950478012, 2655.50106217100],
[0.00000000081, 1.65543714666, 78263.70942472259],
[0.00000000086, 1.19342535692, 4029.24690957760],
[0.00000000079, 4.41964678009, 151.04766984290],
[0.00000000084, 1.96289182788, 14867.73751589219],
[0.00000000091, 5.76229906142, 2544.33167353560],
[0.00000000086, 3.78659802914, 1481.40937134520],
[0.00000000082, 2.85633413428, 14164.81362924540],
[0.00000000078, 4.29426812598, 187.92514776260],
[0.00000000078, 5.38566529072, 2655.56837247380],
[0.00000000084, 2.15121245434, 3311.12060839640],
[0.00000000078, 2.01651247942, 9124.92198604240],
[0.00000000083, 4.28280129037, 74923.09699802278],
[0.00000000077, 1.45903147715, 2544.38173018620],
[0.00000000081, 3.62204400197, 12306.59089495900],
[0.00000000100, 1.33498371324, 9278.84721956680],
[0.00000000089, 2.62080312892, 24341.52831745660],
[0.00000000098, 3.78877505378, 3198.43379966360],
[0.00000000081, 4.34306418828, 10177.19036923080],
[0.00000000080, 5.80054348103, 2751.01515718000],
[0.00000000092, 2.80228448795, 3707.83675566220],
[0.00000000082, 2.45812896240, 9815.65173166220],
[0.00000000076, 3.03616461584, 9993.38809263160],
[0.00000000076, 3.92674885488, 2910.08208256070],
[0.00000000076, 3.20004040720, 7733.49323658800],
[0.00000000098, 3.28574616663, 3289.33208883739],
[0.00000000077, 2.05948930010, 12928.73796892240],
[0.00000000075, 0.85784191736, 28638.90558114660],
[0.00000000078, 0.29690749181, 10654.62101941260],
[0.00000000101, 0.72388999452, 48827.43118573260],
[0.00000000085, 5.19438010130, 2146.14816282300],
[0.00000000083, 4.42475849926, 2060.81785407180],
[0.00000000075, 5.19097428778, 1055.44977692610],
[0.00000000096, 6.24132708357, 11.04570026390],
[0.00000000074, 3.37882325472, 8006.16619393960],
[0.00000000101, 0.95332927487, 8186.51266249260],
[0.00000000092, 0.96173005100, 151.89728108520],
[0.00000000074, 2.22716630210, 272.67295735160],
[0.00000000092, 5.56705883046, 27873.58901026800],
[0.00000000091, 3.73152787182, 2544.29716623120],
[0.00000000084, 0.41493230617, 4296.90158267040],
[0.00000000074, 5.09669613096, 9755.23023837760],
[0.00000000078, 1.79565224435, 3564.95722240170],
[0.00000000075, 4.58345774133, 9153.90361602180],
[0.00000000074, 3.88658218247, 25298.29315444680],
[0.00000000085, 5.31472029744, 4716.38622654560],
[0.00000000074, 1.46907693289, 11527.12508919240],
[0.00000000101, 2.94847804254, 12032.93761653920],
[0.00000000072, 0.24413748615, 1324.94134054000],
[0.00000000078, 0.17721609024, 3391.89276456221],
[0.00000000073, 1.65072742864, 5452.26274007740],
[0.00000000073, 4.91730083470, 10787.63034454580],
[0.00000000073, 3.28285909319, 8830.91338822380],
[0.00000000081, 5.46340742050, 3856.07629779280],
[0.00000000073, 4.61913155968, 3288.35211178700],
[0.00000000096, 5.71767221046, 206.70073729660],
[0.00000000080, 4.47918417138, 12299.54465826100],
[0.00000000071, 4.98130328330, 12942.96506292400],
[0.00000000073, 2.86057567032, 4960.60999642940],
[0.00000000072, 5.14120362338, 4665.55376723980],
[0.00000000076, 0.00928867041, 6534.41316687600],
[0.00000000090, 5.38224594245, 2125.81009707640],
[0.00000000085, 0.94196641948, 2146.18267012740],
[0.00000000096, 0.68069708134, 10006.58480891440],
[0.00000000073, 1.06048379839, 3866.78027344540],
[0.00000000072, 0.84342376295, 3334.54651107000],
[0.00000000091, 5.12701600437, 3392.87274161260],
[0.00000000076, 5.96038992872, 3482.79105373600],
[0.00000000090, 1.46230169383, 5092.16921176800],
[0.00000000071, 1.16745785331, 1574.84580128220],
[0.00000000072, 3.86137692169, 16762.43599541260],
[0.00000000070, 0.07310763691, 12839.87228870540],
[0.00000000073, 0.11725123446, 10507.80933288900],
[0.00000000081, 5.86817748181, 3495.96551583120],
[0.00000000071, 2.07963275673, 1063.31408345230],
[0.00000000068, 3.30993028662, 4106.40549114620],
[0.00000000069, 0.33467954461, 5.52292430740],
[0.00000000068, 1.56404561711, 2398.55036473080],
[0.00000000090, 2.61953849393, 3346.67834232960],
[0.00000000068, 1.06108185791, 191.38095580880],
[0.00000000077, 0.87794040199, 2917.94638908690],
[0.00000000067, 0.29712068423, 12012.58229714040],
[0.00000000067, 2.55451787747, 11567.19126307820],
[0.00000000083, 1.82578570364, 3511.28529731900],
[0.00000000068, 2.68247854175, 20213.25474333179],
[0.00000000086, 2.79273636804, 367.22432896240],
[0.00000000086, 0.81171860574, 209.77597708900],
[0.00000000067, 5.28035928877, 8966.38750317330],
[0.00000000067, 0.20258020424, 27433.88921587499],
[0.00000000071, 2.76410148218, 15650.79375031060],
[0.00000000090, 0.71593793107, 3451.79906898740],
[0.00000000067, 6.18148420146, 3966.28261901220],
[0.00000000074, 3.61959120765, 7064.10413197060],
[0.00000000068, 2.69550405031, 12725.45343477500],
[0.00000000074, 1.24854309783, 8027.56914470940],
[0.00000000084, 2.47006028699, 3738.74417645580],
[0.00000000077, 5.89874180572, 4307.58330413540],
[0.00000000067, 0.33285041428, 19645.52555679060],
[0.00000000083, 3.79134493696, 2472.67876262220],
[0.00000000064, 0.43216125634, 1994.26813539000],
[0.00000000071, 0.65707804543, 860.30992875280],
[0.00000000064, 0.98960038205, 3376.17516116840],
[0.00000000070, 0.96227192685, 8428.83223155250],
[0.00000000066, 0.65425879867, 8219.46528937760],
[0.00000000070, 4.36060455306, 8436.69653807870],
[0.00000000084, 4.50083253887, 3738.77868376020],
[0.00000000073, 5.69670871544, 14687.39104733920],
[0.00000000071, 0.36334330253, 2619.47319549360],
[0.00000000080, 5.85771861744, 7747.72033058960],
[0.00000000068, 3.06409889136, 8446.99147881720],
[0.00000000066, 1.07137364271, 1987.22189869200],
[0.00000000061, 3.71171429905, 1055.85881184020],
[0.00000000079, 0.06487001849, 6286.59896834040],
[0.00000000075, 1.54177744365, 1059.39918384140],
[0.00000000061, 1.47350010728, 1685.05212250160],
[0.00000000061, 0.46897959303, 1727.66109366820],
[0.00000000064, 2.11869877898, 3305.04969223120],
[0.00000000060, 1.17940250396, 97670.38771289718],
[0.00000000060, 5.13953821352, 1898.33396428740],
[0.00000000064, 4.04058406722, 3945.46216740460],
[0.00000000063, 5.20562384814, 24606.13555322000],
[0.00000000061, 0.55428968913, 7082.89697515680],
[0.00000000075, 4.81208819076, 27299.24421193320],
[0.00000000059, 1.75511446129, 12082.65513417120],
[0.00000000061, 5.88333855610, 6901.63749583840],
[0.00000000074, 3.46408580786, 14556.89671702380],
[0.00000000074, 4.40649822049, 9360.60435331840],
[0.00000000058, 4.22827613192, 4531.53631857540],
[0.00000000080, 2.14103357856, 7917.30051372260],
[0.00000000075, 1.85618011420, 52566.19261584059],
[0.00000000075, 5.15830659680, 45884.96776244100],
[0.00000000068, 2.06915254754, 8958.52319664710],
[0.00000000056, 3.77847713307, 299.12639426920],
[0.00000000062, 2.25564130818, 9758.75335672660],
[0.00000000059, 2.68657637673, 6283.05859633920],
[0.00000000056, 5.54148283448, 13286.18363552360],
[0.00000000056, 3.89200811600, 8962.38803960740],
[0.00000000063, 2.07254352069, 7593.79509706520],
[0.00000000061, 4.31994402891, 4709.27267954480],
[0.00000000075, 5.79419108898, 1059.36467653700],
[0.00000000056, 0.18569912415, 7768.00833968560],
[0.00000000059, 5.49627068572, 7322.10246078180],
[0.00000000064, 3.95992112220, 3050.12694723020],
[0.00000000055, 2.19506741266, 7.04623669800],
[0.00000000057, 4.05252695300, 3930.20969621960],
[0.00000000075, 3.99788100837, 5483.25472482600],
[0.00000000060, 4.61703903739, 6990.50317605540],
[0.00000000073, 4.20362525534, 21150.81336588360],
[0.00000000066, 2.82009591985, 8771.00708379860],
[0.00000000054, 0.38782719267, 360.11078196160],
[0.00000000059, 4.71734799803, 6283.09310364360],
[0.00000000068, 5.74655335863, 987.74627292800],
], [
[0.01107433340, 2.03250524950, 3340.61242669980],
[0.00103175886, 2.37071845682, 6681.22485339960],
[0.00012877200, 0.00000000000, 0.00000000000],
[0.00010815880, 2.70888093803, 10021.83728009940],
[0.00001194550, 3.04702182503, 13362.44970679920],
[0.00000438579, 2.88835072628, 2281.23049651060],
[0.00000395698, 3.42324611291, 3344.13554504880],
[0.00000182572, 1.58428644001, 2544.31441988340],
[0.00000135850, 3.38507017993, 16703.06213349900],
[0.00000128204, 0.62991220570, 1059.38193018920],
[0.00000127068, 1.95389775740, 796.29800681640],
[0.00000118443, 2.99761345074, 2146.16541647520],
[0.00000128362, 6.04343360441, 3337.08930835080],
[0.00000087537, 3.42052758979, 398.14900340820],
[0.00000083026, 3.85574986653, 3738.76143010800],
[0.00000075598, 4.45101839349, 6151.53388830500],
[0.00000071999, 2.76442180680, 529.69096509460],
[0.00000066542, 2.54892602695, 1751.53953141600],
[0.00000054314, 0.67750943459, 8962.45534991020],
[0.00000051035, 3.72585409207, 6684.74797174860],
[0.00000066430, 4.40597549957, 1748.01641306700],
[0.00000047863, 2.28527896843, 2914.01423582380],
[0.00000049428, 5.72959428364, 3340.59517304760],
[0.00000049424, 1.47717922226, 3340.62968035200],
[0.00000057518, 0.54354327916, 1194.44701022460],
[0.00000048318, 2.58061691301, 3149.16416058820],
[0.00000036384, 6.02728752344, 3185.19202726560],
[0.00000037176, 5.81439911546, 1349.86740965880],
[0.00000036036, 5.89508336048, 3333.49887969900],
[0.00000031115, 0.97832506960, 191.44826611160],
[0.00000038953, 2.31900090554, 4136.91043351620],
[0.00000027244, 5.41367977087, 1592.59601363280],
[0.00000024300, 3.75843924498, 155.42039943420],
[0.00000022804, 1.74830773908, 5088.62883976680],
[0.00000022324, 0.93932040730, 951.71840625060],
[0.00000021708, 3.83571581352, 6283.07584999140],
[0.00000021304, 0.78049229782, 1589.07289528380],
[0.00000021631, 4.56895741061, 3532.06069281140],
[0.00000017956, 4.21930481803, 3870.30339179440],
[0.00000018237, 0.41328624131, 5486.77784317500],
[0.00000016251, 3.80760134974, 3340.54511639700],
[0.00000016803, 5.54857987615, 3097.88382272579],
[0.00000016850, 4.53690440252, 4292.33083295040],
[0.00000015755, 4.75736730681, 9492.14631500480],
[0.00000015746, 3.72356090283, 20043.67456019880],
[0.00000020428, 3.13540712557, 4690.47983635860],
[0.00000014699, 5.95325006816, 3894.18182954220],
[0.00000016251, 3.39910907599, 3340.67973700260],
[0.00000014259, 3.99897353022, 1990.74501704100],
[0.00000016528, 0.96752074938, 4399.99435688900],
[0.00000013010, 5.14230107067, 6677.70173505060],
[0.00000012492, 1.03211063742, 3341.59274776800],
[0.00000016463, 3.53882915214, 2700.71514038580],
[0.00000016171, 2.34870953554, 553.56940284240],
[0.00000013169, 0.41461716663, 5614.72937620960],
[0.00000011272, 1.02375627844, 12303.06777661000],
[0.00000012408, 6.23142869816, 5628.95647021120],
[0.00000012747, 0.69046314049, 3723.50895892300],
[0.00000011827, 6.25283898676, 2274.11694950980],
[0.00000010384, 1.23257236014, 426.59819087600],
[0.00000011208, 1.31750963435, 3496.03282613400],
[0.00000010345, 0.90062464690, 4535.05943692440],
[0.00000012215, 4.22316056098, 7079.37385680780],
[0.00000009765, 3.45310940204, 382.89653222320],
[0.00000008586, 1.16471901139, 2787.04302385740],
[0.00000007879, 5.73808861790, 2288.34404351140],
[0.00000009195, 1.81689739851, 6681.24210705180],
[0.00000007751, 4.15046998466, 6041.32756708560],
[0.00000009195, 6.06945250657, 6681.20759974740],
[0.00000009026, 2.58210941053, 2388.89402044920],
[0.00000006771, 0.23987737854, 11773.37681151540],
[0.00000007087, 3.51414944377, 8031.09226305840],
[0.00000009159, 3.90158590550, 3553.91152213780],
[0.00000006702, 4.25572879119, 242.72860397400],
[0.00000007232, 3.70287400141, 2818.03500860600],
[0.00000006546, 0.04353472459, 2957.71589447660],
[0.00000008781, 2.19735028572, 1221.84856632140],
[0.00000006540, 2.11834687923, 8429.24126646660],
[0.00000006836, 4.04512263654, 10025.36039844840],
[0.00000007280, 4.26943100715, 2803.80791460440],
[0.00000007676, 1.00782250264, 8432.76438481560],
[0.00000005732, 3.13956241764, 213.29909543800],
[0.00000005344, 3.78220670098, 5092.15195811580],
[0.00000005991, 2.96408254428, 6489.77658728800],
[0.00000005132, 3.98288453952, 7.11354700080],
[0.00000006261, 1.90346469972, 5621.84292321040],
[0.00000005241, 2.67093795050, 7477.52286021600],
[0.00000006261, 1.60056695152, 3347.72597370060],
[0.00000006526, 2.76281601349, 3339.63210563160],
[0.00000004591, 1.81986278078, 2810.92146160520],
[0.00000005460, 4.60874445963, 3583.34103067380],
[0.00000004733, 0.90560026340, 5099.26550511660],
[0.00000005486, 4.91408093456, 7632.94325965020],
[0.00000004004, 4.14067157211, 9623.68827669120],
[0.00000003837, 0.03343295627, 7234.79425624200],
[0.00000003621, 5.76532393672, 4933.20844033260],
[0.00000003747, 0.08778985966, 6525.80445396540],
[0.00000003016, 3.73838855125, 6681.29216370240],
[0.00000003975, 4.91288592965, 2942.46342329160],
[0.00000003911, 0.67451768877, 3127.31333126180],
[0.00000003923, 3.07703531632, 3.52311834900],
[0.00000003944, 0.53974754515, 5884.92684658320],
[0.00000002901, 4.66281989264, 7210.91581849420],
[0.00000002803, 1.00530177454, 7064.12138562280],
[0.00000003153, 4.54673175664, 2487.41604494780],
[0.00000002784, 0.05495331967, 639.89728631400],
[0.00000002759, 5.17099857257, 5828.02847164760],
[0.00000003017, 4.14668877243, 6681.15754309680],
[0.00000002999, 0.82918667275, 5085.03841111500],
[0.00000002677, 0.69427974692, 2699.73481931760],
[0.00000003023, 2.59489020298, 2906.90068882300],
[0.00000002596, 1.08693013783, 4929.68532198360],
[0.00000003126, 1.00027692782, 2118.76386037840],
[0.00000002598, 5.01195749912, 10018.31416175040],
[0.00000002606, 5.34420770679, 10973.55568635000],
[0.00000002779, 3.98358744953, 6467.92575796160],
[0.00000002460, 1.52653571249, 6836.64525283380],
[0.00000002382, 3.93610586965, 11371.70468975820],
[0.00000002590, 5.08892664109, 12832.75874170460],
[0.00000002201, 0.18880589605, 9595.23908922340],
[0.00000002128, 5.69450469171, 3191.04922956520],
[0.00000002065, 3.54133174600, 1066.49547719000],
[0.00000001868, 5.01592531810, 3475.67750673520],
[0.00000002081, 1.30274459220, 7740.60678358880],
[0.00000001830, 5.68365327697, 3319.83703120740],
[0.00000002022, 6.16092328060, 1744.42598441520],
[0.00000001708, 2.21675931288, 2921.12778282460],
[0.00000001836, 6.16477009621, 8425.65083781480],
[0.00000002060, 6.24041853265, 6674.11130639880],
[0.00000001735, 4.58243571826, 10419.98628350760],
[0.00000001852, 1.36883022935, 15643.68020330980],
[0.00000001689, 1.92829590736, 3767.21061757580],
[0.00000001954, 0.46215988899, 10575.40668294180],
[0.00000001800, 2.30913343660, 3355.86489788480],
[0.00000001444, 2.15042616899, 10021.85453375160],
[0.00000001760, 5.87267582299, 3320.25710730100],
[0.00000001845, 4.06123235448, 23384.28698689860],
[0.00000001423, 4.65085713203, 4562.46099302120],
[0.00000001410, 1.50438410845, 3325.35995551480],
[0.00000001444, 0.11969993808, 10021.82002644720],
[0.00000001443, 0.55828572929, 15113.98923821520],
[0.00000001334, 1.25483731308, 7875.67186362420],
[0.00000001442, 1.38958943728, 6682.20517446780],
[0.00000001606, 4.34241260905, 5331.35744374080],
[0.00000001377, 0.14791683820, 1758.65307841680],
[0.00000001282, 5.78533014319, 14584.29827312060],
[0.00000001281, 1.35125896423, 10404.73381232260],
[0.00000001471, 0.34649469321, 8969.56889691100],
[0.00000001245, 6.02681709446, 3264.34635542420],
[0.00000001234, 1.88341938354, 10177.25767953360],
[0.00000001552, 5.92727420332, 8439.87793181640],
[0.00000001182, 4.18100226016, 3360.96774609859],
[0.00000001333, 1.86551437099, 692.15760122680],
[0.00000001189, 0.89892514263, 13916.01910964160],
[0.00000001192, 4.30473818946, 6894.52394883760],
[0.00000001145, 0.15197504252, 3134.42687826260],
[0.00000001299, 1.44631688592, 6254.62666252360],
[0.00000001494, 1.54417907271, 3361.38782219220],
[0.00000001054, 0.67591855339, 3344.20285535160],
[0.00000001210, 0.85117132607, 3120.19978426100],
[0.00000001061, 0.13258232364, 522.57741809380],
[0.00000001003, 1.28021784912, 4569.57454002200],
[0.00000001012, 5.77497169905, 14314.16811304980],
[0.00000001169, 2.99767730172, 6247.51311552280],
[0.00000001062, 0.25467691252, 3337.02199804800],
[0.00000001032, 5.69833683620, 536.80451209540],
[0.00000001082, 2.58016159997, 6261.74020952440],
[0.00000000867, 1.50283829131, 6127.65545055720],
[0.00000000953, 2.92377030638, 5729.50644714900],
[0.00000000887, 5.28743574972, 10213.28554621100],
[0.00000001108, 2.84339171890, 640.87760738220],
[0.00000000861, 3.21491381593, 3914.95722503460],
[0.00000001069, 0.49400181869, 11243.68584642080],
[0.00000000800, 4.64154002129, 6144.42034130420],
[0.00000000799, 3.33215212691, 9830.38901398780],
[0.00000001046, 4.05907877700, 6158.64743530580],
[0.00000000743, 4.93337997290, 3230.40610548040],
[0.00000000740, 3.01511102229, 10818.13528691580],
[0.00000000716, 2.52567242762, 5202.35827933520],
[0.00000000705, 4.39344403231, 9808.53818466140],
[0.00000000786, 1.72357089999, 3178.14579056760],
[0.00000000719, 0.38924465445, 6298.32832117640],
[0.00000000717, 6.23927283856, 3369.06161416760],
[0.00000000704, 1.96763488855, 6688.33840040040],
[0.00000000882, 2.10339285493, 2301.58581590939],
[0.00000000913, 2.30662326829, 13517.87010623340],
[0.00000000914, 4.36610748804, 13365.97282514820],
[0.00000000659, 3.40905557071, 1648.44675719740],
[0.00000000828, 2.13305589137, 7903.07341972100],
[0.00000000652, 5.97050449428, 574.34479833480],
[0.00000000688, 4.02232587894, 1052.26838318840],
[0.00000000709, 2.24658423912, 9225.53927328300],
[0.00000000590, 0.67418318613, 8955.34180290940],
[0.00000000604, 2.73550395152, 16858.48253293320],
[0.00000000785, 3.58704322751, 2693.60159338500],
[0.00000000570, 4.11146135269, 6034.21402008480],
[0.00000000624, 4.45415856101, 12964.30070339100],
[0.00000000563, 3.72383942144, 13119.72110282519],
[0.00000000547, 3.04142188931, 2707.82868738660],
[0.00000000536, 4.65546776421, 135.06508003540],
[0.00000000680, 3.62640859214, 6048.44111408640],
[0.00000000535, 3.32503801413, 9779.10867612540],
[0.00000000615, 0.31792697641, 7910.18696672180],
[0.00000000506, 1.24339056369, 4555.34744602040],
[0.00000000633, 1.32124830132, 2648.45482547300],
[0.00000000671, 2.88173567087, 3316.73398895200],
[0.00000000570, 4.94522781693, 6923.95345737360],
[0.00000000489, 0.48479532469, 12935.85151592320],
[0.00000000490, 1.57712746955, 162.46663613220],
[0.00000000492, 4.08592823251, 10021.90459040220],
[0.00000000468, 4.50628939729, 2384.32327072920],
[0.00000000462, 1.30653882308, 17256.63153634140],
[0.00000000444, 5.20556841675, 13358.92658845020],
[0.00000000511, 5.29436707935, 853.19638175200],
[0.00000000458, 5.52316111365, 6438.49624942560],
[0.00000000443, 4.37626774329, 12168.00269657460],
[0.00000000429, 4.06329082027, 149.56319713460],
[0.00000000502, 6.12188881856, 8273.82086703240],
[0.00000000420, 3.51990468754, 9168.64089834740],
[0.00000000452, 0.15931716927, 7895.95987272020],
[0.00000000401, 0.93276882765, 433.71173787680],
[0.00000000491, 4.49372643902, 10021.76996979660],
[0.00000000390, 1.26790524143, 5459.37628707820],
[0.00000000460, 3.56765356005, 1596.18644228460],
[0.00000000514, 4.14617297678, 16460.33352952499],
[0.00000000510, 2.12338136542, 3335.08950239240],
[0.00000000365, 0.84035244694, 3364.49086444760],
[0.00000000444, 0.42154996651, 9866.41688066520],
[0.00000000380, 2.74315160117, 3344.49376205780],
[0.00000000355, 2.20831807719, 5518.75014899180],
[0.00000000374, 0.93920520997, 3863.18984479360],
[0.00000000380, 0.60825828556, 3980.50971301380],
[0.00000000366, 1.45297694305, 1039.02661079040],
[0.00000000458, 5.01867719021, 10551.52824519400],
[0.00000000352, 5.59661824792, 16062.18452611680],
[0.00000000361, 5.43698827477, 11236.57229942000],
[0.00000000323, 3.25474887566, 3116.26763099790],
[0.00000000396, 5.43635200834, 16173.37116840440],
[0.00000000316, 5.10862851689, 17395.21973472580],
[0.00000000325, 4.59103320065, 19800.94595622480],
[0.00000000320, 0.10022132590, 1692.16566950240],
[0.00000000313, 4.76509182263, 3304.58456002240],
[0.00000000329, 3.51515201342, 1903.43681250120],
[0.00000000361, 1.40179572820, 8270.29774868340],
[0.00000000380, 1.11278812152, 3503.07906283200],
[0.00000000309, 1.63585786252, 11081.21921028860],
[0.00000000304, 6.27804875103, 2391.43681773000],
[0.00000000336, 2.95777936427, 6680.24453233140],
[0.00000000299, 0.48751113813, 3347.65866339780],
[0.00000000327, 3.19951479738, 3981.49003408200],
[0.00000000298, 4.26967988388, 13936.79450513400],
[0.00000000309, 5.05775078180, 12721.57209941700],
[0.00000000310, 6.10243075443, 17924.91069982040],
[0.00000000290, 4.52880846817, 5724.93569742900],
[0.00000000279, 4.30091602167, 3607.21946842160],
[0.00000000293, 1.90646493379, 6702.00024889200],
[0.00000000375, 5.37146136739, 3376.64029337720],
[0.00000000268, 4.93796347898, 13760.59871020740],
[0.00000000269, 5.63342755549, 4032.77002792660],
[0.00000000361, 4.70448724123, 9380.95967271720],
[0.00000000285, 4.37639190605, 6040.34724601740],
[0.00000000305, 3.60878132297, 7255.56965173440],
[0.00000000265, 5.82002998533, 1214.73501932060],
[0.00000000246, 3.48844723382, 3237.51965248120],
[0.00000000339, 6.05128485092, 6660.44945790720],
[0.00000000325, 5.12798981834, 11250.79939342160],
[0.00000000243, 0.48346700024, 13362.43245314700],
[0.00000000246, 4.41923388458, 3546.79797513700],
[0.00000000239, 3.73073204843, 76.26607127560],
[0.00000000239, 6.27709788173, 1964.83862685400],
[0.00000000242, 2.51411096474, 13362.46696045140],
[0.00000000238, 4.61745673345, 17277.40693183380],
[0.00000000232, 3.13987850882, 20199.09495963300],
[0.00000000245, 3.88310965561, 4407.10790388980],
[0.00000000242, 3.07232693388, 12566.15169998280],
[0.00000000277, 3.88618268628, 10596.18207843420],
[0.00000000277, 6.14459469980, 19402.79695281660],
[0.00000000222, 2.20253799065, 7107.82304427560],
[0.00000000218, 1.37621606096, 3415.39402526710],
[0.00000000297, 3.78408680173, 2766.26762836500],
[0.00000000264, 5.35345322905, 6816.28993343500],
[0.00000000213, 1.10915354432, 19004.64794940840],
[0.00000000213, 4.60032427636, 3973.39616601300],
[0.00000000230, 4.39356021431, 26724.89941359840],
[0.00000000202, 0.60981942427, 6677.63442474780],
[0.00000000268, 5.05058237041, 9381.93999378540],
[0.00000000199, 1.34402137469, 8329.67161059700],
[0.00000000198, 5.08527311506, 5820.91492464680],
[0.00000000201, 0.05002970566, 11780.49035851620],
[0.00000000199, 2.66187512344, 6696.47732458460],
[0.00000000227, 1.69939961119, 18984.29263000960],
[0.00000000217, 4.71565260831, 8671.96987044060],
[0.00000000199, 0.66532566162, 15664.03552270859],
[0.00000000201, 3.90133282111, 266.60704172180],
[0.00000000242, 0.76562027191, 3281.23856478620],
[0.00000000254, 6.07712146530, 14054.60730802600],
[0.00000000193, 6.08798590746, 8982.81066930900],
[0.00000000202, 1.12506176909, 6684.81528205140],
[0.00000000212, 0.41763591084, 5732.04924442980],
[0.00000000191, 0.63315794517, 3017.10701004240],
[0.00000000184, 5.68898048651, 5642.19824260920],
[0.00000000180, 4.60366258431, 10235.13637553740],
[0.00000000198, 1.01742381306, 3336.73109134180],
[0.00000000207, 0.80702499658, 3877.41693879520],
[0.00000000202, 1.61753574776, 11216.28429032400],
[0.00000000177, 0.20305783491, 22743.40937951640],
[0.00000000181, 6.17864681592, 4885.96640967860],
[0.00000000228, 0.90779655425, 18454.60166491500],
[0.00000000165, 3.97299091423, 20.35531939880],
[0.00000000206, 3.58770221682, 3205.54734666440],
[0.00000000185, 2.77088436060, 220.41264243880],
[0.00000000163, 0.00569068383, 1437.17561419860],
[0.00000000185, 6.23128875160, 6660.86953400080],
[0.00000000164, 4.64548469502, 3253.30422216000],
[0.00000000210, 4.85590304986, 5618.31980486140],
[0.00000000226, 1.76563729092, 5625.36604155940],
[0.00000000163, 0.67931390118, 12310.18132361080],
[0.00000000211, 1.51278040364, 4039.88357492740],
[0.00000000177, 2.14779710666, 3346.13535100720],
[0.00000000154, 3.33525296567, 9070.11887384880],
[0.00000000178, 1.65162116131, 10713.99488132620],
[0.00000000156, 6.12783235584, 103.09277421860],
[0.00000000155, 3.51854579269, 7373.38245462640],
[0.00000000157, 4.91614155659, 15508.61512327440],
[0.00000000191, 1.74459210202, 10022.81760116760],
[0.00000000178, 3.53665589741, 533.21408344360],
[0.00000000154, 2.64640687885, 3333.56619000180],
[0.00000000162, 1.27235392680, 5415.65737477320],
[0.00000000144, 1.30886254982, 6460.81221096080],
[0.00000000173, 3.76291627342, 3561.02506913860],
[0.00000000144, 0.86629692094, 7380.49600162720],
[0.00000000150, 0.23529641094, 1228.96211332220],
[0.00000000144, 0.12285484149, 647.01083331480],
[0.00000000160, 0.24157324936, 11614.43329373220],
[0.00000000146, 4.76067886088, 16706.58525184800],
[0.00000000188, 2.96688973732, 2178.13772229200],
[0.00000000175, 1.66915420767, 22345.26037610820],
[0.00000000141, 1.75571255457, 3657.00429635640],
[0.00000000145, 0.71777671857, 6784.31762761820],
[0.00000000138, 2.74151377335, 6546.15977336420],
[0.00000000139, 4.12056692213, 3351.24909204960],
[0.00000000152, 4.88528890547, 110.20632121940],
[0.00000000134, 0.86682710306, 3603.69635007260],
[0.00000000170, 5.54401695608, 3265.83082813250],
[0.00000000165, 2.74557093704, 4672.66731424060],
[0.00000000129, 0.94520493983, 419.48464387520],
[0.00000000167, 3.43007767272, 1581.95934828300],
[0.00000000136, 3.68877945956, 13171.00144068760],
[0.00000000160, 0.68321924763, 6475.03930496240],
[0.00000000129, 4.46548223743, 9499.25986200560],
[0.00000000144, 1.88085102951, 9468.26787725700],
[0.00000000149, 3.49118810274, 14158.74771361560],
[0.00000000138, 1.92770959208, 15.25247118500],
[0.00000000172, 0.23189971635, 12323.42309600880],
[0.00000000121, 1.75813513715, 4379.63903749020],
[0.00000000120, 6.04299490267, 6606.44325483230],
[0.00000000134, 1.98845453946, 8965.97846825920],
[0.00000000118, 0.22641710036, 11766.26326451460],
[0.00000000122, 2.92219895926, 21947.11137270000],
[0.00000000147, 5.86576524955, 3169.93955608060],
[0.00000000121, 5.75886629308, 19513.98359510420],
[0.00000000119, 3.93419985914, 4936.79886898440],
[0.00000000123, 4.65853055862, 13149.15061136120],
[0.00000000151, 4.38870879458, 13362.51701710200],
[0.00000000134, 4.49208622602, 2480.30249794700],
[0.00000000115, 5.78268772131, 12722.55242048520],
[0.00000000126, 4.43971496486, 3568.08855948880],
[0.00000000114, 0.36704570747, 3384.33133900480],
[0.00000000117, 0.67607782416, 13207.02930736500],
[0.00000000124, 5.80386208894, 10721.10842832700],
[0.00000000115, 0.23672592056, 224.34479570190],
[0.00000000110, 0.26402316132, 3077.52850332700],
[0.00000000112, 3.50979462224, 1375.77379984580],
[0.00000000108, 5.30086016687, 10264.56588407340],
[0.00000000146, 2.36972522432, 4989.05918389720],
[0.00000000143, 0.92798026058, 5401.43028077160],
[0.00000000111, 2.47771615302, 18606.49894600020],
[0.00000000124, 1.13870545502, 2807.39834325620],
[0.00000000105, 5.87122793977, 4193.80880845180],
[0.00000000115, 3.01754571849, 1118.75579210280],
[0.00000000107, 2.03274473347, 25685.87280280800],
[0.00000000107, 4.82345245872, 13362.38239649640],
[0.00000000105, 1.21018340855, 8584.66166590080],
[0.00000000104, 5.07527834174, 23141.55838292460],
[0.00000000100, 4.08698733114, 3511.28529731900],
[0.00000000105, 1.13833234280, 1162.47470440780],
[0.00000000102, 2.55243872323, 664.75604513000],
[0.00000000138, 3.04361079523, 3329.97576135000],
[0.00000000130, 3.04769575195, 3341.03250279340],
[0.00000000117, 2.97177407391, 9602.35263622420],
[0.00000000098, 4.54292546461, 3362.46325602620],
[0.00000000097, 2.21618504638, 10042.61267559180],
[0.00000000100, 5.45541648580, 3024.22055704320],
[0.00000000097, 1.55448890675, 8799.98871377800],
[0.00000000107, 5.15001764390, 956.28915597060],
[0.00000000100, 1.80839732601, 6665.97238221460],
[0.00000000104, 0.04641040148, 10001.06188460700],
[0.00000000097, 0.30502193916, 10014.72373309860],
[0.00000000125, 3.71144870102, 3873.82651014340],
[0.00000000102, 5.38933965862, 13892.14067189380],
[0.00000000108, 4.33438895790, 3490.17562383440],
[0.00000000095, 2.32591017464, 10028.95082710020],
[0.00000000113, 1.74323945160, 11610.91017538320],
[0.00000000119, 4.94578003013, 3443.70520091840],
[0.00000000096, 1.63239207663, 11925.27409260060],
[0.00000000124, 0.82697196609, 9638.94074787620],
[0.00000000101, 1.51065535085, 1062.90504853820],
[0.00000000107, 4.36653716080, 6531.66165626500],
[0.00000000090, 2.01534774170, 22324.90505670940],
[0.00000000094, 4.85202869277, 14047.49376102520],
[0.00000000089, 1.23714034226, 20809.46762464520],
[0.00000000095, 5.69916785631, 6717.25272007700],
[0.00000000095, 2.15038299943, 8013.27974094040],
[0.00000000111, 3.91313035726, 3311.18291816379],
[0.00000000089, 1.37925538521, 74.78159856730],
[0.00000000094, 3.24872875047, 6657.34641565180],
[0.00000000089, 0.70324117212, 23.87843774780],
[0.00000000087, 0.40376031248, 2221.85663459700],
[0.00000000092, 3.33165786190, 2540.79130153440],
[0.00000000120, 3.09344469205, 6685.10618875760],
[0.00000000087, 4.92694309070, 1505.28780909299],
[0.00000000091, 1.66121998822, 24150.08005134500],
[0.00000000090, 5.47687082598, 16699.53901514999],
[0.00000000119, 2.53709230647, 3312.16323923200],
[0.00000000118, 5.56523997231, 2814.44457995420],
[0.00000000093, 1.61394240489, 3341.04230982650],
[0.00000000084, 1.19439840758, 3450.81874791920],
[0.00000000085, 4.95060410388, 7314.00859271280],
[0.00000000084, 3.92244493446, 170.67287061920],
[0.00000000096, 5.49205832489, 3427.92063123960],
[0.00000000106, 1.61703818023, 3774.32416457660],
[0.00000000101, 6.18535119914, 5511.63660199100],
[0.00000000081, 3.16562241132, 52175.80628314840],
[0.00000000093, 5.15512549422, 3451.79906898740],
[0.00000000108, 0.33314004399, 6709.67404086740],
[0.00000000078, 2.38080208142, 13553.89797291080],
[0.00000000085, 1.18588430640, 6705.10329114740],
[0.00000000098, 3.24856024758, 25287.72379939980],
[0.00000000080, 2.54327778068, 6675.70192909220],
[0.00000000078, 4.70533248161, 24889.57479599160],
[0.00000000095, 1.59916172961, 4271.97551355160],
[0.00000000076, 0.90799171644, 2675.85638156980],
[0.00000000091, 3.80728044706, 2125.87740737920],
[0.00000000093, 5.59480359619, 3340.18254357310],
[0.00000000095, 2.06299921822, 6518.75821726740],
[0.00000000100, 6.02550501045, 3313.21087060300],
[0.00000000075, 6.16095890090, 3370.04193523580],
[0.00000000077, 4.92444879515, 3229.42578441220],
[0.00000000090, 4.55063359845, 6701.58017279840],
[0.00000000078, 2.01202524407, 14421.83163698840],
[0.00000000079, 5.92142974185, 6155.05700665400],
[0.00000000101, 2.07923317336, 15265.88651930040],
[0.00000000082, 6.04078010866, 3760.09707057500],
[0.00000000073, 3.01106366205, 206.18554843720],
[0.00000000078, 1.71095661489, 3399.98628861340],
[0.00000000073, 3.32824316241, 9588.12554222260],
[0.00000000076, 1.74030672711, 6756.00645196690],
[0.00000000073, 1.44980946324, 5408.54382777240],
[0.00000000077, 5.64501410813, 3209.07046501340],
[0.00000000080, 5.70272305344, 10156.90236013480],
[0.00000000075, 3.83222347813, 39048.32250960720],
[0.00000000072, 0.82629826575, 7366.26890762560],
[0.00000000083, 4.71804515025, 14061.72085502680],
[0.00000000072, 4.35767091893, 21548.96236929180],
[0.00000000086, 1.50107043029, 5989.06725217280],
[0.00000000073, 3.77377582806, 28628.33622609960],
[0.00000000082, 0.78740181090, 16276.46394262300],
[0.00000000070, 2.69225539304, 3296.89351439480],
[0.00000000069, 1.01941228196, 12295.95422960920],
[0.00000000081, 4.64227979982, 6947.83189512140],
[0.00000000094, 0.74502278458, 5244.04923920100],
[0.00000000067, 4.47328871650, 20206.14119633100],
[0.00000000091, 2.95968633697, 3326.38533269820],
[0.00000000076, 2.86128350856, 8542.97070603500],
[0.00000000065, 1.31079130285, 23546.75362303080],
[0.00000000065, 3.31422850411, 6414.61781167780],
[0.00000000064, 3.98415414793, 3368.01398279660],
[0.00000000065, 4.15810281695, 3340.19235060619],
[0.00000000071, 3.82044323862, 6578.13207918100],
[0.00000000080, 1.02128994578, 7321.12213971360],
[0.00000000064, 1.07965886113, 6944.30877677240],
[0.00000000064, 1.20215520018, 38.13303563780],
[0.00000000070, 5.11166911478, 9485.03276800400],
[0.00000000067, 2.22216014849, 4845.90023579280],
[0.00000000083, 1.86067842148, 931.36308685180],
[0.00000000063, 0.45029141698, 6418.14093002680],
[0.00000000062, 5.68207205878, 4459.36821880260],
[0.00000000062, 0.62454636835, 6688.27109009760],
[0.00000000076, 0.41820625869, 5032.77809620220],
[0.00000000062, 5.72811519809, 2008.55753915900],
[0.00000000060, 1.98790201827, 12199.97500239140],
[0.00000000078, 2.18035217615, 3232.94890276120],
[0.00000000060, 1.08971396071, 10124.93005431800],
[0.00000000072, 4.08555524166, 3416.87849797540],
[0.00000000061, 2.49066420507, 4005.36847182980],
[0.00000000059, 2.93755144370, 9886.77220006400],
[0.00000000069, 1.02371083242, 6621.85099148600],
[0.00000000061, 4.57446273568, 2277.70737816160],
[0.00000000059, 4.74745481720, 16865.52876963120],
[0.00000000069, 3.62576981720, 15906.76412668260],
[0.00000000058, 4.15993379336, 1854.63230563460],
[0.00000000060, 4.92798256747, 3391.89276456221],
[0.00000000070, 4.51699340219, 16304.91313009080],
[0.00000000056, 3.59354639280, 7322.10246078180],
[0.00000000068, 0.81217091970, 16703.04487984680],
[0.00000000056, 3.19997567622, 4140.43355186520],
[0.00000000058, 1.73479637157, 2409.24933984800],
[0.00000000054, 5.54310937490, 2604.73591316800],
[0.00000000059, 2.02922256380, 45486.81875903279],
[0.00000000063, 5.29505507594, 17101.21113690720],
[0.00000000054, 4.88230660750, 48300.16010269000],
[0.00000000071, 4.84381041200, 3289.33208883739],
[0.00000000054, 1.76917054114, 3510.19260983280],
[0.00000000063, 2.80175814276, 16894.51039961060],
[0.00000000058, 0.91631357427, 10018.24685144760],
[0.00000000054, 1.06826755543, 8948.22825590860],
[0.00000000072, 1.36121375974, 10025.42770875120],
[0.00000000061, 0.92427393171, 17468.85519794540],
[0.00000000068, 2.84271358352, 16703.07938715119],
[0.00000000053, 3.42679182927, 14867.73751589219],
[0.00000000054, 0.41070672545, 18451.07854656599],
[0.00000000060, 5.86922287544, 7447.01791784600],
[0.00000000051, 1.64684042106, 3472.15438838620],
[0.00000000057, 6.13250399703, 17085.95866572220],
[0.00000000053, 4.16969434701, 6106.88005506480],
[0.00000000050, 3.17196717347, 2111.65031337760],
[0.00000000055, 5.72607545560, 10706.88133432540],
[0.00000000062, 0.57333106196, 3171.03224356680],
[0.00000000053, 1.29007833025, 6652.77566593180],
[0.00000000050, 2.96441858632, 10037.08975128440],
[0.00000000065, 5.11165617529, 3113.13629391080],
[0.00000000053, 4.87447079015, 1485.98012106520],
[0.00000000050, 2.52848298042, 10448.43547097540],
[0.00000000059, 1.69623653028, 4025.65648092580],
[0.00000000047, 5.15559748285, 12012.58229714040],
[0.00000000049, 1.19473362353, 3448.27595063840],
[0.00000000063, 1.01191427607, 11769.85369316640],
[0.00000000064, 3.86219786087, 18208.34994259200],
[0.00000000059, 2.96261275062, 14071.43950907579],
[0.00000000049, 1.41657179779, 2938.94030494260],
[0.00000000048, 2.95878690387, 11527.12508919240],
[0.00000000052, 0.01971915447, 8226.57883637840],
[0.00000000045, 5.07966377852, 3318.76159737340],
[0.00000000043, 1.23879381294, 7218.02936549500],
[0.00000000058, 5.58121433163, 6643.09181776180],
[0.00000000048, 5.02446939402, 6645.19698672220],
[0.00000000043, 0.69492704598, 20995.39296644940],
[0.00000000044, 4.02272101657, 9389.05354078620],
[0.00000000055, 4.38138154697, 1478.86657406440],
[0.00000000051, 4.24292455428, 792.77488846740],
[0.00000000042, 2.74826708762, 14577.18472611980],
[0.00000000044, 4.18397905503, 8535.85715903420],
[0.00000000047, 1.33588473182, 632.78373931320],
[0.00000000042, 5.05676915852, 3397.51080163540],
[0.00000000042, 0.28204510006, 10001.48196070061],
[0.00000000042, 0.75310918544, 6357.71943674220],
[0.00000000042, 4.94532732982, 18052.92954315780],
[0.00000000052, 4.09912687749, 5835.14201864840],
[0.00000000054, 2.46533302314, 8186.51266249260],
[0.00000000043, 4.77713978044, 32124.36905223359],
[0.00000000053, 6.08293348275, 3377.21779200400],
[0.00000000041, 2.51168269556, 4186.69526145100],
[0.00000000041, 1.24482327948, 3212.59358336240],
[0.00000000041, 5.42003026893, 685.04405422600],
[0.00000000041, 5.04768364997, 6571.01853218020],
[0.00000000042, 2.08904552145, 13363.43002786740],
[0.00000000048, 4.82888746454, 1835.32461760680],
[0.00000000043, 4.17203713456, 43340.65334255760],
[0.00000000046, 0.81640935106, 45884.96776244100],
[0.00000000042, 2.26773068307, 12729.66596748600],
[0.00000000039, 5.85791936573, 846.08283475120],
[0.00000000043, 2.90976420757, 6872.67311951120],
[0.00000000045, 1.98725045807, 1861.74585263540],
[0.00000000045, 0.50053853542, 14128.24277124560],
[0.00000000046, 2.86512929328, 38650.17350619900],
[0.00000000038, 3.65846461938, 29698.28751133580],
[0.00000000039, 4.57679716458, 6901.63749583840],
[0.00000000039, 3.85504465583, 9945.57120882380],
[0.00000000040, 0.06127203284, 9947.05568153210],
[0.00000000043, 5.28854105201, 3274.12501778540],
[0.00000000047, 6.25707790441, 24606.13555322000],
[0.00000000037, 5.02115296017, 11128.97608578420],
[0.00000000039, 1.71421919870, 7696.88787128380],
[0.00000000037, 4.34652985120, 3283.71405176420],
[0.00000000037, 0.05572748092, 21150.81336588360],
[0.00000000042, 4.97872041460, 13575.74880223720],
[0.00000000050, 4.24170332288, 7747.72033058960],
[0.00000000037, 4.07496312186, 8646.06348025360],
[0.00000000038, 0.44080908793, 24491.42579258340],
[0.00000000036, 1.73681874925, 3468.63127003720],
[0.00000000041, 5.69294900686, 26087.90314157420],
[0.00000000036, 1.80256389689, 8756.26980147300],
[0.00000000036, 3.37374689465, 48429.28218232440],
[0.00000000035, 0.10555289345, 8742.04270747140],
[0.00000000041, 4.26832466355, 21000.91589075680],
[0.00000000038, 0.73199792046, 26084.02180621620],
], [
[0.00044242247, 0.47930603943, 3340.61242669980],
[0.00008138042, 0.86998398093, 6681.22485339960],
[0.00001274915, 1.22594050809, 10021.83728009940],
[0.00000187387, 1.57298991982, 13362.44970679920],
[0.00000040744, 1.97080175060, 3344.13554504880],
[0.00000052396, 3.14159265359, 0.00000000000],
[0.00000026616, 1.91665615762, 16703.06213349900],
[0.00000017825, 4.43499505333, 2281.23049651060],
[0.00000011713, 4.52510453730, 3185.19202726560],
[0.00000010209, 5.39143469548, 1059.38193018920],
[0.00000009950, 0.41870577185, 796.29800681640],
[0.00000009237, 4.53579272961, 2146.16541647520],
[0.00000007299, 3.14218509183, 2544.31441988340],
[0.00000007217, 2.29300859074, 6684.74797174860],
[0.00000006808, 5.26702580055, 155.42039943420],
[0.00000006528, 2.30781369329, 3738.76143010800],
[0.00000007785, 5.93369079547, 1748.01641306700],
[0.00000005840, 1.05191350362, 1349.86740965880],
[0.00000006749, 5.30194395749, 1194.44701022460],
[0.00000004695, 0.76880586144, 3097.88382272579],
[0.00000005391, 1.00223256041, 3149.16416058820],
[0.00000004406, 2.45556303355, 951.71840625060],
[0.00000004286, 3.89643520638, 1592.59601363280],
[0.00000003514, 1.85168391963, 398.14900340820],
[0.00000003699, 2.26043707772, 20043.67456019880],
[0.00000003377, 3.81683532672, 1751.53953141600],
[0.00000004585, 0.80787441740, 4136.91043351620],
[0.00000003201, 2.11657635165, 5614.72937620960],
[0.00000003622, 1.32395191387, 3333.49887969900],
[0.00000002916, 1.19337460559, 529.69096509460],
[0.00000002979, 2.86481008776, 6151.53388830500],
[0.00000003057, 4.55276793064, 5628.95647021120],
[0.00000002906, 1.20295377623, 3894.18182954220],
[0.00000003850, 3.86055626689, 553.56940284240],
[0.00000002820, 2.48683324916, 1990.74501704100],
[0.00000002657, 6.07411629964, 4292.33083295040],
[0.00000002700, 2.92139773350, 3496.03282613400],
[0.00000002395, 5.94175921617, 2787.04302385740],
[0.00000002264, 2.56219866409, 191.44826611160],
[0.00000002167, 5.36812435483, 8962.45534991020],
[0.00000002149, 2.74950075397, 242.72860397400],
[0.00000002217, 1.85265984462, 3337.08930835080],
[0.00000001996, 5.76429928131, 3341.59274776800],
[0.00000001999, 3.82349238481, 2914.01423582380],
[0.00000001835, 5.68592723044, 1589.07289528380],
[0.00000001812, 3.32042068028, 5088.62883976680],
[0.00000002413, 4.68291336853, 4690.47983635860],
[0.00000001970, 4.17480610904, 3340.59517304760],
[0.00000001970, 6.20643855008, 3340.62968035200],
[0.00000001627, 5.67733051452, 4535.05943692440],
[0.00000002160, 1.07452599834, 2388.89402044920],
[0.00000001964, 3.10805316088, 3583.34103067380],
[0.00000001985, 5.75850351840, 4399.99435688900],
[0.00000001507, 4.95936409838, 382.89653222320],
[0.00000001278, 4.82232889938, 2957.71589447660],
[0.00000001475, 2.22707926559, 3723.50895892300],
[0.00000001196, 3.26724458920, 9492.14631500480],
[0.00000001349, 4.87573224485, 6525.80445396540],
[0.00000001433, 2.69734916443, 7079.37385680780],
[0.00000001224, 2.62012336714, 10025.36039844840],
[0.00000001404, 5.19056026479, 2700.71514038580],
[0.00000001202, 0.93472783088, 2810.92146160520],
[0.00000000869, 5.81340811635, 12303.06777661000],
[0.00000000867, 2.20046640409, 2699.73481931760],
[0.00000000830, 2.01484544773, 5092.15195811580],
[0.00000000855, 5.96220147975, 426.59819087600],
[0.00000000848, 2.26407047301, 6283.07584999140],
[0.00000000917, 1.40295785881, 6489.77658728800],
[0.00000000833, 1.17384197174, 7477.52286021600],
[0.00000001041, 6.27171470048, 3347.72597370060],
[0.00000000965, 3.39855816541, 5621.84292321040],
[0.00000000722, 4.26304776331, 4933.20844033260],
[0.00000000706, 2.34131594714, 7.11354700080],
[0.00000000768, 2.06208352904, 5486.77784317500],
[0.00000000953, 2.11123497948, 3870.30339179440],
[0.00000000844, 2.23931963240, 3553.91152213780],
[0.00000000646, 2.24669034469, 3340.54511639700],
[0.00000000653, 3.99043329363, 6677.70173505060],
[0.00000000714, 0.29739480601, 6681.24210705180],
[0.00000000828, 0.22863617670, 3532.06069281140],
[0.00000000612, 1.55388376751, 7234.79425624200],
[0.00000000714, 4.54969883976, 6681.20759974740],
[0.00000000586, 3.30118433303, 1221.84856632140],
[0.00000000646, 1.83853693231, 3340.67973700260],
[0.00000000560, 5.05848353328, 8031.09226305840],
[0.00000000651, 0.15897472160, 7632.94325965020],
[0.00000000488, 3.08086378649, 6836.64525283380],
[0.00000000534, 4.25727954634, 3339.63210563160],
[0.00000000504, 2.59990772815, 23384.28698689860],
[0.00000000372, 6.27186983164, 2487.41604494780],
[0.00000000343, 4.71059403854, 639.89728631400],
[0.00000000449, 1.34123846614, 640.87760738220],
[0.00000000342, 5.96338023755, 4929.68532198360],
[0.00000000329, 2.65955258770, 9623.68827669120],
[0.00000000352, 6.09567212646, 7740.60678358880],
[0.00000000326, 6.05498346093, 2118.76386037840],
[0.00000000403, 4.96465831103, 8969.56889691100],
[0.00000000402, 2.84624835384, 5331.35744374080],
[0.00000000319, 1.44545457475, 5729.50644714900],
[0.00000000303, 0.01918776551, 6127.65545055720],
[0.00000000297, 5.74070606294, 6041.32756708560],
[0.00000000297, 3.06763224975, 10419.98628350760],
[0.00000000282, 6.04069352017, 7875.67186362420],
[0.00000000278, 5.11654962157, 11773.37681151540],
[0.00000000259, 2.89786343627, 7210.91581849420],
[0.00000000273, 3.83181794308, 8429.24126646660],
[0.00000000256, 1.08862226474, 2288.34404351140],
[0.00000000288, 6.13572687680, 6682.20517446780],
[0.00000000302, 3.61490647715, 12832.75874170460],
[0.00000000235, 2.21413387615, 6681.29216370240],
[0.00000000317, 3.60634897209, 2301.58581590939],
[0.00000000289, 5.08223311018, 2274.11694950980],
[0.00000000254, 0.36603904729, 3767.21061757580],
[0.00000000235, 2.62434481550, 6681.15754309680],
[0.00000000226, 3.45305949713, 6923.95345737360],
[0.00000000205, 3.88943452829, 10018.31416175040],
[0.00000000206, 3.44453113177, 10177.25767953360],
[0.00000000210, 0.57926734389, 10973.55568635000],
[0.00000000194, 1.57870686859, 10818.13528691580],
[0.00000000190, 2.42312911773, 8955.34180290940],
[0.00000000194, 2.45887376159, 7064.12138562280],
[0.00000000193, 0.58793888724, 5828.02847164760],
[0.00000000183, 1.68247271963, 213.29909543800],
[0.00000000236, 1.98863774162, 10575.40668294180],
[0.00000000245, 2.17761779228, 4562.46099302120],
[0.00000000177, 0.66379705293, 10021.85453375160],
[0.00000000176, 4.91607557961, 10021.82002644720],
[0.00000000217, 2.93968443649, 13365.97282514820],
[0.00000000167, 4.74764434327, 3914.95722503460],
[0.00000000213, 0.15734917857, 2942.46342329160],
[0.00000000155, 1.78776991092, 9830.38901398780],
[0.00000000180, 5.21088564787, 9866.41688066520],
[0.00000000161, 5.17683861380, 6298.32832117640],
[0.00000000159, 2.68980684850, 6894.52394883760],
[0.00000000149, 6.26524493469, 1039.02661079040],
[0.00000000147, 0.36939961702, 6688.33840040040],
[0.00000000151, 1.22272892290, 574.34479833480],
[0.00000000137, 2.09492296067, 1066.49547719000],
[0.00000000165, 6.15952050903, 15643.68020330980],
[0.00000000163, 4.66507592292, 8273.82086703240],
[0.00000000124, 0.67855210339, 6438.49624942560],
[0.00000000128, 1.69206367749, 3981.49003408200],
[0.00000000116, 2.78191248964, 3360.96774609859],
[0.00000000128, 0.84461423001, 3355.86489788480],
[0.00000000124, 1.63253732557, 6674.11130639880],
[0.00000000120, 0.31762150109, 3127.31333126180],
[0.00000000129, 2.26678583645, 6467.92575796160],
[0.00000000104, 0.07355376701, 3325.35995551480],
[0.00000000130, 4.41777190830, 3320.25710730100],
[0.00000000095, 1.31957248342, 7903.07341972100],
[0.00000000114, 0.65681602343, 3178.14579056760],
[0.00000000092, 4.98392367746, 9779.10867612540],
[0.00000000101, 4.10670787374, 536.80451209540],
[0.00000000106, 5.41622566807, 15113.98923821520],
[0.00000000096, 3.52561014696, 3475.67750673520],
[0.00000000101, 2.91169549546, 692.15760122680],
[0.00000000093, 3.21464368291, 8671.96987044060],
[0.00000000087, 5.24375873119, 13119.72110282519],
[0.00000000106, 3.76804681559, 13517.87010623340],
[0.00000000089, 5.73652101746, 11371.70468975820],
[0.00000000104, 5.90078964406, 8432.76438481560],
[0.00000000099, 3.61425346453, 853.19638175200],
[0.00000000078, 0.95802015551, 3191.04922956520],
[0.00000000089, 2.50872076312, 1052.26838318840],
[0.00000000078, 2.98115354616, 26724.89941359840],
[0.00000000079, 5.91514993930, 6040.34724601740],
[0.00000000090, 3.00950470302, 12964.30070339100],
[0.00000000075, 1.31512531841, 17924.91069982040],
[0.00000000073, 5.01153593776, 1903.43681250120],
[0.00000000075, 2.57969241717, 10021.90459040220],
[0.00000000073, 4.09954161905, 3319.83703120740],
[0.00000000070, 5.37678396256, 12310.18132361080],
[0.00000000071, 0.98422998240, 13362.46696045140],
[0.00000000068, 4.69140248943, 522.57741809380],
[0.00000000068, 3.24217441291, 16706.58525184800],
[0.00000000069, 2.53964193741, 5884.92684658320],
[0.00000000070, 2.38237948321, 13916.01910964160],
[0.00000000066, 3.48443797546, 13760.59871020740],
[0.00000000068, 5.27435069681, 3980.50971301380],
[0.00000000076, 0.12288413214, 11216.28429032400],
[0.00000000073, 3.94785759909, 16173.37116840440],
[0.00000000062, 0.15518975647, 11081.21921028860],
[0.00000000074, 2.99926779692, 10021.76996979660],
[0.00000000080, 6.18812323827, 9380.95967271720],
[0.00000000064, 3.99294283669, 13358.92658845020],
[0.00000000061, 2.56817782412, 149.56319713460],
[0.00000000059, 3.80850908229, 10264.56588407340],
[0.00000000060, 4.79879360562, 1437.17561419860],
[0.00000000068, 2.07515658228, 1596.18644228460],
[0.00000000060, 2.26503107747, 28628.33622609960],
[0.00000000058, 6.10782258899, 5459.37628707820],
[0.00000000063, 0.24407077742, 18984.29263000960],
[0.00000000058, 5.22738430747, 13362.43245314700],
[0.00000000056, 1.88708253797, 9070.11887384880],
[0.00000000055, 5.72587156499, 433.71173787680],
[0.00000000056, 1.18238857561, 6696.47732458460],
[0.00000000062, 3.98214740104, 3427.92063123960],
[0.00000000056, 5.37129176649, 5099.26550511660],
[0.00000000057, 0.86204712032, 5642.19824260920],
[0.00000000055, 1.31787605222, 8982.81066930900],
[0.00000000056, 5.49808236951, 24093.27678917520],
[0.00000000054, 3.77562154746, 10213.28554621100],
[0.00000000054, 2.36294643031, 33716.96506586640],
[0.00000000063, 3.53402427573, 3205.54734666440],
[0.00000000066, 6.25810929981, 8270.29774868340],
[0.00000000067, 0.58592813080, 3335.08950239240],
[0.00000000055, 4.74995645767, 6660.86953400080],
[0.00000000053, 0.31930032532, 12721.57209941700],
[0.00000000069, 2.42905593362, 6158.64743530580],
[0.00000000055, 5.03192783121, 7255.56965173440],
[0.00000000051, 5.45351947711, 13207.02930736500],
[0.00000000050, 0.23368526162, 4379.63903749020],
[0.00000000053, 2.12826344020, 13171.00144068760],
[0.00000000049, 2.35512151368, 4032.77002792660],
[0.00000000049, 2.81773050890, 9808.53818466140],
[0.00000000067, 2.26295786556, 2766.26762836500],
[0.00000000049, 0.72597680486, 10028.95082710020],
[0.00000000050, 6.10119450350, 3253.30422216000],
[0.00000000059, 0.27861398526, 9225.53927328300],
[0.00000000053, 1.27330874549, 3344.49376205780],
[0.00000000049, 2.91499389416, 10404.73381232260],
[0.00000000047, 0.48598973231, 17395.21973472580],
[0.00000000049, 3.40240207389, 3304.58456002240],
[0.00000000060, 3.40554368741, 10551.52824519400],
[0.00000000050, 1.83471955355, 30376.35263916660],
[0.00000000046, 3.04980996832, 6144.42034130420],
[0.00000000049, 0.33200904496, 6702.00024889200],
[0.00000000053, 0.35820094732, 9468.26787725700],
[0.00000000050, 0.15378507249, 2648.45482547300],
[0.00000000044, 0.79762157297, 7107.82304427560],
[0.00000000050, 2.41332661328, 4407.10790388980],
[0.00000000054, 0.21682940856, 10022.81760116760],
[0.00000000044, 5.78502737591, 3364.49086444760],
[0.00000000044, 0.75508636274, 16062.18452611680],
[0.00000000043, 3.10581037685, 10235.13637553740],
[0.00000000044, 5.21252098878, 7373.38245462640],
[0.00000000058, 4.51680312444, 6660.44945790720],
[0.00000000043, 0.15523355839, 1505.28780909299],
[0.00000000055, 5.93371026829, 8439.87793181640],
[0.00000000042, 5.40417232308, 3344.20285535160],
[0.00000000056, 3.87534582911, 6816.28993343500],
[0.00000000049, 5.57153056447, 17468.85519794540],
[0.00000000046, 3.07783299049, 12722.55242048520],
[0.00000000045, 1.49303542795, 6247.51311552280],
[0.00000000055, 6.26098836404, 3361.38782219220],
[0.00000000042, 4.74455545491, 3369.06161416760],
[0.00000000040, 1.58676666294, 2818.03500860600],
[0.00000000043, 4.97295184315, 3337.02199804800],
[0.00000000055, 3.80215638520, 3376.64029337720],
[0.00000000047, 1.97367775421, 1581.95934828300],
[0.00000000045, 2.03598705348, 5244.04923920100],
[0.00000000049, 4.43182954044, 9595.23908922340],
[0.00000000043, 0.38914582094, 6665.97238221460],
[0.00000000040, 1.06953099245, 23695.12778576700],
[0.00000000038, 0.59996214864, 10713.99488132620],
[0.00000000039, 3.79055778605, 33318.81606245820],
[0.00000000041, 5.54542347834, 3863.18984479360],
[0.00000000037, 5.27208151144, 20752.66436247540],
[0.00000000039, 3.15412760412, 14469.58851248400],
[0.00000000041, 0.55705920174, 3346.13535100720],
[0.00000000048, 1.42210748234, 3316.73398895200],
[0.00000000049, 5.44942247991, 9638.94074787620],
[0.00000000038, 2.11846271943, 15664.03552270859],
[0.00000000035, 5.30782933148, 6677.63442474780],
[0.00000000036, 2.68151450016, 8584.66166590080],
[0.00000000046, 3.09450395763, 6701.58017279840],
[0.00000000038, 1.81885395671, 14158.74771361560],
[0.00000000037, 5.80483071722, 6684.81528205140],
[0.00000000047, 2.60317702777, 162.46663613220],
[0.00000000038, 2.22559377525, 3503.07906283200],
[0.00000000035, 0.84358942718, 6518.75821726740],
[0.00000000033, 4.92302322062, 23141.55838292460],
[0.00000000043, 0.95148893985, 34115.11406927460],
[0.00000000046, 4.99457196207, 9381.93999378540],
[0.00000000043, 1.73832102244, 12323.42309600880],
[0.00000000032, 2.92741580696, 9499.25986200560],
[0.00000000043, 1.50296327105, 27035.74021246680],
[0.00000000033, 5.41731109688, 20597.24396304120],
[0.00000000032, 4.13881058425, 31570.79964939120],
[0.00000000040, 5.84463069180, 16460.33352952499],
[0.00000000035, 5.50083743557, 8425.65083781480],
[0.00000000038, 5.91991985929, 3336.73109134180],
[0.00000000030, 5.09155042811, 5085.03841111500],
[0.00000000031, 4.27211180916, 36659.42848915800],
[0.00000000030, 4.87389489592, 1692.16566950240],
[0.00000000030, 3.75494646937, 4845.90023579280],
[0.00000000034, 3.71030605417, 8827.39026987480],
[0.00000000030, 0.01599456850, 11243.68584642080],
[0.00000000029, 2.66198696023, 12295.95422960920],
[0.00000000028, 3.12114207206, 11925.27409260060],
[0.00000000036, 1.16568750904, 18052.92954315780],
[0.00000000032, 1.72704226918, 12566.15169998280],
[0.00000000028, 2.80254457895, 3607.21946842160],
[0.00000000032, 4.04390839531, 6680.24453233140],
[0.00000000027, 2.53565904393, 19004.64794940840],
[0.00000000036, 3.33518515689, 29978.20363575840],
[0.00000000028, 0.58104982217, 20354.51535906720],
[0.00000000029, 5.85207825749, 31172.65064598300],
[0.00000000026, 2.22598820379, 3.52311834900],
[0.00000000033, 5.15903548241, 10596.18207843420],
[0.00000000028, 1.89792803028, 3333.56619000180],
[0.00000000027, 2.25129832716, 76.26607127560],
[0.00000000026, 4.32703172263, 17085.95866572220],
[0.00000000026, 5.12847780702, 11766.26326451460],
[0.00000000028, 0.80926596905, 20735.83216142559],
[0.00000000026, 5.06814803493, 17412.05193577560],
[0.00000000024, 4.47399155600, 3134.42687826260],
[0.00000000024, 4.35557152695, 14584.29827312060],
[0.00000000027, 4.98717355201, 3877.41693879520],
[0.00000000025, 5.63712701265, 14054.60730802600],
[0.00000000024, 4.12573657295, 4193.80880845180],
[0.00000000025, 1.40880282063, 8186.51266249260],
[0.00000000024, 4.96463811748, 26087.90314157420],
], [
[0.00001113107, 5.14987350142, 3340.61242669980],
[0.00000424446, 5.61343766478, 6681.22485339960],
[0.00000100044, 5.99726827028, 10021.83728009940],
[0.00000019606, 0.07633062094, 13362.44970679920],
[0.00000003477, 0.42951907576, 16703.06213349900],
[0.00000004693, 3.14159265359, 0.00000000000],
[0.00000002869, 0.44711842697, 3344.13554504880],
[0.00000002428, 3.02115527957, 3185.19202726560],
[0.00000000688, 0.80693359444, 6684.74797174860],
[0.00000000540, 3.86836515672, 1059.38193018920],
[0.00000000577, 0.77853275120, 20043.67456019880],
[0.00000000468, 4.52450786544, 3496.03282613400],
[0.00000000487, 1.60862391345, 3583.34103067380],
[0.00000000362, 4.42397903418, 2787.04302385740],
[0.00000000397, 5.71967986581, 3149.16416058820],
[0.00000000299, 0.75640033535, 3738.76143010800],
[0.00000000350, 5.55691984889, 4136.91043351620],
[0.00000000314, 3.37632898783, 6525.80445396540],
[0.00000000233, 2.13965262306, 3097.88382272579],
[0.00000000212, 4.20487494011, 3341.59274776800],
[0.00000000214, 0.56779556947, 155.42039943420],
[0.00000000201, 2.35284464564, 1592.59601363280],
[0.00000000204, 0.96723315302, 1990.74501704100],
[0.00000000230, 5.82959057146, 2388.89402044920],
[0.00000000160, 4.14974194757, 4535.05943692440],
[0.00000000156, 5.13345210285, 796.29800681640],
[0.00000000146, 3.29541339704, 2957.71589447660],
[0.00000000156, 1.13805508457, 10025.36039844840],
[0.00000000159, 3.76174286126, 1194.44701022460],
[0.00000000136, 5.58293924642, 3894.18182954220],
[0.00000000145, 3.02112488974, 3337.08930835080],
[0.00000000146, 4.25359617225, 4399.99435688900],
[0.00000000100, 4.26740096115, 1589.07289528380],
[0.00000000091, 6.12108227231, 6489.77658728800],
[0.00000000101, 1.17242141914, 7079.37385680780],
[0.00000000098, 1.12613498307, 23384.28698689860],
[0.00000000075, 6.02182689533, 529.69096509460],
[0.00000000078, 5.93418069229, 7477.52286021600],
[0.00000000068, 1.70775041911, 9492.14631500480],
[0.00000000070, 3.67253155189, 8962.45534991020],
[0.00000000062, 4.14954627063, 4292.33083295040],
[0.00000000067, 0.15092246550, 3870.30339179440],
[0.00000000066, 1.12578506413, 6151.53388830500],
[0.00000000062, 1.93984222091, 6923.95345737360],
[0.00000000060, 4.30641513096, 12303.06777661000],
[0.00000000074, 4.72156358149, 3347.72597370060],
[0.00000000055, 2.75742802464, 4933.20844033260],
[0.00000000053, 4.77894621871, 6127.65545055720],
[0.00000000050, 2.57807944338, 3340.59517304760],
[0.00000000048, 3.72532068729, 9866.41688066520],
[0.00000000042, 6.15391373101, 7234.79425624200],
[0.00000000043, 3.43955584179, 5486.77784317500],
[0.00000000050, 4.60885064189, 3340.62968035200],
[0.00000000044, 4.47943289816, 426.59819087600],
[0.00000000045, 6.24485207500, 2274.11694950980],
[0.00000000040, 0.73805316471, 7.11354700080],
[0.00000000038, 1.06497784748, 9623.68827669120],
[0.00000000041, 4.60954640493, 6682.20517446780],
[0.00000000038, 4.60963924082, 7740.60678358880],
[0.00000000036, 3.15129246169, 639.89728631400],
[0.00000000037, 6.14629970622, 5729.50644714900],
[0.00000000040, 1.47395544850, 13365.97282514820],
[0.00000000035, 2.60772245492, 4690.47983635860],
[0.00000000035, 2.45077931900, 2288.34404351140],
[0.00000000034, 4.50544497582, 7875.67186362420],
[0.00000000042, 2.11383330882, 12832.75874170460],
[0.00000000033, 3.97655860802, 191.44826611160],
[0.00000000032, 4.06047154083, 3532.06069281140],
[0.00000000034, 5.06671994554, 6681.24210705180],
[0.00000000042, 4.67024017441, 15643.68020330980],
[0.00000000036, 0.29140871479, 3723.50895892300],
[0.00000000033, 4.52588149629, 4929.68532198360],
[0.00000000034, 2.74499072890, 6677.70173505060],
[0.00000000030, 1.57743012295, 10419.98628350760],
[0.00000000040, 1.31713176335, 5331.35744374080],
[0.00000000034, 3.03490000148, 6681.20759974740],
[0.00000000031, 1.25306164576, 242.72860397400],
[0.00000000029, 5.44118048011, 10021.85453375160],
[0.00000000029, 3.41037097794, 10021.82002644720],
[0.00000000028, 4.81855060968, 6836.64525283380],
[0.00000000028, 0.72745302325, 6283.07584999140],
[0.00000000030, 3.06267495632, 2281.23049651060],
[0.00000000027, 0.62535799761, 6681.29216370240],
[0.00000000030, 3.56389476096, 8969.56889691100],
[0.00000000032, 5.31078691958, 553.56940284240],
[0.00000000033, 2.00753799963, 5884.92684658320],
[0.00000000027, 1.18001479303, 8955.34180290940],
[0.00000000025, 2.94122791628, 2544.31441988340],
[0.00000000025, 0.17808889827, 9830.38901398780],
[0.00000000031, 5.73384204593, 3339.63210563160],
[0.00000000028, 3.70436008855, 6298.32832117640],
[0.00000000024, 0.07739730466, 10818.13528691580],
[0.00000000027, 1.03401737006, 6681.15754309680],
[0.00000000024, 0.09987383242, 382.89653222320],
[0.00000000027, 0.60053652251, 3553.91152213780],
[0.00000000027, 4.97107900859, 3767.21061757580],
[0.00000000024, 3.36621347824, 8031.09226305840],
[0.00000000026, 4.80509833364, 7632.94325965020],
[0.00000000022, 1.43966107077, 26724.89941359840],
[0.00000000020, 0.36901153144, 398.14900340820],
[0.00000000019, 1.00325306041, 7064.12138562280],
[0.00000000020, 0.19821371186, 6674.11130639880],
[0.00000000018, 1.07169297658, 7210.91581849420],
[0.00000000021, 2.69512140340, 10018.31416175040],
[0.00000000023, 3.25670295081, 5621.84292321040],
[0.00000000018, 0.24542781929, 3981.49003408200],
[0.00000000018, 5.14428605713, 6688.33840040040],
[0.00000000020, 0.97539014916, 6894.52394883760],
[0.00000000024, 4.42156401638, 1748.01641306700],
[0.00000000016, 0.65389503440, 3340.54511639700],
[0.00000000016, 5.28427106012, 3333.49887969900],
], [
[0.00000019552, 3.58211650473, 3340.61242669980],
[0.00000016323, 4.05116076923, 6681.22485339960],
[0.00000005848, 4.46383962094, 10021.83728009940],
[0.00000001532, 4.84374321619, 13362.44970679920],
[0.00000000375, 1.50962233608, 3185.19202726560],
[0.00000000339, 5.20684967613, 16703.06213349900],
[0.00000000151, 5.16472931648, 3344.13554504880],
[0.00000000125, 2.19233532803, 3496.03282613400],
[0.00000000148, 0.00000000000, 0.00000000000],
[0.00000000087, 0.10275067375, 3583.34103067380],
[0.00000000070, 5.55303619365, 20043.67456019880],
[0.00000000048, 2.91797786512, 2787.04302385740],
[0.00000000049, 5.57038514830, 6684.74797174860],
[0.00000000057, 1.86867280743, 6525.80445396540],
[0.00000000034, 3.63370917313, 3097.88382272579],
[0.00000000021, 2.30677637991, 1059.38193018920],
[0.00000000021, 4.03682122005, 4136.91043351620],
[0.00000000018, 4.17438755890, 3149.16416058820],
[0.00000000013, 1.97805475719, 155.42039943420],
[0.00000000017, 5.94856414690, 10025.36039844840],
[0.00000000012, 0.51097435253, 6923.95345737360],
[0.00000000012, 3.27945299261, 6127.65545055720],
[0.00000000013, 2.22938285522, 9866.41688066520],
[0.00000000016, 2.64206771227, 4399.99435688900],
[0.00000000013, 2.75813969974, 6836.64525283380],
[0.00000000013, 4.51988349676, 6489.77658728800],
[0.00000000014, 0.76591550754, 3894.18182954220],
[0.00000000011, 5.47381242145, 3738.76143010800],
], [
[0.00000000476, 2.47617204701, 6681.22485339960],
[0.00000000268, 2.91510547706, 10021.83728009940],
[0.00000000115, 1.76888962311, 3340.61242669980],
[0.00000000096, 3.31378377179, 13362.44970679920],
[0.00000000048, 6.27457828287, 3185.19202726560],
[0.00000000027, 3.69380877066, 16703.06213349900],
[0.00000000013, 3.72005807206, 3496.03282613400],
[0.00000000012, 4.88179002689, 3583.34103067380],
[0.00000000012, 3.14159265359, 0.00000000000],
]],
('Jupiter', 'L'):[[
[0.59954691495, 0.00000000000, 0.00000000000],
[0.09695898711, 5.06191793105, 529.69096509460],
[0.00573610145, 1.44406205976, 7.11354700080],
[0.00306389180, 5.41734729976, 1059.38193018920],
[0.00097178280, 4.14264708819, 632.78373931320],
[0.00072903096, 3.64042909255, 522.57741809380],
[0.00064263986, 3.41145185203, 103.09277421860],
[0.00039806051, 2.29376744855, 419.48464387520],
[0.00038857780, 1.27231724860, 316.39186965660],
[0.00027964622, 1.78454589485, 536.80451209540],
[0.00013589738, 5.77481031590, 1589.07289528380],
[0.00008246362, 3.58227961655, 206.18554843720],
[0.00008768686, 3.63000324417, 949.17560896980],
[0.00007368057, 5.08101125612, 735.87651353180],
[0.00006263171, 0.02497643742, 213.29909543800],
[0.00006114050, 4.51319531666, 1162.47470440780],
[0.00004905419, 1.32084631684, 110.20632121940],
[0.00005305283, 1.30671236848, 14.22709400160],
[0.00005305457, 4.18625053495, 1052.26838318840],
[0.00004647249, 4.69958109497, 3.93215326310],
[0.00003045009, 4.31675960318, 426.59819087600],
[0.00002610001, 1.56667594850, 846.08283475120],
[0.00002028191, 1.06376547379, 3.18139373770],
[0.00001764768, 2.14148077766, 1066.49547719000],
[0.00001722983, 3.88036008872, 1265.56747862640],
[0.00001920959, 0.97168928755, 639.89728631400],
[0.00001633217, 3.58201089758, 515.46387109300],
[0.00001431997, 4.29683690269, 625.67019231240],
[0.00000973278, 4.09764957065, 95.97922721780],
[0.00000884439, 2.43701426123, 412.37109687440],
[0.00000732875, 6.08534113239, 838.96928775040],
[0.00000731072, 3.80591233956, 1581.95934828300],
[0.00000691928, 6.13368222939, 2118.76386037840],
[0.00000709190, 1.29272573658, 742.99006053260],
[0.00000614464, 4.10853496756, 1478.86657406440],
[0.00000495224, 3.75567461379, 323.50541665740],
[0.00000581902, 4.53967717552, 309.27832265580],
[0.00000375657, 4.70299124833, 1368.66025284500],
[0.00000389864, 4.89716105852, 1692.16566950240],
[0.00000341006, 5.71452525783, 533.62311835770],
[0.00000330458, 4.74049819491, 0.04818410980],
[0.00000440854, 2.95818460943, 454.90936652730],
[0.00000417266, 1.03554430161, 2.44768055480],
[0.00000244170, 5.22020878900, 728.76296653100],
[0.00000261540, 1.87652461032, 0.96320784650],
[0.00000256568, 3.72410724159, 199.07200143640],
[0.00000261009, 0.82047246448, 380.12776796000],
[0.00000220382, 1.65115015995, 543.91805909620],
[0.00000201996, 1.80684574186, 1375.77379984580],
[0.00000207327, 1.85461666594, 525.75881183150],
[0.00000197046, 5.29252149016, 1155.36115740700],
[0.00000235141, 1.22693908124, 909.81873305460],
[0.00000174809, 5.90973505276, 956.28915597060],
[0.00000149368, 4.37745104275, 1685.05212250160],
[0.00000175184, 3.22634903433, 1898.35121793960],
[0.00000175191, 3.72966554761, 942.06206196900],
[0.00000157909, 4.36483921766, 1795.25844372100],
[0.00000137871, 1.31797920785, 1169.58825140860],
[0.00000117495, 2.50022140890, 1596.18644228460],
[0.00000150502, 3.90625022622, 74.78159856730],
[0.00000116757, 3.38920921041, 0.52126486180],
[0.00000105895, 4.55439798236, 526.50957135690],
[0.00000130531, 4.16867945489, 1045.15483618760],
[0.00000141445, 3.13568357861, 491.55792945680],
[0.00000099511, 1.42117395747, 532.87235883230],
[0.00000096137, 1.18156870005, 117.31986822020],
[0.00000091758, 0.85756633461, 1272.68102562720],
[0.00000087695, 1.21738140813, 453.42489381900],
[0.00000068507, 2.35242959478, 2.92076130680],
[0.00000066098, 5.34386149468, 1471.75302706360],
[0.00000077401, 4.42676337124, 39.35687591520],
[0.00000072006, 4.23834923691, 2111.65031337760],
[0.00000063406, 4.97665525033, 0.75075952540],
[0.00000059427, 4.11130498612, 2001.44399215820],
[0.00000062481, 0.51211384012, 220.41264243880],
[0.00000066532, 2.98864358135, 2214.74308759620],
[0.00000060194, 4.12628179571, 4.19278569400],
[0.00000056012, 1.15493222602, 21.34064100240],
[0.00000052854, 0.91207215543, 10.29494073850],
[0.00000070297, 5.14180555282, 835.03713448730],
[0.00000051916, 4.10048180020, 1258.45393162560],
[0.00000046442, 4.66531163524, 5.62907429250],
[0.00000058190, 5.86646380344, 5753.38488489680],
[0.00000040103, 4.68801114087, 0.16005869440],
[0.00000046654, 4.79394835282, 305.34616939270],
[0.00000039298, 4.25448423697, 853.19638175200],
[0.00000046042, 5.10983515150, 4.66586644600],
[0.00000054459, 1.57072704127, 983.11585891360],
[0.00000038920, 6.07592905580, 518.64526483070],
[0.00000038450, 2.43836870888, 433.71173787680],
[0.00000046800, 3.54640538283, 5.41662597140],
[0.00000041830, 4.67982493646, 302.16477565500],
[0.00000035920, 2.45088036239, 430.53034413910],
[0.00000037888, 0.21127448431, 2648.45482547300],
[0.00000039190, 1.71835571629, 11.04570026390],
[0.00000037567, 6.19481310233, 831.85574074960],
[0.00000035828, 4.61459907698, 2008.55753915900],
[0.00000043402, 0.14992289081, 528.20649238630],
[0.00000031598, 5.14073450755, 1788.14489672020],
[0.00000029849, 5.34441117167, 2221.85663459700],
[0.00000032811, 5.28907118836, 88.86568021700],
[0.00000027686, 1.85227036207, 0.21244832110],
[0.00000025820, 3.85920882494, 2317.83586181480],
[0.00000024705, 2.63495214991, 114.13847448250],
[0.00000033844, 1.00563073268, 9683.59458111640],
[0.00000024266, 3.82355417268, 1574.84580128220],
[0.00000027111, 2.80845435102, 18.15924726470],
[0.00000026837, 1.77586123775, 532.13864564940],
[0.00000026064, 2.74361318804, 2531.13495725280],
[0.00000030765, 0.42330537728, 1.48447270830],
[0.00000030476, 3.66677894407, 508.35032409220],
[0.00000023282, 3.24372142416, 984.60033162190],
[0.00000019445, 0.52370214471, 14.97785352700],
[0.00000019332, 4.86314494382, 1361.54670584420],
[0.00000022910, 3.84914895064, 2428.04218303420],
[0.00000021617, 6.01696940024, 1063.31408345230],
[0.00000020155, 5.59582008789, 527.24328453980],
[0.00000023732, 2.52766031921, 494.26624244250],
[0.00000020189, 1.01560227681, 628.85158605010],
[0.00000015994, 5.09003530653, 529.73914920440],
[0.00000016134, 5.27095037302, 142.44965013380],
[0.00000020697, 4.03443281612, 355.74874557180],
[0.00000021479, 1.28668134295, 35.42472265210],
[0.00000014964, 4.86039684390, 2104.53676637680],
[0.00000017242, 1.59187913206, 1439.50969814920],
[0.00000015994, 1.89222417794, 529.64278098480],
[0.00000017958, 4.30178016003, 6.15033915430],
[0.00000013279, 2.18943981644, 1055.44977692610],
[0.00000014148, 2.71597731671, 0.26063243090],
[0.00000014689, 0.87944553412, 99.16062095550],
[0.00000014202, 2.41335693735, 530.65417294110],
[0.00000015320, 6.07703092728, 149.56319713460],
[0.00000015832, 4.11682440678, 636.71589257630],
[0.00000012398, 2.61042299578, 405.25754987360],
[0.00000016199, 2.77035044582, 760.25553592000],
[0.00000013665, 3.56039678310, 217.23124870110],
[0.00000015261, 2.81824770887, 621.73803904930],
[0.00000014681, 6.26423732742, 569.04784100980],
[0.00000012529, 1.39077179081, 7.06536289100],
[0.00000011677, 3.60447374272, 2634.22773147140],
[0.00000011603, 4.60461756191, 7.16173111060],
[0.00000012152, 0.24540531919, 1485.98012106520],
[0.00000011347, 2.00818458261, 1073.60902419080],
[0.00000011242, 2.48000947870, 423.41679713830],
[0.00000010942, 5.03602448252, 458.84151979040],
[0.00000011117, 4.04973271023, 519.39602435610],
[0.00000012256, 4.30153222783, 604.47256366190],
[0.00000013149, 2.72189077702, 1364.72809958190],
[0.00000010604, 3.11518747072, 1.27202438720],
[0.00000009874, 1.70200068743, 1699.27921650320],
[0.00000010851, 5.08554552028, 2324.94940881560],
[0.00000010692, 2.51401681528, 2847.52682690940],
[0.00000012640, 4.75572797691, 528.72775724810],
[0.00000010084, 4.05599810206, 38.13303563780],
[0.00000011536, 2.35034215745, 643.82943957710],
[0.00000010247, 3.63479911496, 2744.43405269080],
[0.00000010105, 3.65845333837, 107.02492748170],
[0.00000010121, 1.31482648275, 1905.46476494040],
[0.00000009341, 5.92176693887, 1148.24761040620],
[0.00000008796, 2.77421822809, 6.59228213900],
[0.00000008420, 4.52537756809, 1677.93857550080],
[0.00000010128, 2.09034472544, 511.53171782990],
[0.00000008272, 2.98682673354, 540.73666535850],
[0.00000009753, 1.22438911827, 32.24332891440],
[0.00000010630, 2.07777800288, 92.04707395470],
[0.00000007850, 0.98996894618, 408.43894361130],
[0.00000008811, 3.46911754939, 1021.24889455140],
[0.00000007946, 2.86682926070, 2125.87740737920],
[0.00000008575, 5.29590411702, 415.55249061210],
[0.00000007841, 6.08025056721, 70.84944530420],
[0.00000007706, 1.69832954219, 8.07675484730],
[0.00000007265, 4.65503563919, 629.60234557550],
[0.00000007164, 4.93400217968, 1056.20053645150],
[0.00000007247, 4.61607677560, 2420.92863603340],
[0.00000007753, 2.12871653382, 33.94024994380],
[0.00000006645, 0.45647460873, 635.96513305090],
[0.00000009377, 4.03158388202, 2810.92146160520],
[0.00000008263, 1.23558676139, 1802.37199072180],
[0.00000006341, 0.07278001580, 202.25339517410],
[0.00000006383, 3.54310669809, 1891.23767093880],
[0.00000007902, 2.32510002614, 230.56457082540],
[0.00000006214, 4.54560345237, 2.70831298570],
[0.00000007347, 1.24457237337, 24.37902238820],
[0.00000007451, 3.02719199239, 330.61896365820],
[0.00000006220, 1.77687561489, 1062.56332392690],
[0.00000005674, 5.14132196367, 746.92221379570],
[0.00000005855, 5.42130172896, 28.31117565130],
[0.00000005629, 3.24348217277, 529.16970023280],
[0.00000007652, 0.52813391052, 672.14061522840],
[0.00000005456, 3.34716871364, 2950.61960112800],
[0.00000007127, 1.43497795005, 6.21977512350],
[0.00000005388, 4.90175095580, 69.15252427480],
[0.00000005618, 4.97903783721, 2641.34127847220],
[0.00000005844, 2.95364118152, 490.33408917940],
[0.00000004943, 5.37597740579, 721.64941953020],
[0.00000005062, 4.84282906467, 31.01948863700],
[0.00000005163, 5.07410777073, 67.66805156650],
[0.00000004739, 6.10248862834, 106.27416795630],
[0.00000004879, 0.07095292379, 78.71375183040],
[0.00000004854, 5.63875661096, 1.69692102940],
[0.00000005629, 3.73871604865, 530.21222995640],
[0.00000004471, 4.49152882547, 505.31194270640],
[0.00000004313, 4.79369370451, 535.10759106600],
[0.00000004280, 0.54783823710, 1.43628859850],
[0.00000004453, 0.50551854591, 524.06189080210],
[0.00000004936, 4.82992988255, 422.66603761290],
[0.00000004701, 3.41634869046, 3060.82592234740],
[0.00000004261, 2.67044686458, 561.93429400900],
[0.00000004156, 4.00660658688, 99.91138048090],
[0.00000004561, 2.29650164054, 3163.91869656600],
[0.00000004414, 5.67224020329, 1464.63948006280],
[0.00000005345, 0.31513851830, 1289.94650101460],
[0.00000005269, 3.89116469022, 191.95845443560],
[0.00000003855, 4.28942301453, 1994.33044515740],
[0.00000004210, 5.32763589447, 2538.24850425360],
[0.00000003949, 4.56507101172, 1382.88734684660],
[0.00000003885, 1.56778786810, 647.01083331480],
[0.00000004227, 5.51697599030, 5223.69391980220],
[0.00000004129, 2.81119457666, 416.30325013750],
[0.00000003663, 4.35187510477, 2737.32050569000],
[0.00000003566, 5.48243943375, 750.10360753340],
[0.00000004330, 0.84941756640, 531.17543780290],
[0.00000004093, 0.19980340452, 525.02509864860],
[0.00000004022, 1.92293311337, 1512.80682400820],
[0.00000003400, 6.00302355875, 1.22384027740],
[0.00000003496, 0.31252921473, 597.35901666110],
[0.00000003299, 4.27596694481, 526.77020378780],
[0.00000003226, 2.90455264496, 963.40270297140],
[0.00000003150, 3.81061764181, 280.96714700450],
[0.00000004129, 4.74946631331, 0.89377187730],
[0.00000003840, 1.91064405186, 378.64329525170],
[0.00000003057, 1.65589659685, 528.94020556920],
[0.00000003011, 1.59276337369, 224.34479570190],
[0.00000003196, 5.86588452873, 4.14460158420],
[0.00000003628, 0.07930225897, 558.00214074590],
[0.00000002932, 0.41424445089, 7.86430652620],
[0.00000003316, 2.70211697795, 532.61172640140],
[0.00000002925, 4.47580363425, 533.88375078860],
[0.00000003690, 0.39897023849, 685.47393735270],
[0.00000003223, 2.45833032883, 960.22130923370],
[0.00000003059, 5.32616140812, 530.44172462000],
[0.00000003383, 4.42170370028, 312.45971639350],
[0.00000003320, 2.71417812514, 495.75071515080],
[0.00000002697, 5.23146633437, 739.80866679490],
[0.00000003590, 2.30999595873, 908.33426034630],
[0.00000003677, 5.07337955976, 73.29712585900],
[0.00000002618, 3.09118499149, 3267.01147078460],
[0.00000002796, 2.98942316119, 483.22054217860],
[0.00000003398, 3.29598270278, 911.30320576290],
[0.00000003352, 1.44391979336, 593.42686339800],
[0.00000002563, 3.35080110279, 2207.62954059540],
[0.00000002553, 0.36892288645, 1048.33622992530],
[0.00000002620, 3.82769874340, 520.12973753900],
[0.00000003356, 1.08315053878, 46.47042291600],
[0.00000003035, 5.52230028113, 618.55664531160],
[0.00000003397, 3.83084746522, 210.11770170030],
[0.00000002497, 0.47917884538, 945.24345570670],
[0.00000002341, 5.87941292649, 2751.54759969160],
[0.00000002656, 0.49713061045, 1057.89745748090],
[0.00000002581, 0.03759881914, 1.64453140270],
[0.00000002900, 2.50019054587, 525.49817940060],
[0.00000003153, 2.30900986177, 457.61767951300],
[0.00000002201, 3.94367109739, 31.49256938900],
[0.00000002381, 6.19252134885, 327.43756992050],
[0.00000002458, 0.65614291954, 9153.90361602180],
[0.00000002111, 5.61905648764, 16.46232623530],
[0.00000002130, 3.75880734109, 724.83081326790],
[0.00000002406, 2.29315649755, 195.13984817330],
[0.00000002166, 5.43262641046, 534.35683154060],
[0.00000002057, 1.49875151278, 551.03160609700],
[0.00000002676, 5.06374981112, 456.39383923560],
[0.00000002078, 5.28920097886, 76.26607127560],
[0.00000002261, 5.38117230692, 1781.03134971940],
[0.00000002356, 0.67392574097, 227.52618943960],
[0.00000002240, 3.18006978517, 3377.21779200400],
[0.00000002183, 3.08384250950, 524.27433912320],
[0.00000002119, 2.70107659927, 387.24131496080],
[0.00000002056, 4.82779196994, 2957.73314812880],
[0.00000002116, 6.20263841494, 209.36694217490],
[0.00000002712, 3.18157754631, 1474.67378837040],
[0.00000002127, 1.24424012514, 539.98590583310],
[0.00000002424, 3.57595925853, 953.10776223290],
[0.00000001947, 1.94468082546, 529.53090640020],
[0.00000001896, 4.01406242800, 2310.72231481400],
[0.00000001935, 4.10051493950, 3053.71237534660],
[0.00000002056, 6.27074148550, 245.54242435240],
[0.00000002108, 3.22886474225, 252.65597135320],
[0.00000002596, 2.77467278614, 177.87437278590],
[0.00000001919, 3.14834694111, 381.61224066830],
[0.00000002217, 1.92368906925, 535.91074021810],
[0.00000001947, 5.03751780002, 529.85102378900],
[0.00000002025, 4.82814272957, 17.26547538740],
[0.00000001945, 2.10611582568, 3480.31056622260],
[0.00000001899, 0.05104263891, 560.71045373160],
[0.00000002221, 0.58365090630, 3178.14579056760],
[0.00000002271, 1.67360565619, 731.94436026870],
[0.00000001706, 5.40277333462, 20.44686912510],
[0.00000002295, 4.20863103004, 1038.04128918680],
[0.00000002218, 3.65982280555, 282.45161971280],
[0.00000002181, 4.87369503022, 535.32003938710],
[0.00000001745, 1.34021867874, 25.12978191360],
[0.00000001601, 3.92730015840, 17.52610781830],
[0.00000001651, 0.63598292839, 17.40848773930],
[0.00000001826, 0.31592311031, 124.43341522100],
[0.00000002041, 0.15617294873, 598.84348936940],
[0.00000001494, 3.81418025130, 319.57326339430],
[0.00000001551, 5.25201528605, 437.64389113990],
[0.00000001852, 2.36130812462, 37.87240320690],
[0.00000001466, 1.72926380881, 59.80374504030],
[0.00000001417, 5.82273267086, 81.75213321620],
[0.00000001430, 1.17528806260, 440.82528487760],
[0.00000001906, 4.06896022692, 1819.63746610920],
[0.00000001397, 0.26383366743, 50.40257617910],
[0.00000001756, 2.32977483716, 938.12990870590],
[0.00000001487, 2.24866746540, 10.03430830760],
[0.00000001368, 3.56691602771, 1514.29129671650],
[0.00000001400, 4.84502200703, 295.05122865420],
[0.00000001344, 2.20177702122, 529.90341341570],
[0.00000001464, 1.42648716568, 1158.54255114470],
[0.00000001341, 1.15693423225, 2435.15573003500],
[0.00000001786, 5.44716330146, 2854.64037391020],
[0.00000001677, 6.22875777048, 833.55266177900],
[0.00000001471, 4.80574535807, 696.51963761660],
[0.00000001436, 1.45810957330, 537.76771994190],
[0.00000001657, 0.02890651793, 138.51749687070],
[0.00000001300, 3.14074420421, 547.85021235930],
[0.00000001343, 6.14827138025, 988.53248488500],
[0.00000001344, 4.78042160426, 529.47851677350],
[0.00000001234, 2.83294330979, 3583.40334044120],
[0.00000001651, 2.12056447005, 1061.82961074400],
[0.00000001479, 0.24646493075, 1593.00504854690],
[0.00000001413, 3.07444632745, 6283.07584999140],
[0.00000001246, 5.94882321661, 1056.93424963440],
[0.00000001225, 1.95642397635, 1969.20066324380],
[0.00000001388, 2.87749576073, 1023.95720753710],
[0.00000001263, 3.46181945031, 40.84134862350],
[0.00000001325, 4.15429781246, 916.93228005540],
[0.00000001477, 5.26691818477, 810.65811209910],
[0.00000001165, 4.65528125418, 944.98282327580],
[0.00000001137, 2.48561382158, 2.00573757010],
[0.00000001118, 3.80747957482, 7.00167241620],
[0.00000001138, 5.11611532241, 885.43971066640],
[0.00000001131, 1.54599459004, 775.23338944700],
[0.00000001477, 4.69742954455, 630.33605875840],
[0.00000001252, 1.34316620527, 739.05790726950],
[0.00000001273, 5.19070939905, 2097.42321937600],
[0.00000001446, 5.54999644374, 43.28902917830],
[0.00000001344, 4.75897665313, 1166.40685767090],
[0.00000001101, 4.56997613488, 3274.12501778540],
[0.00000001376, 3.60998729004, 415.29185818120],
[0.00000001437, 6.22410093972, 155.78297225810],
[0.00000001167, 4.09497264272, 203.00415469950],
[0.00000001237, 4.41132627005, 292.01284726840],
[0.00000001077, 2.57045229823, 25.27279426550],
[0.00000001341, 0.49262296655, 635.23141986800],
[0.00000001209, 3.36289125536, 521.61421024730],
[0.00000001030, 1.81822316284, 465.95506679120],
[0.00000001002, 3.21720955284, 2524.02141025200],
[0.00000001338, 1.26054917773, 902.70518605380],
[0.00000001037, 3.87858871885, 3370.10424500320],
[0.00000001224, 0.09219976028, 824.74219374880],
[0.00000001255, 3.04675952762, 447.79581952650],
[0.00000000991, 4.16587903812, 632.83192342300],
[0.00000000975, 3.80216680539, 2627.11418447060],
[0.00000001061, 5.60184374277, 732.69511979410],
[0.00000001049, 2.94931080683, 3693.60966166060],
[0.00000000984, 0.98260254313, 632.73555520340],
[0.00000001050, 2.20935815967, 7.22542158540],
[0.00000000996, 5.41921062583, 1059.43011429900],
[0.00000000961, 0.87315283361, 544.66881862160],
[0.00000001175, 3.09093466406, 1894.41906467650],
[0.00000001049, 5.81616384906, 26.82670294300],
[0.00000001161, 0.01274801567, 850.01498801430],
[0.00000001109, 3.63294273717, 306.83064210100],
[0.00000001077, 0.95716576092, 608.40471692500],
[0.00000001288, 4.23019288942, 1215.16490244730],
[0.00000001060, 3.85856787901, 631.82053146670],
[0.00000001251, 6.15889818604, 462.02291352810],
[0.00000001165, 3.50653563773, 8.59801970910],
[0.00000000933, 4.62559759882, 1049.08698945070],
[0.00000001035, 1.30805283339, 633.74694715970],
[0.00000001238, 2.21195391602, 25558.21217647960],
[0.00000001240, 2.27960685992, 6.90109867970],
[0.00000000942, 4.14526324371, 945.99421523210],
[0.00000000927, 6.10893117637, 514.71311156760],
[0.00000000914, 6.17656044376, 952.35700270750],
[0.00000000893, 4.27448748055, 0.63313944640],
[0.00000001045, 1.64682770236, 565.11568774670],
[0.00000000903, 1.94250156640, 3796.70243587920],
[0.00000001162, 5.51229668479, 2.96894541660],
[0.00000000901, 3.03568112112, 460.53844081980],
[0.00000000903, 2.24012822393, 523.54062594030],
[0.00000001060, 5.28027224466, 3171.03224356680],
[0.00000001064, 0.99330150801, 320.32402291970],
[0.00000000970, 4.56607888439, 429.04587143080],
[0.00000001071, 4.33203090957, 610.69233878540],
[0.00000000865, 0.21831429230, 1098.73880610440],
[0.00000000865, 2.82123742108, 1060.34513803570],
[0.00000000882, 4.80076824948, 384.05992122310],
[0.00000000959, 5.45468005818, 451.94042111070],
[0.00000001042, 5.79270325150, 303.86169668440],
[0.00000000784, 1.85150700827, 313.21047591890],
[0.00000001083, 1.40526460812, 72.07328558160],
[0.00000000782, 3.03559242565, 5.84152261360],
[0.00000000854, 1.22236205478, 611.44309831080],
[0.00000000996, 2.22139794743, 1059.33374607940],
[0.00000000719, 4.92550252164, 421.93232443000],
[0.00000000953, 3.98347050083, 836.52160719560],
[0.00000000822, 4.49679856387, 10213.28554621100],
[0.00000000707, 2.16473400319, 2228.97018159780],
[0.00000000715, 4.62515255534, 385.54439393140],
[0.00000000737, 4.63776694324, 1134.16352875650],
[0.00000000730, 1.87179326186, 153.49535039770],
[0.00000000709, 2.93132115910, 417.03696332040],
[0.00000000926, 1.77006317007, 2332.06295581640],
[0.00000000864, 3.03246275970, 1041.22268292450],
[0.00000000708, 6.01601101389, 395.10562148700],
[0.00000000935, 6.01864676296, 173.94221952280],
[0.00000000695, 1.39408383356, 432.01481684740],
[0.00000000687, 3.06548397586, 529.95159752550],
[0.00000000677, 3.58357527210, 244.31858407500],
[0.00000000850, 5.46114025921, 41.05379694460],
[0.00000000817, 4.65315342412, 535.84130424890],
[0.00000000652, 0.44173759183, 1201.83158032300],
[0.00000000711, 0.96283289310, 373.01422095920],
[0.00000000665, 1.03244633471, 623.22251175760],
[0.00000000643, 5.05335060049, 522.62560220360],
[0.00000000639, 4.22718483639, 25.86349509650],
[0.00000000718, 5.07576900710, 1058.41872234270],
[0.00000000664, 2.43728454444, 1585.14074202070],
[0.00000000833, 1.49468440213, 563.63121503840],
[0.00000000760, 4.34849823663, 100.64509366380],
[0.00000000633, 4.31796718640, 3590.51688744200],
[0.00000000629, 6.23431126402, 679.25416222920],
[0.00000000617, 2.68075016456, 3899.79521009780],
[0.00000000646, 2.88581188015, 13.49338081870],
[0.00000000768, 3.18498076120, 1151.42900414390],
[0.00000000731, 5.86653168561, 501.37978944330],
[0.00000000652, 0.82865771780, 2015.67108615980],
[0.00000000796, 5.36663489938, 420.96911658350],
[0.00000000647, 4.74965662438, 567.82400073240],
[0.00000000845, 1.69406147722, 1744.85586754190],
[0.00000000802, 5.79824707751, 981.63138620530],
[0.00000000764, 5.05232933368, 827.92358748650],
[0.00000000604, 5.11265182908, 1159.29331067010],
[0.00000000682, 3.68248136835, 2281.23049651060],
[0.00000000740, 0.74512356954, 1261.63532536330],
[0.00000000666, 2.06624389616, 27.08733537390],
[0.00000000652, 4.92932795958, 2413.81508903260],
[0.00000000559, 0.17558868481, 63.73589830340],
[0.00000000577, 3.82752312276, 1550.93985964600],
[0.00000000727, 1.05835550856, 490.07345674850],
[0.00000000574, 3.61492119092, 3686.49611465980],
[0.00000000732, 5.93179840659, 42.53826965290],
[0.00000000606, 2.71411884300, 1173.52040467170],
[0.00000000633, 4.21720828607, 166.82867252200],
[0.00000000687, 3.91671464962, 529.43033266370],
[0.00000000570, 2.73551750122, 4010.00153131720],
[0.00000000552, 2.36967119362, 1603.29998928540],
[0.00000000600, 1.82659364395, 522.52923398400],
[0.00000000558, 5.09099246601, 1354.43315884340],
[0.00000000519, 6.11952999304, 366.79444583570],
[0.00000000719, 0.85722557905, 362.86229257260],
[0.00000000518, 2.03954064144, 418.52143602870],
[0.00000000515, 3.51750445111, 528.41894070740],
[0.00000000515, 3.47930063838, 103.14095832840],
[0.00000000550, 5.77676837730, 420.44785172170],
[0.00000000702, 3.67952126446, 1279.79457262800],
[0.00000000550, 0.61451088395, 104.05598206510],
[0.00000000495, 2.41738205536, 179.35884549420],
[0.00000000513, 0.29823688044, 103.04459010880],
[0.00000000537, 5.47946238724, 771.30123618390],
[0.00000000507, 3.08777345288, 1357.61455258110],
[0.00000000495, 4.95362659160, 536.85269620520],
[0.00000000681, 4.56294416261, 112.65400177420],
[0.00000000500, 3.15631977489, 1070.42763045310],
[0.00000000484, 0.79038835602, 28.45418800320],
[0.00000000529, 5.46978501034, 419.43645976540],
[0.00000000597, 4.98058295172, 1251.34038462480],
[0.00000000492, 3.96066546484, 1269.49963188950],
[0.00000000482, 3.60167662490, 2943.50605412720],
[0.00000000630, 6.16496640092, 105.54045477340],
[0.00000000480, 0.86786400621, 35.21227433100],
[0.00000000516, 5.97528782923, 3067.93946934820],
[0.00000000586, 5.48467997697, 56.62235130260],
[0.00000000502, 1.43671788959, 469.88722005430],
[0.00000000473, 2.28007170041, 2042.49778910280],
[0.00000000565, 1.90952569252, 107.28555991260],
[0.00000000452, 3.13938145287, 934.94851496820],
[0.00000000605, 1.65413715574, 761.74000862830],
[0.00000000443, 5.46282223686, 135.33610313300],
[0.00000000580, 2.06327501551, 493.04240216510],
[0.00000000540, 1.73777995970, 536.75632798560],
[0.00000000432, 0.27167052107, 93.53154666300],
[0.00000000515, 3.46469417437, 530.96298948180],
[0.00000000440, 5.28884782489, 497.44763618020],
[0.00000000487, 5.78767525063, 12036.46073488820],
[0.00000000452, 2.57855172248, 1254.52177836250],
[0.00000000427, 3.21032629463, 2840.41327990860],
[0.00000000414, 1.54298025443, 115.62294719080],
[0.00000000424, 0.12699448931, 1268.74887236410],
[0.00000000411, 3.12424023238, 536.28324723360],
[0.00000000452, 1.00194596383, 113.38771495710],
[0.00000000419, 0.81834479225, 1165.65609814550],
[0.00000000490, 4.72785081986, 277.03499374140],
[0.00000000434, 0.36146539146, 1304.92435454160],
[0.00000000401, 5.70326543719, 1127.04998175570],
[0.00000000461, 3.26462894820, 102.12956637210],
[0.00000000533, 2.54951615753, 141.22580985640],
[0.00000000413, 4.38801694479, 6151.53388830500],
[0.00000000415, 1.68861617902, 391.17346822390],
[0.00000000385, 1.69092319074, 4113.09430553580],
[0.00000000450, 5.49339192735, 602.98809095360],
[0.00000000499, 3.80738617353, 81.00137369080],
[0.00000000454, 0.10952919733, 600.54041039880],
[0.00000000377, 6.25375060718, 913.75088631770],
[0.00000000453, 3.86104865567, 758.77106321170],
[0.00000000401, 4.44475618337, 990.22940591440],
[0.00000000407, 5.13442416563, 3487.42411322340],
[0.00000000435, 3.76103358490, 523.09868295560],
[0.00000000425, 3.22287851959, 2655.56837247380],
[0.00000000365, 5.16456645463, 4694.00295470760],
[0.00000000454, 1.63325197950, 976.00231191280],
[0.00000000406, 2.72102389267, 1438.02522544090],
[0.00000000349, 3.59598366422, 1058.86066532740],
[0.00000000354, 0.62136331420, 498.67147645760],
[0.00000000383, 5.09229089574, 539.25219265020],
[0.00000000380, 3.92653231573, 561.18353448360],
[0.00000000339, 4.12175871949, 3906.90875709860],
[0.00000000458, 3.42556794767, 121.25202148330],
[0.00000000427, 3.61285264910, 860.30992875280],
[0.00000000424, 4.72757252331, 1366.21257229020],
[0.00000000328, 4.55286002816, 1696.09782276550],
[0.00000000324, 4.23685005210, 642.34496686880],
[0.00000000395, 3.26282558955, 484.44438245600],
[0.00000000330, 6.05223507989, 215.74677599280],
[0.00000000318, 2.02072800070, 2964.84669512960],
[0.00000000417, 0.20173093597, 842.90144101350],
[0.00000000408, 0.45800247268, 1578.02719501990],
[0.00000000342, 6.15347077985, 1371.84164658270],
[0.00000000310, 1.97259286255, 754.03576079650],
[0.00000000340, 2.77813018312, 3.52311834900],
[0.00000000333, 2.91352254678, 576.16138801060],
[0.00000000324, 0.32544817254, 586.31331639720],
[0.00000000302, 2.08708848849, 526.98265210890],
[0.00000000363, 4.70567113230, 2730.20695868920],
[0.00000000300, 0.94464473068, 1432.39615114840],
[0.00000000352, 5.75013621801, 806.72595883600],
[0.00000000296, 3.97807312133, 2043.98226181110],
[0.00000000295, 2.35257797599, 4216.18707975440],
[0.00000000309, 2.49768755925, 4326.39340097380],
[0.00000000306, 3.35876843257, 2424.11002977110],
[0.00000000300, 4.94288858368, 1379.70595310890],
[0.00000000336, 4.49193455535, 1585.89150154610],
[0.00000000402, 2.04684001796, 842.15068148810],
[0.00000000312, 4.59043534747, 188.92007304980],
[0.00000000346, 5.19792097706, 523.47118997110],
[0.00000000380, 1.67961600066, 36.64856292950],
[0.00000000338, 1.32014513725, 148.07872442630],
[0.00000000391, 4.82224015188, 1012.91150727320],
[0.00000000285, 3.43655052437, 1053.96530421780],
[0.00000000332, 2.02575636311, 1091.62525910360],
[0.00000000282, 5.78865321890, 1064.04779663520],
[0.00000000282, 0.39153852422, 207.67002114550],
[0.00000000280, 3.80196391678, 298.23262239190],
[0.00000000387, 6.26819309990, 1141.13406340540],
[0.00000000349, 4.09121908199, 1059.90319505100],
[0.00000000320, 0.39871942000, 2122.69601364150],
[0.00000000327, 4.76503823073, 134.58534360760],
[0.00000000283, 3.90409016441, 127.47179660680],
[0.00000000301, 4.30291951219, 299.12639426920],
[0.00000000322, 2.48251052680, 1065.60170531270],
[0.00000000297, 2.40814103509, 1591.52057583860],
[0.00000000286, 5.85849626574, 172.24529849340],
[0.00000000285, 4.55845472479, 1446.62324515000],
[0.00000000270, 4.08342186112, 1578.77795454530],
[0.00000000362, 1.06148806683, 181.80652604900],
[0.00000000335, 4.51094500655, 2349.32843120380],
[0.00000000347, 0.62281394535, 1542.60247236780],
[0.00000000275, 3.38473403113, 4002.88798431640],
[0.00000000255, 1.52357936497, 1688.23351623930],
[0.00000000276, 4.32192160071, 1912.57831194120],
[0.00000000253, 2.40482338279, 97.67614824720],
[0.00000000248, 4.45058246237, 1688.98427576470],
[0.00000000300, 3.07435583442, 1902.28337120270],
[0.00000000257, 4.79180478086, 1670.82502850000],
[0.00000000319, 1.34244222683, 1288.46202830630],
[0.00000000245, 4.01852686769, 1567.73225428140],
[0.00000000278, 0.25406312148, 874.39401040250],
[0.00000000324, 5.57824969423, 1670.07426897460],
[0.00000000300, 4.67161812947, 1329.30337692980],
[0.00000000241, 0.01789818312, 1586.62521472900],
[0.00000000295, 5.86996114913, 2804.23779773110],
[0.00000000317, 3.17967272487, 1020.02505427400],
[0.00000000238, 4.97765946754, 351.81659230870],
[0.00000000302, 1.20236375616, 232.04904353370],
[0.00000000301, 5.53432687957, 2274.54683263650],
[0.00000000286, 2.41008592059, 2545.36205125440],
[0.00000000294, 2.01783542485, 313.94418910180],
[0.00000000292, 2.12690999284, 1592.25428902150],
[0.00000000250, 2.31712163679, 632.26247445140],
[0.00000000238, 5.06557054569, 3803.81598288000],
[0.00000000226, 0.05916712753, 1518.22344997960],
[0.00000000235, 0.16574304942, 137.03302416240],
[0.00000000298, 2.99720233431, 1467.82087380050],
[0.00000000286, 5.08357076653, 774.00954916960],
[0.00000000246, 2.81685822336, 633.30500417500],
[0.00000000269, 4.93023426152, 151.04766984290],
[0.00000000228, 6.13118739321, 3281.23856478620],
[0.00000000228, 1.22066024988, 700.45179087970],
[0.00000000239, 0.71695698501, 1276.61317889030],
[0.00000000289, 6.08263862565, 3384.33133900480],
[0.00000000218, 2.90308501961, 85.82729883120],
[0.00000000283, 6.28058228271, 71.81265315070],
[0.00000000271, 6.01605074549, 170.76082578510],
[0.00000000221, 0.99914179141, 1053.75285589670],
[0.00000000218, 1.50681393471, 1087.69310584050],
[0.00000000223, 3.39126063354, 3259.89792378380],
[0.00000000229, 1.19373202707, 1060.86640289750],
[0.00000000264, 3.93467945263, 1363.24362687360],
[0.00000000228, 5.04188376116, 1064.79855616060],
[0.00000000295, 2.15253086390, 6386.16862421000],
[0.00000000214, 3.85961180377, 4223.30062675520],
[0.00000000218, 0.79681703388, 1909.39691820350],
[0.00000000212, 4.11706418218, 269.92144674060],
[0.00000000264, 5.81676406517, 77.96299230500],
[0.00000000256, 5.65978708108, 799.61241183520],
[0.00000000242, 6.25078283449, 1621.31622419820],
[0.00000000235, 2.20668997852, 1570.91364801910],
[0.00000000212, 2.88214546012, 1674.00642223770],
[0.00000000206, 1.59586787037, 4429.48617519240],
[0.00000000208, 2.31366614282, 878.32616366560],
[0.00000000213, 0.30373338388, 8624.21265092720],
[0.00000000223, 4.88419887133, 1035.00290780100],
[0.00000000279, 3.65173543621, 84.93352695390],
[0.00000000210, 4.08825553401, 203.73786788240],
[0.00000000214, 4.63498396475, 812.14258480740],
[0.00000000258, 1.73501688450, 1887.30551767570],
[0.00000000210, 4.51798082710, 1262.38608488870],
[0.00000000252, 5.69246905091, 104.57724692690],
[0.00000000205, 4.62946016431, 1056.46116888240],
[0.00000000263, 3.04951219565, 1493.09366806600],
[0.00000000222, 5.54424082649, 5216.58037280140],
[0.00000000244, 0.91026645686, 3707.83675566220],
[0.00000000204, 0.90117975859, 1408.01712876020],
[0.00000000225, 1.23997048012, 3340.61242669980],
[0.00000000258, 2.35906183505, 2861.75392091100],
[0.00000000267, 3.27705002283, 5120.60114558360],
[0.00000000214, 0.66988779149, 9146.79006902100],
[0.00000000235, 4.93761209111, 1443.44185141230],
[0.00000000194, 1.60798828275, 102.57150935680],
[0.00000000215, 0.97603524747, 479.28838891550],
[0.00000000205, 5.23642605904, 4649.89881763120],
[0.00000000257, 4.70227260707, 9050.81084180320],
[0.00000000228, 6.23410921116, 64.95973858080],
[0.00000000180, 4.21309134581, 143.93412284210],
[0.00000000180, 4.82870451226, 1063.57471588320],
[0.00000000180, 5.06126965624, 52.69019803950],
[0.00000000226, 0.55334952097, 554.06998748280],
[0.00000000209, 5.67975843693, 48.75804477640],
[0.00000000186, 3.66368928017, 108.72184851110],
[0.00000000190, 2.00852986549, 1058.63117066380],
[0.00000000183, 3.17358464220, 140.96517742550],
[0.00000000198, 5.49816579454, 4333.50694797460],
[0.00000000240, 6.06602357868, 1821.12193881750],
[0.00000000172, 3.04802064781, 54.33472944220],
[0.00000000170, 4.66520291204, 1372.59240610810],
[0.00000000173, 4.72884056307, 77204.32749453338],
[0.00000000174, 0.85370421252, 1587.58842257550],
[0.00000000215, 0.68219980704, 1054.71606374320],
[0.00000000170, 1.52204803308, 5591.96087960020],
[0.00000000200, 1.60275092073, 6681.22485339960],
[0.00000000193, 2.13003479280, 103.61403908040],
[0.00000000231, 4.69962389031, 1966.23171782720],
[0.00000000179, 5.57395905447, 1457.52593306200],
[0.00000000205, 3.65507571128, 906.84978763800],
[0.00000000181, 4.52272934666, 24498.83024629040],
[0.00000000223, 0.11650319998, 67.88049988760],
[0.00000000172, 5.68083885227, 1884.12412393800],
[0.00000000219, 0.60964963735, 2729.45619916380],
[0.00000000164, 1.06675279755, 594.65070367540],
[0.00000000176, 2.36848603898, 977.48678462110],
[0.00000000170, 2.43036684800, 4532.57894941100],
[0.00000000191, 3.64255924842, 1440.99417085750],
[0.00000000207, 0.49276008455, 71.60020482960],
[0.00000000157, 4.26888100582, 5069.38346150640],
[0.00000000157, 5.14847227422, 451.72797278960],
[0.00000000158, 5.00063628575, 650.94298657790],
[0.00000000159, 5.37530499642, 20426.57109242200],
[0.00000000218, 0.27875408082, 175.16605980020],
[0.00000000155, 0.83696849428, 1474.93442080130],
[0.00000000154, 2.62839957291, 683.18631549230],
[0.00000000171, 1.79511736017, 1123.11782849260],
[0.00000000188, 5.24747110812, 25565.32572348040],
[0.00000000168, 4.14907553818, 946.72792841500],
[0.00000000203, 2.83699715530, 1489.91227432830],
[0.00000000173, 4.34546063838, 3046.59882834580],
[0.00000000190, 5.67865607835, 1060.13268971460],
[0.00000000201, 2.38524182920, 419.53282798500],
[0.00000000152, 5.89088685790, 208.63322899200],
[0.00000000206, 4.46933127349, 2654.67460059650],
[0.00000000156, 2.37819796438, 2758.66114669240],
[0.00000000203, 0.70565514297, 498.19839570560],
[0.00000000205, 3.05468636546, 1062.30269149600],
[0.00000000174, 3.50824761708, 2004.36475346500],
[0.00000000148, 4.73961194393, 1799.19059698410],
[0.00000000188, 3.62315953725, 3156.80514956520],
[0.00000000183, 2.35011338194, 25551.09862947879],
[0.00000000162, 1.58053710589, 628.59095361920],
[0.00000000162, 3.99983876824, 1482.79872732750],
[0.00000000181, 2.85489861839, 1055.18914449520],
[0.00000000151, 3.43198157222, 629.86297800640],
[0.00000000157, 3.15195826490, 1025.44168024540],
[0.00000000194, 5.13049187783, 1818.15299340090],
[0.00000000193, 1.92287052164, 1140.38330388000],
[0.00000000137, 4.22335221970, 1049.82070263360],
[0.00000000167, 2.85163087563, 5746.27133789600],
[0.00000000167, 5.73970282991, 5760.49843189760],
[0.00000000138, 2.23519776527, 1176.70179840940],
[0.00000000151, 4.89507270899, 532.39927808030],
[0.00000000147, 2.65931838448, 987.30864460760],
[0.00000000135, 0.12836417770, 991.71387862270],
[0.00000000166, 3.12682515439, 580.09354127370],
[0.00000000118, 5.98810576300, 531.38788612400],
[0.00000000135, 5.26601313643, 1065.01100448170],
[0.00000000138, 3.18511244397, 707.56533788050],
[0.00000000122, 1.34377059565, 446.31134681820],
[0.00000000120, 2.29717714347, 1059.22187149480],
[0.00000000121, 0.58145552537, 5621.84292321040],
[0.00000000103, 4.75645235023, 1226.21060271120],
[0.00000000104, 6.08481630139, 528.25467649610],
[0.00000000119, 1.06475523307, 527.99404406520],
[0.00000000104, 0.89730746841, 531.12725369310],
[0.00000000120, 5.39001411803, 1059.54198888360],
[0.00000000104, 0.44849170648, 1128.53445446400],
[0.00000000117, 5.42449214711, 986.08480433020],
[0.00000000101, 5.09893554462, 530.58473697190],
[0.00000000102, 0.26948040239, 450.97721326420],
[0.00000000107, 1.58724086516, 1069.67687092770],
[0.00000000086, 2.28711702506, 2498.89162833840],
[0.00000000101, 1.88318822518, 528.79719321730],
[0.00000000086, 1.37568728263, 970.51624997220],
[0.00000000083, 0.06930748288, 530.91480537200],
[0.00000000085, 3.22094000094, 1553.64817263170],
[0.00000000083, 0.62963097974, 528.46712481720],
[0.00000000083, 4.16314675511, 849.26422848890],
[0.00000000079, 3.46688102340, 1077.54117745390],
[0.00000000097, 0.87886975916, 9690.70812811720],
[0.00000000097, 4.27398311206, 9676.48103411560],
[0.00000000101, 0.29639798579, 857.12853501510],
[0.00000000083, 2.55427333923, 1059.59437851030],
[0.00000000078, 0.06461496210, 521.82665856840],
[0.00000000078, 0.76677000862, 525.54636351040],
[0.00000000096, 0.33631035749, 1090.40141882620],
[0.00000000098, 1.42815294497, 757.21715453420],
[0.00000000077, 0.85066773729, 537.55527162080],
[0.00000000084, 5.04765104413, 1160.02702385300],
[0.00000000076, 3.62264327413, 782.34693644780],
[0.00000000085, 1.86831145784, 25028.52121138500],
[0.00000000079, 2.90602202890, 2114.83170711530],
], [
[529.93480757497, 0.00000000000, 0.00000000000],
[0.00489741194, 4.22066689928, 529.69096509460],
[0.00228918538, 6.02647464016, 7.11354700080],
[0.00027655380, 4.57265956824, 1059.38193018920],
[0.00020720943, 5.45938936295, 522.57741809380],
[0.00012105732, 0.16985765041, 536.80451209540],
[0.00006068051, 4.42419502005, 103.09277421860],
[0.00005433924, 3.98478382565, 419.48464387520],
[0.00004237795, 5.89009351271, 14.22709400160],
[0.00002211854, 5.26771446618, 206.18554843720],
[0.00001295769, 5.55132765087, 3.18139373770],
[0.00001745919, 4.92669378486, 1589.07289528380],
[0.00001163411, 0.51450895328, 3.93215326310],
[0.00001007216, 0.46478398551, 735.87651353180],
[0.00001173129, 5.85647304350, 1052.26838318840],
[0.00000847678, 5.75805850450, 110.20632121940],
[0.00000827329, 4.80312015734, 213.29909543800],
[0.00001003574, 3.15040301822, 426.59819087600],
[0.00001098735, 5.30704981594, 515.46387109300],
[0.00000816397, 0.58643054886, 1066.49547719000],
[0.00000725447, 5.51827471473, 639.89728631400],
[0.00000567845, 5.98867049451, 625.67019231240],
[0.00000474181, 4.13245269168, 412.37109687440],
[0.00000412930, 5.73652891261, 95.97922721780],
[0.00000335817, 3.73248749046, 1162.47470440780],
[0.00000345249, 4.24159565410, 632.78373931320],
[0.00000234066, 6.24302226646, 309.27832265580],
[0.00000194784, 2.21879010911, 323.50541665740],
[0.00000234340, 4.03469970332, 949.17560896980],
[0.00000183938, 6.27963588822, 543.91805909620],
[0.00000198525, 1.50458442825, 838.96928775040],
[0.00000186899, 6.08620565908, 742.99006053260],
[0.00000171380, 5.41655983845, 199.07200143640],
[0.00000130771, 0.62643377351, 728.76296653100],
[0.00000107575, 4.49282760117, 956.28915597060],
[0.00000115393, 0.68019050174, 846.08283475120],
[0.00000115047, 5.28641699144, 2118.76386037840],
[0.00000066824, 5.73365126533, 21.34064100240],
[0.00000069618, 5.97263450278, 532.87235883230],
[0.00000064850, 6.08803490288, 1581.95934828300],
[0.00000079686, 5.82412400273, 1045.15483618760],
[0.00000057939, 0.99453087342, 1596.18644228460],
[0.00000065635, 0.12924191430, 526.50957135690],
[0.00000058509, 0.58626971028, 1155.36115740700],
[0.00000056600, 1.41198438841, 533.62311835770],
[0.00000071643, 5.34162650321, 942.06206196900],
[0.00000057368, 5.96851304799, 1169.58825140860],
[0.00000054935, 5.42806383723, 10.29494073850],
[0.00000052016, 0.22981299129, 1368.66025284500],
[0.00000052309, 5.72661448388, 117.31986822020],
[0.00000050418, 6.08075147811, 525.75881183150],
[0.00000047418, 3.62611843241, 1478.86657406440],
[0.00000039888, 4.16158013600, 1692.16566950240],
[0.00000046678, 0.51144073175, 1265.56747862640],
[0.00000032827, 5.03596689455, 220.41264243880],
[0.00000033558, 0.09913904872, 302.16477565500],
[0.00000029379, 3.35927241533, 4.66586644600],
[0.00000029307, 0.75907909735, 88.86568021700],
[0.00000032449, 5.37492530697, 508.35032409220],
[0.00000029483, 5.42208897099, 1272.68102562720],
[0.00000021802, 6.15054054070, 1685.05212250160],
[0.00000025195, 1.60723063387, 831.85574074960],
[0.00000021133, 5.86346824200, 1258.45393162560],
[0.00000019747, 2.17205957814, 316.39186965660],
[0.00000017871, 0.82841413516, 433.71173787680],
[0.00000017703, 5.95527049039, 5.41662597140],
[0.00000017230, 2.76395560958, 853.19638175200],
[0.00000017453, 0.70749901224, 1471.75302706360],
[0.00000017508, 0.49799925173, 1375.77379984580],
[0.00000014368, 0.91459831140, 18.15924726470],
[0.00000014107, 0.63031082833, 2.92076130680],
[0.00000011559, 4.30379009964, 405.25754987360],
[0.00000011728, 1.76426582357, 380.12776796000],
[0.00000011054, 5.56735602213, 1574.84580128220],
[0.00000010425, 0.31355034390, 1361.54670584420],
[0.00000009804, 5.90363777277, 519.39602435610],
[0.00000009805, 0.38648727979, 1073.60902419080],
[0.00000009285, 3.21842287530, 1795.25844372100],
[0.00000008864, 0.53776257958, 1788.14489672020],
[0.00000008370, 5.88484552222, 2001.44399215820],
[0.00000008148, 5.10162311410, 1485.98012106520],
[0.00000007658, 5.64890060131, 2648.45482547300],
[0.00000006690, 2.41093459420, 4.19278569400],
[0.00000005840, 4.22347896053, 2008.55753915900],
[0.00000007256, 6.19384525651, 11.04570026390],
[0.00000006266, 1.36137786945, 1148.24761040620],
[0.00000005141, 5.23083932012, 628.85158605010],
[0.00000005140, 2.92955981951, 518.64526483070],
[0.00000004765, 0.16838181862, 629.60234557550],
[0.00000004603, 0.78529559911, 721.64941953020],
[0.00000004575, 6.24794935732, 1677.93857550080],
[0.00000004537, 4.95096707833, 635.96513305090],
[0.00000004518, 2.06523915453, 453.42489381900],
[0.00000004414, 0.15381186059, 1699.27921650320],
[0.00000005593, 5.57489981207, 191.95845443560],
[0.00000005403, 1.46004886198, 330.61896365820],
[0.00000004285, 0.23949868127, 2104.53676637680],
[0.00000004223, 1.44087555881, 2125.87740737920],
[0.00000004101, 6.19274358942, 636.71589257630],
[0.00000004432, 4.35811524051, 423.41679713830],
[0.00000004132, 0.50170694173, 1056.20053645150],
[0.00000004398, 4.14280286969, 511.53171782990],
[0.00000005406, 4.40429493698, 2221.85663459700],
[0.00000004467, 0.08534650684, 1062.56332392690],
[0.00000003569, 5.66540477010, 2317.83586181480],
[0.00000004007, 2.54845549248, 74.78159856730],
[0.00000003515, 0.25495124831, 1055.44977692610],
[0.00000003687, 2.93378008847, 32.24332891440],
[0.00000002883, 5.72793010505, 99.91138048090],
[0.00000002969, 5.50054720569, 107.02492748170],
[0.00000002720, 1.25222590925, 540.73666535850],
[0.00000002808, 3.30714813896, 0.75075952540],
[0.00000002768, 1.61339487804, 1063.31408345230],
[0.00000002666, 4.28662288102, 106.27416795630],
[0.00000002704, 3.03615556153, 422.66603761290],
[0.00000003290, 5.89081682150, 1802.37199072180],
[0.00000002578, 3.60390367979, 750.10360753340],
[0.00000002661, 0.35249312659, 1898.35121793960],
[0.00000002486, 5.28950877719, 1891.23767093880],
[0.00000002936, 1.09052029450, 1464.63948006280],
[0.00000003190, 4.60740643547, 416.30325013750],
[0.00000002390, 6.01779736611, 551.03160609700],
[0.00000002214, 5.24450923180, 621.73803904930],
[0.00000002319, 5.82920300130, 305.34616939270],
[0.00000002089, 5.99310370434, 1994.33044515740],
[0.00000002042, 0.75008788531, 142.44965013380],
[0.00000002121, 0.01537599023, 2420.92863603340],
[0.00000002114, 6.25308371567, 647.01083331480],
[0.00000002020, 4.17560390841, 569.04784100980],
[0.00000002109, 5.18682321403, 227.52618943960],
[0.00000002283, 5.80043809222, 539.98590583310],
[0.00000001977, 3.99197009651, 24.37902238820],
[0.00000001960, 1.35288793079, 963.40270297140],
[0.00000001903, 2.78349628184, 2428.04218303420],
[0.00000001915, 4.22134509685, 2324.94940881560],
[0.00000001971, 5.88715684267, 217.23124870110],
[0.00000001917, 3.03728154374, 1382.88734684660],
[0.00000002026, 3.08606488714, 408.43894361130],
[0.00000001834, 5.61474110217, 430.53034413910],
[0.00000001838, 1.25467410218, 81.75213321620],
[0.00000002460, 4.63268678998, 1905.46476494040],
[0.00000001820, 5.97497926120, 114.13847448250],
[0.00000002043, 4.34047514845, 70.84944530420],
[0.00000001959, 4.03116026306, 92.04707395470],
[0.00000001768, 0.33097462499, 35.42472265210],
[0.00000002334, 5.87042638470, 1038.04128918680],
[0.00000001835, 4.81326127892, 124.43341522100],
[0.00000002269, 1.02549350754, 618.55664531160],
[0.00000001919, 5.01297395549, 99.16062095550],
[0.00000001923, 0.28688549585, 31.01948863700],
[0.00000001878, 5.69299116574, 210.11770170030],
[0.00000001679, 0.25635730278, 295.05122865420],
[0.00000001656, 5.46039280732, 2634.22773147140],
[0.00000001675, 6.15609073315, 643.82943957710],
[0.00000001953, 5.09846435548, 17.40848773930],
[0.00000001539, 2.75316078346, 415.55249061210],
[0.00000001467, 0.54812675158, 458.84151979040],
[0.00000001482, 3.76736278426, 534.35683154060],
[0.00000001446, 3.15802770791, 25.12978191360],
[0.00000001667, 0.26406950755, 835.03713448730],
[0.00000001472, 0.83054329617, 28.31117565130],
[0.00000001655, 0.88908548504, 1781.03134971940],
[0.00000001294, 5.76241191046, 440.82528487760],
[0.00000001348, 2.49823510924, 984.60033162190],
[0.00000001352, 5.10869562455, 149.56319713460],
[0.00000001344, 0.01942249067, 2214.74308759620],
[0.00000001188, 2.24279457878, 31.49256938900],
[0.00000001166, 0.80686346228, 739.80866679490],
[0.00000001322, 4.25691184168, 2538.24850425360],
[0.00000001094, 6.02985819406, 2737.32050569000],
[0.00000001112, 4.38204360670, 561.93429400900],
[0.00000001346, 3.20575848870, 525.02509864860],
[0.00000001056, 5.76507115032, 2310.72231481400],
[0.00000001159, 0.46189564970, 67.66805156650],
[0.00000001027, 0.20709586018, 7.86430652620],
[0.00000001143, 5.56626418636, 46.47042291600],
[0.00000001012, 0.54293005597, 532.13864564940],
[0.00000000978, 5.13939194101, 2207.62954059540],
[0.00000000993, 2.03698185233, 319.57326339430],
[0.00000001035, 2.90231353535, 611.44309831080],
[0.00000001021, 4.75651217048, 527.24328453980],
[0.00000001308, 1.78809336431, 824.74219374880],
[0.00000000964, 2.82269601958, 2111.65031337760],
[0.00000000896, 2.54505998806, 2744.43405269080],
[0.00000000890, 5.41036782817, 28.45418800320],
[0.00000000906, 0.76565238554, 1439.50969814920],
[0.00000000985, 0.88687623770, 5760.49843189760],
[0.00000000983, 1.42102343372, 5746.27133789600],
[0.00000000892, 5.87250060663, 203.00415469950],
[0.00000000942, 2.31049430734, 9690.70812811720],
[0.00000000941, 2.84331157527, 9676.48103411560],
[0.00000000867, 0.81020362547, 524.27433912320],
[0.00000000829, 2.35178495412, 312.45971639350],
[0.00000000912, 2.80494184378, 6.21977512350],
[0.00000000809, 1.05148218513, 529.64278098480],
[0.00000000779, 4.80009242059, 945.24345570670],
[0.00000000878, 5.76532521399, 1.64453140270],
[0.00000000953, 4.30945738629, 209.36694217490],
[0.00000000772, 5.25607113566, 2950.61960112800],
[0.00000000745, 0.03810558502, 535.10759106600],
[0.00000000744, 0.58381523987, 25.27279426550],
[0.00000000734, 0.20800485100, 1049.08698945070],
[0.00000000747, 2.71772840871, 38.13303563780],
[0.00000000728, 5.97210358938, 945.99421523210],
[0.00000000769, 4.51394016967, 952.35700270750],
[0.00000000710, 0.38016353553, 69.15252427480],
[0.00000000760, 3.07033779824, 39.35687591520],
[0.00000000802, 1.14191463412, 532.61172640140],
[0.00000000704, 1.25447308120, 547.85021235930],
[0.00000000721, 0.73855379162, 2228.97018159780],
[0.00000000794, 4.25051539085, 2641.34127847220],
[0.00000000795, 3.20588363820, 604.47256366190],
[0.00000000818, 1.05229815343, 909.81873305460],
[0.00000000724, 5.68281830264, 953.10776223290],
[0.00000000836, 0.60410469174, 2097.42321937600],
[0.00000000669, 5.75757140051, 2015.67108615980],
[0.00000000682, 1.19994890339, 387.24131496080],
[0.00000000640, 3.91546675664, 528.72775724810],
[0.00000000809, 4.24929331276, 529.73914920440],
[0.00000000819, 4.91540072376, 2751.54759969160],
[0.00000000692, 2.51162384766, 916.93228005540],
[0.00000000784, 4.23651511312, 195.13984817330],
[0.00000000762, 1.12201139619, 732.69511979410],
[0.00000000617, 5.80920925081, 739.05790726950],
[0.00000000727, 4.24401822698, 760.25553592000],
[0.00000000591, 3.26075006572, 202.25339517410],
[0.00000000552, 5.83533550039, 526.77020378780],
[0.00000000640, 1.38530872949, 530.65417294110],
[0.00000000577, 6.09100925678, 2531.13495725280],
[0.00000000620, 3.01917904435, 902.70518605380],
[0.00000000722, 5.18171159557, 1.48447270830],
[0.00000000540, 3.78809230820, 2957.73314812880],
[0.00000000523, 3.63882376000, 437.64389113990],
[0.00000000527, 5.80796427555, 3053.71237534660],
[0.00000000488, 4.99103190309, 483.22054217860],
[0.00000000557, 4.11381202161, 2854.64037391020],
[0.00000000492, 0.76371083106, 1603.29998928540],
[0.00000000487, 5.55383951779, 2627.11418447060],
[0.00000000487, 5.86510858429, 724.83081326790],
[0.00000000453, 0.61375011101, 1159.29331067010],
[0.00000000450, 2.28121042355, 3060.82592234740],
[0.00000000515, 4.78126059280, 447.79581952650],
[0.00000000449, 4.70231576312, 934.94851496820],
[0.00000000450, 1.91049508739, 597.35901666110],
[0.00000000438, 6.01178917646, 3178.14579056760],
[0.00000000494, 0.53844942275, 1354.43315884340],
[0.00000000501, 5.51752195462, 2435.15573003500],
[0.00000000432, 3.64903264921, 313.21047591890],
[0.00000000435, 3.02449828967, 533.88375078860],
[0.00000000426, 5.07945534339, 2524.02141025200],
[0.00000000491, 3.59286364200, 230.56457082540],
[0.00000000547, 0.34432090949, 1251.34038462480],
[0.00000000503, 1.57454509207, 454.90936652730],
[0.00000000486, 4.39351469958, 462.02291352810],
[0.00000000524, 2.03003740296, 1279.79457262800],
[0.00000000388, 5.58318013074, 731.94436026870],
[0.00000000449, 1.11025492739, 56.62235130260],
[0.00000000398, 5.19943284273, 3267.01147078460],
[0.00000000416, 1.70821917336, 245.54242435240],
[0.00000000379, 1.80234948769, 2655.56837247380],
[0.00000000355, 1.65214516751, 78.71375183040],
[0.00000000404, 1.72647262603, 1141.13406340540],
[0.00000000335, 6.01254286794, 960.22130923370],
[0.00000000331, 1.74086938716, 490.33408917940],
[0.00000000401, 0.30034336462, 2332.06295581640],
[0.00000000336, 2.64385574909, 1021.24889455140],
[0.00000000389, 0.31259289221, 2413.81508903260],
[0.00000000314, 5.73833529708, 1158.54255114470],
[0.00000000313, 4.74363791106, 938.12990870590],
[0.00000000333, 0.80112437148, 1585.14074202070],
[0.00000000323, 3.52656245280, 3274.12501778540],
[0.00000000395, 1.73181407631, 1593.00504854690],
[0.00000000302, 4.64184749164, 1261.63532536330],
[0.00000000325, 0.54991590409, 43.28902917830],
[0.00000000293, 0.97977818746, 1585.89150154610],
[0.00000000341, 2.80833606944, 1514.29129671650],
[0.00000000304, 6.12522825214, 1262.38608488870],
[0.00000000286, 2.89800423081, 530.21222995640],
[0.00000000387, 0.46648572639, 1592.25428902150],
[0.00000000285, 4.56394598052, 1268.74887236410],
[0.00000000310, 4.69102289591, 76.26607127560],
[0.00000000278, 5.49867187248, 280.96714700450],
[0.00000000358, 5.45926487831, 113.38771495710],
[0.00000000283, 1.09230506350, 1061.82961074400],
[0.00000000326, 0.60265259639, 827.92358748650],
[0.00000000284, 5.36580034539, 1165.65609814550],
[0.00000000281, 5.54635461050, 3370.10424500320],
[0.00000000269, 3.92616563946, 42.53826965290],
[0.00000000275, 2.58465453365, 373.01422095920],
[0.00000000357, 1.39391983207, 1493.09366806600],
[0.00000000258, 5.96670694140, 1269.49963188950],
[0.00000000259, 2.56026216784, 9146.79006902100],
[0.00000000281, 2.74823090198, 4694.00295470760],
[0.00000000281, 3.01324655940, 320.32402291970],
[0.00000000272, 4.18504958920, 8624.21265092720],
[0.00000000245, 1.24462798353, 252.65597135320],
[0.00000000244, 2.02892764690, 3377.21779200400],
[0.00000000324, 1.84851618413, 1289.94650101460],
[0.00000000221, 6.22167997496, 3281.23856478620],
[0.00000000238, 3.93371505401, 3171.03224356680],
[0.00000000226, 5.94296271326, 224.34479570190],
[0.00000000213, 3.68264234750, 1048.33622992530],
[0.00000000216, 5.82941334164, 1567.73225428140],
[0.00000000295, 4.70194747095, 3067.93946934820],
[0.00000000206, 4.98184230959, 1357.61455258110],
[0.00000000202, 1.32439444045, 4326.39340097380],
[0.00000000227, 0.78540105705, 59.80374504030],
[0.00000000237, 5.56926897693, 2943.50605412720],
[0.00000000207, 0.07907015398, 5223.69391980220],
[0.00000000199, 3.30501818656, 4120.20785253660],
[0.00000000194, 5.95526916809, 84.93352695390],
[0.00000000266, 1.58032565718, 983.11585891360],
[0.00000000198, 4.31078641704, 4017.11507831800],
[0.00000000198, 0.30166351366, 1166.40685767090],
[0.00000000188, 0.90738705875, 135.33610313300],
[0.00000000186, 0.69289672485, 92.79783348010],
[0.00000000182, 1.18931462257, 1512.80682400820],
[0.00000000191, 1.04146023518, 1884.12412393800],
[0.00000000174, 6.13734594396, 3597.63043444280],
[0.00000000189, 0.35191512844, 1372.59240610810],
[0.00000000172, 4.35250972697, 1578.02719501990],
[0.00000000173, 2.30241719278, 1176.70179840940],
[0.00000000220, 1.06991056825, 2200.51599359460],
[0.00000000186, 4.90511103807, 3583.40334044120],
[0.00000000189, 0.24160744024, 1670.82502850000],
[0.00000000206, 0.01485146863, 2730.20695868920],
[0.00000000174, 1.83997277029, 746.92221379570],
[0.00000000225, 3.13108099660, 630.33605875840],
[0.00000000206, 5.22730929781, 3995.77443731560],
[0.00000000169, 2.57956682688, 9161.01716302260],
[0.00000000165, 1.51795928301, 4010.00153131720],
[0.00000000181, 2.05055200822, 842.90144101350],
[0.00000000181, 5.96554625357, 1578.77795454530],
[0.00000000166, 1.55114863100, 1070.42763045310],
[0.00000000157, 5.87839958880, 3914.02230409940],
[0.00000000160, 0.43729819176, 2545.36205125440],
[0.00000000168, 5.73975661792, 2847.52682690940],
[0.00000000157, 2.25764581068, 850.01498801430],
[0.00000000187, 0.64918748618, 842.15068148810],
[0.00000000180, 1.88055488803, 685.47393735270],
[0.00000000153, 4.15259684562, 4333.50694797460],
[0.00000000154, 3.65536637158, 77734.01845962799],
[0.00000000151, 3.17795437121, 3590.51688744200],
[0.00000000155, 3.87623547990, 327.43756992050],
[0.00000000171, 3.33647878498, 1912.57831194120],
[0.00000000188, 4.53005359421, 1041.22268292450],
[0.00000000134, 4.09921613445, 530.44172462000],
[0.00000000123, 4.79543460218, 1098.73880610440],
[0.00000000161, 2.02006564218, 860.30992875280],
[0.00000000143, 2.40197278329, 529.16970023280],
[0.00000000115, 1.55831212007, 9153.90361602180],
[0.00000000106, 5.94313244357, 1057.89745748090],
[0.00000000119, 5.10578428676, 1056.93424963440],
[0.00000000100, 5.74974781049, 501.23677709140],
[0.00000000094, 1.40134175492, 1059.33374607940],
[0.00000000098, 3.79115318281, 497.44763618020],
[0.00000000090, 4.09610113044, 1064.04779663520],
[0.00000000102, 1.10442899544, 1969.20066324380],
[0.00000000087, 0.58218477838, 1173.52040467170],
[0.00000000109, 3.83745968299, 525.49817940060],
[0.00000000094, 4.59915291355, 1059.43011429900],
[0.00000000118, 6.11701561559, 1069.67687092770],
[0.00000000107, 5.40509332689, 679.25416222920],
[0.00000000089, 5.90037690244, 757.21715453420],
[0.00000000078, 6.06217863109, 970.51624997220],
[0.00000000080, 5.45470236239, 3163.91869656600],
[0.00000000072, 5.65789862232, 1151.42900414390],
[0.00000000080, 0.04539720100, 1080.72257119160],
[0.00000000075, 4.26526686574, 1058.41872234270],
], [
[0.00047233598, 4.32148323554, 7.11354700080],
[0.00030629053, 2.93021440216, 529.69096509460],
[0.00038965550, 0.00000000000, 0.00000000000],
[0.00003189317, 1.05504615595, 522.57741809380],
[0.00002723358, 3.41411526638, 1059.38193018920],
[0.00002729292, 4.84545481351, 536.80451209540],
[0.00001721069, 4.18734385158, 14.22709400160],
[0.00000383258, 5.76790714387, 419.48464387520],
[0.00000367498, 6.05509120409, 103.09277421860],
[0.00000377524, 0.76048964872, 515.46387109300],
[0.00000337386, 3.78644384244, 3.18139373770],
[0.00000308200, 0.69356654052, 206.18554843720],
[0.00000218408, 3.81389191353, 1589.07289528380],
[0.00000198883, 5.33996443444, 1066.49547719000],
[0.00000197445, 2.48356402053, 3.93215326310],
[0.00000146230, 3.81373196838, 639.89728631400],
[0.00000155862, 1.40642426467, 1052.26838318840],
[0.00000129570, 5.83738872525, 412.37109687440],
[0.00000141932, 1.63435169016, 426.59819087600],
[0.00000117327, 1.41435462588, 625.67019231240],
[0.00000096733, 4.03383427887, 110.20632121940],
[0.00000090823, 1.10630629042, 95.97922721780],
[0.00000078769, 4.63726131329, 543.91805909620],
[0.00000072392, 2.21716670026, 735.87651353180],
[0.00000087292, 2.52235174825, 632.78373931320],
[0.00000056910, 3.12292059854, 213.29909543800],
[0.00000048622, 1.67283791618, 309.27832265580],
[0.00000058475, 0.83216317444, 199.07200143640],
[0.00000040150, 4.02485444740, 21.34064100240],
[0.00000039784, 0.62416945827, 323.50541665740],
[0.00000035718, 2.32581247002, 728.76296653100],
[0.00000025620, 2.51240623862, 1162.47470440780],
[0.00000029255, 3.60838327799, 10.29494073850],
[0.00000023591, 3.00532139306, 956.28915597060],
[0.00000027814, 3.23992013743, 838.96928775040],
[0.00000025993, 4.50118298290, 742.99006053260],
[0.00000025194, 1.21868110687, 1045.15483618760],
[0.00000019458, 4.29028644674, 532.87235883230],
[0.00000017660, 0.80953941560, 508.35032409220],
[0.00000015355, 5.81037986941, 1596.18644228460],
[0.00000017058, 4.20001977723, 2118.76386037840],
[0.00000017040, 1.83402146640, 526.50957135690],
[0.00000014661, 3.99989622586, 117.31986822020],
[0.00000013639, 1.80336677963, 302.16477565500],
[0.00000013230, 2.51856643603, 88.86568021700],
[0.00000012756, 4.36856232414, 1169.58825140860],
[0.00000015292, 0.68174165476, 942.06206196900],
[0.00000010986, 4.43586634639, 525.75881183150],
[0.00000013920, 5.95169568482, 316.39186965660],
[0.00000009437, 2.17684563456, 1155.36115740700],
[0.00000008812, 3.29452783338, 220.41264243880],
[0.00000007823, 5.75672228354, 846.08283475120],
[0.00000007549, 2.70955516779, 533.62311835770],
[0.00000009681, 1.71563161051, 1581.95934828300],
[0.00000008690, 3.31924493607, 831.85574074960],
[0.00000006285, 0.49939863541, 949.17560896980],
[0.00000006685, 2.17560093281, 1265.56747862640],
[0.00000005381, 6.00510875948, 405.25754987360],
[0.00000004676, 1.40846192799, 1258.45393162560],
[0.00000004421, 3.02360159274, 1692.16566950240],
[0.00000004403, 5.47737266160, 433.71173787680],
[0.00000004286, 5.07139951645, 1073.60902419080],
[0.00000004201, 5.28560721767, 18.15924726470],
[0.00000003933, 1.26665387164, 853.19638175200],
[0.00000005351, 3.65320121089, 1272.68102562720],
[0.00000004392, 2.27325303667, 1368.66025284500],
[0.00000003482, 1.53983001273, 519.39602435610],
[0.00000002745, 2.09685315627, 1478.86657406440],
[0.00000002737, 1.06017230524, 1574.84580128220],
[0.00000002897, 2.05128453665, 1361.54670584420],
[0.00000003075, 0.99085727534, 191.95845443560],
[0.00000002462, 2.37173605635, 1471.75302706360],
[0.00000002203, 2.47960567714, 721.64941953020],
[0.00000002096, 3.71482580504, 1485.98012106520],
[0.00000001984, 1.88475229557, 1685.05212250160],
[0.00000002274, 3.03360234351, 1148.24761040620],
[0.00000002041, 6.17114556019, 330.61896365820],
[0.00000001451, 4.72055072637, 32.24332891440],
[0.00000001454, 5.14703918585, 1375.77379984580],
[0.00000001447, 3.18833439444, 635.96513305090],
[0.00000001403, 4.26712075104, 551.03160609700],
[0.00000001420, 1.99288040133, 629.60234557550],
[0.00000001269, 0.03300387779, 2125.87740737920],
[0.00000001276, 2.26356919237, 1788.14489672020],
[0.00000001189, 1.70223550488, 1677.93857550080],
[0.00000001182, 2.18142313946, 1795.25844372100],
[0.00000001366, 1.27629917215, 1038.04128918680],
[0.00000001306, 4.76302079847, 1062.56332392690],
[0.00000001109, 2.97787130235, 81.75213321620],
[0.00000001027, 1.99236027398, 295.05122865420],
[0.00000001349, 4.01621534182, 539.98590583310],
[0.00000001025, 3.75336759986, 28.45418800320],
[0.00000000977, 3.01355125761, 124.43341522100],
[0.00000001290, 4.62594234857, 2648.45482547300],
[0.00000001065, 5.06153058155, 1699.27921650320],
[0.00000000965, 1.17716405513, 99.91138048090],
[0.00000001021, 1.90712102660, 750.10360753340],
[0.00000000923, 3.53450109212, 227.52618943960],
[0.00000001059, 0.13532061468, 416.30325013750],
[0.00000000836, 2.07492422755, 1056.20053645150],
[0.00000000889, 1.75177808106, 1898.35121793960],
[0.00000000772, 2.89217715561, 2008.55753915900],
[0.00000001014, 2.80847772922, 1464.63948006280],
[0.00000000820, 1.99735697577, 2111.65031337760],
[0.00000000787, 4.91912237671, 1055.44977692610],
[0.00000000743, 2.65209650690, 106.27416795630],
[0.00000000705, 0.08006443278, 963.40270297140],
[0.00000000724, 3.29664246938, 628.85158605010],
[0.00000000791, 1.64655202110, 2001.44399215820],
[0.00000000822, 2.74067639972, 618.55664531160],
[0.00000000761, 1.26393500358, 1382.88734684660],
[0.00000000650, 1.19590511216, 422.66603761290],
[0.00000000677, 1.88476058357, 2104.53676637680],
[0.00000000681, 5.47481665606, 5760.49843189760],
[0.00000000681, 3.11621209674, 5746.27133789600],
[0.00000000644, 4.68385640894, 611.44309831080],
[0.00000000752, 3.03497138894, 2221.85663459700],
[0.00000000641, 1.86274530783, 636.71589257630],
[0.00000000614, 3.07677356670, 380.12776796000],
[0.00000000635, 4.53916684689, 9676.48103411560],
[0.00000000635, 0.61458805483, 9690.70812811720],
[0.00000000822, 6.25170365084, 423.41679713830],
[0.00000000762, 4.32362906505, 1802.37199072180],
[0.00000000582, 0.84137872868, 1891.23767093880],
[0.00000000558, 3.96171840325, 440.82528487760],
[0.00000000624, 2.83657771014, 1905.46476494040],
[0.00000000711, 3.43538032357, 824.74219374880],
[0.00000000517, 1.10660016329, 107.02492748170],
[0.00000000535, 1.55761050176, 1994.33044515740],
[0.00000000501, 4.44389802599, 647.01083331480],
[0.00000000414, 5.37130370397, 2228.97018159780],
[0.00000000533, 2.54756313371, 1781.03134971940],
[0.00000000393, 1.26351262287, 210.11770170030],
[0.00000000433, 2.90103969634, 1063.31408345230],
[0.00000000384, 1.36194621083, 203.00415469950],
[0.00000000440, 1.46934545869, 2214.74308759620],
[0.00000000424, 4.98974282486, 3178.14579056760],
[0.00000000338, 2.72210106345, 2324.94940881560],
[0.00000000332, 0.37505564414, 2655.56837247380],
[0.00000000318, 6.11024720065, 934.94851496820],
[0.00000000405, 3.51005860013, 2751.54759969160],
[0.00000000388, 5.00609647265, 2015.67108615980],
[0.00000000424, 4.29668654117, 5753.38488489680],
[0.00000000328, 2.35571531981, 1251.34038462480],
[0.00000000316, 0.16949503062, 1279.79457262800],
[0.00000000345, 2.89328206121, 2957.73314812880],
[0.00000000303, 1.63964826684, 2428.04218303420],
[0.00000000328, 3.36132375845, 1141.13406340540],
[0.00000000294, 2.48947693371, 2641.34127847220],
[0.00000000350, 1.50537240918, 2317.83586181480],
[0.00000000287, 1.69638214958, 2420.92863603340],
[0.00000000272, 0.27466529753, 319.57326339430],
[0.00000000303, 2.43034117616, 70.84944530420],
[0.00000000251, 0.43544711316, 3259.89792378380],
[0.00000000224, 4.49752269293, 5223.69391980220],
[0.00000000272, 2.98590404673, 1457.52593306200],
[0.00000000228, 5.47896916415, 1603.29998928540],
[0.00000000288, 2.30146999217, 2854.64037391020],
[0.00000000207, 5.94297320087, 9153.90361602180],
[0.00000000243, 1.58604251447, 2744.43405269080],
[0.00000000228, 1.28182702946, 2310.72231481400],
[0.00000000224, 1.28623905132, 3060.82592234740],
[0.00000000222, 0.63265553397, 3163.91869656600],
[0.00000000242, 2.52382905368, 3274.12501778540],
[0.00000000188, 6.00513627145, 92.04707395470],
[0.00000000239, 1.93897157244, 2413.81508903260],
[0.00000000214, 1.14529237568, 2531.13495725280],
[0.00000000200, 3.42280996072, 99.16062095550],
[0.00000000179, 0.53892926207, 2207.62954059540],
[0.00000000177, 5.56545270243, 2332.06295581640],
[0.00000000172, 1.38604067808, 945.99421523210],
[0.00000000203, 0.41899069603, 2840.41327990860],
[0.00000000231, 2.26353330460, 2097.42321937600],
[0.00000000228, 3.82701076821, 113.38771495710],
[0.00000000165, 4.08776703733, 6283.07584999140],
[0.00000000202, 3.30429764992, 3067.93946934820],
[0.00000000224, 3.69285208525, 2435.15573003500],
[0.00000000214, 2.55756944911, 2538.24850425360],
[0.00000000203, 2.24205059922, 67.66805156650],
[0.00000000152, 5.48122906518, 10213.28554621100],
[0.00000000191, 2.68685722531, 1773.91780271860],
[0.00000000189, 2.95184620359, 732.69511979410],
[0.00000000149, 1.98737542735, 1049.08698945070],
[0.00000000163, 1.24084734609, 3053.71237534660],
[0.00000000171, 2.34210749987, 1354.43315884340],
[0.00000000112, 5.77407285790, 547.85021235930],
[0.00000000124, 0.14001204498, 860.30992875280],
[0.00000000086, 1.26924601636, 511.53171782990],
[0.00000000114, 5.15982838070, 1592.25428902150],
[0.00000000091, 1.48896790758, 1567.73225428140],
[0.00000000086, 4.34444949905, 1069.67687092770],
], [
[0.00006501665, 2.59862880482, 7.11354700080],
[0.00001356524, 1.34635886411, 529.69096509460],
[0.00000470716, 2.47503977883, 14.22709400160],
[0.00000416960, 3.24451243214, 536.80451209540],
[0.00000352851, 2.97360159003, 522.57741809380],
[0.00000154880, 2.07565585817, 1059.38193018920],
[0.00000086771, 2.51431584316, 515.46387109300],
[0.00000033538, 3.82633794497, 1066.49547719000],
[0.00000044378, 0.00000000000, 0.00000000000],
[0.00000022644, 2.98231326774, 543.91805909620],
[0.00000023737, 1.27667172313, 412.37109687440],
[0.00000028457, 2.44754756058, 206.18554843720],
[0.00000019798, 2.10099934005, 639.89728631400],
[0.00000019740, 1.40255938973, 419.48464387520],
[0.00000018768, 1.59368403500, 103.09277421860],
[0.00000017033, 2.30214681202, 21.34064100240],
[0.00000016774, 2.59821460673, 1589.07289528380],
[0.00000016214, 3.14521117299, 625.67019231240],
[0.00000016055, 3.36030126297, 1052.26838318840],
[0.00000013392, 2.75973892202, 95.97922721780],
[0.00000013234, 2.53862244340, 199.07200143640],
[0.00000012611, 6.26578110400, 426.59819087600],
[0.00000008637, 2.26563256289, 110.20632121940],
[0.00000006725, 3.42566433316, 309.27832265580],
[0.00000008701, 1.76334960737, 10.29494073850],
[0.00000006527, 4.03869562907, 728.76296653100],
[0.00000005368, 5.25196153539, 323.50541665740],
[0.00000005675, 2.52096417685, 508.35032409220],
[0.00000005399, 2.91184687105, 1045.15483618760],
[0.00000003996, 4.30290261177, 88.86568021700],
[0.00000003857, 3.52381361552, 302.16477565500],
[0.00000003774, 4.09125315146, 735.87651353180],
[0.00000003269, 1.43175991274, 956.28915597060],
[0.00000002783, 4.35817507670, 1596.18644228460],
[0.00000002661, 1.25276590759, 213.29909543800],
[0.00000002553, 2.23785673285, 117.31986822020],
[0.00000002371, 2.89662409244, 742.99006053260],
[0.00000002656, 5.01505839848, 838.96928775040],
[0.00000001948, 2.77248294666, 1169.58825140860],
[0.00000002279, 2.35581871230, 942.06206196900],
[0.00000001474, 1.61011468581, 220.41264243880],
[0.00000001457, 3.09381959396, 2118.76386037840],
[0.00000001937, 5.01388256693, 831.85574074960],
[0.00000001585, 1.40097680805, 405.25754987360],
[0.00000001257, 3.97811260358, 1155.36115740700],
[0.00000001227, 3.45959919972, 1073.60902419080],
[0.00000000986, 3.39209446167, 532.87235883230],
[0.00000000942, 2.70200385825, 191.95845443560],
[0.00000000828, 1.48348768286, 632.78373931320],
[0.00000000797, 1.10706688850, 1162.47470440780],
[0.00000000822, 3.30295824153, 1258.45393162560],
[0.00000000710, 5.89798771980, 853.19638175200],
[0.00000000766, 3.66351539483, 1581.95934828300],
[0.00000000722, 3.74673245797, 433.71173787680],
[0.00000000663, 2.93063953915, 1574.84580128220],
[0.00000000658, 3.52797311863, 525.75881183150],
[0.00000000609, 4.14881313523, 721.64941953020],
[0.00000000598, 4.69454609357, 81.75213321620],
[0.00000000668, 1.96442971289, 1272.68102562720],
[0.00000000515, 1.57251270902, 949.17560896980],
[0.00000000658, 2.02329201466, 526.50957135690],
[0.00000000517, 4.35827478516, 1368.66025284500],
[0.00000000510, 4.95846155301, 1148.24761040620],
[0.00000000507, 4.31396370095, 330.61896365820],
[0.00000000567, 2.27813343743, 551.03160609700],
[0.00000000480, 3.86758235988, 1361.54670584420],
[0.00000000383, 0.24287136454, 611.44309831080],
[0.00000000434, 2.95461755540, 1038.04128918680],
[0.00000000377, 1.42957648215, 124.43341522100],
[0.00000000391, 4.07770324592, 1471.75302706360],
[0.00000000385, 4.70295179800, 519.39602435610],
[0.00000000428, 2.22472522305, 539.98590583310],
[0.00000000343, 4.83463725823, 2125.87740737920],
[0.00000000394, 4.52891996323, 1464.63948006280],
[0.00000000305, 2.02797683648, 1485.98012106520],
[0.00000000283, 0.97461612169, 1905.46476494040],
[0.00000000276, 3.83552772064, 1062.56332392690],
[0.00000000351, 2.06334334462, 533.62311835770],
[0.00000000304, 3.93228052293, 1685.05212250160],
[0.00000000322, 3.54763044791, 846.08283475120],
[0.00000000345, 4.18332148409, 1788.14489672020],
[0.00000000253, 3.12703531516, 1994.33044515740],
[0.00000000257, 1.05361498985, 1478.86657406440],
[0.00000000232, 1.69999081817, 1692.16566950240],
[0.00000000225, 2.51624149780, 1891.23767093880],
[0.00000000217, 4.58512911216, 963.40270297140],
[0.00000000277, 3.63353707701, 1677.93857550080],
[0.00000000242, 2.90163762388, 2310.72231481400],
[0.00000000211, 3.96419403991, 295.05122865420],
[0.00000000199, 5.17046500750, 618.55664531160],
[0.00000000256, 4.19052619061, 1781.03134971940],
[0.00000000192, 0.81556540966, 2221.85663459700],
[0.00000000187, 3.49895198981, 2648.45482547300],
[0.00000000208, 4.11838429822, 2097.42321937600],
[0.00000000183, 3.30680692414, 1699.27921650320],
[0.00000000231, 2.54516792766, 1375.77379984580],
[0.00000000189, 5.74277274755, 2627.11418447060],
[0.00000000214, 5.48031974537, 1354.43315884340],
[0.00000000220, 3.87471989410, 2104.53676637680],
[0.00000000171, 6.10827209399, 1382.88734684660],
[0.00000000184, 5.98415847544, 750.10360753340],
[0.00000000171, 5.25744961028, 824.74219374880],
[0.00000000151, 4.30799091626, 2001.44399215820],
[0.00000000140, 4.27089466070, 1265.56747862640],
[0.00000000097, 4.67188056608, 647.01083331480],
[0.00000000088, 2.43775210355, 440.82528487760],
[0.00000000075, 3.93105183253, 1055.44977692610],
[0.00000000079, 1.88533153220, 934.94851496820],
[0.00000000077, 3.80503143236, 1603.29998928540],
], [
[0.00000669483, 0.85282421090, 7.11354700080],
[0.00000099961, 0.74258947751, 14.22709400160],
[0.00000114019, 3.14159265359, 0.00000000000],
[0.00000050024, 1.65346208248, 536.80451209540],
[0.00000043585, 5.82026386621, 529.69096509460],
[0.00000031813, 4.85829986650, 522.57741809380],
[0.00000014742, 4.29061635784, 515.46387109300],
[0.00000008899, 0.71478520741, 1059.38193018920],
[0.00000004957, 1.29502259434, 543.91805909620],
[0.00000004484, 2.31715516627, 1066.49547719000],
[0.00000004251, 0.48326797501, 21.34064100240],
[0.00000003100, 3.00245542678, 412.37109687440],
[0.00000002055, 0.39858940218, 639.89728631400],
[0.00000001762, 4.90536207307, 625.67019231240],
[0.00000001902, 4.25925620271, 199.07200143640],
[0.00000001695, 4.26147580803, 206.18554843720],
[0.00000001375, 5.25546955667, 1052.26838318840],
[0.00000001203, 4.71614633845, 95.97922721780],
[0.00000001086, 1.28604571172, 1589.07289528380],
[0.00000000982, 4.77990073662, 1045.15483618760],
[0.00000000935, 6.05847062188, 88.86568021700],
[0.00000000916, 5.77537499431, 728.76296653100],
[0.00000000890, 4.55299189579, 426.59819087600],
[0.00000000784, 3.40161567950, 419.48464387520],
[0.00000000768, 3.54672049322, 103.09277421860],
[0.00000000670, 0.52223307700, 110.20632121940],
[0.00000000415, 5.22809480633, 302.16477565500],
[0.00000000393, 6.24184621807, 956.28915597060],
[0.00000000381, 5.25466966040, 309.27832265580],
[0.00000000421, 0.59561318533, 117.31986822020],
[0.00000000346, 4.78348312106, 508.35032409220],
[0.00000000319, 3.47979828725, 323.50541665740],
[0.00000000331, 2.95893485883, 1596.18644228460],
[0.00000000295, 4.32713459459, 942.06206196900],
[0.00000000319, 0.47990052824, 831.85574074960],
[0.00000000251, 1.79898001222, 1073.60902419080],
[0.00000000212, 0.43917684084, 220.41264243880],
[0.00000000188, 1.12654974776, 1169.58825140860],
[0.00000000188, 2.16135407548, 1361.54670584420],
[0.00000000180, 3.43266428069, 1148.24761040620],
[0.00000000164, 1.92864127211, 2118.76386037840],
[0.00000000157, 3.02963907392, 1272.68102562720],
[0.00000000093, 5.60436000012, 1581.95934828300],
[0.00000000085, 5.02317256200, 1155.36115740700],
[0.00000000075, 3.13198879608, 632.78373931320],
], [
[0.00000049577, 5.25658966184, 7.11354700080],
[0.00000015761, 5.25126837478, 14.22709400160],
[0.00000004343, 0.01461869263, 536.80451209540],
[0.00000001526, 1.09739911439, 522.57741809380],
[0.00000000728, 5.85949047619, 543.91805909620],
[0.00000000694, 0.87382487754, 515.46387109300],
[0.00000000845, 3.14159265359, 0.00000000000],
[0.00000000456, 0.81521692852, 1066.49547719000],
[0.00000000293, 5.62909357048, 1059.38193018920],
[0.00000000090, 0.21178119710, 529.69096509460],
]],
('Jupiter', 'B'):[[
[0.02268615703, 3.55852606718, 529.69096509460],
[0.00109971634, 3.90809347389, 1059.38193018920],
[0.00110090358, 0.00000000000, 0.00000000000],
[0.00008101427, 3.60509573368, 522.57741809380],
[0.00006043996, 4.25883108794, 1589.07289528380],
[0.00006437782, 0.30627121409, 536.80451209540],
[0.00001106880, 2.98534421928, 1162.47470440780],
[0.00000941651, 2.93619072405, 1052.26838318840],
[0.00000894088, 1.75447429921, 7.11354700080],
[0.00000767280, 2.15473594060, 632.78373931320],
[0.00000944328, 1.67522288396, 426.59819087600],
[0.00000684220, 3.67808770098, 213.29909543800],
[0.00000629223, 0.64343282328, 1066.49547719000],
[0.00000835861, 5.17881973234, 103.09277421860],
[0.00000531670, 2.70305954352, 110.20632121940],
[0.00000558524, 0.01354830508, 846.08283475120],
[0.00000464449, 1.17337249185, 949.17560896980],
[0.00000431072, 2.60825000494, 419.48464387520],
[0.00000351433, 4.61062990714, 2118.76386037840],
[0.00000123148, 3.34968181384, 1692.16566950240],
[0.00000115038, 5.04892295442, 316.39186965660],
[0.00000132160, 4.77816990670, 742.99006053260],
[0.00000103402, 2.31878999565, 1478.86657406440],
[0.00000116379, 1.38688232033, 323.50541665740],
[0.00000102420, 3.15293785436, 1581.95934828300],
[0.00000103762, 3.70103838110, 515.46387109300],
[0.00000078650, 3.98318653238, 1265.56747862640],
[0.00000069935, 2.56006216424, 956.28915597060],
[0.00000055597, 0.37500753017, 1375.77379984580],
[0.00000051986, 0.99007119033, 1596.18644228460],
[0.00000055194, 0.40176412035, 525.75881183150],
[0.00000063456, 4.50073574333, 735.87651353180],
[0.00000049691, 0.18649893085, 543.91805909620],
[0.00000048831, 3.57260550671, 533.62311835770],
[0.00000028353, 1.53532744749, 625.67019231240],
[0.00000029209, 5.43145863011, 206.18554843720],
[0.00000023255, 5.95197992848, 838.96928775040],
[0.00000022841, 6.19262787685, 532.87235883230],
[0.00000023202, 4.06473368575, 526.50957135690],
[0.00000024436, 6.10947656959, 1169.58825140860],
[0.00000021116, 4.96322972735, 2648.45482547300],
[0.00000017879, 3.08704395969, 1795.25844372100],
[0.00000016234, 4.83515727869, 1368.66025284500],
[0.00000021314, 2.69476951059, 1045.15483618760],
[0.00000015740, 1.15130330106, 942.06206196900],
[0.00000017325, 1.61550009206, 14.22709400160],
[0.00000013396, 2.30539585502, 853.19638175200],
[0.00000011904, 3.09811974536, 2111.65031337760],
[0.00000011734, 2.83006431723, 2008.55753915900],
[0.00000011291, 0.98957560201, 433.71173787680],
[0.00000011830, 4.76527836803, 309.27832265580],
[0.00000010702, 3.70181397065, 2221.85663459700],
[0.00000010815, 5.81958878617, 1272.68102562720],
[0.00000013505, 3.28126975760, 1155.36115740700],
[0.00000010179, 2.58691128827, 117.31986822020],
[0.00000010632, 5.23487936086, 95.97922721780],
[0.00000008771, 0.40456546655, 220.41264243880],
[0.00000007439, 2.94638292086, 412.37109687440],
[0.00000006151, 2.69100382247, 380.12776796000],
[0.00000005028, 0.72750312028, 1055.44977692610],
[0.00000004939, 0.73756716762, 1905.46476494040],
[0.00000005421, 4.08612438558, 1685.05212250160],
[0.00000005936, 4.32059910537, 1063.31408345230],
[0.00000004737, 4.09303016850, 527.24328453980],
[0.00000004010, 0.51530008355, 1073.60902419080],
[0.00000004709, 1.84067645204, 984.60033162190],
[0.00000003974, 1.33608029246, 2125.87740737920],
[0.00000003762, 3.58647039394, 529.73914920440],
[0.00000004731, 6.16377350841, 532.13864564940],
[0.00000004666, 5.88762905802, 639.89728631400],
[0.00000003763, 0.38865925413, 529.64278098480],
[0.00000003409, 4.05398247269, 1898.35121793960],
[0.00000003457, 3.43865563497, 1485.98012106520],
[0.00000004229, 2.23767157901, 74.78159856730],
[0.00000003091, 0.16470256025, 1699.27921650320],
[0.00000002975, 0.72268908074, 530.65417294110],
[0.00000003162, 1.25048416420, 330.61896365820],
[0.00000002727, 4.37679213321, 149.56319713460],
[0.00000002837, 0.05987107395, 1439.50969814920],
[0.00000002983, 3.25251207220, 528.72775724810],
[0.00000002232, 0.26149880534, 1062.56332392690],
[0.00000002464, 1.16913304420, 453.42489381900],
[0.00000002596, 3.30510149086, 2324.94940881560],
[0.00000001988, 2.85269577619, 1574.84580128220],
[0.00000002527, 5.94458202950, 909.81873305460],
[0.00000002269, 1.30379329597, 3.93215326310],
[0.00000001742, 4.49909767044, 1258.45393162560],
[0.00000001714, 4.12945878208, 2001.44399215820],
[0.00000002029, 3.97938086639, 1056.20053645150],
[0.00000001667, 0.36037092553, 10213.28554621100],
[0.00000001579, 6.11640144795, 1802.37199072180],
[0.00000001393, 3.69324470827, 2214.74308759620],
[0.00000001604, 1.98841031703, 38.13303563780],
[0.00000001325, 1.74025919863, 529.16970023280],
[0.00000001451, 2.39804501178, 2428.04218303420],
[0.00000001594, 2.07556780757, 1021.24889455140],
[0.00000001320, 1.33770977126, 618.55664531160],
[0.00000001346, 3.27591492540, 2641.34127847220],
[0.00000001230, 0.19552728220, 305.34616939270],
[0.00000001223, 2.86681556337, 1382.88734684660],
[0.00000001324, 2.23549334986, 530.21222995640],
[0.00000001056, 3.80579750957, 76.26607127560],
[0.00000001050, 4.68011652614, 1788.14489672020],
[0.00000001226, 5.34003255221, 3178.14579056760],
[0.00000001009, 3.19608028376, 2538.24850425360],
[0.00000001266, 3.04704446731, 604.47256366190],
[0.00000000954, 3.86932544808, 728.76296653100],
[0.00000001124, 1.59560367480, 3.18139373770],
[0.00000000978, 0.25223689838, 983.11585891360],
[0.00000000948, 0.21552742733, 750.10360753340],
[0.00000000946, 3.93927748120, 508.35032409220],
[0.00000000920, 1.14672086939, 963.40270297140],
[0.00000000817, 5.93809619876, 831.85574074960],
[0.00000000770, 2.96062737592, 526.77020378780],
[0.00000001017, 5.55711112145, 199.07200143640],
[0.00000000761, 1.38163787157, 532.61172640140],
[0.00000000726, 3.98337964395, 2317.83586181480],
[0.00000000862, 0.87975657414, 490.33408917940],
[0.00000000868, 3.44331872364, 569.04784100980],
[0.00000000711, 4.11107052823, 2751.54759969160],
[0.00000000708, 0.33555577415, 528.94020556920],
[0.00000000708, 4.00539820601, 530.44172462000],
[0.00000000656, 4.39568451439, 519.39602435610],
[0.00000000801, 4.03984430862, 1364.72809958190],
[0.00000000679, 1.18645749024, 525.49817940060],
[0.00000000645, 5.10510349996, 1361.54670584420],
[0.00000000668, 3.15607509055, 533.88375078860],
[0.00000000663, 0.73722024843, 5223.69391980220],
[0.00000000663, 1.57092786811, 6283.07584999140],
[0.00000000543, 0.26376529935, 227.52618943960],
[0.00000000525, 6.22318693939, 539.98590583310],
[0.00000000513, 4.98337900151, 302.16477565500],
[0.00000000544, 2.22227019273, 2744.43405269080],
[0.00000000532, 2.62425372687, 99.16062095550],
[0.00000000602, 1.56074089013, 454.90936652730],
[0.00000000518, 0.26343805959, 551.03160609700],
[0.00000000516, 1.09376390349, 934.94851496820],
[0.00000000659, 0.62560671589, 1512.80682400820],
[0.00000000524, 0.64710955846, 524.06189080210],
[0.00000000516, 3.69478866795, 535.32003938710],
[0.00000000491, 3.63039940597, 2531.13495725280],
[0.00000000570, 0.61976758791, 540.73666535850],
[0.00000000496, 2.19398015038, 1514.29129671650],
[0.00000000532, 0.20040217534, 525.02509864860],
[0.00000000493, 0.39160693598, 224.34479570190],
[0.00000000449, 0.62392433691, 529.53090640020],
[0.00000000449, 3.71676131146, 529.85102378900],
[0.00000000450, 5.02467015031, 1048.33622992530],
[0.00000000428, 5.44804660290, 11.04570026390],
[0.00000000499, 4.13924061941, 534.35683154060],
[0.00000000528, 1.76471074936, 524.27433912320],
[0.00000000454, 4.53321742354, 1056.93424963440],
[0.00000000520, 2.57406093768, 535.10759106600],
[0.00000000398, 1.40345870113, 960.22130923370],
[0.00000000457, 4.17708652827, 2104.53676637680],
[0.00000000505, 5.36536256321, 1057.89745748090],
[0.00000000535, 4.80455380313, 1593.00504854690],
[0.00000000415, 0.96548127237, 2435.15573003500],
[0.00000000519, 0.54543519483, 1061.82961074400],
[0.00000000359, 4.02704454075, 1059.43011429900],
[0.00000000356, 2.66818105522, 835.03713448730],
[0.00000000443, 5.27513700376, 1.48447270830],
[0.00000000358, 5.94423960514, 440.82528487760],
[0.00000000471, 6.05791940453, 1471.75302706360],
[0.00000000386, 2.15984900214, 9153.90361602180],
[0.00000000424, 2.70929670030, 1038.04128918680],
[0.00000000359, 0.82922836987, 1059.33374607940],
[0.00000000310, 0.88102053266, 529.90341341570],
[0.00000000310, 3.45966511571, 529.47851677350],
[0.00000000300, 3.70331799503, 2634.22773147140],
[0.00000000292, 2.63594456361, 415.55249061210],
[0.00000000279, 1.60669121578, 643.82943957710],
[0.00000000291, 5.83134071820, 1148.24761040620],
[0.00000000370, 5.71572992274, 531.17543780290],
[0.00000000268, 5.39275891813, 1891.23767093880],
[0.00000000275, 3.34108666036, 518.64526483070],
[0.00000000269, 1.06051406954, 1585.14074202070],
[0.00000000306, 2.50289017370, 511.53171782990],
[0.00000000295, 1.84394223501, 547.85021235930],
[0.00000000254, 2.98312992496, 1134.16352875650],
[0.00000000289, 1.86070918711, 21.34064100240],
[0.00000000265, 4.93075479744, 679.25416222920],
[0.00000000250, 0.42860925124, 1969.20066324380],
[0.00000000308, 2.67237933272, 2957.73314812880],
[0.00000000313, 4.88085697819, 528.20649238630],
[0.00000000222, 4.78828764413, 514.71311156760],
[0.00000000221, 4.32763468981, 1677.93857550080],
[0.00000000217, 3.46278526461, 2950.61960112800],
[0.00000000216, 0.52207667980, 2228.97018159780],
[0.00000000214, 5.83569926578, 544.66881862160],
[0.00000000283, 2.88709716090, 35.42472265210],
[0.00000000272, 1.65708415457, 3060.82592234740],
[0.00000000234, 1.68821537711, 2655.56837247380],
[0.00000000205, 3.36186888290, 2847.52682690940],
[0.00000000264, 3.62722625694, 2420.92863603340],
[0.00000000191, 4.26821147044, 430.53034413910],
[0.00000000179, 3.91470663005, 3340.61242669980],
[0.00000000180, 0.04531671003, 387.24131496080],
[0.00000000241, 4.03927631611, 494.26624244250],
[0.00000000176, 4.26298906325, 672.14061522840],
[0.00000000187, 2.72587420586, 299.12639426920],
[0.00000000234, 1.34474827450, 173.94221952280],
[0.00000000171, 0.85473611718, 1603.29998928540],
[0.00000000224, 0.33130232434, 565.11568774670],
[0.00000000200, 1.27632489123, 39.35687591520],
[0.00000000170, 4.96479470273, 1464.63948006280],
[0.00000000211, 1.00937080256, 523.54062594030],
[0.00000000210, 3.75793720248, 2854.64037391020],
[0.00000000162, 5.87784787295, 3480.31056622260],
[0.00000000163, 4.62850343495, 2015.67108615980],
[0.00000000191, 3.33159283750, 535.84130424890],
[0.00000000151, 1.17096741034, 1060.34513803570],
[0.00000000160, 1.81852636004, 312.45971639350],
[0.00000000158, 2.59595816107, 529.43033266370],
[0.00000000158, 1.74472748730, 529.95159752550],
[0.00000000173, 3.62399350412, 230.56457082540],
[0.00000000142, 0.70435921398, 522.52923398400],
[0.00000000144, 5.35763122430, 107.02492748170],
[0.00000000144, 6.13954848857, 1158.54255114470],
[0.00000000178, 0.27566275049, 3906.90875709860],
[0.00000000126, 5.14832919826, 2207.62954059540],
[0.00000000126, 3.41994798109, 2.44768055480],
[0.00000000127, 0.39825164051, 70.84944530420],
[0.00000000123, 4.77865550523, 2524.02141025200],
[0.00000000123, 0.46184813516, 647.01083331480],
[0.00000000144, 3.60261852727, 1058.41872234270],
[0.00000000158, 3.76231915252, 92.04707395470],
[0.00000000119, 4.08266911415, 1585.89150154610],
[0.00000000125, 2.35496721797, 3163.91869656600],
[0.00000000122, 3.21027426317, 3377.21779200400],
[0.00000000121, 3.39770381916, 18.15924726470],
[0.00000000131, 1.67926417552, 1289.94650101460],
[0.00000000115, 2.35735471566, 1550.93985964600],
[0.00000000126, 2.40833814513, 106.27416795630],
[0.00000000131, 1.37610474529, 1023.95720753710],
[0.00000000121, 1.60252617273, 10.29494073850],
[0.00000000121, 0.61420823557, 1592.25428902150],
[0.00000000135, 3.60177675518, 124.43341522100],
[0.00000000137, 2.41724947062, 3274.12501778540],
[0.00000000129, 0.09702914345, 2332.06295581640],
[0.00000000093, 4.88949890397, 1098.73880610440],
[0.00000000106, 5.18592950792, 2281.23049651060],
[0.00000000114, 2.96523316419, 1166.40685767090],
[0.00000000092, 1.65166124027, 860.30992875280],
[0.00000000102, 3.64093193142, 3171.03224356680],
[0.00000000103, 1.63066232967, 1894.41906467650],
[0.00000000080, 0.38766601876, 4694.00295470760],
[0.00000000074, 3.86865238736, 3067.93946934820],
[0.00000000095, 1.66362447044, 1151.42900414390],
], [
[0.00177351787, 5.70166488486, 529.69096509460],
[0.00003230171, 5.77941619340, 1059.38193018920],
[0.00003081364, 5.47464296527, 522.57741809380],
[0.00002211914, 4.73477480209, 536.80451209540],
[0.00001694232, 3.14159265359, 0.00000000000],
[0.00000346445, 4.74595174109, 1052.26838318840],
[0.00000234264, 5.18856099929, 1066.49547719000],
[0.00000196154, 6.18554286642, 7.11354700080],
[0.00000150468, 3.92721226087, 1589.07289528380],
[0.00000114128, 3.43897271830, 632.78373931320],
[0.00000096667, 2.91426304090, 949.17560896980],
[0.00000076599, 2.50522188662, 103.09277421860],
[0.00000081671, 5.07666097497, 1162.47470440780],
[0.00000076572, 0.61288981445, 419.48464387520],
[0.00000073875, 5.49958292155, 515.46387109300],
[0.00000049915, 3.94799616572, 735.87651353180],
[0.00000060544, 5.44740084359, 213.29909543800],
[0.00000036561, 4.69828392839, 543.91805909620],
[0.00000046032, 0.53850360901, 110.20632121940],
[0.00000045123, 1.89516645239, 846.08283475120],
[0.00000036019, 6.10952578764, 316.39186965660],
[0.00000031975, 4.92452714629, 1581.95934828300],
[0.00000021015, 5.62957731410, 1596.18644228460],
[0.00000023156, 5.84829490183, 323.50541665740],
[0.00000024719, 3.94107395247, 2118.76386037840],
[0.00000017274, 5.65310656429, 533.62311835770],
[0.00000016521, 5.89840100621, 526.50957135690],
[0.00000016698, 5.66663034948, 1265.56747862640],
[0.00000015815, 4.43314786393, 1045.15483618760],
[0.00000013398, 4.30179033605, 532.87235883230],
[0.00000011744, 1.80990486955, 956.28915597060],
[0.00000011925, 4.30094564154, 525.75881183150],
[0.00000009514, 2.02589667166, 206.18554843720],
[0.00000010542, 6.15533910933, 14.22709400160],
[0.00000008414, 3.92910450340, 1478.86657406440],
[0.00000008099, 4.20152809071, 1169.58825140860],
[0.00000007712, 2.99160389601, 942.06206196900],
[0.00000008825, 1.55897920307, 426.59819087600],
[0.00000008884, 4.87430124264, 1155.36115740700],
[0.00000007793, 3.84684930196, 625.67019231240],
[0.00000005646, 3.40915964493, 639.89728631400],
[0.00000004615, 0.83374662294, 117.31986822020],
[0.00000004020, 5.50502127885, 433.71173787680],
[0.00000003704, 0.90226777963, 95.97922721780],
[0.00000003859, 0.69640284662, 853.19638175200],
[0.00000003091, 5.09115860882, 1073.60902419080],
[0.00000003360, 5.10133284081, 1692.16566950240],
[0.00000002892, 4.90418916660, 220.41264243880],
[0.00000002772, 5.09066125724, 2111.65031337760],
[0.00000002425, 3.74438653232, 742.99006053260],
[0.00000002558, 5.46955948791, 1795.25844372100],
[0.00000002466, 4.22278355430, 2648.45482547300],
[0.00000001968, 0.57192251841, 309.27832265580],
[0.00000001794, 4.60765219417, 1272.68102562720],
[0.00000001822, 1.98842964323, 1375.77379984580],
[0.00000001703, 6.12660562937, 2125.87740737920],
[0.00000002011, 5.00936865256, 412.37109687440],
[0.00000001645, 0.08830372958, 1063.31408345230],
[0.00000001875, 5.81006158403, 330.61896365820],
[0.00000001741, 4.58650290431, 1574.84580128220],
[0.00000001529, 5.81660291389, 1258.45393162560],
[0.00000001916, 0.85150399517, 1368.66025284500],
[0.00000001614, 4.36839107221, 728.76296653100],
[0.00000001510, 2.79374165455, 1485.98012106520],
[0.00000001333, 4.84260898693, 1062.56332392690],
[0.00000001359, 5.16511980864, 838.96928775040],
[0.00000001165, 5.66275740881, 508.35032409220],
[0.00000001092, 4.68797557406, 1699.27921650320],
[0.00000001438, 5.78105679279, 1056.20053645150],
[0.00000001083, 3.99886917926, 1471.75302706360],
[0.00000001002, 4.79949608524, 1055.44977692610],
[0.00000000749, 6.14400862030, 519.39602435610],
[0.00000000657, 5.63765568876, 1898.35121793960],
[0.00000000702, 5.04126574492, 1685.05212250160],
[0.00000000607, 3.15707515246, 618.55664531160],
[0.00000000587, 1.37658820775, 199.07200143640],
[0.00000000552, 4.80657729450, 551.03160609700],
[0.00000000494, 4.43417307482, 539.98590583310],
[0.00000000517, 0.05161181997, 3.18139373770],
[0.00000000469, 3.81715950042, 2008.55753915900],
[0.00000000415, 1.34693184108, 1382.88734684660],
[0.00000000382, 4.86764073919, 227.52618943960],
[0.00000000473, 1.72405831407, 532.13864564940],
[0.00000000458, 4.44604993015, 1038.04128918680],
[0.00000000376, 2.23190744786, 529.64278098480],
[0.00000000451, 3.75869883836, 984.60033162190],
[0.00000000376, 5.42971857629, 529.73914920440],
[0.00000000389, 1.92698506631, 525.02509864860],
[0.00000000364, 3.35456685746, 2221.85663459700],
[0.00000000476, 5.93625415892, 527.24328453980],
[0.00000000383, 6.12255867339, 149.56319713460],
[0.00000000301, 4.09378934049, 440.82528487760],
[0.00000000310, 5.58150418981, 2428.04218303420],
[0.00000000282, 4.85996662231, 1788.14489672020],
[0.00000000298, 5.09589374634, 528.72775724810],
[0.00000000340, 4.56537070220, 750.10360753340],
[0.00000000272, 2.35346960340, 534.35683154060],
[0.00000000360, 3.91050161665, 74.78159856730],
[0.00000000299, 1.43093538841, 909.81873305460],
[0.00000000297, 2.56584512211, 530.65417294110],
[0.00000000235, 4.81644489422, 535.10759106600],
[0.00000000306, 0.68420442848, 380.12776796000],
[0.00000000236, 4.63162956792, 526.77020378780],
[0.00000000270, 0.18549916939, 21.34064100240],
[0.00000000288, 4.26655874393, 1802.37199072180],
[0.00000000196, 5.35950443033, 2214.74308759620],
[0.00000000190, 4.54615193260, 2104.53676637680],
[0.00000000193, 4.35426216497, 511.53171782990],
[0.00000000178, 4.51895208036, 3178.14579056760],
[0.00000000194, 0.57050756837, 1361.54670584420],
[0.00000000200, 1.48040474749, 302.16477565500],
[0.00000000168, 5.40141749419, 524.27433912320],
[0.00000000152, 0.68077486546, 1905.46476494040],
[0.00000000149, 1.06678990744, 831.85574074960],
[0.00000000182, 3.62401009613, 38.13303563780],
[0.00000000176, 5.64331384323, 963.40270297140],
[0.00000000184, 4.48850356629, 604.47256366190],
[0.00000000133, 5.45026366125, 2641.34127847220],
[0.00000000143, 2.21577268292, 1439.50969814920],
[0.00000000130, 4.88155705493, 2531.13495725280],
[0.00000000129, 6.15206333598, 547.85021235930],
[0.00000000133, 5.43193972385, 1603.29998928540],
[0.00000000133, 3.49297492409, 529.16970023280],
[0.00000000132, 3.98820790955, 530.21222995640],
[0.00000000118, 5.38352943814, 1891.23767093880],
[0.00000000133, 5.65694269884, 76.26607127560],
[0.00000000145, 2.94976686191, 454.90936652730],
[0.00000000115, 3.29206553804, 3.93215326310],
[0.00000000102, 4.48856749557, 2001.44399215820],
[0.00000000106, 6.08434275898, 10.29494073850],
[0.00000000093, 5.84737771840, 2324.94940881560],
[0.00000000101, 0.15815934254, 2655.56837247380],
[0.00000000115, 3.59221021604, 2015.67108615980],
[0.00000000103, 4.70399583323, 305.34616939270],
[0.00000000084, 0.44180206332, 1593.00504854690],
[0.00000000092, 2.44863388631, 490.33408917940],
[0.00000000087, 6.23817512863, 6283.07584999140],
[0.00000000095, 3.30154605532, 2317.83586181480],
[0.00000000072, 1.90578907085, 528.94020556920],
[0.00000000072, 5.57619428876, 530.44172462000],
[0.00000000078, 5.97323507836, 1585.89150154610],
], [
[0.00008094051, 1.46322843658, 529.69096509460],
[0.00000742415, 0.95691639003, 522.57741809380],
[0.00000813244, 3.14159265359, 0.00000000000],
[0.00000398951, 2.89888666447, 536.80451209540],
[0.00000342226, 1.44683789727, 1059.38193018920],
[0.00000073948, 0.40724675866, 1052.26838318840],
[0.00000046151, 3.48036895772, 1066.49547719000],
[0.00000029314, 0.99088831805, 515.46387109300],
[0.00000029717, 1.92504171329, 1589.07289528380],
[0.00000022753, 4.27124052435, 7.11354700080],
[0.00000013916, 2.92242387338, 543.91805909620],
[0.00000012067, 5.22168932482, 632.78373931320],
[0.00000010703, 4.88024222475, 949.17560896980],
[0.00000006078, 6.21089108431, 1045.15483618760],
[0.00000005935, 0.52977760072, 1581.95934828300],
[0.00000005037, 1.43444929374, 526.50957135690],
[0.00000004564, 0.91811732585, 1162.47470440780],
[0.00000004547, 4.01953745202, 1596.18644228460],
[0.00000005098, 6.03169795231, 735.87651353180],
[0.00000003593, 4.54080164408, 110.20632121940],
[0.00000003443, 1.38618954572, 533.62311835770],
[0.00000003277, 4.39650286553, 14.22709400160],
[0.00000003407, 0.42275631534, 419.48464387520],
[0.00000002904, 2.06041641723, 316.39186965660],
[0.00000002541, 3.98323842017, 323.50541665740],
[0.00000003113, 2.48079280193, 2118.76386037840],
[0.00000003061, 2.39880866911, 532.87235883230],
[0.00000002155, 4.77990637140, 942.06206196900],
[0.00000002143, 3.88727338786, 426.59819087600],
[0.00000002252, 0.37196434120, 1155.36115740700],
[0.00000002019, 3.89985000464, 846.08283475120],
[0.00000001857, 1.19658907851, 103.09277421860],
[0.00000001683, 1.42264195434, 1265.56747862640],
[0.00000002313, 0.87671613055, 213.29909543800],
[0.00000001443, 2.38565505909, 1169.58825140860],
[0.00000001823, 5.80106463776, 625.67019231240],
[0.00000001728, 2.24114678267, 525.75881183150],
[0.00000001198, 0.03252059731, 956.28915597060],
[0.00000001138, 3.46420904745, 1073.60902419080],
[0.00000001086, 5.35279146700, 117.31986822020],
[0.00000000840, 2.89946334223, 95.97922721780],
[0.00000000746, 5.53017890231, 1478.86657406440],
[0.00000000944, 4.05587053500, 206.18554843720],
[0.00000000758, 3.74770617289, 433.71173787680],
[0.00000000673, 1.26396626349, 508.35032409220],
[0.00000000889, 6.07878453176, 728.76296653100],
[0.00000000600, 1.82954494089, 639.89728631400],
[0.00000000589, 1.23625943417, 1258.45393162560],
[0.00000000619, 0.67923057477, 838.96928775040],
[0.00000000566, 5.36336098734, 742.99006053260],
[0.00000000648, 5.32990375008, 853.19638175200],
[0.00000000553, 3.15511946637, 220.41264243880],
[0.00000000432, 1.03719283016, 1692.16566950240],
[0.00000000435, 1.65056479007, 519.39602435610],
[0.00000000430, 1.41830384501, 412.37109687440],
[0.00000000431, 2.20986254651, 1368.66025284500],
[0.00000000415, 4.35372561905, 330.61896365820],
[0.00000000438, 0.16552277290, 1574.84580128220],
[0.00000000312, 4.50639455819, 2125.87740737920],
[0.00000000280, 3.01441283033, 551.03160609700],
[0.00000000309, 0.67399908949, 2111.65031337760],
[0.00000000301, 3.06868080871, 1062.56332392690],
[0.00000000236, 1.94696842200, 1485.98012106520],
[0.00000000235, 3.41850395941, 199.07200143640],
[0.00000000246, 2.61803442505, 309.27832265580],
[0.00000000238, 2.56643737684, 539.98590583310],
[0.00000000248, 2.96997778167, 2648.45482547300],
[0.00000000209, 5.82481690851, 1471.75302706360],
[0.00000000205, 1.20202002469, 1056.20053645150],
[0.00000000188, 0.97113663101, 1685.05212250160],
[0.00000000137, 2.91203499563, 1699.27921650320],
[0.00000000131, 1.79274504072, 1063.31408345230],
[0.00000000161, 1.05926568614, 1795.25844372100],
[0.00000000112, 2.62660288825, 440.82528487760],
[0.00000000110, 3.56263668146, 227.52618943960],
[0.00000000114, 6.13907482464, 1038.04128918680],
[0.00000000103, 4.64287101040, 3.18139373770],
[0.00000000123, 4.81268110532, 21.34064100240],
[0.00000000102, 4.27603827970, 1375.77379984580],
[0.00000000089, 1.22926014128, 1898.35121793960],
[0.00000000080, 0.62129648755, 831.85574074960],
], [
[0.00000251624, 3.38087923084, 529.69096509460],
[0.00000121738, 2.73311837200, 522.57741809380],
[0.00000048694, 1.03689996685, 536.80451209540],
[0.00000010988, 2.31463561347, 1052.26838318840],
[0.00000008067, 2.76729757621, 515.46387109300],
[0.00000006205, 1.78115827370, 1066.49547719000],
[0.00000007287, 4.25268318975, 1059.38193018920],
[0.00000003627, 1.13028917221, 543.91805909620],
[0.00000002798, 3.14159265359, 0.00000000000],
[0.00000001898, 2.28934054087, 7.11354700080],
[0.00000001643, 1.77507208483, 1045.15483618760],
[0.00000000945, 0.45261136388, 632.78373931320],
[0.00000000758, 0.30577920142, 949.17560896980],
[0.00000000731, 2.63748223583, 14.22709400160],
[0.00000000876, 0.32927768725, 1589.07289528380],
[0.00000000678, 2.36909615348, 1581.95934828300],
[0.00000000623, 2.48056213600, 1596.18644228460],
[0.00000000736, 1.52532370632, 735.87651353180],
[0.00000000499, 3.67985494258, 419.48464387520],
[0.00000000454, 0.26977404624, 942.06206196900],
[0.00000000453, 3.18232334886, 526.50957135690],
[0.00000000409, 2.88147337106, 110.20632121940],
[0.00000000347, 5.76244285870, 103.09277421860],
[0.00000000310, 2.98017326384, 508.35032409220],
[0.00000000321, 4.40642025933, 532.87235883230],
[0.00000000300, 1.66936571536, 625.67019231240],
[0.00000000295, 1.75924202728, 1073.60902419080],
[0.00000000282, 3.11087801399, 533.62311835770],
[0.00000000263, 0.55255030187, 426.59819087600],
[0.00000000208, 2.17540496886, 1155.36115740700],
[0.00000000183, 4.34670868038, 525.75881183150],
[0.00000000180, 6.07777744541, 639.89728631400],
[0.00000000159, 2.60843864402, 1162.47470440780],
[0.00000000117, 4.70141431381, 95.97922721780],
[0.00000000107, 5.48942805114, 433.71173787680],
[0.00000000105, 3.75192101775, 316.39186965660],
[0.00000000130, 1.37897716939, 323.50541665740],
[0.00000000094, 3.05797832024, 1265.56747862640],
[0.00000000114, 3.75170981478, 117.31986822020],
[0.00000000095, 0.54905691533, 1169.58825140860],
[0.00000000088, 3.26874502411, 213.29909543800],
[0.00000000098, 2.00704668688, 1574.84580128220],
], [
[0.00000015050, 4.52956999637, 522.57741809380],
[0.00000005370, 4.47427159142, 529.69096509460],
[0.00000004456, 5.43908581047, 536.80451209540],
[0.00000003422, 0.00000000000, 0.00000000000],
[0.00000001833, 4.51807036227, 515.46387109300],
[0.00000001322, 4.20117611581, 1052.26838318840],
[0.00000000755, 5.59451554966, 543.91805909620],
[0.00000000512, 0.05803177475, 1066.49547719000],
[0.00000000282, 3.66807771223, 1059.38193018920],
[0.00000000147, 3.56490986181, 1045.15483618760],
[0.00000000142, 5.69936472988, 7.11354700080],
[0.00000000112, 1.16718383135, 14.22709400160],
], [
[0.00000001445, 0.09198554072, 522.57741809380],
[0.00000000368, 0.00874408003, 515.46387109300],
[0.00000000304, 3.27902945138, 536.80451209540],
[0.00000000129, 0.33959775247, 529.69096509460],
[0.00000000095, 1.29305954542, 543.91805909620],
]],
('Jupiter', 'R'):[[
[5.20887429471, 0.00000000000, 0.00000000000],
[0.25209327020, 3.49108640015, 529.69096509460],
[0.00610599902, 3.84115365602, 1059.38193018920],
[0.00282029465, 2.57419879933, 632.78373931320],
[0.00187647391, 2.07590380082, 522.57741809380],
[0.00086792941, 0.71001090609, 419.48464387520],
[0.00072062869, 0.21465694745, 536.80451209540],
[0.00065517227, 5.97995850843, 316.39186965660],
[0.00029134620, 1.67759243710, 103.09277421860],
[0.00030135275, 2.16132058449, 949.17560896980],
[0.00023453209, 3.54023147303, 735.87651353180],
[0.00022283710, 4.19362773546, 1589.07289528380],
[0.00023947340, 0.27457854894, 7.11354700080],
[0.00013032600, 2.96043055741, 1162.47470440780],
[0.00009703346, 1.90669572402, 206.18554843720],
[0.00012749004, 2.71550102862, 1052.26838318840],
[0.00009161431, 4.41352618935, 213.29909543800],
[0.00007894539, 2.47907551404, 426.59819087600],
[0.00007057978, 2.18184753111, 1265.56747862640],
[0.00006137755, 6.26417542514, 846.08283475120],
[0.00005477093, 5.65729325169, 639.89728631400],
[0.00003502519, 0.56531297394, 1066.49547719000],
[0.00004136890, 2.72219979684, 625.67019231240],
[0.00004170012, 2.01605033912, 515.46387109300],
[0.00002499966, 4.55182055941, 838.96928775040],
[0.00002616955, 2.00993967129, 1581.95934828300],
[0.00001911876, 0.85621927419, 412.37109687440],
[0.00002127644, 6.12751461750, 742.99006053260],
[0.00001610549, 3.08867789275, 1368.66025284500],
[0.00001479484, 2.68026191372, 1478.86657406440],
[0.00001230708, 1.89042979701, 323.50541665740],
[0.00001216810, 1.80171561024, 110.20632121940],
[0.00000961072, 4.54876989805, 2118.76386037840],
[0.00000885708, 4.14785948471, 533.62311835770],
[0.00000776700, 3.67696954690, 728.76296653100],
[0.00000998579, 2.87208940110, 309.27832265580],
[0.00001014959, 1.38673237666, 454.90936652730],
[0.00000727162, 3.98824686402, 1155.36115740700],
[0.00000655289, 2.79065604219, 1685.05212250160],
[0.00000821465, 1.59342534396, 1898.35121793960],
[0.00000620798, 4.82284338962, 956.28915597060],
[0.00000653981, 3.38150775269, 1692.16566950240],
[0.00000812036, 5.94091899141, 909.81873305460],
[0.00000562120, 0.08095987241, 543.91805909620],
[0.00000542221, 0.28360266386, 525.75881183150],
[0.00000457859, 0.12722694510, 1375.77379984580],
[0.00000614784, 2.27624915604, 942.06206196900],
[0.00000435805, 2.60272129748, 95.97922721780],
[0.00000496066, 5.53005947761, 380.12776796000],
[0.00000469965, 2.81896276101, 1795.25844372100],
[0.00000445003, 0.14623567024, 14.22709400160],
[0.00000290869, 3.89339143564, 1471.75302706360],
[0.00000276627, 2.52238450687, 2001.44399215820],
[0.00000275084, 2.98863518924, 526.50957135690],
[0.00000293875, 2.04938438861, 199.07200143640],
[0.00000290985, 6.03131226226, 1169.58825140860],
[0.00000338342, 2.79873192583, 1045.15483618760],
[0.00000257482, 6.13395478303, 532.87235883230],
[0.00000319013, 1.34803130803, 2214.74308759620],
[0.00000309352, 5.36855804945, 1272.68102562720],
[0.00000345804, 1.56404293688, 491.55792945680],
[0.00000303364, 1.15407454372, 5753.38488489680],
[0.00000192325, 0.91996333387, 1596.18644228460],
[0.00000215398, 2.63572815848, 2111.65031337760],
[0.00000200738, 2.37259566683, 1258.45393162560],
[0.00000239036, 3.57397189838, 835.03713448730],
[0.00000197073, 5.92859096863, 453.42489381900],
[0.00000139440, 3.63960322318, 1788.14489672020],
[0.00000191373, 6.28251311870, 983.11585891360],
[0.00000176551, 2.57669991654, 9683.59458111640],
[0.00000123567, 2.26158186345, 2317.83586181480],
[0.00000128176, 4.66585907670, 831.85574074960],
[0.00000112430, 0.85604150812, 433.71173787680],
[0.00000128817, 1.10567106595, 2531.13495725280],
[0.00000099390, 4.50312054049, 518.64526483070],
[0.00000093870, 2.72553879990, 853.19638175200],
[0.00000106481, 5.81462222290, 220.41264243880],
[0.00000120188, 2.95156363556, 3.93215326310],
[0.00000104002, 2.22221906187, 74.78159856730],
[0.00000081655, 3.23481337678, 1361.54670584420],
[0.00000112513, 4.86216964016, 528.20649238630],
[0.00000079539, 0.88542246830, 430.53034413910],
[0.00000085801, 2.11458386763, 1574.84580128220],
[0.00000085685, 2.33823884827, 2428.04218303420],
[0.00000068311, 3.35727048905, 2104.53676637680],
[0.00000069570, 3.04164697156, 302.16477565500],
[0.00000069775, 3.22402404312, 305.34616939270],
[0.00000069570, 0.20494979941, 532.13864564940],
[0.00000056991, 2.00204191909, 2634.22773147140],
[0.00000077062, 2.09816000231, 508.35032409220],
[0.00000056716, 3.91743976711, 2221.85663459700],
[0.00000058325, 5.72360355252, 628.85158605010],
[0.00000052485, 4.02485010492, 527.24328453980],
[0.00000063645, 1.09973563964, 1364.72809958190],
[0.00000053607, 0.87425992614, 2847.52682690940],
[0.00000059598, 0.95822471775, 494.26624244250],
[0.00000057960, 3.45779497978, 2008.55753915900],
[0.00000041512, 3.51955526735, 529.73914920440],
[0.00000044666, 1.62313786651, 984.60033162190],
[0.00000044883, 4.90091959557, 2648.45482547300],
[0.00000053206, 1.19800364308, 760.25553592000],
[0.00000044393, 4.42623747662, 1063.31408345230],
[0.00000037566, 2.93021095213, 1677.93857550080],
[0.00000041516, 0.32174409278, 529.64278098480],
[0.00000042855, 0.03093594081, 1439.50969814920],
[0.00000045963, 2.54342106514, 636.71589257630],
[0.00000040181, 4.39381642864, 1148.24761040620],
[0.00000038770, 4.31675565025, 149.56319713460],
[0.00000040348, 2.10140891053, 2744.43405269080],
[0.00000048851, 5.60297777544, 2810.92146160520],
[0.00000037085, 5.07828164301, 1905.46476494040],
[0.00000043875, 1.24536971083, 621.73803904930],
[0.00000034005, 3.09360167248, 2420.92863603340],
[0.00000036782, 0.84232174637, 530.65417294110],
[0.00000031139, 5.35811251334, 1485.98012106520],
[0.00000039295, 4.70800489067, 569.04784100980],
[0.00000039700, 2.46163878814, 355.74874557180],
[0.00000031527, 6.19284070863, 3.18139373770],
[0.00000028399, 2.48456666067, 519.39602435610],
[0.00000032432, 2.73281750275, 604.47256366190],
[0.00000027119, 3.92341697086, 2324.94940881560],
[0.00000026753, 1.74975198417, 2950.61960112800],
[0.00000028986, 1.83535862643, 1891.23767093880],
[0.00000026493, 0.60380196895, 1055.44977692610],
[0.00000033525, 0.76068430639, 643.82943957710],
[0.00000026568, 1.03594610835, 405.25754987360],
[0.00000025534, 3.46320665375, 458.84151979040],
[0.00000024421, 0.88181836930, 423.41679713830],
[0.00000032949, 3.18597137308, 528.72775724810],
[0.00000022456, 0.43129919683, 1073.60902419080],
[0.00000021599, 1.41820425091, 540.73666535850],
[0.00000025673, 0.52358194760, 511.53171782990],
[0.00000021115, 3.08023522766, 629.60234557550],
[0.00000022713, 0.65234613144, 3163.91869656600],
[0.00000019189, 5.16589014963, 635.96513305090],
[0.00000026042, 1.33629471285, 330.61896365820],
[0.00000018263, 3.59973446951, 746.92221379570],
[0.00000018210, 2.66819439927, 1994.33044515740],
[0.00000019724, 4.13552133321, 1464.63948006280],
[0.00000019480, 1.85656428109, 3060.82592234740],
[0.00000023927, 4.99826361784, 1289.94650101460],
[0.00000021886, 5.91718683551, 1802.37199072180],
[0.00000017482, 2.82161612542, 2737.32050569000],
[0.00000016608, 5.67394889755, 408.43894361130],
[0.00000022892, 5.26731352093, 672.14061522840],
[0.00000018349, 1.89869734949, 1021.24889455140],
[0.00000019123, 3.65882402977, 415.55249061210],
[0.00000015735, 3.34772676006, 1056.20053645150],
[0.00000016373, 0.18094878053, 1699.27921650320],
[0.00000018899, 3.69120638874, 88.86568021700],
[0.00000018655, 1.97327300097, 38.13303563780],
[0.00000015542, 3.82204881010, 721.64941953020],
[0.00000016780, 1.90976657921, 217.23124870110],
[0.00000015313, 1.05907174619, 114.13847448250],
[0.00000015190, 1.32317039042, 117.31986822020],
[0.00000015080, 3.74469077216, 2641.34127847220],
[0.00000019836, 2.73184571324, 39.35687591520],
[0.00000014708, 1.67270454473, 529.16970023280],
[0.00000014036, 3.54305270022, 142.44965013380],
[0.00000012931, 1.48829749349, 3267.01147078460],
[0.00000014924, 1.32546085940, 490.33408917940],
[0.00000014753, 4.64530618027, 6283.07584999140],
[0.00000014672, 0.80451954754, 5223.69391980220],
[0.00000012085, 3.67072510553, 750.10360753340],
[0.00000011954, 2.97127390765, 505.31194270640],
[0.00000014650, 2.16792930250, 530.21222995640],
[0.00000011869, 1.66551754962, 2207.62954059540],
[0.00000012273, 0.20690014405, 1062.56332392690],
[0.00000011460, 1.11906683214, 561.93429400900],
[0.00000011083, 3.22049096074, 535.10759106600],
[0.00000011567, 5.22625628971, 524.06189080210],
[0.00000011161, 3.82945634036, 76.26607127560],
[0.00000010918, 1.27796962818, 2125.87740737920],
[0.00000012685, 3.96848605476, 2538.24850425360],
[0.00000011230, 3.23092119889, 422.66603761290],
[0.00000012645, 0.73670428580, 908.33426034630],
[0.00000011330, 5.56127247007, 531.17543780290],
[0.00000009509, 5.00507284204, 597.35901666110],
[0.00000010291, 3.84159025239, 1781.03134971940],
[0.00000010762, 4.91380719453, 525.02509864860],
[0.00000011786, 5.11863653538, 685.47393735270],
[0.00000011980, 1.72470898635, 911.30320576290],
[0.00000008937, 2.40338241992, 2310.72231481400],
[0.00000009253, 2.57670338148, 3053.71237534660],
[0.00000009488, 2.95089828501, 1382.88734684660],
[0.00000009889, 0.43758517388, 3480.31056622260],
[0.00000008781, 3.66562388594, 739.80866679490],
[0.00000008664, 2.70398612383, 526.77020378780],
[0.00000009505, 1.61249870019, 3377.21779200400],
[0.00000011540, 1.59520481029, 1474.67378837040],
[0.00000009533, 0.35468711552, 1512.80682400820],
[0.00000009980, 4.80984684596, 558.00214074590],
[0.00000009014, 1.21458362718, 416.30325013750],
[0.00000007969, 0.08480602718, 528.94020556920],
[0.00000008668, 5.29060005706, 945.24345570670],
[0.00000007851, 1.46751861875, 963.40270297140],
[0.00000008611, 1.13232641062, 532.61172640140],
[0.00000007838, 6.26933498027, 647.01083331480],
[0.00000007581, 2.90608705954, 533.88375078860],
[0.00000008583, 6.06634530166, 10213.28554621100],
[0.00000010198, 2.48743123636, 1819.63746610920],
[0.00000008536, 2.22700701790, 9153.90361602180],
[0.00000009759, 6.15593336218, 593.42686339800],
[0.00000007968, 3.75535355212, 530.44172462000],
[0.00000007142, 3.58836120327, 2957.73314812880],
[0.00000007122, 0.11970048938, 224.34479570190],
[0.00000008731, 0.75302913970, 960.22130923370],
[0.00000007063, 2.16793037690, 724.83081326790],
[0.00000007263, 2.29499675875, 520.12973753900],
[0.00000006418, 1.25058991868, 3583.40334044120],
[0.00000008270, 1.24806288317, 495.75071515080],
[0.00000006483, 4.74567772640, 202.25339517410],
[0.00000007197, 3.84169279666, 618.55664531160],
[0.00000008146, 0.73147060302, 230.56457082540],
[0.00000006165, 5.50124418381, 11.04570026390],
[0.00000007946, 2.07754951174, 953.10776223290],
[0.00000007675, 0.92400307662, 525.49817940060],
[0.00000006210, 1.45641362115, 483.22054217860],
[0.00000007359, 0.31355650764, 378.64329525170],
[0.00000006707, 2.92071167098, 1038.04128918680],
[0.00000007143, 0.18218134889, 731.94436026870],
[0.00000007309, 6.27084533477, 21.34064100240],
[0.00000006135, 2.67651237303, 312.45971639350],
[0.00000005558, 3.83419160288, 534.35683154060],
[0.00000005344, 5.25294750019, 1048.33622992530],
[0.00000007504, 0.74281415471, 457.61767951300],
[0.00000005335, 6.23059924424, 551.03160609700],
[0.00000005613, 1.51210605952, 524.27433912320],
[0.00000005284, 2.18579185671, 280.96714700450],
[0.00000005475, 5.95864753605, 539.98590583310],
[0.00000005056, 0.37387972537, 529.53090640020],
[0.00000006202, 5.53813122743, 2.44768055480],
[0.00000005490, 5.97692444199, 227.52618943960],
[0.00000006266, 0.76632858238, 938.12990870590],
[0.00000005750, 2.13496323512, 191.95845443560],
[0.00000005218, 4.69335266854, 560.71045373160],
[0.00000005480, 5.21157595558, 1057.89745748090],
[0.00000005738, 0.34249718209, 535.91074021810],
[0.00000004816, 1.51326236835, 2524.02141025200],
[0.00000005056, 3.46671669992, 529.85102378900],
[0.00000004710, 2.27813830550, 3370.10424500320],
[0.00000005228, 3.61776977584, 2097.42321937600],
[0.00000004878, 1.39829798223, 3693.60966166060],
[0.00000005727, 4.80120381106, 598.84348936940],
[0.00000005707, 3.94177950323, 2854.64037391020],
[0.00000004988, 4.87244187719, 1.48447270830],
[0.00000005424, 3.53268613904, 456.39383923560],
[0.00000004288, 4.84438067847, 70.84944530420],
[0.00000005944, 3.79180483544, 25558.21217647960],
[0.00000004195, 2.09136830994, 2627.11418447060],
[0.00000004582, 5.61707254513, 2435.15573003500],
[0.00000004268, 6.20250525415, 775.23338944700],
[0.00000004521, 0.20049967962, 92.04707395470],
[0.00000005405, 4.66492781581, 833.55266177900],
[0.00000005607, 3.30226645638, 535.32003938710],
[0.00000004171, 3.14873010832, 944.98282327580],
[0.00000004108, 5.84489743779, 440.82528487760],
[0.00000004367, 4.68363584557, 327.43756992050],
[0.00000004033, 3.30883782817, 3274.12501778540],
[0.00000004292, 0.20604269202, 3796.70243587920],
[0.00000004270, 0.98941708997, 387.24131496080],
[0.00000004259, 3.21120589971, 696.51963761660],
[0.00000004673, 1.96606729969, 107.02492748170],
[0.00000004031, 4.62854606236, 2751.54759969160],
[0.00000005115, 2.66416451377, 1215.16490244730],
[0.00000004181, 4.74527698816, 988.53248488500],
[0.00000004374, 1.50010561403, 1894.41906467650],
[0.00000003803, 3.59911687954, 437.64389113990],
[0.00000003761, 3.96903199782, 732.69511979410],
[0.00000003620, 1.57847427805, 381.61224066830],
[0.00000003490, 0.63097592112, 529.90341341570],
[0.00000004019, 2.57664165720, 916.93228005540],
[0.00000004133, 4.78417930217, 824.74219374880],
[0.00000004411, 3.13179382423, 630.33605875840],
[0.00000004099, 3.63702212253, 810.65811209910],
[0.00000003704, 6.17243801274, 537.76771994190],
[0.00000004124, 2.14248285449, 210.11770170030],
[0.00000003490, 3.20962050417, 529.47851677350],
[0.00000003281, 1.53106243317, 547.85021235930],
[0.00000003554, 6.03787799174, 739.05790726950],
[0.00000004101, 6.00406226999, 902.70518605380],
[0.00000003267, 3.49354065789, 1166.40685767090],
[0.00000003286, 2.55966870530, 945.99421523210],
[0.00000004041, 4.78735413707, 850.01498801430],
[0.00000004304, 0.11406117717, 1744.85586754190],
[0.00000004043, 5.20417093600, 635.23141986800],
[0.00000003115, 4.61986265585, 952.35700270750],
[0.00000003016, 0.95126220905, 3899.79521009780],
[0.00000003017, 2.59699501992, 632.83192342300],
[0.00000003219, 1.83594791142, 18.15924726470],
[0.00000003203, 6.12597544496, 10.29494073850],
[0.00000003220, 6.14213423140, 1158.54255114470],
[0.00000003000, 5.69509924353, 632.73555520340],
[0.00000003226, 5.59910267099, 608.40471692500],
[0.00000003118, 5.64998934505, 99.16062095550],
[0.00000003745, 2.08111521615, 282.45161971280],
[0.00000002837, 4.60175594220, 245.54242435240],
[0.00000003093, 6.02049413961, 633.74694715970],
[0.00000003120, 2.29047945342, 631.82053146670],
[0.00000002662, 3.69016679729, 885.43971066640],
[0.00000003150, 1.79784999553, 521.61421024730],
[0.00000002822, 3.14927418161, 295.05122865420],
[0.00000002615, 0.20732170653, 35.42472265210],
[0.00000002971, 1.28795094653, 1023.95720753710],
[0.00000002571, 2.01817133502, 1514.29129671650],
[0.00000002592, 0.48790221200, 195.13984817330],
[0.00000003263, 2.38820607343, 836.52160719560],
[0.00000002501, 0.21653750027, 465.95506679120],
[0.00000002451, 5.58559489768, 544.66881862160],
[0.00000002535, 1.44414086617, 460.53844081980],
[0.00000002666, 3.30350145485, 2413.81508903260],
[0.00000002412, 4.36756580310, 1056.93424963440],
[0.00000002452, 4.53818816565, 514.71311156760],
[0.00000003239, 1.17022488774, 177.87437278590],
[0.00000003218, 0.60551913257, 1061.82961074400],
[0.00000002408, 0.65423523810, 523.54062594030],
[0.00000002299, 2.15247752560, 319.57326339430],
[0.00000002791, 2.71505085086, 610.69233878540],
[0.00000002729, 1.77685979153, 252.65597135320],
[0.00000002666, 3.77750458842, 3171.03224356680],
[0.00000002303, 0.36676453766, 1969.20066324380],
[0.00000002664, 0.09674841214, 565.11568774670],
[0.00000002312, 2.07210502831, 3686.49611465980],
[0.00000002680, 4.94445888050, 1593.00504854690],
[0.00000002193, 0.55645982205, 2228.97018159780],
[0.00000002526, 1.07528597373, 12036.46073488820],
[0.00000002778, 1.48379350517, 447.79581952650],
[0.00000002235, 5.95475282699, 6151.53388830500],
[0.00000002759, 4.63976153480, 462.02291352810],
[0.00000002175, 4.53588570240, 501.37978944330],
[0.00000002323, 5.93670041006, 611.44309831080],
[0.00000002384, 2.81746622971, 3340.61242669980],
[0.00000002087, 3.10716079675, 1049.08698945070],
[0.00000001994, 2.02500860064, 1058.86066532740],
[0.00000002199, 2.20937490997, 1269.49963188950],
[0.00000002705, 1.97665276677, 415.29185818120],
[0.00000002787, 1.31053438756, 1041.22268292450],
[0.00000002003, 4.66904374443, 679.25416222920],
[0.00000001962, 1.82999730674, 2943.50605412720],
[0.00000002289, 2.96480800939, 69.15252427480],
[0.00000002192, 4.47837196209, 209.36694217490],
[0.00000002020, 0.04621364490, 4113.09430553580],
[0.00000002082, 1.11203059170, 4010.00153131720],
[0.00000001991, 3.20108648275, 3590.51688744200],
[0.00000001900, 3.32227077969, 421.93232443000],
[0.00000002193, 2.82218305362, 292.01284726840],
[0.00000002288, 1.94695631885, 1279.79457262800],
[0.00000001843, 5.23293634337, 14.97785352700],
[0.00000001932, 5.46684252030, 2281.23049651060],
[0.00000002177, 2.93031976617, 429.04587143080],
[0.00000002125, 0.06224847826, 24.37902238820],
[0.00000002464, 5.39581078430, 1261.63532536330],
[0.00000001938, 3.79908004671, 1059.43011429900],
[0.00000002029, 3.95461157815, 771.30123618390],
[0.00000001841, 4.74905354737, 78.71375183040],
[0.00000001922, 2.21862085389, 99.91138048090],
[0.00000001836, 5.75449805175, 623.22251175760],
[0.00000002145, 3.87052575546, 451.94042111070],
[0.00000001782, 0.40860352236, 754.03576079650],
[0.00000001784, 1.49468287576, 529.95159752550],
[0.00000001842, 3.49726261337, 1354.43315884340],
[0.00000001748, 3.48730020953, 522.62560220360],
[0.00000001816, 1.24334711210, 417.03696332040],
[0.00000001752, 1.15500390019, 1060.34513803570],
[0.00000001729, 2.69831073799, 642.34496686880],
[0.00000001985, 1.99916658759, 934.94851496820],
[0.00000001828, 5.44095029767, 1201.83158032300],
[0.00000002158, 3.45672748590, 827.92358748650],
[0.00000001959, 1.06033047373, 33.94024994380],
[0.00000001751, 3.13572498964, 384.05992122310],
[0.00000001781, 5.02895146997, 1098.73880610440],
[0.00000002074, 3.18582065441, 1366.21257229020],
[0.00000001757, 5.02778552877, 586.31331639720],
[0.00000002045, 3.08816627459, 535.84130424890],
[0.00000002273, 5.17998505813, 3178.14579056760],
[0.00000001617, 3.16674916201, 67.66805156650],
[0.00000001627, 6.10603469594, 432.01481684740],
[0.00000001930, 1.63968957659, 5.41662597140],
[0.00000001741, 0.99408274736, 1254.52177836250],
[0.00000001607, 5.65498642076, 1165.65609814550],
[0.00000001676, 3.06138410273, 1134.16352875650],
[0.00000001821, 3.05183555090, 567.82400073240],
[0.00000001677, 3.09175084930, 1251.34038462480],
[0.00000001994, 2.52023134712, 1059.90319505100],
[0.00000002204, 6.15376698510, 563.63121503840],
[0.00000001692, 4.19142612803, 106.27416795630],
[0.00000001906, 5.58417395051, 32.24332891440],
[0.00000002206, 1.75883974012, 1151.42900414390],
[0.00000001552, 3.04262360186, 385.54439393140],
[0.00000001508, 0.42002830727, 313.21047591890],
[0.00000001494, 1.43672345922, 2840.41327990860],
[0.00000001678, 2.17255433434, 306.83064210100],
[0.00000001511, 4.44377608685, 395.10562148700],
[0.00000001958, 0.05215107058, 761.74000862830],
[0.00000001760, 1.27045286501, 1173.52040467170],
[0.00000001463, 6.07810373103, 0.96320784650],
[0.00000001498, 2.79408561759, 277.03499374140],
[0.00000001636, 0.26199351490, 522.52923398400],
[0.00000001507, 0.48961801593, 4216.18707975440],
[0.00000001530, 3.42953827550, 1159.29331067010],
[0.00000001744, 2.39637837261, 203.00415469950],
[0.00000001569, 2.55719070621, 4.19278569400],
[0.00000001576, 3.45039607104, 1058.41872234270],
[0.00000001466, 2.24427539934, 1550.93985964600],
[0.00000001784, 2.34591354953, 529.43033266370],
[0.00000001939, 4.73685428610, 3067.93946934820],
[0.00000001938, 0.60126164334, 1059.33374607940],
[0.00000001523, 2.98744673443, 2730.20695868920],
[0.00000001834, 3.78099298791, 420.96911658350],
[0.00000001372, 3.53997115825, 5.62907429250],
[0.00000001361, 0.45533257707, 418.52143602870],
[0.00000001833, 5.12743628215, 1578.02719501990],
[0.00000001839, 4.24616044210, 981.63138620530],
[0.00000001567, 3.32429870195, 532.39927808030],
[0.00000001340, 1.94668282270, 528.41894070740],
[0.00000001422, 1.83191577465, 4002.88798431640],
[0.00000001745, 5.76913240451, 490.07345674850],
[0.00000001437, 4.19470227783, 420.44785172170],
[0.00000001419, 0.74849005330, 632.26247445140],
[0.00000001447, 5.65611888743, 373.01422095920],
[0.00000001578, 3.90273683089, 602.98809095360],
[0.00000001385, 3.88479835656, 419.43645976540],
[0.00000001352, 0.81697905853, 1585.14074202070],
[0.00000001399, 1.24785452243, 633.30500417500],
[0.00000001297, 5.57914023189, 1276.61317889030],
[0.00000001491, 1.66541781223, 2655.56837247380],
[0.00000001252, 0.72155670765, 173.94221952280],
[0.00000001658, 5.60924662850, 362.86229257260],
[0.00000001606, 3.95301396173, 2274.54683263650],
[0.00000001213, 4.55264289565, 366.79444583570],
[0.00000001521, 0.55773831071, 1592.25428902150],
[0.00000001220, 3.63029788040, 497.44763618020],
[0.00000001215, 4.42854185903, 531.38788612400],
[0.00000001549, 5.73765962068, 320.32402291970],
[0.00000001480, 4.29779032931, 303.86169668440],
[0.00000001507, 2.27998567874, 758.77106321170],
[0.00000001212, 3.38335836048, 536.85269620520],
[0.00000001245, 4.21639959154, 4.66586644600],
[0.00000001507, 3.52136655355, 774.00954916960],
[0.00000001481, 3.06156044618, 1585.89150154610],
[0.00000001462, 2.30628702634, 1363.24362687360],
[0.00000001180, 3.52708055024, 1064.79855616060],
[0.00000001193, 5.88284733845, 1060.86640289750],
[0.00000001398, 4.99456521692, 842.90144101350],
[0.00000001406, 1.53799746944, 1020.02505427400],
[0.00000001367, 4.10254739443, 799.61241183520],
[0.00000001336, 1.89387272380, 530.96298948180],
[0.00000001238, 3.62226383331, 3487.42411322340],
[0.00000001306, 3.39985119727, 539.25219265020],
[0.00000001156, 0.77127511567, 1603.29998928540],
[0.00000001482, 0.48451915093, 493.04240216510],
[0.00000001247, 5.64344659992, 479.28838891550],
[0.00000001195, 2.39909893341, 561.18353448360],
[0.00000001106, 0.89453807282, 2.92076130680],
[0.00000001227, 2.76231244946, 299.12639426920],
[0.00000001128, 4.72319873338, 124.43341522100],
[0.00000001086, 5.66180289525, 1053.75285589670],
[0.00000001329, 0.16664094530, 536.75632798560],
[0.00000001082, 4.51407359350, 528.25467649610],
[0.00000001105, 1.93890691771, 244.31858407500],
[0.00000001446, 0.65096230619, 1091.62525910360],
[0.00000001071, 4.67974963103, 521.82665856840],
[0.00000001413, 4.72936311016, 1141.13406340540],
[0.00000001086, 2.88721124443, 1262.38608488870],
[0.00000001254, 5.74156595137, 527.99404406520],
[0.00000001082, 5.60975006771, 531.12725369310],
[0.00000001148, 3.27410230525, 1035.00290780100],
[0.00000001224, 3.68807537150, 81.75213321620],
[0.00000001072, 0.48068438564, 1058.63117066380],
[0.00000001036, 1.68789163831, 1070.42763045310],
[0.00000001052, 4.72763208332, 913.75088631770],
[0.00000001166, 4.97812626679, 450.97721326420],
[0.00000001042, 2.90894542321, 3906.90875709860],
[0.00000000997, 1.65967703856, 3259.89792378380],
[0.00000001113, 3.06502453809, 1482.79872732750],
[0.00000000991, 0.91568114148, 576.16138801060],
[0.00000000987, 0.91349590742, 2332.06295581640],
[0.00000001003, 6.17381204883, 391.17346822390],
[0.00000001087, 3.19260020877, 151.04766984290],
[0.00000000987, 2.48065918834, 1912.57831194120],
[0.00000000975, 1.55458771092, 536.28324723360],
[0.00000001193, 2.19383228000, 523.09868295560],
[0.00000000979, 3.28693620660, 1379.70595310890],
[0.00000000963, 2.29845109892, 1467.82087380050],
[0.00000001279, 4.73978455573, 600.54041039880],
[0.00000001269, 1.77171706595, 5120.60114558360],
[0.00000000938, 3.13636271584, 1372.59240610810],
[0.00000000956, 0.94045126791, 429.77958461370],
[0.00000001130, 4.87259620358, 874.39401040250],
[0.00000001044, 3.52819283674, 530.58473697190],
[0.00000001244, 0.80634178279, 419.53282798500],
[0.00000000914, 4.34324212455, 1127.04998175570],
[0.00000001095, 3.17513475763, 6681.22485339960],
[0.00000000926, 5.53099018797, 537.55527162080],
[0.00000001025, 6.08315999637, 469.88722005430],
[0.00000000928, 2.64064849636, 31.01948863700],
[0.00000000887, 5.53922649066, 498.67147645760],
[0.00000001153, 5.20213407651, 554.06998748280],
[0.00000000976, 4.26047885490, 806.72595883600],
[0.00000000871, 5.79751110150, 594.65070367540],
[0.00000001044, 0.31244551729, 528.79719321730],
[0.00000000911, 0.94039205468, 337.73251065900],
[0.00000001197, 3.12884590029, 1966.23171782720],
[0.00000000930, 2.88178471518, 1056.46116888240],
[0.00000001052, 1.69484089706, 484.44438245600],
[0.00000000862, 0.67309397482, 20426.57109242200],
[0.00000001152, 1.16751621652, 1489.91227432830],
[0.00000000847, 3.25831322825, 1063.57471588320],
[0.00000000884, 0.71487680084, 2042.49778910280],
[0.00000000888, 5.38714907441, 5621.84292321040],
[0.00000001137, 4.02029739425, 1670.07426897460],
[0.00000000844, 3.31846798590, 812.14258480740],
[0.00000000860, 4.78175008217, 530.91480537200],
[0.00000000835, 3.63117401608, 451.72797278960],
[0.00000000931, 2.27352189963, 100.64509366380],
[0.00000000939, 3.51238251326, 523.47118997110],
[0.00000000860, 5.34207357904, 528.46712481720],
[0.00000000875, 0.87775537110, 4326.39340097380],
[0.00000000961, 5.69327275886, 498.19839570560],
[0.00000000966, 6.25512226434, 700.45179087970],
[0.00000000842, 3.20535945596, 1670.82502850000],
[0.00000000808, 1.09148925587, 683.18631549230],
[0.00000000810, 5.47935192896, 525.54636351040],
[0.00000000855, 6.06969867736, 446.31134681820],
[0.00000000989, 1.55623875216, 1493.09366806600],
[0.00000000837, 1.49510080792, 1025.44168024540],
[0.00000000974, 3.67667471757, 25565.32572348040],
[0.00000000788, 0.51622458293, 526.98265210890],
[0.00000000820, 1.86002542644, 629.86297800640],
[0.00000000813, 0.45441968195, 4694.00295470760],
[0.00000000953, 0.58786779132, 627.36711334180],
[0.00000000908, 2.82093327912, 3046.59882834580],
[0.00000000912, 2.69124310451, 946.72792841500],
[0.00000000820, 4.14947931572, 1884.12412393800],
[0.00000000948, 0.77931728039, 25551.09862947879],
[0.00000000844, 0.00976249584, 628.59095361920],
[0.00000000910, 0.99542530366, 5760.49843189760],
[0.00000000844, 0.22630964490, 1123.11782849260],
[0.00000000924, 4.41952345708, 5746.27133789600],
[0.00000000967, 3.20618313117, 9050.81084180320],
[0.00000000800, 0.10663079153, 4532.57894941100],
[0.00000000748, 3.01376405927, 5481.75455838080],
[0.00000000752, 5.82360472890, 701.93626358800],
[0.00000000771, 0.12101982692, 635.70450062000],
[0.00000000725, 2.81220410314, 3597.63043444280],
[0.00000000944, 0.40327408174, 1140.38330388000],
[0.00000000726, 5.28930472464, 1304.92435454160],
[0.00000000994, 5.16391370100, 10316.37832042960],
[0.00000000890, 4.10819809692, 1060.13268971460],
[0.00000000962, 1.48376004549, 1062.30269149600],
[0.00000000883, 5.26813169286, 1542.60247236780],
[0.00000000916, 6.02908368648, 7.86430652620],
[0.00000000725, 2.18773773010, 1176.70179840940],
[0.00000000808, 5.81725174908, 1087.69310584050],
[0.00000000757, 0.77440414330, 977.48678462110],
[0.00000000838, 3.81585420192, 986.08480433020],
[0.00000000888, 1.89634795578, 707.56533788050],
[0.00000000854, 5.47701506544, 2818.03500860600],
[0.00000000796, 1.08794807212, 987.30864460760],
[0.00000000856, 2.58042139486, 2803.80791460440],
[0.00000000708, 1.09492310353, 248.72381809010],
[0.00000000811, 3.23726191865, 121.25202148330],
[0.00000000727, 1.56150632966, 4319.27985397300],
[0.00000000687, 2.65457835371, 1567.73225428140],
[0.00000000675, 1.78690909614, 103.14095832840],
[0.00000000853, 4.74476428852, 951.62328952460],
[0.00000000832, 5.14362789810, 1054.71606374320],
[0.00000000846, 1.47557828604, 898.77303279070],
[0.00000000701, 1.72139817505, 5230.80746680300],
[0.00000000863, 3.98700238575, 686.95841006100],
[0.00000000703, 2.89202252444, 63.73589830340],
[0.00000000673, 6.11618580510, 738.32419408660],
[0.00000000806, 4.64475158248, 533.83556667880],
[0.00000000670, 2.67625974048, 1012.91150727320],
[0.00000000668, 4.93815253692, 5172.47623572500],
[0.00000000818, 1.41973280302, 580.09354127370],
[0.00000000652, 3.41422919445, 650.94298657790],
[0.00000000643, 2.46566726278, 1049.82070263360],
[0.00000000859, 2.50530106631, 782.34693644780],
[0.00000000662, 4.13533996643, 733.42883297700],
[0.00000000812, 1.30325352179, 1055.18914449520],
[0.00000000638, 4.21760246824, 1064.04779663520],
[0.00000000637, 6.13121700151, 4752.99159184980],
[0.00000000636, 0.83411828974, 711.49749114360],
[0.00000000642, 1.86741704507, 1053.96530421780],
[0.00000000795, 4.54081089118, 1457.52593306200],
[0.00000000783, 4.37652961667, 105.54045477340],
[0.00000000640, 5.44039474349, 632.03297978780],
[0.00000000651, 5.02431301146, 528.04643369190],
[0.00000000686, 0.27079898498, 11.77941344680],
[0.00000000644, 5.36935176134, 835.78789401270],
[0.00000000639, 1.86699974431, 6172.86952877200],
[0.00000000630, 2.86895754523, 633.53449883860],
[0.00000000826, 1.46026926041, 2199.76523406920],
[0.00000000687, 3.81221717134, 73.29712585900],
[0.00000000697, 4.18082589322, 1.69692102940],
[0.00000000788, 0.21278801649, 313.94418910180],
[0.00000000686, 2.51807576494, 638.41281360570],
[0.00000000847, 5.56263749391, 4429.48617519240],
[0.00000000673, 4.87494072856, 103.04459010880],
[0.00000000663, 4.80713895807, 991.71387862270],
[0.00000000614, 3.87231597482, 767.36908292080],
[0.00000000666, 5.71697262323, 661.09491496450],
[0.00000000681, 2.33844767741, 501.23677709140],
[0.00000000597, 3.03921014345, 6.95348830640],
[0.00000000777, 3.08786050361, 441.57604440300],
[0.00000000588, 0.08236113246, 4164.31198961300],
[0.00000000693, 4.66190836234, 3384.33133900480],
[0.00000000810, 1.97701084490, 860.30992875280],
[0.00000000602, 5.56403449542, 1587.58842257550],
[0.00000000622, 6.11554348965, 7.06536289100],
[0.00000000592, 3.29013906024, 10103.07922499160],
[0.00000000692, 6.10931942233, 12.74262129330],
[0.00000000597, 6.13204711801, 7.27360569520],
[0.00000000594, 2.58839673551, 849.26422848890],
[0.00000000728, 2.73732195088, 6.15033915430],
[0.00000000602, 5.28816527514, 949.12742486000],
[0.00000000568, 1.75508433865, 1077.54117745390],
[0.00000000575, 4.50676079721, 1230.14275597430],
[0.00000000588, 0.65827893998, 4642.78527063040],
[0.00000000561, 3.87565914360, 135.33610313300],
[0.00000000558, 3.36094471852, 24498.83024629040],
[0.00000000557, 3.45629457197, 19896.88012732740],
[0.00000000558, 1.17103892689, 3576.28979344040],
[0.00000000574, 5.19235074140, 104.05598206510],
[0.00000000560, 3.57141429379, 5333.90024102160],
[0.00000000555, 0.18349908409, 512.42548970720],
[0.00000000571, 0.83070148820, 1570.91364801910],
[0.00000000632, 3.67893818442, 1065.01100448170],
[0.00000000744, 2.33083237537, 620.25356634100],
[0.00000000540, 5.15775909675, 1751.53953141600],
[0.00000000592, 3.07238123875, 1446.62324515000],
[0.00000000537, 1.52803865425, 8094.52168583260],
[0.00000000550, 5.50701003577, 1432.39615114840],
[0.00000000546, 2.34388967045, 949.22379307960],
[0.00000000534, 3.04076654796, 7.16173111060],
[0.00000000619, 6.07865159203, 46.47042291600],
[0.00000000562, 0.96641974928, 1438.02522544090],
[0.00000000531, 1.06695547390, 100.17201291180],
[0.00000000599, 3.59295739143, 1144.31545714310],
[0.00000000526, 3.51641923371, 0.75075952540],
[0.00000000564, 0.72677136494, 1059.22187149480],
[0.00000000537, 5.72603965787, 513.22863885930],
[0.00000000630, 2.31183143900, 2729.45619916380],
[0.00000000530, 4.99510636441, 9264.10993724120],
[0.00000000649, 0.95666735852, 920.86443331850],
[0.00000000547, 1.18801926149, 11506.76976979360],
[0.00000000516, 3.28562070858, 734.91330568530],
[0.00000000567, 5.13926871155, 288.08069400530],
[0.00000000538, 0.28159637680, 153.49535039770],
[0.00000000718, 0.48326672359, 842.15068148810],
[0.00000000526, 4.39778401928, 546.15329132990],
[0.00000000695, 2.44235086902, 657.16276170140],
[0.00000000697, 4.99042365686, 12.53017297220],
[0.00000000519, 6.27847163164, 59.80374504030],
[0.00000000504, 2.58550284000, 5378.66178416220],
[0.00000000496, 2.43659402827, 990.22940591440],
[0.00000000617, 5.73284985700, 745.43774108740],
[0.00000000519, 3.10157097770, 9161.01716302260],
[0.00000000654, 1.31181453784, 878.32616366560],
[0.00000000619, 3.71554817226, 2090.30967237520],
[0.00000000500, 4.28937439066, 5216.58037280140],
[0.00000000621, 3.98893673383, 409.92341631960],
[0.00000000685, 1.95310431695, 3156.80514956520],
[0.00000000552, 2.81774132958, 344.70304530790],
[0.00000000551, 1.91969778405, 113.38771495710],
[0.00000000682, 0.87321578326, 6069.77675455340],
[0.00000000651, 5.09951064975, 531.33549649730],
[0.00000000537, 3.67357440226, 605.95703637020],
[0.00000000525, 0.74584814988, 736.83972137830],
[0.00000000505, 3.12494814307, 1475.68518032670],
[0.00000000622, 3.00013939606, 2349.32843120380],
[0.00000000644, 3.00156986335, 298.23262239190],
[0.00000000564, 3.81960833949, 1059.54198888360],
[0.00000000468, 3.50348554992, 4841.85727206680],
[0.00000000491, 1.28535573072, 247.23934538180],
[0.00000000458, 0.45056377876, 1065.60170531270],
[0.00000000543, 2.39704308320, 9690.70812811720],
[0.00000000459, 5.29870259698, 1474.93442080130],
[0.00000000483, 3.63649121244, 131.40394986990],
[0.00000000632, 2.75028345792, 334.55111692130],
[0.00000000483, 0.42979609421, 735.82832942200],
[0.00000000540, 0.54791737146, 51646.11531805379],
[0.00000000531, 0.30026207053, 912.78767847120],
[0.00000000449, 3.02583472996, 5901.23920225600],
[0.00000000544, 2.98747240952, 4223.30062675520],
[0.00000000557, 5.83542572008, 9676.48103411560],
[0.00000000501, 0.03408180117, 1080.72257119160],
[0.00000000517, 4.40400852026, 2545.36205125440],
[0.00000000481, 3.63292807076, 5584.84733259940],
[0.00000000557, 6.11443978190, 976.00231191280],
[0.00000000481, 3.41035583659, 3803.81598288000],
[0.00000000622, 2.29597570837, 9999.98645077300],
[0.00000000454, 2.88584538455, 1987.21689815660],
[0.00000000439, 4.83198101064, 50.40257617910],
[0.00000000475, 2.69994471394, 491.81856188770],
[0.00000000618, 0.72471290082, 1291.43097372290],
[0.00000000503, 0.13449993622, 2015.67108615980],
[0.00000000551, 2.13418546604, 1440.99417085750],
[0.00000000595, 3.78181802545, 6386.16862421000],
[0.00000000434, 2.64411689486, 748.40668650400],
[0.00000000592, 0.32587740408, 737.36098624010],
[0.00000000490, 2.37988828800, 2225.78878786010],
[0.00000000439, 1.33582802018, 995.64603188580],
[0.00000000543, 2.05067702505, 906.84978763800],
[0.00000000466, 2.43707405011, 3362.99069800240],
[0.00000000481, 2.32223226419, 1357.61455258110],
[0.00000000566, 0.59740900184, 350.33211960040],
[0.00000000429, 2.46287580628, 3914.02230409940],
[0.00000000429, 1.01299906509, 4333.50694797460],
[0.00000000425, 1.67255823369, 148.07872442630],
[0.00000000412, 3.29630633921, 7.32599532190],
[0.00000000508, 1.16158524676, 9.56122755560],
[0.00000000524, 5.02562926120, 1090.40141882620],
[0.00000000409, 5.80053072411, 9146.79006902100],
[0.00000000497, 0.01579913593, 1069.67687092770],
[0.00000000548, 6.03429743373, 9367.20271145980],
[0.00000000433, 5.93688350840, 1688.23351623930],
[0.00000000424, 4.18150111530, 550.13783421970],
[0.00000000401, 0.11519846139, 970.51624997220],
[0.00000000503, 5.28212300854, 668.20846196530],
[0.00000000555, 1.00328633255, 141.22580985640],
[0.00000000404, 2.48633976473, 519.65665678700],
[0.00000000441, 6.06185501734, 25.12978191360],
[0.00000000412, 5.87495245826, 6.90109867970],
[0.00000000478, 0.71264950607, 1094.80665284130],
[0.00000000446, 2.71248183031, 31.49256938900],
[0.00000000404, 5.49462012486, 447.93883187840],
[0.00000000391, 1.26105612700, 8.07675484730],
[0.00000000463, 1.93535321271, 6275.96230299060],
[0.00000000507, 3.61089992782, 546.95644048200],
[0.00000000402, 5.86200127054, 927.83496796740],
[0.00000000481, 6.21043578332, 683.98946464440],
[0.00000000483, 5.02142924458, 857.12853501510],
[0.00000000444, 0.84873092377, 1371.84164658270],
[0.00000000391, 2.81753436573, 5798.14642803740],
[0.00000000395, 0.22367886581, 51116.42435295920],
[0.00000000378, 6.03765733432, 1268.74887236410],
[0.00000000471, 6.24506463249, 946.46729598410],
[0.00000000405, 0.57785207581, 107.28555991260],
[0.00000000371, 6.15750793727, 509.24409596950],
[0.00000000370, 4.90330687618, 1436.54075273260],
[0.00000000448, 4.76565111029, 284.14854074220],
[0.00000000474, 0.71146352197, 2108.46891963990],
[0.00000000509, 5.53328407404, 1128.53445446400],
], [
[0.01271801596, 2.64937511122, 529.69096509460],
[0.00061661771, 3.00076251018, 1059.38193018920],
[0.00053443592, 3.89717644226, 522.57741809380],
[0.00031185167, 4.88276663526, 536.80451209540],
[0.00041390257, 0.00000000000, 0.00000000000],
[0.00011847190, 2.41329588176, 419.48464387520],
[0.00009166360, 4.75979408587, 7.11354700080],
[0.00003175763, 2.79297987071, 103.09277421860],
[0.00003203446, 5.21083285476, 735.87651353180],
[0.00003403605, 3.34688537997, 1589.07289528380],
[0.00002600003, 3.63435101622, 206.18554843720],
[0.00002412207, 1.46947308304, 426.59819087600],
[0.00002806064, 3.74223693580, 515.46387109300],
[0.00002676575, 4.33052878699, 1052.26838318840],
[0.00002100507, 3.92762682306, 639.89728631400],
[0.00001646182, 5.30953510947, 1066.49547719000],
[0.00001641257, 4.41628669824, 625.67019231240],
[0.00001049866, 3.16113622955, 213.29909543800],
[0.00001024802, 2.55432643018, 412.37109687440],
[0.00000740996, 2.17094630558, 1162.47470440780],
[0.00000806404, 2.67750801380, 632.78373931320],
[0.00000676928, 6.24953479790, 838.96928775040],
[0.00000468895, 4.70973463481, 543.91805909620],
[0.00000444683, 0.40281181402, 323.50541665740],
[0.00000567076, 4.57655414712, 742.99006053260],
[0.00000415894, 5.36836018215, 728.76296653100],
[0.00000484689, 2.46882793186, 949.17560896980],
[0.00000337555, 3.16781951120, 956.28915597060],
[0.00000401738, 4.60528841541, 309.27832265580],
[0.00000347378, 4.68148808722, 14.22709400160],
[0.00000260753, 5.34290306101, 846.08283475120],
[0.00000220084, 4.84210964963, 1368.66025284500],
[0.00000203217, 5.59995425432, 1155.36115740700],
[0.00000246603, 3.92313823537, 942.06206196900],
[0.00000183504, 4.26526769703, 95.97922721780],
[0.00000180134, 4.40165491159, 532.87235883230],
[0.00000197134, 3.70551461394, 2118.76386037840],
[0.00000196005, 3.75877587139, 199.07200143640],
[0.00000200190, 4.43888814441, 1045.15483618760],
[0.00000170225, 4.84647488867, 526.50957135690],
[0.00000146335, 6.12958365535, 533.62311835770],
[0.00000133483, 1.32245735855, 110.20632121940],
[0.00000132076, 4.51187950811, 525.75881183150],
[0.00000123851, 2.04290370696, 1478.86657406440],
[0.00000121861, 4.40581788491, 1169.58825140860],
[0.00000115313, 4.46741278152, 1581.95934828300],
[0.00000098527, 5.72833991647, 1596.18644228460],
[0.00000091608, 4.52965592121, 1685.05212250160],
[0.00000110638, 3.62504147403, 1272.68102562720],
[0.00000080536, 4.11311699583, 1258.45393162560],
[0.00000079552, 2.71898473954, 1692.16566950240],
[0.00000100164, 5.24693885858, 1265.56747862640],
[0.00000077854, 5.56722651753, 1471.75302706360],
[0.00000085766, 0.07906707372, 831.85574074960],
[0.00000082132, 3.80763015979, 508.35032409220],
[0.00000055319, 0.35180851191, 316.39186965660],
[0.00000052338, 5.53074272117, 433.71173787680],
[0.00000055769, 4.75141241141, 302.16477565500],
[0.00000050597, 4.85603161770, 1375.77379984580],
[0.00000043554, 4.94441642712, 1361.54670584420],
[0.00000042172, 1.22404278447, 853.19638175200],
[0.00000037695, 4.26767539209, 2001.44399215820],
[0.00000049395, 4.01422828967, 220.41264243880],
[0.00000038263, 5.33025236797, 1788.14489672020],
[0.00000035611, 1.76205571128, 1795.25844372100],
[0.00000036296, 3.84995284393, 1574.84580128220],
[0.00000029332, 5.16619257786, 3.93215326310],
[0.00000025180, 4.33777727362, 519.39602435610],
[0.00000024778, 2.72907897410, 405.25754987360],
[0.00000027025, 6.09669947903, 1148.24761040620],
[0.00000022604, 0.19173890105, 380.12776796000],
[0.00000020499, 4.32881495378, 3.18139373770],
[0.00000019925, 4.62967500111, 1677.93857550080],
[0.00000019528, 5.10596326232, 1073.60902419080],
[0.00000018427, 3.76522178300, 1485.98012106520],
[0.00000018869, 5.05259402407, 2104.53676637680],
[0.00000017031, 4.01843356903, 2317.83586181480],
[0.00000016671, 5.42931676507, 88.86568021700],
[0.00000015337, 2.92700926091, 2008.55753915900],
[0.00000014499, 3.63339836845, 628.85158605010],
[0.00000014575, 5.50832843322, 721.64941953020],
[0.00000013728, 4.87623389735, 629.60234557550],
[0.00000018481, 6.03032762264, 330.61896365820],
[0.00000013499, 1.38539534821, 518.64526483070],
[0.00000015740, 2.93038271684, 1905.46476494040],
[0.00000012459, 1.58587053146, 2111.65031337760],
[0.00000012272, 3.37671053917, 635.96513305090],
[0.00000011836, 4.08486322993, 2648.45482547300],
[0.00000011166, 4.62623267608, 636.71589257630],
[0.00000014348, 2.74177797727, 2221.85663459700],
[0.00000011221, 3.55311861205, 1891.23767093880],
[0.00000013121, 5.83845065644, 1464.63948006280],
[0.00000011351, 2.57606886230, 511.53171782990],
[0.00000010487, 0.49850799841, 453.42489381900],
[0.00000009728, 4.38837468002, 1994.33044515740],
[0.00000010131, 2.76432756215, 423.41679713830],
[0.00000008620, 5.16374493158, 1056.20053645150],
[0.00000008952, 4.79407952752, 2420.92863603340],
[0.00000008126, 3.72977106954, 2634.22773147140],
[0.00000008078, 1.29246272894, 2428.04218303420],
[0.00000008867, 1.85684753622, 750.10360753340],
[0.00000008912, 4.80973516711, 1062.56332392690],
[0.00000008552, 4.53818617984, 21.34064100240],
[0.00000009468, 4.33472161983, 1802.37199072180],
[0.00000006904, 5.96616555709, 540.73666535850],
[0.00000007293, 4.97763580465, 1699.27921650320],
[0.00000007083, 4.99096728816, 1055.44977692610],
[0.00000007226, 4.97823884383, 1898.35121793960],
[0.00000006464, 1.39173466879, 422.66603761290],
[0.00000006214, 4.46490158256, 551.03160609700],
[0.00000006794, 2.90878831415, 2324.94940881560],
[0.00000006173, 3.65617162985, 621.73803904930],
[0.00000006243, 6.13691919694, 2125.87740737920],
[0.00000005936, 2.58312235120, 569.04784100980],
[0.00000006504, 4.56908431757, 1038.04128918680],
[0.00000007305, 3.02062127734, 416.30325013750],
[0.00000006598, 5.55348005731, 1781.03134971940],
[0.00000005133, 6.21646917980, 963.40270297140],
[0.00000005876, 4.23153077453, 539.98590583310],
[0.00000005119, 0.06942832171, 1063.31408345230],
[0.00000005460, 4.91084384602, 835.03713448730],
[0.00000004989, 1.35153694680, 1382.88734684660],
[0.00000005224, 0.18468411116, 117.31986822020],
[0.00000006187, 3.87193497099, 191.95845443560],
[0.00000004681, 4.61057119508, 643.82943957710],
[0.00000004627, 3.34644534691, 2207.62954059540],
[0.00000004526, 4.07729737127, 2310.72231481400],
[0.00000004718, 4.55578336947, 2737.32050569000],
[0.00000004471, 1.47603161897, 408.43894361130],
[0.00000004073, 1.13014903180, 415.55249061210],
[0.00000005476, 5.63198569698, 618.55664531160],
[0.00000004034, 4.09631702747, 430.53034413910],
[0.00000004304, 4.60536378943, 647.01083331480],
[0.00000003765, 3.42751259825, 2950.61960112800],
[0.00000004559, 4.23723998745, 227.52618943960],
[0.00000003695, 1.03127824978, 2744.43405269080],
[0.00000003667, 4.12268925541, 440.82528487760],
[0.00000003677, 2.19480200527, 534.35683154060],
[0.00000003818, 1.14800596289, 74.78159856730],
[0.00000004221, 2.37721579949, 2538.24850425360],
[0.00000003488, 5.33792561596, 458.84151979040],
[0.00000003437, 4.26164443643, 10.29494073850],
[0.00000004394, 0.18808423412, 824.74219374880],
[0.00000003339, 4.85708402591, 295.05122865420],
[0.00000003329, 5.50043586719, 739.80866679490],
[0.00000003623, 4.64011531952, 2214.74308759620],
[0.00000003185, 2.69708590442, 561.93429400900],
[0.00000003421, 3.38512615384, 149.56319713460],
[0.00000003442, 4.34217280083, 305.34616939270],
[0.00000003580, 5.29481665335, 2097.42321937600],
[0.00000003401, 2.74761862893, 2641.34127847220],
[0.00000002901, 0.91012525424, 984.60033162190],
[0.00000003566, 1.63400343968, 525.02509864860],
[0.00000002869, 1.31799241974, 611.44309831080],
[0.00000002635, 5.25517910535, 532.13864564940],
[0.00000002683, 4.24641945773, 3053.71237534660],
[0.00000002614, 3.17862099921, 527.24328453980],
[0.00000002251, 4.21598247360, 739.05790726950],
[0.00000002268, 5.52248110560, 524.27433912320],
[0.00000002372, 4.19741177512, 217.23124870110],
[0.00000002623, 5.82647427958, 732.69511979410],
[0.00000002666, 3.92538056951, 210.11770170030],
[0.00000002036, 4.84043420813, 1049.08698945070],
[0.00000002441, 2.63840901843, 760.25553592000],
[0.00000002095, 5.76269812349, 529.64278098480],
[0.00000002021, 3.81308146017, 2627.11418447060],
[0.00000002089, 4.18463193132, 945.99421523210],
[0.00000002305, 1.61220665690, 604.47256366190],
[0.00000001969, 5.37427735384, 142.44965013380],
[0.00000001923, 4.75088270631, 535.10759106600],
[0.00000001955, 5.49000238006, 1439.50969814920],
[0.00000001877, 3.26978877187, 3267.01147078460],
[0.00000002286, 2.93885172004, 76.26607127560],
[0.00000002074, 5.85386852879, 532.61172640140],
[0.00000002121, 3.92430797099, 2435.15573003500],
[0.00000001807, 3.17208959472, 2524.02141025200],
[0.00000001712, 4.02986641257, 731.94436026870],
[0.00000002119, 0.41049593984, 1279.79457262800],
[0.00000001660, 2.34370903423, 528.72775724810],
[0.00000001655, 0.78809717175, 3060.82592234740],
[0.00000001729, 4.26127896267, 724.83081326790],
[0.00000002060, 5.04785330873, 2413.81508903260],
[0.00000002095, 2.67732367556, 529.73914920440],
[0.00000001933, 2.49162437046, 2957.73314812880],
[0.00000001898, 2.71948262975, 952.35700270750],
[0.00000001634, 2.98113068812, 945.24345570670],
[0.00000001582, 5.84373095005, 547.85021235930],
[0.00000001662, 0.27359627181, 454.90936652730],
[0.00000001595, 1.18530167095, 38.13303563780],
[0.00000001550, 0.64264572959, 312.45971639350],
[0.00000001525, 4.08789824989, 1158.54255114470],
[0.00000001542, 1.12520322326, 1021.24889455140],
[0.00000001539, 0.37324921979, 319.57326339430],
[0.00000001628, 5.24285773388, 1354.43315884340],
[0.00000001897, 3.79973291113, 953.10776223290],
[0.00000001440, 4.37872256685, 3178.14579056760],
[0.00000001439, 4.26513521887, 526.77020378780],
[0.00000001557, 5.43779802371, 81.75213321620],
[0.00000001656, 6.09667089740, 530.65417294110],
[0.00000001548, 3.48799710267, 934.94851496820],
[0.00000001772, 5.82549274759, 909.81873305460],
[0.00000001615, 1.45018725033, 902.70518605380],
[0.00000001387, 2.52840497309, 530.44172462000],
[0.00000001574, 1.89565809136, 437.64389113990],
[0.00000001459, 3.32546061506, 1041.22268292450],
[0.00000001377, 0.10015418633, 490.33408917940],
[0.00000001460, 4.00706825185, 3370.10424500320],
[0.00000001605, 4.27993020192, 2531.13495725280],
[0.00000001707, 6.28253681644, 18.15924726470],
[0.00000001802, 2.23019296374, 2854.64037391020],
[0.00000001390, 3.76737324192, 1165.65609814550],
[0.00000001498, 0.17285954362, 1141.13406340540],
[0.00000001401, 4.81225317549, 1251.34038462480],
[0.00000001244, 2.83383980283, 124.43341522100],
[0.00000001320, 5.80675430384, 387.24131496080],
[0.00000001329, 0.88314574243, 916.93228005540],
[0.00000001558, 6.17808619637, 983.11585891360],
[0.00000001243, 0.29239666059, 597.35901666110],
[0.00000001541, 3.51095241498, 2751.54759969160],
[0.00000001482, 0.83066678204, 529.16970023280],
[0.00000001149, 3.91142023857, 99.91138048090],
[0.00000001114, 3.53339637290, 483.22054217860],
[0.00000001195, 4.16301075999, 203.00415469950],
[0.00000001100, 1.74769285223, 497.44763618020],
[0.00000001458, 5.19315120878, 1592.25428902150],
[0.00000001123, 1.45270581179, 533.88375078860],
[0.00000001078, 5.23991792940, 1159.29331067010],
[0.00000001083, 3.57026506855, 2943.50605412720],
[0.00000001072, 0.07132659992, 1070.42763045310],
[0.00000001037, 5.48955598976, 1585.89150154610],
[0.00000001343, 0.29600445633, 860.30992875280],
[0.00000001361, 3.46603373194, 107.02492748170],
[0.00000001061, 2.44580706826, 1048.33622992530],
[0.00000001002, 5.55216117410, 337.73251065900],
[0.00000000981, 3.15500987023, 70.84944530420],
[0.00000001007, 4.11504050436, 501.23677709140],
[0.00000000965, 5.63719524421, 1603.29998928540],
[0.00000001083, 4.88373909810, 1166.40685767090],
[0.00000000953, 2.83352026342, 3583.40334044120],
[0.00000001060, 3.18542176646, 447.79581952650],
[0.00000001136, 2.26568590950, 525.49817940060],
[0.00000001191, 2.25249961404, 106.27416795630],
[0.00000000884, 4.69777781327, 960.22130923370],
[0.00000001165, 1.56030440737, 630.33605875840],
[0.00000000947, 0.50856414717, 842.90144101350],
[0.00000001011, 0.30814674949, 1593.00504854690],
[0.00000000924, 2.31939900786, 327.43756992050],
[0.00000000896, 0.22222521202, 746.92221379570],
[0.00000001078, 4.78329116086, 2730.20695868920],
[0.00000000938, 5.42471506763, 1585.14074202070],
[0.00000000923, 4.44469169065, 9676.48103411560],
[0.00000000894, 0.26940821870, 2655.56837247380],
[0.00000001131, 5.46382510304, 224.34479570190],
[0.00000000808, 0.48295590141, 3377.21779200400],
[0.00000000809, 4.14122746067, 114.13847448250],
[0.00000000864, 1.83217006136, 4.66586644600],
[0.00000001106, 2.60444312553, 209.36694217490],
[0.00000000790, 0.11493626208, 460.53844081980],
[0.00000000799, 1.60426497590, 5223.69391980220],
[0.00000000933, 0.30976125598, 685.47393735270],
[0.00000001053, 5.23433104008, 842.15068148810],
[0.00000000846, 3.02878393490, 5746.27133789600],
[0.00000000799, 2.08457026425, 77734.01845962799],
[0.00000000820, 0.99821486743, 373.01422095920],
[0.00000000892, 5.36446426391, 827.92358748650],
[0.00000000821, 3.53889274951, 498.67147645760],
[0.00000000741, 1.32379374647, 530.21222995640],
[0.00000000790, 2.88034567513, 938.12990870590],
[0.00000000842, 3.39449778904, 484.44438245600],
[0.00000000785, 0.57841470897, 850.01498801430],
[0.00000000759, 3.82014112009, 6283.07584999140],
[0.00000000954, 2.94534072982, 462.02291352810],
[0.00000000767, 3.33725133157, 99.16062095550],
[0.00000000810, 4.69425300466, 2228.97018159780],
[0.00000000700, 1.72050221502, 775.23338944700],
[0.00000000764, 4.91747674296, 1670.82502850000],
[0.00000000724, 6.08692841992, 2281.23049651060],
[0.00000000711, 4.82250918143, 11.77941344680],
[0.00000000692, 2.63705354662, 6.59228213900],
[0.00000000771, 3.87410612014, 9690.70812811720],
[0.00000000906, 2.47189948442, 3274.12501778540],
[0.00000000781, 1.25357484582, 202.25339517410],
[0.00000000757, 3.78079814332, 2818.03500860600],
[0.00000000756, 4.28312053897, 2803.80791460440],
[0.00000000663, 5.27704405712, 4532.57894941100],
[0.00000000759, 5.45358686570, 9683.59458111640],
[0.00000000698, 5.43712520216, 565.11568774670],
[0.00000000709, 3.71117647887, 3686.49611465980],
[0.00000000677, 4.27891183416, 25028.52121138500],
[0.00000000643, 1.40239510103, 9161.01716302260],
[0.00000000656, 0.60909845504, 835.78789401270],
[0.00000000635, 5.75373871128, 429.77958461370],
[0.00000000702, 6.10412979847, 4635.67172362960],
[0.00000000627, 3.03666956129, 2840.41327990860],
[0.00000000802, 4.18688054701, 5753.38488489680],
[0.00000000838, 4.51386507097, 1069.67687092770],
[0.00000000633, 4.37183361444, 5.41662597140],
[0.00000000652, 5.79409889124, 1061.82961074400],
[0.00000000638, 2.18896270346, 313.21047591890],
[0.00000000827, 5.94231186039, 1457.52593306200],
[0.00000000678, 2.45013730979, 5760.49843189760],
[0.00000000814, 4.89578791170, 1567.73225428140],
[0.00000000624, 0.61631100566, 1176.70179840940],
[0.00000000600, 3.20918322285, 1098.73880610440],
[0.00000000717, 1.82349064490, 3171.03224356680],
[0.00000000651, 4.14419317491, 2847.52682690940],
[0.00000000629, 1.75272560843, 92.04707395470],
[0.00000000626, 3.53146082217, 3067.93946934820],
[0.00000000667, 4.22974611158, 4539.69249641180],
[0.00000000565, 0.99416346033, 1894.41906467650],
[0.00000000752, 0.46063700150, 635.23141986800],
[0.00000000622, 1.98136818407, 25565.32572348040],
[0.00000000614, 2.48275371627, 25551.09862947879],
[0.00000000560, 1.40733893388, 446.31134681820],
[0.00000000558, 4.37217796469, 1057.89745748090],
[0.00000000628, 4.65037810102, 6275.96230299060],
[0.00000000659, 2.41470950463, 195.13984817330],
[0.00000000616, 2.08837621877, 10.03430830760],
[0.00000000692, 3.13229025530, 7.63481186260],
[0.00000000685, 4.18539472904, 46.47042291600],
[0.00000000624, 0.02693303471, 1493.09366806600],
[0.00000000594, 2.13375704438, 121.25202148330],
[0.00000000508, 2.13584300710, 1.69692102940],
[0.00000000674, 1.47570122611, 4694.00295470760],
[0.00000000559, 4.48852017557, 531.17543780290],
[0.00000000640, 3.10239233469, 11.04570026390],
[0.00000000496, 1.29000001439, 927.83496796740],
[0.00000000587, 3.30651435298, 600.54041039880],
[0.00000000582, 0.44540948860, 113.38771495710],
[0.00000000492, 4.83275232000, 9492.14631500480],
[0.00000000549, 4.34579166146, 3046.59882834580],
[0.00000000576, 1.22846846364, 1514.29129671650],
[0.00000000593, 5.86079640612, 524.06189080210],
[0.00000000510, 2.62557031270, 529.85102378900],
[0.00000000489, 6.26855707323, 3693.60966166060],
[0.00000000480, 0.30754294369, 528.94020556920],
[0.00000000582, 3.51934668795, 1056.93424963440],
[0.00000000493, 5.52699906925, 512.28247735530],
[0.00000000481, 2.99681040149, 9153.90361602180],
[0.00000000562, 3.73437025868, 2015.67108615980],
[0.00000000458, 3.86646994292, 11.30633269480],
[0.00000000457, 1.80238019931, 3281.23856478620],
[0.00000000453, 6.17995938655, 1059.33374607940],
[0.00000000551, 0.13794958618, 1912.57831194120],
[0.00000000446, 5.53828660924, 2332.06295581640],
[0.00000000444, 5.06219342598, 7.86430652620],
[0.00000000461, 0.16951411708, 26087.90314157420],
[0.00000000439, 4.14986379679, 1151.42900414390],
[0.00000000614, 5.42289673768, 2090.30967237520],
[0.00000000488, 3.71681959056, 447.93883187840],
[0.00000000592, 2.91424148255, 8624.21265092720],
[0.00000000433, 2.55336268329, 1064.04779663520],
[0.00000000449, 5.24955106938, 10213.28554621100],
[0.00000000510, 5.81591864532, 529.53090640020],
[0.00000000435, 5.34355963629, 560.71045373160],
[0.00000000449, 0.72330388784, 2758.66114669240],
[0.00000000430, 0.94519103478, 6.36278747540],
[0.00000000563, 6.19175228344, 1884.12412393800],
[0.00000000443, 3.39246520261, 1152.17976366930],
[0.00000000430, 1.28652623263, 505.31194270640],
[0.00000000422, 5.12631540623, 944.98282327580],
[0.00000000464, 2.90444584145, 398.14400287280],
[0.00000000410, 1.24248975309, 5069.38346150640],
[0.00000000411, 2.95117124177, 4326.39340097380],
[0.00000000418, 5.15499986314, 1173.52040467170],
[0.00000000412, 2.98125446330, 554.06998748280],
[0.00000000403, 0.34381388674, 32.24332891440],
[0.00000000402, 5.88926765351, 1570.91364801910],
[0.00000000505, 1.49028912471, 3782.47534187760],
[0.00000000447, 0.03952029309, 245.54242435240],
[0.00000000453, 3.09458004153, 1059.43011429900],
[0.00000000411, 3.21727542472, 1475.68518032670],
[0.00000000426, 3.12237794195, 12566.15169998280],
[0.00000000434, 3.59362426939, 3259.89792378380],
[0.00000000398, 4.91510709622, 4120.20785253660],
[0.00000000399, 4.67075122011, 234.63973644040],
[0.00000000386, 4.81320787761, 970.51624997220],
[0.00000000427, 3.21176085113, 977.48678462110],
[0.00000000411, 4.31566962034, 757.21715453420],
[0.00000000392, 1.86527946688, 885.43971066640],
[0.00000000416, 3.81408093105, 3156.80514956520],
], [
[0.00079644833, 1.35865896596, 529.69096509460],
[0.00008251618, 5.77773935444, 522.57741809380],
[0.00007029864, 3.27476965833, 536.80451209540],
[0.00005314006, 1.83835109712, 1059.38193018920],
[0.00001860833, 2.97682139367, 7.11354700080],
[0.00000836267, 4.19889881718, 419.48464387520],
[0.00000964466, 5.48031822015, 515.46387109300],
[0.00000406453, 3.78250730354, 1066.49547719000],
[0.00000426570, 2.22753101795, 639.89728631400],
[0.00000377316, 2.24248352873, 1589.07289528380],
[0.00000497920, 3.14159265359, 0.00000000000],
[0.00000339043, 6.12690864038, 625.67019231240],
[0.00000362943, 5.36761847267, 206.18554843720],
[0.00000342048, 6.09922969324, 1052.26838318840],
[0.00000279920, 4.26162555827, 412.37109687440],
[0.00000332578, 0.00328961161, 426.59819087600],
[0.00000229777, 0.70530766213, 735.87651353180],
[0.00000200783, 3.06850623368, 543.91805909620],
[0.00000199807, 4.42884165317, 103.09277421860],
[0.00000257290, 0.96295364983, 632.78373931320],
[0.00000138606, 2.93235671606, 14.22709400160],
[0.00000113535, 0.78713911289, 728.76296653100],
[0.00000086025, 5.14434751994, 323.50541665740],
[0.00000094565, 1.70498041073, 838.96928775040],
[0.00000083469, 0.05834873484, 309.27832265580],
[0.00000075198, 1.60495195911, 956.28915597060],
[0.00000070451, 1.50988357484, 213.29909543800],
[0.00000080328, 2.98122361797, 742.99006053260],
[0.00000056203, 0.95534810533, 1162.47470440780],
[0.00000061649, 6.10137889854, 1045.15483618760],
[0.00000066572, 5.47307178077, 199.07200143640],
[0.00000050057, 2.72063162317, 532.87235883230],
[0.00000051904, 5.58435625607, 942.06206196900],
[0.00000039833, 5.94566506227, 95.97922721780],
[0.00000044548, 5.52445621411, 508.35032409220],
[0.00000044282, 0.27118152557, 526.50957135690],
[0.00000029944, 0.93641735919, 1155.36115740700],
[0.00000028412, 2.87835720211, 525.75881183150],
[0.00000026330, 4.26891877269, 1596.18644228460],
[0.00000027039, 2.80607741398, 1169.58825140860],
[0.00000027477, 2.64841266238, 2118.76386037840],
[0.00000022705, 0.17830004133, 302.16477565500],
[0.00000029347, 1.78589692350, 831.85574074960],
[0.00000019991, 0.04328951895, 949.17560896980],
[0.00000019906, 1.16072627347, 533.62311835770],
[0.00000021714, 1.88820231818, 1272.68102562720],
[0.00000017581, 4.14974757919, 846.08283475120],
[0.00000017085, 5.89188996975, 1258.45393162560],
[0.00000021407, 4.35468497204, 316.39186965660],
[0.00000021295, 0.54429472455, 1265.56747862640],
[0.00000019859, 0.06453825800, 1581.95934828300],
[0.00000017025, 0.53383755278, 1368.66025284500],
[0.00000012804, 3.90044242142, 433.71173787680],
[0.00000013072, 0.79468040717, 110.20632121940],
[0.00000011945, 0.40671403646, 1361.54670584420],
[0.00000011695, 4.44394618065, 405.25754987360],
[0.00000011979, 2.22872778682, 220.41264243880],
[0.00000009633, 6.01002272123, 853.19638175200],
[0.00000010163, 0.99504635158, 1471.75302706360],
[0.00000008977, 1.60328709409, 1692.16566950240],
[0.00000008701, 3.52167876799, 1073.60902419080],
[0.00000008314, 5.60169732564, 1574.84580128220],
[0.00000008958, 6.26708748901, 519.39602435610],
[0.00000007828, 0.65241611799, 1478.86657406440],
[0.00000007833, 0.17920601344, 1685.05212250160],
[0.00000007451, 0.88421084942, 88.86568021700],
[0.00000007320, 0.89341249264, 721.64941953020],
[0.00000009135, 1.51210840939, 1148.24761040620],
[0.00000006110, 2.50080005128, 3.18139373770],
[0.00000007037, 4.44127496638, 330.61896365820],
[0.00000005163, 2.79219166952, 21.34064100240],
[0.00000005079, 2.97991736844, 1375.77379984580],
[0.00000004930, 0.04683167622, 1677.93857550080],
[0.00000004664, 2.28007273876, 1485.98012106520],
[0.00000004692, 0.86220230505, 3.93215326310],
[0.00000005307, 0.85008578245, 1788.14489672020],
[0.00000004239, 0.40758287124, 629.60234557550],
[0.00000004230, 1.61046658091, 635.96513305090],
[0.00000003627, 2.71151441113, 551.03160609700],
[0.00000003314, 0.55067236587, 1795.25844372100],
[0.00000004409, 1.28127751050, 1464.63948006280],
[0.00000003270, 1.18744032691, 1905.46476494040],
[0.00000003226, 6.18716071251, 1038.04128918680],
[0.00000003103, 6.22971614425, 2001.44399215820],
[0.00000003410, 2.44624067925, 539.98590583310],
[0.00000003174, 5.54870592599, 191.95845443560],
[0.00000002590, 3.24430559059, 1062.56332392690],
[0.00000002614, 0.55149554149, 2104.53676637680],
[0.00000002174, 5.32613824409, 1891.23767093880],
[0.00000002659, 4.82459974220, 416.30325013750],
[0.00000002187, 1.71707514653, 628.85158605010],
[0.00000002263, 6.19233486371, 1994.33044515740],
[0.00000002328, 4.28236795066, 963.40270297140],
[0.00000002579, 0.03256542251, 1898.35121793960],
[0.00000002077, 3.32602157426, 1699.27921650320],
[0.00000002529, 2.39697505835, 227.52618943960],
[0.00000002468, 0.06551346218, 750.10360753340],
[0.00000001989, 0.29206371261, 636.71589257630],
[0.00000001927, 0.32286661566, 295.05122865420],
[0.00000001904, 3.43534792123, 647.01083331480],
[0.00000001940, 0.29170673525, 2111.65031337760],
[0.00000001880, 3.14403615586, 611.44309831080],
[0.00000002324, 1.94960720763, 824.74219374880],
[0.00000001854, 4.71794950485, 2125.87740737920],
[0.00000002547, 1.23908353090, 2221.85663459700],
[0.00000001814, 1.60250861074, 2008.55753915900],
[0.00000001611, 5.83466560322, 422.66603761290],
[0.00000001667, 2.32455940876, 440.82528487760],
[0.00000001622, 0.36650974375, 1056.20053645150],
[0.00000001624, 2.42139677881, 10.29494073850],
[0.00000001622, 3.51892791175, 1055.44977692610],
[0.00000001606, 5.76205763975, 117.31986822020],
[0.00000001646, 5.88662636573, 2317.83586181480],
[0.00000002026, 4.61781314145, 423.41679713830],
[0.00000002098, 1.04559231028, 1781.03134971940],
[0.00000001868, 1.12487729469, 618.55664531160],
[0.00000001885, 2.78775930564, 1802.37199072180],
[0.00000001445, 0.08308050305, 1382.88734684660],
[0.00000001797, 3.00776822706, 2648.45482547300],
[0.00000001422, 0.17649746278, 2420.92863603340],
[0.00000001129, 1.59030291320, 380.12776796000],
[0.00000001126, 4.19989673600, 547.85021235930],
[0.00000001186, 5.98943062173, 2310.72231481400],
[0.00000001108, 4.22655117757, 934.94851496820],
[0.00000001259, 1.19687222266, 1063.31408345230],
[0.00000001072, 3.86169004168, 1603.29998928540],
[0.00000000946, 5.59968097387, 99.91138048090],
[0.00000000937, 1.03083276760, 81.75213321620],
[0.00000000938, 6.18136092771, 945.99421523210],
[0.00000000908, 2.54355964041, 6283.07584999140],
[0.00000000874, 5.21903196047, 2207.62954059540],
[0.00000000874, 6.01240284465, 511.53171782990],
[0.00000001188, 0.75698357968, 2097.42321937600],
[0.00000000789, 3.91035208173, 10213.28554621100],
[0.00000001000, 1.34667100304, 732.69511979410],
[0.00000000952, 1.55355777420, 2324.94940881560],
[0.00000000811, 5.00475553271, 319.57326339430],
[0.00000000763, 3.98527559630, 337.73251065900],
[0.00000000880, 1.14789972199, 952.35700270750],
[0.00000000780, 4.69463316930, 5746.27133789600],
[0.00000000910, 0.08774541571, 2737.32050569000],
[0.00000000773, 0.77131695762, 5760.49843189760],
[0.00000000764, 6.11686539353, 9676.48103411560],
[0.00000000758, 2.19350719860, 9690.70812811720],
[0.00000000671, 1.19532387143, 124.43341522100],
[0.00000000661, 5.99578306627, 501.23677709140],
[0.00000000729, 0.65312263578, 2538.24850425360],
[0.00000000825, 2.70770030205, 3370.10424500320],
[0.00000000670, 5.44169923277, 107.02492748170],
[0.00000000739, 1.14609907817, 2641.34127847220],
[0.00000000866, 3.02831268213, 3046.59882834580],
[0.00000000718, 4.83684196454, 860.30992875280],
[0.00000000813, 6.01229270247, 2214.74308759620],
[0.00000000746, 1.12371143332, 739.80866679490],
[0.00000000741, 5.93171662010, 2634.22773147140],
[0.00000000667, 0.89885058003, 106.27416795630],
[0.00000000573, 2.42701822581, 739.05790726950],
[0.00000000734, 0.72837704619, 1354.43315884340],
[0.00000000662, 2.21768976390, 2015.67108615980],
[0.00000000782, 2.52401202862, 3679.38256765900],
[0.00000000779, 2.38608991574, 3267.01147078460],
[0.00000000553, 1.85211127676, 453.42489381900],
[0.00000000701, 4.23431087374, 9683.59458111640],
[0.00000000571, 2.98435419019, 1262.38608488870],
[0.00000000621, 1.24462887440, 3803.81598288000],
[0.00000000563, 5.99845316446, 1049.08698945070],
[0.00000000538, 4.92334194042, 447.79581952650],
[0.00000000534, 0.99911551571, 462.02291352810],
[0.00000000541, 6.19275150397, 1987.21689815660],
[0.00000000511, 3.28553278370, 4.66586644600],
[0.00000000539, 5.33214565622, 2751.54759969160],
[0.00000000651, 5.12199308959, 3156.80514956520],
[0.00000000483, 3.03782387056, 3281.23856478620],
[0.00000000476, 2.17592053936, 149.56319713460],
[0.00000000510, 5.35664230912, 9.56122755560],
[0.00000000490, 1.57324553106, 1251.34038462480],
[0.00000000467, 5.92343423840, 203.00415469950],
[0.00000000528, 5.81786945766, 2627.11418447060],
[0.00000000447, 3.51498961805, 18.15924726470],
[0.00000000429, 0.16627197188, 74.78159856730],
[0.00000000497, 0.30985248432, 2428.04218303420],
[0.00000000516, 3.89424540015, 2516.90786325120],
[0.00000000519, 2.43126348834, 3686.49611465980],
[0.00000000404, 2.77840802846, 7.16173111060],
[0.00000000533, 4.77083438961, 3473.19701922180],
[0.00000000515, 3.54549816613, 3178.14579056760],
[0.00000000533, 5.61415688189, 2524.02141025200],
[0.00000000458, 4.91616403047, 3067.93946934820],
[0.00000000400, 3.13887720912, 540.73666535850],
[0.00000000378, 0.86122450940, 525.02509864860],
], [
[0.00003519257, 6.05800633846, 529.69096509460],
[0.00001073239, 1.67321345760, 536.80451209540],
[0.00000915666, 1.41329676116, 522.57741809380],
[0.00000341593, 0.52296542656, 1059.38193018920],
[0.00000254893, 1.19625473533, 7.11354700080],
[0.00000221512, 0.95225226237, 515.46387109300],
[0.00000069078, 2.26885282314, 1066.49547719000],
[0.00000089729, 3.14159265359, 0.00000000000],
[0.00000057827, 1.41389745339, 543.91805909620],
[0.00000057653, 0.52580117593, 639.89728631400],
[0.00000051079, 5.98016364677, 412.37109687440],
[0.00000046935, 1.57864237959, 625.67019231240],
[0.00000042824, 6.11689609099, 419.48464387520],
[0.00000037477, 1.18262762330, 14.22709400160],
[0.00000033816, 1.66671706951, 1052.26838318840],
[0.00000031195, 1.04290245896, 1589.07289528380],
[0.00000030023, 4.63236245032, 426.59819087600],
[0.00000033531, 0.84784977903, 206.18554843720],
[0.00000020804, 2.50071243814, 728.76296653100],
[0.00000014466, 0.96040197071, 508.35032409220],
[0.00000012969, 1.50233788550, 1045.15483618760],
[0.00000011654, 3.55513510121, 323.50541665740],
[0.00000012319, 2.60952614503, 735.87651353180],
[0.00000015023, 0.89136998434, 199.07200143640],
[0.00000011160, 1.79041437555, 309.27832265580],
[0.00000010554, 6.27845112678, 956.28915597060],
[0.00000009812, 6.26016859519, 103.09277421860],
[0.00000009301, 3.45126812476, 838.96928775040],
[0.00000006672, 1.87004905364, 302.16477565500],
[0.00000007442, 1.28047007623, 742.99006053260],
[0.00000007178, 0.92022189637, 942.06206196900],
[0.00000005577, 1.37980792905, 95.97922721780],
[0.00000006834, 3.45228722967, 831.85574074960],
[0.00000004632, 2.82934545414, 1596.18644228460],
[0.00000003969, 1.21290005054, 1169.58825140860],
[0.00000003869, 5.99495313698, 213.29909543800],
[0.00000003551, 6.10714791535, 405.25754987360],
[0.00000002943, 2.32831075458, 1155.36115740700],
[0.00000002442, 1.86965213405, 532.87235883230],
[0.00000002410, 0.42627205128, 220.41264243880],
[0.00000002289, 1.94941487274, 1073.60902419080],
[0.00000002274, 0.09211517505, 632.78373931320],
[0.00000002189, 1.58907745204, 2118.76386037840],
[0.00000002387, 5.97080671477, 1162.47470440780],
[0.00000002104, 1.06751462671, 21.34064100240],
[0.00000002128, 1.51119399925, 1258.45393162560],
[0.00000002491, 0.35125020737, 1272.68102562720],
[0.00000002006, 5.94487388360, 110.20632121940],
[0.00000001980, 2.54989377864, 88.86568021700],
[0.00000002040, 2.16463966964, 433.71173787680],
[0.00000001955, 2.70341589777, 721.64941953020],
[0.00000001670, 4.46255717328, 853.19638175200],
[0.00000001910, 2.25964760758, 1361.54670584420],
[0.00000001710, 1.98372066321, 525.75881183150],
[0.00000001520, 0.11641358425, 949.17560896980],
[0.00000002003, 3.16520599208, 1148.24761040620],
[0.00000001710, 2.70850417287, 330.61896365820],
[0.00000001629, 0.47376028854, 526.50957135690],
[0.00000001229, 3.01987279595, 963.40270297140],
[0.00000001671, 0.44352103086, 533.62311835770],
[0.00000001207, 1.15774089269, 1574.84580128220],
[0.00000001146, 2.54505851138, 846.08283475120],
[0.00000001355, 1.17462112647, 1038.04128918680],
[0.00000001001, 2.70272799283, 519.39602435610],
[0.00000001372, 0.67467128629, 551.03160609700],
[0.00000000983, 4.17198081351, 2627.11418447060],
[0.00000001084, 1.07011164067, 227.52618943960],
[0.00000000892, 2.92543286761, 1368.66025284500],
[0.00000000823, 4.86559196955, 611.44309831080],
[0.00000001136, 1.78981738432, 1581.95934828300],
[0.00000000897, 4.91073630270, 1670.82502850000],
[0.00000000908, 3.68804047330, 824.74219374880],
[0.00000000789, 3.23380893250, 2125.87740737920],
[0.00000000771, 2.39070707004, 2317.83586181480],
[0.00000000891, 0.59692950778, 539.98590583310],
[0.00000000876, 4.52127091462, 750.10360753340],
[0.00000000802, 0.20759322884, 1141.13406340540],
[0.00000000850, 0.94145487094, 191.95845443560],
[0.00000000762, 2.25149516048, 2538.24850425360],
[0.00000000694, 0.67080348659, 440.82528487760],
[0.00000000741, 5.799